      _X  ':たいちょう12345            SmileBoom                                y          '
' FMPETIT SYNTHESIZER for プチコン4
'
' Ver.1.01 2015/09/18
' Ver.2.00 2019/05/15
'
' (C)2015-2019 SmileBoom
'

CONST #KEYCNT_W=16
CONST #MAX_NOTE=8

CONST #SP_LOGO=20
CONST #SP_KEY_W_TOP=100
CONST #SP_KEY_B_TOP=#SP_KEY_W_TOP+#KEYCNT_W
CONST #SP_KEYH_W_TOP=#SP_KEY_B_TOP+#KEYCNT_W
CONST #SP_KEYH_B_TOP=#SP_KEYH_W_TOP+#KEYCNT_W
CONST #SP_SHADOW=#SP_KEYH_B_TOP+#KEYCNT_W

CONST #SPD_KEY_W=90
CONST #SPD_KEY_B=91
CONST #SPD_KEYH_W=92
CONST #SPD_KEYH_B=93


XCTRLSTYLE 0

VAR PV[15]  'パラメーター
VAR PS$[15] 'パラメーター せつめい
'けんばん じょうほう(0:XMIN 1:XMAX 2:NOTE)
VAR KBD_PW[#KEYCNT_W,3] 'はっけん
VAR KBD_PB[#KEYCNT_W,3] 'こっけん
VAR KBD_STAT[#MAX_NOTE]
VAR KBD_KEY[#MAX_NOTE]
VAR KBD_BLK[#MAX_NOTE]

'ノブ
VAR KNOB_POS[15,2]
VAR KNOB_DLG
VAR KNOB_DLGP[2]
VAR KNOB_DLGV
VAR KNOB_DLGX
VAR KNOB_DLGS

'トイコン
VAR TOYCON=0
VAR KNOB_TYPE=0
VAR KNOB_ROT
VAR KNOB_CATEGORY=-1

'はけいデータ
VAR WVRES=4     '0-5 0:こうそく 5:こうおんしつ
VAR WVL=POW(2,6+WVRES) '1しゅうき の サンプルすう
VAR WV[WVL+1]   '-1..+1 じっすう
VAR WVI%[WVL+1] '-&H8000..&H7FFF 16ビット せいすう
'アルゴリズム
VAR ALG '1..4
'ビブラート もじれつ
VAR VIB$
'トランスポーズ
VAR TRS
'デチューン
VAR DTN
VAR DT1$
VAR DT2$

'=============
'パネル びょうが
'=============
DEF PANEL X,Y,W,H
 'HAIRLINE
 FOR I=0 TO H
  R=RND(15)+150-I/2
  X0=0
  X1=X0+RND(5)+1
  X2=X+W
  Y0=Y+I
  WHILE X0 < X2
   GLINE X0,Y0,X1,Y0,RGB(R,R,R)
   DEC R,0.5
   X0=X1+1
   X1=X0+RND(5)+1
  WEND
 NEXT
END

'タイトル + かどまる しかく
DEF PBOX X,Y,W,H,S,CO
 COLOR CO
 LOCATE X/8+3,Y/8
 PRINT S
 RGBF CO OUT R,G,B
 C=RGB(230*R,230*G,230*B)
 EX=X+W
 EY=Y+H
 GFILL X+1,Y+3,X+2,Y+5,C
 GFILL X+2,Y+2,X+3,Y+3,C
 GFILL X+3,Y+1,X+5,Y+2,C
 GFILL X+6,Y,X+15,Y+1,C
 GFILL X+LEN(S)*8+28,Y,EX-5,Y+1,C
 GFILL EX-4,Y+1,EX-2,Y+2,C
 GFILL EX-2,Y+2,EX-1,Y+3,C
 GFILL EX-1,Y+3,EX,Y+5,C
 GFILL EX,Y+6,EX+1,EY-5,C
 GFILL EX-1,EY-4,EX,EY-2,C
 GFILL EX-2,EY-2,EX-1,EY-1,C
 GFILL EX-4,EY-1,EX-2,EY,C
 GFILL X+6,EY,EX-5,EY+1,C
 GFILL X+1,EY-4,X+2,EY-2,C
 GFILL X+2,EY-2,X+3,EY-1,C
 GFILL X+3,EY-1,X+5,EY,C
 GFILL X,Y+6,X+1,EY-5,C
END

'していピクセル を くらく する
DEF DARK(X,Y,D)
 P=GPGET(X,Y)
 RGB P OUT R,G,B
 R=R-D
 G=G-D
 B=B-D
 IF R<0 THEN R=0
 IF G<0 THEN G=0
 IF B<0 THEN B=0
 RETURN RGB(R,G,B)
END

' もくめ
DEF WOOD X,Y,W,H
 GFILL X,Y,X+W,Y+H,RGB(150,70,20)
 FOR I=0 TO 50
  S=RND(30)+80
  R=FLOOR(150*S/100)
  G=FLOOR(70*S/100)
  B=FLOOR(20*S/100)
  SX=X+RND(W)
  SY=Y+RND(H)-(H/2)
  IF SY<Y THEN SY=Y
  EY=Y+(H/2)+RND(H)
  IF EY>Y+H THEN EY=Y+H
  GLINE SX,SY,SX,EY,RGB(R,G,B)
 NEXT
 
 FOR I=X+W-2 TO X+W
  FOR J=Y TO Y+H
   GPSET I,J,DARK(I,J,40)
  NEXT
 NEXT
 FOR I=X TO X+W-3
  FOR J=Y+H-2 TO Y+H
   GPSET I,J,DARK(I,J,40)
  NEXT
 NEXT
END

'かげ
DEF SHADOW X,Y,W,H
 C=50
 FOR I=X+W+1 TO X+W+5
  FOR J=Y TO Y+H
   GPSET I,J,DARK(I,J,C)
  NEXT
  C=C-10
 NEXT
END

'=============
'ロゴ びょうが
'=============
DEF LOGO_DRAW X,Y
 M=#SP_LOGO
 S$="FMPETIT4"
 FOR I=O TO LEN(S$)-1
  C$=MID$(S$,I,1)
  SPSET M,ASC(C$)
  SPPAGE M,4
  SPOFS M,X+I*16,Y,-100
  SPCOLOR M,RGB(180,255,255,255)
  INC M
 NEXT
END

DEF CLEAR_LOGO
 M=#SP_LOGO
 S$="FMPETIT4"
 FOR I=O TO LEN(S$)-1
  SPCLR M
  INC M
 NEXT
END

DEF LOGO_ZOOM F
 X=20
 Y=7
 M=#SP_LOGO
 S$="FMPETIT4"
 IF F THEN
  FOR I=0 TO LEN(S$)-1
   C$=MID$(S$,I,1)
   SPSET M,ASC(C$)
   SPPAGE M,4
   SPOFS M,X+I*16-1,Y-1,-100
   SPCOLOR M,RGB(180,255,255,255)
   SPSCALE M,1.2,1.2
   INC M
  NEXT
 ELSE
  FOR I=0 TO LEN(S$)-1
   C$=MID$(S$,I,1)
   SPSET M,ASC(C$)
   SPPAGE M,4
   SPOFS M,X+I*16,Y,-100
   SPCOLOR M,RGB(180,255,255,255)
   SPSCALE M,1,1
   INC M
  NEXT
 ENDIF
END

'=============
'えきしょう びょうが
'=============
DEF LCD X,Y,W,H
 C=170
 GFILL X,Y,X+W,Y+H,RGB(C,C,C)
 C=60
 Z=0
 FOR J=Y TO Y+4
  FOR I=X+Z TO X+W
   GPSET I,J,DARK(I,J,C)
  NEXT
  C=C-13
  Z=Z+1
 NEXT
 C=60
 Z=1
 FOR I=X TO X+4
  FOR J=Y+Z TO Y+H
   GPSET I,J,DARK(I,J,C)
  NEXT
  C=C-13
  Z=Z+1
 NEXT
 C=200
 GLINE X,Y+H,X+W,Y+H,RGB(C,C,C)
 GLINE X+W,Y,X+W,Y+H,RGB(C,C,C)
 C=30
 GLINE X,Y,X+W,Y,RGB(C,C,C)
 GLINE X,Y,X,Y+H,RGB(C,C,C)
END

'=============
'ノブ びょうが
'=============
KNOB_CSR=-1

DEF CIRCLEFILL X,Y,R,C
 GCIRCLE X,Y,R,RGB(255,0,0)
 GPAINT X,Y,RGB(C,C,C),RGB(255,0,0)
 GCIRCLE X,Y,R,RGB(C,C,C)
END

DEF KNOBSP_INIT
 GTARGET 3
 GFILL 0,0,100,31,0

 DN=0
 P=0
 CIRCLEFILL P+10,2,1,230
 SPDEF DN,P,0,21,21,11,11

 DN=1
 P=27
 CIRCLEFILL P+13,13,13,140
 CIRCLEFILL P+13,13,12,120
 CIRCLEFILL P+13,13,11,100
 CIRCLEFILL P+13,13,10,80
 CIRCLEFILL P+13,13,9,0
 SPDEF DN,P,0,27,27,12,13,16

 GTARGET 0
END

DEF KNOBSP_ADD N,X,Y
 DN=0
 SPSET N,DN
 SPOFS N,X+1,Y
' SPCOLOR N,RGB(255,100,0)
 SPSHOW N

 DN=1
 M=N+50
 SPSET M,DN
 SPOFS M,X,Y
 SPHIDE M

 SPCOLOR M,RGB(200,100,100,255)
' SPSCALE M,0.9,0.9
 SPANIM M,"S",-60,1.3,1.3,-60,1.0,1.0,0
 SPSTART 
END

DEF KNOBSP_VAL N,V
 SPROT N,V*284/127-142
END

DEF KNOB N,X,Y
 'SHADOW
 SX=X+5
 SY=Y+5
 FOR I=SX-12 TO SX+12
  FOR J=SY-12 TO SY+12
   DX=(I-SX)*(I-SX)
   DY=(J-SY)*(J-SY)
   D=DX+DY '0..288
   C=(150-D)/2
   IF C>100 THEN C=100
   IF C<0 THEN C=0
   GPSET I,J,DARK(I,J,C)
  NEXT
 NEXT

 'KNOB
 CIRCLEFILL X+1,Y+1,10,30
 CIRCLEFILL X,Y,9,50

 FOR I=0 TO 10
  FOR J=0 TO 10
   R=I*I+J*J
   IF R>=70 && R<=90 THEN
    C=SIN(#PI*I/9)*80+80
    GPSET X-I,Y-J,RGB(C,C,C)
   ENDIF
  NEXT
 NEXT

 FOR I=0 TO 6
  FOR J=0 TO 6
   IF I*I+J*J<=36 THEN
    C=155+200*ATAN(I,J)/3.1415
    GPSET X+I,Y+J,RGB(C,C,C)
    GPSET X+I,Y-J,RGB(C,C,C)
    GPSET X-I,Y+J,RGB(C,C,C)
    GPSET X-I,Y-J,RGB(C,C,C)
   ENDIF
  NEXT
 NEXT

 KNOBSP_ADD N,X,Y
END


DEF PBOX_HILIGHT N,FLG
 VAR C
 IF FLG THEN C=RGB(100,100,255) ELSE C=#C_WHITE
 CASE N
 WHEN 0:PBOX  44,10+80,85,55,"OSC1",C
 WHEN 1:PBOX 139,10+80,85,55,"OSC2",C
 WHEN 2:PBOX 234,10+80,85,55,"OSC3",C
 WHEN 3:PBOX 44,75+80,130,60,"EG",C
 WHEN 4:PBOX 184,75+80,135,60,"EFFECT",C
 ENDCASE
END

DEF KNOB_SET_CATEGORY N
 IF KNOB_CATEGORY==N THEN RETURN

 IF KNOB_CATEGORY>=0 THEN PBOX_HILIGHT KNOB_CATEGORY,#FALSE
 IF N>=0 THEN PBOX_HILIGHT N,#TRUE

 KNOB_CATEGORY=N
END

DEF KNOB_SEL N
 IF KNOB_CSR>=0 && KNOB_CSR<14 THEN SPHIDE KNOB_CSR+50
 IF N>=0 && N<14 THEN SPSHOW N+50
 KNOB_CSR=N
 KNOB_ROT=0
 IF N>=0 && N<14 THEN KNOB_DLGV=PV[N] ELSE KNOB_DLGV=0
 KNOB_DLGX=127
 IF N==0 || N==2 || N==4 THEN KNOB_DLGX=8
 IF N==12 THEN KNOB_DLGX=3
 KNOB_DLGS=KNOB_DLGX/127

 CAT=-1
 IF N <= 5 THEN
  CAT=N DIV 2
 ELSEIF N <= 9 THEN
  CAT = 3
 ELSEIF N <= 13 THEN
  CAT = 4
 ENDIF
 KNOB_SET_CATEGORY CAT
END

DEF KNOB_TOUCH X,Y
 VAR LEN=-1,L
 VAR SEL=-1
 FOR I=0 TO 13
  IF X>=KNOB_POS[I,0]-20 && X<=KNOB_POS[I,0]+20 THEN
   IF Y>=KNOB_POS[I,1]-20 && Y<=KNOB_POS[I,1]+20 THEN
    L=POW(KNOB_POS[I,0]-X,2)+POW(KNOB_POS[I,1]-Y,2)
    IF LEN<0 || L<LEN THEN
     SEL=I
     LEN=L
    ENDIF
   ENDIF
  ENDIF
 NEXT
 IF SEL>=0 THEN
  KNOB_SEL SEL
  INFO_UPDATE SEL
  KNOB_DLG=SEL
  KNOB_DLGP[0]=X
  KNOB_DLGP[1]=Y
  RETURN
 ENDIF
END

'=============
'パラメーター
'=============
DEF PRM_INIT
 PS$[0]="OSC1 FREQUENCY"
 PS$[1]="OSC1 LEVEL"
 PS$[2]="OSC2 FREQUENCY"
 PS$[3]="OSC2 LEVEL"
 PS$[4]="OSC3 FREQUENCY"
 PS$[5]="OSC3 LEVEL"
 PS$[6]="EG ATTACK"
 PS$[7]="EG DECAY"
 PS$[8]="EG SUSTAIN"
 PS$[9]="EG RELEASE"
 PS$[10]="FX VIBRATO RATE"
 PS$[11]="FX VIBRATO DEPTH"
 PS$[12]="FX REVERB TYPE"
 PS$[13]="FX REVERB LEVEL"
 PS$[14]=""

 FOR I=0 TO 14
  PV[I]=63
 NEXT
 PV[0]=3 'OSC1 FREQ
 PV[2]=3 'OSC2 FREQ
 PV[4]=3 'OSC3 FREQ
 PV[6]=0 'EG A
 PV[9]=25'EG R
 PV[10]=10 'VIBRATO SPEED
 PV[11]=5  'VIBRATO DEPTH
 PV[12]=1  'REVERB TYPE

 ALG=1
 TRS=2
 DTN=10
END

'=============
'けんばん びょうが
'=============
DEF KBD_INIT
 GTARGET 3

 SX=FLOOR(800/#KEYCNT_W)
 WW=SX-4
 BW=SX-18
 HX=FLOOR(BW/2)

 'はくけん 
 PX=200
 C=200
 GFILL PX,0,PX+WW,207,RGB(C,C,C)
 C=100
 GPSET PX,207,RGB(C,C,C)
 GPSET PX+WW,207,RGB(C,C,C)
 SPDEF #SPD_KEY_W,PX,0,WW+1,208,0,0
 SPDEF #SPD_KEYH_W,PX,0,WW+1,208,0,0,#A_ADD

 'こくけん
 PX=PX+WW+1
 C=50
 X0=PX
 X1=PX+2*HX
 GFILL X0,0,X1,120,RGB(C,C,C)
 INC X0,3
 DEC X1,3
 FOR J=20 TO 100
  INC C,0.5
  GLINE X0,J,X1,J,RGB(C,C,C)
 NEXT
 C=100
 GPSET X0,J-1,RGB(C,C,C)
 GPSET X1,J-1,RGB(C,C,C)
 C=100
 GLINE X0,12,X0,18,RGB(C,C,C)
 C=115
 GLINE X0,18,X0,24,RGB(C,C,C)
 C=130
 GLINE X0,24,X0,100,RGB(C,C,C)
 SPDEF #SPD_KEY_B,PX,0,2*HX+1,121,0,0
 SPDEF #SPD_KEYH_B,PX,0,2*HX+1,121,0,0,#A_ADD

 GTARGET 0
END

DEF KBD_DRAW
 Y=240
 SX=FLOOR(800/#KEYCNT_W)
 WW=SX-4
 BW=SX-18
 HX=FLOOR(BW/2)
 'はっけん
 N=0
 FOR I=0 TO #KEYCNT_W-1
  X0=I*SX
  X1=I*SX+WW
  SPSET #SP_KEY_W_TOP+I,#SPD_KEY_W
  SPSET #SP_KEYH_W_TOP+I,#SPD_KEY_W,0
  SPPAGE #SP_KEYH_W_TOP+I,-1
  SPCOLOR #SP_KEYH_W_TOP+I,RGB(100,255,100,100)
  SPOFS #SP_KEY_W_TOP+I,X0,Y,50
  SPOFS #SP_KEYH_W_TOP+I,X0,Y,49
  KBD_PW[I,0]=X0
  KBD_PW[I,1]=X1
  KBD_PW[I,2]=60+N
  INC N
  NM=N MOD 12
  IF NM!=5 && NM!=0 THEN INC N
 NEXT
 'こっけん
 N=1
 FOR I=1 TO #KEYCNT_W-1
  M=I MOD 7
  IF M==3 THEN CONTINUE
  IF M==0 THEN CONTINUE
  X0=I*SX-HX
  X1=I*SX+HX
  SPSET #SP_KEY_B_TOP+I,#SPD_KEY_B
  SPSET #SP_KEYH_B_TOP+I,#SPD_KEY_B,0
  SPPAGE #SP_KEYH_B_TOP+I,-1
  SPCOLOR #SP_KEYH_B_TOP+I,RGB(100,255,100,100)
  SPOFS #SP_KEY_B_TOP+I,X0,Y,48
  SPOFS #SP_KEYH_B_TOP+I,X0,Y,47
  KBD_PB[I,0]=I*SX-HX
  KBD_PB[I,1]=I*SX+HX
  KBD_PB[I,2]=60+N
  INC N,2
  NM=N MOD 12
  IF NM==5 || NM==0 THEN INC N
 NEXT
 'パネル の かげはじょうざんレイヤーで表現 
 GTARGET 2
 GCLS #C_WHITE
 C=180
 FOR Y=240 TO 247
  GLINE 0,Y,799,Y,RGB(C,C,C)
  C=C+10
 NEXT
 SPSET #SP_SHADOW,0,0,800,450
 SPPAGE #SP_SHADOW,2
 SPLAYER #SP_SHADOW,0
 LAYER 0,3
 GTARGET 0
END

'タッチいちからけんばんをけんさくする 
DEF KBD_FIND X,Y OUT NO,ISBLACK
 VAR I,X1,X2

 NO = -1
 ISBLACK = #FALSE

 'こくけんからさきにさがす
 FOR I=1 TO #KEYCNT_W-1
  X1=KBD_PB[I,0]
  X2=KBD_PB[I,1]
  IF Y<=354 && X>=X1 && X<=X2 THEN
   NO = I
   ISBLACK = #TRUE
   RETURN
  ENDIF
 NEXT

 'こくけんがみつからなかったらはくけんをさがす
 FOR I=0 TO #KEYCNT_W-1
  X1=KBD_PW[I,0]
  X2=KBD_PW[I,1]
  IF X>=X1 && X<=X2 THEN
   NO = I
   ISBLACK = #FALSE
   RETURN
  ENDIF
 NEXT
END

'けんばんおしている状態をリセット
DEF KBD_RESET
 FOR I=0 TO #MAX_NOTE-1
  IF KBD_STAT[I] > 0 THEN
   KBD_STAT[I]=0
  ENDIF
 NEXT
END

'していけんばんをおすしょり
'いままでならしていなければならす
'まえフレームもならしていたら、じょうたいをけいぞくちゅうに
DEF KBD_DOWN NO,ISBLACK
 VAR I,CANDIDATE=-1
 FOR I=0 TO #MAX_NOTE-1
  IF KBD_STAT[I] >= 0 THEN
   IF KBD_KEY[I]==NO && KBD_BLK[I]==ISBLACK THEN
     KBD_STAT[I]=1
     RETURN
   ENDIF
  ELSE
   IF CANDIDATE<0 THEN CANDIDATE=I
  ENDIF
 NEXT
 IF CANDIDATE >= 0 THEN
  IF ISBLACK THEN
   SND_PLAY CANDIDATE,KBD_PB[NO,2],100
   SPSHOW #SP_KEYH_B_TOP+NO
  ELSE
   SND_PLAY CANDIDATE,KBD_PW[NO,2],100
   SPSHOW #SP_KEYH_W_TOP+NO
  ENDIF
  KBD_STAT[CANDIDATE]=1
  KBD_KEY[CANDIDATE]=NO
  KBD_BLK[CANDIDATE]=ISBLACK
 ENDIF
END

'おされていないけんばんのおとをまとめてオフ
DEF KBD_SWEEP
 FOR I=0 TO #MAX_NOTE-1
  IF KBD_STAT[I] == 0 THEN
   IF KBD_BLK[I] THEN
    SPHIDE #SP_KEYH_B_TOP+KBD_KEY[I]
   ELSE
    SPHIDE #SP_KEYH_W_TOP+KBD_KEY[I]
   ENDIF
   SND_STOP I
   KBD_STAT[I]=-1
  ENDIF
 NEXT
END

'=============
'アルゴリズム びょうが
'=============
DEF ALG_BOX X,Y
 C=128
 GBOX X*8-10,Y*8-4,X*8+18,Y*8+10,RGB(C,C,C)
END

DEF ALG_AR1 X,Y
 C=128
 X1=X*8+4
 Y1=Y*8+11
 Y2=(Y+3)*8-5
 GLINE X1,Y1,X1,Y2,RGB(C,C,C)
 GLINE X1-2,Y2-2,X1,Y2,RGB(C,C,C)
 GLINE X1+2,Y2-2,X1,Y2,RGB(C,C,C)
END

DEF ALG_AR2 X,Y
 C=128
 X1=X*8-11
 X2=(X-6)*8+19
 Y1=Y*8+3
 GLINE X1,Y1,X2,Y1,RGB(C,C,C)
 GLINE X2+2,Y1-2,X2,Y1,RGB(C,C,C)
 GLINE X2+2,Y1+2,X2,Y1,RGB(C,C,C)
END

DEF ALG_CLS
 X1=47
 X2=56
 Y1=8
 Y2=15
 FOR Y=Y1 TO Y2
  LOCATE X1,Y:PRINT "            "
 NEXT
 C=170
 GFILL X1*8-10,Y1*8-4,X2*8+18,Y2*8+10,RGB(C,C,C)
END

DEF ALG_DRAW
 ALG_CLS
 COLOR #C_GRAY
 CASE ALG
 WHEN 1
  LOCATE 51, 8:PRINT "3"
  LOCATE 51,11:PRINT "2"
  LOCATE 51,14:PRINT "1"
  ALG_BOX 51, 8
  ALG_BOX 51,11
  ALG_BOX 51,14
  ALG_AR1 51, 8
  ALG_AR1 51,11
  ALG_AR1 51,14
 WHEN 2
  LOCATE  48, 9:PRINT "2"
  LOCATE  48,12:PRINT "1"
  LOCATE  54,12:PRINT "3"
  ALG_BOX 48, 9
  ALG_BOX 48,12
  ALG_BOX 54,12
  ALG_AR1 48, 9
  ALG_AR1 48,12
  ALG_AR2 54,12
 WHEN 3
  LOCATE  49, 9:PRINT "2"
  LOCATE  49,12:PRINT "1"
  LOCATE  53,12:PRINT "3"
  ALG_BOX 49, 9
  ALG_BOX 49,12
  ALG_BOX 53,12
  ALG_AR1 49, 9
  ALG_AR1 49,12
  ALG_AR1 53,12
 WHEN 4
  LOCATE  47,11:PRINT "1"
  LOCATE  51,11:PRINT "2"
  LOCATE  55,11:PRINT "3"
  ALG_BOX 47,11
  ALG_BOX 51,11
  ALG_BOX 55,11
  ALG_AR1 47,11
  ALG_AR1 51,11
  ALG_AR1 55,11
 ENDCASE
 INFO "ALGORITHM",ALG
END

'=============
'エンベロープ びょうが
'=============
DEF EG_DRAW
 A=PV[6]
 D=PV[7]
 S=PV[8]
 R=PV[9]

 X=490
 Y=60
 W=120
 H=70

 SUM=A+D+150+R
 AX=W*A/SUM+X
 DX=W*D/SUM+AX
 SX=W*150/SUM+DX
 RX=W*R/SUM+SX
 SY=-H*S/127+Y+H

 C=RGB(128,128,128)
 GFILL X,Y,X+W,Y+H,RGB(170,170,170)
 GLINE X,Y+H,AX,Y,C
 GLINE AX,Y,DX,SY,C
 GLINE DX,SY,SX,SY,C
 GLINE SX,SY,RX,Y+H,C

 SET_WAV
END

'=============
'はけい びょうが
'=============
DEF WAVE_DRAW
 F1=PV[0]+1
 F2=PV[2]+1
 F3=PV[4]+1
 V1=PV[1]/127
 V2=PV[3]/127
 V3=PV[5]/127

 CASE ALG
 WHEN 1
  FOR I=0 TO WVL
   RD=RAD(I*360/WVL)
   S3=V3*SIN(F3*RD)
   S2=V2*SIN(F2*RD+S3)
   WV[I]=V1*SIN(F1*RD+S2)
  NEXT
 WHEN 2
  FOR I=0 TO WVL
   RD=RAD(I*360/WVL)
   S3=V3*SIN(F3*RD)
   S2=V2*SIN(F2*RD)
   WV[I]=V1*SIN(F1*RD+S2+S3)
  NEXT
 WHEN 3
  FOR I=0 TO WVL
   RD=RAD(I*360/WVL)
   S3=V3*SIN(F3*RD)
   S2=V2*SIN(F2*RD)
   WV[I]=(V1*SIN(F1*RD+S2)+S3)/2
  NEXT
 WHEN 4
  FOR I=0 TO WVL
   RD=RAD(I*360/WVL)
   S3=V3*SIN(F3*RD)
   S2=V2*SIN(F2*RD)
   WV[I]=(V1*SIN(F1*RD)+S2+S3)/3
  NEXT
 ENDCASE

 FOR I=0 TO WVL
   WVI%[I]=FLOOR(WV[I]*128)*128
'   WVI%[I]=FLOOR(WV[I]*16384)
  IF WVI%[I]>32767 THEN WVI%[I]=32767
  IF WVI%[I]<-32768 THEN WVI%[I]=-32768
 NEXT

 X=360
 Y=150
 W=256
 H=64
 Y0=Y+H/2
 GFILL X,Y,X+W,Y+H,RGB(170,170,170)
 C=RGB(128,128,128)
 R=(WVL+1) DIV 512
 FOR I=0 TO 255 
  L=WV[I*R]*30
  IF L<-36 THEN L=-30
  IF L>36 THEN L=30
  GLINE X+I,Y0,X+I,Y0-L,C
 NEXT

 SET_WAV
END
'=============
'サウンド
'=============
DEF SET_WAV
 A=127-PV[6]
 D=127-PV[7]
 S=PV[8]
 R=127-PV[9]
 WAVSETA 224,A,D,S,R,WVI%,69,0,LEN(WVI%)-1,28160*POW(2,WAVRES-1)
END

DEF SND_PLAY TRACK,NOTE,VEL
 N$="N"+STR$(NOTE+12*TRS)
 BASE$= "@224T1V80"
 S0$=":0"+BASE$+VIB$+N$+" "
 S1$=":1"+BASE$+VIB$+DT1$+N$+" "
 S2$=":2"+BASE$+VIB$+DT2$+N$+" "
 BGMSET 128+TRACK,S0$+S1$+S2$
 BGMPLAY TRACK,128+TRACK
' LOGO_ZOOM 1
END

DEF SND_STOP TRACK
 S0$=":0@224R16 "
 S1$=":1@224R16 "
 S2$=":2@224R16 "
 BGMSET 192+TRACK,S0$+S1$+S2$
 BGMPLAY TRACK,192+TRACK
' LOGO_ZOOM 0
END

DEF SET_REVERB
' EFCSET PV[12]
' EFCWET 0,PV[13],0
END

DEF SET_VIBRATO
 VIB$="@MP"+STR$(PV[11])+",5,"+STR$(PV[10])+",0"
END

DEF SET_DETUNE
 INC DTN,10
 IF DTN>50 THEN DTN=0
 DT1$="@D"+STR$(DTN)
 DT2$="@D-"+STR$(DTN)
 INFO "DETUNE",DTN
END

'=============
'がめん こうしん
'=============
COMMON DEF DPRINT S
 INFOTEXT S
END

DEF INFOTEXT S
 LOCATE 4,7
 COLOR #C_BLACK
 PRINT S;"                                     "
END

DEF INFO S$,V
 LOCATE 4,7
 COLOR #C_BLACK
 PRINT S$;" : ";V;"                   "
END

DEF KNOB_UPDATE N
 V=PV[N]
 IF N==0 || N==2 || N==4 THEN V=PV[N]*14+7
 IF N==12 THEN V=PV[N]*32+16
 KNOBSP_VAL N,V
END

DEF INFO_UPDATE N
 IF N <0 || N>=14 THEN
  INFOTEXT ""
  RETURN
 ENDIF
 IF N==12 THEN
  P=PV[N]
  IF P==0 THEN S$="OFF"
  IF P==1 THEN S$="BATHROOM"
  IF P==2 THEN S$="CAVE"
  IF P==3 THEN S$="SPACE"
  INFOTEXT PS$[N]+" : "+S$
  RETURN
 ENDIF
 IF N==0 || N==2 || N==4 THEN
  INFOTEXT PS$[N]+" : x"+STR$(PV[N]+1)
 ELSE
  INFO PS$[N],PV[N]
 ENDIF
END

DEF VIEW_UPDATE N
 KNOB_UPDATE N
 INFO_UPDATE N
 IF N>=0 && N<=5 THEN WAVE_DRAW
 IF N>=6 && N<=9 THEN EG_DRAW
 IF N>=10 && N<=11 THEN SET_VIBRATO
 IF N>=12 && N<=13 THEN SET_REVERB
END

'がめん かんぜん クリア
DEF ALLCLS
 BGMSTOP
' EFCOFF
 ACLS
 XSCREEN 800,448
 TSCREEN 4,8,8
 TLAYER 4,1
 SYSPARAM "MOUSECURSOR",1

 GTARGET 0
 GCLS
 CLS

 SPPAGE 3
 SPLAYER 1
 SPOFS #GSPRITE,,,100
 SPLAYER #GSPRITE,1
END


DEF INST_DRAW
 COLOR #C_WHITE
 LOCATE 43,5
 PRINT "  ALGORITHM       ENVELOPE"
 LOCATE 86,16
 PRINT "  OCT UP"
 LOCATE 86,18
 PRINT "Z OCT DOWN"
 LOCATE 86,20
 PRINT "   CHG ALG"
 LOCATE 86,22
 PRINT "   DETUNE"
 LOCATE 86,24
 CASE TOYCON
 WHEN 1:COLOR RGB(255,100,100)
 WHEN 2:COLOR RGB(100,100,255)
 OTHERWISE:COLOR #C_WHITE
 ENDCASE
 PRINT "   TOY-CON"
 COLOR #C_WHITE
 LOCATE 86,26
 PRINT "   EXIT"
END

'ピアノトイコンしようかいし
DEF TOYCON_ON
 IF TOYCON>=1 THEN RETURN
 XCTRLSTYLE 1,100,0,1
 TOYCON=1
 INST_DRAW
 INFOTEXT "TOY-CON WAIT FOR CONN"
END

'ピアノトイコンしようをやめる 
DEF TOYCON_OFF
 IF TOYCON==0 THEN RETURN
 XCTRLSTYLE 0
 TOYCON=0
 INST_DRAW
 INFOTEXT "TOY-CON OFF"
END

'ピアノトイコン ダイアルいれかえ 
DEF TOYCON_SET_KNOB DT
 KNOB_TYPE = DT
 NN=-1
 CASE DT
 WHEN 1
  CASE KNOB_CATEGORY 
  WHEN 0:NN=0
  WHEN 1:NN=2
  WHEN 2:NN=4
  WHEN 3:NN=6
  WHEN 4:NN=10
  ENDCASE
 WHEN 2:
  CASE KNOB_CATEGORY 
  WHEN 0:NN=1
  WHEN 1:NN=3
  WHEN 2:NN=5
  WHEN 3:NN=7
  WHEN 4:NN=11
  ENDCASE
 WHEN 3:
  CASE KNOB_CATEGORY 
  WHEN 3:NN=8
  WHEN 4:NN=12
  ENDCASE
 WHEN 4:
  CASE KNOB_CATEGORY 
  WHEN 3:NN=9
  WHEN 4:NN=13
  ENDCASE
 ENDCASE

 IF NN<0 THEN
  CAT = KNOB_CATEGORY
  KNOB_SEL -1
  KNOB_SET_CATEGORY CAT
  INFO_UPDATE -1
 ELSE
  KNOB_SEL NN
  INFO_UPDATE NN
 ENDIF
END

'ピアノトイコン ダイアルかいてんそうさ 
DEF TOYCON_ROTATE_KNOB DV
 'ものすごくちいさいへんかはノイズとしてむしする 
 IF ABS(DV) < 0.002 THEN RETURN
 KNOB_ROT = KNOB_ROT + DV*127
 PV[KNOB_CSR]=KNOB_DLGV+FLOOR(KNOB_ROT*KNOB_DLGS)
 IF PV[KNOB_CSR]>KNOB_DLGX THEN PV[KNOB_CSR]=KNOB_DLGX
 IF PV[KNOB_CSR]<0 THEN PV[KNOB_CSR]=0
 INFO_UPDATE KNOB_CSR
 VIEW_UPDATE KNOB_CSR
END

VAR PREV_PBIT=0

DEF TOYCON_UPDATE
 IF TOYCON==0 THEN RETURN

 TCPIANO 1 OUT PFLG,PBIT,DT,DV
 VAR NT=1
 IF PFLG!=0 THEN NT=2
 IF TOYCON!=NT THEN
  IF NT==1 THEN
   INFOTEXT "TOY-CON WAIT FOR CONN"
  ELSE
   INFOTEXT "TOY-CON READY"
  ENDIF
  TOYCON=NT
  INST_DRAW
 ENDIF

 IF TOYCON==1 THEN RETURN

 PTRIG = PBIT AND NOT PREV_PBIT
 PREV_PBIT = PBIT
 IF PBIT AND 1 THEN KBD_DOWN 7,#FALSE
 IF PBIT AND 2 THEN KBD_DOWN 8,#TRUE
 IF PBIT AND 4 THEN KBD_DOWN 8,#FALSE
 IF PBIT AND 8 THEN KBD_DOWN 9,#TRUE
 IF PBIT AND 16 THEN KBD_DOWN 9,#FALSE
 IF PBIT AND 32 THEN KBD_DOWN 10,#FALSE
 IF PBIT AND 64 THEN KBD_DOWN 11,#TRUE
 IF PBIT AND 128 THEN KBD_DOWN 11,#FALSE
 IF PBIT AND 256 THEN KBD_DOWN 12,#TRUE
 IF PBIT AND 512 THEN KBD_DOWN 12,#FALSE
 IF PBIT AND 1024 THEN KBD_DOWN 13,#TRUE
 IF PBIT AND 2048 THEN KBD_DOWN 13,#FALSE
 IF PBIT AND 4096 THEN KBD_DOWN 14,#FALSE
 IF PTRIG AND 8192 THEN SET_DETUNE
 IF PTRIG AND 16384 THEN
  INC TRS
  IF TRS>3 THEN TRS=3
  INFO "TRANSPOSE",TRS
 ENDIF
 IF PTRIG AND 32768 THEN
  DEC TRS
  IF TRS<0 THEN TRS=0
  INFO "TRANSPOSE",TRS
 ENDIF
 IF PTRIG AND &H10000 THEN
  INC ALG
  IF ALG>=5 THEN ALG=1
  ALG_DRAW
  WAVE_DRAW
 ENDIF
 IF PTRIG AND &H20000 THEN
  ND=KNOB_CATEGORY+1
  IF (ND > 4) THEN ND=-1
  TOYCON_SET_KNOB -1
  KNOB_SET_CATEGORY ND
 ENDIF

 IF KNOB_TYPE != DT THEN
  TOYCON_SET_KNOB DT
 ELSEIF KNOB_CSR>=0 && KNOB_TYPE >=0 THEN
  TOYCON_ROTATE_KNOB DV
 ENDIF
END


'=============
'メイン
'=============
'がめん しょきか
ALLCLS

'パネル
LY=239
PANEL 10,2,787,LY-4
WOOD 0,0,12,240
SHADOW 0,0,12,240
WOOD 787,0,12,240

LCD 352,50,120,85
LCD 480,50,140,85
LCD 352,144,268,74
LCD 28,50,298,16

LOGO_DRAW 20,7
COLOR RGB(64,64,64)
LOCATE 4,3
PRINT "SYNTHESIZER"

INST_DRAW

LY=150
PBOX  44,10+80,85,55,"OSC1",#C_WHITE
PBOX 139,10+80,85,55,"OSC2",#C_WHITE
PBOX 234,10+80,85,55,"OSC3",#C_WHITE
LOCATE 7,6+10
PRINT "FREQ LVL    FREQ LVL    FREQ LVL"
PBOX 44,75+80,130,60,"EG",#C_WHITE
PBOX 184,75+80,135,60,"EFFECT",#C_WHITE
LOCATE 7,11+10
PRINT "                   VIB     REV"
LOCATE 7,15+10
PRINT "A   D   S   R    SPD DPT TYP LVL"
KBD_INIT
KBD_DRAW

PRM_INIT
KNOBSP_INIT
RESTORE @KNOB_DATA
FOR I=0 TO 13
 READ KNOB_POS[I,0],KNOB_POS[I,1]
 KNOB_POS[I,0]=KNOB_POS[I,0]+24
 KNOB_POS[I,1]=KNOB_POS[I,1]+80
 KNOB I,KNOB_POS[I,0],KNOB_POS[I,1]
 KNOB_UPDATE I
NEXT
@KNOB_DATA
DATA 40,30,80,30,135,30,175,30,230,30,270,30
DATA 40,105,70,105,100,105,130,105
DATA 178,105,210,105,242,105,275,105

'EFCON
SET_VIBRATO
SET_REVERB

ALG_DRAW
EG_DRAW
WAVE_DRAW

INFOTEXT "FMPETIT4 SYNTHESIZER"

'=============
'メインループ
'=============
BREPEAT #B_LUP,30,1
BREPEAT #B_LDOWN,30,1
BREPEAT #B_LLEFT,30,10
BREPEAT #B_LRIGHT,30,10

KNOB_CSR=-1
KNOB_DLG=-1
PREV_PBIT=0

'[X] EXIT
WHILE BUTTON(0,#B_RUP)==0
 VSYNC

 'けんばんしょりかいし
 KBD_RESET

 'トイコン 
 TOYCON_UPDATE

 'タッチ
 FOR I=0 TO #MAX_NOTE-1
  TOUCH I OUT STTM,TX,TY
  IF STTM>0 && KNOB_DLG==-1 THEN
   IF TY<240 THEN
    IF I==0 THEN KNOB_TOUCH TX,TY
   ELSE
    KBD_FIND TX,TY OUT NO,ISBLK
    IF NO>=0 THEN KBD_DOWN NO,ISBLK
   ENDIF
  ENDIF
  IF I==0 THEN
   IF STTM == 0 && KNOB_DLG >= 0 THEN
    VIEW_UPDATE KNOB_DLG
    KNOB_DLG=-1
   ENDIF
   IF KNOB_DLG>=0 THEN
    N=KNOB_DLG
    V=TX-KNOB_DLGP[0]+KNOB_DLGP[1]-TY
    PV[N]=KNOB_DLGV+FLOOR(V*KNOB_DLGS)
    IF PV[N]>KNOB_DLGX THEN PV[N]=KNOB_DLGX
    IF PV[N]<0 THEN PV[N]=0
    KNOB_UPDATE N
    INFO_UPDATE N
    VIEW_UPDATE N
   ENDIF
  ENDIF
 NEXT

 'もうさわってないけんばんのおとをとめる
 KBD_SWEEP

 'ボタン
 ' [A] CHANGE ALGORITHM
 IF BUTTON(0,#B_RRIGHT,1) THEN
  INC ALG
  IF ALG>=5 THEN ALG=1
  ALG_DRAW
  WAVE_DRAW
 ENDIF
 ' [L][R] TRANSPOSE UP
 IF BUTTON(0,#B_L1,1) || BUTTON(0,#B_R1,1) THEN
  INC TRS
  IF TRS>3 THEN TRS=3
  INFO "TRANSPOSE",TRS
 ENDIF
 ' [ZL][ZR] TRANSPOSE DOWN
 IF BUTTON(0,#B_L2,1) || BUTTON(0,#B_R2,1) THEN
  DEC TRS
  IF TRS<0 THEN TRS=0
  INFO "TRANSPOSE",TRS
 ENDIF
 ' [B] CHANGE DETUNE
 IF BUTTON(0,#B_RDOWN,1) THEN
  SET_DETUNE
 ENDIF
 ' [Y] TOY-CON ON/OFF
 IF BUTTON(0,#B_RLEFT,2) THEN
  IF TOYCON!=0 THEN TOYCON_OFF ELSE TOYCON_ON
 ENDIF
 '[] PARAMETER UP
 IF BUTTON(0,#B_LUP,1) THEN
  IF KNOB_CSR >= 0 && KNOB_CSR < 14 THEN
   N=KNOB_CSR
   VMAX=127
   IF N==0 || N==2 || N==4 THEN VMAX=8
   IF N==12 THEN VMAX=3
   IF PV[N]<VMAX THEN INC PV[N]
   VIEW_UPDATE N
  ENDIF
 ENDIF
 '[] PARAMETER DOWN
 IF BUTTON(0,#B_LDOWN,1) THEN
  IF KNOB_CSR >= 0 && KNOB_CSR < 14 THEN
   N=KNOB_CSR
   IF PV[N]>0 THEN DEC PV[N]
   VIEW_UPDATE N
  ENDIF
 ENDIF
 '[] CURSOR LEFT
 IF BUTTON(0,#B_LLEFT,1) THEN
  SEL=KNOB_CSR-1
  IF SEL<0 THEN SEL=14
  KNOB_SEL SEL
  INFO_UPDATE SEL
 ENDIF
 '[] CURSOR RIGHT
 IF BUTTON(0,#B_LRIGHT,1) THEN
  SEL=KNOB_CSR+1
  IF SEL>14 THEN SEL=0
  KNOB_SEL SEL
  INFO_UPDATE SEL
 ENDIF
WEND

ALLCLS

Xb؆9Hd?f