      J  おぼの                       おぼの                               4     4     '
'  OBN-P01 "HOPPERS" version 1.00             
'                        Programmed by OBONO  
'

OPTION STRICT

' CONSTANTS

CONST #APP_CODE$="P01"
CONST #APP_VER$ ="1.01"

CONST #SCRN_W=1280
CONST #SCRN_H=720
CONST #BACKCOLOR=RGB(32,96,0)
CONST #BG_W=40
CONST #BG_H=22

CONST #XY_MIN=-256
CONST #XY_MAX=256
CONST #XY_RANGE=#XY_MAX-#XY_MIN
CONST #Z_MIN=-12
CONST #Z_MAX=244
CONST #Z_RANGE=#Z_MAX-#Z_MIN

CONST #FLN_LEVEL=50

CONST #EF_MAX=1
CONST #PL_MAX=4
CONST #FL_MAX=#FLN_LEVEL+1
CONST #DT_MAX=200
CONST #TT_MAX=7

CONST #PLJ_USUAL=4
CONST #PLJ_GOAL =6
CONST #PLJ_COAF =16

CONST #PLT_NORMAL=0
CONST #PLT_MOVE  =1
CONST #PLT_FALL  =2
CONST #PLT_WAIT  =3

CONST #PLC_RECOVER=120

CONST #CAM_COAF=4

CONST #FLT_NORMAL=0
CONST #FLT_MOVE  =1
CONST #FLT_VANISH=2
CONST #FLT_SMALL =3
CONST #FLT_GOAL  =4
CONST #FLT_MAX   =5

CONST #FLW_VANISH_MAX =64
CONST #FLW_VANISH_WAIT=180
CONST #FLW_VANISH_REV =8

CONST #FLS_SHRINK=4
CONST #FLZ_BASE=32
CONST #FLZ_STEP=2
CONST #FLR_BASE=2
CONST #FLR_STEP=1/8

CONST #FL_SP_X=0
CONST #FL_SP_Y=320
CONST #FL_SP_S=128
CONST #FL_SP_C=#FL_SP_S/2

CONST #SPN_PL=#EF_MAX
CONST #SPN_FL=#SPN_PL+#PL_MAX
CONST #SPN_DT=#SPN_FL+#FL_MAX
CONST #SPN_ALL=#SPN_DT+#DT_MAX

CONST #SPD_FL_BASE=0
CONST #SPD_PL_BASE=#SPD_FL_BASE+#FLT_MAX
CONST #SPD_PL_IDLE=0
CONST #SPD_PL_JUMP=4
CONST #SPD_PL_FALL=5
CONST #SPD_PL_MAX =6
CONST #SPD_DT=1462
CONST #SPD_TTL_BASE=#SPD_PL_BASE+#SPD_PL_MAX*#PL_MAX

CONST #GMD_TITLE  =0
CONST #GMD_START  =1
CONST #GMD_PLAYING=2
CONST #GMD_CLEAR  =3
CONST #GMD_PAUSE  =4
CONST #GMD_OVER   =5
CONST #GMD_EXIT   =6
CONST #GMD_QUIT   =7

CONST #GMC_PAUSE_IGNORE=30
CONST #GMC_OVER_WAIT=120

CONST #MNI_MAX=3

CONST #TITLE_W=496
CONST #TITLE_H=100
CONST #TITLE_GAP=4
CONST #TITLE_Y_INIT=-207
CONST #TITLE_Y_MAX=144
CONST #TITLE_FADE=15

' GLOBAL VARIABLES

DIM PLX[#PL_MAX],PLY[#PL_MAX],PLZ[#PL_MAX]
DIM PLJ[#PL_MAX],PLF[#PL_MAX]
DIM PLT[#PL_MAX],PLC[#PL_MAX]
DIM CAX[#PL_MAX],CAY[#PL_MAX],CAZ[#PL_MAX]

DIM FLX[#FL_MAX],FLY[#FL_MAX],FLZ[#FL_MAX]
DIM FLT[#FL_MAX],FLV[#FL_MAX],FLW[#FL_MAX]
DIM FLM[#FL_MAX]

DIM DTX[#DT_MAX],DTY[#DT_MAX],DTZ[#DT_MAX]

DIM GMD,GMC,GMU,PLN,LVL,CNT,FLS
DIM MNE,MNY,MNV,MNI$[#MNI_MAX],BGM[]=[8,16,27]
DIM RNK$[]=["1ST","2ND","3RD","4TH"]
DIM TTW[]=[90,72,77,77,63,63,54]

' MAIN LOOP 

SUB_INITIALIZE
ON BREAK GOTO @BREAK
LOOP
 GMD=#GMD_TITLE
 SUB_TITLE
 IF GMD==#GMD_QUIT THEN @BREAK
 SUB_GAME
ENDLOOP
@BREAK
ACLS:BGMSTOP:WAIT 3:XCTRLSTYLE 0
END

' INITIALIZE 

DEF SUB_INITIALIZE
 EXEC "TXT:OBN-LOGO",3
 CALL "3:SUB_SHOW_LOGO",#APP_CODE$,#APP_VER$
 SUB_INITIALIZE_BG_GLYPHS
 SUB_INITIALIZE_SPRITES
 CALL "3:SUB_HIDE_LOGO"
 XSCREEN #SCRN_W,#SCRN_H
 TSCREEN 0,16,32,#BG_W,#BG_H:TOFS 0,0,8
 TSCREEN 4,16,16:BACKCOLOR #BACKCOLOR
 FADE #C_CLEAR,#TITLE_FADE
END

DEF SUB_INITIALIZE_BG_GLYPHS
 DIM X,Y,C
 GTARGET 4:TPAGE 0,4,0,992
 ' SMALL GLYPHS
 GCOPY 0,16,511,47,0,992,#G_NORMAL
 GCOPY 0,16,511,47,0,1024,#G_NORMAL
 FOR Y=992 TO 1055
  C=RGB(255,255-(Y MOD 16)*8,(Y<1024)*255)
  FOR X=0 TO 511
   GPSET X,Y,GPGET(X,Y) AND C
  NEXT
 NEXT
 ' LARGE GLYPHS
 GCOPY 0,1056,1023,1119,0,1120,#G_NORMAL
 FOR Y=1056 TO 1183
  C=RGB(255,255-(Y MOD 32)*4,(Y<1120)*255)
  FOR X=0 TO 1023
   GPSET X,Y,GPGET(X,Y) AND C
  NEXT
 NEXT
END

DEF SUB_INITIALIZE_SPRITES
 DIM I,J,X,Y,N,W,TTL%[#TITLE_W,#TITLE_H]
 ' SPDEF FOR FLOORS
 RESTORE @DATA_INIT_SP
 FOR I=#FLT_NORMAL TO #FLT_GOAL
  X=#FL_SP_X+I*#FL_SP_S:Y=#FL_SP_Y
  SUB_INITIALIZE_RANDER_FLOOR X,Y+#FL_SP_S
  SPDEF #SPD_FL_BASE+I,X,Y,\
    #FL_SP_S,#FL_SP_S,#FL_SP_C,#FL_SP_C,0
 NEXT
 ' SPDEF FOR PLAYERS
 FOR I=0 TO #PL_MAX-1
  N=#SPD_PL_BASE+I*#SPD_PL_MAX
  FOR J=0 TO 3
   SPDEF N+J,500+I*20+J,,,,,8,8,
  NEXT
  SPDEF N+4,465+I*8,,,,,8,8,
  SPDEF N+5,468+I*8,,,,,8,8,
 NEXT
 ' POSITION FOR DOTS
 FOR I=0 TO #DT_MAX-1
  DTX[I]=RNDF()*#XY_RANGE+#XY_MIN
  DTY[I]=RNDF()*#XY_RANGE+#XY_MIN
  DTZ[I]=RNDF()*#Z_RANGE
 NEXT
 ' TITLE LOGO
 X=0:LOADV "GRP:TITLE",TTL%
 GLOAD 0,#GRPHEIGHT-#TITLE_H,\
   #TITLE_W,#TITLE_H,TTL%,#G_NORMAL
 FOR I=0 TO #TT_MAX-1
  SPDEF #SPD_TTL_BASE+I,X,#GRPHEIGHT-#TITLE_H,\
    TTW[I],#TITLE_H
  INC X,TTW[I]
 NEXT
END

DEF SUB_INITIALIZE_RANDER_FLOOR X,Y
 DIM R,G,B,I,J,V,L
 READ R,G,B
 FOR I=0 TO #FL_SP_S-1:FOR J=0 TO #FL_SP_S-1
  L=I+J-#FL_SP_S:V=1+MIN(L,0)/256:L=MAX(L,0)/2
  GPSET X+J,Y+I,RGB(R*V+L,G*V+L,B*V+L)
 NEXT:NEXT
END

@DATA_INIT_SP
DATA 255,192,64, 64 ,224,64, 255,255,0
DATA 224,96 ,32, 160,160,255

' TITLE SCREEN 

DEF SUB_TITLE
 DIM I,X,Y,W,L$,C
 DIM TX[#TT_MAX],TY[#TT_MAX],TJ[#TT_MAX]
 ' LOGO
 SPLAYER 0:Y=#TITLE_Y_INIT
 X=#SCRN_W/2-#TITLE_W+(#TT_MAX-1)*#TITLE_GAP
 FOR I=0 TO #TT_MAX-1
  SPSET I,#SPD_TTL_BASE+I:SPSCALE I,2,2
  TX[I]=X:TY[I]=Y:TJ[I]=0
  INC X,(TTW[I]-#TITLE_GAP)*2
 NEXT
 ' LETTERS
  RESTORE @DATA_TITLE
 FOR I=0 TO 3
  READ X,Y,L$:LOCATE X,Y:PRINT L$
 NEXT
 ' MENU
 IF PLN>=2 THEN MNY=1 ELSE MNY=0
 MNI$[0]="SINGLE MODE"
 MNI$[1]="MULTIPLE MODE"
 MNI$[2]="QUIT":MNE=3:SUB_REFRESH_MENU
 ' LOOP
 WHILE GMD==#GMD_TITLE
  FOR I=0 TO #TT_MAX-1
   INC TY[I],TJ[I]:INC TJ[I]
   IF TY[I]>=#TITLE_Y_MAX THEN TJ[I]=-RND(9)-8
   SPOFS I,TX[I],TY[I]
  NEXT
  SUB_CONTROL_MENU
  IF BUTTON(1,#B_RRIGHT,2) THEN
   CASE MNY
    ' SINGLE MODE
    WHEN 0
     C=CONTROLLER(1)
     IF C>=1 && C<=3 THEN
      PLN=1:GMD=#GMD_START
     ELSE
      XCTRLSTYLE 0
      IF RESULT() THEN PLN=1:GMD=#GMD_START
     ENDIF
    ' MULTIPLE MODE
    WHEN 1
     PLN=0:XCTRLSTYLE 4,2,#FALSE,#FALSE,#TRUE
     IF RESULT() THEN
      FOR I=1 TO 4
       IF CONTROLLER(I)!=0 THEN PLN=I
      NEXT
      IF PLN>=2 THEN GMD=#GMD_START
     ENDIF
     IF PLN==0 THEN XCTRLSTYLE 0
    ' QUIT
    WHEN 2
     GMD=#GMD_QUIT:BEEP 13
   ENDCASE
  ENDIF
  VSYNC 1
 WEND
 SPCLR:CLS 4:MNE=0
END

@DATA_TITLE
DATA 53,20,"in Petit Computer 4"
DATA 25,40,"2019.6.3  Programmed by OBONO"
DATA 27,42,"https://obono.hateblo.jp/"
DATA 66,43,"Version "+#APP_VER$

' GAME SCREEN 

DEF SUB_GAME
 SUB_SETUP_GAME
 SUB_GAME_START
 REPEAT
  IF GMD!=#GMD_PAUSE THEN
   SUB_CONTROL_FLOORS
   SUB_CONTROL_PLAYERS
   CALL SPRITE
  ENDIF
  IF GMD==#GMD_PLAYING && GMU THEN
   SUB_UPDATE_STATUS
  ENDIF
  SUB_CONTROL_STATE
  VSYNC
 UNTIL GMD==#GMD_EXIT
 SPCLR:GTARGET 0:GCLS
END

DEF SUB_SETUP_GAME
 DIM I
 SUB_SETUP_LAYERS
 FOR I=0 TO PLN-1
  SUB_SETUP_SPTITES I
 NEXT
 LVL=0:CNT=#FALSE
 PLX[0]=0:PLY[0]=0:PLZ[0]=0:PLJ[0]=0
END

DEF SUB_GAME_START
 DIM I,X,Y
 Y=6:IF PLN>=3 THEN Y=10
 CLS 0:SUB_BGPRINT 15,Y,2,0,"READY"
 IF PLN>=2 THEN
  FOR I=0 TO PLN-1
   X=#BG_W*((I MOD 2)*2+1)/4-1
   IF PLN==2 THEN
    Y=#BG_H/2-2
   ELSE
    Y=#BG_H*((I DIV 2)*2+1)/4-1
   ENDIF
   SUB_BGPRINT X,Y,1,0,STR$(I+1)+"P"
  NEXT
 ENDIF
 GMD=#GMD_START:GMC=0:SUB_SETUP_LEVEL:BEEP 32
END

' SET UP LAYERS 

DEF SUB_SETUP_LAYERS
 DIM I,X,Y,W,H,S
 GTARGET 0:GCLS
 CASE PLN
  WHEN 1
   W=#SCRN_W:H=#SCRN_H:S=4
  WHEN 2
   W=#SCRN_W/2:H=#SCRN_H:S=3
   GFILL W-1,0,W,#SCRN_H-1,#C_BLACK
  OTHERWISE
   W=#SCRN_W/2:H=#SCRN_H/2:S=2
   GFILL W-1,0,W,#SCRN_H-1,#C_BLACK
   GFILL 0,H-1,#SCRN_W-1,H,#C_BLACK
 ENDCASE
 FOR I=0 TO PLN-1
  X=W*(I MOD 2):Y=H*(I DIV 2)
  SUB_SETUP_LAYER I+1,X,Y,W,H,S
 NEXT
 SUB_BLUR_LAYERS #FALSE
END

DEF SUB_SETUP_LAYER L,X,Y,W,H,S
 LCLIP L,X,Y,X+W-1,Y+H-1
 LMATRIX L,0,0,X+W/2,Y+H/2,S,S
END

DEF SUB_BLUR_LAYERS F
 DIM I
 FOR I=1 TO PLN:LFILTER I,2,F*256:NEXT
END

' SET UP SPRITES 

DEF SUB_SETUP_SPTITES P
 DIM I,N,R
 SPLAYER P+1
 ' FADER
 N=#SPN_ALL*P
 SPSET N,0,0,#SCRN_W,#SCRN_H,0,0:SPPAGE N,-1
 SPHOME N,#SCRN_W/2,#SCRN_H/2:SPOFS N,,,-4095
 SPVAR N,"P",P:SPFUNC N,"SUB_SP_FADER"
 ' PLAYERS
 N=#SPN_ALL*P+#SPN_PL
 FOR I=0 TO #PL_MAX-1
  IF I==0 THEN R=P ELSE R=I-(I<=P)
  IF R<PLN THEN
   SPSET N+I,#SPD_PL_BASE+R*#SPD_PL_MAX
   SPHOME N+I,8,8
   SPVAR N+I,"P",P:SPVAR N+I,"I",R
   SPFUNC N+I,"SUB_SP_PLAYER"
  ENDIF
 NEXT
 ' FLOORS
 N=#SPN_ALL*P+#SPN_FL
 FOR I=0 TO #FL_MAX-1
  SPSET N+I,#SPD_FL_BASE
  SPVAR N+I,"P",P:SPVAR N+I,"I",I
  SPFUNC N+I,"SUB_SP_FLOOR"
 NEXT
 ' DOTS
 N=#SPN_ALL*P+#SPN_DT
 FOR I=0 TO #DT_MAX-1
  SPSET N+I,#SPD_DT:SPHOME N+I,8,8
  SPVAR N+I,"P",P:SPVAR N+I,"I",I
  SPFUNC N+I,"SUB_SP_DOT"
 NEXT
END

' SETUP LEVEL 

DEF SUB_SETUP_LEVEL
 FLS=#FL_SP_C-LVL*#FLS_SHRINK
 SUB_SETUP_LEVEL_SPRITE
 SUB_SETUP_LEVEL_FLOORS
 SUB_SETUP_LEVEL_PLAYERS
END

DEF SUB_SETUP_LEVEL_SPRITE
 DIM I,J,X,S,C
 GTARGET 4
 GFILL #FL_SP_X,#FL_SP_Y,\
   #FL_SP_X+#FL_SP_S*#FLT_MAX-1,\
   #FL_SP_Y+#FL_SP_S,#C_CLEAR
 FOR I=#FLT_NORMAL TO #FLT_GOAL
  X=#FL_SP_X+#FL_SP_S*I:S=#FL_SP_C-FLS
  IF I==#FLT_SMALL THEN S=#FL_SP_C-FLS/2
  GCOPY X+S,#FL_SP_Y+#FL_SP_S+S,\
    X+#FL_SP_S-S-1,#FL_SP_Y+#FL_SP_S*2-S-1,\
    X+S,#FL_SP_Y+S,#G_NORMAL
  FOR J=S TO S+8
   C=192-ABS(J-S-4)*32
   GBOX X+J,#FL_SP_Y+J,X+#FL_SP_S-J-1,\
     #FL_SP_Y+#FL_SP_S-J-1,RGB(C,C,C)
  NEXT
 NEXT
END

DEF SUB_SETUP_LEVEL_FLOORS
 DIM I,D,R,Z,T[0]
 IF LVL<3 THEN PUSH T,#FLT_NORMAL
 IF LVL<6 THEN PUSH T,#FLT_NORMAL
 IF LVL AND 1 THEN PUSH T,#FLT_MOVE
 IF LVL AND 2 THEN PUSH T,#FLT_VANISH
 IF LVL AND 4 THEN PUSH T,#FLT_SMALL
 IF LEN(T)==0 THEN PUSH T,#FLT_SMALL
 Z=PLZ[0]-FLOOR(PLZ[0]/#Z_RANGE)*#Z_RANGE
 FOR I=0 TO #FL_MAX-1
  IF I==0 THEN
   FLX[I]=PLX[0]:FLY[I]=PLY[0]:FLZ[I]=Z
  ELSE
   FLX[I]=RNDF()*#XY_RANGE+#XY_MIN
   FLY[I]=RNDF()*#XY_RANGE+#XY_MIN
   FLZ[I]=Z-I*(#FLZ_BASE+LVL*#FLZ_STEP)\
    +(RNDF()*2-1)*LVL*#FLZ_STEP
  ENDIF
  FLT[I]=T[RND(LEN(T))]
  IF FLT[I]==#FLT_MOVE THEN
   D=RNDF()*#PI*2:R=#FLR_BASE+LVL*#FLR_STEP
   FLV[I]=COS(D)*R:FLW[I]=SIN(D)*R
  ELSE
   FLV[I]=0:FLW[I]=0
  ENDIF
 NEXT
 FLT[0]=#FLT_NORMAL:FLT[#FL_MAX-1]=#FLT_GOAL
END

DEF SUB_SETUP_LEVEL_PLAYERS
 DIM P
 FOR P=0 TO PLN-1
  SUB_SETUP_PLAYER_POSITION P,#TRUE
 NEXT
END

DEF SUB_SETUP_PLAYER_POSITION P,F
 DIM X,Y
 IF PLN>=2 THEN X=((P MOD 2)-0.5)*FLS
 IF PLN>=3 THEN Y=((P DIV 2)-0.5)*FLS
 PLX[P]=FLX[0]+X:PLY[P]=FLY[0]+Y:PLZ[P]=FLZ[0]
 PLF[P]=0:PLT[P]=#PLT_NORMAL:PLC[P]=0
 IF F THEN
  DEC PLZ[P],#Z_RANGE:PLT[P]=#PLT_WAIT
  IF PLN>=2 THEN PLJ[P]=0
 ENDIF
 CAX[P]=PLX[P]:CAY[P]=PLY[P]:CAZ[P]=PLZ[P]
END

' CONTROL STATE 

DEF SUB_CONTROL_STATE
 DIM I,B=BUTTON(1,#B_RANY,2),Y
 INC GMC:IF MNE>0 THEN SUB_CONTROL_MENU
 CASE GMD
  ' START
  WHEN #GMD_START
   IF PLZ[0]+PLJ[0]>FLZ[0] THEN
    FOR I=0 TO PLN-1:PLT[I]=#PLT_NORMAL:NEXT
    CLS 0:GMD=#GMD_PLAYING:GMC=0
    SUB_UPDATE_STATUS:SUB_START_BGM
   ENDIF
  ' PLAYING
  WHEN #GMD_PLAYING
   IF PLN==1 THEN
    IF PLT[0]==#PLT_WAIT THEN
     SUB_BGPRINT 10,6,2,1,"EXCELLENT!"
     SUB_BGPRINT 6,14,2,1,"TRY NEXT LEVEL"
     GMD=#GMD_CLEAR:GMC=0:BGMSTOP:BEEP 5
    ELSEIF PLT[0]==#PLT_FALL && PLC[0]==0 THEN
     GMD=#GMD_OVER:GMC=0:BGMSTOP
    ENDIF
   ELSE
    FOR I=0 TO PLN-1
     IF PLT[I]==#PLT_WAIT THEN
      Y=8:IF PLN>=3 THEN Y=10
      SUB_BGPRINT 7,Y,2,1,\
        "PLAYER "+STR$(I+1)+" WON!"
      GMD=#GMD_OVER:GMC=0:BGMSTOP
      SUB_UPDATE_STATUS:BEEP 113:BREAK
     ENDIF
    NEXT
   ENDIF
   IF GMD==#GMD_PLAYING && \
     GMC>=#GMC_PAUSE_IGNORE && B THEN
    SUB_BGPRINT 15,10,2,0,"PAUSE"
    MNI$[0]="RESUME":MNI$[1]="BACK TO TITLE"
    MNE=2:MNY=0:SUB_REFRESH_MENU
    SUB_BLUR_LAYERS #TRUE
    GMD=#GMD_PAUSE:GMC=0:BGMVOL 32:BEEP 3
   ENDIF
  ' CLEAR
  WHEN #GMD_CLEAR
   IF PLJ[0]>=0 THEN
    INC LVL:SUB_SETUP_LEVEL
    GMD=#GMD_START:GMC=0
   ENDIF
  ' PAUSE
  WHEN #GMD_PAUSE
   IF GMC>=#GMC_PAUSE_IGNORE && B THEN
    CLS 0:MNE=0:SUB_BLUR_LAYERS #FALSE
    IF MNY==0 THEN
     GMD=#GMD_PLAYING:GMC=0
     SUB_UPDATE_STATUS:BGMVOL 64:BEEP 4
    ELSE
     GMD=#GMD_EXIT:BGMSTOP:BEEP 40
    ENDIF
   ENDIF
  ' GAME OVER
  WHEN #GMD_OVER
   IF GMC>=#GMC_OVER_WAIT THEN
    IF GMC==#GMC_OVER_WAIT THEN
     IF PLN==1 THEN
      SUB_BGPRINT 11,10,2,0,"GAME OVER"
      BGMPLAY 6
     ENDIF
     I=0:IF PLN==1 && LVL>0 THEN
      MNI$[0]="CONTINUE":I=1
     ENDIF
     MNI$[I]="RETRY":MNI$[I+1]="BACK TO TITLE"
     MNE=2+I:MNY=0:SUB_REFRESH_MENU
     SUB_BLUR_LAYERS #TRUE
    ENDIF
    IF B THEN
     CLS 0:MNE=0:SUB_BLUR_LAYERS #FALSE
     IF PLN==1 && LVL>0 THEN DEC MNY
     IF MNY==-1 THEN
      GMD=#GMD_PLAYING:GMC=0
      PLC[0]=#PLC_RECOVER/2:CNT=#TRUE
      SUB_UPDATE_STATUS:SUB_START_BGM:BEEP 7
     ELSEIF MNY==0 THEN
      IF PLN==1 THEN LVL=0 ELSE LVL=(LVL+1)MOD 4
      CNT=#FALSE:SUB_GAME_START
     ELSE
      GMD=#GMD_EXIT:BEEP 40
     ENDIF
    ENDIF
   ENDIF
 ENDCASE
END

DEF SUB_START_BGM
 IF PLN==1 THEN
  BGMPLAY BGM[LVL MOD LEN(BGM)]
 ELSE
  BGMPLAY 25
 ENDIF
END

' CONTROL MENU 

DEF SUB_CONTROL_MENU
 DIM VY
 STICK 1 OUT ,VY
 VY=VY+BUTTON(1,#B_LDOWN)-BUTTON(1,#B_LUP)
 IF ABS(VY)>0.25 THEN VY=SGN(VY) ELSE VY=0
 IF VY!=MNV && VY!=0 THEN
  MNY=MNY+VY:BEEP 139
  IF MNY<0    THEN MNY=MNE-1
  IF MNY>=MNE THEN MNY=0
  SUB_REFRESH_MENU
 ENDIF
 MNV=VY
END

DEF SUB_REFRESH_MENU
 DIM I,C,L$
 FOR I=0 TO MNE-1
  IF I==MNY THEN C=1:L$="@ " ELSE C=0:L$="  "
  SUB_BGPRINT 15,13+I*2,1,C,L$+MNI$[I]
 NEXT
END

' CONTROL FLOORS 

DEF SUB_CONTROL_FLOORS
 DIM I
 FOR I=0 TO #FL_MAX-1
  SUB_CONTROL_FLOOR I
 NEXT
END

DEF SUB_CONTROL_FLOOR I
 CASE FLT[I]
  WHEN #FLT_MOVE
   FLX[I]=FN_LOOP_COORD(FLX[I],FLV[I])
   FLY[I]=FN_LOOP_COORD(FLY[I],FLW[I])
  WHEN #FLT_VANISH
   IF FLV[I] THEN
    INC FLW[I]
    IF FLW[I]>=#FLW_VANISH_WAIT THEN
     FLV[I]=0:FLW[I]=#FLW_VANISH_MAX
    ENDIF
   ELSE
    IF FLW[I]>0 THEN DEC FLW[I],#FLW_VANISH_REV
   ENDIF
   ENDCASE
 IF FLM[I]>0 THEN DEC FLM[I]
END

' CONTROL PLAYERS 

DEF SUB_CONTROL_PLAYERS
 DIM I
 FOR I=0 TO PLN-1
  SUB_CONTROL_PLAYER_MOVE I
  IF GMD!=#GMD_START THEN 
   SUB_CONTROL_PLAYER_JUDGE I
  ENDIF
 NEXT
END

DEF SUB_CONTROL_PLAYER_MOVE P
 DIM BX,BY,VX,VY,VR
 ' CAMERA X,Y
 VX=FN_LOOP_COORD(PLX[P],-CAX[P])/#CAM_COAF
 VY=FN_LOOP_COORD(PLY[P],-CAY[P])/#CAM_COAF
 CAX[P]=FN_LOOP_COORD(CAX[P],VX)
 CAY[P]=FN_LOOP_COORD(CAY[P],VY)
 ' PLAYER X,Y
 IF PLT[P]!=#PLT_WAIT THEN
  STICK P+1 OUT BX,BY
  VX=BUTTON(P+1,#B_LRIGHT)-BUTTON(P+1,#B_LLEFT)
  VY=BUTTON(P+1,#B_LDOWN) -BUTTON(P+1,#B_LUP)
  VX=VX*4+BX*5:VY=VY*4+BY*5:VR=SQR(VX*VX+VY*VY)
  IF VR>4 THEN VX=VX*4/VR:VY=VY*4/VR
  IF PLT[P]!=#PLT_FALL THEN
   IF VR<2 THEN
    PLT[P]=#PLT_NORMAL:PLC[P]=0
   ELSE
    PLT[P]=#PLT_MOVE:PLC[P]=(PLC[P]+1)MOD 16
   ENDIF
  ENDIF
 ELSE
  VX=0:VY=0:VR=0
 ENDIF
 PLX[P]=FN_LOOP_COORD(PLX[P],VX)
 PLY[P]=FN_LOOP_COORD(PLY[P],VY)
 ' CAMERA & PLAYER Z
 IF PLJ[P]<4 THEN INC PLJ[P],1/#PLJ_COAF
 IF PLJ[P]<0 THEN
  CAZ[P]=(CAZ[P]+PLZ[P])/2
 ELSE
  CAZ[P]=PLZ[P]+PLJ[P]
 ENDIF
 INC PLZ[P],PLJ[P]
 ' RECOVERY
 IF PLT[P]==#PLT_FALL THEN
  IF GMD==#GMD_PLAYING THEN INC PLC[P]
  IF PLC[P]>=#PLC_RECOVER THEN
   SUB_SETUP_PLAYER_POSITION P,#FALSE
  ENDIF
 ENDIF
END

DEF SUB_CONTROL_PLAYER_JUDGE P
 DIM I=PLF[P],X,Y,T,S
 IF I<#FL_MAX-1 && PLZ[P]<FLZ[I+1] THEN
  ' GO UP
  INC PLF[P]:GMU=#TRUE
 ELSEIF I>=0 && PLZ[P]>=FLZ[I] THEN
  X=FN_LOOP_COORD(FLX[I],-PLX[P])
  Y=FN_LOOP_COORD(FLY[I],-PLY[P])
  T=FLT[I]:S=FN_GET_FLOOR_SIZE(I,#TRUE)
  IF MAX(ABS(X),ABS(Y))<S THEN
   ' BOUNCE
   PLZ[P]=FLZ[I]
   IF T==#FLT_GOAL THEN
    PLJ[P]=-#PLJ_GOAL:PLT[P]=#PLT_WAIT
    FLM[I]=#PLJ_GOAL*#PLJ_COAF
    IF GMD==#GMD_PLAYING THEN VIBRATE P+1,20
   ELSE
    PLJ[P]=-#PLJ_USUAL
    FLM[I]=#PLJ_USUAL*#PLJ_COAF
    IF T==#FLT_VANISH THEN FLV[I]=1
    IF GMD==#GMD_PLAYING THEN
     BEEP 8:VIBRATE P+1,4
    ENDIF
   ENDIF
  ELSE
   ' GO DOWN
   DEC PLF[P]:GMU=#TRUE
   IF PLF[P]<0 THEN
    PLT[P]=#PLT_FALL:PLC[P]=0
    IF GMD==#GMD_PLAYING THEN
     BEEP 14:VIBRATE P+1,48
    ENDIF
   ENDIF
  ENDIF
 ENDIF
END

' UPDATE STATUS 

DEF SUB_UPDATE_STATUS
 DIM I,J,S,X,Y,N,R[#PL_MAX]
 IF PLN==1 THEN
  N=#FLN_LEVEL*LVL+MAX(PLF[0],0)
  SUB_BGPRINT 2,1,2,0,"FLOOR "+STR$(N)+" "
  IF CNT THEN SUB_BGPRINT 2,3,1,0,"CONTINUED"
  SUB_BGPRINT 24,19,2,0,"LEVEL "+STR$(LVL+1)
 ELSE
  FOR I=0 TO PLN-1
   R[I]=I
   FOR J=I-1 TO 0 STEP -1
    IF PLF[R[J]]<=PLF[R[J+1]] && \
      PLT[R[J]]!=#PLT_WAIT THEN
     SWAP R[J],R[J+1]
    ENDIF
   NEXT
  NEXT
  IF PLN==2 THEN S=2 ELSE S=1
  FOR I=0 TO PLN-1
   N=R[I]:X=(N MOD 2)*(#BG_W-S*5)+S
   Y=(N DIV 2)*(#BG_H-3)+1
   SUB_BGPRINT X,Y,S,(I==0),RNK$[I]
  NEXT
 ENDIF
 GMU=#FALSE
END

' SPRITE FUNCTIONS 

' FADER
DEF SUB_SP_FADER
 DIM N=CALLIDX()
 DIM P=SPVAR(N,"P")
 IF PLT[P]==#PLT_FALL THEN
  SPSHOW N:SPCOLOR N,RGB(PLC[P]*2,0,0,0)
 ELSE
  SPHIDE N
 ENDIF
END

' PLAYERS
DEF SUB_SP_PLAYER
 DIM N=CALLIDX()
 DIM P=SPVAR(N,"P"),I=SPVAR(N,"I")
 DIM X=PLX[I],Y=PLY[I],Z=PLZ[I],S=1,C
 IF GMD==#GMD_START && I!=P THEN S=0
 IF PLT[I]==#PLT_FALL THEN
  C=#SPD_PL_FALL
 ELSEIF PLJ[I]<-3 THEN
  C=#SPD_PL_JUMP
 ELSEIF PLT[I]==#PLT_MOVE THEN
  C=#SPD_PL_IDLE+PLC[I]/4
 ELSE
  C=#SPD_PL_IDLE
 ENDIF
 SPCHR N,#SPD_PL_BASE+I*#SPD_PL_MAX+C
 FN_ADJUST_COORDS P,X,Y,Z,#FALSE OUT X,Y,Z
 SUB_SPOFS3D N,X,Y,Z,S,(I==P)
END

' FLOORS
DEF SUB_SP_FLOOR
 DIM N=CALLIDX()
 DIM P=SPVAR(N,"P"),I=SPVAR(N,"I")
 DIM X=FLX[I]+(RND(3)-1)*FLM[I]/8
 DIM Y=FLY[I]+(RND(3)-1)*FLM[I]/8,Z=FLZ[I]
 DIM S=FN_GET_FLOOR_SIZE(I,#FALSE)
 SPCHR N,#SPD_FL_BASE+FLT[I]
 FN_ADJUST_COORDS P,X,Y,Z,#FALSE OUT X,Y,Z
 IF GMD==#GMD_START && I>0 THEN S=0
 SUB_SPOFS3D N,X,Y,Z,S,#FALSE
END

' DOTS
DEF SUB_SP_DOT
 DIM N=CALLIDX()
 DIM P=SPVAR(N,"P"),I=SPVAR(N,"I")
 DIM X=DTX[I],Y=DTY[I],Z=DTZ[I]
 FN_ADJUST_COORDS P,X,Y,Z,#TRUE OUT X,Y,Z
 SUB_SPOFS3D N,X,Y,Z,1,#FALSE
END

' ETC 

DEF FN_LOOP_COORD(C,V)
 C=C+V
 C=C+((C<#XY_MIN)-(C>#XY_MAX))*#XY_RANGE
 RETURN C
END

DEF FN_ADJUST_COORDS P,X,Y,Z,F OUT RX,RY,RZ
 RX=FN_LOOP_COORD(X,-CAX[P])
 RY=FN_LOOP_COORD(Y,-CAY[P])
 RZ=Z-CAZ[P]
 IF F THEN
  RZ=RZ-FLOOR((RZ-#Z_MIN)/#Z_RANGE)*#Z_RANGE
 ENDIF
END

DEF FN_GET_FLOOR_SIZE(I,F)
 DIM S=1,T=FLT[I]
 IF T==#FLT_VANISH THEN
  S=MAX(1-FLW[I]/#FLW_VANISH_MAX,0)
 ENDIF
 IF F THEN S=S*FLS:IF T==#FLT_SMALL THEN S=S/2
 RETURN S
END

DEF SUB_SPOFS3D N,X,Y,Z,S,F
 DIM A,Q
 IF S>0 THEN
  A=MIN((256-MAX(ABS(X),ABS(Y),Z))*4,255)
  IF !F THEN A=MIN(256+Z*24,A)
 ENDIF
 IF A>0 THEN
  Q=1/(1+Z/16)
  SPOFS N,X*Q,Y*Q,Z:SPSCALE N,S*Q,S*Q
  SPCOLOR N,RGB(A,255,255,255):SPSHOW N
 ELSE
  SPHIDE N
 ENDIF
END

DEF SUB_BGPRINT X,Y,S,C,L$
 DIM I,L
 FOR I=0 TO LEN(L$)-1
  L=ASC(MID$(L$,I,1))
  CASE S
   WHEN 1
    L=&HE7C0+(L MOD 32)+(L DIV 32)*64+C*128
    TPUT 0,X,Y,L:X=X+1
   WHEN 2
    L=&HE880+(L MOD 32)*2+(L DIV 32)*128+C*256
    TPUT 0,X,Y,L  :TPUT 0,X+1,Y,L+1  :L=L+64
    TPUT 0,X,Y+1,L:TPUT 0,X+1,Y+1,L+1:X=X+2
  ENDCASE
 NEXT
END

' EOF


NŋǇjqT:$6