      K  ; ほしけん                    ほしけん                    a  a                '----------------------------------------
' スプライトを十字キーで動かす (向きが変わって歩き、穴がある方向へ進めない)
'----------------------------------------
' 画面をクリアする
ACLS

' 0番のスプライトをセット。 絵は500番(戦士正面向き)にする
' 2048を足した番号は、基準点が左上ではなく、足元の中心に初期設定されている
SPSET 0,500+2048

' スプライトの座標のための変数
VAR X=200
VAR Y=120
' 絵の番号のための変数
VAR CHR=0
VAR CHR_OLD=0
' 動きたい方向(足したい座標)を覚えておくための変数
VAR MX=0,MY=0
' 今いる座標が、テキストスクリーンでいうと何マス目にあるかを覚えておくための変数
VAR CX=0,CY=0

' テキストスクリーンの大きさのための変数。
' 画面サイズ(400X240)を、1つ分の大きさである16で割る
VAR TW=64
VAR TH=64

' スクロール位置のための座標
VAR SX=0
VAR SY=0

' 0番のテキストスクリーンをセット
TSCREEN 0,16,TW,TH

' 0番のテキストスクリーン全体を &HE803 番のパーツで塗りつぶす
TFILL 0,0,0,TW-1,TH-1,&HE803

' 0番のテキストスクリーンに、ランダムに穴を空ける
FOR I=0 TO 400
  TPUT 0,RND(TW),RND(TH),&HE8E0
NEXT

' 自分のスプライトが立っている位置に穴がこないようにする
TPUT 0,X DIV 16,Y DIV 16,&HE803

' くりかえし開始
LOOP
  ' 直前の絵の番号を覚えておく
  CHR_OLD=CHR

  ' 動きたい方向(足したい座標)の変数を0にクリア
  MX=0
  MY=0

  ' 方向キーが押されたら、押された方向に動く (変数XやYの数字を増やしたり減らしたりする)
  ' さらに、変数 CHR に、向きに応じた絵の番号を入れておく
  IF BUTTON(0,#B_LLEFT)  THEN MX=-2:CHR=504:MOVE=1
  IF BUTTON(0,#B_LRIGHT) THEN MX= 2:CHR=496:MOVE=1
  IF BUTTON(0,#B_LUP)    THEN MY=-2:CHR=508:MOVE=1
  IF BUTTON(0,#B_LDOWN)  THEN MY= 2:CHR=500:MOVE=1

  ' もし、ボタンが押されたことで、絵の番号(変数CHR)が変化したときは
  IF CHR_OLD!=CHR THEN
    ' 変化した絵の番号を、0番のスプライトに反映する
    ' 2048を足した番号は、基準点が左上ではなく、足元の中心に初期設定されている
    SPCHR 0,CHR+2048

    ' 4/60秒ごとに、今の絵の番号から +0、+1、+2、+3 とパターンをくり返し切り替えて、
    ' 歩くアニメーションをさせる
    SPANIM 0,"I+", 4,0, 4,1, 4,2, 4,3, 0
  ENDIF

  ' もし、今動いていない場合は
  IF MX==0 && MY==0 THEN
    ' 歩くアニメーションを停止する
    SPSTOP 0
  ELSE
    ' そうでない(動いている)場合はアニメーションを再開させる
    SPSTART 0
  ENDIF

  ' もし、動きたい先の足元が穴でなければ、動きたい方向に進む
  ' 斜め移動のときに、ひっかからないように、X方向とY方向を別々にチェックする
  ' X方向のみチェックする
  IF CHKBLOCK(X+MX,Y) THEN
    ' 座標に動きたい方+MX向を足す
    INC X,MX
  ENDIF
  ' Y方向のみチェックする
  IF CHKBLOCK(X,Y+MY) THEN
    ' 座標に動きたい方向を足す
    INC Y,MY
  ENDIF

  ' 自分のスプライト座標をもとに、スクロール座標を設定
  SX=X-200
  SY=Y-120
  ' SX,SYの設定を以下のように変えて、上を削除すると、ゆっくり追従します
  'INC SX,((X-200)-SX)*0.1
  'INC SY,((Y-120)-SY)*0.1

  ' マップがはみだすところまではスクロールしないように調整
  IF SX<0 THEN SX=0
  IF SY<0 THEN SY=0
  IF SX>TW*16-400 THEN SX=TW*16-400
  IF SY>TH*16-240 THEN SY=TH*16-240

  ' テキストスクリーンのスクロール位置を設定
  ' TOFSでもできるが、THOMEだと、回転や拡大などしたときに中心がちゃんと真ん中になります
  THOME 0,SX,SY

  ' 0番のスプライトの位置を設定
  SPOFS 0,X-SX,Y-SY

  ' 1/60秒ごとの 画面更新タイミングまで待つ
  VSYNC
ENDLOOP

'-----------------------
' スプライト座標とブロックの当たり判定を取る
' 当たっていると #TRUE をかえします
'-----------------------

DEF CHKBLOCK(X,Y)
  ' 動きたい先のスプライト座標を、テキストスクリーン1マス分の大きさである16で割って、
  ' テキストスクリーンでいうと何マス目なのかを計算する
  VAR CX=X DIV 16
  VAR CY=Y DIV 16
  ' もし、動きたい先の足元が &HE8E0(穴) の絵でなければ、#TRUE を返す
  IF CHKCHR(0,X DIV 16,Y DIV 16)!=&HE8E0 THEN
    RETURN #TRUE
  ENDIF

  RETURN #FALSE
END

Gqm68#h4