      Y#  5
ほしけん                    ほしけん                    a  a                '----------------------------------------
' スプライトを十字キーで動かす (向きが変わって歩き、穴がある方向へ進めない)
'----------------------------------------
' 画面をクリアする
ACLS

' 敵のスプライトは何番から始めるか
CONST #ESPR=10
' 一度に表示する敵の最大数
CONST #EMAX=30
' 床のキャラクターコード
CONST #T_YUKA=&HE803
' 穴のキャラクターコード
CONST #T_HOLE=&HE8E0

' 0番のスプライトをセット。 絵は500番(戦士正面向き)にする
' 2048を足した番号は、基準点が左上ではなく、足元の中心に初期設定されている
SPSET 0,500+2048
' 当たり判定の範囲を設定する。足元の中心(8,15)あたりが基準なので、それにあわせた数値にする
SPCOL 0,-8,-15,16,16

' スプライトの座標のための変数
VAR X=200
VAR Y=120
' 絵の番号のための変数
VAR CHR=0
VAR CHR_OLD=0
' 動きたい方向(足したい座標)を覚えておくための変数
VAR MX=0,MY=0
' 今いる座標が、テキストスクリーンでいうと何マス目にあるかを覚えておくための変数
VAR CX=0,CY=0

' テキストスクリーンの大きさのための変数。
' 画面サイズ(400X240)を、1つ分の大きさである16で割る
VAR TW=64
VAR TH=64

' スクロール位置のための座標
VAR SX=0
VAR SY=0

' 敵の種類のための変数(0=いない、1〜敵の種類)
VAR ES[#EMAX]
' 敵の座標のための変数
VAR EX[#EMAX]
VAR EY[#EMAX]
' 敵の横移動量(または方向)のための変数
VAR EV[#EMAX]
' 敵の重力のための変数
VAR EW[#EMAX]

' 0番のテキストスクリーンをセット
TSCREEN 0,16,TW,TH

' 0番のテキストスクリーン全体を床のパーツで塗りつぶす
TFILL 0,0,0,TW-1,TH-1,#T_YUKA

' 0番のテキストスクリーンに、ランダムに穴を空ける
FOR I=0 TO 400
  TPUT 0,RND(TW),RND(TH),#T_HOLE
NEXT

' 自分のスプライトが立っている位置に穴がこないようにする
TPUT 0,X DIV 16,Y DIV 16,#T_YUKA

' 自分のスプライトが立っている位置に穴がこないようにする
TPUT 0,X DIV 16,Y DIV 16,#T_YUKA

' 適当に敵をちりばめてみます
FOR I=0 TO 30
  ENEMYSET RND(2)+1,RND(TW*16),RND(TH*16)
NEXT

' くりかえし開始
LOOP
  ' スクロール処理
  GOSUB @SCROLL
  ' 自分の移動
  GOSUB @MYMOVE
  ' 敵の移動
  GOSUB @ENEMYMOVE

  ' 1/60秒ごとの 画面更新タイミングまで待つ
  VSYNC
ENDLOOP


'-----------------------
' スクロールの処理
'-----------------------

@SCROLL
  ' 自分のスプライト座標をもとに、スクロール座標を設定
  SX=X-200
  SY=Y-120
  ' SX,SYの設定を以下のように変えて、上を削除すると、ゆっくり追従します
  'INC SX,((X-200)-SX)*0.1
  'INC SY,((Y-120)-SY)*0.1

  ' マップがはみだすところまではスクロールしないように調整
  IF SX<0 THEN SX=0
  IF SY<0 THEN SY=0
  IF SX>TW*16-400 THEN SX=TW*16-400
  IF SY>TH*16-240 THEN SY=TH*16-240

  ' テキストスクリーンのスクロール位置を設定
  ' TOFSでもできるが、THOMEだと、回転や拡大などしたときに中心がちゃんと真ん中になります
  THOME 0,SX,SY

  ' 0番のスプライトの位置を設定
  SPOFS 0,X-SX,Y-SY

  ' 敵のスプライトの位置を設定
  ' 最大の敵の数まで処理する
  FOR I=0 TO #EMAX-1
    ' もし、指定番号の敵が存在している (ES[I]に敵の種類が入っている) なら
    IF ES[I]!=0 THEN
      ' 敵のスプライトの位置を設定
      SPOFS #ESPR+I,EX[I]-SX,EY[I]-SY
    ENDIF
  NEXT
RETURN


'-----------------------
' 自プレイヤーの移動処理
'-----------------------

@MYMOVE
  ' 直前の絵の番号を覚えておく
  CHR_OLD=CHR

  ' 動きたい方向(足したい座標)の変数を0にクリア
  MX=0
  MY=0

  ' 方向キーが押されたら、押された方向に動く (変数XやYの数字を増やしたり減らしたりする)
  ' さらに、変数 CHR に、向きに応じた絵の番号を入れておく
  IF BUTTON(0,#B_LLEFT)  THEN MX=-2:CHR=504:MOVE=1
  IF BUTTON(0,#B_LRIGHT) THEN MX= 2:CHR=496:MOVE=1
  IF BUTTON(0,#B_LUP)    THEN MY=-2:CHR=508:MOVE=1
  IF BUTTON(0,#B_LDOWN)  THEN MY= 2:CHR=500:MOVE=1

  ' もし、ボタンが押されたことで、絵の番号(変数CHR)が変化したときは
  IF CHR_OLD!=CHR THEN
    ' 変化した絵の番号を、0番のスプライトに反映する
    ' 2048を足した番号は、基準点が左上ではなく、足元の中心に初期設定されている
    SPCHR 0,CHR+2048

    ' 4/60秒ごとに、今の絵の番号から +0、+1、+2、+3 とパターンをくり返し切り替えて、
    ' 歩くアニメーションをさせる
    SPANIM 0,"I+", 4,0, 4,1, 4,2, 4,3, 0
  ENDIF

  ' もし、今動いていない場合は
  IF MX==0 && MY==0 THEN
    ' 歩くアニメーションを停止する
    SPSTOP 0
  ELSE
    ' そうでない(動いている)場合はアニメーションを再開させる
    SPSTART 0
  ENDIF

  ' もし、動きたい先の足元が穴でなければ、動きたい方向に進む
  ' 斜め移動のときに、ひっかからないように、X方向とY方向を別々にチェックする
  ' X方向のみチェックする
  IF CHKBLOCK(X+MX,Y) THEN
    ' 座標に動きたい方+MX向を足す
    INC X,MX
  ENDIF
  ' Y方向のみチェックする
  IF CHKBLOCK(X,Y+MY) THEN
    ' 座標に動きたい方向を足す
    INC Y,MY
  ENDIF
RETURN


'-----------------------
' 敵の処理
'-----------------------

@ENEMYMOVE
  ' 最大の敵の数まで処理する
  FOR I=0 TO #EMAX-1

    ' もし、指定番号の敵が存在している (ES[I]に敵の種類が入っている) なら
    IF ES[I]!=0 THEN

      ' 敵の種類によって処理を変える
      CASE ES[I]

        ' 歩いてくるスライム
        WHEN 1
          ' 自分の座標と敵の座標を比べて、自分の方向進むようにする
          INC EX[I],SGN(X-EX[I])*0.5
          INC EY[I],SGN(Y-EY[I])*0.5

        ' とんでくるコウモリ
        WHEN 2
          ' 自分の座標と敵の座標を比べて、自分の方向に慣性をかける
          INC EV[I],SGN(X-EX[I])*0.02
          INC EW[I],SGN(Y-EY[I])*0.02
          ' 慣性を一定以上大きくしないようにする
          IF EV[I]> 1.0 THEN EV[I]= 1.0
          IF EV[I]<-1.0 THEN EV[I]=-1.0
          IF EW[I]> 1.0 THEN EW[I]= 1.0
          IF EW[I]<-1.0 THEN EW[I]=-1.0
          ' 慣性がある方向にとぶ
          INC EX[I],EV[I]
          INC EY[I],EW[I]

      ENDCASE

      ' 敵が自分と当たった場合
      IF SPHITSP(0,#ESPR+I) THEN
        ' 敵にぶつかったものとみなしして、ダメージ音を鳴らす
        BEEP 13
      ENDIF

    ENDIF

  NEXT
RETURN


'-----------------------
' スプライト座標とブロックの当たり判定を取る
' 当たっていると #TRUE をかえします
'-----------------------

DEF CHKBLOCK(X,Y)
  ' 動きたい先のスプライト座標を、テキストスクリーン1マス分の大きさである16で割って、
  ' テキストスクリーンでいうと何マス目なのかを計算する
  VAR CX=X DIV 16
  VAR CY=Y DIV 16
  ' もし、動きたい先の足元が &HE8E0(穴) の絵でなければ、#TRUE を返す
  IF CHKCHR(0,X DIV 16,Y DIV 16)!=#T_HOLE THEN
    RETURN #TRUE
  ENDIF

  RETURN #FALSE
END


'-----------------------
' 敵をあたらしく作る Sは敵の種類番号
'-----------------------

DEF ENEMYSET S,X,Y
  ' 見つかった空き番号を入れるための変数
  VAR NEWE=-1
  ' FORループ用変数(DEFの中でVAR定義すると、その中だけしか見えない「ローカル変数」になる)
  VAR I

  ' 空き番号(ES[I]に0が入っている番号)を探す
  FOR I=0 TO #EMAX-1
    IF ES[I]==0 THEN
      ' 見つかった
      NEWE=I
      ' FORループから抜ける
      BREAK
    ENDIF
  NEXT

  ' 空き番号が見つからなかったら、敵を作らない
  IF NEWE<0 THEN RETURN

  ' 敵の初期値を入れる
  ES[NEWE]=S   ' 種類
  EX[NEWE]=X   ' X座標
  EY[NEWE]=Y   ' Y座標
  EV[NEWE]=-1  ' 向き
  EW[NEWE]=0   ' 重力

  ' 敵のスプライト絵の番号(下向きの絵の番号を指定する)
  VAR PAT
  CASE S
    ' 1 スライム
    WHEN 1
      PAT=1060+2048

    ' 2 こうもり
    WHEN 2
      PAT=1040+2048
  ENDCASE

  ' 敵のスプライト初期化
  SPSET #ESPR+NEWE,PAT
  ' 敵のスプライト位置初期化
  SPOFS #ESPR+NEWE,EX[NEWE],EY[NEWE]
  ' 当たり判定の範囲を設定する。足元の中心(8,15)あたりが基準なので、それにあわせた数値にする
  SPCOL #ESPR+NEWE,-8,-16,16,16

  ' 10/60秒ごとに、今の絵の番号から +0、+1、+2、+3 とパターンをくり返し切り替えて、
  ' 歩くアニメーションをさせる
  SPANIM #ESPR+NEWE,"I+", 10,0, 10,1, 10,2, 10,3, 0
END

,Px1C'52g