      -S  "$ ほしけん                    ほしけん                    a  a                '----------------------------------------                                             
' スプライトを十字キーで動かす (右にスクロールして、マップを走れて敵も出る)
'----------------------------------------
' 画面をクリアする
ACLS

' 敵のスプライトは何番から始めるか
CONST #ESPR=10
' 一度に表示する敵の最大数
CONST #EMAX=24
' コースデータがいくつあるか
CONST #COURSEMAX=3

' ゴールのキャラクターコード
CONST #T_GOAL =&HEEC8
' コインのキャラクターコード
CONST #T_COIN =&HE88F
' ブロックのキャラクターコード
CONST #T_BLOCK=&HE95E

' ループ用変数
VAR I

' 選択したコース番号
VAR CSEL=1
' 選択したコースのBGM番号
VAR BGMNO=0
' タイム
VAR TM=0
' 最速タイム
VAR RC[#COURSEMAX]
FOR I=0 TO #COURSEMAX-1
  RC[I]=10000
NEXT

' スプライトの座標のための変数
VAR X=200
VAR Y=200
' 左右の慣性移動のための変数
VAR V=0
' ジャンプの状態管理のための変数
VAR W=0
VAR JMP=0
VAR JMPC=0
' 動きたい方向(足したい座標)を覚えておくための変数
VAR MX=0
' 絵の番号のための変数
VAR CHR=0
VAR CHR_OLD=0
' スクロールしている位置のための変数
VAR SX=0
' スクロールする量のための変数
VAR SCV=0
' マップデータ
VAR MAP$[15]
' マップデータが今どの位置にいるか
VAR MAPX=0
VAR GFLAG=0

' 敵の種類のための変数(0=いない、1〜敵の種類)
VAR ES[#EMAX]
' 敵の座標のための変数
VAR EX[#EMAX]
VAR EY[#EMAX]
' 敵の横移動量(または方向)のための変数
VAR EV[#EMAX]
' 敵の重力のための変数
VAR EW[#EMAX]

' 新しい敵の番号を受けとるための変数(新しい敵を作れなかった場合はー1)
VAR NEWE

' このコメントを解除すると、画面のはしっこに地面を足しているのが見えますよ
' LMATRIX 0,-20,0,0,0,0.9,0.9


'-----------------------
' タイトルループ
'-----------------------

@TITLE
' 画面をクリアして、文字のサイズを8にする
ACLS
TSCREEN 8
' タイトル画面の音楽を鳴らす
BGMPLAY 4

' タイトルの文字
GPUTCHR 20,50,"YOKO SCROLL SAMPLE GAME",16,1,4,#C_YELLOW
LOCATE 19,20:PRINT "PUSH  BUTTON"
LOCATE 16,27:PRINT "Presented by Hosiken"

' Aボタンが押されるまでのくり返し
WHILE BUTTON(0,#B_RRIGHT,2)==0
  ' 左右ボタンでコース選択
  IF BUTTON(0,#B_LLEFT,2)  THEN CSEL=CSEL-1:BEEP 2
  IF BUTTON(0,#B_LRIGHT,2) THEN CSEL=CSEL+1:BEEP 2
  ' コースの数字が範囲外にならないように
  IF CSEL<1          THEN CSEL=1
  IF CSEL>#COURSEMAX THEN CSEL=#COURSEMAX
  ' 選択中コースや最速タイムを表示
  LOCATE 18, 2:PRINT "RECORD TIME ";RC[CSEL-1];" "*10
  LOCATE 20,17:PRINT "COURSE: ";CSEL;""
  ' 1/60秒ごとのタイミングを待つ
  VSYNC
WEND


'-----------------------
' 初期化
'-----------------------

' 画面をクリアして、文字のサイズを8にする
ACLS
TSCREEN 8
' 音楽を止める
BGMSTOP

' ゲームで使う変数初期化
TM=0
X=200:Y=200:V=0:W=0
W=0:JMP=1:JMPC=0:MX=0:GFLAG=0
CHR=0:CHR_OLD=0:SX=0:SCV=0:MAPX=0
FOR I=0 TO #EMAX-1:ES[I]=0:NEXT

' マップデータを一番下にあるDATAから読みこむ
RESTORE "@COURSE"+STR$(CSEL)
READ BGMNO
FOR I=0 TO LAST(MAP$)
  READ MAP$[I]
NEXT

' グラフィック画面に背景を描く
FOR I=0 TO 239
  GLINE 0,I,399,I,RGB(0,0,I)
NEXT

' テキストスクリーンを設定し、地面を配置する
TSCREEN 0,16,26,15
TFILL 0,0,13,25,14,#T_BLOCK

' 0番のスプライトをセット。 絵は496番(戦士右向き)にする
' 2048を足した番号は、基準点が左上ではなく、足元の中心に初期設定されている
SPSET 0,496+2048
' 当たり判定の範囲を設定する。足元の中心(8,15)あたりが基準なので、それにあわせた数値にする
SPCOL 0,-8,-15,16,16


'-----------------------
' メインループ
'-----------------------

LOOP
  ' スクロール処理
  GOSUB @SCROLL
  ' 自分の移動
  GOSUB @MYMOVE
  ' 敵の移動
  GOSUB @ENEMYMOVE

  ' タイムが0のときはカウントダウンを始める
  IF TM==0 THEN GOSUB @START
  ' ゲームオーバーフラグがたっているなら、ゲームオーバー表示をしてタイトルへ
  IF GFLAG==-1 THEN GOSUB @GAMEOVER:GOTO @TITLE
  ' ゴールしたフラグがたっているなら、ゴールの表示をしてタイトルへ
  IF GFLAG==1  THEN GOSUB @GOAL:GOTO @TITLE

  ' タイムをふやして左上に表示する
  INC TM
  LOCATE 1,1:PRINT "TIME ";TM

  ' 1/60秒ごとのタイミングを待つ
  VSYNC
ENDLOOP


'-----------------------
' ゲームスタート カウントダウン
'-----------------------

@START
  ' スタートの音楽
  BEEP 109

  ' READY 3,2,1 のカウントダウンをする
  FOR I=3 TO 1 STEP -1
    LOCATE 22,20
    PRINT "READY ";I
    BEEP:WAIT 60
  NEXT

  ' カウント表示を消す
  LOCATE 22,20
  PRINT " "*10
  ' 音楽を開始する
  BGMPLAY BGMNO
RETURN


'-----------------------
' ゲームオーバー
'-----------------------

@GAMEOVER
  ' 音楽を止める
  BGMSTOP
  ' 主人公をびっくりの絵にする
  SPSTOP 0
  SPCHR 0,468+2048

  ' 少し待って、ゲームオーバーの音楽を流す
  WAIT 60
  BGMPLAY 6
  ' ゲームオーバー表示
  LOCATE 20,14
  PRINT "GAME OVER"
  ' ボタンを押し待ち
  WHILE BUTTON(0,-1,2)==0:WEND
  ' タイトル画面でボタンを押したことにならないよう、一瞬だけ待つ
  WAIT 2
RETURN


'-----------------------
' ゴール
'-----------------------

@GOAL
  ' 文字が読みやすくなるよう、黒くて半透明のスプライト(大きさ400X116)を下に用意する
  SPSET 1, 0,0, 400,116
  ' 表示位置。表示の優先順位をー10(0よりも手前)にする
  SPOFS 1,0,100,-10
  ' スプライトの画像ページをー1にする。ー1は常に真っ白な画像で、色を変えていろいろな使い方ができて便利
  SPPAGE 1,-1
  ' 色を透明度128/255の黒色にする
  SPCOLOR 1,RGB(128,0,0,0)

  ' ゴールの音楽を鳴ら子
  BGMPLAY 5
  ' ゴール表示とタイム表示をする
  LOCATE 22,14
  PRINT "GOAL!!"
  WAIT 60
  LOCATE 16,18
  PRINT "  YOUR TIME : ";TM
  LOCATE 16,20
  PRINT "RECORD TIME : ";RC[CSEL-1]

  ' もし、タイムがそのコースの 最速タイムを上回ったときは
  IF TM<RC[CSEL-1] THEN
    ' 最速タイムを更新する
    RC[CSEL-1]=TM
    ' 音を鳴らしてベスト表示をする
    BEEP 32
    LOCATE 16,24
    PRINT "SET A NEW RECORD !"
  ENDIF
  ' ボタンを押し待ち
  WHILE BUTTON(0,-1,2)==0:WEND
  ' タイトル画面でボタンを押したことにならないよう、一瞬だけ待つ
  WAIT 2
RETURN


'-----------------------
' 自プレイヤーの移動処理
'-----------------------

@MYMOVE
  ' 直前の絵の番号を覚えておく
  CHR_OLD=CHR

  ' 方向キーが押されたら、押された方向に動く (変数MXに動きたい量を入れる)
  ' さらに、変数 CHR に、向きに応じた絵の番号を入れておく
  MX=0
  IF BUTTON(0,#B_LLEFT)  THEN MX=-0.2:CHR=504:MOVE=1
  IF BUTTON(0,#B_LRIGHT) THEN MX= 0.2:CHR=496:MOVE=1

  ' ジャンプ中ではないとき
  IF JMP==0 THEN
    ' Aボタンが押されたら、ジャンプする
    IF BUTTON(0,#B_RRIGHT,2) THEN
      ' ジャンプの効果音を鳴らす
      BEEP 8
      ' ジャンプ中であることを示す1
      JMP=1
      ' この時間の間、ボタンを押し続けるとよりジャンプがのびる
      JMPC=12
      ' 上にうきあがる、または下に落ちる重力
      W=-5
    ENDIF
  ' ジャンプ中で、さらにボタンを押し続けられるカウントがまだあるとき
  ELSEIF JMPC>0 THEN
    ' Aボタンが押し続けてられていたら
    IF BUTTON(0,#B_RRIGHT,0) THEN
      ' ボタンを押し続けられるカウントを減らす
      DEC JMPC
      ' 上にうきあがる、または下に落ちる重力
      W=-5
    ' Aボタンが押されていないとき
    ELSE
      ' ボタンを押し続けられるカウントを0にする
      JMPC=0
    ENDIF
  ENDIF

  ' もし、ボタンが押されたことで、絵の番号(変数CHR)が変化したときは
  IF CHR_OLD!=CHR THEN
    ' 変化した絵の番号を、0番のスプライトに反映する
    ' 2048を足した番号は、基準点が左上ではなく、足元の中心に初期設定されている
    SPCHR 0,CHR+2048

    ' 4/60秒ごとに、今の絵の番号から +0、+1、+2、+3 とパターンをくり返し切り替えて、
    ' 歩くアニメーションをさせる
    SPANIM 0,"I+", 4,0, 4,1, 4,2, 4,3, 0
  ENDIF

  'どちらかに動こうとしているとき
  IF MX!=0 THEN
    ' 歩くアニメーションを開始、またはつづける
    SPSTART 0
    ' 左右の慣性に動きたい量をプラスする
    INC V,MX
  ELSE
    ' 歩くアニメーションを止める
    SPSTOP 0
    ' 左右の慣性を減らす
    V=V*0.8
  ENDIF

  ' 下方向に重力をかける
  W=W+0.4

  ' 慣性が一定以上を超えないようにする
  IF V>3.0  THEN V=3.0
  IF V<-3.0 THEN V=-3.0

  ' 重力が一定以上を超えないようにする
  IF W>6.0  THEN W=6.0

  ' 右方向の壁当たり判定判定
  IF CHKBLOCK(X+8,Y-8) THEN
    ' 右方向の壁に当たっているので、左にはじく
    DEC X,1
    ' 壁の方向に慣性がある場合は、慣性を解除する
    IF V>0 THEN V=0
  ENDIF

  ' 左方向の壁当たり判定判定
  IF CHKBLOCK(X-8,Y-8) THEN
    ' 左方向の壁に当たっているので、右にはじく
    INC X,1
    ' 壁の方向に慣性がある場合は、慣性を解除する
    IF V<0 THEN V=0
  ENDIF

  ' 慣性に応じて座標を動かす
  INC X,V
  INC Y,W

  ' 地面への着地の判定
  IF CHKBLOCK(X,Y) THEN
    ' 地面に着地しているので、位置調整してジャンプを解除する
    Y=(Y DIV 16)*16
    JMP=0
    W=0
  ELSE
    ' 地面になにもないので、ジャンプ中と同じ状態にする
    JMP=1
  ENDIF

  ' 天井への頭ぶつけ判定
  IF CHKBLOCK(X,Y-12) THEN
    ' 頭をぶつけたので、位置調整して、その場から落ちるようにする
    Y=(((Y-12) DIV 16)+2)*16
    W=0
    JMPC=0
  ENDIF

  ' ゴールやコインの判定
  CASE CHKCHR(0,(X-SX) DIV 16,(Y-8) DIV 16)
    ' ゴール
    WHEN #T_GOAL
      GFLAG=1

    ' コイン(取るとタイムが5おとく)
    WHEN #T_COIN
      ' 音を馴らす
      BEEP 7
      ' タイムを5減らすが、0未満にはしない
      DEC TM,5
      IF TM<0 THEN TM=0
      ' コインがあった場所を消す
      TPUT 0,(X-SX) DIV 16,(Y-8) DIV 16,0
  ENDCASE

  ' 画面の左右からはみ出さないようにする
  IF X<8   THEN X=8
  IF X>391 THEN X=391
  IF Y>240 THEN GFLAG=-1

  ' スプライト座標を設定
  SPOFS 0,X,Y
RETURN


'-----------------------
' スクロールの処理
'-----------------------

@SCROLL
  ' スクロールする量
  SCV=0
  ' 画面の真ん中より右にいる場合、その分だけスクロールする
  IF X>200 THEN SCV=X-200
  ' テキストスクリーンを左にスクロール
  DEC SX,SCV

  ' スクロールにあわせて、スプライト座標も動かす
  DEC X,SCV
  FOR I=0 TO #EMAX-1
    IF ES[I]!=0 THEN
      DEC EX[I],SCV
    ENDIF
  NEXT

  ' スクロールが1マス分動いたら
  IF SX<=-16 THEN
    ' 座標を戻す
    INC SX,16
    ' テキストスクリーン全体の中身を左に1マスずらす
    SCROLL 0,1,0

    ' 右端の各段ごとにマップデータを見てみる
    FOR I=0 TO LAST(MAP$)
      ' マップのちょうど右端のときは、ゴールを設置する
      IF MAPX==LEN(MAP$[0]) THEN
        TPUT 0,25,I,#T_GOAL
        CONTINUE
      ENDIF
      ' マップデータの右端を超えた分は何も設置しない
      IF MAPX>LEN(MAP$[0]) THEN
        CONTINUE
      ENDIF

      ' [MAPX]は左から何マス目、[I]は上からマス目かが入っている
      CASE MAP$[I][MAPX]

        ' 右端に壁を生成する
        WHEN "H"
          TPUT 0,25,I,#T_BLOCK

        ' 右端にコインを生成する
        WHEN "O"
          COLOR 0,#C_YELLOW
          TPUT 0,25,I,#T_COIN
          COLOR 0,#C_WHITE

        ' 敵を生成する
        WHEN "1"
        WHEN "2"
        WHEN "3"
        WHEN "4"
          ENEMYSET VAL(MAP$[I][MAPX]),25*16+SX+8,I*16+16

      ENDCASE

    NEXT

    ' マップデータを1マス進める
    INC MAPX
  ENDIF

  ' テキストスクリーンの座標を設定
  TOFS 0,SX,0
RETURN


'-----------------------
' 敵の処理
'-----------------------

@ENEMYMOVE
  ' 最大の敵の数まで処理する
  FOR I=0 TO #EMAX-1

    ' もし、指定番号の敵が存在している (ES[I]に敵の種類が入っている) なら
    IF ES[I]!=0 THEN

      ' 敵の種類によって処理を変える
      CASE ES[I]

        ' まっすぐとんでくる幽霊
        WHEN 1
          ' まっすぐすすむ
          DEC EX[I],2

        ' 歩いてくるスライム
        WHEN 2
          ' 歩く
          INC EX[I],0.5*EV[I]
          ' 重力
          INC EW[I],0.2
          INC EY[I],EW[I]

          ' 敵とブロックとの当たり判定
          GOSUB @ENEMYKABE

        ' 空中でうごかないコウモリ
        WHEN 3
          DUMMY=0

        ' 歩いてくるロボ
        WHEN 4
          ' 歩く
          INC EX[I],0.5*EV[I]
          ' 重力
          INC EW[I],0.2
          INC EY[I],EW[I]

          ' 敵とブロックとの当たり判定
          GOSUB @ENEMYKABE

          ' 歩いている先に穴がある場合は
          IF EW[I]==0.0 && !CHKBLOCK(EX[I]+EV[I]*2.0,EY[I]+1) THEN
            ' 逆向きにする
            EV[I]=-EV[I]
          ENDIF

      ENDCASE

      ' 敵のスプライト座標をセット
      SPOFS #ESPR+I,EX[I],EY[I]

      ' 敵の向きを動いている方向に変える (SPSCALE をマイナスにすると、絵が反対向きになる)
      SPSCALE #ESPR+I,SGN(EV[I]),1

      ' 画面外に出たとき
      IF EX[I]<-16 || EX[I]>420 || EY[I]>240 THEN
        ' 敵を消す
        SPCLR #ESPR+I
        ES[I]=0
      ENDIF

      ' 敵が自分と当たった場合
      IF SPHITSP(0,#ESPR+I) THEN
        ' もし、自分が敵よりも高い位置にいたなら
        IF Y<EY[I] THEN
          ' 敵が踏まれたものとみなして、敵を消す
          SPCLR #ESPR+I
          ES[I]=0

          ' 自分は少しジャンプする
          W=-3.0
          JMP=1
          JMPC=5

          ' 敵を倒した効果音を鳴らす
          BEEP 11
        ELSE
          ' 敵にぶつかったものとみなしして、ダメージ音を鳴らす
          BEEP 13
          ' ゲームオーバーのフラグをたてる
          GFLAG=-1
        ENDIF
      ENDIF

    ENDIF

  NEXT
RETURN


@ENEMYKABE
  ' 地面への着地の判定
  IF CHKBLOCK(EX[I],EY[I]) THEN
    ' 地面に着地している
    EY[I]=(EY[I] DIV 16)*16
    EW[I]=0
  ENDIF

  ' 右方向の壁当たり判定判定
  IF CHKBLOCK(EX[I]+8,EY[I]-8) THEN
    ' 右方向の壁に当たっているので、左にはじく
    DEC EX[I],1
    ' 壁の方向に移動していた場合は、逆向きにする
    IF EV[I]>0 THEN EV[I]=-EV[I]
  ENDIF

  ' 左方向の壁当たり判定判定
  IF CHKBLOCK(EX[I]-8,EY[I]-8) THEN
    ' 左方向の壁に当たっているので、右にはじく
    INC EX[I],1
    ' 壁の方向に移動していた場合は、逆向きにする
    IF EV[I]<0 THEN EV[I]=-EV[I]
  ENDIF
RETURN


'-----------------------
' 敵をあたらしく作る Sは敵の種類番号
'-----------------------

DEF ENEMYSET S,X,Y
  ' 見つかった空き番号を入れるための変数
  VAR NEWE=-1
  ' FORループ用変数(DEFの中でVAR定義すると、その中だけしか見えない「ローカル変数」になる)
  VAR I

  ' 空き番号(ES[I]に0が入っている番号)を探す
  FOR I=0 TO #EMAX-1
    IF ES[I]==0 THEN
      ' 見つかった
      NEWE=I
      ' FORループから抜ける
      BREAK
    ENDIF
  NEXT

  ' 空き番号が見つからなかったら、敵を作らない
  IF NEWE<0 THEN RETURN

  ' 敵の初期値を入れる
  ES[NEWE]=S   ' 種類
  EX[NEWE]=X   ' X座標
  EY[NEWE]=Y   ' Y座標
  EV[NEWE]=-1  ' 向き
  EW[NEWE]=0   ' 重力

  ' 敵のスプライト絵の番号(右向きの絵の番号を指定する)
  VAR PAT
  CASE S
    ' 1 幽霊
    WHEN 1
      PAT=1016+2048

    ' 2 スライム
    WHEN 2
      PAT=1056+2048

    ' 3 こうもり
    WHEN 3
      PAT=1036+2048

    ' 4 ロボ
    WHEN 4
      PAT=956+2048
  ENDCASE

  ' 敵のスプライト初期化
  SPSET #ESPR+NEWE,PAT
  ' 敵のスプライト位置初期化
  SPOFS #ESPR+NEWE,EX[NEWE],EY[NEWE]
  ' 当たり判定の範囲を設定する。足元の中心(8,15)あたりが基準なので、それにあわせた数値にする
  SPCOL #ESPR+NEWE,-8,-16,16,16

  ' 8/60秒ごとに、今の絵の番号から +0、+1、+2、+3 とパターンをくり返し切り替えて、
  ' 歩くアニメーションをさせる
  SPANIM #ESPR+NEWE,"I+", 8,0, 8,1, 8,2, 8,3, 0
END


'-----------------------
' スプライト座標とブロックの当たり判定を取る
' 当たっていると #TRUE をかえします
'-----------------------

DEF CHKBLOCK(X,Y)
  ' 壁当たり判定 (スクロールによる座標のずれ分は、ここで考慮する)
  ' スプライトの座標を、テキストスクリーンの何マス目に変換する
  VAR TX=(X-SX) DIV 16
  VAR TY=Y DIV 16

  ' テキストスクリーンのその場所にブロックがあるか確認する
  IF CHKCHR(0,TX,TY)==#T_BLOCK THEN
    RETURN #TRUE
  ENDIF

  RETURN #FALSE
END


' マップデータ。書き足して、横に伸ばすことができます
' Insertキーを押して、上書きモードにして編集すると便利です
@COURSE1
DATA 0  'BGM
DATA "                                                               "
DATA "                                                               "
DATA "                                                           2   "
DATA "                        OOOOOO    OO                       HH  "
DATA "                                  HH                     2HHH  "
DATA "      OO        OOO            OO       OOO  1OOO 1      HHHH  "
DATA "     O  O       OOO     1      HH                      2HHHHH  "
DATA "                            OO    OO     2      2      HHHHHH 1"
DATA "          2                 HH    HH   H H    H H     HHHHHHH 1"
DATA "  HHH    HHH   2      1  2     OO      HHH    HHH    HHHHHHHH 1"
DATA "             2HH  HH     HH    HH            2      HHHHHHHHH 1"
DATA "      HH     HHH  HHH                      H H     HHHHHHHHHH  "
DATA "H   2 HH    HHHH  HHHH                  4  HHH   4HHHHHHHHHHH  "
DATA "HHHHHHHHHHHHHHHH  HHHHHHHHHH         HHHHH HHH HHHHHHHHHHHHHHHH"
DATA "HHHHHHHHHHHHHHHH  HHHHHHHHHH         HHHHH HHH HHHHHHHHHHHHHHHH"

@COURSE2
DATA 14 'BGM
DATA "                                                               "
DATA "                                                               "
DATA "                                                               "
DATA "                                                          OO   "
DATA "                                                        OO     "
DATA "                                                    OO         "
DATA "                              OOO  OOO  OOO  OOO  OO       3   "
DATA "                        OO                              3      "
DATA "                   OO  O                             3         "
DATA "    O O O O       O       OO  3  3   3   3   O   3             "
DATA "                      3   HH                 H                 "
DATA "                 3        HH                                   "
DATA "   3   3    OO            HH                                   "
DATA "            HH            HH                                   "
DATA "            HH            HH                                   "

@COURSE3
DATA 13 'BGM
DATA "HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH         HHH          "
DATA "HH        HHHH     HHHHHHHHHHHHH     OOOO   HH    1   2 1"
DATA "H  HHHHH   HHH  HH    HHHHHHHHH         2   H     1  2  1"
DATA "H       H    H   HHHH HHHHHHHHH     HHHHH  HH  OOO1  HH  "
DATA "H HHHH  H O  HH  H   OHHHHHHHHH  OOO    H1    OOOO  HHH  "
DATA "HH      H O  H1  H  OHHHHHHHHHH 4      3H1   OOOO  HHHH  "
DATA "H  OOOO H O  H 1 H OH          HHH      H    OOO  HHHHH  "
DATA "H  HHHHH  O  H  1HOH              HHH   H    1   HHHHHH 1"
DATA "H      H  O     H OH   1 O 3         H H     1  HHHHHHH 1"
DATA "HOHHH  H  O     H OH   1  O            HHHH  1 HHHHHHHH 1"
DATA "HHHHH  H  O   HH  HH   H   O O O O O 1 H1 2   HHHHHHHHH 1"
DATA "      HH     HHH  HH    H    O O O O  H      HHHHHHHHHH  "
DATA "    2 HH  2 HHHH   H    H  4 O O O O 1H 1  2HHHHHHHHHHH  "
DATA "HHHHHHHHHHHHHHH  OOO4   HHHH H H H H HHHHH HHHHHHHHHHHH  "
DATA "HHHHHHHHHHHHHHHH HHHHHHHHHHH         HHHHH HHHHHHHHHHHH  "

D(s'Ǟ5ijt