        (いもいも                    いもいも                                    '**************************************************************************
' INFINITY MAZE
'  PROGRAMMED BY IMOIMO
'**************************************************************************

OPTION STRICT
OPTION DEFINT
ON BREAK GOTO @ENDPROC

'**************************************************************************
'** 定数定義
'**************************************************************************
CONST #SCR_WIDTH=400
CONST #SCR_HEIGHT=240

CONST #SRL_START=28
CONST #SRL_SPEED=1
CONST #SRL_SPEED_MAX=12
CONST #SRL_INTERVAL=60

CONST #BM_WIDTH=25
CONST #BM_HEIGHT=16
CONST #BM_PHEIGHT=15

CONST #RNG_WIDTH=19
CONST #RNG_HEIGHT=49

CONST #NXT_LEFT=314
CONST #NXT_TOP=168
CONST #NXT_OFFSET=14
CONST #NXT_HEIGHT=16
CONST #NXT_HIDE=0

CONST #UI_WIDTH=50
CONST #UI_HEIGHT=31

CONST #MAP_WIDTH=19
CONST #MAP_HEIGHT=17
CONST #MAP_AHEIGHT=14
CONST #MAP_STARTX=9
CONST #MAP_STARTY=15

CONST #START_X=144
CONST #START_Y=192
CONST #START_H=5

CONST #MY_SPEED=1
CONST #MY_YLIMIT=31
CONST #MY_ATKCNT=20
CONST #MY_USECNT=20

CONST #CHR_SIZE=16
CONST #CHR_TBOX=1728
CONST #CHR_OPEN=1729

CONST #AREA_LENGTH=3

CONST #TB_RNDMAX=256
CONST #TB_RND=200

CONST #ST_HP=3
CONST #ST_SPD=1
CONST #ST_SCR=1

CONST #SKY_COLOR=255

CONST #SP_IVT=20
CONST #SP_ENM=30
CONST #SP_STAR=50
CONST #SP_EFFECT=100

CONST #SP_BTS_LEFT=344
CONST #SP_TMR_LEFT=368
CONST #SP_HRT_LEFT=320

CONST #ANM_E0= 5
CONST #ANM_E1=10
CONST #ANM_E2=15
CONST #ANM_E3=20
CONST #ANM_E4=25
CONST #ANM_E5=30
CONST #ANM_ED=35
CONST #ANM_FB=40
CONST #ANM_WB=45
CONST #ANM_PI=50

CONST #IVT_MAX=5

CONST #STAR_MAX=50

CONST #ENEMY_MAX=10

CONST #EFFECT_MAX=100


CONST #BGM_TIMER=30

CONST #SCROLL_TIMER=1800

CONST #BOOTS_TIMER=3600

CONST #INV_TIMER=180

CONST #BEEP_WAIT=15

CONST #STK_BDR=0.5

CONST #KEY_BDR=6

CONST #MUTEKI=0

CONST #GC_FLOOR=&HFF000080
CONST #GC_WALL=&HFF408850
CONST #GC_TRESURE=&HFFAAAA00
CONST #GC_TEMPTY=&HFF666600
CONST #GC_VISITED=&HFF0000FF

CONST #BTN_UP=1<<#B_LUP
CONST #BTN_DOWN=1<<#B_LDOWN
CONST #BTN_LEFT=1<<#B_LLEFT
CONST #BTN_RIGHT=1<<#B_LRIGHT
CONST #BTN_A=1<<#B_RRIGHT
CONST #BTN_B=1<<#B_RDOWN
CONST #BTN_X=1<<#B_RUP
CONST #BTN_Y=1<<#B_RLEFT
CONST #BTN_L=1<<#B_L1
CONST #BTN_R=1<<#B_R1
CONST #BTN_ZL=1<<#B_L2
CONST #BTN_ZR=1<<#B_R2

ENUM #V_L,#V_R,#V_U,#V_D
ENUM #SP_MYC,#SP_CSL,#SP_WPN,#SP_PIT,#SP_ITM
ENUM #SP_HRT=10,#SP_BTS,#SP_TMR,#SP_BTH,#SP_TMH
ENUM #ITM_MONEY,#ITM_BOOTS,#ITM_TIMER,#ITM_HEART,#ITM_MATOK,#ITM_FB
ENUM #MAP_FLOOR,#MAP_WALL,#MAP_TBOX,#MAP_TEMPTY,#MAP_VISITED
ENUM #MAP_INIT,#MAP_APPEND
ENUM #BG_MAP,#BG_OVL,#BG_UI,#BG_WIN

'**************************************************************************
'** 変数定義
'**************************************************************************
VAR SC,HS

' 迷路データ作成用
DIM MZ[#MAP_WIDTH,#MAP_HEIGHT]
' 表示データ格納用
DIM RB[#RNG_WIDTH,#RNG_HEIGHT]
' 迷路データ格納用
DIM FL[#RNG_WIDTH,#RNG_HEIGHT]

' 迷路キャラクタ(床)
DIM FR[]=[ 195, 201, 201, 216, 216, 216, 205, 205, 583, 654, 722,1166]
' 迷路キャラクタ(壁)
DIM WL[]=[ 196, 202, 203, 218, 217, 280, 208, 209,1050,1547,3864,   0]

' エリア毎のBGM
DIM BG[]=[   9,   9,   9,  14,  14,  14,  15,  15,  15,  25,  25,  39]

' エリア毎の敵INDEX
DIM EI[]=[   0,   0,   0,   1,   1,   1,   2,   2,   2,   3,   4,   5]

' アイテム表示用キャラクタ
DIM ITC[]=[ 110, 184, 111, 222, 112,1490]
' マトック表示用キャラクタ
DIM MTC[]=[ 115, 113, 112, 114]
' インベントリスタック
DIM IV[0]

' 主人公キャラアクション
DIM AMC[]=[466,464,467,465]
' 武器キャラクタ
DIM AWC[]=[147,145,144,146]

' 敵やられキャラクタ
DIM ENC[]=[1074, 994,1034,1054, 934, 974]

' 移動方向
DIM VVX[]=[-1,1,0,0],VVY[]=[0,0,-1,1]

'**************************************************************************
'** エントリポイント
'**************************************************************************

ACLS
XSCREEN #SCR_WIDTH,#SCR_HEIGHT,2
RANDOMIZE 0

MAINPROC

'**************************************************************************
'** DEF定義
'**************************************************************************

DEF ANIM_INIT
 '主人公
 ANIMDEF #V_L        ,"I",15, 504,15, 505,15, 506,15, 507,0
 ANIMDEF #V_R        ,"I",15, 496,15, 497,15, 498,15, 499,0
 ANIMDEF #V_U        ,"I",15, 508,15, 509,15, 510,15, 511,0
 ANIMDEF #V_D        ,"I",15, 500,15, 501,15, 502,15, 503,0
 '敵0
 ANIMDEF #V_L+#ANM_E0,"I",15,1064,15,1065,15,1066,15,1067,0
 ANIMDEF #V_R+#ANM_E0,"I",15,1056,15,1057,15,1058,15,1059,0
 ANIMDEF #V_U+#ANM_E0,"I",15,1068,15,1069,15,1070,15,1071,0
 ANIMDEF #V_D+#ANM_E0,"I",15,1060,15,1061,15,1062,15,1063,0
 '敵1
 ANIMDEF #V_L+#ANM_E1,"I",15, 984,15, 985,15, 986,15, 987,0
 ANIMDEF #V_R+#ANM_E1,"I",15, 976,15, 977,15, 978,15, 979,0
 ANIMDEF #V_U+#ANM_E1,"I",15, 988,15, 989,15, 990,15, 991,0
 ANIMDEF #V_D+#ANM_E1,"I",15, 980,15, 981,15, 982,15, 983,0
 '敵2
 ANIMDEF #V_L+#ANM_E2,"I",15,1024,15,1025,15,1026,15,1027,0
 ANIMDEF #V_R+#ANM_E2,"I",15,1016,15,1017,15,1018,15,1019,0
 ANIMDEF #V_U+#ANM_E2,"I",15,1028,15,1029,15,1030,15,1031,0
 ANIMDEF #V_D+#ANM_E2,"I",15,1020,15,1021,15,1022,15,1023,0
 '敵3
 ANIMDEF #V_L+#ANM_E3,"I",15,1044,15,1045,15,1046,15,1047,0
 ANIMDEF #V_R+#ANM_E3,"I",15,1036,15,1037,15,1038,15,1039,0
 ANIMDEF #V_U+#ANM_E3,"I",15,1048,15,1049,15,1050,15,1051,0
 ANIMDEF #V_D+#ANM_E3,"I",15,1040,15,1041,15,1042,15,1043,0
 '敵4
 ANIMDEF #V_L+#ANM_E4,"I",15, 924,15, 925,15, 926,15, 927,0
 ANIMDEF #V_R+#ANM_E4,"I",15, 916,15, 917,15, 918,15, 919,0
 ANIMDEF #V_U+#ANM_E4,"I",15, 928,15, 929,15, 930,15, 931,0
 ANIMDEF #V_D+#ANM_E4,"I",15, 920,15, 921,15, 922,15, 923,0
 '敵5
 ANIMDEF #V_L+#ANM_E5,"I",15, 964,15, 965,15, 966,15, 967,0
 ANIMDEF #V_R+#ANM_E5,"I",15, 956,15, 957,15, 958,15, 959,0
 ANIMDEF #V_U+#ANM_E5,"I",15, 968,15, 969,15, 970,15, 971,0
 ANIMDEF #V_D+#ANM_E5,"I",15, 960,15, 961,15, 962,15, 963,0
 '敵やられエフェクト
 SPDEF 1530,   0, 128,16,16,3
 SPDEF 1531,  16, 128,16,16,3
 SPDEF 1532,  32, 128,16,16,3
 SPDEF 1533,  48, 128,16,16,3
 SPDEF 1534,   0, 128,16,16,1
 SPDEF 1535,  16, 128,16,16,1
 SPDEF 1536,  32, 128,16,16,1
 SPDEF 1537,  48, 128,16,16,1
 SPDEF 1538,   0, 128,16,16,2
 SPDEF 1539,  16, 128,16,16,2
 SPDEF 1540,  32, 128,16,16,2
 SPDEF 1541,  48, 128,16,16,2
 ANIMDEF #V_L+#ANM_ED,"I.",5,1530,5,1531,5,1532,5,1533
 ANIMDEF #V_R+#ANM_ED,"I.",5,1534,5,1535,5,1536,5,1537
 ANIMDEF #V_U+#ANM_ED,"I.",5,1364,5,1365,5,1366,5,1367
 ANIMDEF #V_D+#ANM_ED,"I.",5,1538,5,1539,5,1540,5,1541
 'ファイアボール(インベントリ)
 SPDEF 1490, 160,  48,16,16,1
 'ファイアボール
 SPDEF 1510, 416, 472, 8,16,3
 SPDEF 1511, 424, 472, 8,16,3
 SPDEF 1512, 432, 472, 8,16,3
 SPDEF 1513, 440, 472, 8,16,3
 SPDEF 1514, 416, 472, 8,16,1
 SPDEF 1515, 424, 472, 8,16,1
 SPDEF 1516, 432, 472, 8,16,1
 SPDEF 1517, 440, 472, 8,16,1
 SPDEF 1518, 416, 472, 8,16,2
 SPDEF 1519, 424, 472, 8,16,2
 SPDEF 1520, 432, 472, 8,16,2
 SPDEF 1521, 440, 472, 8,16,2
 ANIMDEF #V_L+#ANM_FB,"I",5,1510,5,1511,5,1512,5,1513,0
 ANIMDEF #V_R+#ANM_FB,"I",5,1514,5,1515,5,1516,5,1517,0
 ANIMDEF #V_U+#ANM_FB,"I",5,1310,5,1311,5,1312,5,1313,0
 ANIMDEF #V_D+#ANM_FB,"I",5,1518,5,1519,5,1520,5,1521,0
 'アイテムポップ
 ANIMDEF #ANM_PI,"C.",1,&H00FFFFFF,-30,&HFFFFFFFF,40,&HFFFFFFFF,-30,&H00FFFFFF
 '壁破壊エフェクト
 ANIMDEF #ANM_WB,"I.",6,1376,6,1377,6,1378,6,1379
END

' TVAR初期化処理
DEF TVAR_INIT
 TVAR #BG_MAP,"TXT_Y",-15
 TVAR #BG_MAP,"CNT",1
 TVAR #BG_MAP,"STG",0
 TVAR #BG_MAP,"EN",0
 TVAR #BG_MAP,"EC",0
 TVAR #BG_MAP,"BGM",BG[0]
 TVAR #BG_MAP,"VOL",0
 TVAR #BG_MAP,"SKY",#SKY_COLOR
 TVAR #BG_MAP,"SF",0
 TVAR #BG_MAP,"SPEED",#SRL_SPEED
 TVAR #BG_MAP,"STIME",#SCROLL_TIMER
 TVAR #BG_MAP,"INTERVAL",#SRL_INTERVAL
 TVAR #BG_MAP,"MAP_Y",#SRL_START+#START_H
 TVAR #BG_MAP,"MAP_Y_CUR",#SRL_START
 TVAR #BG_MAP,"MAP_Y_NEXT",0
END

' スプライト初期化処理
DEF SPRITE_INIT
 VAR I

 SPCLR
 SPSET #SP_MYC,508
 SPANIM #SP_MYC,#V_U
 SPOFS #SP_MYC,#START_X,#START_Y
 SPCOL #SP_MYC,7,7,2,2
 SPSET #SP_CSL,298
 SPOFS #SP_CSL,312,120,-16
 SPCOLOR #SP_CSL,&HAAFFFFFF
 SPSET #SP_WPN,32,0
 SPCOL #SP_WPN
 SPSET #SP_ITM,32,0
 SPFUNC #SP_ITM,"MOVE_FB"
 SPSET #SP_HRT,222
 SPOFS #SP_HRT,#SP_HRT_LEFT,88,9
 SPCOLOR #SP_HRT,&HCCFFFFFF
 SPSET #SP_BTS,184
 SPOFS #SP_BTS,#SP_BTS_LEFT,88,9
 SPSET #SP_BTH,0,0,#CHR_SIZE,#CHR_SIZE
 SPPAGE #SP_BTH,-1
 SPOFS #SP_BTH,#SP_BTS_LEFT,88,8
 SPCOLOR #SP_BTH,&H80000000
 SPSET #SP_TMR,111
 SPOFS #SP_TMR,#SP_TMR_LEFT,88,9
 SPSET #SP_TMH,0,0,#CHR_SIZE,#CHR_SIZE
 SPPAGE #SP_TMH,-1
 SPOFS #SP_TMH,#SP_TMR_LEFT,88,8
 SPCOLOR #SP_TMH,&H80000000
 FOR I=0 TO #IVT_MAX-1
  SPSET I+#SP_IVT,32
  SPOFS I+#SP_IVT,312+I*#CHR_SIZE,120
 NEXT
END

' SPVAR初期化処理
DEF SPVAR_INIT
 'ステータス
 SPVAR #SP_MYC,"V",#V_U
 SPVAR #SP_MYC,"VX",0
 SPVAR #SP_MYC,"VY",0
 SPVAR #SP_MYC,"ST",0
 SPVAR #SP_MYC,"AF",0
 SPVAR #SP_MYC,"AT",0
 SPVAR #SP_MYC,"IF",0
 SPVAR #SP_MYC,"IT",0
 SPVAR #SP_MYC,"IM",0
 SPVAR #SP_MYC,"KT",0
 SPVAR #SP_MYC,"BW",0
 SPVAR #SP_MYC,"HP",#ST_HP
 SPVAR #SP_MYC,"SPD",#ST_SPD
 SPVAR #SP_MYC,"SCR",#ST_SCR
 SPVAR #SP_MYC,"SPT",0
 SPVAR #SP_MYC,"ITEM",0
 SPVAR #SP_MYC,"IMAX",0
 'アイテム用
 SPVAR #SP_ITM,"FB",0
 SPVAR #SP_ITM,"VX",0
 SPVAR #SP_ITM,"VY",0
 'プレビュー用
 SPVAR #GSPRITE,"BL",255
 SPVAR #GSPRITE,"BV",-2
END

' 画面初期化
DEF SCREEN_INIT
 VAR I

 CLS:CLS 0:CLS 1:CLS 2:CLS 3:GCLS
 COLOR #BG_MAP,#C_WHITE
 TSCREEN #BG_MAP,#CHR_SIZE,#CHR_SIZE,#BM_WIDTH,#BM_HEIGHT
 TSCREEN #BG_OVL,#CHR_SIZE,#CHR_SIZE,#BM_WIDTH,#BM_HEIGHT
 TSCREEN #BG_UI,#CHR_SIZE,8,#UI_WIDTH,#UI_HEIGHT
 TSCREEN #BG_WIN,#CHR_SIZE,8,#UI_WIDTH,#UI_HEIGHT
 TOFS #BG_MAP,0,-#CHR_SIZE,1
 TOFS #BG_OVL,0,0,0
 TOFS #BG_UI,0,0,-255
 TOFS #BG_WIN,0,0,-254
 SET_START
 MAZE_MAKE #MAP_INIT
 SET_MAZE #SRL_START,1,#BM_HEIGHT,0
 MAZE_MAKE #MAP_APPEND
 SET_MAZE #MAP_AHEIGHT,1,#BM_PHEIGHT,0
 SET_START
 PRINT_RB #SRL_START+#START_H
 COLOR #BG_UI,#C_MAROON
 FOR I=0 TO #UI_HEIGHT-1
  LOCATE #BG_UI,38,I:TPRINT #BG_UI,"";
 NEXT
 COLOR #BG_UI,#C_CYAN
 LOCATE #BG_UI,39,1:TPRINT #BG_UI,BG_STR$("INFINITY")+"  "
 COLOR #BG_UI,#C_WHITE
 LOCATE #BG_UI,39,2:TPRINT #BG_UI,"      "+BG_STR$("MAZE")
 COLOR #BG_UI,#C_WHITE
 LOCATE #BG_UI,39,10:TPRINT #BG_UI,BG_STR$("STATUS")+"    "
 LOCATE #BG_UI,39,11:TPRINT #BG_UI,"          "
 LOCATE #BG_UI,39,12:TPRINT #BG_UI,"          "
 COLOR #BG_UI,#C_YELLOW
 LOCATE #BG_UI,39,14:TPRINT #BG_UI,BG_STR$("ITEM")+"      "
 LOCATE #BG_UI,39,15:TPRINT #BG_UI,"          "
 LOCATE #BG_UI,39,16:TPRINT #BG_UI,"          "
 COLOR #BG_UI,#C_WHITE
 PRINT_HEART
 PRINT_TIMER
 LOCATE #BG_UI,40,20:TPRINT #BG_UI,BG_STR$("NEXTVIEW")
 FOR I=21 TO 28
  LOCATE #BG_UI,39,I:TPRINT #BG_UI,"          ";
 NEXT
 PRINT_UI
 FADE_IN 4
END

' メイン処理
DEF MAINPROC
 ANIM_INIT
 LOOP
  SC=0:RESIZE IV,0
  DRAW_TITLE
  TVAR_INIT
  SPRITE_INIT
  SPVAR_INIT
  SCREEN_INIT
  BGM_START
  LOOP
   SET_SCRSPD
   MOVE_MYCHAR
   IF CHK_COLSP() THEN BREAK
   CALL SPRITE
   SCROLL_MAZE
   IF SC>HS THEN HS=SC
   PRINT_UI
   VSYNC
  ENDLOOP
 ENDLOOP
END

' キーとスティックの状態を取得する
DEF CHK_STICK
 VAR B=BUTTON(0)
 VAR X,Y

 STICK 0 OUT X,Y
 IF B==0&&ABS(X)<#STK_BDR&&ABS(Y)<#STK_BDR THEN
  SPVAR #SP_MYC,"KT",#KEY_BDR
 ENDIF
 IF B AND #BTN_LEFT||X<=-#STK_BDR THEN
  IF SPVAR(#SP_MYC,"V")==#V_L THEN
   IF SPVAR(#SP_MYC,"KT")==0 THEN SPVAR #SP_MYC,"VX",-#CHR_SIZE
  ELSE
   SPANIM #SP_MYC,#V_L
  ENDIF
  SPVAR #SP_MYC,"V",#V_L
 ENDIF
 IF B AND #BTN_RIGHT||X>=#STK_BDR THEN
  IF SPVAR(#SP_MYC,"V")==#V_R THEN
   IF SPVAR(#SP_MYC,"KT")==0 THEN SPVAR #SP_MYC,"VX",#CHR_SIZE
  ELSE
   SPANIM #SP_MYC,#V_R
  ENDIF
  SPVAR #SP_MYC,"V",#V_R
 ENDIF
 IF SPVAR(#SP_MYC,"VX")==0 THEN
  IF B AND #BTN_UP||Y<=-#STK_BDR THEN
   IF SPVAR(#SP_MYC,"V")==#V_U THEN
    IF SPVAR(#SP_MYC,"KT")==0 THEN SPVAR #SP_MYC,"VY",-#CHR_SIZE
   ELSE
    SPANIM #SP_MYC,#V_U
   ENDIF
   SPVAR #SP_MYC,"V",#V_U
  ENDIF
  IF B AND #BTN_DOWN||Y>=#STK_BDR THEN
   IF SPVAR(#SP_MYC,"V")==#V_D THEN
    IF SPVAR(#SP_MYC,"KT")==0 THEN SPVAR #SP_MYC,"VY",#CHR_SIZE
   ELSE
    SPANIM #SP_MYC,#V_D
   ENDIF
   SPVAR #SP_MYC,"V",#V_D
  ENDIF
 ENDIF
 SPVAR #SP_MYC,"ST",0
 IF B AND #BTN_B THEN
  TVAR #BG_MAP,"INTERVAL",1
  TVAR #BG_MAP,"SPEED",#SRL_SPEED
  SPVAR #SP_MYC,"VX",0
  SPVAR #SP_MYC,"VY",0
  SPVAR #SP_MYC,"ST",1
 ENDIF
END

' スティックタイマ
DEF STICK_TIMER
 SPVAR #SP_MYC,"KT",SPVAR(#SP_MYC,"KT")-1
 IF SPVAR(#SP_MYC,"KT")<0 THEN SPVAR #SP_MYC,"KT",0
END

' トリガキーの状態を取得
DEF CHK_TRIGGER
 IF BUTTON(0,#B_RRIGHT,2)&&SPVAR(#SP_MYC,"AT")==0 THEN
  SPVAR #SP_MYC,"AF",1
 ELSEIF BUTTON(0,#B_RLEFT,2)&&SPVAR(#SP_MYC,"IT")==0 THEN
  SPVAR #SP_MYC,"IF",1
 ENDIF
 IF BUTTON(0,#B_L1,2)&&SPVAR(#SP_MYC,"ITEM")>0 THEN
  SPVAR #SP_MYC,"ITEM",SPVAR(#SP_MYC,"ITEM")-1
  BEEP 9
  SPOFS #SP_CSL,312+SPVAR(#SP_MYC,"ITEM")*#CHR_SIZE,120,-16
 ENDIF
 IF BUTTON(0,#B_R1,2)&&SPVAR(#SP_MYC,"ITEM")<LAST(IV) THEN
  SPVAR #SP_MYC,"ITEM",SPVAR(#SP_MYC,"ITEM")+1
  BEEP 9
  SPOFS #SP_CSL,312+SPVAR(#SP_MYC,"ITEM")*#CHR_SIZE,120,-16
 ENDIF
END

' 自キャラを移動させる
DEF MOVE_MYCHAR
 VAR X,Y
 
 SPOFS #SP_MYC OUT X,Y
 CHK_TRIGGER
 IF SPVAR(#SP_MYC,"IT")==0&&SPVAR(#SP_MYC,"AT")==0 THEN
  IF SPVAR(#SP_MYC,"VX")==0&&SPVAR(#SP_MYC,"VY")==0 THEN
   IF SPVAR(#SP_MYC,"AF")==1 THEN
    INIT_ATTACK
   ELSEIF SPVAR(#SP_MYC,"IF")==1 THEN
    INIT_USEITEM
   ELSE
    CHK_STICK
    CHK_COLMAP X,Y
   ENDIF
  ENDIF
 ENDIF
 STICK_TIMER
 BOOTS_UPDATE
 IF CHK_SCROLL() THEN INC Y,TVAR(#BG_MAP,"SPEED")
 IF ABS(SPVAR(#SP_MYC,"VX"))>0 THEN
  INC X,SPVAR(#SP_MYC,"SPD")*SGN(SPVAR(#SP_MYC,"VX"))
  SPVAR #SP_MYC,"VX",SPVAR(#SP_MYC,"VX")-SGN(SPVAR(#SP_MYC,"VX"))*SPVAR(#SP_MYC,"SPD")
 ENDIF
 IF ABS(SPVAR(#SP_MYC,"VY"))>0 THEN
  INC Y,SPVAR(#SP_MYC,"SPD")*SGN(SPVAR(#SP_MYC,"VY"))
  SPVAR #SP_MYC,"VY",SPVAR(#SP_MYC,"VY")-SGN(SPVAR(#SP_MYC,"VY"))*SPVAR(#SP_MYC,"SPD")
  Y=UPPER_LIMIT(Y)
 ENDIF
 UPDATE_ATTACK X,Y,VVX[SPVAR(#SP_MYC,"V")],VVY[SPVAR(#SP_MYC,"V")]
 UPDATE_USEITEM
 SPOFS #SP_MYC,X,Y
 IMMOTAL_MODE
END

' 移動範囲上端到達時の処理
DEF UPPER_LIMIT(Y)
 IF Y<#MY_YLIMIT THEN
  Y=#MY_YLIMIT
  TVAR #BG_MAP,"INTERVAL",1
  TVAR #BG_MAP,"SPEED",SPVAR(#SP_MYC,"SPD")
 ENDIF
 RETURN Y
END

' ブーツ取得時の更新処理
DEF BOOTS_UPDATE
 VAR VX=SPVAR(#SP_MYC,"VX")
 VAR VY=SPVAR(#SP_MYC,"VY")

 IF SPVAR(#SP_MYC,"SPT")>0 THEN
  SPVAR #SP_MYC,"SPT",SPVAR(#SP_MYC,"SPT")-1
  IF SPVAR(#SP_MYC,"SPT")==0 THEN SPVAR #SP_MYC,"SPD",1
  PRINT_BOOTS
  IF (MAINCNT() MOD 3==0)&&(VX!=0||VY!=0) THEN BLUR_ADD
 ENDIF
END

' 無敵状態の処理
DEF IMMOTAL_MODE
 IF SPVAR(#SP_MYC,"IM")>0 THEN
  SPVAR #SP_MYC,"IM",SPVAR(#SP_MYC,"IM")-1
  IF MAINCNT() MOD 2 > 0 THEN
   SPSHOW #SP_MYC
  ELSE
   SPHIDE #SP_MYC
  ENDIF
  IF SPVAR(#SP_MYC,"IM")==0 THEN
   SPSHOW #SP_MYC
   SPCOL #SP_MYC,0,&HFFFFFFFF
  ENDIF
 ENDIF
END

' 攻撃初期化処理
DEF INIT_ATTACK
 SPVAR #SP_MYC,"AF",0
 SPVAR #SP_MYC,"AT",#MY_ATKCNT
 SPCHR #SP_MYC,AMC[SPVAR(#SP_MYC,"V")]
 SPCHR #SP_WPN,AWC[SPVAR(#SP_MYC,"V")]
 SPSHOW #SP_WPN
 BEEP 40
END

' 攻撃更新処理
DEF UPDATE_ATTACK X,Y,VX,VY
 IF SPVAR(#SP_MYC,"AT")>0 THEN
  SPOFS #SP_WPN,X+VX*#CHR_SIZE,Y+VY*#CHR_SIZE
  SPVAR #SP_MYC,"AT",SPVAR(#SP_MYC,"AT")-1
  IF SPVAR(#SP_MYC,"AT")==0 THEN
   SPHIDE #SP_WPN
   SPANIM #SP_MYC,SPVAR(#SP_MYC,"V")
  ENDIF
 ENDIF
END

' アイテム使用初期化処理
DEF INIT_USEITEM
 SPVAR #SP_MYC,"IF",0
 IF LEN(IV)==0 THEN RETURN
 IF SPVAR(#SP_ITM,"FB")==1 THEN RETURN
 SPVAR #SP_MYC,"IT",#MY_USECNT
 SPCHR #SP_MYC,AMC[SPVAR(#SP_MYC,"V")]
 SPVAR #SP_ITM,"IC",IV[SPVAR(#SP_MYC,"ITEM")]
 CASE SPVAR(#SP_ITM,"IC")
  WHEN #ITM_MATOK
   INIT_MATOK
  WHEN #ITM_FB
   INIT_FB
 ENDCASE
END

' マトック初期化処理
DEF INIT_MATOK
 SPCHR #SP_ITM,MTC[SPVAR(#SP_MYC,"V")]
 SPCOL #SP_ITM,0,&H00000000
 SPSHOW #SP_ITM
 BEEP 40
END

' アイテム使用更新処理
DEF UPDATE_USEITEM
 VAR X,Y
 VAR V=SPVAR(#SP_MYC,"V")
 VAR VX=VVX[V]
 VAR VY=VVY[V]

 SPOFS #SP_MYC OUT X,Y
 IF SPVAR(#SP_MYC,"IT")>0 THEN
  SPVAR #SP_MYC,"IT",SPVAR(#SP_MYC,"IT")-1
  IF SPVAR(#SP_MYC,"IT")==0 THEN
   IF SPVAR(#SP_ITM,"IC")==#ITM_MATOK THEN SPHIDE #SP_ITM
   SPANIM #SP_MYC,SPVAR(#SP_MYC,"V")
  ENDIF
 ENDIF
 CASE SPVAR(#SP_ITM,"IC")
  WHEN #ITM_MATOK
   SPOFS #SP_ITM,X+VX*#CHR_SIZE,Y+VY*#CHR_SIZE
  WHEN #ITM_FB
   IF SPCHK(#SP_ITM)==0 THEN SPHIDE #SP_ITM
 ENDCASE
END

' マップの当たり判定
DEF CHK_COLMAP X,Y
 VAR FX,FY
 VAR TY=TVAR(#BG_MAP,"TXT_Y")
 VAR MY=TVAR(#BG_MAP,"MAP_Y")
 VAR VX=SPVAR(#SP_MYC,"VX")
 VAR VY=SPVAR(#SP_MYC,"VY")
 
 GETRBLOC X,Y,VX,VY,TY,MY OUT FX,FY
 IF #MUTEKI==0 THEN
  IF FL[FX,FY]==#MAP_WALL THEN
   SPVAR #SP_MYC,"VX",0
   SPVAR #SP_MYC,"VY",0
   IF SPVAR(#SP_MYC,"BW")<=0 THEN
    SPVAR #SP_MYC,"BW",#BEEP_WAIT
    BEEP 100
   ELSE
    SPVAR #SP_MYC,"BW",SPVAR(#SP_MYC,"BW")-1
   ENDIF
  ELSE
   SPVAR #SP_MYC,"BW",0
  ENDIF
 ELSE
  IF FX<=0||FX>=#RNG_WIDTH-1 THEN SPVAR #SP_MYC,"VX",0
 ENDIF
 GETRBLOC X,Y,0,0,TY,MY OUT FX,FY
 IF FL[FX,FY]==#MAP_FLOOR THEN
  FL[FX,FY]=#MAP_VISITED
  INC SC
 ENDIF
 IF FL[FX,FY]==#MAP_TBOX THEN GET_TRESURE X,Y,FX,FY,MY
END

' 宝箱を開ける
DEF GET_TRESURE X,Y,FX,FY,MY
 VAR R,ID
 
 R=RND(100)
 IF R>49 THEN
  R=RND(LEN(ITC)-1)+1
 ELSE
  R=0
 ENDIF
 FL[FX,FY]=#MAP_TEMPTY
 RB[FX,FY]=#CHR_OPEN
 BEEP 104
 POP_ITEM X,Y,R
 IF FY<MY THEN MY=MY-#RNG_HEIGHT
 PRINT_RBLOC FX,FY-MY,RB[FX,FY]
 CASE R
  WHEN #ITM_MONEY
   INC SC,250
  WHEN #ITM_HEART
   SPVAR #SP_MYC,"HP",SPVAR(#SP_MYC,"HP")+1
   SPANIM #SP_HRT,"I",5,32,5,ITC[R],8
   PRINT_HEART
   INC SC,100
  WHEN #ITM_BOOTS
   SPVAR #SP_MYC,"SPD",2
   SPVAR #SP_MYC,"SPT",#BOOTS_TIMER
   SPANIM #SP_BTS,"I",5,32,5,ITC[R],8
   INC SC,100
  WHEN #ITM_TIMER
   TVAR #BG_MAP,"SF",1
   SPANIM #SP_TMR,"I",5,32,5,ITC[R],8
   INC SC,100
  WHEN #ITM_MATOK
   INC SC,100
   ADD_INV R
  WHEN #ITM_FB
   INC SC,100
   ADD_INV R
 ENDCASE
END

' インベントリにアイテムを追加する
DEF ADD_INV R
 VAR ID

 IF LEN(IV)<#IVT_MAX THEN
  PUSH IV,R
  ID=LAST(IV)
 ELSE
  ID=SPVAR(#SP_MYC,"ITEM")
  IV[ID]=R
 ENDIF
 PRINT_INV ID
END

' 取得アイテムを表示
DEF POP_ITEM X,Y,R
 SPSET #SP_PIT,ITC[R]
 SPVAR #SP_PIT,"Y",Y-#CHR_SIZE
 SPOFS #SP_PIT,X,Y,-255
 SPANIM #SP_PIT,#ANM_PI
 SPFUNC #SP_PIT,"PIT_MOVE"
END

' 取得アイテムを動かす
DEF PIT_MOVE
 VAR X,Y
 VAR YY=SPVAR(#SP_PIT,"Y")
 
 SPOFS #SP_PIT OUT X,Y
 IF Y>YY THEN DEC Y,0.4
 IF CHK_SCROLL() THEN
  INC Y,TVAR(#BG_MAP,"SPEED")
  INC YY,TVAR(#BG_MAP,"SPEED")
  SPVAR #SP_PIT,"Y",YY
 ENDIF
 SPOFS #SP_PIT,X,Y
END

' インベントリから指定のアイテムを削除
DEF DELETE_INV ITEM
 VAR I,IT

 REMOVE IV,ITEM
 IT=LAST(IV)
 IF ITEM>IT THEN
  IF IT<0 THEN IT=0
  SPOFS #SP_CSL,312+IT*#CHR_SIZE,120,-16
  SPVAR #SP_MYC,"ITEM",IT
 ENDIF
 PRINT_INV -1
END

' キャラの当たり判定
DEF CHK_COLSP()
 VAR SI,X,Y
 
 SPOFS #SP_MYC OUT X,Y
 IF #MUTEKI==0&&SPVAR(#SP_MYC,"IM")==0 THEN
  IF SPHITSP(#SP_MYC,#SP_ENM,#SP_ENM+#ENEMY_MAX-1)>=#SP_ENM THEN
   SPVAR #SP_MYC,"HP",SPVAR(#SP_MYC,"HP")-1
   PRINT_HEART
   IF SPVAR(#SP_MYC,"HP")==0 THEN
    PLAYER_MISS X,Y
    RETURN 1
   ELSE
    BEEP 13
    SPVAR #SP_MYC,"IM",#INV_TIMER
   ENDIF
  ENDIF
 ENDIF
 SI=SPHITSP(#SP_WPN,#SP_ENM,#SP_ENM+#ENEMY_MAX-1)
 IF SI>=#SP_ENM THEN
  ENEMY_DEAD SI,SPVAR(#SP_MYC,"V")
 ENDIF
 SI=SPHITSP(#SP_ITM,#SP_ENM,#SP_ENM+#ENEMY_MAX-1)
 IF SI>=#SP_ENM THEN
  ENEMY_DEAD SI,SPVAR(#SP_ITM,"V")
 ENDIF
 WALL_BREAK
 IF Y>240 THEN
  PLAYER_MISS X,Y
  RETURN 1
 ENDIF
 RETURN 0
END

' 敵を倒した時の処理
DEF ENEMY_DEAD SI,V
 BEEP 11
 SPCOL SI,0,&H00000000
 SPANIM SI,"C",-60,&H00FFFFFF
 SPANIM SI,"I.",60,ENC[SPVAR(SI,"E")]
 ED_INIT SI,V
 INC SC,50
END

' プレイヤーミスの演出処理
DEF PLAYER_MISS X,Y
 SPCHR #SP_MYC,468
 SPHIDE #SP_WPN
 SPHIDE #SP_ITM
 BGMSTOP
 BEEP 57
 WAIT 45
 BEEP 14
 SPOFS #SP_MYC,X+8,Y+8
 SPHOME #SP_MYC,8,8
 SPANIM #SP_MYC,"R",-30,360,0
 SPANIM #SP_MYC,"S",-60,4,4
 SPANIM #SP_MYC,"XY.",-60,150,-16
 WAIT 90
 COLOR #BG_WIN,&H88000000
 TFILL #BG_WIN,14,14,24,16,""
 LOCATE #BG_UI,15,15:TPRINT #BG_UI,BG_STR$("GAME")
 LOCATE #BG_UI,20,15:TPRINT #BG_UI,BG_STR$("OVER")
 BGMPLAY 6:BGMVOL 127
 WAIT_KEY
 BEEP 7
 SAVE_HISCORE
 FADE_OUT 4
END

' 壁を壊す処理
DEF WALL_BREAK
 VAR I,X,Y,C
 VAR FX,FY,CX,CY
 VAR TY=TVAR(#BG_MAP,"TXT_Y")
 VAR MY=TVAR(#BG_MAP,"MAP_Y")
 VAR V=SPVAR(#SP_MYC,"V")
 VAR VX=VVX[V]
 VAR VY=VVY[V]
 VAR ITEM=SPVAR(#SP_MYC,"ITEM")
 
 IF SPVAR(#SP_ITM,"IC")==#ITM_FB THEN RETURN
 IF SPSHOW(#SP_ITM) THEN
  SPOFS #SP_MYC OUT X,Y
  GETRBLOC X,Y,VX,VY,TY,MY OUT FX,FY
  IF FX>0&&FX<18 THEN
   IF FL[FX,FY]==#MAP_WALL THEN
    FL[FX,FY]=#MAP_FLOOR
    GETRBLOC X,Y,0,0,TY,MY OUT CX,CY
    FL[FX,FY]=#MAP_FLOOR
    RB[FX,FY]=GET_W2F(RB[FX,FY])
    IF FY<MY THEN MY=MY-#RNG_HEIGHT
    PRINT_RBLOC FX,FY-MY,RB[FX,FY]
    DELETE_INV ITEM
    SPCHR #SP_IVT+#IVT_MAX-1,32
    BEEP 120
    EWB_INIT
   ENDIF
  ENDIF
 ENDIF
END

' 迷路のスクロールスピードを設定する
DEF SET_SCRSPD
 TVAR #BG_MAP,"STIME",TVAR(#BG_MAP,"STIME")-1
 IF TVAR(#BG_MAP,"SF") THEN
  TVAR #BG_MAP,"SF",0
  TVAR #BG_MAP,"STIME",#SCROLL_TIMER
  SPVAR #SP_MYC,"SCR",SPVAR(#SP_MYC,"SCR")-1
  IF SPVAR(#SP_MYC,"SCR")<1 THEN SPVAR #SP_MYC,"SCR",1
 ENDIF
 PRINT_TIMER
 IF TVAR(#BG_MAP,"STIME")==0 THEN
  TVAR #BG_MAP,"STIME",#SCROLL_TIMER
  SPVAR #SP_MYC,"SCR",SPVAR(#SP_MYC,"SCR")+1
  IF SPVAR(#SP_MYC,"SCR")>#SRL_SPEED_MAX THEN
   SPVAR #SP_MYC,"SCR",#SRL_SPEED_MAX
  ENDIF
 ENDIF
 TVAR #BG_MAP,"INTERVAL",#SRL_INTERVAL-(SPVAR(#SP_MYC,"SCR")-1)*5
 IF TVAR(#BG_MAP,"INTERVAL")<1 THEN TVAR #BG_MAP,"INTERVAL",1
 TVAR #BG_MAP,"SPEED",#SRL_SPEED
END

' 迷路をスクロールさせる
DEF SCROLL_MAZE
 IF CHK_SCROLL() THEN
  TVAR #BG_MAP,"TXT_Y",TVAR(#BG_MAP,"TXT_Y")+TVAR(#BG_MAP,"SPEED")
 ENDIF
 IF TVAR(#BG_MAP,"TXT_Y")>=0 THEN
  IF TVAR(#BG_MAP,"MAP_Y")==TVAR(#BG_MAP,"MAP_Y_CUR") THEN
   ADDNEW_MAZE
  ENDIF
  TVAR #BG_MAP,"MAP_Y",TVAR(#BG_MAP,"MAP_Y")-1
  IF TVAR(#BG_MAP,"MAP_Y")<0 THEN TVAR #BG_MAP,"MAP_Y",#RNG_HEIGHT-1
  PRINT_RB TVAR(#BG_MAP,"MAP_Y")
  PUT_ENEMY
  INC SC,10
  TVAR #BG_MAP,"TXT_Y",-#CHR_SIZE
  BGM_CHANGE
  DRAW_BACKGROUND
 ENDIF
 TOFS 0,0,TVAR(#BG_MAP,"TXT_Y")
END

' 新しい迷路を追加する
DEF ADDNEW_MAZE
 TVAR #BG_MAP,"MAP_Y_CUR",TVAR(#BG_MAP,"MAP_Y_CUR")-14
 IF TVAR(#BG_MAP,"MAP_Y_CUR")<0 THEN
  TVAR #BG_MAP,"MAP_Y_CUR",#RNG_HEIGHT-ABS(TVAR(#BG_MAP,"MAP_Y_CUR"))
 ENDIF
 TVAR #BG_MAP,"CNT",TVAR(#BG_MAP,"CNT")+1
 IF TVAR(#BG_MAP,"CNT")>#AREA_LENGTH THEN
  TVAR #BG_MAP,"CNT",0
  TVAR #BG_MAP,"STG",TVAR(#BG_MAP,"STG")+1
  TVAR #BG_MAP,"EC",#BM_PHEIGHT
  IF TVAR(#BG_MAP,"STG")>LAST(WL) THEN
   TVAR #BG_MAP,"STG",LAST(WL)
  ENDIF
  IF BG[TVAR(#BG_MAP,"STG")]!=TVAR(#BG_MAP,"BGM") THEN
   TVAR #BG_MAP,"BGM",BG[TVAR(#BG_MAP,"STG")]
   TVAR #BG_MAP,"VOL",#BGM_TIMER
  ENDIF
 ENDIF
 MAZE_MAKE #MAP_APPEND
 SET_MAZE TVAR(#BG_MAP,"MAP_Y_NEXT"),1,14,INT(TVAR(#BG_MAP,"STG"))
 TVAR #BG_MAP,"MAP_Y_NEXT",TVAR(#BG_MAP,"MAP_Y_NEXT")-14
 IF TVAR(#BG_MAP,"MAP_Y_NEXT")<0 THEN
  TVAR #BG_MAP,"MAP_Y_NEXT",#RNG_HEIGHT-ABS(TVAR(#BG_MAP,"MAP_Y_NEXT"))
 ENDIF
END

' BGM切替処理
DEF BGM_CHANGE
 IF TVAR(#BG_MAP,"VOL")>0 THEN
  TVAR #BG_MAP,"VOL",TVAR(#BG_MAP,"VOL")-1
  BGMVOL INT(TVAR(#BG_MAP,"VOL")/#BGM_TIMER*64)
  IF TVAR(#BG_MAP,"VOL")==0 THEN
   BGMVOL 127
   BGMPLAY TVAR(#BG_MAP,"BGM")
  ENDIF
 ENDIF
END

' バックグラウンドを描画
DEF DRAW_BACKGROUND
 IF TVAR(#BG_MAP,"STG")==LAST(WL)&&TVAR(#BG_MAP,"VOL")==0 THEN
  TVAR #BG_MAP,"SKY",TVAR(#BG_MAP,"SKY")-#SRL_SPEED*4
  IF TVAR(#BG_MAP,"SKY")<0 THEN
   TVAR #BG_MAP,"SKY",0
   ADD_STAR
  ENDIF
 ENDIF
 GFILL 0,0,303,240,RGB(TVAR(#BG_MAP,"SKY"),0,128,255)
END

' リングバッファにスタート地点を作成
DEF SET_START
 VAR I,J

 FOR I=#RNG_HEIGHT-#START_H-1 TO #RNG_HEIGHT-1
  FOR J=0 TO #RNG_WIDTH-1
   IF J==#MAP_STARTX THEN
    RB[J,I]=FR[0]
    FL[J,I]=#MAP_VISITED
   ELSE
    RB[J,I]=WL[0]
    FL[J,I]=#MAP_WALL
   ENDIF
  NEXT
 NEXT
END

' 迷路をコピー
DEF SET_MAZE Y,S,H,C
 VAR I,J
 
 FOR I=0 TO H-1
  FOR J=0 TO #RNG_WIDTH-1
   CASE MZ[J,I+S]
    WHEN #MAP_FLOOR
     RB[J,Y]=FR[C]
    WHEN #MAP_WALL
     RB[J,Y]=WL[C]
    WHEN #MAP_TBOX
     RB[J,Y]=#CHR_TBOX
   ENDCASE
   FL[J,Y]=MZ[J,I+S]
  NEXT
  INC Y:IF Y>=#RNG_HEIGHT THEN Y=0
 NEXT
END

' リングバッファの一部を表示
DEF PRINT_RBLOC X,Y,C
 LOCATE 0,X,Y:TPRINT 0,BGCHR$(C);
END

' リングバッファを表示
DEF PRINT_RB MY
 VAR I,J
 
 FOR I=0 TO #BM_HEIGHT-1
  FOR J=0 TO #RNG_WIDTH-1
   PRINT_RBLOC J,I,RB[J,MY]
  NEXT
  INC MY:IF MY>=#RNG_HEIGHT THEN MY=0
 NEXT
END

' DIG法で迷路を作成
DEF MAZE_MAKE A
 VAR I,J,R,FX,FY,E,VX,VY,C
 DIM LX[],LY[]

 FY=DIM(MZ,1)-2
 E=DIM(MZ,1)-1
 IF A==#MAP_APPEND THEN
  '前回作成した迷路の上端を下端にコピーする
  FOR I=0 TO DIM(MZ,0)-1
   MZ[I,FY]=MZ[I,1]
   IF (I MOD 2)==1&&CHK_FLOOR(I,1)<3 THEN
    PUSH LX,I:PUSH LY,FY
   ENDIF
  NEXT
  R=RND(LEN(LX)):FX=LX[R]:REMOVE LX,R:REMOVE LY,R
  DEC E,2
 ELSE
  FX=#MAP_STARTX
 ENDIF
 '配列を壁で埋める
 FOR I=0 TO E
  FOR J=0 TO DIM(MZ,0)-1
   MZ[J,I]=#MAP_WALL
  NEXT
 NEXT
 '周囲を通路にする
 FOR I=0 TO DIM(MZ,0)-1
  MZ[I,0]=#MAP_FLOOR:MZ[I,DIM(MZ,1)-1]=#MAP_FLOOR
 NEXT
 FOR I=0 TO DIM(MZ,1)-1
  MZ[0,I]=#MAP_FLOOR:MZ[DIM(MZ,0)-1,I]=#MAP_FLOOR
 NEXT
 C=0
 REPEAT
  '行ける方向のリストを作成
  CHK_WALL FX,FY OUT VX,VY
  IF LEN(VX)>0 THEN
   '壁を2ブロック堀り進み、その座標を始点候補座標に追加
   R=RND(LEN(VX))
   FOR I=0 TO 2
    MZ[FX+VX[R]*I,FY+VY[R]*I]=#MAP_FLOOR
   NEXT
   PUSH LX,FX+VX[R]*2:PUSH LY,FY+VY[R]*2
   FX=LX[LAST(LX)]:FY=LY[LAST(LY)]
   INC C
  ELSE
   '行ける場所がなくなったら始点候補座標からスタートする
   IF C>0&&FY>1&&FY<#MAP_HEIGHT-2 THEN
    IF RND(#TB_RNDMAX)<#TB_RND THEN MZ[FX,FY]=#MAP_TBOX
   ENDIF
   R=RND(LEN(LX))
   FX=LX[R]:FY=LY[R]
   REMOVE LX,R:REMOVE LY,R
   C=0
  ENDIF
 UNTIL LEN(LX)==0
 '通路にしていた外枠を壁にする
 FOR I=0 TO DIM(MZ,0)-1
  MZ[I,0]=#MAP_WALL:MZ[I,DIM(MZ,1)-1]=#MAP_WALL
 NEXT
 FOR I=0 TO DIM(MZ,1)-1
  MZ[0,I]=#MAP_WALL:MZ[DIM(MZ,0)-1,I]=#MAP_WALL
 NEXT
END

' 周囲4方向の2ブロック先までが壁かどうかを調べ、進める方向のリストを作成する
DEF CHK_WALL FX,FY OUT VX,VY
 VAR I
 
 VX=ARRAY%(0):VY=ARRAY%(0)
 FOR I=0 TO 3
  IF MZ[FX+VVX[I],FY+VVY[I]]==#MAP_WALL THEN
   IF MZ[FX+(VVX[I]*2),FY+(VVY[I]*2)]==#MAP_WALL THEN
    PUSH VX,VVX[I]:PUSH VY,VVY[I]
   ENDIF
  ENDIF
 NEXT
END

' 周囲4方向の通路の数を返す
DEF CHK_FLOOR(X,Y)
 VAR I,C
 
 C=0
 FOR I=0 TO 3
  IF MZ[X+VVX[I],Y+VVY[I]]==#MAP_FLOOR THEN INC C
 NEXT
 RETURN C
END

' UI表示
DEF PRINT_UI
 VAR TY=TVAR(#BG_MAP,"TXT_Y")
 VAR MY=TVAR(#BG_MAP,"MAP_Y")

 GPRINT_PREV #NXT_LEFT,#NXT_TOP,TY,MY
 PRINT_HISCORE
 PRINT_SCORE
 COLOR #BG_OVL,&H80FFFF00
 TFILL #BG_OVL,0,1,18,1,""
END

DEF PRINT_SCORE
 COLOR #BG_UI,#C_MAGENTA
 LOCATE #BG_UI,39,7:TPRINT #BG_UI,BG_STR$("SCORE")+"     "
 COLOR #BG_UI,#C_WHITE
 LOCATE #BG_UI,39,8:TPRINT #BG_UI,"    "+BG_NUM$(SC,6)
END

DEF PRINT_HISCORE
 COLOR #BG_UI,#C_LIME
 LOCATE #BG_UI,39,4:TPRINT #BG_UI,BG_STR$("HISCORE")+"   "
 COLOR #BG_UI,#C_WHITE
 LOCATE #BG_UI,39,5:TPRINT #BG_UI,"    "+BG_NUM$(HS,6)
END

' プレビュー画面を表示する
DEF GPRINT_PREV X,Y,TY,MY
 VAR I,J,XX,YY,C,SX,SY,FX,FY
 
 SPOFS 0 OUT SX,SY
 GETRBLOC SX,SY,0,0,TY,MY OUT FX,FY
 DEC MY,#NXT_OFFSET:IF MY<0 THEN MY=#RNG_HEIGHT-ABS(MY)
 TY=(#CHR_SIZE+TY)/4
 SPVAR #GSPRITE,"BL",SPVAR(#GSPRITE,"BL")+SPVAR(#GSPRITE,"BV")
 IF SPVAR(#GSPRITE,"BL")<=127||SPVAR(#GSPRITE,"BL")>=255 THEN
  SPVAR #GSPRITE,"BV",-SPVAR(#GSPRITE,"BV")
 ENDIF
 FOR I=0 TO #NXT_HEIGHT-1
  FOR J=0 TO #RNG_WIDTH-1
   XX=X+J*4
   YY=Y+I*4+TY
   CASE FL[J,MY]
    WHEN #MAP_WALL
     C=#GC_WALL
    WHEN #MAP_VISITED
     C=#GC_VISITED
    WHEN #MAP_TBOX
     C=RGB(255,SPVAR(#GSPRITE,"BL"),SPVAR(#GSPRITE,"BL"),0)
    WHEN #MAP_TEMPTY
     C=#GC_TEMPTY
    OTHERWISE
     C=#GC_FLOOR
   ENDCASE
   GFILL XX,YY,XX+3,YY+3,C
  NEXT
 INC MY:IF MY>=#RNG_HEIGHT THEN MY=0
 NEXT
 GFILL X,Y,X+#MAP_WIDTH*4,Y+2,&HFF000000
 GFILL X,Y+#NXT_HEIGHT*4+4,X+#MAP_WIDTH*4,Y+#NXT_HEIGHT*4-4,&HFF000000
END

' 文字をBGキャラクタの文字に変換
DEF BG_STR$(C$)
 VAR I,R$=""
 
 FOR I=0 TO LAST(C$)
  R$=R$+CHR$(&HE800+ASC(MID$(C$,I,1))+&H40)
 NEXT
 RETURN R$
END

' 数字をBGキャラクタの文字に変換
DEF BG_NUM$(N,D)
 VAR I,S$,R$=""
 
 S$=FORMAT$("%0"+STR$(D)+"D",N)
 FOR I=0 TO LAST(S$)
  R$=R$+CHR$(&HE800+ASC(MID$(S$,I,1))+&H20)
 NEXT
 RETURN R$
END

' コードからBGキャラクタに変換
DEF BGCHR$(C)
 RETURN CHR$(&HE800+C)
END

' 壁キャラクタかどうかを判定する
DEF CHK_CWALL(C)
 VAR I
 
 FOR I=0 TO LAST(WL)
  IF C==WL[I] THEN RETURN 1
 NEXT
 RETURN 0
END

' 壁キャラクタから床キャラクタを返す
DEF GET_W2F(C)
 VAR I
 
 FOR I=0 TO LAST(WL)
  IF WL[I]==C THEN RETURN FR[I]
 NEXT
 RETURN 0
END

' リングバッファ上の座標を取得
DEF GETRBLOC SX,SY,VX,VY,TY,MY OUT FX,FY
 FX=ROUND(SX/#CHR_SIZE)+SGN(VX)
 FY=ROUND((SY-TY)/#CHR_SIZE)+SGN(VY)+MY
 IF FY>=#RNG_HEIGHT THEN DEC FY,#RNG_HEIGHT
END

' ハートの数を表示
DEF PRINT_HEART
 LOCATE #BG_UI,#SP_HRT_LEFT/8,12
 TPRINT #BG_UI,BG_NUM$(SPVAR(#SP_MYC,"HP"),2)
END

' ブーツのを表示
DEF PRINT_BOOTS
 VAR X=#SP_BTS_LEFT
 VAR Y=86-(SPVAR(#SP_MYC,"SPT")/#BOOTS_TIMER)*#CHR_SIZE

 SPOFS #SP_BTH,X,Y
END

' タイマーの数を表示
DEF PRINT_TIMER
 VAR X=#SP_TMR_LEFT
 VAR Y=86-(TVAR(#BG_MAP,"STIME")/#SCROLL_TIMER)*#CHR_SIZE

 SPOFS #SP_TMH,X,Y
 LOCATE #BG_UI,#SP_TMR_LEFT/8,12
 TPRINT #BG_UI,BG_NUM$(SPVAR(#SP_MYC,"SCR"),2)
END

' スクロールのタイミングを返す
DEF CHK_SCROLL()
 RETURN ((MAINCNT() MOD TVAR(#BG_MAP,"INTERVAL"))==0)
END

' BGM開始
DEF BGM_START
 BGMSTOP:BGMVOL 127:BGMPLAY TVAR(#BG_MAP,"BGM")
END

' 逆方向を返す
DEF REV_VECT(V)
 DIM RV[]=[1,0,3,2]

 RETURN RV[V]
END

' タイトル画面描画
DEF DRAW_TITLE
 VAR I,J,K,ID,T$
 DIM TI$[]=["@TTL_INF_IN","@TTL_INF_OUT","@TTL_INF_SHADOW"]
 DIM TM$[]=["@TTL_MAZE_IN","@TTL_MAZE_OUT","@TTL_MAZE_SHADOW"]
 
 SPCLR:FADE &H00000000
 CLS 0:CLS 1:CLS 2:CLS 3:CLS 4:GCLS
 TSCREEN 0,16,8:TSCREEN 1,8,8:TSCREEN 2,8,8:TSCREEN 3,16,8
 TOFS 0,-2,-3,0:TOFS 1,-2,-3,1:TOFS 2,0,0,2:TOFS 3,0,0,3
 COLOR 2,#C_MAROON:TFILL 2,0,0,49,29,""
 COLOR 2,&HFF440000:TFILL 2,30,21,47,25,""
 COLOR #C_WHITE:LOCATE 31,22:PRINT BG_STR$("PUSH")
 COLOR #C_YELLOW:LOCATE 36,23:PRINT BG_STR$("ANY")
 COLOR #C_WHITE:LOCATE 40,24:PRINT BG_STR$("BUTTON")+BGCHR$(65)
 'タイトル文字を表示
 FOR I=0 TO 2
  RESTORE TI$[I]
  COLOR 1,#C_CYAN
  COLOR 2,#C_MAROON
  FOR J=0 TO 7
   COLOR 0,RGB(0,255-J*24,255-J*24)
   READ T$:LOCATE I,1,J+1:TPRINT I,T$
  NEXT
  COLOR 1,#C_WHITE
  RESTORE TM$[I]
  FOR J=0 TO 7
   COLOR 0,RGB(255-J*24,255-J*24,255-J*24)
   READ T$:LOCATE I,49-LEN(T$),J+10:TPRINT I,T$
  NEXT
 NEXT
 'スクロール表示部を空白で埋める
 TFILL 2,1,10,27,28," "
 'スクロール部外周のマスク処理
 COLOR 3,#C_BLACK
 TFILL 3,0,10,0,29,""
 TFILL 3,0,29,27,29,""
 TFILL 3,28,10,49,29,""
 'スクロール部の背景色を設定
 FOR I=0 TO 152
  GLINE 8,78+I,223,78+I,RGB(255-(I+100),255-(I+50),255-I)
 NEXT
 'スプライトデータを作成
 GTARGET 3
 FOR I=0 TO 15
  GCOPY 4,1136,48,1151,63,I*16,0,0
  GCOPY 4,1632,1424,1679,1535,I*48,16,0
 NEXT
 GTARGET 0
 '多重スクロール処理
 FOR I=0 TO 5
  '地面
  ID=200+I*16
  SPSET ID,0:SPPAGE ID,3:SPCHR ID,0,0,256,16
  SPOFS ID,-32,194+I*I+1,50-I
  SPCOLOR ID,RGB(255,I*40+50,I*40+50,I*40+50)
  SPANIM ID,"XY+",-(90-I*12),16,0,0
  '木
  IF I<3 THEN
   ID=300+I*16
   SPSET ID,0:SPPAGE ID,3:SPCHR ID,0,16,768,112
   SPHOME ID,0,111
   SPSCALE ID,1-I*0.2,1-I*0.2
   SPOFS ID,-48+I*10,202-I*4,40+I
   SPCOLOR ID,RGB(255,255-I*120,255-I*120,255-I*120)
   SPANIM ID,"XY+",-(180+I*90),48-I*10,0,0
  ENDIF
 NEXT
 '雲
 SPSET 400,1632,1408,48,16
 SPOFS 400,-48,80,100
 SPCOLOR 400,&H80FFFFFF
 SPANIM 400,"XY",-2400,224,80,0
 '主人公を歩かせる
 SPDEF 1500,0,1312,32,32,#A_REVH
 SPDEF 1501,32,1312,32,32,#A_REVH
 SPDEF 1502,64,1312,32,32,#A_REVH
 SPSET 100,32
 SPSCALE 100,2,2
 SPOFS 100,128,154
 SPANIM 100,"I",15,1501,15,1500,15,1502,15,1500,0
 'BGMを再生
 BGMPLAY 12:BGMVOL 127
 WAIT_KEY
 BEEP 37
 FADE_OUT 4
END

' フェードリセット
DEF FADE_RESET
 FADE &H00000000
END

' フェードアウト処理
DEF FADE_OUT S
 VAR I
 
 FOR I=0 TO 255 STEP S
  FADE RGB(I,0,0,0)
  BGMVOL 80-(I/255)*80
  VSYNC
 NEXT
 BGMSTOP
END

' フェードイン処理
DEF FADE_IN S
 VAR I
 
 FOR I=255 TO 0 STEP -S
  FADE RGB(I,0,0,0)
  VSYNC
 NEXT
END

' キー入力を待つ
DEF WAIT_KEY
 LOOP
  IF BUTTON(0,#B_ANY,2) THEN BREAK
  VSYNC
 ENDLOOP
END

' インベントリ表示
DEF PRINT_INV ID
 VAR I
 
 FOR I=0 TO #IVT_MAX-1
  IF I<=LAST(IV) THEN
   IF I==ID THEN
    SPANIM #SP_IVT+I,"I",5,32,5,ITC[IV[I]],8
   ELSE
    SPCHR #SP_IVT+I,ITC[IV[I]]
   ENDIF
  ELSE
   SPCHR #SP_IVT+I,32
  ENDIF
 NEXT
 IF LEN(IV)==#IVT_MAX THEN
  SPCOLOR #SP_CSL,&HAAFF0000
 ELSE
  SPCOLOR #SP_CSL,&HAAFFFFFF
 ENDIF
END

' ハイスコアをロードする
DEF LOAD_HISCORE
 IF CHKFILE("TXT:HISCORE") THEN
  HS=VAL(LOADV("TXT:HISCORE"))
 ENDIF
END

' ハイスコアをセーブする
DEF SAVE_HISCORE
 IF SC==HS THEN
  SAVEV "TXT:HISCORE",STR$(HS)
 ENDIF
END

' 星スプライト初期化
DEF ADD_STAR
 VAR SI,Z
 
 SI=SPSET(#SP_STAR,#SP_STAR+#STAR_MAX-1,3401)
 IF SI==-1 THEN RETURN
 SPOFS SI,RND(300),-4,255
 Z=(RND(10)+1)/3.3333
 SPVAR SI,"VY",Z/2
 SPSCALE SI,0.2+Z,0.2+Z
 SPFUNC SI,"MOVE_STAR"
 SPSHOW SI
END

' 星スプライトのコールバック処理
DEF MOVE_STAR
 VAR SI,X,Y,Z

 SI=CALLIDX()
 SPOFS SI OUT X,Y
 INC Y,SPVAR(SI,"VY")
 IF Y>248 THEN
  Y=-4
  X=RND(300)
  Z=(RND(10)+1)/3.3333
  SPVAR SI,"VY",Z
  SPSCALE SI,0.2+Z,0.2+Z
 ENDIF
 IF CHK_SCROLL() THEN INC Y,TVAR(#BG_MAP,"SPEED")
 SPOFS SI,X,Y,255
END

' 敵を追加する
DEF PUT_ENEMY
 VAR SI,X,E,V,FX,FY
 
 IF TVAR(#BG_MAP,"EC")>0 THEN
  TVAR #BG_MAP,"EC",TVAR(#BG_MAP,"EC")-1
  IF TVAR(#BG_MAP,"EC")==0 THEN
   TVAR #BG_MAP,"EN",TVAR(#BG_MAP,"STG")
  ENDIF
 ENDIF
 IF RND(256)<TVAR(#BG_MAP,"STG")*INT(256/LEN(EI))+24 THEN
  X=(RND(9)*2+1)*#CHR_SIZE
  GETRBLOC X,-#CHR_SIZE,0,0,-#CHR_SIZE,TVAR(#BG_MAP,"MAP_Y") OUT FX,FY
  IF FL[FX,FY]==#MAP_FLOOR THEN
   SI=SPSET(#SP_ENM,#SP_ENM+#ENEMY_MAX-1,32,0)
   IF SI==-1 THEN RETURN
   SPOFS SI,X,-#CHR_SIZE
   E=EI[TVAR(#BG_MAP,"EN")]
   V=RND(4)
   SPANIM SI,E*5+V+5
   SPVAR SI,"V",V
   SPVAR SI,"C",0
   SPVAR SI,"S",E*E+1
   SPVAR SI,"E",E
   SPCOL SI,2,2,11,11
   SPFUNC SI,"MOVE_ENEMY"
   SPSHOW SI
  ENDIF
 ENDIF
END

' 敵の移動
DEF MOVE_ENEMY
 VAR I,SI,X,Y,V,FX,FY,S,M
 
 SI=CALLIDX()
 SPOFS SI OUT X,Y
 SPCOL SI OUT S,M
 IF M!=&H00000000 THEN
  IF SPVAR(SI,"C")==0 THEN
   IF Y>=0&&RND(100)<SPVAR(SI,"S") THEN
    V=RND(4)
    GETRBLOC X,Y,VVX[V],VVY[V],TVAR(#BG_MAP,"TXT_Y"),TVAR(#BG_MAP,"MAP_Y") OUT FX,FY
    IF FL[FX,FY]==#MAP_FLOOR||FL[FX,FY]==#MAP_VISITED THEN
     SPVAR SI,"C",#CHR_SIZE
     SPVAR SI,"V",V
     SPANIM SI,SPVAR(SI,"E")*5+V+5
    ENDIF
   ENDIF
  ELSE
   SPVAR SI,"C",SPVAR(SI,"C")-1
   INC X,VVX[SPVAR(SI,"V")]
   INC Y,VVY[SPVAR(SI,"V")]
  ENDIF
 ENDIF
 IF CHK_SCROLL() THEN INC Y,TVAR(#BG_MAP,"SPEED")
 SPOFS SI,X,Y
 IF Y>240 THEN SPCLR SI
END

' ファイアボール初期化処理
DEF INIT_FB
 VAR X,Y,FX,FY
 VAR V=SPVAR(#SP_MYC,"V")
 VAR VX=VVX[V]
 VAR VY=VVY[V]
 VAR TY=TVAR(#BG_MAP,"TXT_Y")
 VAR MY=TVAR(#BG_MAP,"MAP_Y")
 
 SPOFS #SP_MYC OUT X,Y
 GETRBLOC X,Y,VX*#CHR_SIZE,VY*#CHR_SIZE,TY,MY OUT FX,FY
 IF FL[FX,FY]==#MAP_FLOOR||FL[FX,FY]==#MAP_VISITED THEN
  SPOFS #SP_ITM,X+VX*16+ABS(VY)*4,Y+VY*16+ABS(VX)*4
  SPANIM #SP_ITM,V+#ANM_FB
  SPVAR #SP_ITM,"FB",1
  SPVAR #SP_ITM,"V",V
  SPVAR #SP_ITM,"VX",VX*2
  SPVAR #SP_ITM,"VY",VY*2
  SPCOL #SP_ITM,0,&HFFFFFFFF
  SPSHOW #SP_ITM
  DELETE_INV SPVAR(#SP_MYC,"ITEM")
  BEEP 10
 ENDIF
END

' ファイアボール移動処理
DEF MOVE_FB
 VAR X,Y,FX,FY,OX=0,OY=0
 VAR VX=SPVAR(#SP_ITM,"VX")
 VAR VY=SPVAR(#SP_ITM,"VY")
 VAR TY=TVAR(#BG_MAP,"TXT_Y")
 VAR MY=TVAR(#BG_MAP,"MAP_Y")
 VAR V=SPVAR(#SP_ITM,"V")

 SPOFS #SP_ITM OUT X,Y
 IF SPVAR(#SP_ITM,"FB")==1 THEN
  GETRBLOC X,Y,0,0,TY,MY OUT FX,FY
  IF Y<-#CHR_SIZE||Y>240||FL[FX,FY]==#MAP_WALL THEN
   SPANIM #SP_ITM,"I",5,1346,5,1347,5,32
   SPCOL #SP_ITM,0,&H00000000
   SPVAR #SP_ITM,"FB",0
   OX=SGN(ABS(VY))*4
   OY=SGN(ABS(VX))*4
   RP_INIT X-OX+8,Y-OY+8,REV_VECT(V),180,20,6,2,0.9,&HFFFF0000
   BEEP 100
  ELSE
   INC X,VX:INC Y,VY
   IF MAINCNT() MOD 4==0 THEN FC_ADD
  ENDIF
 ENDIF
 IF SPCHK(#SP_ITM) THEN
  IF CHK_SCROLL() THEN INC Y,TVAR(#BG_MAP,"SPEED")
  SPOFS #SP_ITM,X-OX,Y-OY
 ENDIF
END

' 残像追加
DEF BLUR_ADD
 VAR X,Y,Z,SI
 
 SPOFS #SP_MYC OUT X,Y,Z
 SI=SPSET(#SP_EFFECT,#SP_EFFECT+#EFFECT_MAX-1,SPCHR(#SP_MYC))
 SPOFS SI,X,Y,Z+1
 SPCOLOR SI,&HAAFFFFFF
 SPANIM SI,"C.",-20,&H00FFFFFF
 SPFUNC SI,"EFFECT_MOVE"
END

' 壁破壊エフェクト初期化
DEF EWB_INIT
 VAR X,Y
 VAR V=SPVAR(#SP_MYC,"V")
 VAR VX=VVX[V]*#CHR_SIZE
 VAR VY=VVY[V]*#CHR_SIZE
 VAR SI=SPSET(#SP_EFFECT,#SP_EFFECT+#EFFECT_MAX-1,32)
 
 SPOFS #SP_MYC OUT X,Y
 SPOFS SI,X+VX-8,Y+VY-8,-1
 SPCOLOR SI,&HCCFFFFFF
 SPANIM SI,#ANM_WB
 SPFUNC SI,"EFFECT_MOVE"
 RP_INIT X+16,Y+16,V,60,10,14,4,0.9,&HFFFFFFFF
END

' 敵やられエフェクト初期化
DEF ED_INIT SP,V
 VAR X,Y
 VAR SI=SPSET(#SP_EFFECT,#SP_EFFECT+#EFFECT_MAX-1,32)
 
 SPOFS SP OUT X,Y
 SPOFS SI,X,Y,-1
 SPCOLOR SI,&HCCFFAA44
 SPANIM SI,#ANM_ED+V
 SPFUNC SI,"EFFECT_MOVE"
 RP_INIT X+8,Y+8,V,120,10,4,2,0.8,&HFFFFAA44
END

' エフェクト共通移動
DEF EFFECT_MOVE
 VAR X,Y,SI=CALLIDX()

 SPOFS SI OUT X,Y
 IF CHK_SCROLL() THEN INC Y,TVAR(#BG_MAP,"SPEED")
 SPOFS SI,X,Y
END

' 火の粉初期化
DEF FC_ADD
 VAR X,Y,Z
 VAR VX=SPVAR(#SP_ITM,"VX")
 VAR VY=SPVAR(#SP_ITM,"VY")
 VAR SI=SPSET(#SP_EFFECT,#SP_EFFECT+#EFFECT_MAX-1,32)

 SPOFS #SP_ITM OUT X,Y,Z
 SPPAGE SI,-1
 SPCHR SI,0,0,2,2
 SPOFS SI,X+RND(4)+3,Y+RND(4)+3,Z+1
 SPVAR SI,"VX",VX/2.0
 SPVAR SI,"VY",VY/2.0
 SPCOLOR SI,&HFFFF0000
 SPANIM SI,"C.",-40,&H00FF0000
 SPFUNC SI,"FC_MOVE"
END

' 火の粉移動
DEF FC_MOVE
 VAR X,Y,SI=CALLIDX()
 VAR VX=SPVAR(SI,"VX")
 VAR VY=SPVAR(SI,"VY")
 
 SPOFS SI OUT X,Y
 IF SPVAR(#SP_ITM,"FB")==0 THEN
  VX=0:VY=0
 ENDIF
 IF CHK_SCROLL() THEN INC Y,TVAR(#BG_MAP,"SPEED")
 SPOFS SI,X+VX,Y+VY
END

' 放射パーティクル初期化
DEF RP_INIT X,Y,V,W,N,R,S,G,C
 VAR I,D,SI,VX,VY,CR,CG,CB
 DIM RD[]=[270,90,180,0]
 
 FOR I=0 TO N-1
  SI=SPSET(#SP_EFFECT,#SP_EFFECT+#EFFECT_MAX-1,32)
  IF SI>-1 THEN
   SPPAGE SI,-1
   SPCHR SI,0,0,2,2
   D=(RD[V]-INT(W/2)+RND(W)) MOD 360
   VX=SIN(RAD(D))
   VY=COS(RAD(D))
   SPOFS SI,X+VX*R,Y+VY*R
   SPVAR SI,"VX",VX*(RND(S)+1)
   SPVAR SI,"VY",VY*(RND(S)+1)
   SPVAR SI,"G",G
   SPCOLOR SI,C
   RGB C OUT CR,CG,CB
   SPANIM SI,"C.",-40,RGB(0,CR,CG,CB)
   SPFUNC SI,"RP_MOVE"
  ENDIF
 NEXT
END

' 放射パーティクル移動
DEF RP_MOVE
 VAR X,Y,SI=CALLIDX()
 VAR VX=SPVAR(SI,"VX")
 VAR VY=SPVAR(SI,"VY")
 VAR G=SPVAR(SI,"G")
 
 SPOFS SI OUT X,Y
 IF CHK_SCROLL() THEN INC Y,TVAR(#BG_MAP,"SPEED")
 SPOFS SI,X+VX,Y+VY
 SPVAR SI,"VX",VX*G
 SPVAR SI,"VY",VY*G
END

@ENDPROC
BGMSTOP

@TTL_INF_IN
DATA "       "
DATA "                     "
DATA "                 "
DATA "                  "
DATA "                  "
DATA "                      "
DATA "                      "
DATA "                "

@TTL_INF_OUT
DATA "       "
DATA "                     "
DATA "                 "
DATA "                  "
DATA "                  "
DATA "                      "
DATA "                      "
DATA "                "

@TTL_INF_SHADOW
DATA "                           "
DATA "             "
DATA "                 "
DATA "                "
DATA "                "
DATA "            "
DATA "            "
DATA "                  "

@TTL_MAZE_IN
DATA "     "
DATA "          "
DATA "           "
DATA "       "
DATA "           "
DATA "             "
DATA "           "
DATA "      "

@TTL_MAZE_OUT
DATA "     "
DATA "          "
DATA "           "
DATA "       "
DATA "           "
DATA "             "
DATA "           "
DATA "      "

@TTL_MAZE_SHADOW
DATA "               "
DATA "          "
DATA "         "
DATA "             "
DATA "         "
DATA "       "
DATA "      "
DATA "              "

fX*Hs'|[9.On2