      Y  
 -&MOT                             MOT                                               '共通関数                     (MOT4CM1.PRG) BY MOT
'  VER 3.0.0 3GO                NEW 2015/02/04
'  VER 3.1.1                    UPD 2018/03/19
'  VER 3.1.2                    UPD 2019/01/12
'  VER 4.0.0 4                  UPD 2019/06/20
'  VER 4.0.1 4                  UPD 2019/07/10
'
'※ プログラムSLOT:1 に 読みこんで 使用します
'
'※ プログラムSLOT:2 を フォント 英数字1-5 データ に 使用します
'  (FONTELOAD 実行時 / 英数字1-5 データ 未保存時)

OPTION STRICT

'直接実行した場合は初期化して終了
GOSUB @MOT4CM1_INIT
END

'初期化
@MOT4CM1_INIT
VAR MOT4CM1_B2_SIKII       'BUTTON2 しきい値
VAR MOT4CM1_B2_PREV        'BUTTON2 前回値
VAR MOT4CM1_B2_STARTTIME   'BUTTON2 開始時間
VAR MOT4CM1_B2_INTERVAL    'BUTTON2 インターバル
VAR MOT4CM1_B2_COUNT       'BUTTON2 カウント
'初期値 設定
MOT4CM1_B2_SIKII=0.5
MOT4CM1_B2_STARTTIME=15
MOT4CM1_B2_INTERVAL=4
MOT4CM1_B2_COUNT=0
'プチコン 3号 互換 BUTTON定数 (別スロットでは使えない?ひとまずコメントアウト)
'CONST #UP   =1<<#B_LUP
'CONST #DOWN =1<<#B_LDOWN
'CONST #LEFT =1<<#B_LLEFT
'CONST #RIGHT=1<<#B_LRIGHT
'CONST #A    =1<<#B_RRIGHT
'CONST #B    =1<<#B_RDOWN
'CONST #X    =1<<#B_RUP
'CONST #Y    =1<<#B_RLEFT
'CONST #L    =1<<#B_L1
'CONST #R    =1<<#B_R1
'CONST #ZL   =1<<#B_L2
'CONST #ZR   =1<<#B_R2
RETURN

'SPOFSの 補完移動 を プチコンmkII と 同じ指定で 行なう
' PN :管理番号
' PX :X座標
' PY :Y座標
' PT :補完フレーム数
COMMON DEF SPOFS2 PN,PX,PY,PT
 VAR X,Y
 IF PT==0 THEN
  SPOFS PN,PX,PY
 ELSE
  IF PT<1 THEN PT=1
  SPOFS PN,OUT X,Y
  SPANIM PN,"XY",1,X,Y,-PT,PX,PY,1
 ENDIF
END

'BGに 文字列(英数字) を 書きだす
' PN :BGレイヤー
' PX :X座標
' PY :Y座標
' PS$:出力 文字列
COMMON DEF BGPUTSTR PN,PX,PY,PS$
 VAR I
 FOR I=0TO LEN(PS$)-1
  BGPUT PN,PX+I,PY,ASC(MID$(PS$,I,1))
 NEXT
END

'SYSBEEP を 保持 しつつ LOAD する
' PS$:LOADファイル
' PF :LOADダイアログ 表示 フラグ
' PB :LOADコマンド SYSBEEP の 値
'COMMON DEF LOADSB PS$,PF,PB
' VAR S
' S=SYSPARAM("SYSBEEP")
' SYSPARAM "SYSBEEP",PB
' LOAD PS$,PF
' SYSPARAM "SYSBEEP",S
'END

'1曲目 が 定義 されていない場合 2曲目を 演奏
' PT :トラック番号
' PB1:曲 番号 1
' PV1:音量 1
' PB2:曲 番号 2
' PV2:音量 2
COMMON DEF BGMPLAYEX PT,PB1,PV1,PB2,PV2
 BGMPLAY PT,PB1,PV1
 IF !BGMCHK(PT) THEN BGMPLAY PT,PB2,PV2
END

'BGMPLAYEXの1曲目をスルーして2曲目を演奏
' PT :トラック番号
' PB1:曲 番号 1
' PV1:音量 1
' PB2:曲 番号 2
' PV2:音量 2
COMMON DEF BGMPLAYEX2 PT,PB1,PV1,PB2,PV2
 BGMPLAY PT,PB2,PV2
END

'New3DS か Old3DS を 判定 (Thanks! by おちゃめさん)
' 戻り値  1:New3DS
'      0:Old3DS
COMMON DEF NEW3DS()
' VAR M,I
' M=MAINCNT()
' FOR I=0TO 25000:NEXT
' RETURN MAINCNT-M<3
 RETURN 1 '1固定
END

'英数字 フォント を 太字 にする
COMMON DEF FONTBOLD
 VAR S,I,J,K,L,KS,C,C$,S$,G$
 G$="MOT4CM1.GRPF"  'GRPF ファイル名
 S=SYSPARAM("SYSBEEP")
 LOADSB "GRP2:"+G$,0,S
 IF !RESULT() THEN  'LOAD に 失敗したら GRPF を 保存
  SAVE "GRPF:"+G$
  LOADSB "GRP2:"+G$,0,S
  IF !RESULT() THEN RETURN  'SAVE しなかったら 終わり
 ENDIF
 GPAGE 0,2
 GCOPY 0,0,500,16,1,0,0  'X+1 ずらして コピー
 FOR L=0TO 1
  IF !L THEN KS=33 ELSE KS=0
  'GRP を もとに フォント を 定義
  FOR K=KS TO 63
   S$=""
   FOR I=0TO 7
    FOR J=0TO 7
     C=GSPOIT(J+K*8,I+L*8)
     IF !C THEN C$="0"*4 ELSE C$="F"*4
     S$=S$+C$
    NEXT
   NEXT
   FONTDEF L*64+K,S$
  NEXT
 NEXT
 GPAGE 0,0
 GCLS
END

'SPSET & 内部変数0 に 1 をセット
' PN :管理 番号
' PT :定義 番号
COMMON DEF SPSET2 PN,PT
 SPSET PN,PT
 SPVAR PN,0,1
END

'SPCLR & 内部変数0 に 0 をセット
' PN :管理 番号
COMMON DEF SPCLR2 PN
 SPCLR PN
 SPVAR PN,0,0
END

'有効な SP に 対して SPCHK
' PN :管理 番号
COMMON DEF SPCHK2(PN)
 VAR R
 R=0
 IF SPVAR(PN,0) THEN R=SPCHK(PN)
 RETURN R
END

'範囲指定 した レイヤーの BGSTOP
' PS :BGレイヤー 範囲 開始
' PE :BGレイヤー 範囲 終了
COMMON DEF BGSTOPALL PS,PE
 VAR I
 FOR I=PS TO PE
  BGSTOP I
 NEXT
END

'範囲指定 した レイヤーの BGSTART
' PS :BGレイヤー 範囲 開始
' PE :BGレイヤー 範囲 終了
COMMON DEF BGSTARTALL PS,PE
 VAR I
 FOR I=PS TO PE
  BGSTART I
 NEXT
END

'範囲指定 した 管理番号の SPSTOP
' PS :SP管理番号 範囲 開始
' PE :SP管理番号 範囲 終了
COMMON DEF SPSTOPALL PS,PE
 VAR I
 FOR I=PS TO PE
  IF SPVAR(I,0) THEN SPSTOP I
 NEXT
END

'範囲指定 した 管理番号の SPSTART
' PS :SP管理番号 範囲 開始
' PE :SP管理番号 範囲 終了
COMMON DEF SPSTARTALL PS,PE
 VAR I
 FOR I=PS TO PE
  IF SPVAR(I,0) THEN SPSTART I
 NEXT
END

'範囲指定 した 管理番号の SPSTOP (Ver3.2~)
' PS :SP管理番号 範囲 開始
' PE :SP管理番号 範囲 終了
COMMON DEF SPSTOPALL2 PS,PE
 VAR I
 FOR I=PS TO PE
  IF SPUSED(I) THEN SPSTOP I
 NEXT
END

'範囲指定 した 管理番号の SPSTART (Ver3.2~)
' PS :SP管理番号 範囲 開始
' PE :SP管理番号 範囲 終了
COMMON DEF SPSTARTALL2 PS,PE
 VAR I
 FOR I=PS TO PE
  IF SPUSED(I) THEN SPSTART I
 NEXT
END

'範囲指定 した 管理番号の SPCLR (Ver3.2~)
' PS :SP管理番号 範囲 開始
' PE :SP管理番号 範囲 終了
COMMON DEF SPCLRALL2 PS,PE
 VAR I
 FOR I=PS TO PE
  IF SPUSED(I) THEN SPCLR I
 NEXT
END

'英数字 フォント を 太字 にする (高速版)
COMMON DEF FONTBOLD2
 VAR S,G$,B$
 B$="MOT4CM1B.GRPF"  'GRPF ファイル名
 S=SYSPARAM("SYSBEEP")
 LOADSB "GRPF:"+B$,0,S
 IF !RESULT() THEN  'LOAD に 失敗したら GRPF を 作成
  G$="MOT4CM1.GRPF"  'GRPF ファイル名
  LOADSB "GRP2:"+G$,0,S
  IF !RESULT() THEN  'LOAD に 失敗したら GRPF を 保存
   SAVE "GRPF:"+G$
   IF !RESULT() THEN RETURN  'SAVE しなかったら 終わり
   LOADSB "GRP2:"+G$,0,S
  ENDIF
  GPAGE 0,2
  GCOPY 0,0,500,16,1,0,0  'X+1 ずらして コピー
  SAVE "GRP2:"+B$
  IF !RESULT() THEN RETURN  'SAVE しなかったら 終わり
  LOADSB "GRPF:"+B$,0,S
 ENDIF
END

'英数字 フォント を データファイル から ロードする
' PF$ :フォント名
'(※ GRPF未作成時、FDTファイルのロードにSLOT2を使うので注意)
COMMON DEF FONTELOAD PF$
 VAR S,I,J,C$,S$,G$,B$
 DIM A[0]
 B$=PF$+".GRPF"  'GRPF ファイル名
 S=SYSPARAM("SYSBEEP")
 LOADSB "GRPF:"+B$,0,S
 IF !RESULT() THEN  'LOAD に 失敗したら GRPF を 作成
  G$="MOT4CM1.GRPF"  'GRPF ファイル名
  LOADSB "GRP2:"+G$,0,S
  IF !RESULT() THEN  'LOAD に 失敗したら GRPF を 保存
   SAVE "GRPF:"+G$
   IF !RESULT() THEN RETURN  'SAVE しなかったら 終わり
   LOADSB "GRP2:"+G$,0,S
  ENDIF
  LOADSB "PRG2:"+PF$+".FDT",0,S
  IF RESULT() THEN
   USE 2
   RESTORE "2:@"+PF$
   FOR I=0TO 15
    READ S$
    FOR J=0TO LEN(S$)-2
     C$=MID$(S$,J,1)
     PUSH A,VAL(C$)*65535
    NEXT
   NEXT
   GPAGE 0,3
   GCLS
   GLOAD 0,0,511,16,A,1,0
   GPAGE 0,2
   GCOPY 3,264,0,511,15,264,0,1
   GCOPY 3,  0,8,511,15,  0,8,1
  ENDIF
  SAVE "GRP2:"+B$
  IF !RESULT() THEN RETURN  'SAVE しなかったら 終わり
  LOADSB "GRPF:"+B$,0,S
 ENDIF
END

'指定文字数分 右に スペースを 埋める
' PS$ :文字列
' PN  :文字数
COMMON DEF RPAD2$(PS$,PN)
 RETURN LEFT$(PS$+" "*(PN-LEN(PS$)),PN)
END

'右の スペースを 詰める
' PS$ :文字列
COMMON DEF TRIM2$(PS$)
 VAR S$,IN
 IN=INSTR(PS$," ")
 IF IN>=0 THEN
  S$=SUBST$(PS$,INSTR(PS$," "),"")
 ELSE
  S$=PS$
 ENDIF
 RETURN S$
END

'ファイル の 存在を 調べる
' PS$ :ファイル名
COMMON DEF EXIST2(PS$)
 VAR I,R
 DIM FLIST$[0]
 R=0
 FILES FLIST$
 FOR I=0TO LEN(FLIST$)-1
  IF FLIST$[I]=="*"+PS$ THEN R=1:BREAK
 NEXT
 RETURN R
END

'FADE が 終わるまで待つ
COMMON DEF FADEWAIT
 REPEAT
  VSYNC
 UNTIL !FADECHK()
END

'ボタンの ON OFF で WAIT数 を変える
' PB  :BUTTON関数 の第一引数
' PBS :ボタンON 下限 の-1
' PT1 :ボタンOFF時 WAIT数
' PT2 :ボタンON 時 WAIT数
COMMON DEF BUTTONWAIT PB,PBS,PT1,PT2
 VAR B,I,M
 B=BUTTON(PB)
 IF B>PBS THEN M=PT2 ELSE M=PT1
 FOR I=0TO M-1
  VSYNC
 NEXT
END

'スプライト使用時のみ隠す
' PN:SP管理番号
COMMON DEF SPHIDE2 PN
 IF SPUSED(PN) THEN SPHIDE PN
END

'スプライト使用時のみ表示
' PN:SP管理番号
COMMON DEF SPSHOW2 PN
 IF SPUSED(PN) THEN SPSHOW PN
END

'スライドパッドをキーに変換
' PB :取得済ボタン値
' PS#:しきい値
' 戻り :変換ボタン値
'COMMON DEF STICKTOB(PB,PS#)
' VAR B,X#,Y#
' B=PB
' STICK OUT X#,Y#
' IF Y#> PS# THEN B=B OR #UP
' IF Y#<-PS# THEN B=B OR #DOWN
' IF X#<-PS# THEN B=B OR #LEFT
' IF X#> PS# THEN B=B OR #RIGHT
' RETURN B
'END

'BUTTON関数+STICKTOB
' PN:BUTTON関数引数
COMMON DEF BUTTON2(PN)
 VAR B,BT,BTB,F,X,Y
 F=0
 IF PN==1 THEN
  STICK OUT X,Y
  IF !X && !Y THEN
   MOT4CM1_B2_COUNT=0
  ELSE
   INC MOT4CM1_B2_COUNT
   '開始時間
   IF MOT4CM1_B2_COUNT<MOT4CM1_B2_STARTTIME THEN
    IF MOT4CM1_B2_COUNT>MOT4CM1_B2_INTERVAL THEN
     F=1
    ENDIF
   ENDIF
   'インターバル
   IF (MOT4CM1_B2_COUNT MOD MOT4CM1_B2_INTERVAL) THEN
    F=1
   ENDIF
  ENDIF
 ENDIF
 IF F THEN
  B=BUTTON(PN)
 ELSE
  B=STICKTOB(BUTTON(PN),MOT4CM1_B2_SIKII)
 ENDIF
 IF PN==2 THEN
  BT=B-(MOT4CM1_B2_PREV AND B)
  MOT4CM1_B2_PREV=B
  B=BT
 ENDIF
 RETURN B
END

'BUTTON2 しきい値 セット
' (※ DEFAULT値 から 書き変えたいときに使う)
COMMON DEF MOT4CM1B2SIKII PD
 MOT4CM1_B2_SIKII=PD
END

'BUTTON2 開始時間 セット
' (※ DEFAULT値 から 書き変えたいときに使う)
COMMON DEF MOT4CM1B2STARTTIME PD
 MOT4CM1_B2_STARTTIME=PD
END

'BUTTON2 インターバル セット
' (※ DEFAULT値 から 書き変えたいときに使う)
COMMON DEF MOT4CM1B2INTERVAL PD
 MOT4CM1_B2_INTERVAL=PD
END

'SPREAD を プチコンmkII と ほぼ同じ指定で 行なう
' PN :管理番号
' PX :X座標
' PY :Y座標
' PA :角度
' PS :倍率
' PC :定義番号
COMMON DEF SPREAD2 PN OUT PX,PY,PA,PS,PC
 VAR SX,SY
 SPOFS PN OUT PX,PY
 SPROT PN OUT PA
 SPSCALE PN OUT SX,SY
 IF SX>=SY THEN PS=SX ELSE PS=SY
 SPCHR PN OUT PC
END

'BGREAD を プチコンmkII と ほぼ同じ指定で 行なう
' PL :レイヤー
' PX :X座標
' PY :Y座標
' PC :キャラ番号
' PP :パレット番号(0固定)
' PH :横反転
' PV :縦反転
'COMMON DEF BGREAD2 PL,PX,PY OUT PC,PP,PH,PV
' VAR R
' R=BGGET(PL,PX,PY,0)
' PP=0
' PC=R AND 4095
' PH=!!(R AND #BGREVH)
' PV=!!(R AND #BGREVV)
'END

'BGANIM を プチコンmkII と ほぼ同じ指定で 行なう
' PN :管理番号
' PM :枚数
' PT :時間
' PL :ループ
COMMON DEF SPANIM2 PN,PM,PT,PL
 VAR I,D
 DIM PARAM[PM*2]
 SPCHR PN OUT D
 FOR I=0TO PM-1
  PARAM[I*2  ]=PT
  PARAM[I*2+1]=D+I
 NEXT
 SPANIM PN,"I",PARAM,PL
END

'BGGET エラー回避版
' ※ 引数はBGGETと同じ
COMMON DEF BGGET2(PL,PX,PY,PF)
 VAR R=0
 IF PX>=0 && PY>=0 THEN R=BGGET(PL,PX,PY,PF)
 RETURN R
END

'SPANIMが終わるまで待つ
' PN :管理番号
' PB :SPCHK定数
COMMON DEF SPCHKWAIT PN,PB
 WHILE SPCHK(PN) AND PB
  WAIT 1
 WEND
END

'キー,スライドパッドをX,Y座標にして返す
' PX :変換前 X座標
' PY :変換前 Y座標
' PS :スピード
' PX2:変換後 X座標
' PY2:変換後 Y座標
COMMON DEF BSTOXY PX,PY,PS OUT PX2,PY2
 VAR XV,YV
 BSTOXYV PS OUT XV,YV
 PX2=PX+XV
 PY2=PY+YV
END

'キー,スライドパッドをX,Y移動量にして返す
' PS :スピード
' PX2:X移動量
' PY2:Y移動量
COMMON DEF BSTOXYV PS OUT PXV,PYV
 VAR V,B,SX,SY
 V=SQR(4/PI())/0.867
 B=BUTTON()
 STICK OUT SX,SY
 PXV=(!(4AND B)-!(8AND B)+SX*V)*PS
 PYV=(!(1AND B)-!(2AND B)-SY*V)*PS
END

'FONTDEF 簡易版
' PN :文字コード
' PS$:フォント定義文字列 (64文字 0orF)
COMMON DEF FONTDEFS PN,PS$
 VAR I,C$,F$
 F$=""
 FOR I=0TO LEN(PS$)-1
  C$=MID$(PS$,I,1)
  F$=F$+C$*4
 NEXT
 FONTDEF PN,F$
END

'アニメ パラメータ 実行
' PN :管理番号
' PS :アニメ コマ数
' PT :アニメ 時間
' PD :定義番号 先頭
' PL :アニメ ループ数
COMMON DEF PANIMRUN PN,PS,PT,PD,PL
 DIM A[0]
 PANIMSET A,PS,PT,PD
 SPANIM PN,"I",A,PL
END

'アニメ パラメータ 設定
' PA[]:アニメ用 配列
' PS  :アニメ コマ数
' PT  :アニメ 時間
' PD  :定義番号 先頭
COMMON DEF PANIMSET PA[],PS,PT,PD
 VAR I,J
 FOR I=0 TO PS-1
  J=I*2
  PUSH PA,PT
  PUSH PA,PD+I
 NEXT
END

'配列再定義
' PN :要素数
COMMON DEF REDIM(PN)
 DIM A[PN]
 RETURN A
END

'2座標間の長さ
' PX1:X座標1
' PY1:Y座標1
' PX2:X座標2
' PY2:Y座標2
COMMON DEF LENGTH2(PX1,PY1,PX2,PY2)
 VAR L
 '三平方の定理
 L=SQR(POW((PX2-PX1),2)+POW((PY2-PY1),2))
 RETURN L
END

'MOD拡張
' PA :割られる数
' PB :割る数
' PD :割る数が0の場合の戻り値
COMMON DEF MOD2(PA,PB,PD)
 VAR R
 IF PB THEN
  R=PA MOD PB
 ELSE
  R=PD
 ENDIF
 RETURN R
END

'DIV拡張
' PA :割られる数
' PB :割る数
' PD :割る数が0の場合の戻り値
COMMON DEF DIV2(PA,PB,PD)
 VAR R
 IF PB THEN
  R=PA DIV PB
 ELSE
  R=PD
 ENDIF
 RETURN R
END

'----------------------------------------ーーーーーーーーーーーーーーーーーーーーーーーーーーーーー
'3号変換関数

'ATTR 3号変換
' PA :3号ATTR
COMMON DEF AT3(PA)
 VAR A
 A=0
 IF PA AND  2 THEN A=A+#A_ROT90
 IF PA AND  4 THEN A=A+#A_ROT180
 IF PA AND  8 THEN A=A+#A_REVH
 IF PA AND 16 THEN A=A+#A_REVV
 RETURN A
END

'----------------------------------------ーーーーーーーーーーーーーーーーーーーーーーーーーーーーー
'3号BG互換関数

'引数なし BGCLR
COMMON DEF BGCLR3
 VAR I
 FOR I=0 TO 3
  CLS I
 NEXT
END

'引数あり BGCLR
' PN :BGレイヤー
COMMON DEF BGCLR PN
 CLS PN
END

'BGHOME
' PI :BGレイヤー
' PX :原点X
' PY :原点Y
COMMON DEF BGHOME PI,PX,PY
 THOME PI,PX,PY
END

'BGOFS
' PI :BGレイヤー
' PX :座標X
' PY :座標Y
COMMON DEF BGOFS PI,PX,PY
 TOFS PI,PX,PY
END

'BGOFS Z座標指定
' PI :BGレイヤー
' PX :座標X
' PY :座標Y
' PZ :座標Z
COMMON DEF BGOFS3 PI,PX,PY,PZ
 TOFS PI,PX,PY,PZ
END

'BGOFS
' PI :BGレイヤー
' PX :座標X
' PY :座標Y
COMMON DEF BGOFSO PI OUT PX,PY
 TOFS PI OUT PX,PY
END

'BGOFS Z座標指定
' PI :BGレイヤー
' PX :座標X
' PY :座標Y
' PZ :座標Z
COMMON DEF BGOFS3O PI OUT PX,PY,PZ
 TOFS PI OUT PX,PY,PZ
END

'BGPUT
' PI :BGレイヤー
' PX :座標X
' PY :座標Y
' PC :スクリーンデータ
COMMON DEF BGPUT PI,PX,PY,PC
 VAR C,A
 C= PC AND &H0FFF
 A=(PC AND &HF000)>>12
 TPUT PI,PX,PY,C+&HE800+32*(C DIV 32),A
END

'BGFILL
' PI :BGレイヤー
' PX1:始点X
' PY1:始点Y
' PX2:終点X
' PY2:終点Y
' PC :スクリーンデータ
COMMON DEF BGFILL PI,PX1,PY1,PX2,PY2,PC
 VAR C,A
 C= PC AND &H0FFF
 A=(PC AND &HF000)>>12
 TFILL PI,PX1,PY1,PX2,PY2,C+&HE800+32*(C DIV 32),A
END

'BGCHK
' PI :BGレイヤー
COMMON DEF BGCHK(PI)
 RETURN TCHK(PI)
END

'BGSCREEN
' PI :BGレイヤー
' PW :幅
' PH :高さ
COMMON DEF BGSCREEN PI,PW,PH
 TSCREEN PI,16,PW,PH
END

'BGGET キャラ単位
' PI :BGレイヤー
' PX :座標X
' PY :座標Y
COMMON DEF BGGET0(PI,PX,PY)
 RETURN BGGET(PI,PX,PY,0)
END

'BGGET ドット単位
' PI :BGレイヤー
' PX :座標X
' PY :座標Y
COMMON DEF BGGET1(PI,PX,PY)
 RETURN BGGET(PI,PX,PY,1)
END

'BGGET ドット単位
' PI :BGレイヤー
' PX :座標X
' PY :座標Y
' PF :座標系フラグ(0:キャラ単位/1:ドット単位)
COMMON DEF BGGET(PI,PX,PY,PF)
 VAR X,Y,XV,YV,C
 TOFS PI OUT XV,YV
 IF PF THEN '1:ドット単位
  X=(PX-XV) DIV 16
  Y=(PY-YV) DIV 16
 ELSE       '0:キャラ単位
  X=PX-XV
  Y=PY-YV
 ENDIF
 C=CHKCHR(PI,X,Y)-&HE800
 RETURN C
END

'BGCOORD ダミー
' PI :BGレイヤー
' PX1:元座標X
' PY1:元座標Y
' PF :モード(0/1/2)
' PX2:変数/座標X
' PY2:変数/座標Y
COMMON DEF BGCOORD0 PI,PX1,PY1,PF OUT PX2,PY2
 'プチコン4ではまだじっそうされていない
 'とりあえずそのままかえしておく
 PX2=PX1
 PY2=PY1
END

'BGCOLOR
' PI :BGレイヤー
' PC :色コード
COMMON DEF BGCOLOR PI,PC
 TCOLOR PI,PC
END

'BGSTART
' PI :BGレイヤー
COMMON DEF BGSTART PI
 TSTART PI
END

'BGSTOP
' PI :BGレイヤー
COMMON DEF BGSTOP PI
 TSTOP PI
END

'BGCLIP
' PI :BGレイヤー
' PX1:始点X
' PY1:始点Y
' PX2:終点X
' PY2:終点Y
COMMON DEF BGCLIP PI,PX1,PY1,PX2,PY2
 LCLIP 0,PX1,PY1,PX2,PY2
END

'BGANIMは置換が面倒なのでTANIMに個別に書き換え

'----------------------------------------ーーーーーーーーーーーーーーーーーーーーーーーーーーーーー
'3号 その他 互換関数

'DISPLAY
' PN :画面ID
COMMON DEF DISPLAY PN
 'なにもしない
END

'GPAGE
' PN :表示ページ
' PM :操作ページ
COMMON DEF GPAGE PN,PM
 VAR M
 IF PM==5 THEN M=4 ELSE M=PM
 GTARGET M
END

'EFCOFF
COMMON DEF EFCOFF
 'なにもしない
END

'SPCHK 3号互換
' PN :管理番号
COMMON DEF SPCHK3(PN)
 VAR R0,R
 R=0
 R0=SPCHK(PN)
 IF R0 AND #CHKXY THEN R=R+  1
 IF R0 AND #CHKZ  THEN R=R+  2
 IF R0 AND #CHKUV THEN R=R+  4
 IF R0 AND #CHKI  THEN R=R+  8
 IF R0 AND #CHKR  THEN R=R+ 16
 IF R0 AND #CHKS  THEN R=R+ 32
 IF R0 AND #CHKC  THEN R=R+ 64
 IF R0 AND #CHKV  THEN R=R+128
 RETURN R
END

'SPCLIP
' PX1:始点X
' PY1:始点Y
' PX2:終点X
' PY2:終点Y
COMMON DEF SPCLIP PX1,PY1,PX2,PY2
 LCLIP 0,PX1,PY1,PX2,PY2
END

'----------------------------------------ーーーーーーーーーーーーーーーーーーーーーーーーーーーーー
'プチコン4 高解像度 画像使用関数

'SPDEF 高解像度版
' PN :定義番号
' PU :定義座標X
' PV :定義座標Y
' PW :幅
' PH :高さ
' PX :原点X
' PY :原点Y
' PA :アトリビュート
COMMON DEF SPDEFB PN,PU,PV,PW,PH,PX,PY,PA
 SPDEF PN,PU*2,PV*2+1024,PW*2,PH*2,PX*2,PY*2,PA
END

'SPDEF 高解像度 選択
' PN :定義番号
' PU :定義座標X
' PV :定義座標Y
' PW :幅
' PH :高さ
' PX :原点X
' PY :原点Y
' PA :アトリビュート
' PF :高解像度フラグ(0:通常/1:高解像度)
COMMON DEF SPDEF2 PN,PU,PV,PW,PH,PX,PY,PA,PF
 IF !PF THEN
  SPDEF  PN,PU,PV,PW,PH,PX,PY,PA
 ELSE
  SPDEFB PN,PU,PV,PW,PH,PX,PY,PA
 ENDIF
END

'SPCHR 高解像度版
' PN :定義番号
' PU :定義座標X
' PV :定義座標Y
' PW :幅
' PH :高さ
' PX :原点X
' PY :原点Y
' PA :アトリビュート
COMMON DEF SPCHRB PN,PU,PV,PW,PH,PA
 SPCHR PN,PU*2,PV*2+1024,PW*2,PH*2,PA
END

'SPCHR 高解像度 選択
' PN :定義番号
' PU :定義座標X
' PV :定義座標Y
' PW :幅
' PH :高さ
' PX :原点X
' PY :原点Y
' PA :アトリビュート
' PF :高解像度フラグ(0:通常/1:高解像度)
COMMON DEF SPCHR2 PN,PU,PV,PW,PH,PA,PF
 IF !PF THEN
  SPCHR PN,PU,PV,PW,PH,PA
 ELSE
  SPCHRB PN,PU,PV,PW,PH,PA
 ENDIF
END

'----------------------------------------ーーーーーーーーーーーーーーーーーーーーーーーーーーーーー
'ボタンID Joy-Con変換

'UP
' PN :変換フラグ(0:フル、2本持ち/1:Joy-Con左/2:Joy-Con右)
COMMON DEF B2_UP(PN)
 VAR R=0
 IF !PN THEN R=#B_LUP
 RETURN R
END

'DOWN
' PN :変換フラグ(0:フル、2本持ち/1:Joy-Con左/2:Joy-Con右)
COMMON DEF B2_DOWN(PN)
 VAR R=0
 IF !PN THEN R=#B_LDOWN
 RETURN R
END

'LEFT
' PN :変換フラグ(0:フル、2本持ち/1:Joy-Con左/2:Joy-Con右)
COMMON DEF B2_LEFT(PN)
 VAR R=0
 IF !PN THEN R=#B_LLEFT
 RETURN R
END

'RIGHT
' PN :変換フラグ(0:フル、2本持ち/1:Joy-Con左/2:Joy-Con右)
COMMON DEF B2_RIGHT(PN)
 VAR R=0
 IF !PN THEN R=#B_LRIGHT
 RETURN R
END

'A
' PN :変換フラグ(0:フル、2本持ち/1:Joy-Con左/2:Joy-Con右)
COMMON DEF B2_A(PN)
 VAR R
 CASE PN
 WHEN 0   :R=#B_RRIGHT
 WHEN 1   :R=#B_LDOWN
 WHEN 2   :R=#B_RUP
 OTHERWISE:R=0
 ENDCASE
 RETURN R
END

'B
' PN :変換フラグ(0:フル、2本持ち/1:Joy-Con左/2:Joy-Con右)
COMMON DEF B2_B(PN)
 VAR R
 CASE PN
 WHEN 0   :R=#B_RDOWN
 WHEN 1   :R=#B_LLEFT
 WHEN 2   :R=#B_RRIGHT
 OTHERWISE:R=0
 ENDCASE
 RETURN R
END

'X
' PN :変換フラグ(0:フル、2本持ち/1:Joy-Con左/2:Joy-Con右)
COMMON DEF B2_X(PN)
 VAR R
 CASE PN
 WHEN 0   :R=#B_RUP
 WHEN 1   :R=#B_LRIGHT
 WHEN 2   :R=#B_RLEFT
 OTHERWISE:R=0
 ENDCASE
 RETURN R
END

'Y
' PN :変換フラグ(0:フル、2本持ち/1:Joy-Con左/2:Joy-Con右)
COMMON DEF B2_Y(PN)
 VAR R
 CASE PN
 WHEN 0   :R=#B_RLEFT
 WHEN 1   :R=#B_LUP
 WHEN 2   :R=#B_RDOWN
 OTHERWISE:R=0
 ENDCASE
 RETURN R
END

'RANY
' PN :変換フラグ(0:フル、2本持ち/1:Joy-Con左/2:Joy-Con右)
COMMON DEF B2_RANY(PN)
 VAR R
 CASE PN
 WHEN 0   :R=#B_RANY
 WHEN 1   :R=#B_LANY
 WHEN 2   :R=#B_RANY
 OTHERWISE:R=0
 ENDCASE
 RETURN R
END

'L
' PN :変換フラグ(0:フル、2本持ち/1:Joy-Con左/2:Joy-Con右)
COMMON DEF B2_L(PN)
 VAR R
 CASE PN
 WHEN 0   :R=#B_L1
 WHEN 1   :R=#B_SL
 WHEN 2   :R=#B_SL
 OTHERWISE:R=0
 ENDCASE
 RETURN R
END

'R
' PN :変換フラグ(0:フル、2本持ち/1:Joy-Con左/2:Joy-Con右)
COMMON DEF B2_R(PN)
 VAR R
 CASE PN
 WHEN 0   :R=#B_R1
 WHEN 1   :R=#B_SR
 WHEN 2   :R=#B_SR
 OTHERWISE:R=0
 ENDCASE
 RETURN R
END

'ZL
' PN :変換フラグ(0:フル、2本持ち/1:Joy-Con左/2:Joy-Con右)
COMMON DEF B2_ZL(PN)
 VAR R
 CASE PN
 WHEN 0   :R=#B_L2
 WHEN 1   :R=#B_L2
 WHEN 2   :R=#B_R2
 OTHERWISE:R=0
 ENDCASE
 RETURN R
END

'Lスティック押し込み
' PN :変換フラグ(0:フル、2本持ち/1:Joy-Con左/2:Joy-Con右)
COMMON DEF B2_LSTICK(PN)
 VAR R
 CASE PN
 WHEN 0   :R=#B_LSTICK
 WHEN 1   :R=#B_LSTICK
 WHEN 2   :R=#B_RSTICK
 OTHERWISE:R=0
 ENDCASE
 RETURN R
END

'Rスティック押し込み
' PN :変換フラグ(0:フル、2本持ち/1:Joy-Con左/2:Joy-Con右)
COMMON DEF B2_RSTICK(PN)
 VAR R
 CASE PN
 WHEN 0   :R=#B_RSTICK
 WHEN 1   :R=0
 WHEN 2   :R=0
 OTHERWISE:R=0
 ENDCASE
 RETURN R
END

'----------------------------------------ーーーーーーーーーーーーーーーーーーーーーーーーーーーーー
'STICK Joy-Con変換

'STICK Joy-Con変換
' PN :変換フラグ(0:フル、2本持ち/1:Joy-Con左/2:Joy-Con右)
' PC :コントローラーID
' PS :スティックID
' PT :縦持ちフラグ(0:横持ち/1:縦持ち)
' PX :辺値X
' PY :辺値Y
COMMON DEF STICK2 PN,PC,PS,PT OUT PX,PY
 VAR X,Y,XS=1,YS=1,X1,Y1
 CASE PN
 WHEN 0   :STICK PC,PS OUT X,Y
 WHEN 1
  STICK PC, 0 OUT X1,Y1
  IF PT THEN
   X=X1
   Y=Y1
  ELSE
   X=Y1
   Y=X1
   YS=-1
  ENDIF
 WHEN 2   
  STICK PC, 1 OUT X1,Y1
  IF PT THEN
   X=X1
   Y=Y1
  ELSE
   X=Y1
   Y=X1
   XS=-1
  ENDIF
 OTHERWISE:STICK PC,PS OUT X,Y
 ENDCASE
 PX=X*XS
 PY=Y*YS
END

'----------------------------------------ーーーーーーーーーーーーーーーーーーーーーーーーーーーーー
'3ごう -> 4 いしょく メモ
'
'BUTTON : B2_*(MI) をつかう
'STICK  : STICK2   をつかう
' Yじくのほうこうをぎゃくにする
'
'BGOFS
'BGANIM -> TANIM
'BGOFS,BGANIM の X,Yをぎゃくにする
'BGのもとがぞうをさんしょうするさいは、X+1024する
'
'SPCHK  -> SPCHK3
'SPSET,SPCHK の アトリビュートに AT3 をかませる
'SPLINK
'
'MML SEのおんりょうがおおきい VVOL=32 をていぎし、BGMPLAYのおんりょうにせってい
'
'システムへんすうをかんすうにへんかん
' MAINCNT -> MAINCNT()
'
'SAVE,LOAD
'----------------------------------------ーーーーーーーーーーーーーーーーーーーーーーーーーーーーー

]~'aۈ(Ty,J