      S  
 (calc84maniac          C    
calc84maniac                         ^      ^      '''''''''''''''''''''''''''''''''''
' Spooky Maze v0.5.00
' by calc84maniac
'
'''''''''''''''''''''''''''''''''''

OPTION STRICT
ACLS
BGMSTOP -1

'Load raycasting library
LOAD"PRG1:RAYCAST.LIB",FALSE
USE 1
'Load gate texture
DIM GATE%[48,48]
LOAD "DAT:GATE.GSV",GATE%,FALSE
'Load high score
DIM HIGHSCORE%[1]
IF CHKFILE("DAT:BESTLVL.HSC") THEN
 LOAD "DAT:BESTLVL.HSC",HIGHSCORE%,FALSE
ENDIF

'Set up screen
XSCREEN 2,500,3

'Copy wall textures from BG to SP
GPAGE 0,4
GCOPY 5,0,288,255,351,0,0,TRUE
GCOPY 5,352,352,399,399,256,0,TRUE
'Set up map graphics
GPAGE 0,5
GCOPY 160,320,175,335,16,0,TRUE
GCOPY 64,432,79,447,80,0,TRUE
GFILL 48,0,79,15,0
GFILL 48,0,63,3,#GRAY
GFILL 48,6,63,9,#GRAY
GFILL 48,12,63,15,#GRAY
GFILL 64,0,67,15,#GRAY
GFILL 70,0,73,15,#GRAY
GFILL 76,0,79,15,#GRAY
GFILL 96,0,111,15,#NAVY
GPAGE 0,0

'Load clouds and trees into BG
INITBG

'Title screen or something
WHILE 1
 SPCLR
 BGMPLAY 0,34
 VISIBLE 1,1,0,1
 GPRIO 0
 VAR TITLE$="SPOOKY MAZE"
 SPSET 0,3445
 SPSCALE 0,3,3
 SPOFS 0,200,170,32
 SPANIM 0,"I",15,3445,15,3446,15,3447,15,3448,0

 CLS
 LOCATE 18,27,0
 PRINT "Best Level: ";HIGHSCORE%[0]
 
 REPEAT
  VSYNC
  GCLS
  VAR I%
  FOR I%=0 TO LEN(TITLE$)-1
   GPUTCHR 68+24*I%,48+12*SIN(MAINCNT/20+I%/5),TITLE$[I%],3,3
  NEXT
  
  LOCATE 17,23,-16
  IF MAINCNT AND 32 THEN
   PRINT "PRESS ANY BUTTON"
  ELSE
   PRINT "                "
  ENDIF
 UNTIL BUTTON(2)

 BGMSTOP 0,1
 GPRIO 1024
 
 'Define some globals for player attributes
 VAR PX,PY,PZ,PR,ANGLE,DEAD%
 'Define global arrays
 DIM EXPLOSIONS%[0]
 VAR GOTCAT%,GOTKEY%
 VAR CATS%[7]
 'Current level
 VAR LVL%=0
 'Current map level (0-7)
 VAR MAPLVL%

 'Keep playing until the player dies
 REPEAT
  MAPLVL%=((LVL%-1) MOD 7)+1
  VAR RET%=PLAYGAME()
  IF RET% THEN INC LVL%
 UNTIL !RET%
 
 IF LVL%>HIGHSCORE%[0] THEN
  HIGHSCORE%[0]=LVL%
  DIALOG "New high score!"
  SAVE "DAT:BESTLVL.HSC",HIGHSCORE%
 ENDIF
 
WEND 'Loop forever

'Visit the shop
DEF SHOP
 VAR S$,I%,J%,L%=LEN(CATS%)-1
 DIM MSG$[1],MAXES%[1]

 COLOR #TWHITE
 LOCATE 10,2,0:PRINT"Buy somethin' will ya!"
 LOCATE 10,29:PRINT" Select,  Buy,  Quit";

 RESTORE @CHOICES
 FOR I%=1 TO L%
  READ S$,J%
  PUSH MSG$,S$
  PUSH MAXES%,J%
  COLOR #TWHITE-(CATS%[I%]>=J%)
  LOCATE 12,4*I%:PRINT S$
 NEXT
 
 VAR SP%=0
 FOR I%=0 TO L%
  FOR J%=0 TO CATS%[I%]-1
   SPSET SP%,2904
   SPANIM SP%,"I",15,2905,15,2904,0
   IF I%==0 THEN
    SPOFS SP%,80-16*J%,40,-16
   ELSE
    SPOFS SP%,250+16*J%,32*I%+8,-16
   ENDIF
   INC SP%
  NEXT
 NEXT
 
 VAR CHOICE%=1
 REPEAT
  VSYNC
  VAR B%=BUTTON(2)
  VAR NEW%=CHOICE%
  IF B% AND #UP THEN NEW%=((NEW%+L%-2) MOD L%)+1
  IF B% AND #DOWN THEN NEW%=(NEW% MOD L%)+1
  IF NEW%!=CHOICE% THEN
   CHOICE%=NEW%
   FOR SP%=0 TO CATS%[0]-1
    SPOFS SP% OUT I%,
    SPANIM SP%,"XY",-15,I%,32*CHOICE%+8
   NEXT
  ENDIF
  IF B% AND #A && CATS%[0]>0 THEN
   IF CATS%[CHOICE%]<MAXES%[CHOICE%] THEN
    BEEP 69
    DEC CATS%[0]
    SP%=CATS%[0]
    SPANIM SP%,"XY",-30,250+16*CATS%[CHOICE%],32*CHOICE%+8
    INC CATS%[CHOICE%]
    IF CATS%[CHOICE%]>=MAXES%[CHOICE%] THEN
     COLOR #TGRAY
     LOCATE 12,4*CHOICE%:PRINT MSG$[CHOICE%]
    ENDIF
   ELSE
    BEEP 2
   ENDIF
  ENDIF
 UNTIL B% AND #B
 
 CLS
 SPCLR
END

@CHOICES
DATA "Bomb Cooking",1
DATA "Fuse Time Down",4
DATA "Reload Time Down",5
DATA "Explosion Size Up",3
DATA "Explosion Time Up",4
DATA "Death Defy (Once)",1

'Play the game!
DEF PLAYGAME()
 'Reset some graphics
 DISPLAY 1
 SPCLR
 BGCLR
 DISPLAY 0
 SPCLR
 CLS
 VISIBLE 1,0,0,1
 IF CATS%[0]>0 THEN
  DIALOG FORMAT$("You've saved %D cat%S!%SVisit the upgrade store?",CATS%[0],"s"*(CATS%[0]!=1),CHR$(13)),3
  IF RESULT>0 THEN SHOP
 ENDIF

 COLOR #TWHITE
 LOCATE 19,13:PRINT ""
 LOCATE 19,14:PRINT "         "
 LOCATE 19,15:PRINT " LEVEL   "
 LOCATE 19,16:PRINT "         "
 LOCATE 19,17:PRINT ""
 LOCATE 27,15:PRINT LVL%
 WAIT 120
 CLS

 VISIBLE 1,1,1,1
 GPAGE 0,4
 GLOAD 352,0,48,48,GATE%,1,TRUE
 GPAGE 0,0

 'Initialize raycaster library
 VAR RAYS%=160
 IF HARDWARE==0 THEN RAYS%=RAYS%/3
 INITRAYLIB 500-RAYS%,499,0,0,399,239

 'Set view callback
 SETVIEWCALLBACK "VIEWMAP"

 'Set wall textures
 DIM TEX%[5,4]
 COPY TEX%,@TEX
 SETTEX TEX%

 'Set map array
 VAR MAPW%=(8<<(MAPLVL% DIV 2))+1,MAPH%=MAPW%
 DIM MAP%[MAPH%,MAPW%]
 SETMAP MAP%,MAPW%,MAPH%
 
 'Set lighting color
 SETLIGHT #BLACK

 'Initialize map contents
 INITMAP MAP%,MAPW%,MAPH%

 'Spawn skeletons
 SPAWNOBJECTS MAP%,MAPW%,MAPH%

 'Create bomb sprite
 VAR BOMB%=SPSET(2292)
 SPSCALE BOMB%,10,10
 SPROT BOMB%,-20
 SPOFS BOMB%,270,250,0
 
 'Create BG and sprite for lower screen
 DISPLAY 1
 BGSCREEN 0,MAPW%,MAPH%
 BGHOME 0,160,120
 VAR MAPSCALE=POW(2,-(MAPLVL%>1)-(MAPLVL%>5))
 BGSCALE 0,MAPSCALE,MAPSCALE
 BGCLIP 0,40,0,279,239
 SPSET 0,2784
 SPOFS 0,160,124
 SPSCALE 0,MAPSCALE*2,MAPSCALE*2
 DISPLAY 0

 'Play spooky music
 IF !BGMCHK(0) THEN BGMPLAY 0,21

 'Initialize camera/player data
 PX=1.5:PY=1.5:PZ=0.5
 ANGLE=PI()/4
 VAR ZLOOK=0,FOV=PI()*0.4

 'Set player movement speeds and radius
 VAR MSPEED=0.05
 VAR SSPEED=0.03
 VAR TSPEED=0.04
 VAR LSPEED=5
 PR=0.3

 'FPS and animation variables
 VAR LAST%=MAINCNT
 'VAR FPS%=0
 VAR WALKTIME%=0
 VAR COOKING%=0

 'Loop until dead or won
 DEAD%=FALSE
 VAR WON%=FALSE
 VAR CANLEAVE%=FALSE
 GOTCAT%=FALSE
 GOTKEY%=FALSE
 WHILE !DEAD% && !WON%
  'Get input information
  VAR B%=BUTTON()
  VAR SX,SY
  STICK OUT SX,SY

  VAR STRAFE%=!!(B% AND #R)-!!(B% AND #L)
 
  'Do movement if stick is not centered
  IF SX || SY || STRAFE% THEN
   'Try to walk/strafe
   VAR NEWX=PX+MSPEED*SY*COS(ANGLE)-SSPEED*STRAFE%*SIN(ANGLE)
   'WON%=WON% || GATECOLLIDE(NEWX,PY,0,PR)
   IF !MAPCOLLIDE(NEWX,PY,0,PR) THEN PX=NEWX
   VAR NEWY=PY+MSPEED*SY*SIN(ANGLE)+SSPEED*STRAFE%*COS(ANGLE)
   'WON%=WON% || GATECOLLIDE(PX,NEWY,0,PR)
   IF !MAPCOLLIDE(PX,NEWY,0,PR) THEN PY=NEWY

   'Turn view
   INC ANGLE,TSPEED*SX
  
   'Progress walk animation
   INC WALKTIME%
  ENDIF
 
  IF GATECOLLIDE(PX,PY,0,1.0) THEN
   IF !CANLEAVE% THEN
    CANLEAVE%=TRUE
    LOCATE 22,15,0:PRINT "LEAVE "
   ENDIF
  ELSE
   IF CANLEAVE% THEN
    CANLEAVE%=FALSE
    LOCATE 22,15,0:PRINT "       "
   ENDIF
  ENDIF
 
  'Bob camera and bomb up and down
  PZ=0.6+0.05*ABS(SIN(WALKTIME%*PI()/30))
  SPOFS BOMB%,270,250+20*ABS(SIN(WALKTIME%*PI()/30))
 
  'Look up or down
  IF B% AND #X THEN ZLOOK=MIN(ZLOOK+LSPEED,150)
  IF B% AND #B THEN ZLOOK=MAX(ZLOOK-LSPEED,-150)
 
  'Throw a bomb if ready
  IF COOKING% && !(CATS%[1] && B% AND #A && SPCHK(BOMB%) AND #CHKI) THEN
   THROWBOMB BOMB%,PX,PY,PZ-0.2,ANGLE,SIN(ATAN(ZLOOK,300))/5
   'Make new bomb to hold
   BOMB%=SPSET(2292)
   SPSCALE BOMB%,10,10
   SPROT BOMB%,-180
   SPOFS BOMB%,270,250,0
   SPANIM BOMB%,"R",90-15*CATS%[3],-180,-20,-20
   COOKING%=FALSE
  ELSEIF B% AND #A && !(COOKING% || SPCHK(BOMB%) AND #CHKR) THEN
   'Animate ticking
   SPANIM BOMB%,"I",20,2292,20,2293,5-CATS%[2]
   COOKING%=TRUE
  ENDIF

  'Die in explosions
  VAR E%=COLLIDE_EXPLOSIONS(PX,PY,PR)
  IF E%>=0 THEN
   IF CATS%[6] THEN
    DEC CATS%[6]
    SPSTOP E%
   ELSE
    DEAD%=TRUE
   ENDIF
   SPBEEP3D E%,80,-1000,127
  ENDIF

  VSYNC
  'Display FPS
  'IF MAINCNT>=LAST%+60 THEN 
  ' LOCATE 0,0,-20
  ' PRINT "FPS:",FPS%,
  ' LAST%=MAINCNT
  ' FPS%=0
  'ENDIF
  'INC FPS%

  VAR C=COS(ANGLE),S=SIN(ANGLE)
 
  'Fill sky and floor
  GFILL 0,0,399,119+ZLOOK,RGB(128,32,16)
  GFILL 0,120+ZLOOK,399,239,RGB(16,64,16)
 
  'Scroll clouds and trees
  VAR BGX%=(ANGLE/PI()*1000) MOD 800
  IF BGX%<0 THEN INC BGX%,800
  BGOFS 0,BGX% MOD 400,120-ZLOOK,1023
  BGOFS 1,BGX% MOD 400,-40-ZLOOK,1023
  BGOFS 2,BGX% DIV 2,10-ZLOOK/2,MIN(128+MAX((C>0)*MAPW%-C*PX,(S>0)*MAPH%-S*PY)*64,1023)

  'Update map and player animation
  DISPLAY 1
  BGOFS 0,PX*16,PY*16
  BGPUT 0,PX,PY,6
  IF ABS(C)>ABS(S) THEN
   SPCHR 0,2784+(WALKTIME%>>4 AND 3)+(C<0)*8
  ELSE
   SPCHR 0,2788+(WALKTIME%>>4 AND 3)+(S<0)*8 
  ENDIF

  IF !(SPCHK(0) AND #CHKS) THEN
   BGSCALE 0 OUT S,
   C=S
   IF B% AND #UP THEN C=MIN(S*2,1.0)
   IF B% AND #DOWN THEN C=MAX(S/2,0.25)
   IF C!=S THEN   
    BGANIM 0,"S",-20,C,C,1
    SPANIM 0,"S",-20,C*2,C*2,1
   ENDIF
  ENDIF
  DISPLAY 0

  'Set camera and update scene
  SETCAM PX,PY,PZ,ANGLE,ZLOOK,FOV
  CALL SPRITE
  
  'Do you really want to leave? Can you?
  IF CANLEAVE% && B% AND #Y THEN
   SPSTOP
   IF GOTKEY% THEN
    IF GOTCAT% THEN
     DIALOG "Leave this area?",3
    ELSE
     DIALOG "Leave without the cat?",3
    ENDIF
    IF RESULT>0 THEN WON%=TRUE
   ELSE
    DIALOG "You can't leave without the key!"
   ENDIF
   SPSTART
  ENDIF
 WEND

 WHILE LEN(EXPLOSIONS%)
  B%=POP(EXPLOSIONS%)
 WEND

 'You died.
 IF DEAD% THEN
  BGMSTOP 0 
  FADE #RED,60
  DISPLAY 1
  FADE #RED,60
  DISPLAY 0
  WAIT 60

  BACKCOLOR #RED
  VISIBLE 1,0,0,0
  CLS
  WIDTH 16
  LOCATE 6,7,-128

  VAR D$="YOU ARE DEAD."
  FADE 0
  WHILE LEN(D$)
   IF ASC(D$)!=32 THEN BEEP 0,1200
   PRINT SHIFT(D$);
   WAIT 6
  WEND
  
  REPEAT
   VSYNC
  UNTIL BUTTON(2)
  
  DISPLAY 1
  SPCLR
  BGCLR
  FADE 0
  DISPLAY 0

  WIDTH 8
  BACKCOLOR #BLACK
 
  CLS
 ELSE
  INC CATS%[0],GOTCAT%
  BEEP 99
  FADE #BLACK,72
  DISPLAY 1
  FADE #BLACK,72
  DISPLAY 0
  
  'Open the gate!
  VAR I%
  FOR I%=0 TO 23
   GPAGE 0,4
   GCOPY 352-I%,0,375-I%,47,351-I%,0,TRUE
   GCOPY 376+I%,0,399+I%,47,377+I%,0,TRUE
   GFILL 375-I%,0,376+I%,47,0
   GPAGE 0,0
   VSYNC 3
   CALL SPRITE
  NEXT
  
  FADE 0
  DISPLAY 1
  FADE 0
  DISPLAY 0
 ENDIF

 RETURN WON%
END

'Check collision with map in a square radius,
'using helper function which returns number
'of walls collided.
DEF MAPCOLLIDE(X,Y,Z,R)
 RETURN MAPCHK("COLLIDE",X,Y,Z,R)>0
END

DEF GATECOLLIDE(X,Y,Z,R)
 RETURN MAPCHK("GATECHK",X,Y,Z,R)>0
END

DEF GATECHK(MAP%,X%,Y%,Z)
 RETURN MAP%[Y%,X%]==5
END

'Create a key at the given position.
DEF MAKEKEY X,Y
 VAR SP%
 SPSET 2146 OUT SP%
 'Set X,Y,Z coordinates and height
 SPVAR SP%,0,X
 SPVAR SP%,1,Y
 SPVAR SP%,2,0.0
 SPVAR SP%,3,0.3
 'Set callback function
 SPFUNC SP%,"KEY_CB"
END

'Key callback function
DEF KEY_CB
 IF !GOTKEY% THEN
  'Get X,Y coordinates
  VAR X=SPVAR(CALLIDX,0)
  VAR Y=SPVAR(CALLIDX,1)
 
  'Check for distance from player
  VAR DIST_SQ=POW(X-PX,2)+POW(Y-PY,2)
  IF DIST_SQ<0.5*0.5 THEN
   'Pick up key
   SPBEEP3D CALLIDX,12,0,127
   GOTKEY%=TRUE
   SPOFS CALLIDX,380,32,0
   SPSCALE CALLIDX,2,2
  ELSE
   SPWORLD
  ENDIF
 ENDIF
END

'Create a lantern at the given position.
DEF MAKELANTERN X,Y
 VAR SP%
 SPSET 2266 OUT SP%
 'Set X,Y,Z coordinates and height
 SPVAR SP%,0,X
 SPVAR SP%,1,Y
 SPVAR SP%,2,0.0
 SPVAR SP%,3,0.5

 SPANIM SP%,"C",-10,RGB(255,255,128),-10,#WHITE,0
 SPFUNC SP%,"LANTERN_CB"
END

'Lantern callback function
DEF LANTERN_CB
 IF !SPVAR(CALLIDX,7) THEN
  'Get X,Y coordinates
  VAR X=SPVAR(CALLIDX,0)
  VAR Y=SPVAR(CALLIDX,1)
 
  'Check for distance from player
  VAR DIST_SQ=POW(X-PX,2)+POW(Y-PY,2)
  IF DIST_SQ<0.5*0.5 THEN
   'Pick up lantern
   SETLIGHT RGB(128,128,0)
   SPBEEP3D CALLIDX,100,-250,127
   SPSCALE CALLIDX,2,2
   SPHOME CALLIDX,8,1
   SPOFS CALLIDX,16,8,0
   SPVAR CALLIDX,7,1
   SPROT CALLIDX,10
   SPVAR CALLIDX,6,0
   SPVAR CALLIDX,5,ANGLE
  ELSE
   SPWORLD
  ENDIF
 ELSE
  VAR R,VR=SPVAR(CALLIDX,6)
  VAR LAST=SPVAR(CALLIDX,5)
  SPROT CALLIDX OUT R
  INC R,VR
  INC VR,-SGN(R+DEG(LAST-ANGLE)*6)*0.15
  SPROT CALLIDX,R
  SPVAR CALLIDX,5,ANGLE
  SPVAR CALLIDX,6,VR
 ENDIF
END

'Create a cat at the given position.
DEF MAKECAT X,Y
 VAR SP%
 SPSET 2908 OUT SP%
 'Set X,Y,Z coordinates and height
 SPVAR SP%,0,X
 SPVAR SP%,1,Y
 SPVAR SP%,2,0.0
 SPVAR SP%,3,0.5
 'Set destination X,Y
 SPVAR SP%,4,X
 SPVAR SP%,5,Y
 'Set callback function
 SPFUNC SP%,"CAT_CB"
END

'Cat callback function.
DEF CAT_CB
 'Get X,Y coordinates
 VAR X=SPVAR(CALLIDX,0)
 VAR Y=SPVAR(CALLIDX,1)
 'Get destination X,Y coordinates
 VAR DX=SPVAR(CALLIDX,4)
 VAR DY=SPVAR(CALLIDX,5)
 
 'Check if can see player
 GOTCAT%=CANSEE(X,Y,PX,PY)
 
 'Check for distance from player
 VAR DIST_SQ=POW(X-PX,2)+POW(Y-PY,2)
 IF DIST_SQ<0.8*0.8 THEN
  'You're a kitty!
  DX=X:DY=Y
 ELSEIF GOTCAT% THEN
  'Set destination to player position
  DX=PX:DY=PY
 ENDIF
 
 MOVETOWARD X,Y,DX,DY,0.03,0.2 OUT X,Y
 
 'Update animation
 IF !(SPCHK(CALLIDX) AND #CHKI) THEN
  IF X==DX && Y==DY THEN
   'Sitting sprite
   SPCHR CALLIDX,2908
  ELSE
   'Walking animation
   SPANIM CALLIDX,"I",15,2905,15,2904,1
  ENDIF
 ENDIF
 
 'Save X,Y coordinates
 SPVAR CALLIDX,0,X
 SPVAR CALLIDX,1,Y
 'Save destination coordinates
 SPVAR CALLIDX,4,DX
 SPVAR CALLIDX,5,DY
 
 'Display sprite in 3D world
 SPWORLD
 
 'Occasionally meow
 IF !(SPCHK(CALLIDX) AND #CHKV) THEN
  IF SPVAR(CALLIDX,7) THEN SPBEEP3D CALLIDX,69,0,127
  SPANIM CALLIDX,"V",RND(500+200*GOTCAT%)+100*(GOTCAT%+1),1,1
 ENDIF

 'Collide with explosions
 IF COLLIDE_EXPLOSIONS(X,Y,0.2)>=0 THEN
  SPCHR CALLIDX,2920
  'SPVAR CALLIDX,3,0.5
  SPFUNC CALLIDX,"SPWORLD"
  SPBEEP3D CALLIDX,69,-500,127
  GOTCAT%=FALSE
 ENDIF
END

'Create a skeleton at the given coordinates.
DEF MAKESKELETON X,Y
 VAR SP%
 SPSET 3445 OUT SP%
 'Set X,Y,Z coordinates and height
 SPVAR SP%,0,X
 SPVAR SP%,1,Y
 SPVAR SP%,2,0.0
 SPVAR SP%,3,1.0
 'Set destination X,Y
 SPVAR SP%,4,X
 SPVAR SP%,5,Y
 'Set speed
 SPVAR SP%,6,0.01
 'Walking animation
 SPANIM SP%,"I",15,3445,15,3446,15,3447,15,3448,0
 'Set callback function
 SPFUNC SP%,"SKELETON_CB"
END

'Skeleton callback function.
DEF SKELETON_CB
 'Get X,Y coordinates
 VAR X=SPVAR(CALLIDX,0)
 VAR Y=SPVAR(CALLIDX,1)

 'Ignore skeletons that are far away
 VAR DIST_SQ=POW(X-PX,2)+POW(Y-PY,2)
 IF DIST_SQ>100 THEN SPHIDE CALLIDX:RETURN

 'Get destination X,Y coordinates
 VAR DX=SPVAR(CALLIDX,4)
 VAR DY=SPVAR(CALLIDX,5)
 
 'Check for intersection with player
 IF DIST_SQ<POW(PR+PR,2) THEN
  'Stop movement, play sound effect, die 
  SPBEEP3D CALLIDX,103,0,127
  SPANIM CALLIDX,"I",1,3457,20,3458,20,3459,1
  DEAD%=TRUE
 ELSEIF CANSEE(X,Y,PX,PY) THEN
  'Set destination to player position
  DX=PX:DY=PY
  'Speed up
  SPVAR CALLIDX,6,0.005*(3+(LVL%-1) DIV 7)
 ENDIF
 
 MOVETOWARD X,Y,DX,DY,SPVAR(CALLIDX,6),PR OUT X,Y
 
 IF X==DX AND Y==DY THEN
  'Get new destination randomly
  REPEAT
   VAR D%=RND(5)
   DX=FLOOR(X)+0.5
   DY=FLOOR(Y)+0.5
   IF D%==1 THEN DEC DX
   IF D%==2 THEN INC DX
   IF D%==3 THEN DEC DY
   IF D%==4 THEN INC DY
  UNTIL !MAPCOLLIDE(DX,DY,0,0)
  'Slow down
  SPVAR CALLIDX,6,0.01
 ENDIF
 
 'Save X,Y coordinates
 SPVAR CALLIDX,0,X
 SPVAR CALLIDX,1,Y
 'Save destination coordinates
 SPVAR CALLIDX,4,DX
 SPVAR CALLIDX,5,DY
 
 'Display sprite in 3D world
 SPWORLD
 
 'Occasionally make a sound
 IF !(SPCHK(CALLIDX) AND #CHKV) THEN
  IF SPVAR(CALLIDX,7) THEN SPBEEP3D CALLIDX,98,-500,127
  SPANIM CALLIDX,"V",RND(300)+100,1,1
 ENDIF

 'Collide with explosions
 IF COLLIDE_EXPLOSIONS(X,Y,PR)>=0 || DEAD% && CATS%[6] THEN
  IF DEAD% && CATS%[6] THEN
   DEAD%=FALSE
   DEC CATS%[6]
  ENDIF
  SPCHR CALLIDX,3463
  SPVAR CALLIDX,3,0.5
  SPFUNC CALLIDX,"SPWORLD"
  SPBEEP3D CALLIDX,98,-1500,127
 ENDIF
END

'Move to a destination at the given speed
'and collide with walls. Tries not to get
'stuck going around corners.
DEF MOVETOWARD X,Y,DX,DY,SPEED,R OUT OX,OY
 'Move towards destination
 VAR VX=DX-X
 VAR VY=DY-Y
 VAR DIST=SQR(VX*VX+VY*VY)
 IF DIST<SPEED THEN
  'Stop at destination
  X=DX:Y=DY
 ELSE
  'Move with collisions,
  'also try to get around corners
  VAR NEWX=X+VX/DIST*SPEED
  IF MAPCOLLIDE(NEWX,Y,0,R) THEN
   IF MAPCOLLIDE(NEWX+SGN(VX)*R,Y,0,0) THEN
    VY=SGN(VY)*DIST
   ELSEIF ABS(VX)>ABS(VY) THEN
    VY=SGN(0.5-(Y*2 MOD 2))*DIST
   ENDIF
  ELSE
   X=NEWX
  ENDIF
  VAR NEWY=Y+VY/DIST*SPEED
  IF MAPCOLLIDE(X,NEWY,0,R) THEN
   IF MAPCOLLIDE(X,NEWY+SGN(VY)*R,0,0) THEN
    NEWX=X+SGN(VX)*SPEED
   ELSEIF ABS(VY)>ABS(VX) THEN
    NEWX=X+SGN(0.5-(X*2 MOD 2))*SPEED
   ENDIF
   IF !MAPCOLLIDE(NEWX,Y,0,R) THEN X=NEWX
  ELSE
   Y=NEWY
  ENDIF  
 ENDIF
 
 OX=X
 OY=Y
END

'Throw a bomb from the given position,
'traveling at the given angle and vertical
'velocity.
DEF THROWBOMB SP%,X,Y,Z,ANGLE,VZ
 VAR SCALE=SQR(1-VZ*VZ)
 VAR C=COS(ANGLE), S=SIN(ANGLE)
 'Set position
 SPVAR SP%,0,X+C*0.2-S*0.1
 SPVAR SP%,1,Y+S*0.2+C*0.1
 SPVAR SP%,2,Z
 'Set height
 SPVAR SP%,3,0.4
 'Set velocity
 SPVAR SP%,4,C*0.1*SCALE
 SPVAR SP%,5,S*0.1*SCALE
 SPVAR SP%,6,VZ
 'Animate rotation
 SPANIM SP%,"R",-20,0,1
 'Play sound effect if not already exploded
 IF SPCHK(SP%) AND #CHKI THEN SPBEEP3D SP%,10,0,96
 'Set callback function
 SPFUNC SP%,"BOMB_CB"
END

'Bomb callback function.
DEF BOMB_CB
 'Get position and velocity
 VAR X=SPVAR(CALLIDX,0)
 VAR Y=SPVAR(CALLIDX,1)
 VAR Z=SPVAR(CALLIDX,2)
 VAR VX=SPVAR(CALLIDX,4)
 VAR VY=SPVAR(CALLIDX,5)
 VAR VZ=SPVAR(CALLIDX,6)
 
 'Move in X direction
 INC X,VX
 'Bounce off walls
 IF MAPCOLLIDE(X,Y,Z,0.1) THEN
  DEC X,VX
  VX=VX*-0.2
 ENDIF
 
 'Move in Y direction
 INC Y,VY
 'Bounce off walls
 IF MAPCOLLIDE(X,Y,Z,0.1) THEN
  DEC Y,VY
  VY=VY*-0.2
 ENDIF
 
 'Get floor height (0 or 1)
 VAR FLOORZ=MAPCOLLIDE(X,Y,0,0.1)
 'Move in Z direction
 INC Z,VZ
 'Bounce off floors and apply friction
 IF Z<FLOORZ THEN
  Z=FLOORZ
  VZ=-0.6*VZ
  VX=0.6*VX
  VY=0.6*VY
 ENDIF
 
 'Apply gravity
 DEC VZ,0.005
 
 'Save position and velocity
 SPVAR CALLIDX,0,X
 SPVAR CALLIDX,1,Y
 SPVAR CALLIDX,2,Z
 SPVAR CALLIDX,4,VX
 SPVAR CALLIDX,5,VY
 SPVAR CALLIDX,6,VZ
 
 'Display sprite in 3D world
 SPWORLD
 
 'If animation timed out, explode
 IF !(SPCHK(CALLIDX) AND #CHKI) THEN
  'Switch to explosion animation
  SPANIM CALLIDX,"I",4,3394,4,3395,2+CATS%[5]
  'Set new larger size and higher position
  VAR ER=0.35+0.05*CATS%[4]
  SPVAR CALLIDX,3,ER*3
  SPVAR CALLIDX,2,Z+ER
  'Call explosion function on all walls
  'in a square radius of 0.4
  VAR COUNT%=MAPCHK("EXPLODE",X,Y,Z,ER)
  'Switch to explosion callback
  SPFUNC CALLIDX,"EXPLOSION_CB"
  'Play explosion sound
  SPBEEP3D CALLIDX,13,0,127
  'Add to explosion list
  PUSH EXPLOSIONS%,CALLIDX
 ENDIF
END

'Remove a stone wall and play sound effect
DEF EXPLODE(MAP%,X%,Y%,Z)
 IF MAP%[Y%,X%]==1 THEN
  BEEP3D X%+0.5,Y%+0.5,0.5,95,0,127
  MAP%[Y%,X%]=0
  DISPLAY 1
  BGPUT 0,X%,Y%,0
  DISPLAY 0
  RETURN 1
 ENDIF
 RETURN 0 
END

'Explosion callback function.
DEF EXPLOSION_CB
 'Display sprite in 3D world
 SPWORLD
 
 'If animation ended, clear sprite
 IF !(SPCHK(CALLIDX) AND #CHKI) THEN
  SPCLR CALLIDX
  'Remove from explosion list
  VAR I%=0
  WHILE EXPLOSIONS%[I%]!=CALLIDX
   I%=I%+1
  WEND
  SWAP EXPLOSIONS%[I%],EXPLOSIONS%[LEN(EXPLOSIONS%)-1]
  I%=POP(EXPLOSIONS%)
 ENDIF
END

'Return explosion if one is colliding
'with object at X,Y and given radius,
'-1 otherwise
DEF COLLIDE_EXPLOSIONS(X,Y,RADIUS)
 VAR I%
 FOR I%=0 TO LEN(EXPLOSIONS%)-1
  VAR E%=EXPLOSIONS%[I%]
  VAR EX=SPVAR(E%,0)
  VAR EY=SPVAR(E%,1)
  VAR ER=SPVAR(E%,3)/3
  IF POW(EX-X,2)+POW(EY-Y,2)<POW(ER+RADIUS,2) THEN RETURN E%
 NEXT
 RETURN -1
END

'View callback
DEF VIEWMAP MAP%,X,Y
 DISPLAY 1
 IF !CHKCHR(X,Y) THEN
  BGPUT 0,X,Y,MAP%[Y,X]
 ENDIF
 DISPLAY 0
END

'Drop in random skeletons and things
DEF SPAWNOBJECTS MAP%,W%,H%
 VAR SCALE=1<<MAPLVL%
 VAR I,J,K%=RND(SCALE)+(SCALE DIV 2)
 REPEAT
  I=RND(W%-2)+1.5
  J=RND(H%-2)+1.5
  IF I<5 && J<5 || MAP%[J,I] || CANSEE(I,J,1.5,1.5) THEN CONTINUE
  IF K%>0 THEN
   MAKESKELETON I,J
  ELSEIF K%==0 THEN
   MAKECAT I,J
  ELSEIF K%==-1 THEN
   MAKEKEY I,J
  ELSE
   MAKELANTERN I,J
  ENDIF
  DEC K%
 UNTIL K%<-2
END

'Initialize map array.
DEF INITMAP MAP%,W%,H%
 VAR I%,J%
 FOR I%=0 TO W%-1
  MAP%[0,I%]=3
  MAP%[H%-1,I%]=3
 NEXT
 FOR J%=0 TO H%-1
  MAP%[J%,0]=4
  MAP%[J%,W%-1]=4
 NEXT
 
 IF RND(2) THEN
  MAP%[H%-1,RND(W% DIV 2-1)*2+1]=5
 ELSE
  MAP%[RND(H% DIV 2-1)*2+1,W%-1]=5
 ENDIF
  
 FOR J%=1 TO W%-2
  FOR I%=1 TO H%-2
   MAP%[J%,I%]=2*(NOT (J% AND I%) AND 1)
  NEXT
 NEXT
 
 GENMAZE MAP%,1,1,W%-2,H%-2

 FOR J%=1 TO W%-2
  FOR I%=1 TO H%-2
   IF !RND(10) THEN MAP%[J%,I%]=1
  NEXT
 NEXT
 
 'Make sure player is in empty space
 MAP%[1,1]=0
 MAP%[1,2]=0
 MAP%[2,1]=0
END

'Generate maze recursively.
'Map size must be square of size 2^N-1.
DEF GENMAZE MAP%,I%,J%,W%,H%
 IF W%==1 || H%==1 THEN RETURN
 VAR MIDW%=W% DIV 2
 VAR MIDH%=H% DIV 2
 VAR EXCLUDE%=RND(4)
 IF EXCLUDE%!=0 THEN MAP%[J%+MIDH%,I%+2*RND(MIDW% DIV 2+1)]=0
 IF EXCLUDE%!=1 THEN MAP%[J%+MIDH%,I%+MIDW%+1+2*RND(MIDW% DIV 2+1)]=0
 IF EXCLUDE%!=2 THEN MAP%[J%+2*RND(MIDH% DIV 2+1),I%+MIDW%]=0
 IF EXCLUDE%!=3 THEN MAP%[J%+MIDW%+1+2*RND(MIDH% DIV 2+1),I%+MIDW%]=0
 GENMAZE MAP%,I%,J%,MIDW%,MIDH%
 GENMAZE MAP%,I%+MIDW%+1,J%,MIDW%,MIDH%
 GENMAZE MAP%,I%,J%+MIDH%+1,MIDW%,MIDH%
 GENMAZE MAP%,I%+MIDH%+1,J%+MIDH%+1,MIDW%,MIDH%
END

'Initialize BG with random clouds.
DEF INITBG
 DIM CLOUD%[2,4]
 COPY CLOUD%,@CLOUD
 BGSCREEN 0,50,15
 BGCLIP 0,2,0,397,239

 VAR I%
 FOR I%=0 TO 9
  REPEAT
   VAR X%=RND(25)
   VAR Y%=RND(13)
   VAR FINE%=TRUE
   VAR DX%,DY%
   FOR DX%=0 TO 3
    FOR DY%=0 TO 1
     IF BGGET(0,X%+DX%,Y%+DY%) THEN FINE%=FALSE
    NEXT
   NEXT
  UNTIL FINE%
  BGLOAD 0,X%-25,Y%,4,2,CLOUD%
  BGLOAD 0,X%,Y%,4,2,CLOUD%
  BGLOAD 0,X%+25,Y%,4,2,CLOUD%
 NEXT
 
 BGCOLOR 0,RGB(32,32,32)
 BGSHOW 0
 
 DIM TREES%[5,5]
 COPY TREES%,@TREES
 
 BGSCREEN 1,50,5
 BGCLIP 1,2,0,397,239
 FOR I%=0 TO 49 STEP 5
  BGLOAD 1,I%,0,5,5,TREES%
 NEXT
 BGCOLOR 1,RGB(0,0,0)
 BGSHOW 1

 BGSCREEN 2,50,5
 BGCLIP 2,2,0,397,239
 FOR I%=0 TO 49 STEP 5
  BGLOAD 2,I%,0,5,5,TREES%
 NEXT
 BGCOLOR 2,RGB(64,64,64)
 BGSCALE 2,2,2
 BGHOME 2,25,0
 BGSHOW 2
  
END

@TEX
DATA 144,16,48,48
DATA 16,16,48,48
DATA 256,0,48,48
DATA 256,0,48,48
DATA 352,0,48,48

@CLOUD
DATA 816,817,818,819
DATA 848,849,850,851

@TREES
DATA 0,0,598,0,0
DATA 632+#BGREVH,631+#BGREVH,630,631,632
DATA 664+#BGREVH,663+#BGREVH,662,663,664
DATA 696+#BGREVH,695+#BGREVH,694,695,696
DATA 728+#BGREVH,727+#BGREVH,726,727,728
nQrCW+<Յ