         るる                          るる                                            '
' TYPE THE METEOR
'             (C)RRRQ
OPTION STRICT
ACLS
VAR I,J,K

XSCREEN 1280,720
TSCREEN 16,32
TSCREEN 0,16,64
TOFS 0,32,0,-100

'定数
CONST #CMAX=12
CONST #STAGENUM=14

'ENEMYすてーと 
ENUM #E_EMPTY=-1,#E_WAIT,#E_ENABLE,#E_DISABLE
'GAMEすてーと
ENUM #G_PLAY,#G_CLEAR,#G_OVER
'しゅつだいもーど 
ENUM #QM_KANJI,#QM_HIRA
'スプライト番号管理
ENUM \
 #_INPUT,\
 #_GAME,\
 #_SOFTKEY,\
 #_GRAPH,\
 #_ENEMYSTART,\
 #_ENEMYEND=#_ENEMYSTART+#CMAX,\
 #_METEORSTART,\
 #_METEOREND=#_METEORSTART+#CMAX,\
 #_HASTART,\
 #_HAEND=#_HASTART+#CMAX,\
 #_WAKUSTART,\
 #_WAKUEND=#_WAKUSTART+4,\
 #_EFFECTSTART,\
 #_EFFECTEND=#_EFFECTSTART+256
'SUPURAOTODEFBANGO
ENUM \
 #D_METEOR,\
 #D_SPLITER0,\
 #D_SPLITER1,\
 #D_HASTART,\
 #D_HAEND=#D_HASTART+8,\
 #D_BOMBSTART,\
 #D_BOMBEND=#D_BOMBSTART+8,\
 #D_HITSTART,\
 #D_hITEND=#D_HITSTART+4,\
 #D_RANKSTART,\
 #D_RANKEND=#D_RANKSTART+5

VAR X,Y
VAR TXT$
VAR TMP$
VAR C$,NUM
VAR IK$
VAR N

DIM _CHAR$[]
DIM _KEY$[]

VAR _DIFNAME$[4]
_DIFNAME$[0]="初級"
_DIFNAME$[1]="中級"
_DIFNAME$[2]="上級"
_DIFNAME$[3]="超級"
VAR _DIFSPEED[]=[60,180,360,480]

VAR _SELECTEDSTAGE=0
VAR _SELECTEDDIF=0
VAR _TYPESPEED=60
VAR _QMODE=#QM_KANJI

' はいけいびょうが
DEF DRAWBG
  GTARGET 3
  
  GFILL 0,0,639,359,RGB(0,0,0)
  FOR I=-256 TO 256
    FOR J=-256 TO 256
     VAR X=580+J
     VAR Y=60+I
     IF X<0 || X>=640 THEN CONTINUE
     IF Y<0 THEN CONTINUE
     VAR L=SQR(J*J+I*I)
     VAR C
     IF L<=8 THEN
       C=255
     ELSE
       C=POW(1-MAX(L-8,0)/(256-8),4)*150
     ENDIF
     GPSET X,Y,RGB(C,255,255,255),#G_ADD
    NEXT
  NEXT
  FOR I=0 TO 640
    GPSET RND(640),RND(208),RGB(RND(255),255,255,255),#G_ALPHA
  NEXT
  FOR I=0 TO 64
    GFILL 0,207-I*2,640,207-I*2-1,RGB(64-I,255,255,255),2
    GFILL 0,I*2,640,I*2+1,RGB(64-I,0,0,128),#G_ADD
  NEXT
  
  FOR J=208 TO 380 STEP 16
    VAR INVRATE = MIN((J-208)/100,1)
    VAR RATE = 1-INVRATE
    'VAR COL = RGB(160*RATE+INVRATE*100,180*RATE+INVRATE*100,255*RATE+INVRATE*150)
    VAR COL = RGB(0*RATE+INVRATE*64,0*RATE+INVRATE*64,0*RATE+INVRATE*64)
    GFILL 0,J,640,360,COL
    VAR W = 16+INVRATE*32
    VAR H = 32+INVRATE*64  
    FOR I=0 TO 639 STEP W
      VAR WW=W*0.7+RND(W*0.3)
      VAR HH=RND(H)*0.5+H*0.5
      GFILL I,J-HH,I+WW,J,COL
      FOR K=0 TO MIN(H/2,HH)
        GLINE I,J-HH+K,I+WW,J-HH+K,RGB((1-K/(H/2))*96,0,0,0),#G_ALPHA2
      NEXT
      IF RNDF()>0.8 THEN
        GPSET I,J-HH-1,RGB(255,0,0)
        GPSET I+WW,J-HH-1,RGB(255,0,0)
      ENDIF
      Y=J-HH
      VAR MH=H/32
      FOR K=0 TO (HH/MH)/2-1
        FOR L=0 TO 6
          GFILL I+WW/8*L+1+WW/16,Y+MH*(K*2+1),I+WW/8*(L+1)-1+WW/16,Y+MH*(K*2+2)-1,RGB(POW(RNDF(),3)*64,200+RND(55),200+RND(55),200+RND(55)),#G_ADD
        NEXT
      NEXT
    NEXT
  NEXT
  
  SPSET #GSPRITE,0,0,640,360
  SPSCALE #GSPRITE,2,2
  SPOFS #GSPRITE,0,0,1000
  SPPAGE #GSPRITE,3
END
DRAWBG

' FILLCIRCLE
DEF GFILLCIRCLE X,Y,R,C
  VAR I
  FOR I=-R TO R
    VAR XX=X+I'SQRT(R^2-X*X)=Y
    VAR J=SQR(R*R-I*I)
    VAR Y0=Y+J
    VAR Y1=Y-J
    GLINE XX,Y0,XX,Y1,C
  NEXT
END

' めておびょうが
DEF DRAWMETEOR
  'BACKCOLOR RGB(60,128,128)
  BACKCOLOR RGB(0,0,0)
  GTARGET 3
  'GFILL 640,0,640+160,160,0
  'GCIRCLE 640+80,80,79,RGB(0,0,0)
  FOR I=0 TO 360
    VAR H=(SIN(I*0.15)*0.5+0.5)*0.1+0.9
    VAR H1=(SIN(((I+1)MOD 360)*0.15)*0.5+0.5)*0.1+0.9
    GLINE 640+80+COS(I/180*#PI)*80*H,80+SIN(I/180*#PI)*80*H,\
      640+80+COS((I+1)/180*#PI)*80*H1,80+SIN((I+1)/180*#PI)*80*H1,RGB(0,0,0)
    GLINE 640+80+COS(I/180*#PI)*79.5*H,80+SIN(I/180*#PI)*79.5*H,\
      640+80+COS((I+1)/180*#PI)*79.5*H1,80+SIN((I+1)/180*#PI)*79.5*H1,RGB(0,0,0)
  NEXT
  'GPAINT 640+2,80,RGB(0,0,0)
  GPAINT 640+80,80,RGB(10,10,10)
  
  'GCIRCLE 640+90,100,15,RGB(0,0,0)
  GCIRCLE 640+90,100,18,RGB(1,1,1)
  'GPAINT 640+90-16,100,RGB(0,0,0)
  GPAINT 640+90,100,RGB(1,1,1)
  
  'GCIRCLE 640+100,30,9,RGB(0,0,0)
  GCIRCLE 640+100,30,12,RGB(1,1,1)
  'GPAINT 640+100-10,30,RGB(0,0,0)
  GPAINT 640+100,30,RGB(1,1,1)
  
  'GCIRCLE 640+40,60,8,RGB(0,0,0)
  GCIRCLE 640+40,60,11,RGB(1,1,1)
  'GPAINT 640+40-9,60,RGB(0,0,0)
  GPAINT 640+40,60,RGB(1,1,1)
  
  FOR I=0 TO 7
    VAR A=RND(360)/180*#PI
    VAR R=RNDF()*64
    VAR X=COS(A)*R+80
    VAR Y=SIN(A)*R+80
    GFILLCIRCLE 640+X,Y,4+RND(8),RGB(1,1,1)
    'GCIRCLE 640+X,Y,4+RND(8),RGB(1,1,1)
    'GPAINT 640+X,Y,RGB(1,1,1)
  NEXT
  
  FOR I=0 TO 159
    FOR J=0 TO 159
      VAR C=GPGET(640+J,I)
      IF (C AND &HFF) != 0 THEN
        X=J-80
        Y=I-80
        VAR L=SQR(X*X+Y*Y)
        R=(1-POW(L/80,2))*(RNDF()*0.3+0.7)
        GPSET 640+J,I,RGB(R*100,255,255,255),#G_ADD
      ENDIF
    NEXT
  NEXT
  SPDEF #D_METEOR,640,0,160,160,80,80
  
  'KAKERA
  'GFILL 640,160,640+23,160+23,0
  GFILL 640,160,640+23,160+23,RGB(0,0,0)
  GFILL 640+4,160+4,640+23-4,160+23-4,RGB(80,80,80)
  SPDEF #D_SPLITER0,640,160,24,24,12,12
  
  'GFILL 640+24,160,640+24+23,160+23,0
  GCIRCLE 640+24+12,160+12,11,RGB(0,0,0)
  GCIRCLE 640+24+12,160+12,8,RGB(0,0,0)
  GPAINT 640+24+12-9,160+12,RGB(0,0,0)
  GPAINT 640+24+12,160+12,RGB(80,80,80)
  SPDEF #D_SPLITER1,640+24,160,24,24,12,12
  
  'SYOUGEKIHA
  FOR K=0 TO 7
    FOR I=0 TO 159*2-79 STEP 80
      Y = 160*2-1-I-K*10
      C = Y/(160*2-79)
      C = C*255
      FOR J=0 TO 159
        VAR W1,W2,W3
        H=ABS(COS(J*0.5+RNDF())*20)'RND(20)
        H=RND(20)
        VAR Y1=Y-H
        VAR Y3=Y-39+H
        VAR Y2=Y-20+RND(10)-5
        IF Y1>160*2-1-80 THEN
          W1=SIN((160*2-1-Y1)/160*#PI)
        ELSE
          W1=POW(Y1/(160*2-1-80),0.5)
        ENDIF
        IF Y2>160*2-1-80 THEN
          W2=SIN((160*2-1-Y2)/160*#PI)
        ELSE
          W2=POW(Y2/(160*2-1-80),0.5)
        ENDIF
        IF Y3>160*2-1-80 THEN
          W3=SIN((160*2-1-Y3)/160*#PI)
        ELSE
          W3=POW(Y3/(160*2-1-80),0.5)
        ENDIF
        VAR X1=640+160+80+(J-80)*W1 + K*160
        VAR X2=640+160+80+(J-80)*W2 + K*160
        VAR X3=640+160+80+(J-80)*W3 + K*160
        'GLINE X1,Y1,X2,Y2,RGB(C,255,230,100)
        'GLINE X2,Y2,X3,Y3,RGB(C,255,100,0)
        GLINE X1,Y1,X2,Y2,RGB(C,200,200,200)
        GLINE X2,Y2,X3,Y3,RGB(C,120,120,120)
      NEXT
    NEXT
    SPDEF #D_HASTART+K,640+160+K*160,0,160,160*2,80,160+80
  NEXT
  'STOP
END
DRAWMETEOR

' BOMBびょうが
DEF DRAWBOMB
  GTARGET 3
  GFILL 640,320,640+128*8,320+128,0
  VAR C=RGB(255,200,0)
  FOR I=0 TO 7
    GCIRCLE 640+I*128+64,320+64,63,C
    GPAINT 640+I*128+64,320+64,C
    IF I>0 THEN
      GCIRCLE 640+I*128+I*(44/8)+20,320+I*(44/8)+20,I*8,0
      GPAINT 640+I*128+I*(44/8)+20,320+I*(44/8)+20,0
    ENDIF
    SPDEF #D_BOMBSTART+I,640+I*128,320,128,128,64,64
  NEXT
END
DRAWBOMB

' HITびょうが
DEF DRAWHIT
  GTARGET 3
  'GFILL 640,448,640+128*2,448+128,0
  FOR I=0 TO 3
    'GCIRCLE 640+I*128+64,320+64,63,C
    VAR RATE=(1-POW(I/4,3.0))
    VAR C=RGB(RATE*255,255,255,255)
    VAR W = (96+32*POW(I/4,0.5))*0.5
    FOR J=0 TO 24
      VAR C0 = COS(J/12*#PI)
      VAR S0 = SIN(J/12*#PI)
      VAR C1 = COS((J+1)/12*#PI)
      VAR S1 = SIN((J+1)/12*#PI)
      VAR W0 = W*(0.6+(J MOD 2)*0.4*RATE+0.4*(1-RATE))
      VAR W1 = W*(0.6+((J+1) MOD 2)*0.4*RATE+0.4*(1-RATE))
      GLINE 640+I*128+64+C0*W0,448+64+S0*W0,640+I*128+64+C1*W1,448+64+S1*W1,C
    NEXT
    GPAINT 640+I*128+64,448+64,C
    
    SPDEF #D_HITSTART+I,640+I*128,448,128,128,64,64
  NEXT
END
DRAWHIT

' RANKびょうが
DEF DRAWRANK
  GTARGET 3
  'GFILL 640,448,640+128*2,448+128,0
  DIM RANK$[]=["RankS","RankA","RankB","RankC","RankD"]
  DIM COL[]=[RGB(180,220,255),RGB(255,220,80),RGB(80,200,80),RGB(200,80,80),RGB(100,100,100)]
  FOR I = 0 TO 4
    FOR J = 0 TO 4
      VAR X=640+J*25+(25*5+4)*I+2
      VAR Y=576+2
      GPUTCHR X-2,Y,MID$(RANK$[I],J,1),16,2,2,RGB(0,0,0),#G_ALPHA2
      GPUTCHR X+2,Y,MID$(RANK$[I],J,1),16,2,2,RGB(0,0,0),#G_ALPHA2
      GPUTCHR X,Y-2,MID$(RANK$[I],J,1),16,2,2,RGB(0,0,0),#G_ALPHA2
      GPUTCHR X,Y+2,MID$(RANK$[I],J,1),16,2,2,RGB(0,0,0),#G_ALPHA2

      GPUTCHR X-2,Y-2,MID$(RANK$[I],J,1),16,2,2,RGB(0,0,0),#G_ALPHA2
      GPUTCHR X+2,Y+2,MID$(RANK$[I],J,1),16,2,2,RGB(0,0,0),#G_ALPHA2
      GPUTCHR X-2,Y+2,MID$(RANK$[I],J,1),16,2,2,RGB(0,0,0),#G_ALPHA2
      GPUTCHR X+2,Y-2,MID$(RANK$[I],J,1),16,2,2,RGB(0,0,0),#G_ALPHA2

      GPUTCHR X,Y,MID$(RANK$[I],J,1),16,2,2,COL[I],#G_ALPHA2
    NEXT
    SPDEF #D_RANKSTART+I,640+(25*5+4)*I,576,25*5+4,32+4,25*5/2,16
  NEXT
  
  FOR I=0 TO 32+4-1
    FOR J=0 TO (25*5+4)*5-1
      X=640+J
      Y=576+I
      VAR A=(GPGET(X,Y)>>24) AND &HFF
      IF I<18 THEN
        GPSET X,Y,RGB(A AND FLOOR((I/18)*0.15*255),255,255,255),#G_ALPHA2
      ELSE
        GPSET X,Y,RGB(A AND FLOOR((1-(I-18)/18)*0.15*255),0,0,0),#G_ALPHA2
      ENDIF
    NEXT
  NEXT
END
DRAWRANK

' 候補取得
DEF GETCANDIDATE W$,C$[] OUT NUM
 VAR I,J,K
 VAR NEX$,NEX1$
 NUM=0
 IF W$=="" THEN RETURN
 
 FOR I=0 TO LEN(_CHAR$)-1
  IF _CHAR$[I]==LEFT$(W$,LEN(_CHAR$[I])) THEN
   
   FOR J=0 TO 4
    IF _KEY$[I*5+J]=="" THEN BREAK
    
    C$[NUM*2+0]=_CHAR$[I]
    IF _KEY$[I*5+J]=="*" THEN
     NEX$=MID$(W$,1,2)
     NEX1$=LEFT$(NEX$,1)
     IF NEX1$=="あ" || NEX1$=="い" || NEX1$=="う" || NEX1$=="え" || NEX1$=="お" || NEX1$=="ん" || NEX1$=="" THEN CONTINUE
     IF NEX1$=="な" || NEX1$=="に" || NEX1$=="ぬ" || NEX1$=="ね" || NEX1$=="の" THEN CONTINUE
     FOR K=0 TO LEN(_CHAR$)-1
      IF _CHAR$[K]==LEFT$(NEX$,LEN(_CHAR$[K])) THEN
       C$[NUM*2+1]=LEFT$(_KEY$[K*5],1)
       NUM=NUM+1
       BREAK
      ENDIF
     NEXT
     
    ELSE
     C$[NUM*2+1]=_KEY$[I*5+J]
     NUM=NUM+1
    ENDIF
    
   NEXT
   
  ENDIF
 NEXT
END

RESTORE @KEYDATA
J=0
LOOP
 READ C$,NUM
 IF C$=="" THEN BREAK
 
 PUSH _CHAR$, C$
 
 FOR I=0 TO 4
  PUSH _KEY$,""
 NEXT
 FOR I=0 TO NUM-1
  READ C$
  _KEY$[J*5+I]=C$
 NEXT
 J=J+1
ENDLOOP

'SOFTWAREKEYBORD
VAR _SKEY$[]
VAR _SKEYX[]
VAR _SKEYY[]
DEF DRAWSOFTKEY
  RESTORE @SOFTKEY
  GTARGET 2
  
  'GFILL 0,450-24-4,1280,720,RGB(50,50,50)
  FOR I=450-24-4 TO 720
    VAR RATE=1-I/720.0+RNDF()*0.1
    GLINE 0,I,1280,I,RGB(RATE*150+64,RATE*150+64,RATE*150+64)
  NEXT
  GFILL 0,450-24-4,1280,450-24-4-1,RGB(200,200,200)
  LOOP
   READ TXT$,X,Y
   IF TXT$=="" THEN BREAK
   
   X=X*32-30+15
   Y=Y*24-22+450
   VAR BGCOL=RGB(64,64,64)
   GFILL X-3,Y-3,X+32+60+3,Y+24+44+3,BGCOL
   GFILL X,Y,X+32+60,Y+24+44,RGB(180,180,180)
   FOR I=0 TO 6
     GLINE X+I,Y+I,X+I,Y+24+44-I,RGB(64-(I/8)*64,0,0,0),2
     GLINE X+32+60-I,Y+I,X+32+60-I,Y+24+44-I,RGB(64-(I/8)*64,0,0,0),2
   NEXT
   FOR I=0 TO 3
     GLINE X+I,Y,X,Y+I,BGCOL
     GLINE X+32+60-I,Y,X+32+60,Y+I,BGCOL
     GLINE X+I,Y+24+44,X,Y+24+44-I,BGCOL
     GLINE X+32+60-I,Y+24+44,X+32+60,Y+24+44-I,BGCOL
   NEXT
   
   GPUTCHR X+30,Y+22-2,TXT$,16,2,2,#C_BLACK,#G_ALPHA
   GPUTCHR X+30,Y+22+2,TXT$,16,2,2,RGB(220,220,220),#G_ALPHA
   GPUTCHR X+30,Y+22,TXT$,16,2,2,RGB(64,64,64),#G_ALPHA
   
   PUSH _SKEY$,TXT$
   PUSH _SKEYX,X
   PUSH _SKEYY,Y
  ENDLOOP
END
DRAWSOFTKEY

' GRAPH
DIM _RECORD[#STAGENUM*(6+100)]
IF CHKFILE("DAT:RQTYPERECORD.DAT") THEN
  LOADV "DAT:RQTYPERECORD.DAT", _RECORD
  J=LEN(_RECORD)
  IF J<#STAGENUM*(6+100) THEN
    FOR I=J TO #STAGENUM*(6+100)-1
     PUSH _RECORD,0
    NEXT
    J=LEN(_RECORD)
    IF J!=#STAGENUM*(6+100) THEN
      STOP
    ENDIF
  ENDIF
ENDIF

' きろく
DEF SETRECORD(STAGE,SCORE,SPEED,MISS,LIFE,DIFFICULT)
  VAR IDX = STAGE*105
  VAR ISUPDATE=#FALSE
  IF _RECORD[IDX+0] < SCORE THEN
    _RECORD[IDX+0] = SCORE
    _RECORD[IDX+1] = SPEED
    _RECORD[IDX+2] = MISS
    _RECORD[IDX+3] = LIFE
    _RECORD[IDX+4] = DIFFICULT
    ISUPDATE=#TRUE
  ENDIF
  VAR I = _RECORD[IDX+5]
  IF I == 100 THEN
    FOR J=1 TO 99
      _RECORD[IDX+6+J-1] = _RECORD[IDX+5+J]
    NEXT
    I = 99
  ENDIF
  _RECORD[IDX+6+I] = SCORE
  
  _RECORD[IDX+5] = I + 1
  
  RETURN ISUPDATE
END

' ぐらふびょうが
DEF DRAWGRAPH STAGE,X,Y,W
  VAR IDX = STAGE*105
  
  VAR RCNT = _RECORD[IDX+5]
  VAR MAXS = _RECORD[IDX+0]
  IF MAXS==0 THEN MAXS=1
  
  GTARGET 2
  GFILL 0,720,W,720+300,RGB(200,0,0,0)
  
  W=W-80
  
  GLINE 40,720+300-16-256,40+W,720+300-16-256,RGB(64,255,255,255),#G_ALPHA2
  GLINE 40,720+300-16-128,40+W,720+300-16-128,RGB(64,255,255,255),#G_ALPHA2
  GLINE 40,720+300-16-0,40+W,720+300-16-0,RGB(64,255,255,255),#G_ALPHA2
  FOR I=0 TO RCNT-1
    VAR PREVSCR = _RECORD[IDX+6+I-1]
    IF I == 0 THEN PREVSCR = 0
    VAR SCR = _RECORD[IDX+6+I]
    
    GLINE 40+I*(W/RCNT),720+300-16-PREVSCR/MAXS*256,40+(I+1)*(W/RCNT),720+300-16-SCR/MAXS*256,RGB(255,255,255)
  NEXT
  
  GPUTCHR 40,720+300-16-256   ,"最高スコア "+STR$(_RECORD[IDX+0]),16,1,1,#C_WHITE,#G_ALPHA2
  GPUTCHR 40,720+300-16-256+16,"  難易度 "+_DIFNAME$[_RECORD[IDX+4]],16,1,1,#C_WHITE,#G_ALPHA2
  GPUTCHR 40,720+300-16-256+32,"タイプ速度 "+STR$(_RECORD[IDX+1])+"[CPM]",16,1,1,#C_WHITE,#G_ALPHA2
  GPUTCHR 40,720+300-16-256+48,"  正確性 "+STR$(_RECORD[IDX+2])+"[%]",16,1,1,#C_WHITE,#G_ALPHA2
  GPUTCHR 40,720+300-16-256+64," 残ライフ "+STR$(_RECORD[IDX+3]),16,1,1,#C_WHITE,#G_ALPHA2
 
 SPSET #_GRAPH,0,720,W+80,300'1280,300
 SPOFS #_GRAPH,X,Y,10 '0,720-300
 SPPAGE #_GRAPH,2
END

' わくひょうじ
DEF SETWAKU IDX,X,Y,W,H,C
  VAR ID = #_WAKUSTART+IDX
  SPSET ID,0,0,1,1
  SPPAGE ID,-1
  SPOFS ID,X,Y,-500
  SPSCALE ID,W,H
  SPCOLOR ID,C'RGB(160,0,0,0)
END

DEF HIDEWAKU IDX
  VAR ID = #_WAKUSTART+IDX
  SPCLR ID
END

'TITLE
@TITLE
CLS
CLS 0
SPCLR
BGMPLAY 24
VSYNC

SPSET 0,#D_METEOR
SPPAGE 0,3
SPOFS 0,640,360,100
SPSCALE 0,4,4
SPCOLOR 0,RGB(0,0,0)
'SPANIM 0,"R",-3000,-360,0

DEF DRAWTITLE
  GTARGET 0
  COLOR RGB(200,200,200)
  TSCREEN 4,16,32,1280/16,720/16+1
  LOCATE 15,8
  PRINT "タイプ ザ メテオ"
  LOCATE 12,18
  PRINT "PRESS ENTER KEY"
  COLOR #C_GRAY
  LOCATE 1,21
  PRINT "v0.9.0"
  LOCATE 34,21
  PRINT "©RRRQ"
  GPUTCHR 0, 0,"    ",16
  GPUTCHR 0,16,"                    ",16
  GPUTCHR 0,32,"             ",16
  GPUTCHR 0,48,"                        ",16
  GPUTCHR 0,64,"                ",16
  FOR I=0 TO 16*5-1
    FOR J=0 TO 16*41-1
      VAR A=(GPGET(J,I)>>24) AND &HFF
      VAR R=1-I/(16*5)*0.5
      GPSET J,I,RGB(A,255*R,255*R,255*R),#G_ALPHA2
    NEXT
  NEXT
  SPSET 2,0,0,16*41,16*5
  SPHOME 2,16*41/2,16*5/2
  SPPAGE 2,0
  SPOFS 2,640,360
  SPSCALE 2,1.5,1.5
END
DRAWTITLE

LOOP
 IK$=INKEY$()
 IF KEYBOARD(&H28,2) || BUTTON(0,#B_RRIGHT,2) THEN BREAK
 VSYNC
ENDLOOP

BEEP 32

SPCLR 0
SPCLR 1
SPCLR 2

'STAGE SELECT
@SELECT
BGMPLAY 43
SPCOLOR #GSPRITE,RGB(255,255,255)
 LMATRIX 0,0,0,0,0
VSYNC

VAR _TITLE$[#STAGENUM]
VAR _INFO$[#STAGENUM]
VAR _MENUSEQ=0

FOR I=0 TO #STAGENUM-1
 RESTORE "@STAGE"+STR$(I)
 READ _TITLE$[I],_INFO$[I]
NEXT

BGPRINT 3,0,"SELECT  LEVEL"

SETWAKU 0,8+32,8+64,416-32,720-16-128-48-8,RGB(160,255,255,255)
SETWAKU 3,8+32,8+64+32*16+16,416-32,48,RGB(160,255,255,255)
SETWAKU 1,416+16,8+64,840-32,720-16-308-128,RGB(160,255,255,255)
DIM MODE$[]=["漢字","ひらがな"]
LOOP
  IK$=INKEY$()
  CLS
  COLOR #C_WHITE
  LOCATE 9,21
  PRINT "F1:モード切替 :選択 ENTER:決定 ESC:戻る"
  COLOR #C_BLACK
  LOCATE 2,19
  PRINT "出題モード:"+MODE$[_QMODE]
  IF _MENUSEQ==0 THEN
    ' STAGE
    IF KEYBOARD(&H52,2) || BUTTON(0,#B_LUP,2)   THEN
      _SELECTEDSTAGE=_SELECTEDSTAGE-1
      IF _SELECTEDSTAGE<0 THEN _SELECTEDSTAGE=#STAGENUM-1
      BEEP 9
    ENDIF
    IF KEYBOARD(&H51,2) || BUTTON(0,#B_LDOWN,2) THEN
      _SELECTEDSTAGE=_SELECTEDSTAGE+1
      IF _SELECTEDSTAGE>=#STAGENUM THEN _SELECTEDSTAGE=0
      BEEP 9
    ENDIF
    IF KEYBOARD(&H28,2) || BUTTON(0,#B_RRIGHT,2) THEN
      _MENUSEQ=1
      SETWAKU 2,11*32-16,(_SELECTEDSTAGE+1+2)*32-16,4*32+32,4*32+32,RGB(240,255,255,255)
      BEEP 32
    ENDIF
    IF KEYBOARD(&H29,2) || BUTTON(0,#B_RDOWN,2) THEN @TITLE
    
  ELSEIF _MENUSEQ==1 THEN
    
    ' NANIDO
    IF KEYBOARD(&H52,2) || BUTTON(0,#B_LUP,2)   THEN
      _SELECTEDDIF=_SELECTEDDIF-1
      IF _SELECTEDDIF<0 THEN _SELECTEDDIF=3
      BEEP 9
    ENDIF
    IF KEYBOARD(&H51,2) || BUTTON(0,#B_LDOWN,2) THEN 
      _SELECTEDDIF=_SELECTEDDIF+1
      IF _SELECTEDDIF>3 THEN _SELECTEDDIF=0
      BEEP 9
    ENDIF
    IF _SELECTEDSTAGE<=8 THEN _SELECTEDDIF=0
    IF KEYBOARD(&h29,2) || BUTTON(0,#B_RDOWN,2) THEN
      _MENUSEQ=0
      HIDEWAKU 2
      BEEP 4
    ENDIF
    IF KEYBOARD(&H28,2) || BUTTON(0,#B_RRIGHT,2) THEN
      _TYPESPEED=_DIFSPEED[_SELECTEDDIF]
      BEEP 32
      BREAK
    ENDIF
    
  ENDIF
  IF KEYBOARD(&H3A,2) || BUTTON(0,#B_RUP,2)   THEN
    _QMODE=1-_QMODE
    BEEP 9
  ENDIF
  
  FOR I=0 TO #STAGENUM-1
    LOCATE 4,I+1+2
    PRINT _TITLE$[I]
  NEXT
  LOCATE 2,_SELECTEDSTAGE+1+2
  PRINT ""
  
  TXT$=_INFO$[_SELECTEDSTAGE]
  I=1
  LOOP
    LOCATE 15,I+2
    TMP$=LEFT$(TXT$,23)
    TXT$=MID$(TXT$,23,LEN(TXT$))
    J=INSTR(TMP$,CHR$(13))
    IF J>=0 THEN
      TXT$=MID$(TMP$,J+1,LEN(TMP$))+TXT$
      TMP$=LEFT$(TMP$,J)
    ENDIF
    PRINT TMP$
    INC I
    IF TXT$=="" THEN BREAK
  ENDLOOP
  
  DRAWGRAPH _SELECTEDSTAGE,416+16,720-8-300-64,808
  
  IF _MENUSEQ==1 THEN
    COLOR #C_BLACK
    TFILL 4,10,_SELECTEDSTAGE+2,15,_SELECTEDSTAGE+2+5," "
    
    LOCATE 11,_SELECTEDSTAGE+1+_SELECTEDDIF+2
    PRINT ""
    FOR I=0 TO 3
     LOCATE 13,_SELECTEDSTAGE+1+I+2
     IF _SELECTEDSTAGE<=8 && I>0 THEN COLOR #C_GRAY
     PRINT _DIFNAME$[I]
    NEXT
  ENDIF
  
  VSYNC
ENDLOOP

'GAME
@GAME
VAR CANDI$[16]
VAR CANDINUM

VAR _TGT=-1
VAR _QIDX=0
VAR _NOW$=""
VAR _SCHAR$=""
VAR _SCANDI$=""
VAR _BEGINTIME
VAR _KEYCOUNT

VAR _READ$[]
VAR _WRITE$[]

VAR _CE[#CMAX]
VAR _CT[#CMAX]
VAR _CX[#CMAX]
VAR _CR$[#CMAX]
VAR _CW$[#CMAX]
VAR _CA[#CMAX]

VAR _WAVECNT

VAR _LIFE
VAR _TOTALTIME
VAR _TOTALKEYCOUNT
VAR _TOTALMISSCOUNT
VAR _TOTALQCOUNT
VAR _READY

VAR _QUAKE

TOFS 4,0,0,-50
SPCLR
CLS 0

'すてーじのたんごをりすとする
DEF LISTWORDS
 VAR DAT$=ARRAY$(0)
 _READ$=ARRAY$(0)
 _WRITE$=ARRAY$(0)
 LOOP
  READ TXT$
  PUSH DAT$,TXT$
  IF TXT$=="" THEN BREAK
 ENDLOOP
 
 FOR I=0 TO LEN(DAT$)-1
  IF DAT$[I]=="" THEN BREAK
  EXEC DAT$[I]+".DAT",1
  RESTORE "1:@"+DAT$[I]
  LOOP
   READ TXT$
   IF TXT$=="" THEN BREAK
   PUSH _READ$,TXT$
   READ TXT$
   PUSH _WRITE$,TXT$
  ENDLOOP
 NEXT
END

'えねみーしゅつげん
DEF POPENEMY( TIME, DIF )
  VAR I
  VAR IDX
  
  FOR I = 0 TO #CMAX-1
    
    IF _CE[I] == #E_EMPTY THEN
      
      _CE[I] = #E_WAIT
      
      READ IDX,_CX[I]
      
      IF IDX<0 THEN
        
        VAR FIRST,NUM
        READ FIRST,NUM
        IF FIRST >= 0 THEN
          IDX = FIRST+RND(NUM)
        ELSE
          IDX = RND(LEN(_READ$))
        ENDIF
        
      ENDIF
      
      IF _CX[I] < 0 THEN _CX[I] = 2+RND(36)
      
      _CT[I] = TIME
      _CR$[I] = _READ$[IDX]
      _CW$[I] = _WRITE$[IDX]
      
      VAR SX=0
      VAR R$=_CR$[I]
      TXT$=""
      LOOP
        GETCANDIDATE MID$(R$,SX,3),CANDI$ OUT CANDINUM
        IF CANDINUM==0 THEN BREAK
        TXT$=TXT$+CANDI$[1]
        SX=SX+LEN(CANDI$[0])
        IF SX>=LEN(R$) THEN BREAK
      ENDLOOP
      
      
      VAR A = LEN(TXT$)*(60/_TYPESPEED)*60+30
      _CA[I] = FLOOR(A + DIF + 30)
      
      RETURN A
      
    ENDIF
    
  NEXT
END

'えねみーしゅつげん
VAR _DBGIDX=0
DEF POPENEMYDBG( TIME, DIF )
  VAR I
  VAR IDX
  
  FOR I = 0 TO #CMAX-1
    
    IF _CE[I] == #E_EMPTY THEN
      
      _CE[I] = #E_WAIT
      
      IDX = _DBGIDX
      INC _DBGIDX
      _CX[I] = 20
      
      _CT[I] = TIME
      _CR$[I] = _READ$[IDX]
      _CW$[I] = _WRITE$[IDX]
      
      VAR SX=0
      VAR R$=_CR$[I]
      TXT$=""
      LOOP
        GETCANDIDATE MID$(R$,SX,3),CANDI$ OUT CANDINUM
        IF CANDINUM==0 THEN BREAK
        TXT$=TXT$+CANDI$[1]
        SX=SX+LEN(CANDI$[0])
        IF SX>=LEN(R$) THEN BREAK
      ENDLOOP
      
      
      VAR A = LEN(TXT$)*(60/_TYPESPEED)*60+30
      _CA[I] = FLOOR(A + DIF + 30)
      
      RETURN A
      
    ENDIF
    
  NEXT
END

' うぇーぶせっと
DEF SETWAVE()
  VAR I
  VAR NUM
  
  FILL _CE,#E_EMPTY
  
  CONST #DGBPOP=#FALSE
  
  READ NUM
  IF #DGBPOP THEN NUM=1
  
  VAR TIME=0
  VAR DIF=0
  VAR NEXTRATE=0.3
  VAR A
  
  FOR I=0 TO NUM-1
    IF #DGBPOP==#FALSE THEN
      A = POPENEMY(TIME,DIF)
    ELSE
      A = POPENEMYDBG(TIME,DIF)
    ENDIF
    TIME = TIME + A*NEXTRATE
    DIF = DIF + A - A*NEXTRATE
    NEXTRATE = NEXTRATE + 0.5 * POW(0.5,I+1)
  NEXT
  
  _WAVECNT=0
  
  RETURN NUM
END

'うぇーぶこうしん
DEF UPDATEWAVE()
 VAR EMPTY=#TRUE
 VAR ISWAIT=#FALSE
 
 WHILE EMPTY 'からだったらじかんをすきっぷ
 
  FOR I=0 TO #CMAX-1
   IF _CE[I]==#E_WAIT && _CT[I]<=_WAVECNT THEN 
     _CE[I]=#E_ENABLE
   ENDIF
   IF _CE[I]==#E_ENABLE THEN
     _CA[I]=_CA[I]-1
     IF _CA[I]==0 THEN
       _LIFE=_LIFE-1
       
       VAR X,Y,W,H
       SPCHR I+#_ENEMYSTART OUT X,Y,W,H
       SPOFS I+#_ENEMYSTART OUT X,Y
       FOR J=0 TO 23
         POPSPLINTER X+RND(W)-W/2,Y+RND(H)-H/2,3
       NEXT
       FOR J=0 TO 3
         POPBOMB X+RND(W*2)-W,Y+RND(H*2)-H,W/128+RNDF()*2
       NEXT
       
       _QUAKE=30
       
       'BEEP 120,-2000,127
       BEEP 13,-4000,127
     ENDIF
     EMPTY=#FALSE
   ENDIF
   IF _CE[I]==#E_WAIT THEN ISWAIT=#TRUE
  NEXT
  
  EMPTY=EMPTY AND ISWAIT
  
  _WAVECNT=_WAVECNT+1
 WEND
 
 RETURN _LIFE>0
END

' うぇーぶくりあーしたかちぇっく
DEF ISWAVECLEAR()
 VAR I
 FOR I=0 TO #CMAX-1
  IF _CE[I]==#E_WAIT || _CE[I]==#E_ENABLE THEN RETURN #FALSE
 NEXT
 
 RETURN #TRUE
END

' てきびょうが
DEF DRAWENEMYS
 VAR I
 FOR I=0 TO #CMAX-1
  IF _CE[I]==#E_ENABLE THEN
   DRAWWORD I,_CW$[I],_CR$[I],_CX[I],_CA[I],_TGT==I
  ENDIF
 NEXT
END

' わーどびょうが
DEF DRAWWORD IDX,W$,R$,X,A,ISTGT
 CONST #BOXH=108
 
 IF _QMODE==#QM_HIRA THEN W$=R$
 
 VAR SX=0
 VAR LIMIT=LEN(W$)
 VAR I
 VAR SID=IDX+#_ENEMYSTART
 VAR FIRST=(SPUSED(SID)==#FALSE)
 
 VAR CS=2
 VAR FSIZE=16
 VAR W=LIMIT*16*CS+63+16
 IF W>=1280 THEN
   FSIZE=8
   CS=3
   W=LIMIT*FSIZE*CS+63+16
   IF W>=1280 || #TRUE THEN
     FSIZE=16
     CS=1
     W=LIMIT*FSIZE*CS+63+16
   ENDIF
 ENDIF
 
 IF FIRST THEN
   GTARGET 1
   
   GFILL 0,IDX*#BOXH,W-1,IDX*#BOXH+#BOXH-2,RGB(255,255,255)
   GFILL 4,IDX*#BOXH+4,W-4-1,IDX*#BOXH+#BOXH-1-4,RGB(32,32,32)
   
   'GPUTCHR 32+4,IDX*#BOXH+16+8,W$,16,CS,CS,RGB(255,255,255),#G_ALPHA
   'GPUTCHR 32+4,IDX*#BOXH+5,R$,16,1,1,RGB(255,255,255),#G_ALPHA
   
   VAR RUBI=0
   VAR RUBIX=32+4
   VAR RUBIERROR=#FALSE
   VAR KANJI$=""
   FOR I=0 TO LIMIT-1
     VAR C$=MID$(W$,I,1)
     VAR WX=32+4+I*FSIZE*CS
     GPUTCHR WX,IDX*#BOXH+16+7,C$,FSIZE,CS,CS,RGB(255,255,255),#G_ALPHA
     
     IF (ASC(C$)>=ASC("あ") && ASC(C$)<=ASC("ん")) || (ASC(C$)>=ASC("ア") && ASC(C$)<=ASC("ン")) || (ASC(C$)>=ASC("A") && ASC(C$)<=ASC("Z")) || (ASC(C$)>=ASC("0") && ASC(C$)<=ASC("9")) || C$=="、" || C$=="。" || C$=="「" || C$=="」" || C$=="-"|| C$=="ー"|| C$=="ヴ" || C$=="@" || C$==";" || C$==":" || C$=="," || C$=="." || C$=="/" || C$=="\" || C$=="^" || C$=="[" || C$=="]" || C$=="・" THEN
       VAR CC$
       IF (ASC(C$)>=ASC("ア") && ASC(C$)<=ASC("ン")) THEN
         C$ = CHR$(ASC(C$)-ASC("ア")+ASC("あ"))
       ENDIF
       CC$=C$
       FOR J=I+1 TO LIMIT-1
         C$=MID$(W$,J,1)
         IF (ASC(C$)>=ASC("あ") && ASC(C$)<=ASC("ん")) || (ASC(C$)>=ASC("ア") && ASC(C$)<=ASC("ン")) || (ASC(C$)>=ASC("A") && ASC(C$)<=ASC("Z")) || (ASC(C$)>=ASC("0") && ASC(C$)<=ASC("9")) || C$=="、" || C$=="。" || C$=="「" || C$=="」" || C$=="-"|| C$=="ー"|| C$=="ヴ" || C$=="@" || C$==";" || C$==":" || C$=="," || C$=="." || C$=="/" || C$=="\" || C$=="^" || C$=="[" || C$=="]" THEN
           IF (ASC(C$)>=ASC("ア") && ASC(C$)<=ASC("ン")) THEN
             C$ = CHR$(ASC(C$)-ASC("ア")+ASC("あ"))
           ENDIF
           
           CC$=CC$+C$
         ELSE
           BREAK
         ENDIF
       NEXT
       
       IF KANJI$!="" THEN
         VAR INS = INSTR(RUBI+1,R$,CC$)-RUBI
         VAR INS2 = -1
         IF LEN(CC$)==1 && (ASC(CC$)>=ASC("あ") && ASC(CC$)<=ASC("ん")) THEN
           INS2=INSTR(RUBI+INS+1,R$,CC$)-RUBI
         ENDIF
         
         IF INS>=0 THEN
           IF (INS2<0 || INS2>6) && RUBIERROR==#FALSE THEN 'しっぱいのかのうせいがあるのではじく
             VAR YOMI$=MID$(R$,RUBI,INS)
             GPUTCHR RUBIX,IDX*#BOXH+7,YOMI$,16,1,1,RGB(180,180,180),#G_ALPHA
             RUBIERROR=#FALSE
           ELSE
             RUBIERROR=!RUBIERROR
             'STOP
           ENDIF
           RUBI=RUBI+INS+1
           RUBIX=MAX(WX+1*FSIZE*CS,RUBIX+LEN(YOMI$)*16)
         ELSE
           'BUG
         ENDIF
       ELSE
         RUBI=RUBI+1
         RUBIX=MAX(WX+1*FSIZE*CS,RUBIX)
       ENDIF
       KANJI$=""
     ELSE
       KANJI$=KANJI$+C$
     ENDIF
   NEXT
   INS = LEN(R$)-RUBI
   IF INS>0 THEN
     YOMI$=MID$(R$,RUBI,INS)
     GPUTCHR RUBIX,IDX*#BOXH+7,YOMI$,16,1,1,RGB(180,180,180),#G_ALPHA
   ENDIF
 ENDIF
 IF FIRST || ISTGT THEN
   GTARGET 1
   
   IF ISTGT THEN
     FOR I=0 TO 3
       GBOX I,IDX*#BOXH+I,W-1-I,IDX*#BOXH+#BOXH-2-I,RGB(255,0,0)
     NEXT
   ENDIF
   
   GFILL 4,IDX*#BOXH+16+7+32,W-4-1,IDX*#BOXH+#BOXH-1-4,RGB(32,32,32)
   
   TXT$=""
   IF ISTGT THEN
    TXT$=MID$(_SCANDI$,LEN(_NOW$),LEN(_SCANDI$))
    SX=_QIDX+LEN(_SCHAR$)
   ENDIF
   
   LOOP
     GETCANDIDATE MID$(R$,SX,3),CANDI$ OUT CANDINUM
     IF CANDINUM==0 THEN BREAK
     TXT$=TXT$+CANDI$[1]
     SX=SX+LEN(CANDI$[0])
     IF SX>=LEN(R$) THEN BREAK
   ENDLOOP
   VAR YMAX=(W-15)/24
   TXT$=LEFT$(TXT$,YMAX)
   VAR L=LEN(TXT$)*24
   GPUTCHR (W-L)/2,IDX*#BOXH+48+4+8+2,TXT$,8,3,3,RGB(180,180,180),#G_ALPHA
 ENDIF
 
 IF FIRST THEN
  SPSET SID,0,IDX*#BOXH,W+1,#BOXH
  SPPAGE SID,1
  SPHOME SID,W/2,#BOXH/2
  VAR XX=X*32
  VAR XX2=XX+RND(512)-256
  IF XX-W/2<0 THEN XX=W/2
  IF XX+W/2>1279 THEN XX=1279-W/2
  IF XX2-W/2<0 THEN XX2=W/2
  IF XX2+W/2>1279 THEN XX2=1279-W/2
  SPOFS SID,XX,#BOXH/2,-100
  SPANIM SID,"XY",-A,XX2,422-#BOXH/2
  
  VAR MID=IDX+#_METEORSTART
  SPSET MID,0
  SPPAGE MID,3
  VAR S=(LIMIT-1)/8+1
  VAR YY=-80*S+10
  VAR YY2=422-48*S
  SPOFS MID,XX,YY,100
  SPSCALE MID,S,S
  VAR R=RND(360)
  SPROT MID,R
  SPANIM MID,"XY.",-A,XX2,YY2
  SPANIM MID,"R",-A,R+RND(120)-60
  
  VAR HID=IDX+#_HASTART
  SPSET HID,3
  SPPAGE HID,3
  SPOFS HID,XX,YY,90
  SPSCALE HID,S*1.05,S*1.05
  VAR ANG=ATAN(XX2-XX,YY-YY2)
  SPROT HID,ANG*0.5/3.14*360+180
  SPANIM HID,"XY.",-A,XX2,YY2
  SPCOLOR HID,RGB(96,255,255,255)
  VAR AT=2
  SPANIM HID,"I",AT,4,AT,5,AT,6,AT,7,AT,8,AT,9,AT,10,AT,3,0
  
 ENDIF

END

'BGにぷりんと
DEF BGPRINT X,Y,TXT$
 VAR L=LEN(TXT$)
 VAR I
 FOR I=0 TO L-1
  VAR C$=MID$(TXT$,I,1)
  IF C$!=" " THEN TPUT 0,X+I,Y,&HE800+129+ASC(C$)-ASC("A")
 NEXT
END

'SOFTKEY
VAR _PREVTT=0
DEF UPDATESOFTKEY
 VAR TT,TX,TY
 TOUCH OUT TT,TX,TY
 
 IF _PREVTT==0 && TT THEN
  VAR NUM=LEN(_SKEY$)
  FOR I=0 TO NUM-1
   X=_SKEYX[I]
   Y=_SKEYY[I]
   IF TX>=X && TX<=X+32+60 && TY>=Y && TY<=Y+24+44 THEN
    PUSHKEY _SKEY$[I]
   ENDIF
  NEXT
 ENDIF
 
 _PREVTT=TT
END

'SPLINTER
DEF UPDATESPLINTER
  VAR IDX=CALLIDX()
  VAR VX=SPVAR(IDX,"VX")
  VAR VY=SPVAR(IDX,"VY")
  VAR X,Y
  SPOFS IDX OUT X,Y
  X=X+VX
  Y=Y+VY
  VY=VY+0.4
  SPOFS IDX,X,Y
  SPVAR IDX,"VX",VX
  SPVAR IDX,"VY",VY
  IF Y>720 THEN SPCLR IDX
END

DEF POPSPLINTER X,Y,VSCALE
  VAR IDX = SPSET(#_EFFECTSTART,#_EFFECTEND,RND(2)+#D_SPLITER0)
  IF IDX<0 THEN RETURN
  SPPAGE IDX,3
  VAR VX=(RNDF()*24-12)*VSCALE
  VAR VY=(RNDF()*-12)*VSCALE
  SPOFS IDX,X,Y
  SPSCALE IDX,2,2
  SPVAR IDX,"VX",VX
  SPVAR IDX,"VY",VY
  SPROT IDX, RND(360)
  SPANIM IDX,"R.",-120,RND(360*30)-360*10
  SPFUNC IDX,"UPDATESPLINTER"
END

'BOMB
DEF POPBOMB X,Y,SCALE
  VAR IDX = SPSET(#_EFFECTSTART,#_EFFECTEND,#D_BOMBSTART)
  IF IDX<0 THEN RETURN
  SPPAGE IDX,3
  SPOFS IDX,X,Y
  SPSCALE IDX,SCALE,SCALE
  VAR I=#D_BOMBSTART
  VAR AT=2
  SPANIM IDX,"I+.",AT,1,AT,2,AT,3,AT,4,AT,5,AT,6,AT,7,AT,7
END

'HIT
DEF POPHIT X,Y,SCALE
  VAR IDX = SPSET(#_EFFECTSTART,#_EFFECTEND,#D_HITSTART)
  IF IDX<0 THEN RETURN
  SPPAGE IDX,3
  SPOFS IDX,X,Y
  SPSCALE IDX,SCALE,SCALE
  SPROT IDX,RND(360)
  VAR I=#D_HITSTART
  VAR AT=1
  SPANIM IDX,"I+.",AT,1,AT,2,AT,3,AT,3
END

'RANK
DEF POPRANK X,Y,RANK
  VAR IDX = SPSET(#_EFFECTSTART,#_EFFECTEND,#D_RANKSTART+RANK)
  IF IDX<0 THEN RETURN
  SPPAGE IDX,3
  SPOFS IDX,X,Y
  SPSCALE IDX,1.5,1.5
  SPANIM IDX,"S+.",-60,1.1,1.1
  SPANIM IDX,"C.",-30,RGB(255,255,255),-30,RGB(0,255,255,255)
END

'FILL
DEF POPFILL COL
  VAR IDX = SPSET(0,0,1280,720,0)
  IF IDX<0 THEN RETURN
  SPPAGE IDX,-1
  SPOFS IDX,0,0,-1000
  SPCOLOR IDX,COL
  VAR AT=1
  SPANIM IDX,"C.",-8,0
END

'KEY
DEF POPKEY IK$
  FOR I=0 TO LEN(_SKEY$)-1
    IF IK$==_SKEY$[I] THEN
      VAR IDX = SPSET(0,0,32+60,24+44,0,#A_ADD)
      IF IDX<0 THEN RETURN
      SPPAGE IDX,-1
      SPHOME IDX,92/2,68/2
      SPOFS IDX,_SKEYX[I]+92/2,_SKEYY[I]+68/2,-1000
      SPCOLOR IDX,RGB(200,255,255,255)
      SPANIM IDX,"C.",-16,RGB(0,255,255,255)
      SPANIM IDX,"S",-16,1.3,1.3
      RETURN
    ENDIF
  NEXT
END

'STAGEよみこみ
RESTORE "@STAGE"+STR$(_SELECTEDSTAGE)
READ TXT$,TXT$ 'SKIP META
LISTWORDS
RESTORE "@LEVEL"+STR$(_SELECTEDSTAGE)
N=SETWAVE()

_LIFE=10
_TOTALTIME=0
_TOTALKEYCOUNT=0
_TOTALMISSCOUNT=0
_TOTALQCOUNT=0

_READY=120

_QUAKE=0

SPSET  #_SOFTKEY,0,0,1280,720
SPPAGE #_SOFTKEY,2
SPOFS  #_SOFTKEY,0,720
SPANIM #_SOFTKEY,"XY",-30,0,0

BGMSTOP

' MAIN LOOP
VAR GAMESTATE=#G_PLAY
VAR CLEARCNT=0
LOOP
 'UPDATE READY
 IF _READY>0 THEN
   DEC _READY
   IF _READY==0 THEN BGMPLAY 25:CLS 0
 ENDIF
 
 'WAVEこうしん
 IF _READY==0 && UPDATEWAVE()==#FALSE THEN
   GAMESTATE=#G_OVER
   BEEP 108,0,127
   _QUAKE=120
 ENDIF
 
 IF CLEARCNT==0 THEN
   IF ISWAVECLEAR() THEN
     N=SETWAVE()
     IF N==0 THEN CLEARCNT=30
   ENDIF
 ELSE
   DEC CLEARCNT
   IF CLEARCNT==0 THEN GAMESTATE=#G_CLEAR
 ENDIF
 
 ' SOFTKEY
 UPDATESOFTKEY
 
 ' KEYにゅうりょく
 LOOP
   IK$=INKEY$()
   IF IK$=="" THEN BREAK
   
   POPKEY IK$
   
   IF _TGT==-1 THEN 
     FOR I=0 TO #CMAX-1
       IF _CE[I]==#E_ENABLE && SPUSED(I+#_ENEMYSTART) THEN
         GETCANDIDATE MID$(_CR$[I],0,3),CANDI$ OUT CANDINUM
         FOR J=0 TO CANDINUM-1
           IF LEFT$(CANDI$[J*2+1],1)==IK$ THEN
             _TGT=I
             _KEYCOUNT=0
             _BEGINTIME=MILLISEC()
             BREAK
           ENDIF
         NEXT
         IF _TGT>=0 THEN BREAK
       ENDIF
     NEXT
   ENDIF
   
   ' KEYにゅうりょく
   WHILE _TGT>=0
     _NOW$=_NOW$+IK$
      
     GETCANDIDATE MID$(_CR$[_TGT],_QIDX,3),CANDI$ OUT CANDINUM
     FOR I=0 TO CANDINUM-1
       IF _NOW$==LEFT$(CANDI$[I*2+1],LEN(_NOW$)) THEN
         
         INC _KEYCOUNT
         
         IF _NOW$!=CANDI$[I*2+1] THEN
           _SCHAR$=CANDI$[I*2]
           _SCANDI$=CANDI$[I*2+1]
         ELSE
           _QIDX=_QIDX+LEN(CANDI$[I*2])
           _SCHAR$=""
           _SCANDI$=""
           _NOW$=""
         ENDIF
         
         BREAK
        
       ENDIF
     NEXT
     IF I==CANDINUM THEN
       IF _SCHAR$=="ん" && LEN(_NOW$)==2 &&\
         IK$!="A" && IK$!="I" && IK$!="U" && IK$!="E" && IK$!="O" && IK$!="Y" THEN
         _QIDX=_QIDX+LEN(_SCHAR$)
         _SCHAR$=""
         _SCANDI$=""
         _NOW$=""
       ELSE
         _NOW$=LEFT$(_NOW$,LEN(_NOW$)-1)
         INC _TOTALMISSCOUNT
         POPFILL RGB(160,255,0,0)
         BEEP 11,-2000
         BREAK
       ENDIF
     ELSE
       VAR W,H
       SPCHR _TGT+#_ENEMYSTART OUT X,Y,W,H
       SPOFS _TGT+#_ENEMYSTART OUT X,Y
       FOR I=0 TO 3
         POPSPLINTER X+RND(W)-W/2,Y+RND(H)-H/2,1
       NEXT
       POPHIT X+RND(W)-W/2,Y+RND(H)-H/2,1+RNDF()*2
       'POPFILL RGB(160,255,255,255)
       'BEEP 9
       BEEP 30,-1000,127
       '_QUAKE=30
       BREAK
     ENDIF
   WEND
   
   IF _TGT>=0 && LEN(_CR$[_TGT])<=_QIDX THEN
     VAR NOWTIME = MILLISEC()-_BEGINTIME
     _TOTALTIME=_TOTALTIME+NOWTIME
     _TOTALKEYCOUNT=_TOTALKEYCOUNT+_KEYCOUNT-1
     _TOTALQCOUNT=_TOTALQCOUNT+1
     _CE[_TGT]=#E_DISABLE
     
     SPCHR _TGT+#_ENEMYSTART OUT X,Y,W,H
     SPOFS _TGT+#_ENEMYSTART OUT X,Y
     'IF Y>450 THEN STOP
     'IF SPUSED(_TGT+#_ENEMYSTART)==0 THEN STOP
     FOR J=0 TO 23
       POPSPLINTER X+RND(W)-W/2,Y+RND(H)-H/2,3
     NEXT
     
     POPBOMB X,Y,W/128
     
     IF _KEYCOUNT>1 THEN
       VAR TYPESPEED = _KEYCOUNT *60*1000 / NOWTIME
       VAR RANK=0
       IF TYPESPEED>=480 THEN
         RANK=0
       ELSEIF TYPESPEED>=360 THEN
         RANK=1
       ELSEIF TYPESPEED>=240 THEN
         RANK=2
       ELSEIF TYPESPEED>=120 THEN
         RANK=3
       ELSE
         RANK=4
       ENDIF
       POPRANK X,Y,RANK
     ENDIF
     
      
     _QIDX=0
     SPCLR _TGT+#_ENEMYSTART
     SPCLR _TGT+#_METEORSTART
     SPCLR _TGT+#_HASTART
     _TGT=-1
     BEEP 13,0,127
   ENDIF
 ENDLOOP
 
 CALL SPRITE
 
 ' DRAW
 CLS
 
 LMATRIX 0,0,0,SIN(_QUAKE*3.14*0.66)*_QUAKE*0.25,SIN(_QUAKE*3.14)*_QUAKE*2
 _QUAKE=MAX(_QUAKE-1,0)
 
 COLOR #C_WHITE
 IF _READY>0 THEN
  'LOCATE 17,7
  'PRINT "READY…"
  BGPRINT 7,3,"READY"
 ENDIF
 
 SPCOLOR #GSPRITE,RGB(255,MIN(_LIFE/5,1)*255,MIN(_LIFE/5,1)*255)
 
 LOCATE 0,12
 PRINT "ライフ"
 COLOR RGB(255,64,160)
 FOR I=0 TO _LIFE-1
  LOCATE 3+I,12
  PRINT ""
 NEXT
 COLOR RGB(160,0,0)
 FOR J=I TO 10-1
  LOCATE 3+J,12
  PRINT "×"
 NEXT
 
 'てきびょうが
 DRAWENEMYS
 
 IF GAMESTATE!=#G_PLAY THEN BREAK
 VSYNC
ENDLOOP

'しゅうりょうがめん
CLS
VSYNC
SPANIM #_SOFTKEY,"XY",-30,0,720
SPCLR #_ENEMYSTART,#_ENEMYEND
SPCLR #_METEORSTART,#_METEOREND
SPCLR #_HASTART,#_HAEND
SPCLR #_EFFECTSTART,#_EFFECTEND

SETWAKU 0,640-464,6*32-16,464*2,32*6+32,RGB(160,255,255,255)

TOFS 4,0,0,-1000
IF GAMESTATE==#G_CLEAR THEN
  BGMPLAY 5
  BGPRINT 4,1,"LEVEL CLEAR"
ELSE
  BGMPLAY 6
  BGPRINT 5,1,"GAME OVER"
ENDIF
X=-4
COLOR #C_BLACK
LOCATE 12+X,9
PRINT "  難易度 " + _DIFNAME$[_SELECTEDDIF]
LOCATE 12+X,6
VAR CPM=0
IF _TOTALTIME>0 && _TOTALKEYCOUNT>0 THEN
  CPM=FLOOR(_TOTALKEYCOUNT/(_TOTALTIME/1000/60)*100)/100
  PRINT "タイプ速度 "+STR$(CPM)+"[CPM]"
ELSE
  PRINT "タイプ速度 計測不可"
ENDIF
LOCATE 14+X,7
VAR TOTALCNT=_TOTALQCOUNT+_TOTALKEYCOUNT+_TOTALMISSCOUNT
VAR MISS=0
IF TOTALCNT THEN
  MISS=FLOOR((1-_TOTALMISSCOUNT/TOTALCNT)*10000)/100
  PRINT "正確性 "+STR$(MISS)+"[%]"
ELSE
  PRINT "正確性 計測不可"
ENDIF
LOCATE 14+X,8
PRINT "ライフ"
COLOR RGB(255,64,160)
FOR I=0 TO _LIFE-1
  LOCATE 14+X+4+I,8
  PRINT ""
NEXT
COLOR RGB(160,0,0)
FOR J=I TO 10-1
  LOCATE 14+X+4+J,8
  PRINT "×"
NEXT

COLOR RGB(80,80,80)
LOCATE 30+X,9
PRINT "×"+STR$(_SELECTEDDIF*0.5+0.5)
LOCATE 30+X,6
PRINT ""+STR$(100*CPM)
LOCATE 30+X,7
PRINT "×"+STR$(FLOOR(POW(MISS/100,4)*1000)/1000)
LOCATE 30+X,8
PRINT "×"+STR$((_LIFE/10*0.75+0.25))

' KIROKU
VAR SCORE=FLOOR(POW(MISS/100,4)*100*CPM*(_LIFE/10*0.75+0.25)*(_SELECTEDDIF*0.5+0.5))

VAR ISUPDATE=#FALSE
'IF GAMESTATE==#G_CLEAR THEN
  ISUPDATE = SETRECORD(_SELECTEDSTAGE,SCORE,CPM,MISS,_LIFE,_SELECTEDDIF)
'ENDIF
DRAWGRAPH _SELECTEDSTAGE,0,720-300,1280

COLOR #C_BLACK
LOCATE 14+X,11
TXT$="スコア "+STR$(SCORE)
PRINT TXT$
IF ISUPDATE THEN
  COLOR RGB(255,0,0)
  LOCATE 30+X,11
  PRINT "ハイスコア!"
ENDIF

I=0
LOOP
  LMATRIX 0,0,0,SIN(_QUAKE*3.14*0.66)*_QUAKE*0.25,SIN(_QUAKE*3.14)*_QUAKE*2
  _QUAKE=MAX(_QUAKE-1,0)
  
  IF KEYBOARD(&H28,2) || BUTTON(0,#B_RRIGHT,2) THEN
    ' SAVE
    'IF GAMESTATE==#G_CLEAR THEN
      SAVEV "DAT:RQTYPERECORD.DAT",_RECORD
    'ENDIF
    BREAK
  ENDIF
  IF GAMESTATE!=#G_CLEAR && I MOD 2==0 THEN
    POPBOMB RND(1280),RND(720),RNDF()*2+1
    IF I MOD 16==0 THEN
      BEEP 13,-4000
    ENDIF
  ENDIF
  INC I
  VSYNC
ENDLOOP

SPCLR 
CLS 0
CLS
GOTO @SELECT

@KEYDATA
DATA "あ",1,"A"
DATA "い",1,"I"
DATA "うぃ",1,"WI"
DATA "うぇ",1,"WE"
DATA "う",1,"U"
DATA "え",1,"E"
DATA "お",1,"O"
DATA "ぁ",2,"LA","XA"
DATA "ぃ",2,"LI","XI"
DATA "ぅ",2,"LU","XU"
DATA "ぇ",2,"LE","XE"
DATA "ぉ",2,"LO","XO"
DATA "か",2,"KA","CA"
DATA "きゃ",1,"KYA"
DATA "きゅ",1,"KYU"
DATA "きょ",1,"KYO"
DATA "き",1,"KI"
DATA "く",2,"KU","CU"
DATA "け",1,"KE"
DATA "こ",2,"KO","CO"
DATA "が",1,"GA"
DATA "ぎゃ",1,"GYA"
DATA "ぎゅ",1,"GYU"
DATA "ぎょ",1,"GYO"
DATA "ぎ",1,"GI"
DATA "ぐ",1,"GU"
DATA "げ",1,"GE"
DATA "ご",1,"GO"
DATA "さ",1,"SA"
DATA "しゃ",2,"SYA","SHA"
DATA "しぃ",1,"SYI"
DATA "しゅ",2,"SYU","SHU"
DATA "しぇ",2,"SYE","SHE"
DATA "しょ",2,"SYO","SHO"
DATA "し",3,"SI","SHI","CI"
DATA "す",1,"SU"
DATA "せ",2,"SE","CE"
DATA "そ",1,"SO"
DATA "ざ",1,"ZA"
DATA "じゃ",3,"JA","JYA","ZYA"
DATA "じぃ",2,"JYI","ZYI"
DATA "じゅ",3,"JU","JYU","ZYU"
DATA "じぇ",3,"JE","JYE","ZYE"
DATA "じょ",3,"JO","JYO","ZYO"
DATA "じ",2,"JI","ZI"
DATA "ず",1,"ZU"
DATA "ぜ",1,"ZE"
DATA "ぞ",1,"ZO"
DATA "た",1,"TA"
DATA "ちゃ",2,"TYA","CHA"
DATA "ちぃ",1,"TYI"
DATA "ちゅ",2,"TYU","CHU"
DATA "ちぇ",2,"TYE","CHE"
DATA "ちょ",2,"TYO","CHO"
DATA "ち",2,"TI","CHI"
DATA "つ",1,"TU"
DATA "てゃ",1,"THA"
DATA "てぃ",1,"THI"
DATA "てゅ",1,"THU"
DATA "てぇ",1,"THE"
DATA "てょ",1,"THO"
DATA "て",1,"TE"
DATA "と",1,"TO"
DATA "だ",1,"DA"
DATA "ぢ",1,"DI"
DATA "づ",1,"DU"
DATA "でゃ",1,"DHA"
DATA "でぃ",1,"DHI"
DATA "でゅ",1,"DHU"
DATA "でぇ",1,"DHE"
DATA "でょ",1,"DHO"
DATA "で",1,"DE"
DATA "ど",1,"DO"
DATA "な",1,"NA"
DATA "にゃ",1,"NYA"
DATA "にゅ",1,"NYU"
DATA "にょ",1,"NYO"
DATA "に",1,"NI"
DATA "ぬ",1,"NU"
DATA "ね",1,"NE"
DATA "の",1,"NO"
DATA "は",1,"HA"
DATA "ひゃ",1,"HYA"
DATA "ひゅ",1,"HYU"
DATA "ひょ",1,"HYO"
DATA "ひ",1,"HI"
DATA "ふぁ",1,"FA"
DATA "ふぃ",1,"FI"
DATA "ふぇ",1,"FE"
DATA "ふぉ",1,"FO"
DATA "ふ",2,"HU","FU"
DATA "へ",1,"HE"
DATA "ほ",1,"HO"
DATA "ば",1,"BA"
DATA "びゃ",1,"BYA"
DATA "びゅ",1,"BYU"
DATA "びょ",1,"BYO"
DATA "び",1,"BI"
DATA "ぶ",1,"BU"
DATA "べ",1,"BE"
DATA "ぼ",1,"BO"
DATA "ぱ",1,"PA"
DATA "ぴゃ",1,"PYA"
DATA "ぴゅ",1,"PYU"
DATA "ぴょ",1,"PYO"
DATA "ぴ",1,"PI"
DATA "ぷ",1,"PU"
DATA "ぺ",1,"PE"
DATA "ぽ",1,"PO"
DATA "ま",1,"MA"
DATA "みゃ",1,"MYA"
DATA "みゅ",1,"MYU"
DATA "みょ",1,"MYO"
DATA "み",1,"MI"
DATA "む",1,"MU"
DATA "め",1,"ME"
DATA "も",1,"MO"
DATA "や",1,"YA"
DATA "ゆ",1,"YU"
DATA "よ",1,"YO"
DATA "ゃ",2,"LYA","XYA"
DATA "ゅ",2,"LYU","XYU"
DATA "ょ",2,"LYO","XYO"
DATA "ら",1,"RA"
DATA "りゃ",1,"RYA"
DATA "りゅ",1,"RYU"
DATA "りょ",1,"RYO"
DATA "り",1,"RI"
DATA "る",1,"RU"
DATA "れ",1,"RE"
DATA "ろ",1,"RO"
DATA "わ",1,"WA"
DATA "を",1,"WO"
DATA "ん",1,"NN"
DATA "っ",3,"*","LTU","XTU"
DATA "ヴぁ",1,"VA"
DATA "ヴぃ",1,"VI"
DATA "ヴぇ",1,"VE"
DATA "ヴぉ",1,"VO"
DATA "ヴ",1,"VU"
DATA "A",1,"A"
DATA "B",1,"B"
DATA "C",1,"C"
DATA "D",1,"D"
DATA "E",1,"E"
DATA "F",1,"F"
DATA "G",1,"G"
DATA "H",1,"H"
DATA "I",1,"I"
DATA "J",1,"J"
DATA "K",1,"K"
DATA "L",1,"L"
DATA "M",1,"M"
DATA "N",1,"N"
DATA "O",1,"O"
DATA "P",1,"P"
DATA "Q",1,"Q"
DATA "R",1,"R"
DATA "S",1,"S"
DATA "T",1,"T"
DATA "U",1,"U"
DATA "V",1,"V"
DATA "W",1,"W"
DATA "X",1,"X"
DATA "Y",1,"Y"
DATA "Z",1,"Z"
DATA "、",1,","
DATA "。",1,"."
DATA "1",1,"1"
DATA "2",1,"2"
DATA "3",1,"3"
DATA "4",1,"4"
DATA "5",1,"5"
DATA "6",1,"6"
DATA "7",1,"7"
DATA "8",1,"8"
DATA "9",1,"9"
DATA "0",1,"0"
DATA ",",1,","
DATA ".",1,"."
DATA "/",1,"/"
DATA ";",1,";"
DATA "P",1,"P"
DATA "0",1,"0"
DATA "\",1,"\"
DATA ":",1,":"
DATA "@",1,"@"
DATA "-",1,"-"
DATA "]",1,"]"
DATA "[",1,"["
DATA "」",1,"]"
DATA "「",1,"["
DATA "^",1,"^"
DATA "\",1,"\"
DATA " ",1," "
DATA "ー",1,"-"
DATA "・",1,"/"
DATA "",0

@SOFTKEY
DATA "1",1,0
DATA "2",4,0
DATA "3",7,0
DATA "4",10,0
DATA "5",13,0
DATA "6",16,0
DATA "7",19,0
DATA "8",22,0
DATA "9",25,0
DATA "0",28,0
DATA "-",31,0
DATA "^",34,0
DATA "\",37,0
DATA "Q",2,3
DATA "W",5,3
DATA "E",8,3
DATA "R",11,3
DATA "T",14,3
DATA "Y",17,3
DATA "U",20,3
DATA "I",23,3
DATA "O",26,3
DATA "P",29,3
DATA "@",32,3
DATA "[",35,3
DATA "A",3,6
DATA "S",6,6
DATA "D",9,6
DATA "F",12,6
DATA "G",15,6
DATA "H",18,6
DATA "J",21,6
DATA "K",24,6
DATA "L",27,6
DATA ";",30,6
DATA ":",33,6
DATA "]",36,6
DATA "Z",4,9
DATA "X",7,9
DATA "C",10,9
DATA "V",13,9
DATA "B",16,9
DATA "N",19,9
DATA "M",22,9
DATA ",",25,9
DATA ".",28,9
DATA "/",31,9
DATA "\",34,9
DATA "",0,0

'すてーじでーた
@STAGE0
'META
DATA "ホームポジション","ホームポジションの練習です。"+CHR$(13)+\
     "右手人差指をJ、中指をK、薬指をL、小指を;、"+\
     "左手人差指をF、中指をD、薬指をS、小指をAにおいたところがホームポジションとなります。"+CHR$(13)+\
     "この課題はホームポジションから手をはなさないようにして打ちましょう。"
'WORDS
DATA "HOME"
DATA "HOME_B"
DATA ""
'''LEVEL
@LEVEL0
DATA 8
DATA 0,2
DATA 1,7
DATA 2,12
DATA 3,17
DATA 4,22
DATA 5,27
DATA 6,32
DATA 7,37
DATA 8
DATA 7,37
DATA 6,32
DATA 5,27
DATA 4,22
DATA 3,17
DATA 2,12
DATA 1,7
DATA 0,2
DATA 8
DATA 3,17
DATA 4,22
DATA 2,12
DATA 5,27
DATA 1,7
DATA 6,32
DATA 0,2
DATA 7,37
DATA 8
DATA 4,22
DATA 3,17
DATA 5,27
DATA 2,12
DATA 6,32
DATA 1,7
DATA 7,37
DATA 0,2
DATA 8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA 8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA 8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA 8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA 1
DATA 8,20
DATA 0

@STAGE1
'META
DATA "左手人差し指","左手人差し指でタイプするキーの練習です。"+CHR$(13)+\
     "この課題は左手人差し指だけで打ちましょう。"
'WORDS
DATA "LHITO"
DATA "LHITO_B"
DATA ""

'LEVEL
@LEVEL1
DATA 8
DATA 0,2
DATA 1,7
DATA 2,12
DATA 3,17
DATA 4,22
DATA 5,27
DATA 6,32
DATA 7,37
DATA 8
DATA 7,37
DATA 6,32
DATA 5,27
DATA 4,22
DATA 3,17
DATA 2,12
DATA 1,7
DATA 0,2
DATA 8
DATA 3,17
DATA 4,22
DATA 2,12
DATA 5,27
DATA 1,7
DATA 6,32
DATA 0,2
DATA 7,37
DATA 8
DATA 4,22
DATA 3,17
DATA 5,27
DATA 2,12
DATA 6,32
DATA 1,7
DATA 7,37
DATA 0,2
DATA 8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA 8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA 8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA 8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA 1
DATA 8,20
DATA 0

@STAGE2
'META
DATA "右手人差し指","右手人差し指でタイプするキーの練習です。"+CHR$(13)+\
              "この課題は右手人差し指だけで打ちましょう。"
'WORDS
DATA "RHITO"
DATA "RHITO_B"
DATA ""

'LEVEL
@LEVEL2
DATA 8
DATA 0,2
DATA 1,7
DATA 2,12
DATA 3,17
DATA 4,22
DATA 5,27
DATA 6,32
DATA 7,37
DATA 8
DATA 7,37
DATA 6,32
DATA 5,27
DATA 4,22
DATA 3,17
DATA 2,12
DATA 1,7
DATA 0,2
DATA 8
DATA 3,17
DATA 4,22
DATA 2,12
DATA 5,27
DATA 1,7
DATA 6,32
DATA 0,2
DATA 7,37
DATA 8
DATA 4,22
DATA 3,17
DATA 5,27
DATA 2,12
DATA 6,32
DATA 1,7
DATA 7,37
DATA 0,2
DATA 8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA 8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA 8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA 8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA -1,-1,0,8
DATA 1
DATA 8,20
DATA 0

@STAGE3
'META
DATA "左手中指","左手中指でタイプするキーの練習です。"+CHR$(13)+\
     "この課題は左手中指だけで打ちましょう。"
'WORDS
DATA "LNAKA"
DATA "LNAKA_B"
DATA ""
'LEVEL
@LEVEL3
DATA 4
DATA 0,2
DATA 1,7
DATA 2,12
DATA 3,17
DATA 4
DATA 3,17
DATA 2,12
DATA 1,7
DATA 0,2
DATA 4
DATA 1,7
DATA 2,12
DATA 0,2
DATA 3,17
DATA 4
DATA 2,12
DATA 1,7
DATA 3,17
DATA 0,2
DATA 8
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA 8
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA 8
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA 8
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA 1
DATA 4,20
DATA 0

@STAGE4
'META
DATA "右手中指","右手中指でタイプするキーの練習です。"+CHR$(13)+\
     "この課題は右手中指だけで打ちましょう。"
'WORDS
DATA "RNAKA"
DATA "RNAKA_B"
DATA ""

'LEVEL
@LEVEL4
DATA 4
DATA 0,22
DATA 1,27
DATA 2,32
DATA 3,37
DATA 4
DATA 3,37
DATA 2,32
DATA 1,27
DATA 0,22
DATA 4
DATA 1,27
DATA 2,32
DATA 0,22
DATA 3,37
DATA 4
DATA 2,32
DATA 1,27
DATA 3,37
DATA 0,22
DATA 8
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA 8
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA 8
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA 8
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA 1
DATA 4,20
DATA 0

@STAGE5
'META
DATA "左手薬指","左手薬指でタイプするキーの練習です。"+CHR$(13)+\
     "この課題は左手薬指だけで打ちましょう。"
'WORDS
DATA "LKUSURI"
DATA "LKUSURI_B"
DATA ""
'LEVEL
@LEVEL5
DATA 4
DATA 0,2
DATA 1,7
DATA 2,12
DATA 3,17
DATA 4
DATA 3,17
DATA 2,12
DATA 1,7
DATA 0,2
DATA 4
DATA 1,7
DATA 2,12
DATA 0,2
DATA 3,17
DATA 4
DATA 2,12
DATA 1,7
DATA 3,17
DATA 0,2
DATA 8
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA 8
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA 8
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA 8
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA 1
DATA 4,20
DATA 0

@STAGE6
'META
DATA "右手薬指","右手薬指でタイプするキーの練習です。"+CHR$(13)+\
     "この課題は右手薬指だけで打ちましょう。"
'WORDS
DATA "RKUSURI"
DATA "RKUSURI_B"
DATA ""
'LEVEL
@LEVEL6
DATA 4
DATA 0,22
DATA 1,27
DATA 2,32
DATA 3,37
DATA 4
DATA 3,37
DATA 2,32
DATA 1,27
DATA 0,22
DATA 4
DATA 1,27
DATA 2,32
DATA 0,22
DATA 3,37
DATA 4
DATA 2,32
DATA 1,27
DATA 3,37
DATA 0,22
DATA 8
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA 8
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA 8
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA 8
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA 1
DATA 4,20
DATA 0

@STAGE7
'META
DATA "左手小指","左手小指でタイプするキーの練習です。"+CHR$(13)+\
     "この課題は左手小指だけで打ちましょう。"
'WORDS
DATA "LKO"
DATA "LKO_B"
DATA ""

'LEVEL
@LEVEL7
DATA 4
DATA 0,2
DATA 1,7
DATA 2,12
DATA 3,17
DATA 4
DATA 3,17
DATA 2,12
DATA 1,7
DATA 0,2
DATA 4
DATA 1,7
DATA 2,12
DATA 0,2
DATA 3,17
DATA 4
DATA 2,12
DATA 1,7
DATA 3,17
DATA 0,2
DATA 8
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA 8
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA 8
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA 8
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA -1,-1,0,4
DATA 1
DATA 4,20
DATA 0

@STAGE8
'META
DATA "右手小指","右手小指でタイプするキーの練習です。"+CHR$(13)+\
            "この課題は右手小指だけで打ちましょう。"
'WORDS
DATA "RKO"
DATA "RKO_B"
DATA ""
'LEVEL
@LEVEL8
DATA 11
DATA 0,2
DATA 1,5
DATA 2,8
DATA 3,11
DATA 4,14
DATA 5,17
DATA 6,20
DATA 7,23
DATA 8,26
DATA 9,29
DATA 10,32
DATA 11
DATA 10,32
DATA 9,29
DATA 8,26
DATA 7,23
DATA 6,20
DATA 5,17
DATA 4,14
DATA 3,11
DATA 2,8
DATA 1,5
DATA 0,2
DATA 11
DATA 5,17
DATA 6,20
DATA 4,14
DATA 7,23
DATA 3,11
DATA 8,26
DATA 2,8
DATA 9,29
DATA 1,5
DATA 10,32
DATA 0,2
DATA 11
DATA 6,20
DATA 5,17
DATA 7,23
DATA 4,14
DATA 8,26
DATA 3,11
DATA 9,29
DATA 2,8
DATA 10,32
DATA 1,5
DATA 0,2
DATA 8
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA 8
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA 8
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA 8
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA -1,-1,0,11
DATA 1
DATA 11,20
DATA 0

@STAGE9
'META
DATA "アルファベット","アルファベット(A〜Z)キーの練習です。"+CHR$(13)+\
               "指の担当を意識しながらタイピングしましょう。"+CHR$(13)+CHR$(13)+\
               "初級:推奨 60[CPM](1秒1タイプ)"+CHR$(13)+\
               "中級:推奨180[CPM](1秒3タイプ)"+CHR$(13)+\
               "上級:推奨360[CPM](1秒6タイプ)"+CHR$(13)+\
               "超級:推奨480[CPM](1秒8タイプ)"
'WORDS
DATA "ALPHA"
DATA "ALPHA_B"
DATA ""

'LEVEL
@LEVEL9
DATA 4
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA 4
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA 4
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA 4
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA 4
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA 4
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA 4
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA 4
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA 4
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA 4
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA 4
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA 4
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA 4
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA 4
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA 4
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA 4
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA -1,-1,0,26
DATA 1
DATA 26,20
DATA 0

@STAGE10
'META
DATA "A〜Z+数字+記号","アルファベット(A〜Z)+数字+記号キーの練習です。"+CHR$(13)+\
               "指の担当を意識しながらタイピングしましょう。"
'WORDS
DATA "LHITO"
DATA "RHITO"
DATA "LNAKA"
DATA "RNAKA"
DATA "LKUSURI"
DATA "RKUSURI"
DATA "LKO"
DATA "RKO"
DATA "ALPHA_B"
DATA ""
'LEVEL
@LEVEL10
DATA 4
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA 4
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA 4
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA 4
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA 4
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA 4
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA 4
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA 4
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA 4
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA 4
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA 4
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA 4
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA 4
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA 4
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA 4
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA 4
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA -1,-1,0,47
DATA 1
DATA 47,20
DATA 0

@STAGE11
'META
DATA "ひらがな","ひらがなをローマ字でを打つ練習です。"

'WORDS
DATA "HIRAGANA"
DATA ""

'LEVEL
@LEVEL11
DATA 4
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA 4
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA 4
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA 4
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA 4
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA 4
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA 4
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA 4
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA 4
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA 4
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA 4
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA 4
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA 4
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA 4
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA 4
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA 4
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA -1,-1,0,163
DATA 1
DATA 163,20
DATA 0

@STAGE12
'META
DATA "短文","短い文章を打つ練習です。"

'WORDS
DATA "TANBUN"
DATA ""

'LEVEL
@LEVEL12
DATA 4
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA 4
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA 4
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA 4
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA 4
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA 4
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA 4
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA 4
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA 4
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA 4
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA 4
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA 4
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA 4
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA 4
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA 4
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA 4
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA -1,-1,-1,-1
DATA 0

@STAGE13
'META
DATA "長文","長い文章を打つ練習です。"+CHR$(13)+\
          "出典:青空文庫"

'WORDS
DATA "TYOBUN"
DATA ""

'LEVEL
@LEVEL13
DATA 1
DATA -1,20,-1,-1
DATA 1
DATA -1,20,-1,-1
DATA 1
DATA -1,20,-1,-1
DATA 1
DATA -1,20,-1,-1
DATA 1
DATA -1,20,-1,-1
DATA 1
DATA -1,20,-1,-1
DATA 1
DATA -1,20,-1,-1
DATA 1
DATA -1,20,-1,-1
DATA 1
DATA -1,20,-1,-1
DATA 1
DATA -1,20,-1,-1

DATA 1
DATA -1,20,-1,-1
DATA 1
DATA -1,20,-1,-1
DATA 1
DATA -1,20,-1,-1
DATA 1
DATA -1,20,-1,-1
DATA 1
DATA -1,20,-1,-1
DATA 1
DATA -1,20,-1,-1
DATA 1
DATA -1,20,-1,-1
DATA 1
DATA -1,20,-1,-1
DATA 1
DATA -1,20,-1,-1
DATA 1
DATA -1,20,-1,-1

DATA 0

EUx5