      U Hosiken             M-1   $@!Hosiken                                  C       C      ' 
' プチコン漢字ライブラリ Version 2.00 Byほしけん 2019/05/25
' 
'
' ●このプチコン漢字ライブラリは、
' ・ワシがつくったと ウソをつく
' ・フォントデータのライセンスに きをつけない
' ・誰かに迷惑をかける
' 以外は自由に使って構いません。改造も自由です。

' ●プチコン漢字ライブラリのつかいかた
' PRG1(または2,3) スロットにライブラリを読み込んで初期化する
'   EXEC "KNJLIB.PRG",1
' または
'   LOAD "KNJLIB.PRG",1:EXEC 1
'   GOSUB "1:@KNJLIB_INIT"
'
' または、33行目〜を自分のプログラムの後ろにコピペして、次のように初期化する
'   GOSUB "@KNJLIB_INIT"
' 
' これで、GKNJ で始まる命令を使うことができます。
' たとえば初期化したあと、
'   GKNJPRINT 0,0,"こんにちは"
' と書くと文字が表示されます。
'   GKNJFONT 4:GKNJPRINT 0,0,"こんにちは"
' と書くと違うフォントで文字が表示されます。

' 

OPTION STRICT

' EXEC されたとき
GOSUB @KNJLIB_INIT:END

'
' ●初期化
' USE 1:GOSUB "1:@KNJLIB_INIT"
' まず最初に、このラベルに GOSUB して初期化してください。
'

@KNJLIB_INIT
  DIM KNJLIB_STRTBL$[4]
  DIM KNJLIB_FONTDAT$[4]
  DIM KNJLIB_HANKAKU%[4]
  DIM KNJLIB_BITTBL%[256*8]
  VAR KNJLIB_COLOR%=#C_WHITE,KNJLIB_BACKCOLOR%
  VAR KNJLIB_EFFECT%=0,KNJLIB_EFFCOLOR%=#C_BLACK
  VAR KNJLIB_DRAWMODE%=#G_ALPHA2
  VAR KNJLIB_SCALEX=1,KNJLIB_SCALEY=1
  VAR KNJLIB_LINEMGN%=0,KNJLIB_CHARMGN%=0
  VAR KNJLIB_FONTW%,KNJLIB_FONTH%
  VAR KNJLIB_ZENKAKUCONV%=#TRUE
  VAR KNJLIB_TABLEDIRTY%=#FALSE
  VAR KNJLIB_HANKAKUTBL$=" !"+CHR$(34)+"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~｡｢｣､･ｦｧｨｩｪｫｬｭｮｯｰｱｲｳｴｵｶｷｸｹｺｻｼｽｾｿﾀﾁﾂﾃﾄﾅﾆﾇﾈﾉﾊﾋﾌﾍﾎﾏﾐﾑﾒﾓﾔﾕﾖﾗﾘﾙﾚﾛﾜﾝﾞﾟ"
  VAR KNJLIB_ZENKAKUTBL$="　！”＃＄％＆’（）＊＋，－．／０１２３４５６７８９：；＜＝＞？＠ＡＢＣＤＥＦＧＨＩＪＫＬＭＮＯＰＱＲＳＴＵＶＷＸＹＺ［￥］＾＿｀ａｂｃｄｅｆｇｈｉｊｋｌｍｎｏｐｑｒｓｔｕｖｗｘｙｚ｛｜｝～。「」、・ヲァィゥェォャュョッーアイウエオカキクケコサシスセソタチツテトナニヌネノハヒフヘホマミムメモヤユヨラリルレロワン゛゜"
  VAR KNJLIB_KNJCONVMARK$="$"
  _GKNJINIT
  RETURN

DEF _GKNJINIT
  VAR I%,J%
  FOR I%=0 TO 255
    FOR J%=0 TO 7
      KNJLIB_BITTBL%[I%*8+(7-J%)]=SGN(I% AND (1<<J%))
    NEXT
  NEXT

  GKNJTABLEINIT
  GKNJFONT 0
END

'
' ●全角変換の設定
' #TRUE の場合、GKNJPRINT で表示する内容を自動的に全角に変換します
'
COMMON DEF GKNJZENKAKU SET%
  KNJLIB_ZENKAKUCONV%=SET%
END

'
' ●フォントデータ文字テーブルの初期化
' フォントデータがどういう文字の順で並んでいるかのテーブルを標準に戻します。
'
COMMON DEF GKNJTABLEINIT
  KNJLIB_TABLEDIRTY%=#FALSE

  ' 0:半角文字
  KNJLIB_HANKAKU%[0]=#TRUE
  KNJLIB_STRTBL$[0]=" !"+CHR$(34)+"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~｡｢｣､･ｦｧｨｩｪｫｬｭｮｯｰｱｲｳｴｵｶｷｸｹｺｻｼｽｾｿﾀﾁﾂﾃﾄﾅﾆﾇﾈﾉﾊﾋﾌﾍﾎﾏﾐﾑﾒﾓﾔﾕﾖﾗﾘﾙﾚﾛﾜﾝﾞﾟ"
  ' 1:全角非漢字
  KNJLIB_STRTBL$[1]="　、。，．・：；？！゛゜´｀¨＾￣＿ヽヾゝゞ〃仝々〆〇ー―‐／＼〜∥｜…‥‘’“”（）〔〕［］｛｝〈〉《》「」『』【】＋－±×÷＝≠＜＞≦≧∞∴♂♀°′″℃￥＄￠￡％＃＆＊＠§☆★○●◎◇◆□■△▲▽▼※〒→←↑↓〓∈∋⊆⊇⊂⊃∪∩∧∨￢⇒⇔∀∃∠⊥⌒∂∇≡≒≪≫√∽∝∵∫∬Å‰♯♭♪†‡¶◯０１２３４５６７８９ＡＢＣＤＥＦＧＨＩＪＫＬＭＮＯＰＱＲＳＴＵＶＷＸＹＺａｂｃｄｅｆｇｈｉｊｋｌｍｎｏｐｑｒｓｔｕｖｗｘｙｚぁあぃいぅうぇえぉおかがきぎくぐけげこごさざしじすずせぜそぞただちぢっつづてでとどなにぬねのはばぱひびぴふぶぷへべぺほぼぽまみむめもゃやゅゆょよらりるれろゎわゐゑをんァアィイゥウェエォオカガキギクグケゲコゴサザシジスズセゼソゾタダチヂッツヅテデトドナニヌネノハバパヒビピフブプヘベペホボポマミムメモャヤュユョヨラリルレロヮワヰヱヲンヴヵヶΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡΣΤΥΦΧΨΩαβγδεζηθικλμνξοπρστυφχψωАБВГДЕЁЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯабвгдеёжзийклмнопрстуфхцчшщъыьэюя─│┌┐┘└├┬┤┴┼━┃┏┓┛┗┣┳┫┻╋┠┯┨┷┿┝┰┥┸╂①②③④⑤⑥⑦⑧⑨⑩⑪⑫⑬⑭⑮⑯⑰⑱⑲⑳ⅠⅡⅢⅣⅤⅥⅦⅧⅨⅩ㍉㌔㌢㍍㌘㌧㌃㌶㍑㍗㌍㌦㌣㌫㍊㌻㎜㎝㎞㎎㎏㏄㎡㍻〝〟№㏍℡㊤㊥㊦㊧㊨㈱㈲㈹㍾㍽㍼≒≡∫∮∑√⊥∠∟⊿∵∩∪"
  ' 2:JIS第1水準漢字
  KNJLIB_STRTBL$[2]="亜唖娃阿哀愛挨姶逢葵茜穐悪握渥旭葦芦鯵梓圧斡扱宛姐虻飴絢綾鮎或粟袷安庵按暗案闇鞍杏以伊位依偉囲夷委威尉惟意慰易椅為畏異移維緯胃萎衣謂違遺医井亥域育郁磯一壱溢逸稲茨芋鰯允印咽員因姻引飲淫胤蔭院陰隠韻吋右宇烏羽迂雨卯鵜窺丑碓臼渦嘘唄欝蔚鰻姥厩浦瓜閏噂云運雲荏餌叡営嬰影映曳栄永泳洩瑛盈穎頴英衛詠鋭液疫益駅悦謁越閲榎厭円園堰奄宴延怨掩援沿演炎焔煙燕猿縁艶苑薗遠鉛鴛塩於汚甥凹央奥往応押旺横欧殴王翁襖鴬鴎黄岡沖荻億屋憶臆桶牡乙俺卸恩温穏音下化仮何伽価佳加可嘉夏嫁家寡科暇果架歌河火珂禍禾稼箇花苛茄荷華菓蝦課嘩貨迦過霞蚊俄峨我牙画臥芽蛾賀雅餓駕介会解回塊壊廻快怪悔恢懐戒拐改魁晦械海灰界皆絵芥蟹開階貝凱劾外咳害崖慨概涯碍蓋街該鎧骸浬馨蛙垣柿蛎鈎劃嚇各廓拡撹格核殻獲確穫覚角赫較郭閣隔革学岳楽額顎掛笠樫橿梶鰍潟割喝恰括活渇滑葛褐轄且鰹叶椛樺鞄株兜竃蒲釜鎌噛鴨栢茅萱粥刈苅瓦乾侃冠寒刊勘勧巻喚堪姦完官寛干幹患感慣憾換敢柑桓棺款歓汗漢澗潅環甘監看竿管簡緩缶翰肝艦莞観諌貫還鑑間閑関陥韓館舘丸含岸巌玩癌眼岩翫贋雁頑顔願企伎危喜器基奇嬉寄岐希幾忌揮机旗既期棋棄機帰毅気汽畿祈季稀紀徽規記貴起軌輝飢騎鬼亀偽儀妓宜戯技擬欺犠疑祇義蟻誼議掬菊鞠吉吃喫桔橘詰砧杵黍却客脚虐逆丘久仇休及吸宮弓急救朽求汲泣灸球究窮笈級糾給旧牛去居巨拒拠挙渠虚許距鋸漁禦魚亨享京供侠僑兇競共凶協匡卿叫喬境峡強彊怯恐恭挟教橋況狂狭矯胸脅興蕎郷鏡響饗驚仰凝尭暁業局曲極玉桐粁僅勤均巾錦斤欣欽琴禁禽筋緊芹菌衿襟謹近金吟銀九倶句区狗玖矩苦躯駆駈駒具愚虞喰空偶寓遇隅串櫛釧屑屈掘窟沓靴轡窪熊隈粂栗繰桑鍬勲君薫訓群軍郡卦袈祁係傾刑兄啓圭珪型契形径恵慶慧憩掲携敬景桂渓畦稽系経継繋罫茎荊蛍計詣警軽頚鶏芸迎鯨劇戟撃激隙桁傑欠決潔穴結血訣月件倹倦健兼券剣喧圏堅嫌建憲懸拳捲検権牽犬献研硯絹県肩見謙賢軒遣鍵険顕験鹸元原厳幻弦減源玄現絃舷言諺限乎個古呼固姑孤己庫弧戸故枯湖狐糊袴股胡菰虎誇跨鈷雇顧鼓五互伍午呉吾娯後御悟梧檎瑚碁語誤護醐乞鯉交佼侯候倖光公功効勾厚口向后喉坑垢好孔孝宏工巧巷幸広庚康弘恒慌抗拘控攻昂晃更杭校梗構江洪浩港溝甲皇硬稿糠紅紘絞綱耕考肯肱腔膏航荒行衡講貢購郊酵鉱砿鋼閤降項香高鴻剛劫号合壕拷濠豪轟麹克刻告国穀酷鵠黒獄漉腰甑忽惚骨狛込此頃今困坤墾婚恨懇昏昆根梱混痕紺艮魂些佐叉唆嵯左差査沙瑳砂詐鎖裟坐座挫債催再最哉塞妻宰彩才採栽歳済災采犀砕砦祭斎細菜裁載際剤在材罪財冴坂阪堺榊肴咲崎埼碕鷺作削咋搾昨朔柵窄策索錯桜鮭笹匙冊刷察拶撮擦札殺薩雑皐鯖捌錆鮫皿晒三傘参山惨撒散桟燦珊産算纂蚕讃賛酸餐斬暫残仕仔伺使刺司史嗣四士始姉姿子屍市師志思指支孜斯施旨枝止死氏獅祉私糸紙紫肢脂至視詞詩試誌諮資賜雌飼歯事似侍児字寺慈持時次滋治爾璽痔磁示而耳自蒔辞汐鹿式識鴫竺軸宍雫七叱執失嫉室悉湿漆疾質実蔀篠偲柴芝屡蕊縞舎写射捨赦斜煮社紗者謝車遮蛇邪借勺尺杓灼爵酌釈錫若寂弱惹主取守手朱殊狩珠種腫趣酒首儒受呪寿授樹綬需囚収周宗就州修愁拾洲秀秋終繍習臭舟蒐衆襲讐蹴輯週酋酬集醜什住充十従戎柔汁渋獣縦重銃叔夙宿淑祝縮粛塾熟出術述俊峻春瞬竣舜駿准循旬楯殉淳準潤盾純巡遵醇順処初所暑曙渚庶緒署書薯藷諸助叙女序徐恕鋤除傷償勝匠升召哨商唱嘗奨妾娼宵将小少尚庄床廠彰承抄招掌捷昇昌昭晶松梢樟樵沼消渉湘焼焦照症省硝礁祥称章笑粧紹肖菖蒋蕉衝裳訟証詔詳象賞醤鉦鍾鐘障鞘上丈丞乗冗剰城場壌嬢常情擾条杖浄状畳穣蒸譲醸錠嘱埴飾拭植殖燭織職色触食蝕辱尻伸信侵唇娠寝審心慎振新晋森榛浸深申疹真神秦紳臣芯薪親診身辛進針震人仁刃塵壬尋甚尽腎訊迅陣靭笥諏須酢図厨逗吹垂帥推水炊睡粋翠衰遂酔錐錘随瑞髄崇嵩数枢趨雛据杉椙菅頗雀裾澄摺寸世瀬畝是凄制勢姓征性成政整星晴棲栖正清牲生盛精聖声製西誠誓請逝醒青静斉税脆隻席惜戚斥昔析石積籍績脊責赤跡蹟碩切拙接摂折設窃節説雪絶舌蝉仙先千占宣専尖川戦扇撰栓栴泉浅洗染潜煎煽旋穿箭線繊羨腺舛船薦詮賎践選遷銭銑閃鮮前善漸然全禅繕膳糎噌塑岨措曾曽楚狙疏疎礎祖租粗素組蘇訴阻遡鼠僧創双叢倉喪壮奏爽宋層匝惣想捜掃挿掻操早曹巣槍槽漕燥争痩相窓糟総綜聡草荘葬蒼藻装走送遭鎗霜騒像増憎臓蔵贈造促側則即息捉束測足速俗属賊族続卒袖其揃存孫尊損村遜他多太汰詑唾堕妥惰打柁舵楕陀駄騨体堆対耐岱帯待怠態戴替泰滞胎腿苔袋貸退逮隊黛鯛代台大第醍題鷹滝瀧卓啄宅托択拓沢濯琢託鐸濁諾茸凧蛸只叩但達辰奪脱巽竪辿棚谷狸鱈樽誰丹単嘆坦担探旦歎淡湛炭短端箪綻耽胆蛋誕鍛団壇弾断暖檀段男談値知地弛恥智池痴稚置致蜘遅馳築畜竹筑蓄逐秩窒茶嫡着中仲宙忠抽昼柱注虫衷註酎鋳駐樗瀦猪苧著貯丁兆凋喋寵帖帳庁弔張彫徴懲挑暢朝潮牒町眺聴脹腸蝶調諜超跳銚長頂鳥勅捗直朕沈珍賃鎮陳津墜椎槌追鎚痛通塚栂掴槻佃漬柘辻蔦綴鍔椿潰坪壷嬬紬爪吊釣鶴亭低停偵剃貞呈堤定帝底庭廷弟悌抵挺提梯汀碇禎程締艇訂諦蹄逓邸鄭釘鼎泥摘擢敵滴的笛適鏑溺哲徹撤轍迭鉄典填天展店添纏甜貼転顛点伝殿澱田電兎吐堵塗妬屠徒斗杜渡登菟賭途都鍍砥砺努度土奴怒倒党冬凍刀唐塔塘套宕島嶋悼投搭東桃梼棟盗淘湯涛灯燈当痘祷等答筒糖統到董蕩藤討謄豆踏逃透鐙陶頭騰闘働動同堂導憧撞洞瞳童胴萄道銅峠鴇匿得徳涜特督禿篤毒独読栃橡凸突椴届鳶苫寅酉瀞噸屯惇敦沌豚遁頓呑曇鈍奈那内乍凪薙謎灘捺鍋楢馴縄畷南楠軟難汝二尼弐迩匂賑肉虹廿日乳入如尿韮任妊忍認濡禰祢寧葱猫熱年念捻撚燃粘乃廼之埜嚢悩濃納能脳膿農覗蚤巴把播覇杷波派琶破婆罵芭馬俳廃拝排敗杯盃牌背肺輩配倍培媒梅楳煤狽買売賠陪這蝿秤矧萩伯剥博拍柏泊白箔粕舶薄迫曝漠爆縛莫駁麦函箱硲箸肇筈櫨幡肌畑畠八鉢溌発醗髪伐罰抜筏閥鳩噺塙蛤隼伴判半反叛帆搬斑板氾汎版犯班畔繁般藩販範釆煩頒飯挽晩番盤磐蕃蛮匪卑否妃庇彼悲扉批披斐比泌疲皮碑秘緋罷肥被誹費避非飛樋簸備尾微枇毘琵眉美鼻柊稗匹疋髭彦膝菱肘弼必畢筆逼桧姫媛紐百謬俵彪標氷漂瓢票表評豹廟描病秒苗錨鋲蒜蛭鰭品彬斌浜瀕貧賓頻敏瓶不付埠夫婦富冨布府怖扶敷斧普浮父符腐膚芙譜負賦赴阜附侮撫武舞葡蕪部封楓風葺蕗伏副復幅服福腹複覆淵弗払沸仏物鮒分吻噴墳憤扮焚奮粉糞紛雰文聞丙併兵塀幣平弊柄並蔽閉陛米頁僻壁癖碧別瞥蔑箆偏変片篇編辺返遍便勉娩弁鞭保舗鋪圃捕歩甫補輔穂募墓慕戊暮母簿菩倣俸包呆報奉宝峰峯崩庖抱捧放方朋法泡烹砲縫胞芳萌蓬蜂褒訪豊邦鋒飽鳳鵬乏亡傍剖坊妨帽忘忙房暴望某棒冒紡肪膨謀貌貿鉾防吠頬北僕卜墨撲朴牧睦穆釦勃没殆堀幌奔本翻凡盆摩磨魔麻埋妹昧枚毎哩槙幕膜枕鮪柾鱒桝亦俣又抹末沫迄侭繭麿万慢満漫蔓味未魅巳箕岬密蜜湊蓑稔脈妙粍民眠務夢無牟矛霧鵡椋婿娘冥名命明盟迷銘鳴姪牝滅免棉綿緬面麺摸模茂妄孟毛猛盲網耗蒙儲木黙目杢勿餅尤戻籾貰問悶紋門匁也冶夜爺耶野弥矢厄役約薬訳躍靖柳薮鑓愉愈油癒諭輸唯佑優勇友宥幽悠憂揖有柚湧涌猶猷由祐裕誘遊邑郵雄融夕予余与誉輿預傭幼妖容庸揚揺擁曜楊様洋溶熔用窯羊耀葉蓉要謡踊遥陽養慾抑欲沃浴翌翼淀羅螺裸来莱頼雷洛絡落酪乱卵嵐欄濫藍蘭覧利吏履李梨理璃痢裏裡里離陸律率立葎掠略劉流溜琉留硫粒隆竜龍侶慮旅虜了亮僚両凌寮料梁涼猟療瞭稜糧良諒遼量陵領力緑倫厘林淋燐琳臨輪隣鱗麟瑠塁涙累類令伶例冷励嶺怜玲礼苓鈴隷零霊麗齢暦歴列劣烈裂廉恋憐漣煉簾練聯蓮連錬呂魯櫓炉賂路露労婁廊弄朗楼榔浪漏牢狼篭老聾蝋郎六麓禄肋録論倭和話歪賄脇惑枠鷲亙亘鰐詫藁蕨椀湾碗腕"
  ' 3:JIS第2水準漢字
  KNJLIB_STRTBL$[3]="弌丐丕个丱丶丼丿乂乖乘亂亅豫亊舒弍于亞亟亠亢亰亳亶从仍仄仆仂仗仞仭仟价伉佚估佛佝佗佇佶侈侏侘佻佩佰侑佯來侖儘俔俟俎俘俛俑俚俐俤俥倚倨倔倪倥倅伜俶倡倩倬俾俯們倆偃假會偕偐偈做偖偬偸傀傚傅傴傲僉僊傳僂僖僞僥僭僣僮價僵儉儁儂儖儕儔儚儡儺儷儼儻儿兀兒兌兔兢竸兩兪兮冀冂囘册冉冏冑冓冕冖冤冦冢冩冪冫决冱冲冰况冽凅凉凛几處凩凭凰凵凾刄刋刔刎刧刪刮刳刹剏剄剋剌剞剔剪剴剩剳剿剽劍劔劒剱劈劑辨辧劬劭劼劵勁勍勗勞勣勦飭勠勳勵勸勹匆匈甸匍匐匏匕匚匣匯匱匳匸區卆卅丗卉卍凖卞卩卮夘卻卷厂厖厠厦厥厮厰厶參簒雙叟曼燮叮叨叭叺吁吽呀听吭吼吮吶吩吝呎咏呵咎呟呱呷呰咒呻咀呶咄咐咆哇咢咸咥咬哄哈咨咫哂咤咾咼哘哥哦唏唔哽哮哭哺哢唹啀啣啌售啜啅啖啗唸唳啝喙喀咯喊喟啻啾喘喞單啼喃喩喇喨嗚嗅嗟嗄嗜嗤嗔嘔嗷嘖嗾嗽嘛嗹噎噐營嘴嘶嘲嘸噫噤嘯噬噪嚆嚀嚊嚠嚔嚏嚥嚮嚶嚴囂嚼囁囃囀囈囎囑囓囗囮囹圀囿圄圉圈國圍圓團圖嗇圜圦圷圸坎圻址坏坩埀垈坡坿垉垓垠垳垤垪垰埃埆埔埒埓堊埖埣堋堙堝塲堡塢塋塰毀塒堽塹墅墹墟墫墺壞墻墸墮壅壓壑壗壙壘壥壜壤壟壯壺壹壻壼壽夂夊夐夛梦夥夬夭夲夸夾竒奕奐奎奚奘奢奠奧奬奩奸妁妝佞侫妣妲姆姨姜妍姙姚娥娟娑娜娉娚婀婬婉娵娶婢婪媚媼媾嫋嫂媽嫣嫗嫦嫩嫖嫺嫻嬌嬋嬖嬲嫐嬪嬶嬾孃孅孀孑孕孚孛孥孩孰孳孵學斈孺宀它宦宸寃寇寉寔寐寤實寢寞寥寫寰寶寳尅將專對尓尠尢尨尸尹屁屆屎屓屐屏孱屬屮乢屶屹岌岑岔妛岫岻岶岼岷峅岾峇峙峩峽峺峭嶌峪崋崕崗嵜崟崛崑崔崢崚崙崘嵌嵒嵎嵋嵬嵳嵶嶇嶄嶂嶢嶝嶬嶮嶽嶐嶷嶼巉巍巓巒巖巛巫已巵帋帚帙帑帛帶帷幄幃幀幎幗幔幟幢幤幇幵并幺麼广庠廁廂廈廐廏廖廣廝廚廛廢廡廨廩廬廱廳廰廴廸廾弃弉彝彜弋弑弖弩弭弸彁彈彌彎弯彑彖彗彙彡彭彳彷徃徂彿徊很徑徇從徙徘徠徨徭徼忖忻忤忸忱忝悳忿怡恠怙怐怩怎怱怛怕怫怦怏怺恚恁恪恷恟恊恆恍恣恃恤恂恬恫恙悁悍惧悃悚悄悛悖悗悒悧悋惡悸惠惓悴忰悽惆悵惘慍愕愆惶惷愀惴惺愃愡惻惱愍愎慇愾愨愧慊愿愼愬愴愽慂慄慳慷慘慙慚慫慴慯慥慱慟慝慓慵憙憖憇憬憔憚憊憑憫憮懌懊應懷懈懃懆憺懋罹懍懦懣懶懺懴懿懽懼懾戀戈戉戍戌戔戛戞戡截戮戰戲戳扁扎扞扣扛扠扨扼抂抉找抒抓抖拔抃抔拗拑抻拏拿拆擔拈拜拌拊拂拇抛拉挌拮拱挧挂挈拯拵捐挾捍搜捏掖掎掀掫捶掣掏掉掟掵捫捩掾揩揀揆揣揉插揶揄搖搴搆搓搦搶攝搗搨搏摧摯摶摎攪撕撓撥撩撈撼據擒擅擇撻擘擂擱擧舉擠擡抬擣擯攬擶擴擲擺攀擽攘攜攅攤攣攫攴攵攷收攸畋效敖敕敍敘敞敝敲數斂斃變斛斟斫斷旃旆旁旄旌旒旛旙无旡旱杲昊昃旻杳昵昶昴昜晏晄晉晁晞晝晤晧晨晟晢晰暃暈暎暉暄暘暝曁暹曉暾暼曄暸曖曚曠昿曦曩曰曵曷朏朖朞朦朧霸朮朿朶杁朸朷杆杞杠杙杣杤枉杰枩杼杪枌枋枦枡枅枷柯枴柬枳柩枸柤柞柝柢柮枹柎柆柧檜栞框栩桀桍栲桎梳栫桙档桷桿梟梏梭梔條梛梃檮梹桴梵梠梺椏梍桾椁棊椈棘椢椦棡椌棍棔棧棕椶椒椄棗棣椥棹棠棯椨椪椚椣椡棆楹楷楜楸楫楔楾楮椹楴椽楙椰楡楞楝榁楪榲榮槐榿槁槓榾槎寨槊槝榻槃榧樮榑榠榜榕榴槞槨樂樛槿權槹槲槧樅榱樞槭樔槫樊樒櫁樣樓橄樌橲樶橸橇橢橙橦橈樸樢檐檍檠檄檢檣檗蘗檻櫃櫂檸檳檬櫞櫑櫟檪櫚櫪櫻欅蘖櫺欒欖鬱欟欸欷盜欹飮歇歃歉歐歙歔歛歟歡歸歹歿殀殄殃殍殘殕殞殤殪殫殯殲殱殳殷殼毆毋毓毟毬毫毳毯麾氈氓气氛氤氣汞汕汢汪沂沍沚沁沛汾汨汳沒沐泄泱泓沽泗泅泝沮沱沾沺泛泯泙泪洟衍洶洫洽洸洙洵洳洒洌浣涓浤浚浹浙涎涕濤涅淹渕渊涵淇淦涸淆淬淞淌淨淒淅淺淙淤淕淪淮渭湮渮渙湲湟渾渣湫渫湶湍渟湃渺湎渤滿渝游溂溪溘滉溷滓溽溯滄溲滔滕溏溥滂溟潁漑灌滬滸滾漿滲漱滯漲滌漾漓滷澆潺潸澁澀潯潛濳潭澂潼潘澎澑濂潦澳澣澡澤澹濆澪濟濕濬濔濘濱濮濛瀉瀋濺瀑瀁瀏濾瀛瀚潴瀝瀘瀟瀰瀾瀲灑灣炙炒炯烱炬炸炳炮烟烋烝烙焉烽焜焙煥煕熈煦煢煌煖煬熏燻熄熕熨熬燗熹熾燒燉燔燎燠燬燧燵燼燹燿爍爐爛爨爭爬爰爲爻爼爿牀牆牋牘牴牾犂犁犇犒犖犢犧犹犲狃狆狄狎狒狢狠狡狹狷倏猗猊猜猖猝猴猯猩猥猾獎獏默獗獪獨獰獸獵獻獺珈玳珎玻珀珥珮珞璢琅瑯琥珸琲琺瑕琿瑟瑙瑁瑜瑩瑰瑣瑪瑶瑾璋璞璧瓊瓏瓔珱瓠瓣瓧瓩瓮瓲瓰瓱瓸瓷甄甃甅甌甎甍甕甓甞甦甬甼畄畍畊畉畛畆畚畩畤畧畫畭畸當疆疇畴疊疉疂疔疚疝疥疣痂疳痃疵疽疸疼疱痍痊痒痙痣痞痾痿痼瘁痰痺痲痳瘋瘍瘉瘟瘧瘠瘡瘢瘤瘴瘰瘻癇癈癆癜癘癡癢癨癩癪癧癬癰癲癶癸發皀皃皈皋皎皖皓皙皚皰皴皸皹皺盂盍盖盒盞盡盥盧盪蘯盻眈眇眄眩眤眞眥眦眛眷眸睇睚睨睫睛睥睿睾睹瞎瞋瞑瞠瞞瞰瞶瞹瞿瞼瞽瞻矇矍矗矚矜矣矮矼砌砒礦砠礪硅碎硴碆硼碚碌碣碵碪碯磑磆磋磔碾碼磅磊磬磧磚磽磴礇礒礑礙礬礫祀祠祗祟祚祕祓祺祿禊禝禧齋禪禮禳禹禺秉秕秧秬秡秣稈稍稘稙稠稟禀稱稻稾稷穃穗穉穡穢穩龝穰穹穽窈窗窕窘窖窩竈窰窶竅竄窿邃竇竊竍竏竕竓站竚竝竡竢竦竭竰笂笏笊笆笳笘笙笞笵笨笶筐筺笄筍笋筌筅筵筥筴筧筰筱筬筮箝箘箟箍箜箚箋箒箏筝箙篋篁篌篏箴篆篝篩簑簔篦篥籠簀簇簓篳篷簗簍篶簣簧簪簟簷簫簽籌籃籔籏籀籐籘籟籤籖籥籬籵粃粐粤粭粢粫粡粨粳粲粱粮粹粽糀糅糂糘糒糜糢鬻糯糲糴糶糺紆紂紜紕紊絅絋紮紲紿紵絆絳絖絎絲絨絮絏絣經綉絛綏絽綛綺綮綣綵緇綽綫總綢綯緜綸綟綰緘緝緤緞緻緲緡縅縊縣縡縒縱縟縉縋縢繆繦縻縵縹繃縷縲縺繧繝繖繞繙繚繹繪繩繼繻纃緕繽辮繿纈纉續纒纐纓纔纖纎纛纜缸缺罅罌罍罎罐网罕罔罘罟罠罨罩罧罸羂羆羃羈羇羌羔羞羝羚羣羯羲羹羮羶羸譱翅翆翊翕翔翡翦翩翳翹飜耆耄耋耒耘耙耜耡耨耿耻聊聆聒聘聚聟聢聨聳聲聰聶聹聽聿肄肆肅肛肓肚肭冐肬胛胥胙胝胄胚胖脉胯胱脛脩脣脯腋隋腆脾腓腑胼腱腮腥腦腴膃膈膊膀膂膠膕膤膣腟膓膩膰膵膾膸膽臀臂膺臉臍臑臙臘臈臚臟臠臧臺臻臾舁舂舅與舊舍舐舖舩舫舸舳艀艙艘艝艚艟艤艢艨艪艫舮艱艷艸艾芍芒芫芟芻芬苡苣苟苒苴苳苺莓范苻苹苞茆苜茉苙茵茴茖茲茱荀茹荐荅茯茫茗茘莅莚莪莟莢莖茣莎莇莊荼莵荳荵莠莉莨菴萓菫菎菽萃菘萋菁菷萇菠菲萍萢萠莽萸蔆菻葭萪萼蕚蒄葷葫蒭葮蒂葩葆萬葯葹萵蓊葢蒹蒿蒟蓙蓍蒻蓚蓐蓁蓆蓖蒡蔡蓿蓴蔗蔘蔬蔟蔕蔔蓼蕀蕣蕘蕈蕁蘂蕋蕕薀薤薈薑薊薨蕭薔薛藪薇薜蕷蕾薐藉薺藏薹藐藕藝藥藜藹蘊蘓蘋藾藺蘆蘢蘚蘰蘿虍乕虔號虧虱蚓蚣蚩蚪蚋蚌蚶蚯蛄蛆蚰蛉蠣蚫蛔蛞蛩蛬蛟蛛蛯蜒蜆蜈蜀蜃蛻蜑蜉蜍蛹蜊蜴蜿蜷蜻蜥蜩蜚蝠蝟蝸蝌蝎蝴蝗蝨蝮蝙蝓蝣蝪蠅螢螟螂螯蟋螽蟀蟐雖螫蟄螳蟇蟆螻蟯蟲蟠蠏蠍蟾蟶蟷蠎蟒蠑蠖蠕蠢蠡蠱蠶蠹蠧蠻衄衂衒衙衞衢衫袁衾袞衵衽袵衲袂袗袒袮袙袢袍袤袰袿袱裃裄裔裘裙裝裹褂裼裴裨裲褄褌褊褓襃褞褥褪褫襁襄褻褶褸襌褝襠襞襦襤襭襪襯襴襷襾覃覈覊覓覘覡覩覦覬覯覲覺覽覿觀觚觜觝觧觴觸訃訖訐訌訛訝訥訶詁詛詒詆詈詼詭詬詢誅誂誄誨誡誑誥誦誚誣諄諍諂諚諫諳諧諤諱謔諠諢諷諞諛謌謇謚諡謖謐謗謠謳鞫謦謫謾謨譁譌譏譎證譖譛譚譫譟譬譯譴譽讀讌讎讒讓讖讙讚谺豁谿豈豌豎豐豕豢豬豸豺貂貉貅貊貍貎貔豼貘戝貭貪貽貲貳貮貶賈賁賤賣賚賽賺賻贄贅贊贇贏贍贐齎贓賍贔贖赧赭赱赳趁趙跂趾趺跏跚跖跌跛跋跪跫跟跣跼踈踉跿踝踞踐踟蹂踵踰踴蹊蹇蹉蹌蹐蹈蹙蹤蹠踪蹣蹕蹶蹲蹼躁躇躅躄躋躊躓躑躔躙躪躡躬躰軆躱躾軅軈軋軛軣軼軻軫軾輊輅輕輒輙輓輜輟輛輌輦輳輻輹轅轂輾轌轉轆轎轗轜轢轣轤辜辟辣辭辯辷迚迥迢迪迯邇迴逅迹迺逑逕逡逍逞逖逋逧逶逵逹迸遏遐遑遒逎遉逾遖遘遞遨遯遶隨遲邂遽邁邀邊邉邏邨邯邱邵郢郤扈郛鄂鄒鄙鄲鄰酊酖酘酣酥酩酳酲醋醉醂醢醫醯醪醵醴醺釀釁釉釋釐釖釟釡釛釼釵釶鈞釿鈔鈬鈕鈑鉞鉗鉅鉉鉤鉈銕鈿鉋鉐銜銖銓銛鉚鋏銹銷鋩錏鋺鍄錮錙錢錚錣錺錵錻鍜鍠鍼鍮鍖鎰鎬鎭鎔鎹鏖鏗鏨鏥鏘鏃鏝鏐鏈鏤鐚鐔鐓鐃鐇鐐鐶鐫鐵鐡鐺鑁鑒鑄鑛鑠鑢鑞鑪鈩鑰鑵鑷鑽鑚鑼鑾钁鑿閂閇閊閔閖閘閙閠閨閧閭閼閻閹閾闊濶闃闍闌闕闔闖關闡闥闢阡阨阮阯陂陌陏陋陷陜陞陝陟陦陲陬隍隘隕隗險隧隱隲隰隴隶隸隹雎雋雉雍襍雜霍雕雹霄霆霈霓霎霑霏霖霙霤霪霰霹霽霾靄靆靈靂靉靜靠靤靦靨勒靫靱靹鞅靼鞁靺鞆鞋鞏鞐鞜鞨鞦鞣鞳鞴韃韆韈韋韜韭齏韲竟韶韵頏頌頸頤頡頷頽顆顏顋顫顯顰顱顴顳颪颯颱颶飄飃飆飩飫餃餉餒餔餘餡餝餞餤餠餬餮餽餾饂饉饅饐饋饑饒饌饕馗馘馥馭馮馼駟駛駝駘駑駭駮駱駲駻駸騁騏騅駢騙騫騷驅驂驀驃騾驕驍驛驗驟驢驥驤驩驫驪骭骰骼髀髏髑髓體髞髟髢髣髦髯髫髮髴髱髷髻鬆鬘鬚鬟鬢鬣鬥鬧鬨鬩鬪鬮鬯鬲魄魃魏魍魎魑魘魴鮓鮃鮑鮖鮗鮟鮠鮨鮴鯀鯊鮹鯆鯏鯑鯒鯣鯢鯤鯔鯡鰺鯲鯱鯰鰕鰔鰉鰓鰌鰆鰈鰒鰊鰄鰮鰛鰥鰤鰡鰰鱇鰲鱆鰾鱚鱠鱧鱶鱸鳧鳬鳰鴉鴈鳫鴃鴆鴪鴦鶯鴣鴟鵄鴕鴒鵁鴿鴾鵆鵈鵝鵞鵤鵑鵐鵙鵲鶉鶇鶫鵯鵺鶚鶤鶩鶲鷄鷁鶻鶸鶺鷆鷏鷂鷙鷓鷸鷦鷭鷯鷽鸚鸛鸞鹵鹹鹽麁麈麋麌麒麕麑麝麥麩麸麪麭靡黌黎黏黐黔黜點黝黠黥黨黯黴黶黷黹黻黼黽鼇鼈皷鼕鼡鼬鼾齊齒齔齣齟齠齡齦齧齬齪齷齲齶龕龜龠堯槇遙瑤凜熙"
END

'
' ●フォントデータ文字テーブルの設定
' GKNJTABLE 種別,文字の並び文字列
' 種別は 0:半角文字 1:全角非漢字 2:JIS第1水準漢字 3:JIS第2水準漢字
' フォントデータがどういう文字の順で並んでいるかを設定します。
' サブセットツール(KNJLIB_SUBTOOL)で
' サブセット(使う文字だけ抽出したデータ)化した
' フォントデータを設定したいときに使います。
'
COMMON DEF GKNJTABLE BANK%,TBL$
  KNJLIB_TABLEDIRTY%=#TRUE
  KNJLIB_STRTBL$[BANK%]=TBL$
END

'
' ●フォントデータの設定開始
' GKNJDEFINIT フォントデータの幅,フォントデータの高さ
' ライブラリの外からフォントデータを設定する際、まず初期化します。
' これを呼んだあと、GKNJDEF 命令でフォントデータを送り込んでください。
'
COMMON DEF GKNJDEFINIT W%,H%
  VAR I%,L%=LEN(KNJLIB_FONTDAT$)
  KNJLIB_FONTW%=W%:KNJLIB_FONTH%=H%
  FOR I%=0 TO L%-1
    KNJLIB_FONTDAT$[I%]=""
  NEXT
END

'
' ●フォントデータの設定
' GKNJDEF 種別,フォントデータ(すごく長い文字列)
' フォントデータを直接設定します。
' 事前に GKNJDEFINIT でフォントデータの幅と高さを設定してください。
' 種別は 0:半角文字 1:全角非漢字 2:JIS第1水準漢字 3:JIS第2水準漢字
'
COMMON DEF GKNJDEF BANK%,PAT$
  KNJLIB_FONTDAT$[BANK%]=PAT$
END

'
' ●フォントデータの設定(データを追加)
' GKNJDEFAPPEND 種別,フォントデータ(すごく長い文字列)
' フォントデータを直接設定します。これまで設定されたデータの末尾につぎ足します。
' データの文字列の式が長すぎてエラーになる場合に、データを複数に分割して設定できます。
' 種別は 0:半角文字 1:全角非漢字 2:JIS第1水準漢字 3:JIS第2水準漢字
'
COMMON DEF GKNJDEFAPPEND BANK%,PAT$
  INC KNJLIB_FONTDAT$[BANK%],PAT$
END

COMMON DEF GKNJFONT FONT%
  ' ……………………………………………………………………………………………………………

  ' 使用しないフォントを ここから削除すると PRGの データが小さくなります。
  ' 逆に 使いたいフォントデータを ここに追加することも できます。
  ' KNJLIB_FONTS1〜5 から使いたいフォントデータをコピペで追加すれば
  ' GKNJFONT で切り替えられるようにできます。
  ' その際、 GKNJDEF x,"〜" を
  ' KNJLIB_FONTDAT$[x]="〜" に
  ' 置き換えると、ほんのわずかに処理が早いです。

  ' ……………………………………………………………………………………………………………

  ' 0〜2: k8x12
  IF FONT%==0 || FONT%==1 || FONT%==2 THEN
    GKNJDEFINIT 8,12
    KNJLIB_FONTDAT$[0]="   ф䑀Ѐપ  મꪮꨀъ萪䐀⒀ Ҫ䒪蘀ф  ⑄䑄䐠葄䑄䒀ю䨀  䓤䀀  䒀 à   ЀȤ䑄蠀Ҫ꺪ꐀӄ䑄一Ҫ⑈踀Ҫ␪ꐀȦ檮∀ຈ쨪ꐀҪ貪ꐀຢ⑄䐀Ҫ꒪ꐀҪꘪꐀ 䀀Ѐ 䀀䒀 ⒄  ฎ  萤耀Ҫ⑀ЀҪ詀Ҫꫪꨀಪ겪가Ҫ袊ꐀಪꪪ가ຈ貈踀ຈ貈蠀Ҫ說ꘀપ꺪ꨀไ䑄一Ȣ∪ꐀપ첪ꨀ࢈袈踀૮ꨀಪꪪꨀҪꪪꐀಪ겈蠀Ҫꪮꘀಪ겪ꨀҪ萪ꐀไ䑄䐀પꪪ글પꪪ䐀પ껮પ䑊ꨀપꑄ䐀ย䑈踀摄䑄䑠ࢄ䑄∀쑄䑄䓀Ҫ    à萀   쉪ꘀ࢈쪪가 䪈ꐀȢ檪ꘀ 䪮蘀ل䐀 檦⩀࢈쪪ꨀЀ䑄䐀Ȁ∢ꩀ࢈꫊ꨀౄ䑄䐀 컮ꨀ 쪪ꨀ 䪪ꐀ 쪪좀 檪戠 겈蠀 桂ⰀD䘀 ꪪ글 ꪪ䐀 ꪮ ꩄꨀ ꪦ⋀ 踀摄䡄䑠䑄䑄䑀쑄䉄䓀 ౠ  ꐀ蠀  Ȣ⋠  萀 Ѐ â⸢䠀 䠀 ≌䐀 亢␀ ไ一 ⹪☀ 书䐀 ౄ一 ⸀ 䠀 蘀 â晄䠀Ȣ䱄䐀Ӫꈢ䠀ä䑄ˢ晪☀Ӧ暪☀ю䓤䐀Ѧꈢ䠀ࢎ채䠀â∢મꪢ䠀ࡈ䀢䠀â⑄ꨀࢎꪨ踀દ戤䠀Ѫ꘢䠀˄乄䠀î䠀à䠀࢈쪈蠀ю䑄䠀à âꑄꨀю⑎䐀Ȣ∤䠀тꪪꨀ࢈蘀â∤䠀Dꪢ Ӥ仮䐀â⩄∀ఠ䈀숀ф䢊Ȫ䑊蠀ä乄䘀ю晄䐀Ä䑄â⸢⸀à䠀પꨢ␀ь쳌࢈袪저êꪪ글êꈢ䠀"+CHR$(34)+"䠀ઠ  Ҥ  䥂"
    KNJLIB_FONTDAT$[1]="          聀䀀   @ꂠ䀀    쁀耀    샀   ᠀   ᠀ ᠘  ᠀ ᠈က<䈂Ȍက တတက ꁐ     䂠ꁀ    ࠐ     ‐     ⠀     ဨ⡄    ︀          ︀ `ဈЄ  ਊ`ဈЄ   `᠄Ȍ　 ਊ`᠄Ȍ　  $␤䡈  ဨ⡄艼တတ︀ ‼⑄蠰ဈ Ȃд䡈钤ꃀ耀 㡄节艄㠀   聾     ÿ      ᠀  Јࠐ†䂀 䀠‐ࠈЂ   悒ఀ  ᐔᐨ⠨⠨偐倀တတတတတက       D   Ȅ؀    쁀耀    ሤ㘀    退    ȄЈࠈࠈЄȀ聀䀠††䁀耀ؘတတတဘ؀쀰တတတူ쀀จࠈࠈࠈࠈ฀††††؈ࠈࠐࠈࠈ؀쀠†‐††쀀ȄЈࠐࠈЄȀ聀䀠‐†䁀耀ਔᐨ⡐⠨ᐔ਀ꁐ倨⠔⠨偐ꀀḐတတတ   တတတ㸢⸨⠨⠨㠀  㠨⠨⠨ฌఈࠈࠈఌ฀怠††恠 တჾတက   þ   တ︐တþ  艄⠐⡄舀  ကþ က   ︀︀   Ј︐︠䀀  ؘ悀怘؀  쀰ంర쀀 㣀㠆þþ À㠆㣀þþ  沒銒銒氀  က  䐀 㸆ਊቲ袈袈瀀㡄䑄䐸တ簐က悐遠    䁀耀    偐ꀀ    䂠걒††ሌ 䑄⣾ჾတ 粒遼ኒ簐 ࡼ銐鉼† 8䑀⁠ꉜ B꒨䠐␪䪄 ᑾ⠨⣼偐 0䡈値咈豲  ႒吸咒က 8䒒ꪪꪬ遄㠀㡄䀰䡄␘ф㠀တხ䐨⡔汄 တჾ簸㡼汄 8䒂节节䐸 8糾﻾﻾簸 8䒒ꪪꪒ䐸 ဨ⡄䒂䑄⠨ကး㡼糾籼㠸ကþ节节节苾 þ﻾﻾﻾﻾ တ⠨⡄䑄苾 တ㠸㡼籼﻾ þ艄䑄⠨⠐ကþﹼ籼㠸㠐က艔䐨⢒⠨䑔舀þ ︐တတ  ဈӾЈက  ဠ䃾䀠က း吐တတတကတတတတ吸က ﻾ þ︀ >䂀胾肀䀾 øЂ˾ȂӸ >䂀聀㸀þ øЂȄþ >䂀肀肀䀾 øЂȂȂӸ 节节节䐸 8䒂节节节 တ⠨⡄䑄节 艄䑄⠨⠐က  þȂȀ  ဈﰂﰈက  ⡄粂籄⠀ 节艼䑄⠨⠐က縂ȂɾȂȂ縀Єࠐ†䃾 တတတჾ 㡄舀    㡄Є㑌蒈袐怀þ쉄䑤⠨㠐က ︀þ ︀ @ ︀︀  ሤ䢐䠤ሀ  遈␒⑈退 Ḑဠ†⃠䁀䀀 䲒銒銒搀  沒邐邒氀  䐀  က ࠔတတတၐ ᐪ⠨⠨⠨⢨倀ဨ⠐⠨䑼节 @꒨倠咪⨔ Ф☼搤☼搤 ††ⰲ∢␨　ဘᰖሒᐐ烰怀တ簐တတတကတ簐တတ簐က㱴瑴琴ᐔᐔ᐀㡄节节节艄㠀<䉆䩒扂䈼 瀐တတၼ <䉂Ȅᠠ䁾 <䈂ȜȂ䈼 ఔᐤ䑾Є ~䁀硄Ȃ䐸 ⁀屢䉂䈼 ~Ȅࠈတတ <䉂䈼䉂䈼 <䉂䉆㨂и ဨ⡄䑼节 |䉂䉼䉂䉼 ≀䁀䁀∜ x䑂䉂䉂䑸 ~䁀䁼䁀䁾 ~䁀䁼䁀䁀 ≀䁎䉂∜ B䉂䉾䉂䉂 8တတတး ȂȂɂ䈼 B䑈䡐桄䑂 @䁀䁀䁀䁾 苆욪ꪒ銂 B扢削䩆䙂 <䉂䉂䉂䈼 |䉂䉼䁀䁀 <䉂䉂䉚携 |䉂䉼䡄䑂 <䉀䀼Ȃ䈼 þတတတတ B䉂䉂䉂䈼 艄䑄⠨တ 銒ꪪꩄ䑄 䑄⠐⡄䒂 䑄⠐တတ ~Ȅࠐဠ䁾   㠄㱄䐼 @䁀塤䑄䑸   㡄䁀䐸 Є㑌䑄䐼   㡄籀䐸 တ㰐တတ   㱄䐼ф㠀@䁀塤䑄䑄  တတတ  ࠈࠈࡈ　@䁀䑈偰䡄 0တတတတ   銒銒   塤䑄䑄   㡄䑄䐸   硄䑄础䀀  㱄䑄㰄Ѐ  塤䁀䁀   㡄〈䐸  †砠†␘   䑄䑄䰴   䑄⠨⠐   銒ꪪ䑄   䐨တ⡄   䑄⠨တ怀  簄ࠐ⁼   砠㡬둤  簠⠼檪뉤   袄蒄ꁀ  袄节芢ꁀ  88䐄࠰ <<䈂Ȅ࠰  8xࠐ⡌ 8|ࠐ㠨䢎   㡤ꑨ  ‼抢ꉬ  ⃴⩊䩈ꢐ ਪ⃴⩊䩈ꢐ 簈︄㱀䀼 ਊ簈︄㱀䀼 ဠ䁀‐ࠈ ဪ䩀‐ࠈ 蒾蒄蒄蠐 ઊ蒾蒄蒄蠐  簀 䂀聾 ਊ簀 䂀聾 ︈м䑀“ ਊ︈м䑀“ @䁀䁀䁂䐸 ੊䁀䁀䁂䐸 ︈㡈䠸࠰ ਊ︈㡈䠸࠰ $⓾␤Ⱐ„ ਪ⓾␤Ⱐ„ |ဠ︐†“ ੺ဠ︐†“  乀䁈邎 ਪ乀䁈邎  ﰠ⁜戂и ਪﰠ⁜戂и   8쐄࠰  㳂ȂȄ㠀 ਊ㳂ȂȄ㠀  ︐††ဌ ਊ︐††ဌ  †ⰰ䂀聾 ਪ†ⰰ䂀聾  䑄鰤☘ 鲀肀邠ꂞ 䡜橊늖ꩆ  Ⳳ∢晪ꨦ  㡔銒ꊢ䐘 蒾蒄鲤Ꚙ ઊ蒾蒄鲤Ꚙ Ҋ誾蒄鲤Ꚙ è⑆䒄蒄䠰 ૪⑆䒄蒄䠰 Ӫ⩆䒄蒄䠰 0ࠐတ䱊訰 ਺ࠐတ䱊訰 кਔတ䱊訰  ⁐傈ࠄȀ ਊ⁐傈ࠄȀ Њ⩔傈ࠄȀ 뺄뺄蒜Ꚙ ઊ뺄뺄蒜Ꚙ Ҋ몄뺄蒜Ꚙ ︐︐ၸ鑢 pဤ㱤ꚤ쐘  悤ꑢ䈼 䡜橊ꪒꉌ ﰠ⃼•∜   選쑈† H峢∤†တ  룔钸ဠ 볊誊ꪜဠ  လၰ顤 သတ炘鑢 `ᡀ䂼슂и X摄䑄Є࠰ |ࠐ㡄舲䰸  ⳴␤摤ꐢ |ࠐ㡄舂и  @壤䑄쑘  Ⳳ∢扢ꈬ pလ㉒險ꩆ |း䐴堠沒 ﰠ皘⡈䀾 ဠ‰䡈誄   ﰄ⠠⁀  ︂ᐘတ⁀  ࠐバတ Јᠨ절ࠈ   ⃼萄࠰ ჾ节Є࠰   xတჼ  簐တတ︀   ࣼᠨ젘 ࣾ࠘⡈蠘 ჾሒ∢䪄 ਊჾሒ∢䪄 ၼတ︈ࠈ ਊၼတ︈ࠈ  ‾䊂Єᡠ ਪ‾䊂Єᡠ @䁾䢈ࠈဠ ੊䁾䢈ࠈဠ  縂ȂȂɾ ਊ縂ȂȂɾ $⓾␤␄࠰ ਪ⓾␤␄࠰ `က숢Єᡠ ੪က숢Єᡠ  簄ࠈဨ䒂 ਊ簄ࠈဨ䒂  ⃾∤⠠„ ਪ⃾∤⠠„  艂䈄Јဠ ਊ聂䈄Јဠ  ‾䊲ఄᡠ ਪ‾䊲ఄᡠ 瀐ჾတဠ ਊ瀐ჾတဠ   ꑔ各࠰  ꉒ剒Є࠰ ਊꁒ剒Є࠰ | ︐တဠ ੺ ︐တဠ  †〨␠† ਪ†〨␠† ჾတတ⁀  簀  ︀  簄␘ࠔ⋀ 簄ࠐ㓒တ ࠈࠐဠ䂀  ⠤␤䑂䊂 ਊ⠤␤䑂䊂 Њ⨤␤䑂䊂 @䁀䱰䁀䀾 ੊䁀䱰䁀䀾 ъ䩄䱰䁀䀾  ︂ȄЈၠ ਊ︂ȄЈၠ Њ暴Єࠈၠ  ⁐傈ЄȀ ਊ⁐傈ЄȀ Њ⩔傈ЄȀ ჾၔ劒ူ ਊჾၔ劒ူ К᫾ၔ劒ူ  ︂ш【ࠈ 0ఀ「 砆 တ†⁄䳲 Ѥ᠈ࠔⓀ  簠⃾†„   㳤⠠တ  㻢␨‐တ   pတჼ  砈ࠈࠈ︀   簄㰄Ѽ  縂ȾȂɾ | ︂Ȅ࠰ D䑄䑄Јဠ ⠨⠨⩊䲈 @䁀䁄䑈偠  繂䉂䉂䉾   繂Ȅࠐ  ﺂ舄Јဠ ࣾ䡈䣾ࠈ  簄ࠐတ︀  ︂ɼЈၠ  쀠ȂЈダ ਪ⃾节Є࠰   ⃼␤䒌  @䁼逐ဠ ဨ⡄䑼节 |䉂䉼䉂䉼 ~䁀䁀䁀䁀 ဨ⡄䑄苾 ~䁀䁼䁀䁾 ~Ȅࠐဠ䁾 B䉂䉾䉂䉂 <䉂䉚䉂䈼 8တတတး B䑈䡐桄䑂 ဨ⡄䑄节 苆욪ꪒ銂 B扢削䩆䙂 ~ < ~ <䉂䉂䉂䈼 ~䉂䉂䉂䉂 |䉂䉼䁀䁀 ~䀠ဈဠ䁾 þတတတတ 䑄⠐တတ 粒銒銒簐 䑄⠐⡄䒂 呔吸တတ 8䒂节艄⣮   ᨦ䑄䠶 ሒⰢ∢局䀀  ㉌ࠈࠐက∐ᠤ䑄䠰   ᰢᠠ䈼 ,ᠠ⁀䁀㠄᠀  ⱒሢ␤Ѐ∢䉾䉄䐸   တဠ⠐   ∤⠸䡆 0ࠈࠔᐤ≂   ␤␤婀耀  䈢␤⠰ ,ဠᠠ䁀㠄᠀  ᰢ䉂䐸   㹔ᐤ⑆   ᰢ∢局䀀  Ḥ䑄䠰   㹈ࠐᐈ   ㉒ሢ␘ ࠈ粒銒簠   搘တぐ谀ࠈ劒銒簠   ⑂銒鉬 ဨ⡄䑼节 |䁀䁼䉂䉼 |䉂䉼䉂䉼 ~䁀䁀䁀䁀 <␤␤⑄䓾舀~䁀䁼䁀䁾 ␀繀䁼䁀䁾 呔吸呔咒 <䈂ИЂ䈼 B䙆䩒剢扂 ␘䉆䩊剢扂 F䡈偰䡄䑂 >∢∢∢⋂ D䑄ꪪꪒ銂 B䉂䉾䉂䉂 <䉂䉂䉂䈼 ~䉂䉂䉂䉂 |䉂䉼䁀䁀 ≀䁀䁀∜ þတတတတ B∤ᐈࠐၠ 粒銒銒簐 䑄⠐⡄䒂 D䑄䑄䑄䑾ȀB䉂䉆㨂Ȃ 銒銒銒鋾 銒銒銒鋾ȀÀ䁀硄䉂䑸 节誊鋢 @䁀硄䉂䑸 8䐂ȾȂ䐸 ꊢꋢꊢꊜ >䉂䈾ሢ≂   㠄㱄䐼 ぀塤䑄䐸   硄硄䑸   籀䁀䁀   㰤␤⑾䈀  㡄籀䐸  ⠀㡄籀䐸   鉔㡔咒   㡄᠄䐸   䑌呔摄  ⠐䑌呔摄   䱐偰䡄   㰤␤Ⓞ   䑬汔呄   䑄籄䑄   㡄䑄䐸   籄䑄䑄   硄䑄础䀀  㡄䁀䐸   簐တတ   䑄⠨တ怀 တ粒銒簐က  䐨တ⡄   䑄䑄䑾Ȁ  䑄䐼Є   銒銒鋾   銒銒鋾Ȁ  怠㰢∼   䉂牊䩲   䁀硄䑸   㡄ᰄ䐸   䱒牒剌   㱄䐼⑄   ÿ   တတတတတတ  တတတ  ðတတတတတჰ   တတဟ   တတဟတတတ  ÿတတတတတჰတတတတတჿ   တတჿတတတ  ÿ＀  ᠘᠘᠘᠘᠘᠘  Ἐ᠘᠘  ø᠘᠘᠘᠘᣸  ᠘᠘᠟ἀ  ᠘᠘᠟Ἐ᠘᠘  ÿ８᠘᠘᠘᠘᣸᠘᠘᠘᠘᣿＀  ᠘᠘᣿８᠘᠘᠘᠘᠟᠘᠘᠘  ÿ０တတ᠘᠘᣸᠘᠘᠘တတჿ＀  တတჿ０တတတတဟἐတတ  ÿ᠘᠘᠘တတჰတတ᠘᠘᣿   ᠘᠘᣿᠘᠘᠘㡄銲銒銒鉄㠀㡄銪誒銢멄㠀㡄銪誒說鉄㠀㡄誚ꪪ몊詄㠀㡄몢늪說鉄㠀㡄銪ꊲꪪ鉄㠀㡄몪誒銒鉄㠀㡄銪ꪒꪪ鉄㠀㡄銪ꪚ說鉄㠀㡄芮ꪮ艄㠀㡄芦ꚦ艄㠀㡄芮ꪮ艄㠀㡄芮ꚮ艄㠀㡄芪꺦艄㠀㡄芮ꚮ艄㠀㡄芪꺮艄㠀㡄芮ꪪ艄㠀㡄芮꺮艄㠀㡄芮ꚮ艄㠀㡄苮ꫪ쫮艄㠀တတတတ (⠨⠨⠨⠨ T呔呔呔呔 ¢ꊢ钔钔袈 D䑄⠨⠨တ 誊剒剒∢ ªꪪꪪꪪ䩊 ªꪪꪪꪪ橪 ¢ꊔ针钔ꊢ D䐨⠐⠨䑄 怀ሒሂఀ䃰䃰 ḒሒḀ裤ꂂ耀₠亠耀蒌阀噰阒搀䁀䂐肀耀ဈȄ᠀湀耀₠ꂠ뀀䑆ꪢⰀ撬籌阀ꂠ긢䰀蒌阀⸢䰀肀耀仪檪글ꂠ긠䀀낀耀Дᐔᘀ裤ꂂ肀耀倨낦ꀀ铤Ꚍ퐀樂搬벬글偨낦 퀀퀠쀀  쳮ꪪ   䲮躎ꩊ 肀겮컎ꪪ   웪ꊪЀ肀ꚪ쫆ꊪЀ  䒪袈ꩄ ؂؄효ꢨꢨ 䓮䳮䱌刀ᐔਊ        ꁐ倀郐풺몚骔 ªꪪ쳌ꪪꪪ à䁀瑤瑤摶 㡄銒骒鋾艄㠀㡄鋾훖ﺒ鉄㠀㡄苾銚銒鉄㠀㡄ꋺꊺ튒멄㠀㡄ꋺꊺ멄㠀䒂닾꫾ꪂ䐀䒂ꋺꊺꪂ䐀䒂꺪뻪ꪪꚂ䐀橢桮溮글乄䓤䑎䱌견글汤蹮汤搀@ ︀︀  ︀þ ︀ ࠔတတတၐ ࠔး呔吸ၐ 繀‐ࠄࠐ⁀縀Ḑဠ†⃠䁀䀀တတတჾ Єࠐ†䃾 肀肀肀胾 ؊਒∢䋾  䐀  က 8䒂节节节 节节节䐸 "
    KNJLIB_FONTDAT$[2]="︨⣾ꪪ꫾⠨︀㻔뒾뚶뛾ᐔ㸀␮⓴幔搮⑤鸀훖훞节蘀ჾ|䑼⡪ꐴ戀﹔ﺂ哊㡨ဨ였䡒﹐屨졾䡔␪⃾偐渪⩚踀豔࠶ࣜ䡾䡀븀⣾⡴ꩄ먐︨였⣾⣾⣾ꪮ슂︀Ⳕ繪﹈绪﹈一︨ﺪ︨︀哊먀幒幘幤鹒Ẑ帘Ṕ庤鸀乊署幚婚庐鸀⣾⣾⓾䑾僾က⣾⡼|䑼䁀耀撪㻤뻪듢ಢ가䡾푔终죾䡈䠀繀䡈䡜䡈䡈븀䓪僪꛲ꫢ廢䈀屔噲呤ჾ艀繚驪⡊踀⸪⫾婚渪⩪鸀䑄ﺨꢨ䡨츀䒤࣪뻠껪說偞ꋞ嚞홖䘀䡜裾咦졔戀梨⣮꣨뻲ኲ븀ਈ︈꫄㓊ሀ︨ﺪ︐哾㡔鈀䡔䁀ﹲ剒帀ჾ舐︤䑨ᠤ숀ࡾ䡾呪繪繈踀䡾織푘䡔Ӿꪪﺠ꺪฀ჾ鉼⡴ჾ㡔鈀ﺪﺪ먀ꣾꋨ绔푘졔戀ჾး咒籄䑄簀䑄呌䑄摈蠔戀㸪䩞쩊幈䡈倀⠨繄푔呔䡈縀⠨繈瑔呚爀␾䩾퉞䑞呾䐀ﺂ꫾ꪪﺪ쪂︀ჾၼᑼ僾ረ였簐︸혐︤栘ਈ繈硚穬瑔ꨀﺂ㊢昀呔呞呔帀ၼ⣾䑼䑼僊먀ﺂ뉦僊먀籄籄簠纪䪒☀䡾졔拾싺橺䘀倐㱄纂⪪蘀籔籔簀﹔䡤숀籔籔簨簨﹄舀⣎削勪쑈瀀呔黔庴푞帀䑞諾办쑞푾䐀ﺒﺒ﹄籄籄䰀⣾ჾ㡔︤栘တ︐⠪沨␴戀︪︪︔퐀葞ਾዞ呾䑀븀蠾⨾ᓜ呜所븀ﺐ鲨袾袔ꊀ︀䑄﹄䑄﹄䑄萀ჾၤ⠐⑈ᠤ숀䩈终穪橼쐴਀ჾဤ﹄籄籄䰀☦盖癖瑔吀婬纄織噴⨀  Ӿ   ჾၼþ艌灂㸀鐈㺔ᐢᱜ岜븀豔о⫾呔晀븀⛘橪쁮櫮渀⣾⠐鸪ࡈ钔∀⣾⠀簐ჾတ　盤㚒똀တ⁄﨨⠨䩊踀⃞銒銖က㻢ꪾꪪ꫶∢㸀籄ﺂﺂﺂ﹄舀ﺂ鋾銒ꪪ욂︀繢櫾檪ꩶ抢븀ቲ䊂ሒ戀䢮૶ꓤꓤ蒪蘸⪪иࢾ袈븀呤呬籄籬籬글⣾⣔ﺔ먀죾샾퓔钔ꘀ죔ﺀﻀ뺔먀웸钲글仪꺠Ӥ뺤꒴곤Єఀတ︠‼撤␤㰀ჾ艼တ︐တ　ၼ䑼䁾䁾ʪ蘀ꩦ∢暪∢昀鱈࠾ࣈ䡈塀븀︐ჾ鋚뛚뚒阀⃎ꪪꪪꫪ꠨䠀吮郞类抪☀ჾꩌ廲廲幬阀簔ᐔᓾ␤␤︀ᓴ幔应瑞呴Ḁဠ캂苮节节︀鱔Ეᐾ⊾뚾ꈀ࣮ꢾꢮꃴ㙔㸀㻢뺢뺢ꋾ∀䓮哾꫾⣾⣲黲諶⊲昀溪⻪뻶뻪Ҫ눀␤⻴幘樬⡚踀繀織瑔繄汌阀訾ࢾ⨾⪾ꪪꨀ౰呔呔呔呜눀몒몒먀ᓾ뒾뚢뻤㸔ఀ簀þတ†䡄切븪ᰈ᳜䡾䡀븀簐ﺒ뙼þဤ切⣾⠤塈﹈䡈尀庪໪ꫮꫪ麢⸲⋺詔ꑔ署爀合ﺂ㠨㠐籄簀ꨐ︤栘牒瑐禍琠ꨢ搀ࣾꪪꢨ∀ჼ铼钔ﰔࠚ合ﺒၼး咒က〈〔㡔咒　顀ᢊ稜ᱜ檪頀蠾⪾⨾ࡊ䒌눀푾呈﹪橾젔∀ﰤ㸪劮|呔︀黨黲㻒廲廠刀黨黲ỲỲ廠刀⣾⠐籔哾ဨ였噸頾橺퉺牺嘀靖咨㻢拾哔푔衾ᒖ⨦檤꒪눀ࡾ䃜呦䡔ꈀ䐈︨䒂籔呔︀쪊캌ꪪ刀呈ﻢ呔呔昀틚였䫨幔哴븀몪뫎舀繈峔呈瘀繀瑖瑎瑔瓚娀ﺒ銒鋾节节蘀ﺒ몒ﺺ꺺횒︀幐廾呞婴Ḁჾ⡔﹔籔簒Ḁჾ艼䑼ჾ␸였쉜䒄화哔幀븀䁾嫚⠪츐䓊먀䡾푪繪﹪繈츀䙸䡾큞牌鑔ᒔ∀᱔咔鰀蠾⊜࠾⪾ꪜꈀၔ堨옐员ဨ였䡎勄橮檪글幌延䑎撤鸀⣾⡄﹬泼䘀ꨀꢼ䡾峚瑔騀屄鳄纈홬푦堀固틾᫺黸婚⣾⡀繚驪⡊踀⣾⣾鋾ꪺ횒︀衜࠾Ü噜橀븀䪪૪勠仪쩪츀䁾칼籀縂ꨀ偞惜呜䁜㸀␪懲䑲剐呒눀鱈ࢾ倐Ṃ䊂蘀廖ﻖ廨幊櫊ᘀꪪꪺ节节︀ၼ呔哾ဨ⡄舀ၼ䑬呼哾ဨ였偈븈䡈䡈縀ࡾ偈偔牲偔鰀繪橪䡈저Ụ꒤꒤Ḁ呾푾䣾䁔戀꒤퓔諪ሀ꺪蓪ሀ簐တၼတတ︀⡄ꩴî⊪暪昀䡾橾䡔戀合ﺒ籄繀縂ꨀꪮ苪ᘀ⡼⣾ၼ呼呼舀ﺂꪒﺒ훖ﺂ蘀衈㺪横㹈䢈蠀⣾⢤噔ꑤꐪ툀⠾呾퉞剞呲渀繂繀織穈屈븀䡾퓾퉞剞呲渀듾늾꒲글幄졾櫾橪樀⒤ꐤ㓤␤⸀簄ࠐဠ䁀节縀⠾呪﹪繪繈一乺ꨪ飯몪ꢸ저籔籔汄簀哊먀鹒Ẓ帀Ṗ嚖븀⛘橄廀푲渀ၼ⠨︀籄籄簀︐တ᠔တတက〰偒푘偐剒帀㸰偞퉚婔摊刀㸢幖홖噞䉂䘀偞穚婪橎堀㸴呾홖噖噖縀⠼䡈﹈䡜䡈縀䁎署婚婚媞뀀︄瑔呔呴Єఀჾჾ䑼⣾婚븀︐籄籄簤栐䡞勬ꢶ챔沖谀ჾ艼⃒ⳘⳊ　ჾ먐籄﹄먨堀ⓔ䱄䓆ﱄ䐀㛲늶ꊪ⨀籔籔簐︸咒က䃾婚븐︸咒က爀븂㪪⨪⪺节蘀တ剔墐ဨ⡄舀﹂幖噾숂؀乊䩞噞刀౰တ︐㠸咒ကⓞ剌졖䳔䰀䡮됀ﺒ몒몪︀⣾⠨䡊챈䡊一⣾⠀︄瑔呴ఀ⣾⡀﹚婚媞뀀⣾⠾䉞홖幂䘀⣾⣾哾哾ჾက⣾⡼呼哾㡔鈀癲ꂶ瑤︪︪︈︈저ᓾ뒾겾곾࠾ࠀ⡊챊繄籄籄舀逖㨚᫚橎塀븀鱔ᰔ㻢穪穀븀簐ﺒ뛮ꋮ諤言䡈ﺴ뒴呔ⰶ呾푔屶呜爀䱶呾퓔퐜㈀ᡪ⣾⠨㫪␤樀籈䡈䣾ᠨ䢈᠀︐鋾훾훖ﺂ︀ꓴ钔꫺਀⣾⡼⠨︘⣈᠀䱶퓾퓔呜䃾媾䑼䑼䑼舀꺼껬Ɱ갬渀䲶ᓾ듴볶钼䃾婾큼偾ʪ蘀ဨ⡄ꨨ⠨⡈蠀ဨ䒺þဠ⡄切溦⫰듼뻴麔됀ﺂ芺ꪪꪺ节︀䡾櫾橾塜一䡾䣾百䡾ᨀ庖홖廒幀븀䡞쫊쩾䡈呔戀屄퓈푪䡜䡈縀偞橪繂䰀幐퓔呔呪䨀䡾죾䡾婴娀ਈ︈塚穀呄言幒퉞䁞쩊䩒혀⸺誤ꓪሀ哬ꓴ곤晼摠븀ჾꂾꪪ︂ఀ䩈﹄哼훔摊刀逞₞⩾⪪뺂谀繀䡪汨䡈呔ꈀ籔籔簨䒪⠨䠀䡪䱪츐籄籄簀䡔ꋜ䂾졈큔稀⣾⠐⡄ꨨ⡈蠀溦橤溤籔簔切ﺪﺪ쨀ꓤ뚨뺲鸀籄籄籄䑼D舀껺ૺૺ髺婚⣸⻊娪䪚⩒阀䡈硘岺ᨨ⡈蠀Ӿ꒸ꪤꣲЊሀჾ鉼ၼჾ籄簀鋾~屈繈屈븀乼摬籌嘀乼泾籌嘀븤⺤㸤⒮꓄鸀Ỳ幒庀繢繪؀⣾⠐︤切籔︀噸逖穒禍婲䘀젾젰퐈툤죔媾î䃾勾챬瑞瑘杖硒瑚刀븪㺪⨾࡜䢈븀⻺恮萺ჾ咺㠀䑎뺤䑤幀廲剞割㸀䡾졈绪橈䠀幐뒴䩪혀䢮ዪ䫪勶였⋺⫲着着拓ᓾ퓔ﻪ⨪嘀‼䒨ဨ䓾䑄簀ࡾ䁖繬繖織됀䑞큔呔푨䩒橄﹢屔屔停푨䣔呔尀䡾조哈틤䡔戀⻺⩰໺詴呚言钾呞哞呈똀ࣾ䩔应織年Ḁ㓾呞哞푈瘀合ﺂ籄籄簪츀㰤䣾剾剾䉂蘀⑾␤﹚嫚婚똀䣾哔퓈䣔戀⻺穜稊稚ﰨ栀ꪒﺪ먀ﺠ볔베뺶ꨀ⣾⠐籔簐︐က合ﺂ簈ჾတ　౰䁼䡈︐銒︀Ⴚ永沺ჾ㡔鈀仴鹪깊긊뺴븊渊﹊渠樀呼푔籖ﱔ屴쐀䡮됐ჾ␤⠈︀癢瓪屈縀繜䃾局縀幒囜훜噬䘀撴⓮볬ꓴ㒪ꨀ阢㚢㸐㺂ꪪ蘀⋺ꩺ⩺⋺牒瘀Ỳ뺲뺨껺ሚ؀䡔쁀幒剒帀䉜쑄幄쑞剒艜҄帄ў劒鸀鹒Ẓ师Ṻ劚蘀鱔Ე㸢᱔岔鐀⣾䑼䑼㹢쩺؀幒︲幈剚䘀䣾櫜죜죾峔尀籄䑼䑄籄䑄︀皢㋴듪단ᲈ븀Ӥ꒤뺤ꓤЄЀ呾푀哔呔嘀呾푾峾䡾䠀꣮ꫲ嫪節帀䡘䣾죈屪䠀嚺ꪺꪺ온⡊踀ჾꩌ﹔ﺒ︐Ḁ⣾⢊㺈㸪뺪ꨀ⡄ꨐ⡼鉼ၔ︀咾ᓾ图图푶퐀࣮ꢾꂶ꫾㸪㸀꫾ꪮꣾ∪☀幈勒剒帀⣾⡼⠐︲傐　⣾⠐ﺂ籄簀︀홺狖범牒혀ሒ驚⨪≒剂蘀⣾⠒驚⨢剂蘀︠‼␴呄䑴였䣮僮ꋤ꣨勲一㸲剞쁚婚婚樀ﺂ搄Ụ瑤沠븀ჾꩼ⣾䒲ࡰఀ爪⨪飯⨢∢☀哴并噶囶䡸껺⩺橪瘀吐簨﹄먈硂縀೴꒾ꪶꋾࠔ∀呾哜呜呾㸀ჾ␸䓾ꪪ챦ꨀჾ艼þ⠨⩊踀ჾ艼䑼䁾䉂縀ჾꩼ⡼籄簪츀簐တ︐တတက䓪僮ꓤ뻤䓤䐀ၼ呼ﺒ︐䓊먀੾䡺呔窀哊먀屪ﻪ屔局戀䑾穀呲渀䱔쑾橶䡔琤穚穔瓚ሀ剒﹒勞틒剒帀幀勞틒幀帀䡾哜탞剒帀⣾⩶ѴӴ⪺樀䑶꫶⑴橪爀鱈࢈縈ࡈ䢈蠀鐾ᒾ⨾ࢾ袔ꈀ똶㚶∾㚾뚾ꈀ逞⢾ᐞ㒞钔鸀﹪繀﹔届ࠀ䑄﹄䑼䑄䑄簀籔︀簐簐︠粤㰤㰀䡮됀簐ჾတက䡮됐ﺪ먠㰤㰀䡮듮ꫮ몪몪먀䙘꫾䢾큞爀䁼傐ჾၔ呔簀䓪䃾꫾ꫮ嫪䨀ꓤ뺤꒤ꐀ䓼뛸뚸견븀⣾⣾艼þ⠪츀乺껺⹺摬瘀젾젾죜籔﹔籄籄籄舀븪㸀㻜噜橀븀䒼ᛸ囸䃬챬ꪺꪺ蘀ﺒ뫖鈀ꪒ몒ꨀ닄꺪ꪮ글䓾䫾닾꓾哾䐀䒾ዮꫮ꣮說䒾ዮ䫮䣮ꪪ†⡨㠨䡊踀ဨ粂簈ၼ䑄簀鋾~䁜䡾䡈蠀鋾呾䁶婺瑴騀䁾푔呔퐔☀ࡾ䃜呾䁪븀Ỳ뻲늾듲ᨀ႒︀︠⁾ꈢ㸀﹔織湬湜呜呜ꈀ繀呔湬湬湬글໺湪湪뺀਀⻴幚ﺪ캪쨀ﻚﻚﺪ⺰樀ဨ䒒ၜ偐偐︀⠨繈呈䡔戀㰤䣾䁜呔偒鸀ჾၼ䑼⣾籄簀︨였⣾⠸⣾䒒簐︀ჾဨ䓾Ѵ呴ఀ䡞䣾늾푞纒鸀ჾ鉼⡄ﹴ呴ఀ䡈繈퓈젔∀搘搐︨绊䩎ࠀ咘咺︔﹈䩬鈀簄籀䑼T䋊먀繢졾䡾䡾저屔푔哔퓔呔昀䡎幪꺪븠樀ﺪ꫾蒬곬ᘀ建婾婺建੒阀呾표哜퓾䁔戀ჾ䓺哾哾㡔鈀婬组ﻔ噔樀屄ﻪ䡾檪蠀⻺婐︺檴咚樀䁼聼üᑔ⑔舀逞ₜ<ф䒄舀咘咺︔︈䉌乊䩒䈀౰ჾ㡔먈︐　㋌剈﹔擞홖䐀幂苂庐큐帀呔븊穚籔䨀幒﹒廲幌겔☀숂퀐틒ၼ哾䑼䑼䑼舀⹲∢︨桺湠鸀䣨峬哴嘀㺢꠾橾桾蠀岴ᓴ듴듴钔좔슞ꪺ昀ၼ呼呼⨬⹈踀㡈ﱔ籔ﺒ︐Ḁ呈籔繂橪䘀呾䡾졾呾噼刀␤⻴幒樤⑪鈀ჾ艼䑼䑼䑄︀␶⓾꒴虔푚䡈﹈屄푈䡔晲智푾呔哶婶呴哴੊鈀哾죾졾哾噼刀躢쪤哶呔글䉜呞呒娀䓾ၼჾ株︤樀呾죾죾푾噼툀젾퐜퐜퓔︀퐾젾젾퐾훼툀偞湊﹚湊였⣾⡀纒嫾㉚阀꣮닪廪﹊﹊䘀တ︐ၼ|䑄簀࣮낮ꊤ꣨ሒ฀᛾훾훺죾ࠔ∀䑄﹄䓞샞剒帀屄﹚棾橺昀쐄︄쐞쀞틒ࣨ䡎䢈繒割Ḁ停䣾죈䡈䠀簐︸혨화㣖　⸪飯⫺⩊壸ࠀჾꈸ栐⣆籄簀뻮꺾뒼ꐀࠎࡾ䡎幐幐鸀鐾ࠪ⫾䡈偀븀౰䁀籈䡈䡈︀‼⑄䢈တ⡄舀⠨籔푔呔呔昀⠨繈屪橈䠀⠮∲呔䢔戀㳔퓔훒␪刀ჾ艼䑼ჾ节︀簄Ѽ䂀︂Ȃఀ㡈ﰄ簄簀哊먀㐤몪⩤됪樀幈廒싂䉂䰀ᐐ︐员း咒　뱔ᒔ嘒ᩚ咤騀衈㺄吔ᑔ䢈븀‼䐘员ဨ였쩈繈䡜᠀ჾꨨ䰠⩊踀ჾꩌ♲囼㛒㘀䡮됀⸢呈똀屄铔嚒푤娀䑔铔咔푖ﱄ䐀䡔ꋜ䂀帀뺢ꊢꊾꊢꊢ븀ၐ籐逐︐တကတ簐ჾဠ⡄切繂繈繈䡾扢븀ﺀ胼蒄ﲀ肀︀幐割偐偖橪偨였合﹄먐簐︐　鹐鸒庐Ỿ㡔鈀ࠎࡾ剜䁔癔븀ﺰ냾剒ﻐ탰庲Ỵ廴哾츀鰔Ⓘ⨾⪾肔ꨀ暾图噼þ咒　㠨䣼呼呼Tꨀჾ䑼|ࠐတ　ჾ籄簀簈︐　ჾ|䑼ၔ劒　呔織푔繀呔戀⠾䡪繈䡔戀㰨織呾百戀䑬呔汄簨⩊踀⓾婚﹚婾⑬똀⠨簨⠨︀⡄舀芊쪪銒ꪪ슂︀䡞䫪噀呾噖樀ﺀ뺈袜袈뺀︀䙾꺾꺾㱄萀˪ꪪꪪꫮᨂȀ簐﹄먨ﺺꪺ蘀䡾哾剞剾퐔☀䡾䡪ﻈ젔∀졒终뺪䡊︀﹜峜肾局︀䡈졾䡈偔稀ﱔ屔瓖T䋊먀⣾⠨﹄ꈠꨪ怀䡾졪橈﹈䡔⑴⛺⩊먔樀屈﹔拜퓾百戀빢⊢縔ᑔ咔ꘀ꺤䑄ꐮ撤␤ꢾ䡪终䡔ꈀ鲈﹔拜呾皾ꈀ닦뚪뺢ꘀ⁼⓾媶籄籄䰀䚺꫾D舀⣾ჾ粪㣾ꪺ蘀䙾꺼溾ꛮ㱄萀䢾ᓾ勾勾푔皶暴簨﹄籄簀皶됨粪㠨瘀固璺繐籐縂ꨀ偞橪橺案䠀⚲戴☺呾钔⨀ၼ၄﹄þ⠪츀ࣼꢴﺴꂾ☀ꨨ︨︐簐﹔鈀繂繀繂穪橺蘀⠨ﺪꪪﺪꪪ︀繐櫪䩘縀簐တၼနሐ︀幒廖훖幒嘀⊬ꐤ︤摴ꐤ␀呾呾繈屈縀哼哾ꪪ飯稪偞勢婂䙪툂ఀတﺒ銒銒阐က䢼ᓜ哜䣾저౰䁀繈䡈䡈蠀ᑦ䩆瑔呔婚鈀䢮૶䓤䓤쩪툀㣆簈က⓾沶⑼þ咒　ဨ糖汼ჾ꫶舀䡮됀똀쓪ဤ﹔鈀⣾⠌灀繈䡈蠀⣾⣾몒ﺺ횒︀䡔䁀﹢䑄䠀䩞䩞䑖䰀퐾퐾︈︀葘သᓔ呤䑀븀ဨ䒺ၼၔ吐︀ࣴꊬꂠ뻢Єࠀ庲Ỳ勾哶푲†⠨⡈䩊踀㰴屔局繀戀䁾艺䩊䩺Ȃఀﺄ蒴袈钤삀︀ꢮ剺ꨪ檺∢찀큜呔䡔퐢䈀么碮⫺⸨塈踀⣾⠐︐ၼ䑄簀⹸婺屼嫺㡘븀쪊첌ꢨ渀쒘킐뒴縀튎쪊ꊢ昀籄籄籄簀﹄舀籔籔ﺚ뚂哊먀ࠎࡾ䩮籄織ꈀࣴꪼ뒼듼ᨔ㨀ჾꨨ䰀簐တ︀㸪繪﹈繪湺昀ჾ艼呼哾銪똀븪㸈㻪湺晀븀ﺪ뻪뺨뺪ꘀჾ鋾ჾ銒︐က摶퉀盖噴䐀劲᫺嫺嫺퉢숀繂繄噄幒幒阀繂繈橪繈橪븀繢﹤癶﹤噖ჾꩌ繂繜䢪븀ჲ㱔鉼䑼䑄簀곬듴围嘀媄媄嫾娀籄簀ჾꩈ鰈븈ᲈ븀䒖똀ꨀﺪ뻪뺠뺨눀‼䐘哾㡔鈀︨ﺪ︐︸咒က屔鳾檾졾䠀砨ხꩄ꫾㡔鈀咴ᓾ峴哴푺琤ﹶ癶⫶Tꨀ簔ᓾᑼ‾抢㸀⣾⡼ჾ呼︀ꨀ툒틒穀廴哾䑴琀ﺒ簐籼呼ჾက囼囶䙶푔琀⡸⠨ﰪ稨㣈ࠀ䃾婚븐︨檤㈀乊䩊䱈䠀☸员졔穈橪䠀⸤湺湺乀刀婚署剒剒阀籄䑄簨⠨⩊踀穚瑄詼䑄簀ၼတ︐ၼတ︀졜䡈﹈䡜절㸀嫺剒蘐簐︀廪䫪䫶ჾဨ였禍呐禍呐剒鐀屄鐈呪졜䡈縀ჾ籔籔簀哊먀ࡾ呼呾橜瑈똀䓮䓾ѼѼ僊먀Ⓨ䫮䪪哊먀幒幈剚였呞呞쁼噒哴噊窚穔呺ᨀ籄籄﹄簐咒　䡜졈终죜䡈縀蘸⪪ࠜࢾ袔ꈀӮﻤḀ⫞䡚廒帀౰⁨ဤ塚咒က屄铈咪졜졈縀呞鳔应帀⻺恮ဤ﹔鈀ﺪ︨砨ﰪ核저⣾⡼␸옐簐︀⣾⣲婚禍剒阀合ﺒ籔呼န切︄퀒哶窌櫾||簀峄哈퓪죜䣈縀︔帪庪⹺⸰쨀㓎娮種≒蘀⣾⠀簀︐⁄切遞⨪⫪橸案븀撾⃮ꫮꓶᚤ가∺⋺ꪺ꫒뉚똀䫨仸ꫪꫤ䓪刀⻺恮簐︐　鐼⺺⨚㪜鲪騀꓎ꪮꪮ쒖谀噐勒剒嘀␾汖繈屪䠀䁾剔逐ဨ⡄舀衞ઊਾࡈ咔ꈀ阾ᚺᘨኾ袪蠀ჾ节⠨⡄䑄舀䑄뻄䒞쁞퉒帀ဠ籔呔呔呔︀젞쨊쨾절퓔㸢∾∢㸢䉂蘀␴幔쑄幄䑄䐀⠴繈﹪橾䡔戀⠪䡾푢屄屒帀㑞噮呾呐渀䓾⡼⳾ⱼ⡬ꨀ吐簨﹄粪⠨堀≒飯着꫺≒蘀Ӿ뚠꺪껪฀Ḁﺒ횪ﺪ횢몂︀ﺢ杖塚簐︀呾哾难홾咶鐀졞䪾졜䣾䡀븀ჾ鉼ჾ꫾哊먀湤ꐀ哊먀吐簨﹄먐︐　䡪졾呢屒䡔﹈绪䡔戀偞哞呔帀ჾ値ﺒ⑼僾ကနჾတဨ⡄舀⓶⓾铔듴꫺ꨀỪ䩊床橪橪ሀỲ幒庒繬汬ᘀ幒黀庒嘀㲤벤벤︐咒က︀繂繀幒幒阀籄籄籄簨⡊踀퐾퐾혾혾퓶퐀䑼䑼䑼舀令䓤ﻤ䓤䐀蠾⨾᳔幒幀븀媮૶嫮䫾쩨혀뻈뺪ꪾ좔ꈀﺔﺚ﹪滺湰쨀좔ﻈﻪꢴ戀䑪仴풔切簀þ⠨⠨䩊踀繈屔屔屈橈頀刄繀癚穴瑴騀‮⋂刢≂鋲ఀ졈终邴졐偤切詈㺤簤㹬沺言븤⺪⸪⺤뛄谀တ︐⁤᠐⁄切﹒幒﹒幬찔☀䑄黄䢚쑄帀䓤뻤ꢺꢲ븀簀︀簀簀籄簀젾퐔︤틞퓖钒騀౰ၔ吐︐တ　㸢橾癶繢縀တჾတ籄䑄簀۸ꢺꪨ뻨ࠈ᠀ﺂ鋾銺ꪪ몂︀␤⓾呔渪⩚踀偔呴푔呚ﰄЄﲀ肀节縀ࡾ䡾䡾橾䡾蠀쉜僔钔푔呚︀籄䑄籀䁀耀䡈䫪ꪤꓪሀ䑄쑾䓄剒帀긪窮⩺廚阀ꊼ偔푔哔呚ꈀ囖﹖홾䨀䑞乀﹨乂䘀ꫠ꺢꒪눀乊䫪꺪ꫪᘀ⣾⣢㱔瓔呚ࠎࡾ剜䁔呔ꘀ젾퐢︐였꫰乀ﻈ컢였䒤Ӿ䓤仪쩪츀︀繂織年幔鸀滊⓴⻴໲髴呚簐တၼ␤␤︀︠‼⑄䡸ࠈ︀㰨䡈졼呔呔縀䁼傐ჾတတက᱔呜䁼ӾD舀簐簤⓾|䑄簀乊嫾낼悪鈀䡐蠒繐䡔戀晾똖繖瑼䐀幄쩾䁞剒帀幄䫾샞剒帀䡔﹪盾죾橮稀홖繖홾湮਀⣾⠸⣾䓺䂼㰀쨾쀞틒츊쐾샔퐾퐞퐞퓈홖绖훾䁾䂼Јဠ䉂㸀纪⫾꫾꣼ࢨ븀ჾ⡄ꨨ⠐ဨ였⠾呔呈䡔戀Ⱔ䑾큜桾䡔戀Ⱔ䑾瑾摊刀⠾䡾푔繈繈䠀ၔ吐︨⠨⩊踀⠨⡄咒ဠ⡄切ࣨ幊䩊䩪툒☀⣸幚詚娪⩒阀䁾劒ሢ≊瘂ఀ繀屔屔屄繈頀þ节节节苾舀ဠﺂ몪ꪪ몂蘀ٸ䁾䁀幒剒鸀ᛒꊾꢮ듾␪㈀䡈绀屔呔퐤䘀䉜僞偐幚฀⸢⋴呞搤⑔谀⡈䡨졈䩊츀ၺᓾ⁼蠐︐　ჾ舐︠⡈傔㨀|တတတတ︀Ứ䡐幒䉢숂ఀ⣾⠨﹄먈硂縀ၼჾ⠨︐簐ကࡾ䁈䡈偐呔먀ࡾ䡞䩾䩞䡔ꈀࡾ䡞䩾䡪屪頀졈䣈袈큐呔切幀퉞剒幀帀呾퓈﹐局橪樀䡈﹀屔푔呔偞噖홞䉂찀䡾晀䡈︀ა年呔周젔∀籄籄簮쪊꫊ࠀ籄籄簐哾⡈踀︐籔籔籐‰츀䡈﹀峔퓔呔昀䡾푔拔퓈䡔戀繈﹪绪ﻈ塈瘀呾푾哾織吀聜࢈䠈ࡈ䢈븀鐔㺔ᐔ㺀钔ꈀ鑞ᒤḀṒ劒鸀鐾ᒾᐢ᱄岒鸀鐾ᒾᐾᲜ뺔鐀ﺒ鋾銒鋾တကၼ䑼䑼︐簐︀Ụ幖庖繤汤ᨀ⣾呜쁾拾戀䓞푞홞챖䰀䁞蓄䒤쑄帀䡈뻈傔졒帀䡾铔抔푈졔戀繢뛪纪﹢昀哔绔哔绔푔搀ၺᓾြ悾Ȃఀၜ僾䑼䑼䑄䰀뻨ꪲꢪ븀닪늠꒤븀ჾ䑼ﺪ籄籄䰀䣨뻠벴뒴ꘀ⣾⠐﹀簀呔阀局耾䑄쑄䑄䰀噘ꠖ空禍穒樀퐾퐾퐾ﻔ퐀簐﹄籄籄籄舀퓾퓾퓾ﳬ㺤가⛾噔蹖嘦⑔萀䓾ꊤﺤ䒾ჴ哴哨쩪츀Ӿ偔咔瑨橪฀红㛪绪櫾﹢뫆몪먀컊풄뺄萀Ứ幒幒干ሀ౰ჾ㡔﹄籄簀ჾ䑼þ芺ꪺ蘀葾⪮⨮⢾阀慠ﺮ꫺慠言⠨︪⫺⩊勲ᘀ籄簀︠㱄Є᠀ဨ䒺 籄䑄簀䡾哜繢屮퐦᠀䩜졾䡞䉂찀蠾ᒜ㸢Ხ钦頀ჾ䑼ﺂ糚Ⳋ　ჾ呼哾汬泾␀僾勪廪幪뙀븀ჾၼ䑄簨⩊踀⋺⫊娪䪒≒阀偼傐︀籄䑄簀ﺂﺒ銺銖ﺂ︀⻺⫰蹺⫴⑺ꨀ哤ﻠ꺪꓾ꨮ﨎ꊪ籔籔簐簐︀ꨀ뒦屆밤粤㨺쨀蠾㒾㘾Ⓐꓤ똀뻶뺤ﺪ겤먀빈切䁾ꨪ劦T䋊먀偞䙐呲渀籄屔ﺂ籄籄䰀ꢨ幒눾犲㈲顈ࠈࣔ呔所븀⠨⢪벨ꢨꪺ츀麈뻒麒麲︀ሀဨ䒺 簄ࠈကﺂ鋾銺뫖銂︀䡈绪橾橪︈ࠀ⻊溪溬樐簐︀䉜哾뒲庲鸀幒ﻒ퉞呖呒娀⻊溺溬樀哊먀Ѹ䡾䣦籄籄簀籄籄籈䩬䡪츀幒勞퓖呒娀繢櫾ﻪ橢縀븢㺢㸤Ⓐ꒤똀ࡾ䃞剞퉜噔騀剒뻒办퉒퉒帀籄籄䑼䡊䑤숀ࣾ⨾䲮☀␤뚤듆| ︀⠨幈졎呔摄帀簄⑔䐨⠐⡄舀ࣲ뺴ꚨ곴ࠔ∀呾䡜죾탞퐤Ḁတ︠‼䡈蠈縀䓾ၼჾ‼䢈縀ჾ㡔﹄籄籄︀衈Ⲫ䨈ᩂ䒈뀀푾䡜졾偞퐤Ḁࣨ屚䪈橢摨က嚤Ỳ廲廲툀蠪蠚䒘︨檤㈀ၔ呔먐ၼတ︀ࡾ呔呪䡜䡈븀呔푔橈졜䡈︀⠼䡜졾呜呜戀⨪織幔幔帀︐籔籔哾䑄䰀籄籄﹐繒嫴ᨀ⡺⠨︄瑖呴਀ჾꩼ⣾䒒簐︀ჾᓾᑼჾ␸였ჾ鉼⠨︐︐ကዢꑐ⋲①눢␀ࠈ︈ఈᠨ절᠀䙸䡾졜屪저⡺⣾⣺⩴璤⨀ၜ僾ࡾ䡺䑴ꨀ蠾ᒈ㘔᱔岔ꐀ呔ꡔ吀员ဨ였౰鑈ჾး咒က繂繀癈桾䡾蠀ࣼ呔暈桾桨ࠀⒶ꒴였︠粤㰀繒됨䒺þ咒　ჾ䐸왼䑼呼鐀幖雖嚞홖帀⣾౰ᑈჾ㡔鈀⡺⣾⓼♬푔樀⡺⣾⓼癴瓼⨀샾袪頀⋺娪牒牒阀ჾ 䣜䡈䡈縀䑄﹄䛄쳔摄䰀ﺪ︨䠀ﺤ곴Ҥ가㺔吔ᐾ䑌钤ఀ幐僞剚婔ሀ킞틚꒪鈀繪绪織扔퐔␀呔﹚嫮幔吀搘搐︠粤㰤Ⰰᓴꂾꢨ뻨ࠔ∀䡾䡔싺؀䡾䣔找䉺؀ࣾ䡔䊞扺橺؀籄縂ꨀ⠮塈칈䡎䡈䠀늪⫺髺髲銒똀࣮뢨꺨꣮ࠈࠀ䡾晐么저࣮뢨ꢮࠀ帪郞ꪪ︪⩊阀幚嫾婒嘀ჾꩌ‾傞သက䡮됐︐ﺒ㡔鈀ၼჾꪒ⓺ၔ鈀䪾૪廠仪칪츀䡪䣾퓘䡔戀撮ⓤ뻤ꓮҤ븀䡮됀哾呔局縀滀븀繪橪櫾橪橪䘀穊穂穒穚婒阀ჾ艶ꩄ먀﹔눀䩊푊䁮쩖䉄屔繘婼쨀䡾橔䡪⠨⡨碨⨪⸀Ớ⩐踪﨤璪⨀⣾⣄글䫺幜鸬ﰮ粬⸀ၼ䑼䑼ზჾက撮⓮꓾ꫮમꨀ穪噖橊혀䒮Ӯ䓾䫮쩮쨀撾⫪냪ꫤҪ눀|呔呔呔呔︀㻔뒾뚢㸀| 8  ︀ဨ화메먐︐ကဤ蘒﹔ꈐ␈瀀တ႒銒銒銒︀䡒ﻐ﹔橄䩄堀桸䩺汪哴固ૺ髴钚눀䩎磎䑌爀塖嫪퓪䡾岪蠀婚婚ᘀჾ⑾䁨繨屈븀䡮둼䑼䑼⣾䠀䡮둼䓾咢籔鈀︐﹄鉼呔簔切퐾퐪䓮䒪籄籄籄舀廪꺺⸲檬动粪㠨瘀䋬䣨䫲䈀⋼桮諸籄籄簀塮뢮砪⑌鈀⠨䡾졈䡈䡈尀⸢䉄쑞䑄䑄䰀㸢幂噖幂䘀⠾䡾繈塈瘀⋺⋺ꪪ≲ꨢ☀︂稂穊䩊稂؀ၼ呔呼倰ဨ였껢໺阀ﺪꪪꪪ껂节︀တჾတတတ簀␤⣺幐渪⩚踀䑞䓤뺶홖嚤萀႞⨈咢︤栘簄ࠐჾတတ　繂繀織屮屔ꘀჾတﺒ銒阐က廨ꢾ꣨ࠀတ︐ၼT䋊먀籔籔呼T䋊먀偒幀幒တ︐簄⠨ဨ였⹚䩪쩄䑊툀勼塸幺嫺੒鈀䡎䩮몪꠪渀肌縀籄籄簀䡈﹈峄퓈䡔戀တၐ屐偐偐︀﹈䡪겨栨⩊踀Ѹ䡈䡾䡈䑤숀꺤籮븦纮ⰼ쐀䑄噔呔帀ᑤ␤⡸ꨪ⸀တ搨ဤ塚咒က䉜铔咞푔娀Ⓐꓶၠᓺၔ鈀뻤꺢꒪눀곪꺠꺪글︐ 琐ၼတ︀幒︲幒﹌䱌嘀혖였제젾쐾쐤퓄찀쨈︄쐼퐔퓺숀절︈제쀔탲젮현퐪쀞틒逞⪔籄籄籄舀껪ᚪꘀ呔廔ﻔ퓞퓴庢໢껪ꫪ躢ၜ僾Ö鋾뫖︀ჾ籔簔︔簐　㈲噖퉒婒摊刀⠼䡾쑾䑤呄䰀屔呜呔尨⩊踀ჾ艼ࠐ︐တ　ၼჾࣾࡈ⠈᠀䓾䒈䒪哊먀䡜졾䑾쑤呄찀ࣼꢾ꒴ఀ႞刪ࠈ䡈钔∀鐈㺒ሤኒ꒤똀衈႔稀᱔咔鰀﹔鋾뛚뛚뛚鈀﹔鋾뛚簐簔︀ࡾ䣜䡾쑾䑔谀૤幊䪔橪瑴Ḁ簀þတ呒鈐　︐⃾ꪪꪪꪪ蘀﹄籄䑼䑄廤Ѐဠﺂﺂ苾节︀⣾⠜ఀⓞ䩊﹄䓾꒤衈ຒሪل䒈뀀ࡾ呾噾摶摤똀ਈ︈ࡸ⠤␴숀퐖ﰬ︄ﰮﳬ切Ӯᘀ䡈溴␀簀 ︀䣈绪櫪縀ჾ舐︀⠤䑂舀簐ﺒ똀︐᠔က†…㣠†∢Ḁჰ낲뒸냰ሒḀ⣸⳼屜ﰬ☀ၐ籐郾ဨ⡄舀䑞僴벾푞璔ꨀჾ艼ဨ琐簐︀౰吐︸咒䓊먀븢㺢㸔ᒶ钔븀蠾Ცᐢࢪ鲪頀ࡾ僜案﹈䡔ꈀ汈溴⑼䑼䑼舀ჾ鉼ၼჾဨ였⣾⃾噔︆癔琀䡮됦䩤汖䐀㸪繪䁔偲渀Ⓐ꒴옐︸咒က⣾⠐簄ࡐ恀븀繂繪屪䡾呌눀⣾⡔쪺$䣚똀䡾铜䂾戀ဨ咺ჾ|䑄簀ﺂ䁼䁸ࣾࠈ　≲干剺囲㉒똀䡔䡾쁜呔⑴☪署嫔呚눀≒虲⋶⊲븢戀ၺᓾ⑼ꐼTꨀ䑄䑄䑄帀䡈곪䪈쑈瀀တ稔︠粤㰤㰀툺ჾၼ呼呼ჾက蠾‪㻪湀橀븀䑞ꪬ䩪츀ﺪꪬ꫺⩪갨栀呾呔﹀屔屔尀䁾䊢ሒሂȂఀ籄䑼䡈䡈䑄舀偞勊쫂䉂䰀偞拂틊䩂抢谀﹔ﺪ︂勢ꪢỪ⪪⻼ⱬꨲ∀庲Ỳ廨仪홪혀⣾⠐︠㱤ꐤ㰀ჾꈶ⋺⪴됪樀ꩦꨢ昀⣾ჾ⁼ꐼ僊먀‐︐တ簐တ︀牚婴呔竚ကჾ興︈䠨ࠈ᠀౰ၼတ︐တ　ၐ粐ჾး咒က年꒾搤ⱖ萀꒾剄븤撴␤찀졘屨졾䡈ࠀⓘ繈﹪终縀뻤뺶ﺤ꺤븀峸幚臭峺죀븀빔ᒾ瘶㙢红븀䐈︐籄籄籄簀屈繪쁾䡾橪樀۸哾艼Шဨ였Ỳ늲뺬곬ఔ☀ၼၼჾ⓾⑔谀䙸扜쑔䡔剺홺䋾剚瘀䙘꫾抜쑔졔戀簐ﺒ⓾ჾꪪꨀﺂ銒銒ꪪ욂︀⺢ꪪꪪꓤꐪ㈀繒剺剾䉺橺蘀ჾ艼þၔ劒　⓶Ѿ呴⒴됪樀剒勶剒剒鈀⠮婤賓橤橄堀琤璤⨀哊먀䡔䁀剒ꨪ⪾繾⪪ꪪ쨀౰ჾ咒砨ⱄ谀⣈䡪䣈푔戀䡌铈咢졄쁘䐀䡞諞䢪﹪﹪䨀ꩦꨐ籄籄簀ၼ䑼䑼ᓾဨ였ၼ䑔䓾呔呄谀⣾ၼ呼呼㘰⁼呔︘劚ᑔ鈀⛴囲噴图檤㈀呾縀簀籄簀훼쓾汼퓼퓚峔峀ﻔ廴䐀븢⨾⫾扺婀븀䐈︨ﺪ캂ﺂ︀䫾﻾ꪪ⠾䣼䡾ჾ㡔鈀嫾﫾겮␤䑄䑄䑄䐀⠤幄쑄乄䑄帀ჾဠ䑼⠨⩊踀တတ︐တတက削萾䑄화呔渀ਈ︈䡊䒌㈀簈︲咰ჾ㡔鈀衈࢈縈ࡈ䢈蠀葖ᒔ㸀≔䂔ꈀ퐦切婒ꃎ咴푖표嘀౰﹔籔簐簐︀䢾ࣰ勾哴푤였⸢㨪﨤⒴ꨪ樀籄籔屬汜䱔ꘀჾ舾䡞퉞剒帀陒᪒稔㒴눀幒幌䱔嘀䡾ꋞ撮渀ၼᓾᓼ噺幺阀⣼呴Ⲵ昐簐︀⣼瑔琬둦Tꨀ႒銒︐႒銒︀噐렖剺喙剒嘀計㸈ࣜ婪䡀븀⠲幔屴䡔戀䡒織젔∀ၼၼ⣾粪㠨㠀Ỵ뻲꓾겼␀䡒︴ꚨ건䣔∀໰哾艴廔㹄萀ꢴ戀ᒔ帴Ḕ呞钔Ḁ䉜鐞呞婪一䁾艺䩺䩊稂ఀ䉜푞哞婪一剺ꪺ横㩂谀衾Ე尀᱄纈頀鐞됞咞ჾတက똶㚶∾⪾ꪾꈀٸ䡾䡞剞剒鸀䡎룈檪﹈졊一ꨪ⨪哪橪橀븀鐾ᐾ㻄織䱀븀仪꺢ﺤ幔繺繺繺幐騀䁜瑔呔됦⁐踀幊䩊䩒嘀硘幚穊䩒舀籄簐稔︤粤㰀Ỷ뺤뺪฀衊ᲈ㸐Ṳ庒鸀ࡾ䁔織呜䁔ꨀ䡊鳈纐帀ﺪ︐稔︤粤㰀ၼᓾᑼჾ籄簀⣾⣾꫾᣾粤㰀⣾⣊᳈㻐㻒젊︐瑔并噖癚婲였⹒艺⫺⒴됪樀တჾ␤䡨ᠤ숀ࡾ䁼呈繊䡈頀䡔ꈜ䡾졪橈堀⃾婚㫎T䋊먀䒼⻾滮绮였죔죾죪ꪈ頀⠮婎쩞䡎噊嘀⨾扜푾繢繀戀꓾겲ꪪ똀ﺄ뢠뺨꣈袀︀ᑤ␤︤␤⑄萀︒ሢ䲀繂䉂縀᫪ꢾ늾닾ሒᘀჾ䓾ꪮ슺ꪺ蘀໪꺪꺠뻲ḒḀ吐ﺪ硂繄籄簀廪䑾푌ჾဨ였ၼ⠨︐︤栘幒廲뺠庲鸀ჾ鉔籄籄籄䰀䙸櫀䑾䓔䱄䰀တၔ呒劒တ　တ呒劐㐄࠰쀀႒吐ﺂ몪ꪺ蘀ࡾ䁈䡜䡈䡈븀ࡾ䁈繈屜橈蠀ࡾ䁬噺穼籪ꨀ⋺哸割呰⋺␀㠈်푸呼咒　䡈䩈䑈幊쩊噀剒吐ﺪ㠐簐︐　䑞쑞䙞쑖呔籄籄簨棾⠨䠀籄籄簀ﺂﺂ︀Ừꪪ뺲Ḁ籄籄簀呔푢䣈죐呔稀橪졞勞틞剒嘀䡾푾哜퓜䡾䠀呞哞퓞䁔樀鹊ઊ嘀Ṓ劒鸀ꨪࢾ∾⊾ꊢꘀ蠬⢨縈⫚蒈뀀긪窮⩪绪ꪪ글䡜䣔ﻔ䁾咔ꘀ⠾䣼䡼䡾Tꨀﺪ꫶ꂮꫮTꨀࡾ䃞䑄화呔븀ၔ鈔㻂繂繂縀⫪䡞办牞割ᘀᓞ瑞咞瑾怔⨀䩄︤䑎幄䐀マ案嫪졈堀ၼ⣾䑼䑼ჾက䡮됈瀐︐⡄舀䓞큔푞퓔푤帀幊諊嚠帀鉔ჾ苾苾节蘀⣾⡼䑼ﺂﺂ︀⣾⡆磪䑾쑔䰀⣾⡾졼䡾Tꨀ䙸逾空퉺剚瘀吐ﺪ먐︨檤㈀퐔퐢절점퓔切쐄퐖퐔퓔︀쨊혀틒퐈︈제절ﻈ저㡈ﱔ糒ⳘⳊ　吐ﺪ㡼䑼䑼舀廪䑾푌ﹼ汄簀庤Ӥ哶哴푴䊬Ụ延廤칤䢾ᓔ络峈︀죾풾퓜퓜袾蠀ꫪꣾ勾嘀တလတတတ︀ࠈ︈⠨⠐ဨ였簈ዔ塔咒　︀౰ჾ哾哾㡔鈀ﺂ먨⠨⠨䩊踀ቢ⋺勺勺≲ꨀ䩈绤籬汮䨀屔峔繐幪혪ᘀ䡾哢呾呾ᨀ袾铢퓾푾媴騀吐ﺪ㠐ﺒ銖က䡜죜졾呜呜吀繈繪푞瑈‼搘︸咒က䑄﹄哔퓈䡔戀鰔Ⓘ੾ા袈頀䡊䣾䡈䣔呔戀籔籔ﺂ籄籄︀⣾呢푾哾娀⣾⠸쩜咒簀ꨀ젾퐢퐾퐾졾哢퓾퓾䒾ዮ䓤围푔㻢뺤꺮꓾㘾刀䑞䓮橮橪㸀䢮ᓤ뻶뛶隤䩈﹄䑼푔呺숀䑞櫮湠縀䑮ꪮ横⹠븀繪绐幞䪮騀呖볬纄ﱮﱬ稀籬繤籮ﰬ㨀㠨䣼呔籀䉂㸀梨㻪ꫪ뻨ꢪ븀ဨ哾䑼䑼呈䢨㻪ꫪ뻨袪︀繀局織騈︨᠀繂繈䡼呔呔ꘀ⠨繪橪繈䠀Ⱐ幀幀幒帀㰤屄﹢屔䡔戀繀局織驼䑄簀幐困뺴화咲騀ჾ艜䓾扜푈瘀ჾ苾哾㡔﹔簀‐ ⒢ꊠ␤㰀䡾죜표呾䁔戀幐홐幔화瑒⋼塘︪飯檲∀︨ꨨ︀籄籄簀ჾ㡔鈤︤沶␀䡜졾哢繜樀鱄ᲄ㸢᱔䢔ꈀ븢ᒦ࠾࡜岪蠀တﺒ鋾銒︐ကࡾ䣔扈푈剄頀ჾၼ䑼䓾D舀䡈︪橾繈䠀ၼၼ⣾䒺簸혀䡈뻪檾﹈䠀ﺐ郼蒄ﲐ邐︀⣾⠠ဠ摢ꀤ㰀⣾⠢ﱘ︪全ꨀ⻺幚︪︬沴☀젔퀄젒쓈ၼ䑼䑼䛼ఴ찀ၼ⠨︐ჾတက鑔ḴỔ幔幀븀䒤Ӥ廤䓤쑤쐀簐ﺒ똀繀織騀တတဨ⠨䑄舀‮䁀쁀䁀䁞䀀︒ቒ㈒ᨢ≂谀ࡾ呾癤癈屈븀౰တჾတတ簀簄簄︨᠀⣾⠸⠸⣾汀簀籄䑼䡄눈pఀﱄ籄籄䰀ﰔ퐔퐔퓤였뱔ᐔ㳔呔剀븀ꣾꪾꪾ좾蠀뻪ꫪ嫮嘀䡮둾ɺɺ䩺؀ﰨ︪響저幈鸒幒鸒幀鈀壨ꢮﺂ훖蚪銪욂︀繀穆穪湺剚똀빀㸢㻔呔繀븀࣮늪ꢨ꣨ᐔ∀౰ჾ哾哾တ︀䣨뺪ꫨࠀ呔幔푞呔တዴ㠰塔鈐　偞勪죈䡈呔ꈀˬ꓾겾ꓤḀ䣼푔죾졈䠀暪ჾ咺ჾကჾ䓾䑼⡪ꐴ戀鐾ဪ᳨屪塀븀䳴ꢾ咴Ỵ廴哾푴䒸ࣾ哾哾졈︀꓈꺪꺪글繀﹐繪⨀瑮摨癖癐帀鋾ჾ芺þ咒　鋾ჾ䑼þꪺ蘀꠨ﹺꨪ穀携쨀幐퉚哔퓚塐帀僞橺큞櫺훀븀䩺껼⻌粮ﰬ츀幒幔푞橊츀∢≤炢∤⠀幒廀幒帀⣾⠐ﺪ먠㰤㰀⻴꺪ﺚ깐言ၔ鈔㻈籈籈縀幒︴幔䩊一먔⊜>⊾钔븀癒癒幒ࠈ︈ࡈ⠈ࠈ᠀呔哾呔呜䁀縀깴⻺繺纪ﺠꨀ␦見듴몺切籄籄簀︐屐븀ࢾ䠾ਾࡾ和눀⊢着⫺⋺ꪪ☀⣼⳼泖⃼⑄谀␬⻴呔渤⑤鸀幄萄呖푔呔縀䡘졈屈䡈縀ਈ繄瑔噔瑊鈀☪몪ꪤ듊ሀ⣾空ꐪ︐屐︀籄籄籐粐簐︀Ӯ꒮ꪮ਀䡾졞䫞죾呌爀織푾盶扢縀簐တ停偐偐︀衜࢜࠾ᑜ咜鐀䣘졈峈䡈縀ၐ籐逐簐တ︀੾䑶咪|呔︀䣜졜졾퓜표吀穚︐簐簐︀ჾၼ|呔籀耀ꋺꩺ⋺ꨐ﹨똀︨⣾ꪪ껂节︀쨈︤ﰬ쨀峐廤簀簀籄簀제제젾퐜퓜퐀鈔㰔ᛶ婒牀븀仪꺴︀ၼၼჾ䑼䑼䐀♺⑾⛾噾呴尀ჾ䐨㣆籄籄萀㓈繢哔푔昀꓾낾視뢪글⠾䣼䡾|␘ࡾ呾呜䡾檪蠀呾퓔﹀屔屔尀ਈ織屔籖籔눀౰䁀繈塌䩈蠀⡼⠨︀籄籄簀䑘큐廔퓔呤䐀︠†㱤ꐤ␤㰀⣜䡜졾哜표戀䡮됪︪︠﹪글䡜補䢾표표戀혐혨糆籄籄䰀ၼၼჾ䑼䑼舀ၼတ︨⢪ꨨ堀뻔呶퓔꣜䡾퓜퓜Ứ幒庒繒幠ሀ幊䫪䩊䩊樒☀䡪繈졪橪︀䡾푔繈﹔塌織繄䁔䑘큐幔푔呤쐀퐦퐈죔ჾꩌ^䩪ᘀ䡮됀퐈︢퐔퓔簐ﺒ똀簄簄簀䱔蓞媺帀౰တ︐ၼ䑄簀橄ﺪ뺪﹈繈저⠨䡪橪橪縀ၐ籐郾⠨⩊踀౰တ︐တတကတသတﺂ节︀ჾ먀籄籄簀︀ჾ呼呼ࣾࠨ᠀ၔ劒【︐⡄舀䉒剒剒剒䉂舀ꨈﺨ着ﰤ⨀︀繂繀繪幪騀癒䁔﹔繀䡔䣈䡈縀偞嫚剒嘀ၼ䑼䑼ლ咒　討㢎㠎㢊蒌눀蠨㺨䡾ᒔ钤였逼鐔ꘐ︸咒က鐾ᒾᐪ᱔岔鰀䓾êꫪꫢꘀꨀ幀廲ﻐ幚庪阀偞䩨꺨꠸渀ჾꩌ|䣾⣈᠀䡮둈︀ꘀ䡜铜咜졺堀噼链咔ﱖ표爀䓾ჾ႞⪈࢔ꈀꫮꪮ겶가䑄織咴ᐞ⑄萀䫪ꫪꪰꪪ글⣾⡾呾幐庂嘀젔절죈︀룪Ҭ눀룮塎쓬툀똒㘤㻔繀所븀블㸾ᓾ橐局븀䪮ᣮ壮壪쑬툀䒴Ụ䓾䳬챬혀銒꫆舀檤㻤ꓮꓤẤꐀ䓾âꫪꫪꊢꘀ⣾ၼჾ哾籄簀鈼ᒼ㸺㪺銺鈀䙴庴吤䪊Tꨀဨ䒺တ簐တ︀婄︶幖﹄幄䐀呾補䢾푾尀ꓮ꒾꺪글廐帀ᓨ뺪뺪뻔ᰔᰀ建⺪﹊阐簐︀屔呜퓔퐔㸀呾푔繀屔⡄ﻖ몒﹄籄簀䐈ﺒﺒ﹄籄簀⓾沶⓾ቜ偐븀벴呜푔峔呔븀䡒ﻀ⨀䡾ﻈࠀ૾䩞䪎癔噼ᘀ屔呔ﱔ呔縀㳔呜푔峔푔縀峔표푔푔縀ၼၼჾ値﹔鈀屔铜咔푔縀⣾⡢갤ﺤꐀ쐘퀐훤쐀풜퓔钔븀긚縊⫾婚橀븀ⱄ汄籴屴屴㐨繪﹪織屔尀≒見穚牂狒瘀︒ቚ娪␤告鈀꫾⡼ჾ剺哴ᨀဨ粂籄籀粤㰀ჾზ혐﹈䩤숀␤ꑾ␤⑤ꐤ⸀ၼၼ⣾䒺簨였ჾႺ咺咺ဨ였ჾ舐︐㠸咒က繂織繪織屔鰀ﺈ袾ꪪꪈ袀︀僞櫒䘐䓊먀⻺⹺溪⸀哊먀䡾橾졼呈屄繪졾橪저䑘﹈繪﹪繈저籔졶䡾䡊︀屔橾졾屪저籄籄䑼ჾတက⣾⣾꫾﹄籄簀呼呼呼ჾ㡔鈀䡔﹀廒幪一呾푾盾ﻔ屔尀鐾ᒾ㘾㺔鲔鰀屔峾䡾岪蠀㠨䣼ᓾᑼတ　ࡾ䣾橾졼呈똀幒勲剒帀ჾꩌဨ琀哊먀哾푾ﻔ尀呔ꋈ咺쁔큲渀䡾ꋜ䂾졪堀灤橾恪㘀⣾⡼䑼䑼ჾက⣾⠀⒤㸤撤⸀⣾⣾沨丨︨䠀⣾⡄﹄籀粤㰀⣾Ე㺪㸈뺜ꨀⒾ⑤긐︨檤㈀ၼတ︐屐偰鸀鐈㸈ࣾ䡔所븀鐾ᐾ㛾屔局븀䒪Ỡ仪仨츀簐ﺒ똠︪纪⸀쒚쒞꒦帀ⰴ繪﹨噬呦堀呈绪繪織ᰀ呈ﻪ﹪織屔尀들뺤뒴ꨀ⣾⠄繄籶瑼言ﺶﺶ뻪ສ글鑞ᐤỀ幒幀븀㸲剞쑄噔呔渀㨪繮﹮橺䉪樀ꫢʢꘀꫪ誊꣨ࠀၼ䑼䑼䑼僊먀幒퉞䑄화呔ჾၼ呔簸咒က먪㺮㸮⪺芪ꨀ籄䑼တ屐偰鸀蠾࠾⫾䡜橀븀呔扈푔扜呔尀繂繈屜䡾穮먀쫈ﻔ퓼훔ᒤꨀ䡎乴꒾ꐪ爀䡾補䂾푔昀ჾ䑄ꨐჾတက䡈︪橾橪縀䓾䑼䑼䓾D舀呾쁺橺橪ჾ‼䓈繈䡈堀⡌䑪噖쐀䓾⡼汄簈︨᠀幒幒幀툀␤︤⑴沤␤Ⰰ눜ᐨ㓚呞瑀븀␴噞呔剒帀‼䒨ხቪЈ瀀တ︐ဨ⠨䑔舀衈㺈䠔ᑔ努ꈀӸꢾ겾곾ࠈ㸀좮뫎訐縐︀౰呔ࣾ⑨ာ숀䡾탞剞剒嘀幄䑤쑄䑄찀䡾勔剒帀䓾단ꪬꪪ글䡾큞擞틞剒嘀ꋈꪬꢨ쪊踀좈좔늪戀︤뺤搀⠨繈橈屈䠀呔廴幔呾퐔Ḁ∢︒剚⨢剒蘀仲늺뚲늲阀⨨付䑄䈐銒︀哾呼ჾ鉼呔က䡜蠾䑾쑤呄䰀ဤ切籄簀哊먀䒖䃊먀⡺⣾ࣸ賓鈀䓮䓮䒪籄籄簀ၼၼ⣾䓖㣖　ꩾ⪾ࡾ䪾ꪪ蠀꣪뺠ꪪ글껪꺨몰글⣾⠐⓺|䑄簀⩈䈐︨檤㈀⩞쑂籄籄籄舀鹒ḒỔ噔婀븀衞ਾ࣪屪塀븀퓈ﺈ탪퓬钦頀⩞쑂籔簐︀ꨀ红⫾꫾ꋾ㚾ꈀ⨨乸졈䡄䑄䈀တ⁄切籄䑄簀တ︐ဨ⠨䑄舀䡮둼ᑼ偾㉖退仪뺤櫀븀ࡾ呮汮屘幂ꨀ蠾ᒔ縪㺪뺈踀鑾Ⲯ種㲮벬글သၼ䑼䑼ჾကỨꢬ뚬듬ᘤఀჾ舌瀐ỰဒḀ䑘졈乸졈䩊츀幒퉞呔푔呒幈乚䩊츀鹒ኞ吔ᑔ咒ꈀ똒㚒㘔Ẵ麔鸀﹈䡚汔᠀쐘절츸절쫊츀纪㻈峾哾졾저븪㺐Ḫ㺾誎눀퐾퐈︐틒⣾⣾䑼䑼䛼Ѐ籄呔籼籼呔阀婊늾割혀籄䑄䑼(⑄舀Ỳ늲늲닶တက㸲剞퉒剞䁀帀衜࠾ᓾ屾䡀븀繀局織噔呚눀ჾ䒪㱨밨︨᠀뻲늾겴ꘀ簨﹄舀쓪ၼ⠨︀衈ࠪ⫪橪繀븀繪櫪ﻪ橪嘀⡄舐⡄艼䑄簀뺪繪䣜䡈븀溤㻶뛠껢ຢ글呾푾盢ﻄ織䰀퐔퐞퓔籄摔䓾䑄䑄谀合籔籔簐︐ကᓾ뒾ꪾꣾࠔ∀幒勞剒剞쀀㸀幒割퉞䁀繢푦䡾졜屪저籄䑼䑄䑼 ︀哶嫶듴⓴⑚言蠪Ⲕ∈⪬袔ꈀ鐾ᒜᐜᒾ뚠븀鋾~䡪橬䡔ꈀ麀䫮䁊檤鸀橪︀뺨빪櫪⨀䡮둔籔籔︐က䑞鋎䒄화푔渀橪桬汬☀ꫮꪪꂠ글︒屐븐籔簔切퐤퐴䢶᛺僶勺푴ﺂ諾說骊骂︀䡾䃾百屔㸀绪뺪﹈繈저ꋬﺪ﫪ꪊ۸ꪾꢮ㈀䡾쁾盾局縀⹊䩠乢䩤쑊刀ﺒﺒ︐︢≂谀젪죔␾䑮橪湠縀䁎窪⫺⨪婚踀䑔回癖呔툒Ḁ쑔回뚖푔剒恨橺穸⸀䁾꫺⻐籄籄簀葔᚞㘖ᑔ劒鸀ࡾ䃦繖홾噖ꠀ㓔年哞푔帀ﺪ︐︤벤벀︀䙚飯琤㓊ሀ恦ﻖ훾홖噮저鹒Ḑ᫞呞摀븀횞횖늲帀䡮듼哦ჾ㡔鈀ჾ⁨ဤ﹔籔簀䡈溴␤␤␤Ⰰ䡮됀ﱔ屔瓔☀⣾⠐︤穀籔簀빈ဪᓬ呦塀븀⣘屨졾䣈푔戀ჾꩌ︨琐簐︀⣾⠐⡔먐咒က䡾哾ꪾ皾ꈀ䓾ၼჾ㱤밤㰀တﺒ銒︐တက⠨繪繈䡈䠀ჾ鈐籔呼呔簀ၼ呔呼ၔ䋊먀䡈﹪橾橪︀籄籈粪㠨㠀︀偈﹈䣈䡈縀遈㺈䠈᱈䢈븀တ籔呔簐န切ჾၼ呼⡪ꐴ戀퀈︈절죈︀廤겤䢼ࣼ䣾哾찀쒎꒤帀屈﹪哀ﻐ幂䘀됔⺔㹘Ẻ글꒤幄븨溺⸪츀⣾⠐ﺂ簐တ　⣾⠐稔︤粤㰀ꓤҤ가︐တတတတ　⠨ꩬ⡬ꨨ⩊踀㺢樾⨾找뚾∀⫾ꪮꂾꣾᰪࠀჾ舦癔嘀䡈﹒剒帀幐﹔噔娀ࡾ䁀繈䡈䡈頀簔ᑼ傐︒ሖက峐鲐﹔噔慠곸꫺賸谀呔븆繖﹖呺䨀呖빆﹔稀哊먀呔呔呔乊뻨꺪嘀仪䫮ꫪ껪䫪嘀깺⫾婺建ꫲꘀꪾꫮ裮꒾겶ꐀ뒴뒴ఀᓴ뛴듴뚴☀摾百恪㘀골겨ﺨꪬꨀ껪뺨뚪똀橾ꂾ졾屪저︢젾저⹶☪湺湠鸀뛴呔퓔咴ᛴ哴围푤였㰠㠠㠠︨⨤爀Ứ幒幒幒廀ሀၼ䑼䑾䁾ʪ蘀⣸⻺ꪪ飯檲☀䑖푔繈䑈ჾႼ꒼꒤벀︀ꃾ꒤ﺤ꒪눀蠾⪪ࠌౌ咔ꘀ졔扈큄䡒쐈　⑘졾䡼䑼䑼舀䢾ࣜ哜哾쁔ꣾꪾꪾ좜ꨀ蠾ાਾ࡜䢾蠀퓾郚감簐︀呔廔퓞呔帀扖왆䓶훖噐渀衞ሞპ剒幀븀劦ۦ䓶囶홰ࡾ䃾䑾橾ꨀ븄㸪㻪繪橀븀繢糐婬呬퐦᠀幒绒幂䘀繢﹪橾繢︀噖﹖图훔呪䨀㸪橪橪橪縀衜࢜࠾ᑜ咜ꈀ幈仚䩊一衈࠾ࣈ䡈䡀븀⣾ၼ䑼䑾ʪ蘀幊諔檀樀嚶ᛠ䳠廨칢였䡜졾哾屔尀蠾⪾ᐜᑜ咜ꈀ繈櫪䡈繈절ࠀჾၼﺪ籬簨︀鲈뻪샾졾檪ꨀ䡈뻪檾縀౰呔呔呔呔鈀籄䑼ჾ銒阐က䢮ዢ勪䫢쉢찀⓾ꨮ竮确牪瘀ჾ䑼þ艼တ　∼呔呔婂娀⠾呜쁾扜䡈堀⠮䡜표呜呜戀刢飯甆飯檺☀သၼ䑼䑼䑼舀籄䑼|ၼတ︀幒廲幀幤혔⸀ჾ艼တ屐偰鸀ჾ⠨ﺒ籔呔ကࡾ䉜呞呔婂먀ࡾ䁲層織繐글쑘䢈﹈䣈局븀䐈︒ﺐ︒㉖退呈ﻊ﹨繊婮䠀䉜푔幔푔婂牜푤織푴幐幒幀噔呈﹊绨ﻊ婮䠀비҄䐄ф䒄谀Ӿ剎䒄癔呼ᘀ䡎呜呜戀㻒剞䓮쑄帀䡾铔纪졾䠀狜퓤ﻔ퓴글︄젾퐔︪젾듔繪죾저鹔ḔỤ幖䑀븀ᛦꚤꚦ퐔퐀嘦﹔ﻞ軾⑔谀庤Ӥ䓤䓤쑤찀㢪몪뫮⣮⩪ꨀ븢⊾⠪Ⲩ꣊踀䡾푾橾百癒癔幔⓼固꫺꫼言蠾ᒾ⨾⪾뚾ꈀ䡎닪ꪢꋢఀ䡮됐籔呼呔簀蠾ᐾ⫾橶繀븀䢾ᓾ櫾櫾똒㚤㘒㛚뛚똀䓘偞푤䑼䑄簀呼阪穊𤋮籪樀呼홪穊𤋮籪哼囪響﫬糪樀꠾⡈㻈䡔所븀䒴Ỵ䓾䓤쑪툀⠨籬籬泾D舀䡾䣜呜呾쀔∀︐တ簐ဨ⡄舀繂織織織噔騀ࡾ䡈么䡞剒鸀萘ࢾᐢࢪ꺊頀䑾ꃮ溤﹪帀⫊幊䫪ꪪ뻲ኲ븀仠䃾䫲帀⻴⹺幺建๐言တᰐ籄䑼Tꨀ⸠䁞쑄䡈䩒帀繊穀湺橼䑪ꨀ븪㪠⸺⪼쒪ꨀþ銒鋾銒銒︀簐ﺒ籔籔簒Ḁ౰ၼ呔簪⡊踀Ӥ꒾꒤ꓤЄḀ䡊峈繐干Ḁ蠔븈㺈ꨐ簐︀幈䣨꺪檪踀繂繈届繐繒鸀䑞萄繄화呔渀ࠨ᠈䠨ࠎࠀ䑄䓄䑄帀萾⪾⨮₮꫄騀璪䒺|䑼⠨︀⣾‸䣼呼⨨츀ﺨ뻪ສ글蠔∜ࣾ䡪塀븀☮瘤﹆盖瑔琀䒾⫾櫮惮˼呔应瑔婢ᨀỰ偞咔癚婲؀⻲婔㓊ჾሢ찀ࡾ呾呜䁜呈똀တၼတတတ︀⸢⫺婚搤⑪鈀⻲婔㓊T䋊먀㨲晾홖穒婲䘀吐ﺂ籄簨⡊踀‼䒨ဨ혈pఀࢾ䠾⨾橾袜⨀︒ሒሢ∢䉂谀ࡾ䡞䩾䁞剒鸀呾哈呢局ᰀ䑾擮晾恾툒Ḁჾ䒺‸⃾ဤ切ჾ艼†㱤ꐤ㰀ၼ䑼䑾䁾⊪切䡞剞틞탞숪☀䡎죜표呜䡾䠀屔푦屄푈䡔呾푈呢屔ჾၼ呼呼㡔鈀呔哔呔昀䡜졜䣾퓾摔䰀䡾졾櫾䡜樀႞⨈咢|呔︀逞㊞⨞પ뺂蘀鱔Ე㸐Ẫ險阀蠼ࢼࡾᓾꓔ谀幄䓤쓄䑄撤谀穔拜샾找咔븀႒吐︂ɾȂ︀ࡾ䃾䁾呔븀䡜䡾푾摔䰀䡮됐簐︈︨᠀䡮됐⡄먀籄簀䡮듾芺芺ꪺ蘀䓞푞홞탞帀䡾裐抾푔푔昀䩚飯爢㋂؀⣾Ɒ﹔籔簐︀⣾⢜ᒾသꪖꨀ⣾⣴ꣾꣴꪼꨀ︄꓾겲꺪글︀籄䑼ࠨ⠈︀볨屪鐔㘔ᓶ呔晀븀鰈㸜⫼噒晀븀窴⋜䃾拾푔︀탞쫪뺂蘀꺪仠ሀ꓾겲꺢똀꛶舀␼噾ﹾ噾噺䨀⣈廪䫪䩲혀ﺂ몂몪ꪪ몂蘀吐ﺂ籄簐簐︀鐾ࣔ屔븈︨᠀䡾퓔﹜屈屈縀䡾푔繜屈︀븢㺢㸶㚶뺢ꘀӾꫪ뺮껤Ḁၼ⠨﹔籔簐︀ﺲ뻲뺶뺲똀⣾⡾쉺ꉺ꫺؀鐾ࠔ᳔屔局븀庲Ỳ延囶혀䡎䡞ࠀ蒮쪎䣮䉊嘀ﺔ뺐뺐뻒麀︀屔鰔繄﹄呄䰀䡾蠾百쁔偲渀蠾࢜>⊔钔ꘀ䣜죾쑾䓤呄䰀⸲⫴⒪籄籄簀౰ჾ咒⠨⩊踀䡮둼偼偾ʪ蘀ၼၼჾ哾呾ఀꢨ繪ꨪ纨⠪젾제쀾퓔幐큞哔훪橊嘀䱔﹪绘훬呦堀㠨⠨⣮节节︀ჾꨨ䰐︐⡄舀䡖僖呔娀繂繈䡾橾橪븀૾ᑾ䑼䑾ʪ蘀⣾⠐Ḑ籄䑄簀ჾ艼ၼ呼呼舀︨⣾ꪪ캂ﺂ︀阺ᒾᙾ⺾ꪺꨀ⻤뺪꺺뻪⸰਀ဖ銒︐ဒḀ䡾屄繈堀⓴癚稊稔樀蠎㢈⨪㺈袊踀ﺨ꣬뚬뚤가鹔ḔỚ幪乀븀⸴꺪︪⸰਀౰ჾ⡄艼䑄簀籄籄ﺒ簀︤切䢮ᣨ䫪廨졪츀ჾ⡄먀︐咒　围噖呔됀တﺒ銪꫆节蘀䁾傐Ḑသတက籄呔屔瑴瑼蘀⣾⡊纬縬⹜踀쐶퐄ꩺ⻼噼ᒾ钴츀䡾푢局﹈橈亪໪䫾勾홾툀呈﹔绶繢縀墨늲戀繪뻈纪﹪﹈一Ừﻪ⨀ჾჾ芪銺銺阀䡾졾拶橾樀䣮䫶䫪刀哴廼껼⳾ⱜ踀衈ࢾ吔ᑘ䢔ꈀ|   Ӿ 繂䉾偒屐剒鸀ࡪࣾࠈ栄д숀逞␄ᓖ晄䱀븀䁾艂䩲䉊稂ఀﺰﺴ뛴ᒲ먀ჾ銪욒銪욂蘀䁞꒤䑤䑄䓾䑄䑄䑄簀繂䉂䉾䉂䉂縀᳤간琔⓼␤昀瀐တဨ⠨䑄舀‮⫺婚横⩚踀繂繈䡺屘汊頀⣾⠨︀␸䡈졾䡈䡈尀∬⓴呞搤⑤鸀簔琜⑌T䋊먀쨖쀔탲鰈㺪>ࢾꪪꨀ幌慨噚噚嘀偞屚䡈堀ჾ鉈먀籔︐　⣾⡀纪嘀哊먀钾呀﹪绪橪븀⣼⳼岬㓦Tꨀ䁼傐籐僾တကဨ䒺|ࠐ䓊먀䡔䁾쑀呲噜汔䁔噜滜橊䂴ꨀ䣨졎퉒帀ﰤ␨⸢∢䉂蘀庞廒幀븀တ簄ࠈၐ恀븀⓾⑬똤ၼတ︀ჾ哾ꩼ⣾檤㈀䡪橪癢縀鐾㚾>₾듔騀䡈뻪檪昀䒖똀ꫤꊶ뚢븀뫾ꂾ뒴먀⡼汼~䁼噔騀︲︲ﺲ뺬昀簔䐸홼呔簔切ﲔ钔铼肀节縀繪橾扢屈屪﹪繪︀︨ﺪ︀껪仪嘀繪櫾扢帀蠾⪪㰤㒨좔ꈀ萸⊼㐴㚴듔鈀﹔呼䁂㸀Ӿ噔庒穔呪ሀ蠾꨼뒨哾␸였ﺪ︀籐籐縂ꨀ⣾⡼呔籀䉂㸀籐籐籐縂ꪪ蘀呔癔呶呔搀ࡾ䁺呢織織ꘀ繈屈졾䡈저呔癔푶呔ꫤҪ눀繈졘峪䡈䠀︐ご鈀籔呔︀ꢾ뫾髾겴뺤ꐀ⣮⣮籄籄籄䰀ꓤ뺶뚤ꐀ⣮⣮⣾呼哾က䋢ꢨ⠾呔﹀屔呔尀䡾哔繀屔퐔ᰀ䩞䫮ꪮ쑞沖萀偞櫾繂䰀呾표哜죾屪䠀呾哜퓜䡾岪蠀꺪乊긪檮‪툀ﺪ﹄籄籄籄舀ჾၼþ舨⡊踀ﺠ껪પ글죾풔ﻀ钔鰀鰀㸀᳀屔局븀乊뺶﹖幤였㻈橪졈终졈䠀骊勲婊檪騀⣾⣈櫬棈졔戀⠨幒퉞剒剒帀截横飯ꩲꨢ昀䩾䣾橾䑾䑔䰀䡈﹒剾퉒剒䡈勞틒剒帀蠈㺢∾⊢ꊢ븀ဠﺂ节ﺂ节︀䡮됈븢븢⊢븀䣨틲퉒帀䣨뻲늾늲븀⣾ࢾᲜо蒔谀衞ሒỒ剒幀븀㻢뺴ﺴ뺪ﰪ᠀鐾ᒾ∾ࢾ袔ꈀ繢绔ﻔ繪岪頀䩾裾檾쑾쑔䰀⣾⡼䑼ჾဨ였첒삊꒪刀ၼၼჾ⁼ꐘ︠ゖ뫖늂︀䡮됀⻺⹺溪⸀૪偄䪊灮橪฀䡮됐稔︤粤㰀瑊遼ᓾჾက䡮됌瀐︐籄簀䑆哖훐汌帀屈﹪繪縀ꫪꪪꪪ눀幖囶훞噖嚶鸀ၼ䑼䑼ﺒﺒ︀⠨⠨⠨⡄䑄舀䒤Ụ䓬囤칤쐀렪ᒢ>ᒾ钔ꘀ瀔ꩄ艼⣾⡊踀哢샾퓾퓔牄牄︼咈瘀⨨乸쩊䩄䑊刀ﺪ︀䡈﹐屔푨䡔䡮됪䡾졊䑌刀꺺똀䑎橮梮늊ᘀዼꢨ뺲뫒㩒ሀ䡾哜䁾找∀䡔ꂠ﹒割⠾䣼䡾ჾတက␶噄䑞䑄䐀⊪ꨢ諸⋺∢☀ၔ吐簐ჾတက繀䁼䑔呈䡔ꈀ廰嫴䑊鈀幒틚훖퉒剒戀噺湪𤋮汪쨀화籌泖呔泄฀幐큞勚摊刀鹒ኒ刖ၐ劒鸀밤⒴Ⱜ⒤꒤였꺨꣮諪ꪴ꒪눀뺲剒눶炰㈲䱬泮汌䳔⸀Ӷ뚴뻴뒾듴Ѐ蓶櫴樐怔﹔鈀仪ꫠ꺢꒪눀⣾Ҙ⪾ᰪ뺪븀ꫴҪꨀ䡮됮飯﫸⫺⸀౰呔ჾး咒က幈廲幒纠鈀幔庚໺幚幐먀庰ჾ닺뫤蒪䱔쑾橪﹔呔೴꒾뺴☀簐哾㡔﹔籔簀仪ꃮ꒪|呔︀仪ꃮ꒪︠粤㰀⣾࠰哾㡔﹔簀ჾ⢪堐籔簔切ﺔ뚔뚔뚔ꒀ︀ၼ呼呼⡈︈ࠀ︐ご鈐籄䑄簀⸢⋲幘栨⩚踀ࡾ䁤摶摤撤똀䑞阔幒摊刀⣮⣮⣮⠀哊먀︀繂織癔癔ꐀ呔푞呔푔呜䑞화幒摊툀⣮⣮⠐﹄⠸였䡈䡊籈䡈䩺츀逈ʒᐴ㪸銒글ࡾ䓞噔呔ꨀࡾ䩊屄呈䡔ꈀࣾ婞媞汴繤Ѐ⣈䉒푴竸퉒渀呔뛔皔푶푔搀ﺪ﹄雴۴雴阀ﺪꫪꪾꊢ븀䑞幒充告刀퐔퐶퓔⣾⫾꡾왼䑼舀됮⨺⻴幔瑀븀⠨⡮꠨䠀ﰔ囔勼噔噔鈀乢쑎䫾婐渀䡮둔﹖瑞宅騀呾呾큞橾橾樀繂繄硎硎硊踀呔븆繖화汪䨀呔푞哔퓔呜瘀籔籔呼䩬䡪츀䩬䡪츀繊繀幒幒幒鸀䓾ၼჾჾဨ였ၼ䑼ﺒ﹄﹄萀䡌푈哢죄䁘䐀⣾橾哤﹄䐀ﺨꢨꪪ껀肀︀簔ᐐၜ偐偰鸀牄牄瀤뚤ჾ␨繈呈剄렀곶겲겶가⣾⡼ჾ䒺栐뻤꒴꒤가왺勾견﹪橺였‐Ф⒪ꪰ≢鸀籔籔﹔︐︐က䡮둼ᓾᑼჾက빔ᰀ㻪繪繀븀䡔䃾죈偔稀幔哾늲咴鸀䙘䫾ꢾ큞犌눀籔铔咾푔푔縀︐ၼ䑄籄䑄簀젔쫄⠾䡞졾䡚瑔娀∴⃲꒰苔큒鸀織ﹾ䃜샾䡪堀ၔ吘㡔咒　블㺾¾袪頀ᑴᓴ㒺戀︨ﺪﹼþ咒　ၼၼჾ⡪ꐴ戀혖쐄쓄쐀⣎뉂뉪ꩢꈢ氀ࡾ䁮穮穾ꩺ⨀呾푀繪﹪橪︀ࡾ䃾䡾癢ꘀ⣈屚嫂쑈瀀⣾⠀籔呼呔簀咾ᓀ绪绪︀䒸ჾ哴廠푔⣾⠀氀︤똤氀幄뺤䑤撮⓾곶껪ສ글籄䑼îꪪꪪ⨪ﰨ⩺粸⨪Ⰰ䡚꒴屔咺舀葘႞吔㹀咔ꈀ긴⺪縪溪麠쨀⡄︤䱼䑼䑼舀ჾ舸吼쑼䑼舀⸴꺪︪꺪Ḡ쨀䑴虺婚杖樀븐哼屔呜阀︐ူ㑒鈐တက␤幄쑔䱄䑄䰀䡜哜幒幈︈ࠀတ簐ჾဨ⡄舀屄峤뺪졾檪蠀ჾ艼䑼ﺒﺒ︀ﺂ籄簀ﺒﺒ︀ჾ⁐﹒剒嘐ကࡾ䁒幒牚剒阀䡾탨졾橪橈䠀䡈䡾졈呔⓴⛺飯梅瑚눀⡄꨸외䁾䡈蠀䓾⢪⣾籄籄簀蘸⪀ᰄࢾ袈頀⠨䒪⠨တ⡄舀䡮됀⑞쑔䱄䰀ࡾ呮摬繪癪똀ࠎࡾ䡾橾呜鐀⣾⠐簐︐⡄舀퐾퐶퐾㡈ﱄ籄籄籄舀보ᒼꈀ⑴␤摴摠鸀ၸ䡸籄簐︐က쫊횒틒銒阀偞恞橪繂䰀偞織푾䁔ѶӾᐔ屔呚䁾푾哾䑾퐾쐀⣾⡾ꋺ⋺꫺ꨀ⣾䁾푾哾Tꨀ⛾噔︆癖呔琀≲⸢瘢㋂؀繦頻绪橮娀籌瑔籔呼呜똀⣾⡼䓾䑼䓾Ѐ⣾⣦ꫤ䫠컊⠪䡾졈䡔呔戀拓癖瘆着着切偞된呜큜瑈瘀幀﹪繪縀繒噰幒穔呚눀幀︲幀﹪繪縀뫮ꪮ몤먀䡎郞䩎婄娀︨ﺪ﹜鑜瘀ꨪ⪶∾⊶ꪪ쨀⣾⫾ꢨ︪⩎蠀䡈䡨큐呔切鐾ᚾ㐴㺖隔ꐀ⠨䡈졈偐呔稀僞쩖囪䩒䘀檪㛲닺닲ኲ똀⠨⡄艼␤⑄谀࣮꺶ꚪ뛦਒؀ࣾ퓾퓜퓜ᐜ∀䡾哾呜呜퐜∀䡾퓾표呜呜戀呔푢䁞쩊剒⓾沶␐呔ဨ였ჾ䒪㱨밨籔簀哔푢쁞쫊퉒昀哾咒籔簨﹄舀呔铢䂞쩊퉒昀簐ﺒ똨䒾ᐤ䰀တ﹄䐨⠐⡄舀ﺪ몪뻪言︐ჾ銒꫆节蘀㐨織푾呔呔搀౰䁼䡈︀⡄舀幒廐婔幪ሀ됦着ჾ銖က︐呔တ︐တက됦着䓾䑄萀繈졾櫪扢昀䓾⠨ꩪ氨⠨︀⣾₴⛺꫺ꨀ朗닒똀뛤꒶ꢼ좈븀ၔ吐︐㠸咒က︐籄籄籄籄舀␾婚﹤瑞呴䐀瑞穎琐簐︀ࡾ䓾橺年萀︠粤㰀髺䩊牒剒똀됦着籄籄簀⣾⡼呾䑦呄言䡮둼呬䩬䡪츀㸠幒幪繪樀ჾ⢪ꩀ㡨ဨ였䡈䡾䁀籄䑄萀䡮듾䑼䁾橾ꨀ幀黒庐﹪樀빊ਊ૒剒晀븀鹐သዚ呤婀븀빒ḐỪ繪橀븀㸨繪﹪繈塈瘀梨㻪ꪪ噀븀䱔䓾ꪪ빔咴ꘀတ⓺␤︤⑄萀껴뻾廴娀㰴呜졾䡜屪䠀䪾䣾櫾⫾ꪪ䪾ࣾ櫾櫾ﺂ雾鋾훾횂︀䩾졾橾橪ၜ偐﹔阴ࠐዾჾ鋾鋾銒阀䩞橾橪樀䫾䣾櫪樀⣾䡾櫾푲渀⣾⡼䓾䒒簤찀⣾⡼䑼﹔먐簀⣾⡼䓾䒢₪怀ਈ繈䡊䩄䑌鈀⣾⡼䑼︨粪㠀籄呄﹄ꒄ︄᠀䡮됈븜鰄㺔谀⣾⠐簨︀籄簀呔繖홞幬汊娀⠼䡾푾橜䡾䠀䁾䊺ਊ穆䁂㸀籄䑼ჾး咒က⻺⫸幚﨤⨀ၼၼ⣾咺ၼကჾ艼တ簐ᐐ︀䱔䡶죜죜젾ࠀ鋾‼쐸홼ჾက鋾~婾婾婚똀ࡾ偞扚䩚偒鸀偞퉚橊偒䡜졾呾䡾저␤䩺婔呚눀တ︠‼␤䑄谀繚婾婚繚婚똀衈ᲈ䠾ࡈ傔먀遞ኺ䨊ᩖ傒鸀ჾ䑼|ࠐ　ꨀჾ剚䪊穖偲Ḁ噊蓊䒾푞푐渀꫶ꚤꪪ글⣾⠐︠㰤⑄谀⣾⣮ꫮꪮ☀⣾⢌合繈븀䙊꒮䑾쐀ჾ㱔﹜樐⫤㈀︈⣾꫾þ䑼⠨︀⻺⫼⨪飯ⱈ蠀䚪Ӻ䓮䓮쑾쐀䢮૶ꛤ골說籄籔籬籤籌글뫾몾늺똀౰ၼЈၐ恀븀တ﹀䁀䁀䁀㸀⠾呾繐幒昀⋺婚見牒剒瘀䑄廨䡎䩪쨊ᘀ䑄廨ꢮ쩊檪阀繢ﻢﻔ屔尀ჾ䁀䀼T䋊먀䡈ﻐ큐偐偐一︀繂繈繐幒ꘀ籄簨簨﹔㣖　⻺乊瘀簐簐︀䓾䑼䑼ჾ㡔鈀䡜졾哾䡾䠀ﺂﺂ﹄籄籄簀䑄黈䢮쩊嘀뻨ꢮꪪ똀꫼ꊾꪾꐀ퐾퐜퐜젾저⣞뉞뉲빬갬嘀床鋼䑼䑼䑼舀䢲Ỡ哾哤쐀뻈ꢮꪪ쪊阀࣪ꢾꢨꣴᐔ∀⸤︪긪︪⹐言⠨⣪Ⱘ⡨ꨪ⸀⨨織﹈屈織戀†‰⠤␠† 籔籔︀ꨐ簐︀橈﹔繈織⠨ⱪ窨⠨⠀僐푔哈䡔戀ࣼꣾ듦ꢼ㸀⣜呜壄堀⁞詺⫺⪺꨺츀⣸⻺驪⫺⨢昀鱔ᒦ射ᑈ䢔ꈀ䡪뺠渪⩊踀繢绠橪繈㸀屔졾呔昀ჾ⡔먐䓾䑄萀တ︐㠸呔먐က纪櫾檪籄䑤呔呄䑄蘀⠨䓾⑌|呔︀ࡾ呾呈繈繈頀ࡾ呾呾偞牒鸀ࡾ呾呾橾屚글ࡾ䁔織呼織鐀繪绪橾䡜절㸀䡈峨ꢾ졈岪蠀ࣨ벨꣨ᰪࠀ偐哔퓈䡔戀䁾聼哾咔︄᠀㻪뺪ꪾ꣼ࠈ㸀䡾졜哜퓾䁔戀⣾⡼䓾咒籔က꫾늾꒪눀䡾䣌쳌呔昀撤㻨껺껪ສꨀ幄쑄哖퓔呔縀檾⫾뫲뻤Ẵ가剒櫚쫎剒戀တ︨⡬檪⠨堀㰴呜쁾䡜䡔戀簄䑄⠨တ⡄舀䡈﹈䡜졈屪저တ︐ၼး咒က蠈㺈ࠜ࢈鲪蠀遞ာӈ偒乀븀㸲剞푢䡄䁜䈀⣾⣾銶鈀ࡾ呾呾扜繢븀︠‼␤␤䑄谀屔﹪織䡔戀鐾ᒾ࠾⪾뺢ꘀ鱔Ე㸪㹔䢔ꈀ⣾⡼䓾꫾⠐ࣨ벨ꢾ꣨ᰪࠀတ簐ჾး咒က䓮ꓤ뻤汶摠븀ﲄ蒄蓼肀节縀䡮둄﹄籄﹄舀繪橾절ࠀჾ鈤ꨰ銒︀ჾ鈤ꩰ﹔簔切蠾ࢾᑾ⋜뺔ꈀ⣾ჾ䓾䑼檤㈀⣔扜쁾䓀푲渀닼뒴뒴눀䡈峺ꪨ撨退䓘졎컸졊一籄䑼䡈繈䡤숀Ỳ닾뒴ﺴ듲ᨀ䣞䩊혀⣾⡼哾ꈼ搘䁾푔﹔哾Tꨀဤ塚偼逐︐က簄⠐︒㑐逐　簐ﺒ㛪⓪廊嘀ᓞ᫾ᩞ磞틪였䡾쁜哜죪橈堀幊䳶뺲庲阀䑞勾늾푖咲騀ﺂ籄籄簐﹄舀‼䒨ဠ红∢㸀ဨ䒺îꪪࠀ໪ꪮ껪਒☀|呔︀蠪࠾ࣜ屪䡀븀䢮ዪ䓨廪쩪츀Ӯꪮꪮ꣮Ȫ☀幄䣪뺤쑎撤鸀⢨갨㣨⨪⸀計组籔综풔ꨀ㠨䣼呔簨⩊踀䡜표哜죾橪䠀䡜铜咜졾䠀幄裞嚾홞帀︐⃾ꪺꪺꪪ︀廨延延并빀븀呾푾找졾䡔呾푾拾죾䡔戀⣾⠊繈䩊䑌鈀ჾ䁀簐︤栘簈ჾူ籔呔︀౰သỰဒḀ벤䡾졈峜屜븀ჾ䁼|䑼䑄簀繢뛾檾昀䓘䣎磈仸졊一⣾⣾艼ペⳊ　␴乴칸乺湺一တ︐㠸呔鈐ကﻨ䣨哢Tꨀ繂䉾䉂繂䉂縀ჾး咒|တ︀䁾檪⨪䪒ሢ䰀䪤Ừ꫾ꫪ說ᐐ︐᠘ᠨ⩊踀︀繂繈繈䡔ꈀ廪쩊쫪쩊嘀哾呜䁾䑼䑼舀몪ꪺ蘀銢蘀䡈뻔咔졈푔戀节节蘀䁾劒㈒ሪ♂谀ၐ噚狒噐䉂㸀࢈倔㨀屔钔ᰀჾ⠮削푈䡔戀⣆㣆癖盔᐀﹖癔噶噖瓔᐀ﺲ華뻶⑴␴찀큞棈鲚䡈䁀粐ჾတ⡄舀繀䁞剒噐剒鸀屔鐦屄푈䡔戀偞ꋂ劊쩂䰀⣾Ⴚ沺ჾ㡔鈀툞퐔퐔퓒ﺪ뻪幄䑎꒾꩎櫎਀噖盶呔搀⣾⢮喙ꫴ吺쨀咮໤仦哶홰䡔쁺橺橺樀ဨ粂瑔瑔Ê먀蠈㺪⨾⪪ꪪ븀ࡾ䣔繪頻䁲글젔쀺䣔拜샺櫺樀ᓴ뺴뺴듾ᐔḀ⠨繐큞牒剒帀㸨屔﹪呞瑈瘀簈籔籔簐︢츀တ︠㰤呔蠔戀ჾ鉼‼撼␤Ⰰ႒뛚ﺒ︀⠮嫪摪刀哊먀︐籄ﺒ撺栐屔織年쐀တ︠㱤밤㰤Ⰰ䡈﹪櫾橪縀븄㺪㸪㺈뺒ꘀ븄ࢾ⨾⪾ꪪꨀ뒨織븶皢㸢︀否풔切တﺒ鋾銒銒︀䑄︨䡎䩊一呔呔呔尀쐘젾ﰔ훒鐖㠖ዜ橊噀븀籄簀ﺒ鋾肂縀Ṫ⫼櫺櫺ⰸ저⨪﹌京ⱎ峼฀繚稊ﺔ鸀တḢ䊴ఈဠ쀀簄⠐︒ᐐတ　ဨ䒺ჾၔ劒　䁼䁀砈ࣾࠈ　合﹄먀簀籄簀嚺횺횺鋾D舀칊乊乀쨀␾摮摞噞嘀⠨⻊娪⩊鋲ᘀ∬⓴幔搤⩪鈀ჾꩄဨ䓾䑄簀ࡾ䡞䩾䡾檾ꨀ屔繐噪혀䙸屈﹈橪︀䡾쁒晼홤織Ừ뺪ﺤ꺴Ḁ屔绐噪嘀呾졜䣾죪屪堀鑈㺈䠜ࡈ纈蠀蠾⊔∈ᒢ鲔鰀䡾拔呢岔鰀繒剾剒繒剒阀ჾꩌ⡼ၼჾꨀ䐈︐ၼတ︐က㺪븪﹔幔幔鸀⣾哾呜䃾㡔鈀⣾ჾ꩔⡄﹄簀︨ﺪ︐︤栘옸︈︀꓾噞훖蘸⨾ࣾ䡪繀븀ﻐ險阀䓾ჾ⡔먨㐨瘀咆⩔葤樀哊먀偞橪案저呖訦呔葴婚爀葘࢈縈ࡈ咔ꈀ鐔⊈ᐔ⊜钔鰀ꩦꩦၼ⠨︀暪織簨﹄舀蠾⊜ࠈ⺨ꢨﺪ﹔鹔뻔廴帀繪ﺪ뺰䡪저繪︪繈﹨屪䠀ჾၔჾး咒က⣾⡰єࣾ㡔鈀⻴⻺꺪︪溰⨀簐ﺒ똀籔籔簀逜ᒨࠔ⊜钔鰀停铨䢔푔尀⣾ႜ㒈ᐢ鲔鰀䫴낮⣈䡈䣨ꪪ⻊ꪪꫪ꠨䠀鋾|呼呼呜똀癶櫾ﻪ繪戀됦グ☰\岜븀⣾籔︀⣾⣮ꫮ鋾몺혀ﱄ籄簪츀ቪ⨪飯⩲ꈢ☀ჾၼ呔籐〨였繂繈湚湦橤ꨀჾ㡔鉸ࣾတ　爪全ꘐ︸咒က﹪繪䡜절㸀졾呪䡾∀ࡾ䃊癖﹖穒阀ჾ呼呼ჾ檤㈀幖︶噞䑄帀籔籔呼ၼတ︀⫺庬⳾과踀죜좾퓦죜袈븀䡞訾䩞졜䡾䠀ჾႢၤ먐︐ကတ︄䑄␨⠈︀⣾⡞訾䣜䡾䠀䡾쁜呜졪橈࣮฀媚꫚≒諸爺蠾࢒㸀⪪ꪪ쨀阦⚪㘀㺪뺪븀졾䡒﹀橪䨀㻊說혀籔籔簀ࣾ䡒庀橪横䨀䣈﹄푔퓔졈縀듈뚨벨븀ၼ⠨﹔籔簒Ḁ⓶呖瑖瑔嘀㸲剞졈幒剒帀ࠎࡾ䡾橾呲글䡎婪견갪樀ࠎࡾ䡾橾繒ꘀ︄ࠐတတတ　ჾ䑼þ舨⡊踀⠾䡪푾呜䡪堀︐ჾ銒훖ﺂ蘀࢜䠾ᐦ停뒈㘀ჾ鉼ꩄ먨咒　䓔채쓆ﱄ䐀바똔감︸咒က蠾ᐜࢪꪈ頀ꪪ䑾꨾檾⨪쨀ࡾ䣾呢䡪頀ࣾ꣪듾뒼젪᠀⣜䡾푦僜瘀峔﹪ﻪ﹈縀ၼ䑼䑼䡊䑤숀젾쀜퐜젪蠾⨔㻔屪塀븀籄籄﹔籔簐︀죜좾퓦태뒈똀庨ỒỲ幒幀刀†︢∢≂䉂谀屄鳄纈堀⠴扜쁾橾橪樀繀繪繪繈屈븀␤︤⑬沶␤␀鐔纔ᐼ㳞钔鐀橈络呞沖ꐀ푔織푼籾퐔᐀ꣶ隐ﺪ꫺฀䣔拜샾櫪樀뻜ꪠ뒾ꐀ檨㻼ꫠ듾Ⲗꐀ䫨ꫠ퓞ꐀ홦晪繪︪㸀籔籔粂䒒簐︀鹀Ẓ帔Ṕ撊鈀籔籔籐⓾咒က긤︪纪⻺⹐言ဨ䒺þሒᘐက⠴扜쁾䩊䩈䠀∺剚婊剢䘀࢔戜>䩊誈ࠀ軺ꪪ뫚婒똀鋾交໪໪湀䨀䡔쁾䩊䩈䠀졔扜쁾䩊쨈ࠀ䡈䡈䩊一⣾ဨ䒺þሖက䢴ˬ䃾䫪쩨저䣾䫾૞࣪峪堀簐ﺒ똨粂簔က簐ﺒ똀︨ꨨ︀ꨐ織繤癤똀Ⓔꃶ¾횶織織織繢繢븀織織織䑖呔븀䩺媚刢≂蘀ၔ労࠰큾ሢ찀檪横䊆Tꨀ檪䊆ჾ檤㈀ࡾ呾噾噾呶鐀ჾ⢪꩘T䋊먀橈ﻜ呞汖搀ꐞҞᙾⒾ꒠䡾䣾橾䢜ꨀ䡮둾呾噾呶鐀䡾裾檾졜樀橴繴瑶␀⣾⢈㸜繈븀蠾࠾⫾䡾䡀븀䢾ࣾ櫾櫾졜籄䑼ဠﺂ节︀㡈ﱔ粪籄籄簀䱴峪屔尀幀廲틒幐傠ꀀ냮પ글ꫴ䑊쫪츀簐ﺒ㓦꫄滊合ﺒၼᐤ⑄谀ၼ哾呼哾␸였ࡾ䁖癴癶晬됀簐簐﹄䓾䑄萀仪ꫮꪪꪪ혀橈﹜櫈ﻔ塌爀噾滾汴䐀蠼Ⓖ␼⢪꒴븢㺠㸨㺪뻪ꨀჾ艐粐ჾတက꒾剞퉞哖呒騀䡮됐簨﹔簒Ḁတ稔︐⑸ꀢ㸀⛴囲哾䑼䓾Ѐ橪쒾ꪾ橪쨀仪ꫬꪪ겨တ︀⠨⑄䑂舀䓮䓮織繤癤똀屄繈橈堀뻪ꪪꪲꘀ岤᳄终櫜젔쀾㰨繜織塌爀ၮ⨪飯⩺ꨮ 순쐄︄쐞틒︐ご鉼ၜ偐︀ﺨ껪ສꨀꫪ뚠ꪪ똀૾࣪ꑴ쨀哊먀䡼푔曈죾䡈䠀⓾呴ꩼ䑾ʪ蘀︠‼⑔䑔ࠈ︀︀籄䑼䑄簀︀皶㛠고뻨ຢꘀ젾츸죊츀⣾ჾ⣾꨸︸혀⣾⡾䑮穼呤言䡾廪䡚渀蠾ᒶᰄ᱐庂蘀Ӿ剈亖癮摬ᘀ단꺶꒬똀"
    KNJLIB_FONTDAT$[3]=""

    IF FONT%==1 THEN
      ' 1: k8x12L (漢字は k8x12 と共通)
      KNJLIB_FONTDAT$[1]="          聀䀀   @ꂠ䀀    쁀耀    샀   ᠀   ᠀ ᠘  ᠀ ᠈က<䈂Ȍက တတက ꁐ倀    䂠ꁀ    ࠐ     ‐     ⠀     ဨ⡄    ︀          ︀ `ဈࠄЀ ਊ`ဈࠄЀ  `᠄Ȍ　 ਊ`᠄Ȍ　  $␤䡈  ဨ⡄艼တတ︀ ‼⑄蠰ဈ Ȃд䡈钤ꃀ耀 㡄节艄㠀   聾     ÿ      ᠀  Јࠐ†䂀 䀠‐ࠈЂ   悒ఀ  ᐔᐨ⠨⠨偐倀တတတတတက       D   @䁀    @䁀     ꂠ     ꂠ    ȄЈࠈࠈЄȀ聀䀠††䁀耀ؘတတတဘ؀쀰တတတူ쀀จࠈࠈࠈࠈ฀††††؈ࠈࠐࠈࠈ؀쀠†‐††쀀ȄЈࠐࠈЄȀ聀䀠‐†䁀耀ਔᐨ⡐⠨ᐔ਀ꁐ倨⠔⠨偐ꀀḐတတတ   တတတ㸢⸨⠨⠨㠀  㠨⠨⠨ฌఈࠈࠈఌ฀怠††恠 တჾတက   þ   တ︐တþ  艄⠐⡄舀  ကþ က   ︀︀   Ј︐︠䀀  ؘ悀怘؀  쀰ంర쀀 㣀㠆þþ À㠆㣀þþ  沒銒銒氀  က  䐀 㸆ਊቲ袈袈瀀㡄䑄䐸တ簐က悐遠    䁀耀    偐ꀀ    䂠걒††ሌ 䑄⣾ჾတ 粒遼ኒ簐 ࡼ銐鉼† 8䑀⁠ꉜ B꒨䠐␪䪄 ᑾ⠨⣼偐 0䡈値咈豲  ႒吸咒က 8䒒ꪪꪬ遄㠀㡄䀰䡄␘ф㠀တხ䐨⡔汄 တჾ簸㡼汄 8䒂节节䐸 8糾﻾﻾簸 8䒒ꪪꪒ䐸 ဨ⡄䒂䑄⠨ကး㡼糾籼㠸ကþ节节节苾 þ﻾﻾﻾﻾ တ⠨⡄䑄苾 တ㠸㡼籼﻾ þ艄䑄⠨⠐ကþﹼ籼㠸㠐က艔䐨⢒⠨䑔舀þ ︐တတ  ဈӾЈက  ဠ䃾䀠က း吐တတတကတတတတ吸က ﻾ þ︀ >䂀胾肀䀾 øЂ˾ȂӸ >䂀聀㸀þ øЂȄþ >䂀肀肀䀾 øЂȂȂӸ 节节节䐸 8䒂节节节 တ⠨⡄䑄节 艄䑄⠨⠐က  þȂȀ  ဈﰂﰈက  ⡄粂籄⠀ 节艼䑄⠨⠐က縂ȂɾȂȂ縀Єࠐ†䃾 တတတჾ 㡄舀    㡄Є㑌蒈袐怀þ쉄䑤⠨㠐က ︀þ ︀ @ ︀︀  ሤ䢐䠤ሀ  遈␒⑈退 Ḑဠ†⃠䁀䀀 䲒銒銒搀  沒邐邒氀  䐀  က ࠔတတတၐ ᐪ⠨⠨⠨⢨倀ဨ⠐⠨䑼节 @꒨倠咪⨔ Ф☼搤☼搤 ††ⰲ∢␨　ဘᰖሒᐐ烰怀တ簐တတတကတ簐တတ簐က㱴瑴琴ᐔᐔ᐀㡄节节节艄㠀<䉆䩒扂䈼 瀐တတၼ <䉂Ȅᠠ䁾 <䈂ȜȂ䈼 ఔᐤ䑾Є ~䁀硄Ȃ䐸 ⁀屢䉂䈼 ~Ȅࠈတတ <䉂䈼䉂䈼 <䉂䉆㨂и ဨ⡄䑼节 |䉂䉼䉂䉼 ≀䁀䁀∜ x䑂䉂䉂䑸 ~䁀䁼䁀䁾 ~䁀䁼䁀䁀 ≀䁎䉂∜ B䉂䉾䉂䉂 8တတတး ȂȂɂ䈼 B䑈䡐桄䑂 @䁀䁀䁀䁾 苆욪ꪒ銂 B扢削䩆䙂 <䉂䉂䉂䈼 |䉂䉼䁀䁀 <䉂䉂䉚携 |䉂䉼䡄䑂 <䉀䀼Ȃ䈼 þတတတတ B䉂䉂䉂䈼 艄䑄⠨တ 銒ꪪꩄ䑄 䑄⠐⡄䒂 䑄⠐တတ ~Ȅࠐဠ䁾   㠄㱄䐼 @䁀塤䑄䑸   㡄䁀䐸 Є㑌䑄䐼   㡄籀䐸 တ㰐တတ   㱄䐼ф㠀@䁀塤䑄䑄  တတတ  ࠈࠈࡈ　@䁀䑈偰䡄 0တတတတ   銒銒   塤䑄䑄   㡄䑄䐸   硄䑄础䀀  㱄䑄㰄Ѐ  塤䁀䁀   㡄〈䐸  †砠†␘   䑄䑄䰴   䑄⠨⠐   銒ꪪ䑄   䐨တ⡄   䑄⠨တ怀  簄ࠐ⁼   簠㱪ꪲ搀†簠⠼檪늢䰀  袄蒄꒠䀀蒄节芢ꁀ䀀 88䐄Ј　「<䈂ȂЈ　 8|ࠐ㡈踀〈|ࠐး䡈蘀  ⓲‼抢氀†‼≢ꊢ氀†⓴⩊䩈䢨退⨪⃴⩊䩈䢨退ࠈ簈︄㱄䀠ᰀਊ簈︄㱄䀠ᰀࠈဠ䁀‐ဈࠀࠈဪ䩀‐ဈࠀ҄뺄蒄蒄萈ကઊ뺄蒄蒄萈က 簀 @肀縀ਊ簀 @肀縀ࠈ︈м䑀䀠ᰀਊ︈м䑀䀠ᰀ䁀䁀䁀䁀䉄㠀䁊䩀䁀䁀䉄㠀ࠈ︈㡈䠸ࠈ　ਊ︈㡈䠸ࠈ　␤⓾␤Ⱐ†Ḁ⨪⓾␤Ⱐ†Ḁ|ࠐ⃾ဠ‐ఀ੺ࠐ⃾ဠ‐ఀ†乀䁈傐踀⨪乀䁈傐踀†ﰠ⁜戂Ȅ㠀⨪⁜戂Ȅ㠀  㣄Є࠰  㣄ȂȄ࠰ ਊ㣄ȂȄ࠰ þࠐ††‐ఀþࠐ⨪†‐ఀ††ⰰ䂀聀㸀⨪†ⰰ䂀聀㸀†䑄䒜␦᠀鲀肀肐ꂠ鸀ࡈ䡜橊ꪲ險䘀†Ⳳ∢扦ꨪ☀8呒銒銢ꉄ᠀҄蒾蒄蒜꒦頀ઊ蒾蒄蒜꒦頀Ҋ誾蒄蒜꒦頀è⑆䒄蒄葈　૪⑆䒄蒄葈　Ӫ⩆䒄蒄葈　〈တ䱊誊　㨊တ䱊誊　㐊ਔတ䱊誊　 ⁐偈蠄Ђ ਊ⁐偈蠄Ђ Њ⩔偈蠄Ђ ¾蒄뺄蒜꒦頀ા蒄뺄蒜꒦頀Һ誄뺄蒜꒦頀တ︐︐ၸ钒怀瀐ဤ㱤ꚤꑈက†悤꒢扂㰀ࡈ䡜橊ꪲ銢䰀တﰠ⃼•∢ᰀ H䠼‐က䡈峢∤†တက 룔钔렐 ဈ볊誊ꪜࠐ  လတ炘搀တသတၸ钒怀怘@䂼슂Ȅ㠀塤䑄䑄Јࠐ |ࠐ㡄舂㉌㠀†⳴␤摤ꐤ∀|ࠐ㡄舂Ȅ㠀  Ⳳ≢抢Ⰰ†Ⳳ∢扢ꈢⰀ瀐လ㉒劖ꪪ䐀簐㡄뉒㰠䒪鈀တﰠ犌ᠨ䡀㸀တဠ‰䡈䪊萀  ﰄ⠰†䀀þȒᐘတဠ䀀 ࠐバတကȂЈᠨ절ࠈࠀ  ⃼蒄ࠐ တﺂ舂Єࠐ   簐တჾ |တတတჾ  ࣼᠨ䢈᠀ࠈ︈ᠨ⡈蠈᠀တ︒ሒ∢≊萀ᨐ︒ሒ∢≊萀တ簐တ︈ࠈࠀᐔ簐တ︈ࠈࠀ†㸢䊂Єࠐ怀⨠㸢䊂Єࠐ怀䁀繈䢈ࠈတ 䩀繈䢈ࠈတ ~ȂȂȂɾ ੾ȂȂȂɾ ␤⓾␤␄Ј　⨪⓾␤␄Ј　`က숢Єࠐ怀੪က숢Єࠐ怀|Єࠈ᠔⑂舀੾Єࠈ᠔⑂舀†⃾∤⠠†Ḁ⨪⃾∤⠠†Ḁ䉂䈄Јࠐ ઀䉂䈄Јࠐ †㸢䊲ఄࠐ怀⨠㸢䊲ఄࠐ怀౰တ︐တဠ䀀੺တ︐တဠ䀀  ꑔ各ࠐ怀 ꉒ剒ȄЈ　ਊꁒ剒ȄЈ　| ︐တတ ੺ ︐တတ ††〨␠† ⨪†〨␠† တჾတတဠ䀀|   þ |Є␘ࠈᐢ쀀တ簄ࠐご鈐ကЄЄࠈတ⁀耀(␤␤䑂䉂舀ਪ␤␤䑂䉂舀Ъ⨤␤䑂䉂舀䁀䁀䱰䁀䁀㸀䩊䁀䱰䁀䁀㸀䑊䩄䱰䁀䁀㸀þȂЄЈࠐ怀૾ȂЄЈࠐ怀ӺਆЄЈࠐ怀 ⁐傈蠄Ђ ਊ⁐傈蠄Ђ Њ⩔傈蠄Ђ တჾတ呒鈐　ਚჾတ呒鈐　ᐚ᫼တ呒鈐　þȄш【ဈࠀ「 「 怜Ȁတဠ†䑄仲ȀЄѤ᠈ᐔ⑀耀|†⃾††Ḁ  ⻲␠တက†㻢␨‐တက  砈ࠈࣾ xࠈࠈࠈࣾ   簄мЄ簀~ȂȾȂȂ縀| ︂ȄЈ　䑄䑄䑄Јࠐ ࠨ⠨⠨⩊䩌蠀䁀䁀䁂䉄䡐怀~䉂䉂䉂䉾   ﲄ萄ࠐ þ节舂Єࠐ ࠈ﹈䡈䣾ࠈࠀ|Јတတჾ þȂ縂Єࠐ怀䀠ȂЄ࠰쀀⨠ﺂ舂Єࠐ   ⃼␤䑄谀  ‾䢈ࠐ ဨ⡄䑼节 |䉂䉼䉂䉼 ~䁀䁀䁀䁀 ဨ⡄䑄苾 ~䁀䁼䁀䁾 ~Ȅࠐဠ䁾 B䉂䉾䉂䉂 <䉂䉚䉂䈼 8တတတး B䑈䡐桄䑂 ဨ⡄䑄节 苆욪ꪒ銂 B扢削䩆䙂 ~ < ~ <䉂䉂䉂䈼 ~䉂䉂䉂䉂 |䉂䉼䁀䁀 ~䀠ဈဠ䁾 þတတတတ 䑄⠐တတ 粒銒銒簐 䑄⠐⡄䒂 呔吸တတ 8䒂节艄⣮   ᨦ䑄䠶 ሒⰢ∢局䀀  ㉌ࠈࠐက∐ᠤ䑄䠰   ᰢᠠ䈼 ,ᠠ⁀䁀㠄᠀  ⱒሢ␤Ѐ∢䉾䉄䐸   တဠ⠐   ∤⠸䡆 0ࠈࠔᐤ≂   ␤␤婀耀  䈢␤⠰ ,ဠᠠ䁀㠄᠀  ᰢ䉂䐸   㹔ᐤ⑆   ᰢ∢局䀀  Ḥ䑄䠰   㹈ࠐᐈ   ㉒ሢ␘ ࠈ粒銒簠   搘တぐ谀ࠈ劒銒簠   ⑂銒鉬 ဨ⡄䑼节 |䁀䁼䉂䉼 |䉂䉼䉂䉼 ~䁀䁀䁀䁀 <␤␤⑄䓾舀~䁀䁼䁀䁾 ␀繀䁼䁀䁾 呔吸呔咒 <䈂ИЂ䈼 B䙆䩒剢扂 ␘䉆䩊剢扂 F䡈偰䡄䑂 >∢∢∢⋂ D䑄ꪪꪒ銂 B䉂䉾䉂䉂 <䉂䉂䉂䈼 ~䉂䉂䉂䉂 |䉂䉼䁀䁀 ≀䁀䁀∜ þတတတတ B∤ᐈࠐၠ 粒銒銒簐 䑄⠐⡄䒂 D䑄䑄䑄䑾ȀB䉂䉆㨂Ȃ 銒銒銒鋾 銒銒銒鋾ȀÀ䁀硄䉂䑸 节誊鋢 @䁀硄䉂䑸 8䐂ȾȂ䐸 ꊢꋢꊢꊜ >䉂䈾ሢ≂   㠄㱄䐼 ぀塤䑄䐸   硄硄䑸   籀䁀䁀   㰤␤⑾䈀  㡄籀䐸  ⠀㡄籀䐸   鉔㡔咒   㡄᠄䐸   䑌呔摄  ⠐䑌呔摄   䱐偰䡄   㰤␤Ⓞ   䑬汔呄   䑄籄䑄   㡄䑄䐸   籄䑄䑄   硄䑄础䀀  㡄䁀䐸   簐တတ   䑄⠨တ怀 တ粒銒簐က  䐨တ⡄   䑄䑄䑾Ȁ  䑄䐼Є   銒銒鋾   銒銒鋾Ȁ  怠㰢∼   䉂牊䩲   䁀硄䑸   㡄ᰄ䐸   䱒牒剌   㱄䐼⑄   ÿ   တတတတတတ  တတတ  ðတတတတတჰ   တတဟ   တတဟတတတ  ÿတတတတတჰတတတတတჿ   တတჿတတတ  ÿ＀  ᠘᠘᠘᠘᠘᠘  Ἐ᠘᠘  ø᠘᠘᠘᠘᣸  ᠘᠘᠟ἀ  ᠘᠘᠟Ἐ᠘᠘  ÿ８᠘᠘᠘᠘᣸᠘᠘᠘᠘᣿＀  ᠘᠘᣿８᠘᠘᠘᠘᠟᠘᠘᠘  ÿ０တတ᠘᠘᣸᠘᠘᠘တတჿ＀  တတჿ０တတတတဟἐတတ  ÿ᠘᠘᠘တတჰတတ᠘᠘᣿   ᠘᠘᣿᠘᠘᠘㡄銲銒銒鉄㠀㡄銪誒銢멄㠀㡄銪誒說鉄㠀㡄誚ꪪ몊詄㠀㡄몢늪說鉄㠀㡄銪ꊲꪪ鉄㠀㡄몪誒銒鉄㠀㡄銪ꪒꪪ鉄㠀㡄銪ꪚ說鉄㠀㡄芮ꪮ艄㠀㡄芦ꚦ艄㠀㡄芮ꪮ艄㠀㡄芮ꚮ艄㠀㡄芪꺦艄㠀㡄芮ꚮ艄㠀㡄芪꺮艄㠀㡄芮ꪪ艄㠀㡄芮꺮艄㠀㡄芮ꚮ艄㠀㡄苮ꫪ쫮艄㠀တတတတ (⠨⠨⠨⠨ T呔呔呔呔 ¢ꊢ钔钔袈 D䑄⠨⠨တ 誊剒剒∢ ªꪪꪪꪪ䩊 ªꪪꪪꪪ橪 ¢ꊔ针钔ꊢ D䐨⠐⠨䑄 怀ሒሂఀ䃰䃰 ḒሒḀ裤ꂂ耀₠亠耀蒌阀噰阒搀䁀䂐肀耀ဈȄ᠀湀耀₠ꂠ뀀䑆ꪢⰀ撬籌阀ꂠ긢䰀蒌阀⸢䰀肀耀仪檪글ꂠ긠䀀낀耀Дᐔᘀ裤ꂂ肀耀倨낦ꀀ铤Ꚍ퐀樂搬벬글偨낦 퀀퀠쀀  쳮ꪪ   䲮躎ꩊ 肀겮컎ꪪ   웪ꊪЀ肀ꚪ쫆ꊪЀ  䒪袈ꩄ ؂؄효ꢨꢨ 䓮䳮䱌刀ᐔਊ        ꁐ倀郐풺몚骔 ªꪪ쳌ꪪꪪ à䁀瑤瑤摶 㡄銒骒鋾艄㠀㡄鋾훖ﺒ鉄㠀㡄苾銚銒鉄㠀㡄ꋺꊺ튒멄㠀㡄ꋺꊺ멄㠀䒂닾꫾ꪂ䐀䒂ꋺꊺꪂ䐀䒂꺪뻪ꪪꚂ䐀橢桮溮글乄䓤䑎䱌견글汤蹮汤搀@ ︀︀  ︀þ ︀ ࠔတတတၐ ࠔး呔吸ၐ 繀‐ࠄࠐ⁀縀Ḑဠ†⃠䁀䀀တတတჾ Єࠐ†䃾 肀肀肀胾 ؊਒∢䋾  䐀  က 8䒂节节节 节节节䐸 "
    ELSEIF FONT%==2 THEN
      ' 2: k8x12S (漢字は k8x12 と共通)
      KNJLIB_FONTDAT$[0]="   䑄@"+CHR$(10)+"ꀀ "+CHR$(10)+"꺪桂ⱀɈȀꩄꡠ䀀 䑄䐠䑄䒀  ю䐀  Ҁ    @⑄䢀ꫪꩀ쑄䓠ꨤ䣠ꉂꩀ暪貢ꩀ꣊ꩀꉄ䑀ꩊꩀꪦ⩀ ЀЀ ЀҀ Ɉ䈀 à ࡂ䠀ꉄ@ꫪ졠ꪮꪠ꫊ꫀꪈꩀꪪꫀ裈裠裈袀ꢊꩠ"+CHR$(10)+"ꫪꪠ䑄䓠∢ꩀ"+CHR$(10)+"꫌ꪠ袈裠"+CHR$(10)+"ꪠꪪꪠꪪꩀꪬ袀ꪪ꫊ꪠꡂꩀ䑄䑀"+CHR$(10)+"ꪪꫠ"+CHR$(10)+"ꪪꑀ"+CHR$(10)+"ꪮ"+CHR$(10)+"ꩄꪠ"+CHR$(10)+"ꩄ䑀≄裠䑄䑠葄䈠䑄䓀ꀀ   à䀀  Â橠裊ꫀ h衠≪ꩠ J䓤䑀 j拀裊ꪠD䑀Ȣ⩀袪쪠䑄䑀 Î Êꪠ Jꩀ Ê검 j꘠ ¬袀 h䋀 䓤䑠 ªꫠ ªꑀ ª ª䪠 ª拀 â䣠䒄䑠䑄䑀䐤䓀 Æ   䩀袈  "+CHR$(34)+"⋠  ࡀ @  ⒀ æ䒀 $쑀 Nꉀ 䓠 .橠 N摀 䓠 â拠 î⒀   䒀Ⓞ䑀⒀ 一ꉠꉠ䑀樢⒀䒀 ⸀"+CHR$(10)+"⒀䡀⒀ 䪠裠"+CHR$(10)+"Ꙣ⒀檦⒀쓤䒀 ⒀ 䒀裊袀乄䒀 ฀ 䪠∢䒀⊪ꪠ躈衠 䒀 䒪∀ 䐠⁂ఠ䒈긠⩄ꢀ 䑠䑀 쑄一 ⋠ ⒀"+CHR$(10)+"ꪢ≀䳌컀袊검 ꫠ ⒀ 萀⒀"+CHR$(10)+"ꀀ ꐀ 䥂"
      KNJLIB_FONTDAT$[1]="          䀀    䂠䀀    쁀耀    À쀀   ᠘    ᠀᠀  ᠘ ᠈က <䈂ఐ က တတ က  倀    @ꁀ    က     က    (     ⡄    þ         ︀  ‐ࠄЀ "+CHR$(10)+"਀‐ࠄЀ   怐ࠄర "+CHR$(10)+"਀怐ࠄర   $␤䠀 ဨ⡄艼တတ︀ ‼⑄蠰ဈ Ȃд䡈钤ꃀ耀 㡄节艄㠀   縀     ＀         Ȅࠐ⁀耀  聀‐ࠄȀ  `鈌   ᐨ⠨⡐倀 တတတက   鈀     䐀   @䀀    @䀀     ꀀ     ꀀ    ЈࠈࠄȀ 䀠†⁀耀 ᠐တဘ؀ À【တူ쀀 ࠈࠈࠈ฀ à††† ࠈဈࠈ؀ À†ဠ†쀀 ЈဈЂ  䀠ဠ䂀  "+CHR$(10)+"ᐨ倨ᐊ   倨ᐨ傠  တတက   တတ >∮⠨⠸   㠨⠨ ఈࠈࠌ฀ à怠†⁠ တ︐တ    ︀   ჾတ ︀ 䐨ဨ䒂   ︀   þþ   ࣾჾ⁀  ᡠ聠᠆  À「Ȍダ  㣀㠆︀︀ À㠆㣀︀︀  沒銒鉬   က D  ؊犈袈瀀 8䑄䐸ၼက @ꁀ    @耀    Pꀀ    @걒တဒఀ 䐨︐︐က 粐簒鉼က 㱊䡐刼က 8䑀悢尀  䊤䠐⑊萀 ᑾ⠨ﱐ倀 0䡐⁔针瘀 鉔㡔鈐  8䒚ꪪ鑀㠀 8䐰䠤ᡄ㠀 ხ䐨㡬䐀 ჾ簸㡬䐀 8䒂节艄㠀 8糾﻾ﹼ㠀 8䒒ꪪ鉄㠀 ⡄节䐨က 㡼﻾簸က þ节节苾  þ﻾﻾﻾  ဨ⡄䒂︀ း㡼糾︀ þ艄䐨⠐က þﹼ簸㠐က 䐨鈨䒒  þ ︐တက  ࠄ︄ࠀ   ⁀﹀   㡔တတက တတ吸က  ﻾ ﻾   㹀胾聀㸀  ˾Ȅ >䂀聀㸀︀ øЂȄ︀  㹀肀䀾   ȂӸ  节节艄㠀 8䒂节节舀 ဨ⡄䒂舀 艄䐨⠐က   ︂Ȁ   ࣼ˼ࠀ   ⡼艼⠀  艼䐨⠐က ~Ȃ縂Ȃ縀  Ȅࠐ⁀︀ တတတ︀ |舀    ␄㑈袐怀 þ쉄搨㠐က þ ︀þ  @þþ   ⑈遈␀   䠤ሤ䠀  ဠ†䀀  䲒銒鉤   沒邐鉬   䐀   ᐐတၐ  ⨨⠨⢨倀 ⠐⠨䑼舀 Dꡐ⁀鐪᐀ ☼搦㱤   ‬㈢␨　 ᰖሔ烰怀 㠐တတက 㠐တးက <瑴㐔ᐔ᐀ |节节节簀 <䉆䩒扂㰀 瀐တတ簀 <䈂И⁀縀 <䈂ᰂɂ㰀 ఔ⑄縄Ѐ ~䁸䐂Ʉ㠀 ⁀籂䉂㰀 ~Ȅࠈတက <䉂㱂䉂㰀 <䉂䈾Ȅ㠀 ဨ⡄粂舀 |䉂籂䉂簀 ≀䁀䀢ᰀ x䑂䉂䉄砀 ~䁀籀䁀縀 ~䁀籀䁀䀀 ≀䁎䈢ᰀ B䉂繂䉂䈀 8တတတ㠀 ȂȂ䉂㰀 B䑈偰䡄䈀 @䁀䁀䁀縀 웆ꪪ銒舀 B扒削䩆䈀 <䉂䉂䉂㰀 |䉂䉼䁀䀀 <䉂䉂婤㨀 |䉂䉼䡄䈀 <䉀㰂ɂ㰀 þတတတက B䉂䉂䉂㰀 艄䐨⠐က 銒ꪪꩄ䐀 䐨တ⡄舀 䑄⠐တက ~Ȅࠐ⁀縀   㠄㱄㰀 @䁀塤䑄砀   㡄䁄㠀 Є㑌䑄㰀   㡄籀㠀 တ㰐တက   㱄㰄㠀 @䁀塤䑄䐀  တတက  ࠈࡈ　 @䁀䡐灈䐀 0တတတက   銒鈀   塤䑄䐀   㡄䑄㠀   硄础䀀   㱄㰄Ѐ   塤䁀䀀   㡀㠄砀  †砠․᠀   䑄䑌㐀   䑄⠨က   銒ꩄ䐀   䐨ဨ䐀   䐨⠐怀   簈ဠ簀   砠碴搀  簠㱪ꪲ搀   袄蒠䀀  袄节芠䀀  88䐈　 <<䈂Ȅ㠀  8xူ尀 8|ࠐ㡈踀   碤栀  ‼抢氀  ⃴⩊䡈뀀"+CHR$(10)+"ਠ⃴⩊䡈뀀 簈︄㱀㰀"+CHR$(10)+"ਐ簈︄㱀㰀 ဠ䁀‐ࠀ"+CHR$(10)+"ਈဠ䁀‐ࠀ 蒾蒄蒈က"+CHR$(10)+"઄蒾蒄蒈က  簀 䂀縀"+CHR$(10)+"਀簀 䂀縀 ︈Ѽ聀㠀"+CHR$(10)+"ਐ︈Ѽ聀㠀 @䁀䁀䉄㠀"+CHR$(10)+"ੀ䁀䁀䉄㠀 ︐㡈㠈　"+CHR$(10)+"ਐ︐㡈㠈　 $⓾␬†Ḁ"+CHR$(10)+"ਤ⓾␬†Ḁ |ဠ︐†ᰀ"+CHR$(10)+"੼ဠ︐†ᰀ  䁀䢐踀"+CHR$(10)+"ਠ䁀䢐踀  ﰠ屢Ȅ㠀"+CHR$(10)+"ਠﰠ屢Ȅ㠀   㣄Ј　  㳂Ȃи "+CHR$(10)+"਀㳂Ȃи   ︐†‐ఀ"+CHR$(10)+"਀︐†‐ఀ  ․㡀肀縀"+CHR$(10)+"ਠ․㡀肀縀  䑄鰦᠀ 鲀肀邠鸀 䡜檪뚪䘀  Ⳳ∢暪☀  㡔銒ꉄ᠀ 蒾蒄鲦頀"+CHR$(10)+"઄蒾蒄鲦頀Њ҄蒾蒄鲦頀 è⑆蒄葈　"+CHR$(10)+"૨⑆蒄葈　ЊӨ⑆蒄葈　 0ࠐ၌䪊　"+CHR$(10)+"ਰࠐ၌䪊　Њаࠐ၌䪊　  ⁐傈Ђ "+CHR$(10)+"਀⁐傈Ђ ЊЀ⁐傈Ђ  ¾蒾蒄鲦頀"+CHR$(10)+"ા蒾蒄鲦頀ЊҾ蒾蒄鲦頀 ︐︐碔戀 pန㱦꒤䠀  悠ꉂ㰀 䡜檪늢䰀 ﰠﰠ∢ᰀ  磄䠠  H峢∤‐က  Ⴘ풔렐  볊說鰐   ᰐ炘搀 သတ碔戀 pࡀ糂舄㠀 X摄䑄Ј　 |ဠ粂㉊㰀  ⳴␤撦␀ |ဠ粂Ȅ㠀  @䓄堀  Ⳳ∢抢Ⰰ pလ㉒險䘀 |း䐘⁬鈀 ﰠ皘⡀㸀 ဠ⁰䢊谀   簔᠐  þȔ᠐ဠ䀀  ࠘栈ࠀ Јᠨ절ࠀ  籄Ј　 ﺂ舄Ј　   㠐တ簀  簐တჾ   簘⡈᠀ ︈ᠨ䢈᠀ ︒ሢ≊萀"+CHR$(10)+"ਐ︒ሢ≊萀 簐ჾࠈࠀ"+CHR$(10)+"ਐ簐ჾࠈࠀ  㹂舄И怀"+CHR$(10)+"ਠ㹂舄И怀 @繈蠈ࠐ "+CHR$(10)+"ੀ繈蠈ࠐ   縂ȂȂ縀"+CHR$(10)+"਀縂ȂȂ縀 $︤␤Ј　"+CHR$(10)+"ਤ︤␤Ј　 `Ⴢ∄И怀"+CHR$(10)+"੠Ⴢ∄И怀  簄Јᠤ숀"+CHR$(10)+"਀簄Јᠤ숀  ⃾∤†Ḁ"+CHR$(10)+"ਠ⃾∤†Ḁ  艂䐄ࠐ "+CHR$(10)+"਀艂䐄ࠐ   㹂눌И怀"+CHR$(10)+"ਠ㹂눌И怀 瀐︐တ "+CHR$(10)+"਌瀐︐တ    呔Ј　  ꉒ刄Ј　"+CHR$(10)+"਀ꉒ刄Ј　 |þတတ "+CHR$(10)+"੼þတတ   †㠤† "+CHR$(10)+"ਠ†㠤†  ჾတဠ䀀  簀 þ  |Ф᠈ᐢ쀀 簄ࠐ㓒က Єࠈဠ쀀  ⠤⑄䉂舀"+CHR$(10)+"਀⠤⑄䉂舀ЊЀ⠤⑄䉂舀 @䁆础䁀㸀"+CHR$(10)+"ੀ䁆础䁀㸀Њр䁆础䁀㸀  ︂Єࠐ怀"+CHR$(10)+"਀︂Єࠐ怀ЊЀ︂Єࠐ怀  ⁐䢈Ђ "+CHR$(10)+"਀⁐䢈Ђ ЊЀ⁐䢈Ђ  ︐ၔ鈒　"+CHR$(10)+"ਐ︐ၔ鈐　ЊА︐ၔ鈐　  ︂ш【ࠀ 8Ѐ㠄p฀ ဠ†䡄切 Ѥ᠈ᐤ쀀 |†︠†Ḁ   㳤‐က  㻢␠တက   瀐တﰀ  砈ࠈࣾ    砈㠈砀 ~Ȃ㸂Ȃ縀 |þȂЈ　 D䑄䑄Ј　 ⠨⠪䩌蠀 @䁀䁄䡐怀  繂䉂䉂縀   籄Ј　  ﺂ舄Ј　 ﹈䡈︈ࠀ  簄ࠐჾ  ~Ȃ㸄Ј　  쀢Ȅ࠰쀀"+CHR$(10)+"ਐﺂ舄Ј　  簔␤䰀  @粐တ  ဨ⡄粂舀 |䉂籂䉂簀 ~䁀䁀䁀䀀 ⠨䑄䒂︀ ~䁀籀䁀縀 ~Ȅࠐ⁀縀 B䉂繂䉂䈀 <䉂婂䉂㰀 8တတတ㠀 B䑈偨䑄䈀 ⠨䑄䒂舀 웆ꪪ銒舀 B扒削䩆䈀 ~ 㰀 縀 <䉂䉂䉂㰀 ~䉂䉂䉂䈀 |䉂䉼䁀䀀 ~‐ࠈဠ縀 þတတတက 䑄⠐တက 粒銒鉼က 䐨တ⡄舀 呔吸တက 8䒂节䐨   ᨤ䑈㘀 ሜ␢≜䀀   ㉌ࠐက ∘⑄䑈　  ␐⁄㠀 ,ဠ䁀㠄᠀  ,划␤Ѐ ∢繂䑄㠀   တ က   ␨ぐ䰀 0ࠈࠔ␤䈀   ␤⑚䀀   䐤␨　 ‸䁀㠄᠀   ᠤ䑈　   㹔ᐤ䘀   ᰢ≜䀀   Ḥ䑈　   㹈နࠀ   搤䑈　 Є㱊䨼က   ㈌ᠨ䘀 Ј⩊䨼က   ⑂銒氀 ဨ⡄粂舀 |䁀籂䉂簀 |䉂籂䉂簀 ~䁀䁀䁀䀀 <␤⑄䓾舀 ~䁀籀䁀縀 $繀䁼䁀縀 呔㡔呔鈀 <䈂ᰂɂ㰀 B䙊䩒剢䈀 $ᡂ䙊剢䈀 F䡈偨䑄䈀 >∢∢∢숀 D䒪ꪪ銒舀 B䉂繂䉂䈀 <䉂䉂䉂㰀 ~䉂䉂䉂䈀 |䉂䉼䁀䀀 ≀䁀䀢ᰀ þတတတက B∤ᐈࠐ怀 粒銒鉼က 䐨တ⡄舀 D䑄䑄䑾Ȁ B䉂䘺ȂȀ 銒銒銒︀ 銒銒鋾Ȁ À䁀硄䑄砀 节誊 @䁀硄䑄砀 8䐂㸂Ʉ㠀 ꊢꊢ鰀 >䉂䈾ሢ䈀   㠄㱄㰀 ぀硄䑄㠀   硄硄砀   籀䁀䀀   㰤⑾䈀   㡄籀㠀  ⠀㡄籀㠀   鉔㡔鈀   㡄ᡄ㠀   䑌呤䐀  ⠐䑌呤䐀   䱐灈䐀   㰤␤쐀   䑬呔䐀   䑄籄䐀   㡄䑄㠀   籄䑄䐀   硄础䀀   㡄䁄㠀   簐တက   䐨⠐怀  တ㡔吸က   䐨ဨ䐀   䡈䡼Ѐ   䑄䰴Ѐ   呔呔簀   呔呾Ȁ   怠㠤㠀   䉂牊爀   䁀硄砀   㡄᱄㠀   䱒牒䰀   㱄㰤䐀   ＀   တတတက   ἐတက   တက တ   တἀ   တἐတက   ０တက တတက တ＀   တ０တက   ￿   ᠘᠘᠘᠀   ἟᠘᠀   ᠘᠀ ᠘   ᠘἟   ᠘἟᠘᠀   ￿᠘᠀ ᠘᠘᠀ ᠘￿   ᠘￿᠘᠀ ᠘Ἐ᠘᠀   ￿တက ᠘᠘᠀ တ￿   တ￿တက တ἟တက   ８᠘᠀ တတက ᠘＀   ᠘８᠘᠀ |銲銒銂簀 |늊銢몂簀 |늊銊늂簀 |誚ꪺ誂簀 |몢늊늂簀 |骢늪銂簀 |몊銒銂簀 |銪銪銂簀 |銪骊늂簀 |껪ꪪ꺂簀 |ꛮꚦꚂ簀 |껦꺪꺂簀 |껦꺦꺂簀 |ꫪ꺮Ꚃ簀 |껪꺦꺂簀 |ꫪ꺮꺂簀 |껦ꪪꪂ簀 |껮ꚮ꺂簀 |껮꺦꺂簀 |簀 တတတက (⠨⠨⠨⠀ T呔呔呔吀 ¢ꊔ钔针蠀 D䐨⠨⠐က 詒剒刢∀ ªꪪꪪꩊ䨀 ªꪪꪪꩪ樀 ¢钔袈钔ꈀ D⠨တ⠨䐀 à`૪ਂЀ @ਊ฀ 豠耀  亠铔阀 vꀮ䈌䂐 胠貀ఀ ð偮耠ꂠ뀀 FꨢѬ뱌阀  긢䂄铔阀 àꀮ䉀恀䀀 N글ꂮ  °胠蒔ᐔᘀ 豠胠耀 °뚠퐀 ê樊Ⲽ글 PꘐÐ쀠쀀   쳮ꨀ   沎躎樀 肀겮캮ꨀ   웪가 肀ꚪ욢가   暈袈昀 Ȇ풮ꢨꠀ ä们刀 ᐊ       ꁐ倀 郐풺몚鐀 ªꪪ쳌ꪪꨀ à䁀瑤瑤瘀 |銚銒ﺂ簀 |鋾훾銒簀 |苾銚銒簀 |ꋺꊺ튺簀 |ꋺꊺ簀 D닾꫾氀 Dꋺꋺꪺ氀 Dꪾꫪꪪ搀 j溮글 N䓤乌䲬글 lꚎ湤搀 @þþ  þ ︀þ  ᐐတၐ  း呔㠐怀 ~‐ࠈဠ縀 ဠ†䀀 တတတ︀  Ȅࠐ⁀︀ 肀肀肀︀  Ȇ਒≂︀  䐀   8䒂节节舀 节节艄㠀"
    ENDIF
  ENDIF

  ' ……………………………………………………………………………………………………………

  ' 3: k6x8
  IF FONT%==3 THEN
    GKNJDEFINIT 6,8
    KNJLIB_FONTDAT$[0]="  䤠耀됀 뻟䀀弾耀Ⴈ䀀唽쀀倀 ⤤蠀褤ꀀ嵐 ॴ耀 倀p  耀¨ ૺ耀ଥ쀀ᢩ쀀ᢣ耀מ䀀ṣ耀๪耀Ფ耀પ耀ળ耀Ą ą Մ䀀Ύ ᄕ 咠耀咺耀囻䀀흛耀版쀀훛耀쀀 牚쀀뛻䀀쀀⒚耀띛䀀鉉쀀뿛䀀훛䀀囚耀훩 囚蠀훫䀀焓耀耀뛛쀀뛝 뛿䀀딫䀀딤耀쀀椤頀ꮮ耀줤뀀吀  㠀䐀 ǚ쀀鍛耀ǈ쀀◚쀀Ǹ쀀殤耀ǖ瀀鍛䀀䄤耀䄤ꀀ鋫䀀줤耀Ϳ䀀͛䀀Ś耀͛ꀀǚ저˩ ǧ耀த쀀˛쀀˝ ˟쀀ʥ䀀˖瀀Ε쀀⥄蠀䤤退褔ꀀ *耀 ғ쀀耀   ε ¬耀ź䀀u쀀÷䀀Ŷ耀e쀀γ쀀ϳ耀Ȱ  ╤耀庒耀ᴥ쀀㲺䀀嶻䀀嵴耀井 鼥 Დ쀀뺕 쌃耀䀀黙쀀궕 亵  ᾓ耀 鍙 䮥 ఁ쀀䀀岮耀⒕ 䛛䀀鏈쀀 䫒 嵾耀䀀ᰱ쀀䥋쀀㔫 쀀嶴耀줥쀀쀀耀뚒耀䭭쀀鉋耀ớ쀀 쀓耀ꀀ 唀 䥂"
    KNJLIB_FONTDAT$[1]="    Ѐ B萀 Áࠀ ఀ ᡠ Ɔa耀Ɔ`萀爠谠Ȁ₂ࠠȀꅀ  䊄  ႀ  䂀  倀  ⅀      ྀࠐ䀀⠄ࠐ䀀ĂИ耀⤂И耀鉊䀀ⅈ鰠辀ć銐脀ࡅ⢣䠀⊉쀀Ḁ  㼀  ᰀ !ࡂ Ȅࠐ ⨐ 充ᑑ䔀₂ࠠ舀 ⨀  ␀ ࡁ耀 섈  ⥇耀   ࡂࠠ䂀脂ࠡࠀᦄ၁膀상А찀㢂ࠠ莀ࠠ踀ᢂဠ膀삂Р谀ࡂဠ䂀脂СࠀႥ⡐ꄀ䊅੒萀㢂ࠠ ࠠ踀礥鑑쀀ǅᓒ伀㣂ࠠ쎀ࠡ踀㸠耀 㸀 ₏蠠ྀȥࡒ 㸀耀胸 O裹 f⁠怀̃ȳ ᦈ᠘ྀ샀賀ྀŊꪩ䀀 㡢颒䘀爨鰣䊄  䄈  兊  䋄遁⌀襏裸舀⇪ᰫ숀ᇊꢩ쐀ㄤ㰣관쌡ࡂ憀句ᑓⅅᢪ䚀鲨耀爫ꪲ✀㤃ሰ✀₏鑳梀₏鱳梀ǈꊉ쀀Ǐ뻹쀀Ǌ뚩쀀≐耀㹰耀Ϩꊋϯ뻻ᑓᱳϥᐠ耀ϧᰠ耀ʥ⩒ꀀϠ㸠舀㸐耀㹀耀⇊蠠舀₂ࢩ숀ϯ胻Ǩ㺁π븋쀀稈⁸ྀ苰ྀǨ₁π舋쀀Ȩꊉ쀀ǈꊊ ₅ᒊ Ȩ鑐舀 㸈 ˰耀Ň≱䀀訧ᑐ舀븈⾀!ࡃࠣ爠  ㄠ骒䘀逸ᑐ舀Ϡ㸃䀏胸Ā¥⡐ꀀʅ੒耀㢂ࣁЀJꪩ Ŋꢩ䀀Ƞ 耀⅄ࠑ䈀努ᐪꔀ⅂ᑓ쭂ႃ涀ᅧ㙳䐀䄅ᩉ䘀⃂詣谀⇂ࠠ舀⇂ࠡ숀箮騨ꊀ爨ꊊ✀爩꫊✀ↂࠠ蜀爠豂ྀ爠谊✀Ⴥ⓸䄀﨏∊✀爨㲊✀ࠡЀ爨鲊✀爨鸊✀₅ᑲ⢀벊⼀ㄨ₁⌀ꊊ一行㲂ྀ行㲂ࠀㄨ⚉⌀訨뺊⢀炂ࠠ蜀ࠠ舊✀詊ア䢀興₂ྀ設ꪪ⢀訬ꪚ⢀爨ꊊ✀벂ࠀ爨ꊪ䚀벢䢀爨ᰊ✀ࠠ舀訨ꊊ✀訥ᑐ舀ꪪ꩑䔀襅ࡑ䢀襅ࠠ舀ࡂྀȹ⎀䄇቉✀ቁ⌀ࠣ鉉⎀ቹ̀ᢇࠠ舀鈸⌀䄇቉⒀ ࠠ舀ခА䘀䄄鑡䒀悂ࠠ舀⪪ꪀ቉⒀቉⌀ቱЀ鈸₀顁Ѐ逰✀蠠膀鉉⎀鉉䈀"+CHR$(10)+"ꪩ䔀鈱⒀鈨䘀舐螀ੲ⇂鲺ꒀ	⊊萀Ɉꊊ萀Àై䈀瀇∈䘀Àᰐ薀瀏С䦀Ď遳─厤᳋─䅎陒䨀夎陒䨀⏂㹒܀⯂㹒܀၆⁠䄀၆ꁠ䄀鉋꒒䈀驋꒒䈀ǀBހ⧀Bހ₏葒܀⢏葒܀䄄၁⌀处၁⌀Ꮳᐰ䈀⯣ᐰ䈀兏鑑΀奏鑑΀炄㸠脀炤㸠脀䎅邒覀宅邒覀⏤᱈⌀⯤᱈⌀ ೈ⌀Ì興쀀⣌興쀀㭂ࠠ䂀㭂蠠䂀䄄豂ހ处豂ހ䍥␱戀苨₣஀ᅇ㚪䅎鋛ꖀǊꪫ℀鉋꒳樀驋꒳樀銫꒳樀卅꒒䘀孅꒒䘀厥꒒䘀⁂ё檀⡂ё檀⁂葑檀⠘ ⠄⠘ Ⴅ⠘ 苩⺒ꫩ⺒銩⺒⏢㸣캀悅᳛䈀厤Ⴣ✀ᅇ㚪ꒀ⏄㱁⌀Ň㉘舀凌阠舀㪨쐀⋎ꪰ萀๢쒀₃衢쒀䂈Ⳉ✀冤鈈䈀灂Ᲊ꜀䅎鋓䒀灂ᲈ✀ą㩋─䅎鋋─悃᪪炇∱䪀⏄鲩΀₄ၢ꤀訰萀谠萀 萳䄀ࠡ೐䄀㺈䘀⏨興䘀 ᰠ辀ǂࠣ㸳䌀Ꮱ౒䌀⏢詉⦀⯢詉⦀⏢ࣸ舀⯢ࣸ舀⃤ꈐ谀⣤ꈐ谀䇥␐䈀䧥␐䈀Ϡ興⾀⯠興⾀句ᐐ萀寅ᐐ萀脈鈐谀餈鈐谀Ϡ萡䢀⯠萡䢀䄏鉑΀夏鉑΀褤萐萀餤萐萀⃤ꨐ谀⣤ꨐ谀ᆂ㸠萀ᆢ㸠萀 ⪨䘀ʪꨈ䘀᪊ꨈ䘀瀏蠠萀栏蠠萀䄄ᡑЀ处ᡑЀ₏蠠萀ǀϠ鰐가⏡ࡲꈀ၁ࠡࠀŅᑊ⢀⤅ᑊ⢀ᆥᑊ⢀舉뢂ހꨉ뢂ހ銩뢂ހϠ舐萀⯠舐萀Ꭱ舐萀⠐ ⠄⠐ Ⴅ⠐ ₏袪ꈀ⢏袪ꈀクࢪꈀϠ葠脀恢Ё膀₂၂亀ࠦ萐가炂㸠膀㹈舀䏤鐠舀 ᰐ侀ǁГ舸➀Ϡ鸈⾀瀏興䘀䤤鈈䈀ᅅᑑ椀䄄၉䘀Ϩꊊ⾀ꈈ䘀Ϩ興䘀Ꮵᓸ䄀ϡࠣϠ鸈䘀脀舐谀⯨興䘀㸩⦀Ẑ䈀₅ᑲ⢀벊⼀行₂ࠀ₅ᑒ⾀行㲂ྀࡂྀ訨뺊⢀爭뻚✀炂ࠠ蜀詊ア䢀₅ᑒ⢀設ꪪ⢀訬ꪚ⢀ᰀྀ爨ꊊ✀﨨ꊊ⢀벂ࠀ車Сྀࠠ舀襅ࠠ舀⇊ꪩ숀襅ࡑ䢀ꪪ鰠舀爨ꊉ䶀钒薀ᢥቊ저谡萀ㄢᒒ䘀ቢ✀墄ဠ䘀"+CHR$(13)+"੉䄀ㄤ뺒䘀ࡁ䈀鑢覀⁁౑䢀鉒ꠀ鉑萀㤇ꁠ䘀ኊ䘀鑒䦀ቊ저钒䘀ꠠꄀꩉ⌀၇⪩쐀萡覀၊⪩쐀ꊪꔀ₅ᑲ⢀行㲊⼀벊⼀行₂ࠀ煅ᒓ行㲂ྀ叨㲂ྀꪧࡲꪀ爠谊✀訩꫊⢀傈ꚫ⢀骊ア䢀礤鉉⢀充⪪ꢀ訨뺊⢀爨ꊊ✀﨨ꊊ⢀벂ࠀㄨ₁⌀ࠠ舀襅ᐠ谀⇊ꪩ숀襅ࡑ䢀鉉⒓訨ꉸ₀ꪪꪪ꾀ꪪꪫ섄᱉✀訨늪검興㲊⼀所鸊䘀銪몪꤀稨鹉⢀ȹ⎀ᢇ቉⌀ቱ✀遁Ѐᑓቹ̀倃ቹ̀"+CHR$(10)+"鰡쪀ሑ⌀鉙ꒀ傄鉙ꒀ鑡䒀鉉⢀뚪ꢀ鉹⒀቉⌀鉉⒀ቱЀቁ⌀蠠舀鑐谀₇⪩숀鈱⒀	⒓鈸₀"+CHR$(10)+"ꪪ꾀"+CHR$(10)+"ꪫၱ✀鉩暀ၱ✀ሙ⌀	⫪꤀鈸ꒀ 㼀 ₂ࠠ興 ༠興 㠠興₂㠀 ₂ༀ ₂༠興 㼠興₂㠠興₂㼀 ₂㼠興 㿼 ッర쌌 ༼쌌 㳰쌌ッ㳰 ッ༼ ッ༼쌌 㿼쌌ッ㳰쌌ッ㿼 ッ㿼쌌ッ༰쌌 㿼興ッ㰰쌌₂㿼 ₂㿼興₂༼興 㼰쌌₂㣠興ッ㼀 ッ㼰쌌 က  က  က  က  က  က  က  က  က  က  က  က  က  က  က  က  က  က  က  က  က  က  က  က  က  က  က  က  က  က  ကက ჀကЀခ▀฀ကႀကȀ䀀Ⓚ쀁▀ 적Ѐ䬀耀ကↀခЀ Ā က⣀ Ѐ 㯣踀 ណ㓀⟞简 㮎⠀⯖䍀 ᮒ钀娔၀ᱝ痀 쀀  Ȁ က "+CHR$(13)+"㛚䭀ṩꟀÀ昃Á繊 À怊 À栳䀀À栺ꀀ	⃢恀꣺껂À㿃痀驉⊀盫䈀䀏胸ĀϠ㸃⅄ࠑ䈀 ࠈ쀀 ⁀и㢂ࣁЀࠣ!ࡃȈ₂ࠀ 䈐萀Ƞ 耀ǈꊊ Ȩꊉ쀀"
    KNJLIB_FONTDAT$[2]="累뛹侀㭋꫸䎀鋭㻑䮀שׂ뫺⦀⏥ᱫ䚀累눱䪀厇铹亀銭냹ꮀ颡⫺侀句≰趀句㹙➀ỻ䖀劉㹓⮀篥᣹侀吝᣻䮀宧驹讀叢빓句㹉톏뫐⬀另듹䔀爫⺒䮀톬㩋獅鋩亀⏨麩讀몯뫹ꮀ只㡡趀䪡㛂涀拧ꩻꞀ勥♫䚀텍듸ꮀᏡ㓘첀劉⫹쪀厣郹Ꞁ⏪빐첀⏪㚲즀另雩亀Ꮾ뻃憀⏪铹쪀뻚鏮雫䚀⏧⩱䜀䥤驊䊀祯뙱䘀凬멩䞀凭㡩욀凭빱ﭯ뛻澀⏧ᡰ춀珧⫹亀Ꮿ㒻䪀뚛ꖀ毯ṱ잀⏥㹳⮀멃⮀隷遺ꖀ句㫹⚀參ᓸ⪀絛胺趀絛铸ࢀ᛫䘀櫧⹳잀勥깳絛빑씀叧⫹亀⏢᫑䚀믣ꀻ롣겺侀郇겳⾀懲뺒꾀句ᓹ䤀⏤⩐첀凭ᱻ䊀⏥㩑씀寥ộ씀ꑹ슀㸀 ⏢㺸莀ꧫኂ쾀馣꺒꾀짎郛斀叢⹘䪀句㸣듈檀ℯ鑑䦀䋪몫舀筯뛩➀煏ꋸࢀ絛꫚⾀몯뛩⮀ꋨꚀ勠듒亀裊肺䮀ꬪ뻛叭⫓ꮀ폪냺䪀펫㓺讀쯊뛚讀寪㸛຀௬뫘ↀ⏤ỉ➀⏨鰣⇅ᱸ⪀詺ꊀ롃꒒쾀뺫窪ꫩ言ꯧ룹ꪀ⏭雹䪀㹑侀⹱쎀䉨뚊⾀뢪黋涀፯㛁䮀㮫꫸ʀ武뻊沀叮뺋ꖀ뻨䪀鋭㻡䦀﫭뚻䪀郩຺ᮊꪫ뺫⯮닸ꆀ瀏蠡亀뢡⺺侀珪鳹亀叧铹䞀䋡뛚妮꩓욀꧍鰡윀郹亀걃ꔀᏮ뻐䚀⏋㰨亀ꯨ裹쪀怆㩲ꘀ뀋ẳ欀郫蒚䪀⯥㩻䊀烅ꩱ侀뭋髻ڀ뭋먻ڀ句⫸趀嫅멙댃㘳櫎黑亀釪໪쪀ᇭ᫹䪀句≱侀ꙓ䚀歎鹑䚀孠㘫叧㱫஀뛺궀筅뛩䚀וֹ듓䪀着뺊⦀節꫺꾀祭驓Ꞁ⏥⩱솀⏫賹亀짉铹஀窦⸃⮀句᫱춀䯆雩亀ꢪ肺ꮀ郪蚚઀ꥈ袩䢀妭㙙榀祏빹䮀叧ᓸ઀釫骸캀娧ꑫ暀宯⻹辀句ẩ讀叭꫺꾀郧ꪻ侀䊮郹꾀窦⸸⪀兯陃掀厤ᩢ誀롋葚⦀믧둻技뺊⾀⇅㸠趀⇥髸趀切둹䞀⏩₫讀箧髹䴀㭍㻓䎀毦뻙ڀ곒亀窱⻪亀ᰠ辀判㺩叧깹䚀ꯪ顸⪀곚⺀句㹱좀鶴ꫛ釭雺䤀叩ố䪀凮빙薀ﯩ⪺䮀叮鹙薀폮뻛趀獇뫹Ꚁ퍏铑䞀灂ႂ➀凭㩱얀鯥빛촀節븃⮀뢫肺꾀짎雛薀⏥㹱䜀ਠ舀ㅍᙑ䖀㦏驩䚀㤯驹▀凭뙹㥏驩Ꞁ凭㹑䞀䏦驪ꮀᑰ䌀⏧ᓹꮀ᳐趀鋮듩檀⏨鱪욀⏫賹䪀즬髋箬뻩䚀絛裹쪀䏦껹쪀밲욀렫誺⦀↧⠡䢀㬧멻ↀ客黉斀ᆏ衲ꈀ퇮铫暀鍤뺫澀叡ᛑ䖀句㸉Ꚁ句ჹꮀ句ỉꚀ叧㹳叧᳹쪀箬빩亀믣됻⯫⻰六ṱ좀ꇣ껚ྀ뢢껋澀珪肻䪀只멑亀祏둙쒀祇듛삀㭏鑛쒀祅㸳䌀꺺⾀퉍㓒亀叧铹䬀筏둙첀䏦깱좀㹲잀嫃듚첀䏦길⪀ⅈ鑑䤀⅋胹亀窦ṩ隷뛺⾀凯鹓䊀凯鑻슀雙஀叭鹑䚀箭᩹䞀揭险筏鱑䚀可鑹욀Ꮱ⳺쪀箧郹満텮ꪫ䊀欮뉹⮀⏭뛫句㳙䒀ꃩ蚪祉뒒䪀絛铙䤀鍩㘡윀劧ꁻ螀叢ᓙ䤀嬭鱰꾀뻻梀퍩㛢隷ꋸࢀ뮢목꺀叩隹檀凋ḱ䤀Ꮾ㓨䚀⏪鰣꯫꒺䮀宮陱䚀宦뛱䚀累铻䮀ꉹꆀ叧㩱侀嫅빙鏢␫亀櫬ứ侀槮ꑩ욀룫蒺䮀宥⩳最叭㹑侀礍陛΀句㻙攀笏둙꺀括雩䮧멩Ꮽ㻸ㅂᓹ䜀⏭벻古ᓑ꾀毦雙亀宥㫁斀另㓩䚀室㺩䪀ꧫứ䪀퇦ꑹ쎀ừ䚀꧍鱑즀㍇驹⦀句㻙檀퇮끫䚀寫㹛씀뚫ﭩ냺叢ᱳ꯫蓸蘀ᆅ㸢꾀ꥍ裹쪀寋隹蚀뫁빙芀叅ố촀鍤裹侀箧㫁䞀筤㻙ހ篥볙얀퇏볰쪀邫蒻⪀䮪鋩Ꚁ᭬㛨厭遹Ꞁ筇铹꾀롋蒺ꮀ냈໋ꦀ냏銲쬀叧ỉꆀ孤♩퇮둻斀煇ᑱ侀羚㫀䮀ፏ듐䄀毤㳹잀毧㻱ꏬ鳓螀珥㻑꭯뛹䦀⏪鑱솀叩ຨ卢㘡쾀櫭黑፭㻩枀폯롹⊀筇뫹Ꞁ叧ӹ欀句㺸쾀곹궀⢪鉪⦀叠⩉ꦀ龜ᑱ䶀㹓薀禯끩Ꚁ都۩殀⏪鱲∀빉▀句雺꺀鏥뻛満ꧏ钩܀ᮭ뛸䊀凭ᑻ쎀⏢ᓹ䪀⏨鳹䦀⏨鱱➀⏪鱱즀炂㸠舀톬㹓⇇㻹⮀Ꮽ㈃⮀环ṹڀ可ᩁꖀ宥雹亀驫슀毦뻩Ꞁ笅뛙ހ另뛑斀卦됓䚀鏦鳱욀롉ຒ䤀ꧫ蒺䪀溺雛沀ꃩ໲쮀㯥㩓句᱑䜀퍬㘁쾀ᆃ㹂쌀鍤鰣鍤뻩윀鍤뛚⪀娆ꙫ䚀䇊㸢꾀톬㹫暀כֿ㻓䴀殮㫃쾀叨鳹䦀뮧뫛亀鏣긓珧q좀룢꒺侀檮᫁쾀꺺뺫뛺궀㛚榀퇭빳勢뛒涀勦뙓涀䏅㑱䦀⅏葱䜀ꯨ⺓ꯥ㻫쪀㬇둓䊀ᇭ᫁ꮀ絛꣪캀ꯠ㹂鐓亀節뚲첀節듛䶀㭃멹઀寅뺻઀ﭏ빛蒀ⅈ葙侀凭㹩䚀㍇鹩讀⏧ᓹ䜀㹓涀句㹒꜀⏢ᓸ䔀鋭㻩⏪铸䔀凥㻫䊀傅㸡䩄뱙䪀灇ၳ⮀箥ự䏦뫩ꒀ句鹺誀㭭뺓䊀寧黸檀毧뻹ڀ⏥㫹쪀歆볙䚀嬯멑宦㹪욀菧㺩⪀ꃨಒ䢀䩄받䲀䯆⹩ꒀ珥⸓铻攀稤깣Ꞁ狥깙욀箧멹䪀묠긣꾀⇏鱑좀宥뱛஀퇍㑓䚀㪥㹹䋢뫪검틭⩻⚀⏪뺩즀片㺫솀楏㑹⚀槭㹙쒀鋭㻩䪀⏨鱱侀姍볛亀句ứ亀宧鳹亀另鳰䪀ộ쒀鮩鳹䪀䯇⹱욀叢㹛쒀毭㹙첀鏢뀛澀ꯡ⸛첀揦雹満古ẩꏮ電暀⏢ᰁ윀⏬㻐膀寭뫰薀句㻁斀獧듁鏡⸃涀ꑹꎀ揥㓹䔀珧⩓寥빚촀⏫鐣最폭뻛ꮀ⃮⺺讀ꧢ꺒辀ᆄṑ侀䇅␡䢀凍㑑䚀凭㹹䔀鉩䪀獍닩䪀⏭鰡䜀⃸ↀ㍇ѳ⮀句뙻䚀筅㛉▀⯢⩲ꘀ鋫䪀部說䮀牂㚨趀Ꮵ㙳挀⏭裱䦀⏭铛▀鍤鸩䪀牅ꩫ䚀䪦ꩫ劧ꁻꞀ몪꺪ꮀ懪ࣸ舀⇂㸡亀ﯩ⺒ꮀ﨏⓲ྀ箇髹辀䏦髩趀ꯥ≳룋裹쪀⃮⺃侀ꏡ㐻䴀鬒黛춀端ố꾀颩຺઀嫧듸誀㍇驸઀⏥ᰐ蘀⏥ᰓ⏥ᰢꘀ槮멹ڀ凭㩹䚀姭㩁ꋹ䦀另빩䪀句ᓸࢀ譪꫚⾀凮適﫩⺒婯뻙준பꫨ珥⫺⪀凮鹻䊀凥㫻䊀톏껑澀塞⻙ྀ叭ṑ螀㨃⮀句㹃ꐀ句᫹亀句빚슀寥㫁郎麲춀륍ố䮀釭᫹䪀믥㩁뛫⏅ẩ씀媭뻸ࢀ叧㛺⪀嫧⹙준勮黱춀嫧걓嫧곙蔀뮯᩸⪀慭뙹䔀鳻䪀⇏铹䦀Ꮻ㪻䊀ꯥ㻹쪀㺋꺀兏뛻澀筅닩ހᰨ辀笧당觍ồ䔀槯둹䞀돯雹満懬驛ꆀ⏪ꪨ舀勮鳹洀ᆄṑ䤀择듓䚀拭铑亀铸䈀䭤鳸誀⍧᳻ꢀ鍤듻満ﮭ૸誀句ṁ叫뻪꾀厥ꁙ─䭤깑ꯣ됻侀裂⻒侀⅏裹쾀Ꭽ냸℀窯飩캀䏅ᑑ䦀奭끹ڀ䇨鹙嗀⣒ྀꇬ雙⦀፦뉓䊀鯅빙䮀句㸡䜀㦆鳩讀搜걫螀쫎⹳잀ꙛ▀煇ᓸࢀ燋먃⮀⃮⺳Ꭻ⳨슀⏭聰辀禯둹⏨鱲룡⺺꾀ﮫ듺⇇ࣻ卤뻙씀䪮髩검ﯭ⺪隷꺓澀笧黑澀⏭鱱ꮀ⎧⩱䜀돏铳얀櫆빩윀⏭蒸䮀剬㓘઀ﮫ냺쪀片⫹쪀劉ࣹ쪀分ꁓ炍钩쪀勏鳱캀퇭뙨઀鑲叧㹓䮢ꨫ검ẓ諸㹳說ᚙ윀叅㹑촀䏦깻䚀寣᛹䔀禍㩑奏뙙蒀빩ꪀ﨨빑䦀殮⩱䜀⇂㹰辀Ꮵ㹓䎀隈辀筦냸趀뱡꬀窥㩹䞀⏧ᰃ⮀⏫㻚캀䭤빳⮀퇮鸃⮀孤ᛩ毧ề満돪먪욀煏鑲ꘀ句㻑䞀裊蒺䪀Ꮽ㻓䎀퇭ᛣᮄ૸誀窥⩻䞀櫇걫螀玲᫸誀ﯥ㱛섀句ࣘ辀叮᫩ꪀꯨ鱰꾀千됓䴀卡㘃涀뮯ᨃ玲㩻䞀隹຀铹⪀句ù亀ꅥ뛲侀퇮뻐欀䦬꫊궀둛䚀뮭⩳뇭麻䪀뻒欀欅뫩Ꚁ槭멑䇪蠡䢀郩麒䪀맫骓椀⏨鑑䢀勥⹃斀⇥陙澀鏡긓亀礧鉹⦀燭㑹䔀冭㹹䚀楏둩䖀䧭멙Ꞁ口㸹쪀ꧏ针씀䪤뫩⪀Ꮼ변잀ﭪ뚪ﮭੰ辀ꫭ뻑퇫铹䮀⏪鰳⮀פֿ鐃⮀ꧏ钸蘀歇铩䶀厤㻹䚀揥㻱잀⏥㻉숀⢏蠡䢀叅볳쪀便깙技獵꩹䊀婤⹫㋋⃸誀龍Ṫ隷ꋹ䦀ꯡ긓ﮭੱ좀淚㹓䔀釥뺲䫭髙꾀펨㻺䪀鉶빹躀튬⹻䚀冤㺺캀瀏鑑䦀碑꺓欀ꯨ㛫䪀䅨銫ꄀ퇭⫑辀釭᳛캀累黓⏤㐡亀㮧멻䊀勥⩓螀叭㫓辀⏠ᰁ윀鏢빓ⴀﮫ룪쪀ᮊ裸蘀祯뙩₏衱䜀்듸䌀絛ꫛ鉏듹ꮀ짊髩㲂➀⏩㺳짎ꫩ鉹ࠀ卦몫䊀升듹Ꞁ맫黛觎髩맯黛句⩑撀ﮬ㻫䪀箧못ꊀ可᪩⃮⺂춀鏡⨓沀틭᫓沀勏铹꾀龍᩹쮀暈黹蚀句⻩亀炂㱑侀ᑠ辀祍㹙枀䇪ࣸ舀㪯蓸ࢀ炏ᓹ䜀驯㓹઀劅㙩䚀櫥빙筏陁斀筇뛁斀厥뛹㯧빛句Ᲊ쬀뭃똃涀季㐻຀ꯣ⸫亀뻛䇨ᰡ⎀璘듸䮀⏥≐趀凮끩䚀夯둹䚀夯뱹䚀凯멹⊢㹑䦀先蠡亀Ꮵ雘ꊀ叫蚹檀䇪詛ꆀ頋⓺䬀Ϩꊋ⏨뻛ৄṁ榀嬯듹䚀凬ṫꊀ䧌ᙃ憀먭㻑䬀᳑䶀⧂㹒⏪뱂䎀ǂࠠ辀㭅ᙋↀ句㱫܀⇏铹숀⏨⒒ꮀ⏫⚺䪀⏫㲫쪀텍ⓡ꾀笍陙ހ毮ṁꚀ古ứ검揤雙ⶀ另郹侀፦驫䊀隷邛愀ﯢ⫹䦀劉ࡠ趀古㻩ꒀ另냩䚀筇뻱䚀毦뻹胩Ғ䮀ꧪ諺઀냭ຂꧪ鲫䦀ꧪ麻絛꫸舀⇅᳸辀磊깱䊀퇭郻釭雳最䋥⑓䞀拦⩫䖀勦ꁫ䚀窧깻寥뙻暀⧂㹢ᅥ㹑씀㫫䶀폮냻侀⏥㻹씀召㻫검古ᰁꪀ娇뉉▀䫅빹暀ꯢ긻炏鱑좀껸寫ڹ䬀퇭㛫沀勮᫩䶀퇦⩩솀窯黹꫚㫒㭇驻ʀᆏ鲩윀⏥ᳺ⪀釫費ꦀ뫫ꪀ句빚꺀煏遰䌀⅋聱䜀凮鹳挀句ᛱ沀釪麳欀⏥㹪욀⏧㻛揦隩殀⏧鉹䦀䮨銩⪀懪㸁윀ﯪ뺫室㺫䚀㻃涀쯥받꺀絛裸઀뇍鳑쪀釭黃쮀﯏㣻亀롍똛満䇪詓⮀卮陁ꖀ煏ꉱ씀釮黩ꮀ끁Ⳋྀ兇듓춀멏ꪻʀ⅋胸䘀絛꫺꾀凯鹻㭥⹐辀뫏볩榀箯顩욀㭥⹓⮀꓉윀煇ⓚ䶀箧룩욀筧뛹枀뢫貺쮀ᇯᳩ쪀櫦깫Ꞁ隷ꋺ趀탯麳䊀鍩㙰ྀ凭㡹䞀鐡䢀⯮뛨䊀槥㻻䎀⏤Ṓ䞀叢㹹䮀⏧⩱侀郋钊䨀⯥㹻䎀퇇ꑡꄀ卣㘓洀櫏髹຀酩᣻䚀兊衰辀⏭⫲辀卆铹侀凭㹙ڀ槭㹱잀᳹䔀煏驳ꈀ寅㸓䲀⏭鱲꜀⏣᳹亀⏪빓铣ꔀᏡس䌀笆铹寅㹓쒀ᅥ㹙쪀釪蒫䩄袨趀ᮊ蓹쪀ﯩ㚓퇅⩑鍩㹂窥≰誀⏧㙱쬀䉥ꙛ叡᣹쪀寅㹚첀寅㹻쒀㋲誀䮪銫ꪀ⏤㑹䞀䯤뛩▀ﯥ㙓攀쯬뛨⪀뢢麛ꦀ福驫䊀ﮋ뫪䪀积鑫ꊀ毥뻹Ꚁ傅㹓씀⬏듸䊀凥㫻⊀凭᩻⊀퇥⩹⊀㩸⪀兯㙑攀꤮ꫪꪀ፯㛐愀另郡፯㛓愀믥껹榀箦뻩ꒀ⏭遢鍤뺩쪀⇏꩐誀櫮黁涀歄㻩䚀퇭㻐䮀鍤빙ހ퍁둛஀禦빩ꒀꋫꒀ⏪钉쪀歆雩一珇髱글另铩叅㳑䖀릨ừ䚀叭⻣䮀卥⹓얀⇇⨣퇭㻨箧雙꺀勭ứ퇮냨䪀ǥ陙澀㭋뺫ꎀǀᰀྀ⅊鲫ℯ钨䘀₊ꪪ꾀厏驑─句黹캀돪몫쪀寅볙䚀熭㩑㮦빫ꊀ⏥㺺䮀鍤鱓鍧᳨誀鱰캀돥⨳캀句⩱좀뛫亀䇪铩薀짎㹫ꒀ䯇멉윀磊걹䪀兏둑䞀夭㹑䜀夭뉙撀凯둱䚀⯢뺩艩ꆀ⏪빠趀못ﭭ뚊⾀₏蠠蜀卆껁鋭㻙椀ꃩૹ亀灂㸠蘀隷곚춀⏢㺪ꈀ筏ꛛ䄀⏢ᰃ⮀絛븃⮀卥ᛁ涀⏢᱐趀黙亀箇髨⪀揤Ṫ讀鎈鸁윀句㻩䚀၅鑑侀磊⹱䦀ᎊ㺢䲀ꧯ髹卅ꑑ䞀텍ᓣꞀ⍂ᓨ誀䫇⹳욀鍩㛨誀폭㻫䪀⻢漏衰辀箧꩹䚀묣눻鏡⸋궀孃됳캀鏡⸃궀ꏡ⨃涀ꃡ⩱좀ﮯ듨檀凯㻳쮀媡닚沀ᅯ᩹Ꞁ⏧㰻숀⥬驉䚀凭㹉ꖀ몫ꪹ䦀⏫蓸蘀⇂㸓句⡓⮀句ỉ궀Ꮽ㻋ꆀꃥ蒒䪀ꧪ钫侀遊躂壘뺫壘뺨辀ᇭỉꦀꑩ䎀瀏袪ꘀ羅ꪪꪀ磊᱓⏨몺⾀口듻ꆀ퇮黓遪蚊䨀⏫㳚䶀⢏蓱亀ꯃ갛캀Ꮿ룻⊀鍤聰ྀ퇯빻⏨裸ࢀ珪胸슀䄅롁⎀⎊고ꎀ另ꩻꒀ懊㸡䢀鏬㣹䪀⏪铨辀累鲫஀勞賺쾀釫ᚳ欀ᇬ᣹䪀䩍ꩱ좀⏪鳸趀叫받洀鍥ố禯빁ꖀ鍩㛹쪀叢㸑讀ﯭ⣻亀古ంꖀ勥ꁻ⅊鳹䜀ﬧჸ䌀⧦黹ꪀ厥ề涀句빻쪀䪤멋⧂㺰઀升ꑑ䞀勇ꑋ䘀⧂㹂쌀ꯦ븻꺀⏧ᱳ釥㻂꾀叮둙䶀便㹺윀槮빁斀䇨鈨ↀ礧鑑䢀揤뫙▀懬멙⦀累뻊沀뫛ⶀ賱ꪀ窯铩満古㹂쌀⏨陫䚀ꑋ撀古ⰳ⮀䂏衰辀驳ꈀ⏨蓹䌀炏裸蘀懊㸡쪀⹑釬铹䬀㏥㹓짍ỻ䞀쯍㻻䮀䏅뙻䮀롋躪叢ᑱ䜀祎끑累ꉰ趀㮪껐䊀⇏铺䔀筇髁亀毦뻙Ꞁ穇ꩃ䚀珪鰣飯꫚⾀㪪ꪳ슀絛ꫛ⏨鳸誀寋뱓䚀榯빩ꪀ懭㩑─퇭ᨃ⮀厤ᛁ涀ꢯ麪검珧⫱梀텏鳓䚀媥⩓ր勅걫暀鈡윀⇅᳸趀⇦鋹ꪀ叢㻹䦀⇏颩쪀密뱻䚀凯ỹ䜀틏铳쪀뙛뢣ꪻ澀句㻚⾀뺫꺀凭ỹ쪀퇯뻓亀兏둑䔀儏둹䞀⏥㩑䦀₏蠠舀櫥㙑얀Ꮱᓹ䪀珦꣹쪀運蒒䤀酭ẋ䢀뇇蓱욀櫥♓얀ᆏ鱰辀勭᣹亀妤멓䚀隷껚검⏨黑斀髓亀箦깑䚀勦ꙓ斀⇃뱩友㱘辀友㱘઀⊯袪꾀櫆빹ꒀ釡㛚侀冯뙩䚀冧뛫䊀⏧㹒ﭏ뫃技厫깫䊀累ꋑ튯깫䚀꣧າ쮀窇둙斀䇯陹枀箇듙斀꩹ꮀ釪躋꣫ຣ黛祐꒺勥⩻䖀ꢥ⪪ྀꧣ뺪澀퇮뻋뭏뫺઀䇪ꩉ覀筥ꙙꚀ죎⻪ꢀ煇ࣹ쬀㮯듻憀郩ả榀⏫㺰઀勥⹣斀絛鳹쬀⇃밣可鳹쬀叡⸣涀鏡⸣涀폭뛛ꊀ媮铳䚀₏鑠첀⏫⓺ꘀ劧둹씀寫똃⮀勭黙펫듺준懭둩暀楎빹ڀ㫓檀琢⻒侀㍅㹑䤀꙱䜀⭏뫸ꊀ⏥㻚⪀᭫꫸ꎀ꯫遹䜀宧둸趀⏥㻹亀奯꫹ꮀ⏭鱑씀夎郹ꖀ₇᪨蘀⇆꠨䘀⊢㺊⏩⺒䮀⏩㺳椀⏪㛫쪀䯊뱣ꔀ灎鱲ꘀ叇铉一筦郹꾀꧍鱳句鳙춀隷铹䤀煏ꋺ⾀㭪낻ꎀ煇㛛涀殤㓑Ꞁ歇뫹Ꚁ另뻱毧㳹ڀ롪肺ꮀꡋ誺ꪀ酭Ồ⬀릫髺ꮀ凭㩹䪀凯ᑸ઀ﭮ뛘઀ᇬ᳙쮀⊣㉹➀꩹ꊀⱹʀ毥⹑ỻ䔀⏥㹳鍤鳸趀釬ᓻ䞀穦ꁻꞀꢏꋺ⦀叧ᓺ⾀另둻ꖀ叧㑸઀䫆빹Ꞁ꧍鱻䚀ꮠ㐓꾀뭁㘓侀뭢뀻꾀ꯡ⸓㍇Ჩ쪀꧍鱱좀宧둹윀竍ᛱ쾀䫏黹侀勮黹侀폪뻲ꭏ髻Ꚁ₃ࠠ辀⏢ᠡ䢀灎鲨辀炏铹쪀﨧ᑑ䦀碯黩凯ᱻ슀奯鑫技凬᩻슀鋬㫹쪀꧍鳺ꈀ叭ṩ筇黩亀ㅂᓹ쪀句㳑䚀颩ບ奏铑䚀燏ꉱ侀퇬᫻욀另⩳鏠⨻캀퇬㫻캀勮铙춀篭㳹凭ṻ莀拡㻚洀孇铱캀句㻹螀퇥⹹讀秬빹檀嫇걛욀볛욀㍇陹΀퇮뻓殀⅊顩䚀勢뻒澀𢡊铹䌀隷ꣲ춀凮빩凬㙁斀夭빩䚀𢡊듩윀몏룹쪀⏩빫䚀⏪鳹䂄ᓉ䜀叭ṹڀ笅郹캀䯊㹫ꒀ淚铹䜀⏧⩳句㫑끋Ừ亀囹Ẓ⏪뺫ᇭ᫑⤀⏧᳸ࢀ另깩⏧㺩쪀勦깫摒⓲辀句ၓ✀叫㡻ꒀ宫멻䚀厡㈓ⴀ⇅᳘촀⏥㸣꣧⺲勏铑䴀珪鱫䚀₂ࡑ䢀䇬ぁ騹⦀⏫ⓘ辀ᆂ㸠蜀灏髹䌀句᳹䞀礧钨̀ﮭੱ씀뮣먫검렢뺪ྀ폫㳲뭭黛Ꚁ鍤븉Ꚁ돣긳洀穇꨹઀텯㛓洀ﭨ뚫澀﨎껩満룢꺒⏭듐䊀炏铸辀叭ꛛ䄀毧ự쾀₯ᢰꘀ懭둑䪀ﭏ볻䎀重᫓離빓⏧㙳䚀ꧣ㚳澀퇍㫓櫯ự쾀竏鳹侀폪㛚讀⯤㹓燮⹙螀ꯨ鳸誀ꯥᳺ⪀녪骩䪀笆듩ހ卦둛ꮀ䧫ᙲ얀篥ố꾀䭄듁─孧뫹Ꞁ句㻩윀寍뺻઀⊧둹䞀篥⹑Ꞁꡊ躪䮀箥髑涀Ꮱᐰ䌀ꪯꪺྀ맏麻誀卢닓亀煏衱讀釡೺캀쮤멋ꪀ反᫱䬀닭㓹䮀穅㙑䞀班ᑹ䞀Ꮹ㲻䪀뻛亀宧⫹辀煇ꡰ辀Ꮽ㻫古뛹䚀筇뻩Ꞁᙑ侀郩Ẫᓹ䞀懪ࡰ辀Ꮽ㒉쾀釭ừ羚衰辀⏢ṩ쮮꡻䚀累뛚⾀鏣ⰻ캀䭅멋鏡⸫꧃⻪꾀羚룻侀⇂㹑씀宥㺻쬀⏥ࣙ준黓䚀㻫讀凭Ṑ趀⏭㺣毮鹁斀Ꮽ㳛쒀ৄṱ椀句㹱䜀䯆㻩ꒀ滑ỉ➀퇭ớڀ鍤빓勥⹛ڀꢊ鳙씀⇂㹑좀⇂㹓攀틭黻満틭ớ຀磊꩹ʀ奯陸技卧铙澀另黩亀篇郩຀䯆ứ검뮠⸫亀⏭郹暀鍤뛚䴀ꭂ긓亀珪聰䜀媥⹻螀ᆏ衱䜀歋빑免뙙枀懊㹑䦀ᆂ㸠舀₃裺⾀⏫聱侀⏧᳹䌀⊪飸趀說ꪪ₀륏뱛쒀龍ṩ檀筧鳹຀厧铹侀揤㻹⇅ᳩ쪀駉鲚䪀냭Ẳ춀ꇋ᛹쪀뇫᪂쬀只모઀秌㹩檀揤Ṫ쪀⏭鳹䬀鍤뺫ꪀ勦깓嫅걛쒀叢㺸䪀폮뻓䧪騹⢀殮냻ꮀ句鱹⪀鎣됻侀볘䪀鳛亀롣⺂꾀㊢쾀嫍鳙亀狭ự춀ꪫ梀㻐叠㪫ꪀ叢㹓ẫꪀ凫ᒨ઀⅏衰辀歇깑櫥⹫㻫뤏黻䞀⯫껀뮯骘辀禧뫻ꎀ毦黁涀刯꫹䜀只빱䜀䭤븱讀릯髹ꮀ퇦⻃ꊀ퇦껓ꁙ얀箧꩹Ꞁ羚髻Ꞁ릯髻Ꞁ⇏铨誀窧ꩻꞀ另⹰欀鎂⸳ﮫ뫺ꮀ껚꾀娯꫚궀槯빁斀䪦驋Ꚁ驑䪀ꯥ㹫슀⅏鱂쌀⏦裻䚀兏铑䞀⏧㺨蔀⏪鲩䢀⏪鰡쪀ﯭ⫺쬀祐뛚侀퍦뙫஀寧똃⮀另雩亀嬥黹䯅ỹ䴀笥ỹ侀匆郑煇ᑳ句㻹䜀꧇ࣹ쪀厥뛑毦뻹斀ꧪ黺ꮀ儎끑㍇㸱숀ᇯứ䪀箧뫹Ꞁ⏭衳⮀ꧮ黻斀檥⹃ꖀ勦ꁻ㻃ꖀ叧ᑳ古㑻䞀叧걛句㩡쬀叩ઐ句㹻䚀⇂㸱讀ꧡ⺒꾀ꧢ뻺꾀劭雑珪빛鶴⹻䞀妭뙑ꖀ楏鹃憀歏鹁斀폭㻓쪀句㻛亀뻀殀냥㺂禯둙얀禯멹⚀ꫨ⪀뚚촀⇅ᱳ⮀箧铙춀⏯꫹쪀說雺ⶀ煇ࡱ讀釣꒻侀植㩁斀ﯩ㣺폭㳘䪀卦ᑺ쪀勥⹫ڀ⏥ᒫ升깹句᳸ࢀ毤᫩꺀⏥뉑壘ố叭ꋹ䌀孤ỹ຀䯤뫙▀㊻꾀憯멩螀ㅂ㘨䘀₏蠡䪀運蒒궀鏢됛䶀㭏본䎀폪㚘辀ᮊ빐첀叮ᙹ室髉ⶀ另듙䖀叮듛䶀另㛹폪듚䦀퉏ꑓꖀ깓凭㩑槯ṳ쎀䯢깙⪀꺺ꪀ凭ሂ꾀叧㺩씀勥㹉ꖀℯ鑳⮀剭㘃⮀叏鳸䪀句⩱䜀⏧㚩쪀ꧪ黚퍎뻃듫讀叢ዹ䜀凭ቻ䚀凭ቱ좀뢣ꪲ꾀釣뒻侀㛲欀凭ታ說뛨奏둑䒀₅㨁윀₏蠡䢀鍤뺡듛춀סּ뙃ꮀ⏭㚸⪀釪麺䦀맋骺쮀⃧ᑳ㭏㛱挀⏩飸莀䯅ố䶀孥铑亀筅ᣙ涀뢪貲검롫蒻쮀㭇㙳挀证⸓䶀竭᫑루躺檀ꯡ⸣涀句㹓飯뻺ꪀ歋멹꺀﨨븁䢀㮪ꫨ舀禯멹ހ郧꫺侀廓⃻䚀⏧㫹䌀뫓䪀鳸ࢀﮭૹ侀ꂂ꫺ྀ箧뫹ꖀ刢ᒉ윀릯髹䮀漏냸⮀毧당ꖀꯣ⸳쾀礦鋹⦀ꡏ븣⯫곸䊀禯驻΀箧髹ྀ箥ố煇ᑰྀ돮铱䪀酩᫚亀ꧪ諻侀ꯩ㛒䪀묇멹䮀毪⹓鍦鱳勦ꑛ얀폮듓暀ﮯ뫻஀⹰꾀鯅걛趀媮ứ캀﩯ꛚ凮鹃쎀껑ꭏ㚺満㬎뛫䊀另뻁잀窬⻪䪀絛裹⦀鍡⨻亀凭㙙ހ菥빙樀憯驫莀ꫩ辀팎㫣ꖀ鯥깱䜀ꂫ骪讀ᇮỹ贀ỳ잀ﯢ㸲쾀鋩亀揭빙亀룢⫺侀ꩫ螀鍦냹쪀⏤ૹ윀ꏭᑑ䔀鍤빉검古ૹ윀룅곚쾀ồ䚀⏪铨辀叢ᓸ誀鋮뻹叢㹳윀⏪꫸舀凮멹䔀⏨裺꾀⏪븣⮀升黹礧≱侀厧듹䞀逋蒺䮀⏪븠꾀⏧ᱫ䚀錃됻侀짬뫛ⶀ勯髹⺀툏ꑻ䞀實냑撀釫Ợ釭ỡ榀句㺸蘀叧ࣹ쬀폮냸䬀ࠠ蘀卥㙑䦀不雫寭냸얀⏭蓋䶀卍둹Ꞁ孍둹욀⏨⺒䬀꣸ꈀꓹ캀곣꬀狧뙹욀勥뱫஀珧ự춀孫뒻暀羚멻ꖀ骻ꪀ꯮⻓쏭㓓䌀⻲춀폭뛃ꖀ듻쪀듫檀毮㹑뮣꨻ꯢ⸓筦끛殀ỳ춀狯ự춀焇ჹ䚀㭇驻ʀ⇇ၸ⪀可빛Ꚁ卥ố⼀⏢Ⲳྀ듻䪀釭蒲춀Ꭴ㉓⌀祏鑹좀勭ỹ຀폫뻒郩躒㚰辀毧㻱잀步듙枀郣ꢺ꾀䫭铙澀ᇯᓹ끃꺪ྀ禯ᙳ挀孥黩篥黙寧뻹䚀禮빩Ꞁ郩Ẳ첀筅㣙斀遇꒒侀叢ᱸ⪀穆깫䚀檬ố沀叧㻩斀釭麲첀祏鑻䄀⏢㻙쾀멎냑則깻ொꪪꪀ煇㺪ꈀ括髙ⶀ叫飹Ꚁ⏥㺸蘀䧍㹑➀凮빙䜀六㹹ڀꮦ닩ꪀ⃧ᑱ좀煏衰辀奯鑛솀⏫衹讀⏥㺩씀⏨겺쪀⏫뒻䮀屢铹஀叢뺡毭鱹暀䯅ố⾀毅鳹趀孧铙춀毥볹暀롉Ғ䬀퇦ꑙ솀卥⹹ڀ铻䞀勦깓母볻趀뭁㐓伀鏢븓틮黓觅㻚侀㭯㚸伀믯⻹䬀窮鋩궀㋨뙓攀勞铛䦀另黹筧铹쾀只뫫쪀釪黛꾀揬뫛ↀ鍤裺꾀釢뻛꾀勮黹롫費殀䭅멱䜀勧뙹욀叧雹캀퇯뙻욀냥⺒꾀狭ố亀凇᳸ࢀ凭ṻʀࠡ䢀隷곻䚀⏩⚒롏銣ꨀ勧⹫䞀黪꾀퍍듸ꮀ둓Ꞁ寅뻸઀⃢ᱰ઀夏둑Ꞁﮨ㻨䪀怜ừ䪀着뺪꾀珪鱱솀ᮏ꫹䦀ፏ듐䎀凭ṣ憀邩ຐ辀멍㣙榀ﯫꓺ勥㹙얀ᅁᐛ섀升듑䞀釯ừ䪀鱐辀口㑱즀폭㻠殀邧ꓚ侀寥㹛윀勯ứ亀짅⹑⎀驪걹ꊀ宥⩱䬀⏫㺪䪀₇ࠠ辀먮뫑䪀宥⨃⮀䧭멙ꯨ鱑즀ㅂ㘠̀釣躳椀詉⦀⏫⛺쬀槭ᩃ憀凭鉳憀⏥㫹亀⏨鱂쌀⇇ၻ⺀凧룻⊀卯ṑ箤ứ亀毥᫁涀⏧ᰡ쪀珧㻱얀叧뫹⚀叧뻑ꃡ⩱쾀ꃪ麫뢯蒻檀郯諻⪀祍㑑䬀楎빩䮀ꢏ艸⾀ᇬứ䮀叧꩹⚀鍤裹䌀鍤衒鍤뺊釭鋳斀勥⡻䚀鋩⺀叧㹱쾀叫ಹ檀叢듻䪀诠ꨛⶀ㫃涀ꋹ侀틯ᛓ뇣㺳澀뇣뒚꾀櫎黩侀뻪뙛ʀ㫻⪀못満煯빙퇭뛙꺀飼ꊺ꧍衰辀ꧣ⳹䌀叮鹹䞀另黹侀勞鋻폮뻻䎀⏥㹰辀絛꫺叧ꩺ꾀ꧡ⪺꾀窯髹入㻓愀鏫롻⚀ﭏꣲ쾀婧뉹ꖀ勥뙁ꖀ釩Ị춀폭ỉꖀ妥㩁윀珧⩑䦀鍤鱸⪀⇂㹳釮黑殀鏡⸫຀笇듙Ꚁ宥뛑ꖀ煅㚊⾀⏭裸趀筦㛩䚀隷꣺꾀Ꮱ᩸⪀叢ม윀⏪鱱좀累뚋릫ớ寍뻙芀⏢⫸莀叮鹉只먫쒀ꇪ᫺讀ﭏ㛳欀裃곚澀寅뛹ڀᆏ钉윀煏ꩱ⾀勭᫹䶀⏥≰誀說᛹䬀⏪꫚⦀䇪ภ飯껫叮鳹쮀ꭃ둻侀鳺춀句᫁媮黉涀毦뻹Ꞁꩫꒀ童⹻䖀㭎뻫䊀⏢㚫句㻹둓䚀ꯋ볹䮀遏課亀ǀ ྀ隷ꢺ讀蓐䲀ꃥ⛚쾀䇬驉ꆀ摒꣸쪀⏪뚫梀䏫㱑侀兏鑑䜀﨨뺊⾀㍁㰳얀悂ࡑ䢀䅯껙樀隷꣪욀叭铙侀䧍㹑䞀諍㻑䮀異똃⮀뮡ꨃ궀롊肒筆깩揥⹹䔀⏪铸蘀叧꩛஀ꧮ郹句뺨઀䇩ṓ⅋鰓⮀厧ᓁ궀獧ᓩ຀煯㑩઀녍铻Ꞁ鉉⦀屢黹஀⏠萣஀䭤ꩰ辀⏥㻻䚀欎鑩Ꞁ꣫肻쪀勧깫Ꚁ剬ӛ䶀듫ꮀ냻쪀可胻䚀諻슀㙰꾀着뺂➀箦黡궀筇铩涀劉⹛暀箦뻡ꖀ釭ừ䪀觌鳫쪀꫺ހ퇧⹩䊀郫᫹亀絛顸⪀可꫺ހ摒⣸⪀燯㹱⏮곊얀筇铹䴀珧ựꫨ䪀筅㫑䔀⩱쾀폮껛卥㹑씀폭㻛洀卥㹳冷뺣꾀凮빁斀凮鹃憀ꫮ뻑揤㛙毦뻑槮빑릯髹઀絛鱑좀⏢㺉䦀폮뻀폪뻂郠⺂篭㹹䶀累铻䔀뭧멹殀叠㑻䚀凮빩Ꞁ梯誩凭陹ꖀ另黩꾀另뻩Ꞁ郪躪ꮀ⏨뺊⾀鍤ꐺꮀ釮黫Ꞁ只껪ꮀ叩蚸ꦀ郢꺪㯭㫓ꄀꧫ諺䪀秭㩑꤀櫥ꙻꖀ叧ᓸ趀ꁫ䚀⇂㹒薀力뻺꾀鍤빛⩁憀鍤裹쬀獵⩳鍤鰣卧㛁잀筏둩斀类ꫪꪀ禮빩ꮀ⇅㻺꾀充ᑑ䢀勭᫑롊躺䪀鳹䦀漏뻻亀楎鰱䪀奏둙䚀絛똛ⶀ句ᛩ亀鍤雱䚀뫻궀叧顺⊀⯍㺩ꊀ凭遻厫끹꾀凭ḣ榭㹑ꪤ멋ꖀ⊢㸣﨏ꪪ䪀뢏髩䪀笮뙉⒀宦ứ캀㙱춀箇뫩䚀뢪誢ꮀ冷雋⢀몏ꫪ쪀릮髡ꮀ㹱䦀⮭㻓鮧㩰誀箬㻫䪀叫ằ摒ꫨ䪀鍤빫薀ᮊ븡쪀祏멹઀뫁빹誀窃뫪亀宥ỹ亀ᮭ㻻䊀累鲩윀禯⩱쾀禯⫹쬀句㹲⏥㙰꾀𢡊곻侀⏪빓⩱䜀央껑즀⏨ⓚ䶀勧㹩䚀卥㙓⮀磊ᙓ攀珇鳱쾀叧ứ亀卥㹐趀兇鑑춀ꁊ᫲궀ᇭứ쪀⏪볒趀퇦깙턭᳻䚀狧⹳絛钛䶀类껢ꮀ叧⹩䚀돣㸳句뻑좀釦듺侀卥㙓攀뱹쪀獇뻩ހ鍤껨쪀槮빁ﯩ㢻讀勧뙹䚀珇볱잀絛ꓚ䶀ꓚ䶀絛ꂺ叧ࣸ趀⇅㺫宥㫑ր퇮黛כֿ㒚ྀṡ讀楎ꓚ䶀⏥㺢⬀폭㫓꤀叧㹚쒀쯬뫛ⶀ곹궀䂄듩஀燇㹳鍤븳롡ꂺ厧냹螀뫏뫹쮀먎뛩䪀牅⹓䞀ᑱ䜀뭡⨓ⴀ凭㹩욀䧌벋䮀筤㻑⊣㡲ꘀẓ椀멫ꒀ劉ø誀⇂㱫䚀뭃ꐻ䴀㍤깺ꖀ⏬㻫毦郹ᇬố퇏铋䘀句㻺꾀櫮郹䫏鳹຀叠㙋撀筎둹侀퇭볘煇Û涀毆볡꜀歃ꑱ쪀裋賺઀黚貀刣ᑱ좀⏪铱좀姍빘貀鏦骫슀뢏ᳱ쪀Შ舀䧬멙▀减ṫ⇂㸡䢀뉏뫑⏭鳺꾀﨧ᓺ꾀䏤⡹ꈀ⏨㋻ꖀ叮ᑹ攀句ố亀另髩䪀卢㙁叭铹䜀륈ಓ別ᐡ䢀鍤黉ꖀ⏫㓺궀⃮⺺叢᳸趀ꯣ꘻涀㍇ᑱ좀듰쪀卅둓஀⇅ṋ뻪ꪀ懭뙩揥ố鑳亀菥㹒叧뉩Ꚁ古㹓寫㸛䴀䯤멙검筧뻙絛뺪叧㹓只둫涀奏둑䚀苫꺀拥뙩䚀筭끹类⻪쪀筥ꁹ뻫䪀揥ꙩ䚀劉♫䚀鋻ꪀ叧듹椀卅ᓡ꾀뇫鳺免㑡Ꞁ髙ꖀ뻸ꪀ先鱑䬀⏭뫘ꆀᏪ껰쒀凮鹳ʀ叮鹱ڀ殤ộ満䭤袨趀⏥㫺꾀ꦬớ暀꧊鱳檤⹛暀珪针씀⏥ᐡ䢀뺻꫚⦀椏뙹暀ᆇ铸ࢀ禯顛릯⨃裸舀릯⩓筇뻹Ꚁ句㛙侀叠⹫쪀뺫ꪀ㻂䮀ꢏ衲ꈀ᱑좀凮뙱폪뻐辀ᇯứ퇮黹쬀鉩ꪀ릯⩱윀叧ṙ䪀鍤鱲䶀祏べ⏥㘱䪀兇遹⢀鍧᱂窧꡻臢꫚ྀ뢃꫒꾀룂⻺꾀祏빱䚀퇭뛩஀骭㻹䪀ℯ铹䤀뭏黳䚀禭㹑勥㸻勭ỹ絛ꪺ句ỹᅥ㺨䘀⯢㺫句⹹퇭㹻퇭雃ꖀ叧㹒叧㹒꜀叧㹃ꐀᇥᑙ䪀叧㹒煅㺳鍤걺ꦀ叢㹓凭빹욀凯멑䇮詩ހ煇ࣹ쪀箦⹫䚀⇏鲩숀⏫衰꾀妥㫓ꯤ鲩숀ꯧ驹궀⏪⻚讀揤鳑辀叧髑句鹺쪀⏤ṉ⦀禧驹궀郩Ẓ讀ꃬ貒讀⏥ᰐ઀걑莀媥⩻䞀볓讀叢㹁준口뫸ꖀ只蒺侀宭㩑⏥뙣䚀鏢⸫궀减鑰辀寥㹛씀媭᫑拤뛊䶀类뫺涀폯룻⪀炏萣஀⏤၁΀凮빑暀䮪먋ⶀ凭ᙛꊀ鋭㛙ꪀ箯끙斀⏤ᰃ⮀叮ᡡ薀蠟鑺ꖀﯥ㺩쪀審髸辀句᳹쪀叧뫑隷鑱䜀勥♛Ꚁ폭㛛ꪀ듣관ꯢ긓㍦깪욀㭮鱑좀劎黑폩㛚ꪀ᭏듐䊀寅뻹઀免鑓䖀槮빹䚀䄆ᑁЀ絛肨ྀ毦黹亀叅㻑䔀퍮髩䚀폭㫃侀퇯髓─䋮髩可깛Ꚁ뢨ສ䪀텆깁礯鹓孮둹䚀⏥⨳⏢Ჩ숀勞銹Ꚁ館ꪪ⢀刣ᐁ쾀⏭㻓⏭㻑⏭㻱즀⏭㻓积鑻䎀鋭㻑Ꮽ㻓卦뫩䚀䇫㹑㯯듸䎀句㻹ڀ叧Ჩ씀뫻䪀另듑䚀퇭㣘檀筅㛑䞀닸ꦀ毧뻙ꒀ⏥㛙䬀奯둹䚀ᐡ䢀句ố⏢ᰡ쪀釩ຒꃥ꒢澀禯㩑ր句㻻⏭㻓龜鉉⦀孯鹩䚀ꧪ麒顫躪䪀叧㻘趀Ꮽ㻐⇂㸡쪀叭㹑஀㲂➀鍤빓祧뛻䄀⏪钱Ꞁ⏭麰꾀釫Ớ䪀叧㙳䚀톯ᓃꖀ쯌볫쪀鋏듉䨀觍鳛얀⣺䲀אָ듻亀㩻暀叧㺸䘀菥㹓ℯ鲣㹪蘀珪铩檀ꥯ铛⪀另뻑멯㛩鋮뻩쪀﨧ᓸࢀ㢥ࣸꎀ⅋胛愀絛꫸ꖀ㮯詙쾀ꡇ곚侀媭ᣙ涀Ꮻ꣸⊀멎듹䮀퍍铑䖀釯ᓻ䪀㍇꫹䦀厧듹劧ꑻ攀穇깻뛻澀寅麹殀毧髹亀毧뫹䚀句㺚䪀⏤᳹亀灏衱쾀ᆃ렻莀餯铹⏤ᱱ䜀窧깫䯅뱛얀句㺩䪀煯㙡⏢ᱲꈀ폭ᓨ઀隷ꋺ⾀⏧⩰辀䇫軘ꖀ樃뫺검⯢ఱ䦀蠟鑹䪀륭黛Ꚁ句ṑ좀뻛ꋚ勦꩓䚀ꊊ⦀䇪騹⦀ᅇ뙑⎀遂麂⏥ᛩ䚀卢㛓攀不ṛ섀㹙伀⻹䴀䇊㸡䢀廓ꪪ讀窤㹩䚀拤꩛▀叧㛹쪀뮢갳검铛춀叫⹫寧뻹씀叫骩䪀勭铙澀厭適Ꚁ⅋驫஀運躺ᇭ᫡⮀鎡뀫꺀톭끫Ꚁ⯫⻰쎀凭㡙斀祏빩䚀灇髸궀⏢౒薀⏪鳑씀⊭꫚꾀妭ᨃ⮀劉㻘趀孧雙䏤ỉ升뛹枀끋軺궀끏電涀ꧭỹꮀ믅볲캀₏꫺꾀句⡙斀欅⩁斀돣㘳満뇢껚꾀煏꫺ހ說ỹ伀寅钹䞀뺓쮀䇤ꨐ谀灂㸨蘀⅏裸誀䇄᳸䌀ꯥ⸁윀媯꫸ࢀ빙຀凭뱹凩際ꊀ諍㻑䪀⏭衒⏫㺫孧铩満箤ố澀另铹춀㭫뒻쎀孧듩暀毧듹ꧩຓ釮蒫榀凮둩榀絛꫺ꪀ⏪鰣叢ᰣ᪥뱙즀句郹쪀叭衒劉ࣹ亀뮠⸓澀電涀馠⺓澀듪檀叢㹳ꔀ녪鱫஀捥雹䴀끤갓亀裉Ẓ䪀ꠉૂ盛꫹侀盛꫸ࢀ釭蒺춀絛ꑛ얀篫롑篥⹑⏦裹쪀另裹쪀寏빛蒀珪胺꾀颩ૂ媥⩃斀叩誐㫃涀ᓲ쾀窯ꫩ言ꯪ뻺殥뻙텬ᚂ쾀叭㘁쾀叭꫻퉬ᱱ즀雫▀⏧ᱠ趀ﯪ㚫쪀⏧⸓鋹쪀㯧둻䎀Ꮵ뙻ᇮዩꪀ⏧᳻䚀篧ꑹ䞀絛衰辀䯧ỳ쮀폩㫂䮀勥빑⏪钫⏥ᑑ辀句⹛另黑ᮭ㫃憀䩯隩釪Ẃꪀꅭ骂쬀Ꮶ㹃ꊀ㭩먁윀퇦⹁ꊀ釬髫䞀㫂䮀⏥㹱솀寋骻쮀禯둹Ꞁ⃮⺳⮀卦ᑪ쪀⃮⺳ࠠ蘀⏥㺉䦀凯멑꫻郡ẫ䪀⏪鳙쪀ꥮ雋롡꫹쪀釪躓欀ꥏ髹ꪀᇯ髑폯뫓퇭᛫䚀릯黻䞀⏉㳲趀鏢긓釢뺫侀煏鱰辀폩㛪䪀嫍蛹蒀⏢訩⦀娧ꑓ冭끹絛꫺螀句㻹䔀ꧪ黺ꪀ楎끩⯦빻ꊀ껣澀톭끻냪냨歎낫⍥멃憀燈针辀勞铻䪀燄૸誀륋雹઀⅋胸ꈀ冭끹攀䧭멙ꒀ邥肺椀뛺ꪀꯥ⸛蒀厭遹攀Ꭵ끻愀參ᓱ䖀叢ᓸꈀ劭郹洀句븓珪铸ꈀ珪鲩쾀곺䶀冭냻洀ﭏ듻➀ﭏ뒙侀ꩩ⦀⊣㡸궀銘઀陻䚀⏫㺹쪀⏥㙓⮀歎適ꡩ蚺ꮀ凯빑鍯곹쪀勧깓듻暀叩຺侀釣⳺侀勯黑煇ࣺ⾀㍇Ჩ윀宥뛩斀复뙑䨀㫀殀᫃涀珪듩涀ꯨ裹⦀⇏鳹亀⏭뒚铹䤀寫뺚歆뻩䚀寧㻙씀郪躪쪀溺ồ⏬鲣釮黩쪀鍯铹솀⧂㹲莀密빳歋멹꺀寫㺚촀⏠ᑑ䢀䭯곺䶀嬧ꑑ폭뛛ꪀ媯铑鎡뀻祏둩䚀電搀뭃됻꾀流븲辀폭㣘檀폮냫Ꮷ㨃⮀叅㫑叫᪸⪀龜隨侀暈᱑쾀㻠鏢됻䶀叧㚩쪀另⻛䪀另뛹얀釪骲퇦ꙹ솀폮뛻춀"
    KNJLIB_FONTDAT$[3]=""
  ENDIF

  ' ……………………………………………………………………………………………………………

  ' 4:M+ BITMAP FONTS 10
  IF FONT%==4 THEN
    GKNJDEFINIT 10,11
    KNJLIB_FONTDAT$[0]="    䈐耠 ʔꔀ  꼫쩐 쫢 1脲ذ 䨢푐 Ĉ䈀  䐡Р耀А舐衄  ꉸ言  䉸萀   "+CHR$(34)+"  x    @ ∑ࢄ ⭪剠 쨐萠 ℑჰ <∰剠 쩓쐠 =จ剠 ๊剠 <∑ࡀ ⤲剠 ⥉쉠  ȀЀ  Ȁр 䑁А  ༃쀀  興袀 8ℑ@ ⭒큰 ⥺劐 9⥲勠 ⡂ၰ 9⥊勠 =ࡲჰ =ࡲႀ ࡚剰 %⥺劐 䈐葰 ℊ剠 %䱢銐 !ࡂჰ %浊劐 %ꭊ劐 ⥊剠 9⥋邀 ⥊剢ఀ9⥲劐 ࠰䋠 >䈐萠 %⥊剠 %⥊哀 %⥋嚐 %⤲劐 %⥑ࡀ <∢ჰ ΐ萡ࡃ耀%䑹Ṁ ܈䈐萧 ĕက    耀Ȑ䈀   ؉퉰 !๊勠  يၰ ❊剰  ً큰 葹ࡀ  ݊剰頀!๊劐 Āؐ葰 Āؐ萡　!॓ᒐ 䈐萰  བ떨  ๊劐  ي剠  ๊勤  ݊剰萀 ୢႀ  ݁苠 輡࠰  ॊ剰  ॊ哀  ो嚐  ॉ銐  ॊ剰頀 ༑ჰ Ɛ葁ࡁ耀Ĉ䈐萡 ؈䈈萦 <    銓 ΐ萡ࠀ  䈐萧     1耀 <ⅸ䈢  ༉䱄  đ鐡  Ѻ䈢  yࡇ耀 ɸ財  ѹ䨡  p萧耀 x帗耀 Z툢  A쀀 <℩袄 䈲萡 ȑ䈢 <萡ࡇ耀刑耀ȑ刓 ȑ쐡 Ȝꥈ䈢 Ȑ賂䈢 <℈䈗耀ʕ䈡 ȉЀ䈦 <ℐ誔耀Ȑࡁ耀%┨䈢 Ȝ꥘䈢 ¸䉸葂 -歘䈢 ΀ྐ葂 Ȑ蘩⡂ ĉ葂 < ð <ℨ葔 ĉ阩 Ĉ䈑ࢄ Ȕꔩ劔耀С⩢ႃ耀<℈䈢 1詒鈐耀ȑ嫒 <⅊蠡 Ȉ␐偁耀Ȑ萢ኗ耀ꔐ詔 <葹ࡁ耀Ȑ䐡 8䈐萧耀<ⅸ䈗耀̀༈䈢 ҥ⥊䈡 ĩ䩒钭耀Сࡂ劦 =⥊劗耀=⤈䈢  耀䈦 舠耀  撤쀀  䥂"
    KNJLIB_FONTDAT$[1]="            䀈    Ġ䠌     À〘     À　    ؁耀    怘 `᠀   怘 `᠌ Сࠄȁ က  Ȁ ࠀ ဒȀ     〒Ҁ쀀    ࠄ      ဂ      㘍耀     ࠅȠ     ?           ࿼  耐Ȁ䀐   䁈蠐Ȁ䀐    耐Ȁ䃰   䁈蠐Ȁ䃰    䠒ं䀀  ȡҀ辀耠ࠟ쀀 Ȁႁ䀠Ѐ  Кऄꅄ怐  ǁ貀ꀨঌᰀ   @࿠      㿰      ܀    ‐ࠄȁ䀠  Ѐ耐Ȁ䀈Ā   0ቀ怀  ᐅŀ倔ԁ䁐ᐅŀࠂ Ȁ耠ࠂ   㛍뀀     ᣆ　  ఁ耀     ᠌      㘆쀀     㘛      Ā耠ငĀ䀐Ȁ耐䀈Ȁ䀐Ё@ ЀĀ聀ငĀ䀐Ѐ耐䀈Ā䀐Ё@ဈЀ༂ Ȁ耠ࠂð砂 Ȁ耠ࠂހ́@င؀䀐Ё0怄Ā䀐́@င؀ 䀐ࠂĀ Ā䀀Ѐ耠Ђ䀐 䁐⠊Ԁꀨԁ䀀ԀꀨԂ肠倔 ༂ Ȁ耀    Ȁ耠ࠂހἄ䅰倔ԁ䁰    瀔ԁ䁐琑߀༃胀〈Ȁ耰ః胰砎ƀ怈Ȁ聠᠎ހ  ῀耠ࠀ    ῀   ⁿȀ耠쀀 А蠔ȁ䂈䄀 ǀ ῀ ᰂ      ࡿȇ䀀  0〰〃0̀  ؀怆`恠怀  耜àϾ?8ǀผ㠀Ͼ? 貔ꈩ䦌   瀈⇜∀  ø؂輤䤐䐎 Ƞ蠢܀臼ࠂ ҁ‰    ࠄ      ሉ      怤ॱꈐЁ"+CHR$(34)+"܀ 䈠偿ȇࠀ ϡ⑈ྀ鄤㸂 ሄ胸ࠂ Ƞ胼ЇɄ渀 褢偨ˁ䢒⌀ 脡︒҇ሀ ɀ逛詄儘㦀 Ґꠜ઄造  舑㉒钤킀Ḁ ᰈ舀瀢ࢁ쀈∇ 僷遂₨眐䀀烿鿃眐䀀رҀꀨऄ指 ߱ﳿ뿯識缇 ر璢ꢪ⥴指 ŀ衁․ႈᐂ ǀ㿧ᰂ ɀ逤ं羀 ﹿ鿧茶羀 ŀ倢ࢄᄄﾀ ǀ瀾྇ﾀ ?Тࢁ䁐ࠀ ?ﰾཱྀ쁰ࠀ А蠔∡䂈䄂 쀀Ȁ耠ࠀ  @ࠁ㿠ဈЀ  Ā聀㿤က ǀꡉȀ耠ࠂ  Ȅ邨ᰂ  ﱿ   Ǹ聀ῤᾀ  ߠЀ鿠ࠄ縀 @ࠁ耐Ȁ聇 Ǹ聀ငᾀ  ߠЀ耠ࠄ縀 䐑с၄ႈᰀ ȡс၄ᄄ䄀 倔ࢂ℄䄀 䐐蠢ԁ䀠ࠀ   @င   @ࣿ/Ѐ  ŀ衿‧᐀ 䐐ԁ䀠ࠀ 쀐ѿ@င缀  䀠ဈЂĀﾀ  Ȁ耠ﾀ زȀ    Ġࠎ҂₈␆ ?萢ಁ䁰ࠀ  ﰀ῀Ǽ  ܀聿܀耀ℐ衄∄䂈ᄂ "+CHR$(34)+"р蠑ȡႈ䐢 ၈ሊ芠င  貄ꈩঌ   貔ꈉ䦌   ȡ 聰ࠀ ŀ䀐Ȁ䀐ᐆ 앑၄ࢁ၄唙耀ఄ脠〈ԁ삈∀ 䤢偨ۂ䦒鬀 Ȅ脰砲Ӂሄ Ā䀜ҁ⁐᠀ À㠊ʃ臠　 ࠂϠ ܁쀠ࠂ ࠂϠ“܀胸ࠂ 莠ڀꀨ਀ رҀꀨऄ指 舐萡ࡂႄḀ À倄Ā䀐Ѐ 舐萂Ā聀㼀 쀠ဎ@ႄḀ 肠䠢ࢃȀ 숀耾@ႄḀ 脀耾ࡂႄḀ 쀐ࠄĀ耠ࠀ 舐萞ࡂႄḀ 舐萡߀ဈᰀ 倔ࢃ䄀 舐萾ࡂႄ㸀 舑@ငḀ Сс၄ᄈ簀 숀耾ࠂ㼀 숀耾ࠂ  舑G၄ႌᴀ 䈐萿ࡂႄ℀  Ȁ耠ࠀ  䀐ЁࡂႄḀ 䈠逨ം₄₀ Ȁ耠ࠂ㼀 䘱呉၄ᄄ䄀 䌐ꐥࣂႄ℀ ȡс၄ႈᰀ 舐萡ྂ  ȡс၄ႈᰁ0舐萡ྂ䂈℀ 舐耞@ႄḀ 삀 Ȁ耠ࠀ 䈐萡ࡂႄḀ 䐐蠢ԁ䀠ࠀ "+CHR$(34)+"⢊≕ᕅ傈∀ 䈠倈ȁ䂈䄀 䐐蠔Ȁ耠ࠀ 쀐ࠄȁ㼀   瀂ނ₈Ḁ Ȁࢂ₈㰀   瀢ࠂᰀ  耠砢ࢂ₈Ḁ   瀢ྂᰀ 肀‾Ȁ耠ࠀ   砢ࢂ⁸Ȉ臀Ȁ뀲ࢂ₈∀ ࠂ Ȁ耠ࠀ Ё Ā䀐Ё΀Ȁ蠤ਃ䂈℀  Ȁ耠ࠀ  ቄ鄤䤀   뀲ࢂ₈∀   砡ࡂႄḀ   ࢂ₈㰈Ȁ  砢ࢂ₈Ḁ耠  堘Ё@က   瀢܀₈ᰀ ĀЁHఀ   蠢ࢂₘᨀ   蠢ԁ䀠ࠀ  ⑉ᕅ傈∀   蠔Ȁ聐∀   蠢ҁ䁐ࠂ̀  ȁ㸀   䁿Ѓ夌耀င࿸䀾᥊誢焁耀  "+CHR$(34)+"ࢄᄄ䤌  Ёҁ ढ　   ܆ І `ᡀင؆   砀ྀ䀠ᐈ쀀`䀰㈰怀 Ā䡽Ѓ儙耀ငߐ䈐྅ቂ邘쀀ငē褢䤐䐆 ᄅ℣ू䤒䐆 ࠂ쟀᛾ăꄘ䀏 ᄅ➠⃿脃ꄘ䀏 䀠ࠁ Ё Đ鉂ဂ@ࠂ Ȑ萢纂₈∈䐖 đ␢纂₈∈䐖  Ϡ Ā䄏耀 ߐȂDȀ舟 Ё[݂むဃ耀ं₣ຄ愀  Ȁ聀ငᄄ∇ 䉈血ငᄄ∇ Ё࿸လं䁰ࠌ Ё࿸ဝढ恴ࠌ Ȉ舠黺ࢂ悀 쀀ĉ∠黺ࢂ悀 쀀쀠ဈῠ聀ဃ耀䁈⠐㿁  င࿠䀗蠂ₐ䐐℉⾠耯င䄠蠡쀀ငŻஃငȇ ᄄⅣஃငȇ   ᲀငȇ  ǃ蠁@ဘ㠀 ँ⇃蠁@ဘ㠀  ǻ逈Ё@ࠁ耀 ǻꀑढ₀ဃ Ā䀋́ 쀀ĉ∠耖؂Ā䀏耀င俈聂ႈኃ ɹ@ᄄ脠➈ Бс硥ᄪ誺餙ꀀ ɣꐰ蠦㪒⒈쀀 Ǡꑈꈩੂ愁耀Ȑ萢纂₈劓 đ␢纂₈劓 ̑⑊粂₈劓 ཀ䠣ࢤ℈䐎 ā⼠䀢ࣄ⤈䐎 ́⽈䰢袄℈䐎 耠ဈቄ划蒆 ď†ᐈቄ划蒆 ̏⁈ᰈቄ划蒆   8ᄈ    䁈࠸ᄈ   ́⁈సᄈ   ࢟ꂈ劓 鐲࢟ꂈ劓 ̗⑊ಞ₈劓 Ё࿸ၿă섘䔎 ␉Έᩄ戃 ငྐ䉰␉Ƅℇ耀Љɀ⨪詂愁耀ࠂ߰ ῁Dᄃ耀  ဤஇ偄ਂ Љɀ볲萡〠ࠂ   ၎ᕅ傸␂ Ёǲ銤鄥䤼І    ΀胠䰌耀ࠂ㰈ȃ섘䔎 À@ឆငȏ 舠蠢ઁ І 聀“ᢁ邔☇  ɣꐱࡆ⊈∈怀聀“ᢀငȏ   䀐ᶁ遄ㄕ耀 ɣꐰ蠦ં℉耀@∨멒撀쀀쁀硡ك猣 ࠂ߰䀙覄ꁈဃ쀀䀐؂䂒䒐쀀  ?@ꀠࠌ  ߸ȉʀ耠ဘ   Ђ̃䀐Ё  䀐ࠄ܆䀐Ё    ࿂ႄȃ ࠂ﹀造င؆   >Ȁ耠ࠟ쀀 ߰ Ȁ耠ﾀ   ࠂ࿀怨㈁耀ЁC︄̃䌐Ї ࠂ︈舠衂႘쀀ᄅ℣ﰑсႄℱ耀ࠂﰈȏЁ ᄄ℣ȏЁ ငǰ䐡၀ ఌ ĉ∠₀䀐᠘  Ȁ﹄ᄀ䀐ࠌ 䄑␡ﲈ∀耠ဘ  ߰Ё@င缀䀀ँ⿠ࠂ ︀耀Ȉ舣︢ࢀ І ĉ∣︢ࢀ І Àɠ虀ဈఌ ę↠`蘠ဈజ  ߠࠂĀ䀨㄰䀀ँ⟠ࠂĀ䀨㄰䀀ငĘ娸둁⁀ဃᄅ℠东뱁⁀ဃ ␉Ƞ血ဈఌ ँ⠂сႀ‐᠘ ငǰ䐩ᅀ జ उ⏠衒⊀䀐ᠸ 잀 㿠耠ဘ ā➠ 㿠耠ဘ   )ੂ逄ȇ  ҉∤褠င؎ ā⤢䁉ቀ జ 쀀ÿ舀耠ဘ ğ†ÿ舀耠ဘ Ȁ耰ଂむ  ĉ∠耰ଂむ  ЁA︄Ā䀐ࠌ  ϰ   羀  ߰ЁҀꀐᨘ䀀ࠂﰂāꎤࢂ  Ё‐᠘  Ā䐑ࡂࢂ䂐 ā∠耠ႄ℄脠䀀́≈谠ႄ℄脠䀀ЁౌᰄĀ䀏쀀đ␡GḄĀ䀏쀀̑⑉ౌᰄĀ䀏쀀 ߸Ȁ耠င؎ ँ⿰Ё@ జ ́⿈ం䀐᠘   쁈℀    䁈࠰ለ䀈ƀ  쁈ሳለ䀈ƀ ࠂ︈Ȅ鈢ࠆ Ԃꂃ︈Ȅ鈢ࠆ ং邧︈Ȅ鈢ࠆ  ߸ȁࢁ䀠Ѐ耀pƀ 㠁쀀Ā䀡ࡂᄚ碀  䀐䐉ƀ—ᢘ  ߰䀐㿡@ဃ쀀  䀐׃逨ࠂ ငĸ狰葀造ࠂ   <Ā䀐缀  ߠࠂ ﾀ    ྀ⃸ȏ耀 ߰Ё῀င缀䀀쀀耠ࠄ؆ 舠蠢ࢀ І ҁ⁈鈤鄤訣 Ȁ耠ࠂࢄ☎  ߹ɀ逤ं羐   ?ࡂငȃ  ߹ɀ造င؆ Aﰤं䏾Ё  ߰Ђ̀耠ﾀ  ߰Ё῀ဈఌ  ؀戀聀ဈఌ ᄅ℣ﲁ⁀ ఌ    ῁၄℉耀  耠࿄䀐ࠌ 倔ࢃ䄀 Ƞ蠾ࡂႄ縀 섐䀐Ё@㰀 倔ࢂ℄缀 숐逼ं缀 숐ࠄȁႄ㼀 萿ࡂႄ玀 舑䩞钤ࢄḀ  Ȁ耠ᰀ 쉀ꀰਂ䂈眀 倔ࢂ℄䜀 8呕ቄ鄄 ꐩू傌猀  縀 ȡс၄ႈᰀ 술蠢ࢂ₈眀 脐䐑ށ@㠀 섐 ȁႄ㼀 쒑␈Ȁ耠ᰀ 쥈 Ȁ耠ᰀ 肀ቃ㸀 술倈ȁ䂈眀 Ғꨪ܀耠ᰀ ȡс၂⅔眀   戥ᆄ䄰㈀ 脐䐮ࢂᅄ丐Ѐ  챌ȁ@  脐—ࢄℐ㠀   㠑܂Ḁ 쉀怐ࠂ@ࠁ΀  т₈䐁@脐萿ႄℐ㠀  Ā䀠ࠄᄘ㠀   䘒ः脤䘀 @င܂䄈膀   䐑ࢂₒ嬐Ѐ 舐葂₰　 삀簠྄àЁ΀  㠑ࡂႈᰀ  ﱒ҂䂒䌀   㠑ࡂႈ尐Ѐ 簢ႄℐ㠀  ﱈȁࡄ฀  Ƞ萡ႄℐ㠀 @砩ቄ鄨㰄Ā  숉ʀ쁠⠑࠰Cረ詄鄨㰄Ā  葈鈨詒挀 倔ࢃ䄀 舐耾ࡂႄ縀 Ƞ蠾ࡂႄ縀 섐䈐Ё@㰀 선䠒҂₈缠 舐逼ं缀 ㌀ߠ萤༂䂄缀 Ғꨪ܂ꄤ 蘑ЎᆄḀ 谥੃ႄ玀 ሃܸ萣ୃႄ玀 䈨逸ं₄玀 ␉Ɉ鉄掀 술蠶ᕄ鄤 萿ࡂႄ玀 ȡс၄ႈᰀ 萡ࡂႄ玀 舐萡ྂ瀀 䈱рငḀ 쒒∈Ȁ耠ᰀ 䐒ʀꂐ␆ 肁ﲈꈧ㸀 䠌҂ႄ玀 9쐡ࡂႄ℈＀ 萡ࣁ퀄΀ 6⑉ቄ鄤ﾀ 6⑉ቄ鄤ﾀကԂ䀟Сࡂ㼀 8ѹᅄ儔ﮀ Ȁ耾ࡂႄ縀 ءЙীᄈ㰀 9쒉≸鈤褢 쐡ࡂྀꁈ最   ྄℘㤀 ă脀렱ࡂႄḀ  ྂႄ縀  ࡂ瀀   ﰒҁ₈缠   砡࿂Ḁ ㌀ 砡࿂Ḁ  ⒪蜂ꂨ즀   ΀ᄄ㸀  옣ू郄掀 ሃ蘣ू郄掀  찤踂悄玀   ︑щቄ掀  蘡ೂ킄玀  측࿂ႄ玀   砡ࡂႄḀ  ︡ࡂႄ玀  렱ࡂჄ⸈܀  砡ࠂḀ  ﱉ∠耠㸀  ࢁ䁐䠒̀겜ꈨ該欂ǀ 츒́₄玀  鱂ႄ℈＀  측ࡂぴƀ  湉ቄ鄤ﾀ  湉ቄ鄤ﾀက ⟁ࡂ㼀  蹁Ṅ儔ﮀ  ྂႄ縀   砡́やḀ  鱈鸤褢   ﹁၃掀    㿰   ࠂ Ȁ耠ࠂ   ϰ耠ࠂ   㸀耠ࠂࠂ 㸀   ࠂ ϰ   ࠂ ϰ耠ࠂ   㿰耠ࠂࠂ 㸀耠ࠂࠂ 㿰   ࠂ 㿰耠ࠂ   㿿ﰀ  ఃÀ「̀쀰ఃÀ   ϰﰰఃÀ   㼏쀰ఃÀఃÀ「㼏쀀  ఃÀ「ϰﰀ  ఃÀ「ϰﰰఃÀ   㿿ﰰఃÀఃÀ「㼏쀰ఃÀఃÀ「㿿ﰀ  ఃÀ「㿿ﰰఃÀఃÀ「ϰ쀰ఃÀ   㿿ﰠࠂఃÀ「㼀쀰ఃÀࠂ 㿿ﰀ  ࠂ 㿿ﰠࠂࠂ ϰﰠࠂ   㿰쀰ఃÀࠂ 㸏耠ࠂఃÀ「㿰   ఃÀ「㿰쀰ఃÀ萒抈ꈨ訢䄏耀萒犄ꜩੲ䄏耀萒犄Ꜩ䩲䄏耀萒劔ꔩ쨒䄏耀萒犐Ꜩ䩲䄏耀萒犐ꜩ䩲䄏耀萒犄ꄨ訢䄏耀萒犔ꜩ䩲䄏耀萒犔Ꜩ䩲䄏耀萒몪ꪪꪺ䄏耀萒꒩⩊䄏耀萒몢ꮪ誺䄏耀萒몢ꮪ⪺䄏耀萒ꪪꪪ䄏耀萒모ꮪ⪺䄏耀萒모ꮪꪺ䄏耀萒몢ꢪ䪒䄏耀萒몪ꮪꪺ䄏耀萒몪ꮪ⪺䄏耀萒꺪⫮䄏耀 Ȁ耠ᰀ 腀倔ԁ䁐㸀 슠꠪ંꂨ缀 슠꠪ં䂐琀 술蠔ԁ䀠ࠀ 슠꠪ઁ⁈ᜀ 7呕ᕂ傔⾀ 7⩚隢ꢪ⾀ 슠ꠤंꂨ笀 술倈ȁ䂈眀 0̃4넣䠒쀀ྀ胸ס䠒ҁ༡䉀跀‾ȁ ո새叔蔢怀帐蠬뀠ᄇ쀀 ࠃ삀∈䠂ă耀>耧뀁ň刧 ∃㠊叴┱怀%ꥨ䉣叔蔢怀>ࢀ㩶耤燠䀐 ⪚胩ɀម Ձxᅄ儔ं怀༡䉀跁xင ဪऺ䀀♎ኖ蔶䀀=⁋툀볅劔봩怀ࠅڂ丈゠ꬠး  ꪪꪪꪀ  벊ꊨꨪ檀  ࠂ粪늪ꩪ誀  ꯊ芼ꢁ쀀耠ࠊ岨뇊艜袁쀀 貔ꄈ䈐玀  쀋쒪⫪芠ꠀ Ⱦꋺꢪ讯났⺊ ԁ䂠⠀       ਂ腀倀 "+CHR$(34)+"ಒꪚꊨ鈠讀 %⥊铆⥊剒钀 >䐑瑑ᝅᅄ嶀 蒒⊎ꈨ諺䄏耀蒒着ꪫ䤏耀萒愈ꌨꨢ䤏耀蔒敖ꮬ䩺䄏耀蒒敖꾭⩺䄏耀䭋ﺤ꿮䪺떙䀀䯪⊞겭麔쀀䥚銿뤪䪒ꊘ쀀仢ꬋ뮪亖॥兔锥슣뺺뢫܀聿܀耀 ﰀ῀Ǽ  ŀ䀐Ȁ䀐ᐆ Ā瀪ંꁰІ  ߰耐ȁ缀 ၈ሊ芠င  Ȁ耠ﾀ  䀠ဈЂĀﾀ Ё@ငĀ羀  䀰ᐉтᄄ＀  ȡ 聰ࠀ ȡс၄ᄄ䄀 䐑с၄ႈᰀ "
    KNJLIB_FONTDAT$[2]="?ﱕᕇᐿﺪꪫ直쨏Ȑ蓻졟钊ﮈ刓?뫊ꪪꬺ肠怀ࠂ࿸蠢ཱྀ䮔∞怀쒐裿ꐥ᰸Бҋ﹈៦⍾䔶 쒋쁟鐊ﮢ墓#ᠹ도ⅾꈧ∈迺呒迌觼ᐸ∈迸僿镅农䄟쀀"+CHR$(13)+"绪韧⭾刐?ﱕ῁䏾儧ꀀ﹕៧⍾䈷'纕១⃾䈧锥祀邧∈迸ⁿяﾁ ∈迸裿衂ჼ䀐 ȝ⧻좯뵊ꯐƫ耀Ȉ菻ꐩῦ⋾ꈈ耀ࡂ៤∈舏辑ዱ♏剆䀀ꡋ鈧䭌䔶 ࠂ࿺˷镇剜⒱锪篒䒓Ȉ舣ﺪ⪏ꂈ⨾Ȝ衋튗밉篒꒵ࠒࣻ숮銯꺨쀀Ȑ觻蠿鉏梤꘮怀Ȝ褣㺊ﯢࢫЁ⿸ࡺ銧逌 ?ﱕῂꏾ⨲怀쒋쀟蠄ﮢ墓ࠂ࿺Ȑ㿢₈㰰Ё߹⡒鿥⥾鈠Б׻쉄៦錤䘶怀Ȁ迺钥㿪誾ࠂ࿺䉿҂鏾⨲怀=뿩䫺钧怀Ȕ迹䋴⯯邤怀ࠂ࿸栩㈠臼䄟쀀䔑⑁၅⎈ഌ 绂邤龜䈓 ЉϹÉቄ鄨䈗ЉϹ჊銥醤䪗 Ȉ菹ዟ鉅賂羐耀?杖ꔯ禍꒿ࠂ࿸⑿ሏ㘰怀삃︪቏㸰怀Ё⟹ࡾ钧튤늳 ¾⣻봢⪢ꢘ怀Љ䋺꒿ꩊ瘝⤋ࠂ࿸䣿衃儧ꀀ¾⣻騪堀儧ꀀ萡ᾂϾ䢤쀀Ȉ菻鐨鿦ꪪ꺈怀∄聁࿄᏾怀쒑ﱉ῀Ͼ∾怀쒑ﱉ㿢⏾∰怀"+CHR$(13)+"ᓲᇭ覔䘖 Б䣻鉏꤫Ȑ觻鈿鉏뾨耀﹈鿢ჼ℈쀀∈迸⃿蚎颈᰸ࠂ࿸䀤ᤪ傈℞ ?︒뿠设ꢺ怀С׸ሿ뉅龜ꀧȠ藸䨿뉄ꀧ?粤㿨ꉄꂿ∈舣︢࢏䈐耀ࠂ࿸䠤ن‐ᨸ䀀Ȑꗻ衞閥兴 ࠂ࿸裿ၧ缐䀀 詻㊧ꤪ笒耀Ⱥ앩Ⲗ뢋着댻    㿠   ࠂ࿸⃿꠪棠ℏ쀀ढ萀ﺉᐣ唯#씠︒럤ꅎꀧ걉䫨ᇭ䧞咕∈迸袈Ꮱ⠈䔦 ∈迸蠀῀菾ࠆ 㽫殶ᚫ怀ȡӿ蔁䁒⒱"+CHR$(13)+"ዴꄨ䨒 銿ꤪ꫆숑﹀鿤৾መ怀?⋿ꈩ䪊肿쩟钩毦傗<䄐䓱⁏၄ᄘ䀀Нࡻ뺈ꏨ锺 'ꑈ䪈០⁾䈧ဩ䯒䒥⽊勴꒫ ∈迸䓯ꢍ敖й௺苏ꠋﬨ説;쬊뻀⯪፾褧ꀀ?蓏꠪﬈ꢫꀀ​쾑繐뿩௾褼 ĸ䨒ﺡ⩊劄쀀ࠂ࿸䀐࿆ኄℏ쀀ࠂ࿺ʾ舀菾ࠆ ࠄߡࡿ逇咪쀀=剒萣᥊钌怀'ࠟ낄℘ꀧ?ﺈꪩ騢ꪦ怀"+CHR$(13)+"劔ꔯ䩒▉ ȩ˳㹌梨쪕怀ࠂ࿺鉏㹄伬 脠䠒㿢₈∿й䓹⒟멊瘝ꤻࠄٹɀ鷤ं䂟'씐岕ῢꢪ溨怀؁࿺ꊿ⨊䀹뺨ꨪﮀԆ 䄕亹哿ꔯ既뒵怀∈迸裸ꏯ訒着怀쥳뺪ﯤت怀Бӻ퉕៪䎾向?㵉﯌ꔶ怀Ƞꗸ࢟钡徤ꀀ⑉ቄ鄪뺠 =뿨諺袯ꀀऀ迺ꪭꨫ廒怀쀀ÿ萁₈䔞䀀縊돤꥾ꈧ삃ﺪ鿀Ͼ∟䀀∈迸耯邍龜䈗뷩䯒꾴 〈퉊벨폤調 ࠊ迺誾萇䄟쀀=뷥펎㰰>⢓비ꇢ锬耀Ȁ軺ꪪ몫愈 ࠂ߱⑿ቇ಼ᄒ艃ﺈ舏⤲ 〃㬂ꄤ袆 ఠ쐀碂雀ꀬ务耀Ƞ藸䪟钡䚦怀ं俹⑟벥⥾ ?쐡ꕧ唿#㻸误袾攪 #㻸華袾ꔮ ∈迸ⁿቄ鏾∰怀ࠒ毠⠿钭纒怀స쀃렂뻀ꎬ늹耀ҝ䠃︨븢杖⤼怀С߸傗隣䡔匧 Ё߻⡊㑧踬怀∅︢၏凜唿=튤ꧯ偔 ऊ舂뺨ꨪ杖⤌怀;삓밉㯡讪겸쀀℈佸铽襋檲=뿪⫺钩ꀀ︨鯦誾댋 ?쪏벉⏈键 ?⊈뿨ਂ肠?愈뿪⫾钿韥䥌ࠂ࿸ꡉ㿤釼䢃ࠂ࿺訾࢏㸰怀8拡ࣣ誊ꄾ뀣噔৬耔傧쀀Б߻㑔鿭䥾吱葟鄇ﬤ丼怀!쐐⊐退䢣С߸銟ᕁ輬怀ࠒ䒐舄鄤㘰怀	쒧败祒钥ﺪ迤䅾萯∿ﳕ镍唢ꀀȈ诹ࢿ訦朗㤳 젓뱁⟮ꃚꬭꀀ‽쪓ﺪ뺤易⢿∈迸裷ꔯ穐⒱∈迸裿꒫銿Ƞ藸ࠟ뉄ꈧ젓툨밂甆⢿ﱡ꿂ჾ䂪ꀀࠒ׻ꑏစ浪쾉Fᱩɀᘘ怀'႟鈀傠쀀︪뿢⃾怀=劔Ꜩਂ肿ࠂ߱⑉቏∰怀ࠄ߱呿ቅ叾∰怀А蠀縢ႌ龜䈗Ё߹⁄၄襠ꢣ쩟钧⭾䈰耀袢㯪⊈ԉ䏻鐿骦着꼌 ࠾ࣻ檢ꢍ∈ =劬ꠍ晴 ? ῀耠࠿	蔒切㷡૖劭怀ȑ׻혚跤ꭾ攖 ࠊ迺䊾袃咥怀Ƚࣳ撯⩍拓怀ሄ蟸䣿詃㼰 ?誔뿨說뺠怀Ƞ藸䪒钡䈠耀∈迺衊꫆⊈┶ Ȉ菹ⓟ鈤龜⢓ꀀ﹑ῄ䩼萏Ȉ菺꒿ꨪ⢓ꀀȸ诺꓿ꨪﮈꢫꀀ쐓﹒韭⧾劔ꀀȈ訣좯ꢃ⎈∋쀐ࠄȁࢂ䂟쀀ЉϹ㓔鿥䥾向䀑鋼褣䪒ꖿ 쒑ﱕᣇ儧ꀀ'씐粑ៀþ檯蓿蠢杻ꢋꀀࠂ߸䠒㿢ჼℏ쀀?‌ʀ造ࠂ ࠊʉⓊጄ脢䢓⃏鈥䥔䌓 竒钥⥺䂐怀ࠊ竊銥⥊䊓⢿ꪪꪪꪯȈ苹ࣟ還龜䈗 Ȼ銤ꨪ誌?ቄ釤Ā쀀ࠂ࿸ⁿ࢏勒钭?ﰡ࿂ፌḸ怀Ȑ藻쉟ᔪꮔ夑ꀀࠂ࿺ɿਬ탘얆 ࠂ࿺誾袇ሙ耀"+CHR$(13)+"䰱⓵၆ᬜ夐䀀꺸㣫쪊﬉ 쒑ﱉ῀菾⨲怀䀑劷舏⤲ ࠾ૺꫪ肏ꊨ /璕ᕁ側䄠쀀ࠂ⒊Ȁ쁈ℰ 㩊몤ꤺ씓࿥⭊庐怀잀 㿠聨⤲ Ȍ跹䋿ᄦꬔ夑ꀀБݺ꓿ꈫ钿∈迸蠨ቬ䢓∈迸裿聇鄤礁쀀∈迸血㻤ꤪ説∈迸蠿逭庐怀∈迸裿鉏襤ﾂ ∈迹⑿቏⤲ 훜㓯쥊嬽 ;븊믠⏾꘺ꀀԁ俺钿ꪫ着ﾀ耀"+CHR$(10)+"擣≿袃㸰怀ࠢҸ稊능⥞ꀧ#쒐Ⰺ㟥䥞ꀧ삃ﺪ舏稒 Ȉ舣ﺨꪯꢄ⬿ ȏꔫ䡿钅꧄劗 ȏꊪꢿꪊ Ї么郿袃ꮄ⊛ 술蠢㿠ꁈ∱耀?着꾪꫺肿Ⱦ訣좒㲊劔 ∈迸衿࢏∳耀ȏꊫꢿꪎ⪿ 䀑势袃㸰怀н䫺꒯빂捻ꤛșꦫꢿ몊ꪷ 䀑纤࿂䃾䂥怀ȡҢ袂₈䈐耀ȡҾ耏䔞䀀빊ﯤ辦䀀?甆ꢪ⫺肿ȑ׻퉟锥老풉Б׻꩟鄇浪 ;㫪讪褾ꀧȈ苺誢꿪⊈┎ ꒦⹪⊾∏ࠊ˺삯ꪫ着⪋ꪪꪪ⊈┎ ЉϺ꪿ꤋ着㤋 Ё⿸ࡒ뺥ᅄ芣 ꉏ逍裸䢴쀀ࠂ໸ꐱ㥈劈怀‐꾚닺ꨯ뢲怯ࠂ໺삯몫着Ȉꏻ蠪龦늤ꊋ ࠢӸ䂟銣劧䩒钤∔袌 쒑ﱉῃ⍌ኘ耀Бݹ၄뿤ᇼ䄟쀀좋쀯透ꢫ∈迸蠜ࢌᢈ∰耀ﺪ㿤釼ࢿ=뿩䫺钩怀ĺ䫚꓉⯪謾袣쐑ﱁ၇∰怀‪ૺꊯꥊ势 ∈辡㺊钢䬢ゲ쀀Ȑ螡⢮⫁⡈∰耀Ȁ迺銩⪊䪤怀ࠂ࿺≿ȏ∏耀ࠢ⿹ၿ鄇蘿萯瓷띍ㅔ崒怀靍㇔崒怀'庒១⁞䈧;㺈뿪ઢ꒸怀∈迸⃿衏凜唿ࠒ‽鈭줢䢗怀ȸ臻鈉㪀䮤꘾怀Țꣻ쀯븢杖┿Ȟ蓹勵⊇쥄瘖怀'纒韠⁾䈧‿슛뿊ꇼ솟쀀Ȉ苻좯ꢏ⨿빈鏤褾Ȉ苻젯骦ꫪꪈ耀ﻔ㗯䥒墼쀀Нࡻ봢誺₼쀀>⒫뾪ꯪꢿ怀ਂ迺ꢪ⿪剖䀀숑䠌҃ℏ쀀ࠂ࿺ꪺꋉ⯺錬耀Ȑ蓻ኇ⍒咱Е䟻䉟ᑇ፼䪼퐣ᤦ﫢ꢋȈ菻鈩᪆䪤꘎怀 鋼ꈇ祒錧 Љ䫹撯詆﫤☶怀ȸ藹劅㯫ꊾ꨻Ѝ䳹擯鉆ﭤ䘖怀ࠊ迺誾袂⃸⒱쐣﹈鿤觾肠怀∈迸蠢㿥兖锬쀀Ȉ迺ꓰꨏ邔怀 哶Ղ䯲✙ =뷩쫚햧 ?변⿪ꯆ꺩 ∈迸衿ቇﾂ ࠊ迺ʾ脀菾ࠆ 숀︢࢏䒟ࠄ௩貾袏⤲ 䀓빈ꯡ设ꔾ ?︈뿤课褌 ࠒ䗓⑿ቭ픤䤷䀀Бݺꐈῂ₈п禎ឭ䇾䈗븠ῦꪾꪏ᯦︪ꊾ눈ȟ被뻊ꏨപ ȡְ䒛ᑁ咥怀င⿪䩾蒯䒟怀켒粑⟨詊ﲀ쀀	슊삯ꠊ甆⢋衟邆ﬢ䢳#࢟邀䢣'씐粑០衊岠쀀'씐墿逡弤䀀ᐅ࿸蠾ࢃ壟꒎쀀씓ﰑ࿤譊岐쀀Ȉ迺꫷ꢏ숐ﰡࡃ℟瘟㽊꯾ȫȀ踢袿ꢊ⊈耀ऊ䏻ꐪẦ늨ꪊऊ䏻ꐿ驇愈뾈耀Еཹ拷꩏ﲉȊ苻ῦ⊜ꪌ耀ࠄේ誾ꢭ⒱ࠂ࿺剿ઇ礓∈迹࠿꒥徤ꀀᐊ跘衿∧⨿घ觻꩟몥ﬨ嬺ꀀ؉࿺풤꿪쫖Ƚ૲꓿⩊﯂⪍怀퀯騦﫢ꢋ∈迸衿┳ ∈迸⃿ꢫ∿2暫皉⿌饲檲怀⅊剔褢䥒䢠怀∈迸䂔锢䢒傢怀?ಂꂊ㺰Бཹ⃷ꑏ≒⋏逄ꤪ劘ꀀ?쐇빅兌邧ࠂ࿺剿ԏ耀>≈鈤뼢䢒₈怀Ȓ辡㹺銯ꪲ肾쀀䈐螢黺ꢯ쪒ꂾ쀀ᄒ艃︒㿤勲ℏ쀀켒ﺪ곪䫾줌 ऒ䗻ꑏቅࠂ࿸䠜࢏襤瘦怀ࠂ࿺Ⱦ⒱ࠂ࿺誾蠃ℏ쀀ࠂ࿺䩿ࢃ㺰삀 㿠耠ࠂ 쾉ÿ꒏≾耀ࠂϠ꡿ቇꄧꀀЁ⿺ꢪ깈⡐儣ꀀﺪꯪ誾┎ Ȉꏺꢪ깊⠐儧ꀀ씓﹔雭৾䔶 пɻ㵉剈怀ࠊ⊋︨騦甆ꢋ︨鯦誾ꀋȈ菻ꈯ騆﫢ꢋЉ࿸諺肏ꂈꔮ 䐑ߺ꫺ꢏꊈꔾ 'ࢂ០ 䈠耀ԧ纒韠⁾䔦 .鿢ꢺꪫꀀࠢӸ䒟钃刧繀㿤鄾 ℈䈓︡ࡃℏ쀀н੻ꐏ唿?ﰐ㿢ᇼꄏ쀀Бݺꐀ῀菾ࠂ Бݺꐈ㿪䫺∏耀Бݺꓷꔯ穲钧怀葟ꄏ긬怀 ϱ₈㿠脤䤟쀀켉绤궮怀?좒⟯≈鈬耀䈯躺ꤋﮪꪯ∈迸裿ꀧ⒱䀑黼꤯戴ꔾ怀ȸ臻ꨏ몠ﮘꪼꀀ쒓﹉ῂ₈㸰怀/︉㏥冒ꀧȟ誻뤃着⪿=뿪⫺ꊯꀀ=뿨該ꪢ怀=뿨諺钨ꀀ9쓇꤫筒钥Б࿹ዿ꩏賂ﾐ耀Ș裻튗봉篒꒵Ș觻퉇봄篒钽ငăᒃ⁊⪰ȡﲀ辀䇼䄟쀀ࠢ⿸逇蘿뾡 ࠢ⿹⓿ꔏ禍 _륄儔怀Ё߻⡿銯뤐꒯;뺨꯮ꊪꤻ ࠢ⿸ÿ萃ℏ쀀?쁟뵉叔锾怀?뺩⿪ዼመ怀?咯멋瘝꤫;㻸详諾蔆 ​繐뿪譾┶ ?ﺈ뿨课┮ ȡ⒈莂肠⠿Ȉ菹ࣂ៤褤䘖怀葃﹀ៅᅌ邧ࠂ࿸ⁿࢁ䏾䄟쀀앑㿢⏞唝쀀∿㿤鋺࠿ࠂ࿸倢㿠ᇤ䤞쀀Ȑ藻衟鈪叾傗ࠂ࿺刢㿠ᇤ䤞쀀Ȉ菸袢⿪誤怀쇀裿蔃漣ꖁ ࠒ䢣깉⪯襤昦怀쀑ﱀ῀肔ꂧ耀﹊鏦ꬪ徰耀슓ᩆ銤ꢌ ࠒ࿹⑏ᩋ婢┚ =풕㿨ኌ픢怀年锯咢怀ऊ䏻ꐯᩇ婢ꔊ ࠂ࿸衿એ⤲ Ȋ썫갶颇着댋 뺠⿢⣾劔ꀀ 勼鐊戮ꌛ  Ϲ¿㢱ꀀဤ׸肟ခ䂠 ࠒ䢣㿪ꏪꤿꀀ扣褦䫒⢊ 삃︩ឨ䏾ࠆ 湠꓿褆﫪⪊ꀀ숯鈏肢ꢫਚ誸钭턤媛 ﹈븤樂ꤤ怀;舏먀莢ꢻࠂ߱⓿袃㸰怀 苿褃쪞Ȉ辠黺ꪯꪪﲉ 븪뿤ꦪ龠耀졓풕㵉叔ꔶ怀ȼ諻좥⨯怀ࠄ߱⑿ቇ⒱葃ﱉ㿈鏼袃ऊ䈡糉៥৾䂕怀ई菹ࣟ邇壘笕 Ȑ蓻졒៪䯒䌓 ࠂ࿺Ⱦࢃ∿∎ꈫﺢ㾪᫴势 Ȑ藻衂៦謤䘶怀쑟骧娻ࠒ࿹⩺銏ꀈ唢 न諻좯ꢃﮪ㴊ꀀ#ࣿꢯꂮ樧擳௤鎤墓ꀀ∉࿸ⁿȯ襤怀ऐ藻죟뒏浪崺ꀀȸ臻숏㩀ꤿस臻蠏뢁ﮪ봺ꀀࠒӻ퉖鄧גּ嚱怀∈迸衿ꔡ௺咤쀀ࠒ࿹勶꤯怀ࠂ࿸ⁿ䄟쀀ࠂ໺삯ꢊ䊢ࠂꊽꪋ愈 Ȉ菻蠯順﫢ꢋ숣︥ῦ꫾ꪋꀀȸ胻蠏렀ﮢꢻйѹႄ㯪誢ꢻࠊ˻젢ᢆ靖ꈈ耀삃﹉┢ꌦ⨶怀 鈤뼤䨲 ࠂ࿺䪢锁쎎∏耀࠺ꪪ꾮꫊뾨耀ࠃ삁﹄៥˾逇ढ萀縂㊤龜ꀧ莀耿ࢂ₈∿ငǰ䐡ႀ䀨㄰ Љɀ﹄鄤褢傔　Ȉ舡绂ᆄ녊䈐耀섐䠣訤儈ജ ꢫꨫ䪌 ࠂ࿺誾萇䄟쀀쀐пࠃ車䂀쀀葂ﰁ῀ᇸꄯꀀ∊芻ꪫႄ檩 퀧餧䪢ꢈ쀀ࠂ⿸⁈譁ꂤ좆 '⢋鈡䡌䔦 С׸ቀ逨䈧찠烣舄訤㘰怀Ȁ꿹ࡒ뫄ℬ耀ࠂ࿺刔ᧀ臸ኸࠂ࿺刢뷩䏾催쀀Бݺꑿ袂祄踬怀꠫鈯䢌ꔮ 䢓ꐩ቎颼뤨䀀좋쀯透ꢫ䉐韥ू傗ࠒ߲₈ȏࠂ ࠂ߰ 㿡₈䔞䀀﹄ῤ䉾邇ﱁ၇䀟﹈鈦ﬠ䠳ပ엓呥ᕍ儦䰼ᄒ艃︩ᾨ菾ࠆ 㹘诤菾⤲ ข߹≿ሄ響鈟࠺û젂㢁ﮈꈸ耀=廴褣敖ꐿ︪㯣⊾⢿#씠ﺒ韡⡾䤩 ဗ竊鿠Ͼ䤦 葃ﱉῄ釼䤩 ࠂ࿸蠾ࠆ ࠂ࿸蠢῀䏾ࠆ ࠂ࿸၇䤦 ऊ䊑绉ቇ豈䤔 Ȉ菹䫋ႇ龜䔖 绉ᖦž嚔怀䒑呡၇⒱∈轹哿ꔯ禘ꪮሄ脣︒ҏℰ  ⨪劈ꔪ⨂肿Б׹ዤ鉇勒咛怀?ﺄ⟈䋾耿>꺪⮪㮘耀 互꒩⩊骼豈䀀삃︢ᝈৼ唗䀀Б׻ꑉ៥ᅼ쪌Ȉ菺쪫⢋愈 ȹ⋻袏ꊮ⊳?뺀⟮ꢾ⪷Ȉ菺袢⿪䊐⢋;쒑㑋㱠肔ꂧ耀∈蟰裿詌袴䪦䀀Ȑ蟻䩋ႇ﬈䔶 ␉࿸鋺銩Ᏼ⊛ ︩ᶦ˾ꪋꀀ'䊐韠ꀨ劤ࢢ௦⊈∳Ȉ诹䪫ࢇ愈┶ '绩ᖦ˾ꪋꀀ࠺ૻ튨ꪯ檊뺨怀ࠂ߰⓷钯滑缐䀀7楋皔ꔯ䄠 ∈迸⃿镉䯾钧怀禎➯⣚嬐耀Ȝ裻퐥㿢誾┾怀ﱒ뿢⏾䄟쀀ﱒ뿦㋺∾怀Щ࿺ꫫᾤ臾ª쀀䩒钥⥚箐耀	萿誧騫ࠂ࿸⃿袏⒱Ё࿺邿멋滛ᐕ俸衿ȏ⨲怀쐑ﱀῥ䥒鲠쀀␉Ƀﺤ꤯朗꒿骦닪ꐏ? ῀耨ि﨨鮦ꫪ꺊怀蠢㿢⇈ꈈ耀ԏ绒韤ⅾ䈗刾蔣ﺪ뺢⯲₾쀀ࠒӻ쉎逤㤲쀀ࠂ࿺⊈ꈨ訦ࠂ ȝࣻ븢愈⾾ꀀ 쟁@ῤ䈐萁 ࠎ೺⫲ꢊ⊈ꔎ Нࡻ뺂⋈┾ =㿤ዺȇ ∈迸顫⾠Ͼ䤦 蒓︔ቅ叾銯怀Бݺꓴ⟯䩒쀀=풓㴪鏾⨲怀∈迸衿ဇ蘿萡 ∈迸裿ꈫ꪿쒋쀟蠄ﮂ儑耀ऒ䗻갹评;䨔ꀀԿ븊믠⎾ꈻ싀‏멂還倣ȡﲈ鿀脤⨿캊삯ꠊ廒耀︨뿢ꊪ⤿ ငăҁ⢊⊰㻈鏤ž䔖  Ϲɼꤪ䣲ā耀?䒊℈ꉄ耿ࠊૹ䊮誦ꪺ₰쀀Ё๹≈롄ᄈ #븨븢堣∈迸蠈㿠臼䄟쀀‑嫵❏楒鐭=⥏桒퐍<橣킧ꥏ偔픏࠾ૻ슮ꪯ꡺킌쀀舠ྀϾ∰怀쒑ﱉ㿨袸ꄧꀀข࿺⪪⿈᏾鈘怀캊ﺨꯪ誾 ࠂ࿺刔ᧀǼ࠿绒韤ⅾ咕ꀀࠂ࿺꨾એ諸뺠怀'앐簕㟥䥚ꀧ;뻊ꯪ⍾钥ꀀࠂ߱⑿ȏ諸ﾂ Ȕ藻ꑟ钭垖耀⢫뺢ꪪ⢼ ﹤镇廒뾈 ﹄ᔥ塚꒏﹒ᚦ﬈劷ࠂ࿺劥ῥ剼꒏ࠂ໘ꡉ㿤ᇼ䄟쀀Ȕ迡⫻⪏ꂪ慠ࠗ䪩璪靌駼䄟쀀ࠂ࿺判⿤䁼䐯‑⥳킗봉砀唢ꀀ;뻊ꯪ;褧 옠〲㉢ꏾ⨲怀?ﱕ῀菾⨲怀좓﹒꟮⃾ꨬꀀ술烷镂ꏾ⤲ ȟ被꩞뫄ꍨ䴾 Ⱦ艻뼢௬% 섓︑ῂǼꄏ쀀∈迹⑿ȏ唢ꀀ:₫ꨊ몠ꮪꢼ ҽ䔃﹒㷤⇾툜耀?ﺪ辂ꂨﾂ >飼㺢⧪쬞耀∈辠裻ࢯꒈ∾耀䀑劗舏옜怀䀑否ᅌ䦒圑 Ⓤᄥ龜䪔ꀀ廜闥䥾䔖 ?┩䩒뾥⥊邤怀숐萡࿁䁒⒱н{㶈駼䄟쀀ࠂ߰⃿與࠿Ȁ軹࡟뢄龜>ꔫꑠ臼࠿​諴詏㘰怀?┑䡐뽅⅂鄤耀␆ᙬℾ䈗ࠂ࿹⑿ቇꄧꀀЁ࿺䣿ꪭผ怀∈轸裷聇ꄧꀀľ艻봩篈傧ꀀ씓ﱑ៦譊岰쀀ऒ䗻졟钇ﬔ䢴쀀Ȕ边剺ꊮ銤 쐑ﱁ㿢⃸䤦 Ȉ苻蠿领愈ꈏ'⒂០⁾䔦 Ȁ迺袯벊愈Ȍ극ᓨ韌觾傗섀蠔ȯ䤢 퐦ቯ₾ꈫȔ꦳졟꒏煪툗 䳽钂䯾⨲怀?︢㺂㏪∾耀∈迸蠜㣠臼࠿∈迸胺钯邤怀ᄒ艃ﺈ꾢ꃸࢿļ䀓쐏뱀Ꮔ鄼䀀:惣ꈏ먠ﮢꢻЩ࿺ꫫྠϾ∏耀银⩯⊾?빨꟢课┾ Ƚײꑏ㹄﯂䪥怀∈迸衿䔞䀀&䨒떥뤈ꀧȜ觻삯븪﯈ڪꀀ‎∫甆꺭⫚怀Ȉ꿸裺ꊯ鈤憎 ​쾑幹ᖏﾂ ሤ蟸銾钣큔ꚫ Ⱥꪪ죏ꨪ﬈銩ꀀ	抃쀧鬧䪒ꒉ怀ė䕹듇附⇾䨔ꀀ Ϲ⊉∀聐∰怀Ƞ蓸ં韠 䔦 ဥ䪽銁䧾锩 ࠂ࿺ʀ讂₈䄠 Ȑ觻蠯透ꢫЂāﱕᕅ兔唿ȸ胻訂믠⎈ꔾ 숐ﰡࡃ䄐쀀Ȋ苹䣒ႅ龜䈐耀	슉绂៥⥾䔖 Д꒑ﻉῥᆼ䢓Ȉ菹䫟颥賂堙℈迸哿蕇㔵 ࠊ䊡ﰒ㿤ዺሙ耀⢫뺪ꯪ傣怀Ё࿺芯⩊?勿ꔪ歶銿=풒㵊诼࠿ऐ蟻⩿銩ﮨ嬚ꀀȸ苹૿袪龜뀣࠿㿥凼ꄯꀀ뺅⡐ꄯꀀᄒ艃︢㿤鋺袆 Д꒓﹉῭ᆼ䢳	슋᯦︢ꪾꔎ Љɻ驇瘝ꤋࠂ߰郿꒣ﾂ ं₃︈Ȁ聐∰怀Ȉ꾨黺⪍ꊨﴪ ?⒉㿪銤ꤼ䀀;㺈먪杖ꤼ怀︠Ꮿ袾ꢪ怀쨒ﲡ⡏䤢 ?﹀鿦૾ꂈ怀숐ﰡࡃ⒱र菻⨿늣ﬨ묺ꀀ=풞㣋㸰怀	蓹⯯銤龜䀀Ƞ藸䨿도褾ꀧȘ觻쩏벥רּ堹9쪊ﻂ⯪ꬾ蔦 ?ﺐ뿥୾收 =쪋ﺢ⿯⡾픎 쒋ﺲ㟫⭾ꔾ 쀀ÿ蔁䁐⒱籑៉ቼ┓ Љ俺䣿ꨫꪪﬣ 䉐蠢ं鄽耀ȸ菸部ꅎₒ⢳Ƞꗸ䢞閡側ꊫ '应闡䠞鈩ꀀࠂ࿸䀢ᄂ遄⊿ 㹈븤樂滑怀Ȑ觻遈ꅏₒꢫ∐迺部ꥏ⊒ꢫ考︀ྀǼ䄟쀀ȸ臻鐅㯠鎸놹耀;뻈ꯪꌪ褣 쾁␪ȏࠆ 绒闥䥞傗ࠂ︈ȇ䄟쀀ꪫ⢋愈耀?愈꾪⫺肿Ȑ萣﹒ᒊﮢ墓?푕ᕍ兒徸 쀐ѿငĂ䂟Ё߹䩟钥龜뾠耀?ꓩ≎邪㺰 ?ﱁ၇耠 ࠒӻᅏ剈阾怀Ȉ舣︢ᢆ﫢ꢋဥ应鼢碒벢怀⒩੆銪㺰 ࠊ긪뾢㦊뺉怀Ȑ藻鐨韬䆾䢐쀀;쪓꒩갎瘝꘮怀 ︤褯穒颼怀∈迸裿赅卖庸 ข߹≾ረ煮ኘȸ臻鐈믠䎾ꢸ쀀ȼ觺哸诫䊾ꢼ쀀Ȝ蠣︢㲂甆⢿?﹀鿥ⅾ눧?ﺈ뿪课ꔾ ∈迸裺⏯襔嘾怀삀 ῁၄ᄿ?砢ࢇпჄ៤褢䢟䀐ߺ₈ȏࠂ 쨒ﲀ㿀᏾∰怀삁ﰑ㿠Ǽ䄟쀀៪௾䔖 Вऐ⠤韬酔䘖怀‘䨾钭ꥊ羐耀뺤꿪ʾ⢋븤鿦ʾꢋ앋﹊韬䇾咕ꀀࠂ⹊뾥㥊纱怀∈迸蠾࢏樓늗耀;븄믠ξꢻ8금㯠௾ꔺ й䇻ꐟ멀ﮤ꘾怀࠺껪꾪㮊뺹怀䀐߹¿∁䂟쀀ﺪ뿪⏾ȫࠂ࿸衁⢡䀠㘰怀Ȉ菹ⓐ頄鄔䘖怀ﻈᏥⅾ䔖 终៥ⅾ唖 Ȉ菹ࣟ鉅龜徐耀ࠂҐꠈ㿡䁐⒱萡ґ␢⢈䔞䀀Ȁ踡繄鄤䤢쀀∈辡床肥䢒傠쀀䀐ߺʠ蠤䧲ă耀繐韤ቾ舃耀 ࿺ʀꀨਂﾠ ࠄȃﺀ꾪⪊뺠怀 逅既邇ﺨ⯫⊾ Б׻聏ቄ鄤怀擣鈄異쑒ᒊﮈ刑耀>肠䠢࢏ꂊ⊘ࠂ߸␊㿢⇾萃 ࠂ࿺䈐㿢邤劗  ߰ Ȁ耠ﾀ ၇鈤褂耀∈蟰裿襄䫰ℏ쀀ࠂ߰⃿袏缂 ࠂ߹၄ሄ鉄ꊯ Ё߹ቿ鄥塚訌怀Ё߹ቿ鄥朗锋 <脠䣴ℎ邤㊷ 뺨ꯪ誾​ԉ䏺钿ꨊ婢⪌ꀀБ׻聏ቆ錤儴怀ࠒӻ쉎銦ꬺ䂰쀀Ȑ蟻⩊ᳬž䈿ࠂ໹⑑ᕄ儈怀쐑ﱁ㿨諢쮂 쐑ﱁῂꏾ␱?ﱉῄ醼ᠹЉϻ耯ᩆ銤ꤌ怀Љϻ鐨鰆銔꘎怀︪鯦ꫮ꘎怀ԉ䏻鐿骦着뾊 'ࢂႀ₈䈧ढ䒐纉ቃ䤤 Ȣ蓸䢟退䢣ढ䗸Ⓙ鋁⠸䢣ԡ䗸ᒟ銠徢 ≿鈤觾ࠂ ࠟ쐑ﱁ῀臼࠿?㺊믪ꫮ꘾怀Ѝ෹⓯ဇתּ应怀Ȉ诺ꨯ뺢流ꬍꀀ젢ႏ₈ꈫȐ觻逥቎ꂊ뒩Б৻鑈ꐎ邔꘮怀꟯䥖 ĉ佐뻵ॏ椬䀀ࠂ߸␊㿣ż脃耀ࠂӱ⃿遇缐䀀ȸ读邥⩎ꋊ꒩ȸ读ꪪⳮ˾ꈯࠂ࿸裿ꢫ㸈耀∐迺䃗╏剔怀∈迸⃿蠃⨲/遌ᄄ䄑쀀檀꾪꫺钨Թ䇻鐟몠ﮪ뾺 삀⃿袃㸰怀Թ䯻钿ꪮ뾪  咎Ņ䢒圡 ȼ蓻죟격叾鄽쀀Ȝ裻㺂⋒Ⓗȸ藹䂒㲊䊒ꢻ뿥䭖徼 =뿩䫺햧 9铆⹪龠䀀繐韥ॾ 삃︪ῌ᧼䄟쀀ࠂ࿸蠾慠뺠怀ȡ߰咗ᕃ咥怀>⢫檪뺪ꪪ怀∈輠븢벤䩒쀀쐑ﰀ㿢Ǽ䄃耀ȡҾ耇䄟쀀Ȑ藻ꑟ鐤凜ꀀБ׻鉅៦䌾傱쀀Ƞ藸⒟鐠䪥ꀀࠂ࿸裿ꀣ⨶怀ࠂ߰ꣿ镇凜ﾈ耀䠒໹櫤韮櫖性ࠂ࿸ⁿ၇⒱င⿨詊钢⬪コ怀ࠒ߲⃿耇䄟쀀?愈꾨髺肿 鋸ꈇ碒猫 Ľ䑻갉篒钽∩࿲ꐯ㹀﯂骽怀쒑ﱉ῀菾% ď䨙纡ཆዺ㒷 С߸ꢿ骣賂麬?ﺪꪯ瘝긬怀逫ﲩ㽊돤躾  Ϲ⪒褠逐儧ꀀࠊ˺쪤ꨪ倈傧ꀀ舠룿ꢫ㸈耀Ȉ詁㺨訦甆⢳#萠ࠂㅄ褀ꀧЉɀ銽⦊䊐벱绰꟩੾ ȡҾ耇ȇ ?⋿ꘪ쬪袿Ȑ藻쩟钥⥾耀=ﺤ闪出࠿﹑៪设墓뺨ꯪꊪ⤋ =ﺤ闪做儧ꀀ쑁﹂㿤ᇼ䄟쀀쐑ﱁῄ䇜䒽︨鯦ꋪꤋ 퉟锭咗'纐韡⁮刦Ё߻䉟됥壘鄧 ࠒ⢋︨鈯ꢫ쐑ﱁῄ褔䈾怀ȁ࿸勿锩杖Љ௺邼룠Ǽ?ЉϹ⃈Ꮵⅈ䈗섐␂ࢁ䀠㘰怀Ёຊﺥ⹪狤怀ई菺袯ꢋ杖င࿸耠៤䈐萏ᄄ迸ⁿȏ쐏ࠂ࿸ꡉ⾢⃸∿Ср咔鄀쀂䌧 ऀ迹ࡏ뢅樂йс咔뤊슂ꌿ ࠺û퀇뤀䎞ꐹ Н⡓︨뿢誾┾ СՐ劍ႏ옜怀ࠂʐꑚꌠ臼࠿Ё߹䑑᪤䋾萏Ȑ蒫ꩊ闆⌾䈷Ȉ菹ࣟ邇濫伜 Ѕ⏹ⓟ鲅賂列?ﱉῄ鏾䄐쀀쐑ﱁ㿤觪䬿 Б佉ჿ肏⩄銽 ࠂ࿺詿࢏襤袟쀀ࠂ࿸⑿葏㰰ࠂ࿺≿࢏缂 >⊒䡀衏ꂂ焪耀ЁC︄ƀ샐쐃 鑐ႅﮘ䪴ꀀЉ佈郿袏꣄檩 ࠓ쒃︂ῤ⇪ꌫ С߸䒎ᱡ뼨䀀	⒒䡉Ą鄤㘰怀섁␢ď⤲ ?ﺵꄋ﬐뾡 й׹ኈ벊⋾ꈸ耀Љ୺邼맠Ͼ愯쀀吢ᝈৼ䤦 ࠂ࿸蠞㡣欶䀀鏯ꢪꪫ∈迸衿ੁ⏾⨲怀Љ佈郿袏ꥄ쪙 Љ佈郿ꪏꪤ憎 ?橊ⷪ;鈩ꀀ ⿩⨲뎧ꤪ怀င࿸蠢៬℈䈗Ĉ䈓︡ᣆ劤ꄈ쀀?︔㷡䏞ᐙ ļ䤓ﺑⓏ倄儢쀀'␉ߤ儤鄠쀀鈥䥔 ;ꃏꨫ䭔茧 ﹒韥冖씆䀀ሔ蕻銭꧞刔耀쇀裿衇㼈䀀ं踂ﺢ⢋愈 Ȉ菺钨꿪ꪪ怀Ȑ藻鑈韤ꤪ怀ȸ藹ᒈ뿪ꪪ꺸怀=꿬⇾䂪쀀ࠊ˹僗鄄䄞䐑  ⪪쨢뺨ꯪ袦怀ࠂ໺킧ꤊ䊞 Б߻⩳ᄆﭐ䞱 ࠂ໺킧뤊䊞 逕︤꤯䢒怀ꨪ鿦ꪪꪈ怀ࠂ࿺剧Ѓ鸞辂 Бݺꐈ㿤酴⨲怀ࠂ߰⃿ꔢ鏾⤲ ԝ䣻퐥㿢誾⢿"+CHR$(10)+"≋쐩ᤇ瘝긌怀Ȝ觻좯벊﯈ȫБݺꑒ㿥ⅸ䀟=ो풖㴂䫞앑呕㿥兔唐쀀>⢫뺪ꪪ뢈怀ࠂ࿺⩒㭠Ͼ䤦 Вꕓꡕᇭ褔䘶 ﹐韭⥺匿ꀀБ߻꩒᭬Ǿ䔻 Ȉ舣ᢇ⊪ꊈ劌蠏猫 ∈迸铵⯬銾턥Б佹撏詏礫ࠄ߱ѿ၎렠ﾂ Ȝ裻좯벊ﯢྪ ⒫⩺钭䒶怀Ȝ裻젯벂甆⾾ Ȝ裻풨밊鏔ت怀앑呕ᕅ兔唿ﺪ몪꫎쀀 ྀ ?萒ꩉ⪤鏾ࠂ ဈ蟰⃿袌탂؞ ࠂ⊈ꈨ訢袿Њ䏺邿ꩋ⪰↋耀ሔ蟻䩾锭텔庵 刔边勾ꊯ鈤画 Ȉꏻ蠯颇慠ꌋ 竵㊧ⅾ訬ꀀ⩊뿤ꤪ怀ࠂ࿸䠒ῥ䅼萯Бݺꑿ၇ﾐ耀Бݺ꡿၏凜뺒䀀?︩ᾪꃺࢿल䇻␟뉁殤꼼 ∈轸裿镋㸰怀нҋﻕ⹩珤阾怀䀝퓓ྮ⃺┼ 濢郿ꥏ킔ﴈ䀀စ幕㿄ᇼ䄟쀀ȼꓹ졟뒋⌳ Ȉ舡绂ႄ℈䈗ӂႅ龜䈑耀竀鞥⥊庐怀Ȉ菹ࣟ钥龜䔖  ⾨諺ꪪ꣊梩怀?鼤䤒粀怀ࠂ߱⑉ῂ聠☰怀?切뾪ꯪ꺪怀?劤뇨ਂﾠ ࠂ︈Ȁ耠ࠟ쀀Бҋ쉟鐊ﮢ墓Ȑ藻衟钩⯊劐耀ࠢ׸鉊⑏㰰쀠ဈ㿠耠ࠆ ﹀ῤꊮ鈘ࠂ࿸ⁿ鈤褢䦂 䀧뻪ꊮꪪꮸ耀ࠂ࿸ ῀肔ꂧ耀쒑ﱉ῀肔ꂧ耀擣ꉏ鈦ﬢ䢳ࠂ࿸ ῂႈ᰸࠺˸ꑑᕎ儈䘶怀偷锯젒咢 ࠒ࿹䡋龪ꪨ⢳ɿ衃ℏ쀀Ȉ菻蠢ῦ誤꘎怀ࠂ⁏ሄ脠䠿?퉕㖋䁒⒱ 쟁၄ῤ䄈娸怀ဉ뺺袧ꪪ⮾耀Ȑ萣젛誄ꌨ樗谡ࣴᄆ錤劗 ȡဨч䤢 棳Ꮿ邤ꢫꀀЉ୺郼蓢䏾⤲ ȸ读袢⿮誤꘮怀:櫣ꊯꨮ甆ꢫ?衿ȧ࠿븨訤ﬔ椔怀;먀뮠ꮪ꺸怀ȸ胻蠏렠ﮂꢹ怀ȸꇻ蠂㿀鎤뺸 ȸ臻蠂㯠δ뒹쀀йŻꨒ㥀设ꢻࠢ׸鉾⣃㸰怀;뺨꯮聾䪥怀Љ䋸꒿ꩊ瘝뤳몠뮪ꮪ麸怀ࠓ쒃︪∯謁꪿ࠂ࿸꠪㿀鯼ࠆ "+CHR$(10)+"⋉⫈鈤퇄䊓 Ȉ苹ࣟ逥車䢑怀씑籑ᑅ⒱ࠂ࿺ȾĀ菾ࠆ ࠂ߰⃿肏∅耀∉࿹䪥ႏ碠ꄧꀀБ׻遟遍滑儲쀀Ȁ軺袿렫廒怀ࠢӸ⨒蒄℈蔦 ढ萀ﺉᒁ鈯С҈⊏退䢣?ﺪ띪ꭶꪢ怀?ﺪ띪ꧼिЁ߻࡟낇車袡怀ऺ萁纄멊朗ꤿ쀀ÿ舀脤袆 ?䃿ꔩ䩒钠怀?ﰡ࿂᣼섀䀀ࠄ߱ѿ၇䄟쀀∈迸裯ꢏ廒ꢹ怀Ȍ跹⓹Ꮿ≾鈼耀СѸ⊔邠ႄ䘦 ࠂ࿺䣿꒯愈꺬ԁ⿸ࠂ㺂ႄ㲰 ሴꏻ꠪뾢叴ꚿ ȁ࿲꒯㹊甆徭怀Ȑ蝺ꐡ?Ȉ辢뻺ꪯ懲ࠂ࿺Ȉȏ䄠 ?ﺪꙠϾਂ䀀ငĀ䘞㰁Bႃࠂຂꚮ⸊芢∈迸諺鏯ꢊﲉ ࠒ߱₈㿠聐∰怀Ȑ藻큗隊ﮈ唖 ࠂ࿺ɿЂ⇼࠿?ꣿ銈颐ꄧꀀ'纐韠ꁪ䨯Ƞ藸⪓ᆠꁌ䪥ꀀЁ߻⁏뒅龜蔦 =࿂ჼ∰怀ࠂ࿺≿ȏ∰怀∈迸裿钥㏺誾쀀Бݺ뉓ᜭⅾ䨔ꀀ繒韤䁈傣ꀀЉ୺邼맠菾⨲怀∈迸蠈῀ₐ㠱?ﺥ㿩勮฼怀∈迸₡⾠ªꈮБ৻ꐯဏ꺨怀蒒行῀Ǽ䄟쀀?蘒ྀ⏾ȇ ₐ⾊㻸ꌯꢢ䢦怀씫빂៦̾䢳∈辸鋼钭酔銭 䤰өᅏᤜ䀀င⟰䣿鑉唢ꀀȐ萣︒ࢆ⍈䈗Бࡃ퐤鄎삂ꌫ ࠂ߸␊㿡ჼ턇쀀ࢴ⏋鸼릣뒻怀ࠂ࿹⑿ቇﾂ Ƞ藸吟땅熪ꀧȐ藻싔㕯愐咽?呖㽃䥒霍 ऊ䏹Ⓣῤ褾䢓 Ϲɀꐨ蠂ā耀쐑ѿᄄ䄈脠 ࠊ˻술騦䫂ꂈ쀀ࠊૺ슠訢䥂邠쀀?ﺔ뿩௾꒴нѻ괩⯂邼쀀?퉧뽂凔ꢊ 좓ﰩ㿢苾⪽怀∈迸蠈㿡ü쀀ࠂ࿺芷衏킔댫 =㷩䥊钌怀∈迸䃿鑉ꄧꀀဂ︈ȇ࠿?麤鄤廙 ࠂ࿺ਂ㿠℈∁耀잀ⁿȀ菾ࠆ ࠒ߱₈㿠聨⤲ Ⱦ蓹졒㟫⁜⪴耀Љ௹ʡ࿦ዄ⤰쀀Ȃ軹⡂㿤ℜ耀뻺询ꧾꈋ;ﺪ꯮ꪾꈫ‏뻺讪닪'纔雡ࡾ傧∉︐ῄᇼ䄟쀀ﻄ靤䇾咕怀쉐䣿ꀧ᰸ꊨꯪ劔怀ࠂ࿸ⁿ葏儢쀀葟鐦䘶怀ࠒ⟋⹼閭咟怀葟ꐯ꘮怀삃ﺪꙠ菾钥怀?⊈ꔪ⬆肿銤ꥋ厈꘎怀煮鿤৺ꊯࠂ࿺Ⱦ䤦 ∈꼨㻲⒏傔ꤪ怀	≊銶꭪䢒䒐 Љɹ⋕ᖅ饘冓耀<芫ᵊ蠐儧ꀀ쒋쁏逆ﬢ䢳"+CHR$(34)+"꒨⪟銠꠪劤 삃︪ቫ႘쀀Ȇ踨꫺諃ↈꔎ Бࡻᆏ颈갨Б৻鉟ꄯ꺭怀=䪔鿄ᇼ䄟쀀ࠄ߱ѿ၏∰怀ࠄϰꐥࡏ䤐쀀∈迹⑿ቇ⒱ࠄ࿺勿褭逨⤲ ∈边⣿鈯옜怀䈽㷠菾䄟쀀ऺ䯚軽襃튪못 뻰⯯袾 '縒럥䥞ꀧᄄ俸䡿銥⧾䂟:꒫꫿ꪪꮪꪼ ␉߳ⁿሏ⤲ ȹ׻틟괩ﯔ鲽Ȉ舡ࣟ킄℈䈐耀Ј舁绂ႅ龜䈗ࠂ࿸䠡ᾡ䁒⒱ࠂ⃿舀耠ࠂ ऒ蠀縢ႌ뤨东怀Ё⿸蠢뺢ႄ䚖 聀⃿詄ꏾ⤲ Ƞ萠࢟邀 䈠耀Ƞ蔸䢟鈠倀䤤 ሪꔫﺪ㺊ꏨ贾 ऒ蠃빉⑏奔휖怀삃﹉ῄ釼࠿Ș觻逩㿢勔⤼怀 訢뺢ኤꪛ ?젓ﲑ❊協袬 ࠂ࿺訤៭ॾ傗ဤ䪒龡ე劧 ꈨ诤⌘檔Б৻ꩊ◯䥞풕ࠂ߰⛿ન쯾ꪲ怀∈迱哽ত觼࠿∈迱哽দ蠀唢ꀀࠂґ⑿Ȁ舢袿ࠒ鈭ꦪ䢒怀Ƞꐨ縂㋅⤈ꀧЉʉ绅ᙤ煤䘖怀Љʈﺥ⹪狤怀ࠂ࿸ⁿ࢏歷ꊏ耀?蒿꬯窴Ꞿ䀀Бҋ︥⹪烤怀쉐䣿ꩄ䀹Ᾰ䀀нઋﺥ⩯灤혎怀ࠂ䧹䠿蒅賂鈧縲ᗭ䥞咑 Ϲɼ꤫좒㲀쀀᯦︢誾ꢋ࠾ӹ쉞뒫㺰쀀Ƞ藸⊏遀⁾䈡耀ࠢ䗺䡟蒅蘒ﾂ .鿢䢺꒫ꀀ﹄៥੾邇Ȑ觻젪銯ꪪ"+CHR$(34)+"꒨吕㊤꤀ꀧठ蟸创됧襤ꄧȼ蓻틗걉⏾鄼쀀'뺨ꯪ誾ꔦ 䀐ݹ剔ꔪ袀倣툔褤订傔쀀<恣킗ꕏ判褠䀀쐑︒㿢ᇼꄏ쀀ﺥ㿪諾С◸ኅ០衾ꢣࠂ࿺䣿ꒉ唥 Б⧻鉅⟮裾ꢫ?︒㿢ᇼꄏ쀀ࠟ삓︉㿠Ǽ䄟쀀∈迹呿ҏ愯쀀∈迸郯腏朗경й⃻鈅㿠课ꢻȼ褣ﺒ꒯䩒邾쀀뺢⪤꬛ ငă︢ႇ䀰㌰ Ё߹_遄≾舁耀줈耟邍龜劙ꀀ ⩊賬肔ꂧ耀Ȟ誣︪몣ꪲ⢾쀀9쪊샟ꢋ﬈銩ꀀࠊϹ䓟ᑇ浪咚쀀Љ䏹ⓟ鐥壟弘 Ⱥ꯻钿꩎䫾ꢬ쀀?粐⟪⊈舿踠蠢㿢₈䈐耀?싃䄟쀀Ȁ躪겢⯪誾怀ࠂ࿸裿ꔪ筲钧怀캒벩⿪૾ࠊ迺訢ᾄ৾䄟쀀+葯ꥀ菾∰怀ࠂ࿸裿萏㰰쒓ﱉ៩௾傗ࠂ࿺ꐊῄᇼ䄐쀀鑐၇ﬄ儒쀀ࠂ⑉ረ訢ࠆ ࠂ⑈ꈁ逈జ ࠂҐꣿꀫ뺠怀Ё߹၄ῤ䈐萏Ё߹၄Ῠ䈸ᔙ ࠂ࿺ꢣ뼨ꮪꬻ  ⿑⣼ꉏꈢﴈ耀耠㋩ྂ酺袆 Бу푄鄆쌂䌷 鉉逆ﬢ䢳ࠊ迺訾ȇﾂ Ȑ藻詟邧常怀쐑ﱁῂ⏾∰耀숐ﰡῤ৾䂟銩렊甆舠㿩䯞钽	숓领䋒ꢋȈ芫᯦誾ꢊ怀Ȉ菻ꐿ騦甆뾈耀Љ䋻驆婢ꪊꀀ'⊑送傧Ƞ蔨Ⲃ១ࡾ傤怀Х앀ﺄᕂ전䘦 ဥﺔ锡咥Љ௺邿詅廊説 ߱⃿ሇ唢ꀀ;銯ꨮ唢ꀀЁ߻넅祐鐯ࠂҒ樄ߎჼℏ쀀ȸ蒩Ⲃ㯪誾ꢺ怀й䓹撏멊婢ꪺꀀऒ萃︢௤⎈徐耀Ѝు㻲ႆ덊䈑耀ࠂ࿸䣿袃ﾂ Бݺꠐ῀菾∰怀Ȉ諺㯢釄ꄋ鈩透ꢫࠂ҈ꐊῤ৾䂐怀∈迸衁ῄ᏾肿∈迹ቒ㉇滑턒쀀∈迸避ㄇ唢ꀀ梀龪꫺袯怀ࠊ迺訾ȏ옜怀9쀓ꈈ벀⎒꒻;蠊㫠ꎨ꨿;鈉렀ﮢꢻऺ考︂㯠⎈뾸耀쐣ﱉῂ쭚┶ ࠊ迺䪾袃㸰怀﹉㿥䦞䂟젪㻢ꊨ⨿︪뿢ꪾ∿Ȝ裻퐥㿢ꪾ∿ȸ诺ꓟꨪﬢ龠耀Ȕ辩䳺⯯袾怀ࠂ‏Ȁ耠࠿ЁC︄ँ䀠㘰怀쁀⋭઄鉢?삃﹉㿤鏾⨲怀?ȼं䂒⒱?Å禍뾥⯺墥怀Ȑꗻ졞閥兴 쒓뱉Ꮴ腾怀Ȑ藻鑟酅浪賈ꀀȐ蓻푟镊ﮪ夓ꀀࠊ迺誾與䤒쀀Ȉ菺袯ꢋ甆⾊ 뱉῭⦤䘶怀옐䠜㣠菾⤲ Ĉ䈓︡ᩆ勈ꔎ #씐纂迠⡾䈡耀Ȉꨩ︢ࢂ↔ꢌ 쒓ﺢ辂⃸∿Ȍ跹⓿鉅שׁ礓ꀀ∈迸裞酈觼% ȸ臻鐟륁ﮪ뤻ꀀȸ藻铿ꥋﮪ뤻ꀀȘ觻숯벂모⸼怀ﺪꯪ⏾咕ꀀȗ鹄闥䥞Нࡻ뺨ꯪ鎺耀Ȑꗻ衂ំ錤庰 ȗ鹄闭䧞倗ȿ뗫䡞〷ﺠ࿦ꥺ袯쀀ऒ䯻呕⟏⥺튗ꀀሴ꯺꣪꾪叴ꚏ 葃ﱉቇ䂟Ȝ褣ﺪ뺪ﯨ誧ʡﳁ鿄ᇼ䈼怀Ȝ袣ﺊ뺨ﯨ銻?ﺢ⹨᏾ꄄ쀀﹈Ὲ鈤ᄘ怀Ȉ菹䫟钥⥾䈐耀绀Ꮴľ䢓㻀韤褤䘖怀?ﺢ⹠Ǽ䄟쀀៨ꎪ䤗 ࠂ࿺ɟぇ籠츜怀ࠂ࿺ꨈ㿢ꇼ즟쀀`ᑅੀ鄇쀀ȏ뺨ꯪ諾┊ ៦ꌪ䤷  偗뽂叔椪䀀?吔㿢⃸∏耀ࠂ࿸ꡉ࢏欬ꀀȈ菻蠿饇着뜊ꀀ'㺀韠蠤䘦怀'ᒙ邁䬤ꀀࠂ߹≿鈤觾ࠂ Ё߻⡑㢤쇂茧 ࠿ྂ⏾∰怀Ȑ藻쨟貥⭾成耀ࠂ࿸ⁿࢌ퇢⸲怀Ȑ裻銯ꢾꈨ耀?ﲁ⁏蠿∈迸蠈Łी鄇쀀∈迸裿锏甪䀀 幔뼢篬攪怀9삋찌㣀쎂ꌻ ࠄߡࡾ郏㈱耀ࠂ߰蠢㿠臼ࠂ С䓸␟뉄鄾ꀧĜ䢓쐧빂ኤℾ䀀삃ﺪ鿄Ǿꈮ怀 ԁ䂈䄠 ˹ÀငĀ䀓?䈰萢袒䄑耀ࠂ࿺䫿ꒉ萯잀 㿠耠࠿쀓︤뷠⏾∅耀℈䟸萿࡯怟쐑ѿᒄ鈂頁耀=풒㿤ᇼ䄐쀀;쁓鐟㥀厔ꤺ怀'쒐␟㉄褢ꀧȸ诺꫏ꪪ﬈龠耀倕䫾ꫯꢒﲈ쀀Бݺꐀ㿠௲䢞怀?︔뾡叔麽 縰韩ࣾ䔦 нѻ겉⏎鈼耀?⫂ꤨ䨪邿?빈폤儾쀀'㸈돤儾ꀧࠂ໺ꪲꢊ⊈ 삃﹉㿤鏾࠿䈠軺ꫪꊮꪪꮸ耀Б䓻ꑟ鉆ﬤ䤳ࠂꐪ઄鄢袆 ࠊૺꪪ袅ⅈ蔦 ?ﺪ꿮꫾ꈿЉ௲鐩㱢⇾ꈈ耀=䪄鿂⅔ﾂ ࠂ࿸裿袃옜怀ढ萀縄㚤煪ꐧнӳ퓕⹩⏾鈼耀Н䣻빂瘝⤿︪뿢꫾∿ȼ諺裛ꮪ묪鐤Ѕ⽉繀㿤䅾怀ļ䫺裷ꚮ몪ࠢ⿸⃿꜠Ͼ䤦 ࠢ⿸⃿袏慠뺠怀Ȫ謻ꢯ턤犣 ᩆꪲꠋ␉ླྀꫴ诋䪺Б䟺꓿鉇瘝邏﹒៭↾䢳扣馇ʠꆉ耀슓ﰩῦ૾ꂏ∈迸⃿ꤪ䣸∏耀​뺨뿨誾㔲 ࠂҒ樄࿬䇼䐟︒࿥⍾梓'ꑐ岈韢蠾䔧敫뙔鏦謾䢳Ȁ耣︂ႂ ȃ耀ࠒ䒓﹉ቄ䀟ဥ廼闧졞夥 ␉ɻ빊鏨괾 쐑ﱁ㿠肼㠱С׸ሿ脥襤踬怀 ⾪諾袯ꪪꢪ怀∈迹䪮볢䏾Ⴘ쀀Ȓ蒣﹒ᒊﮈ䈗ࠪዬꄨ䨗Ȋ芢뺲⢊愈∏Ё⟹ࡺ銤酤芣 Ё࿸ꐡ⥋劈꘾怀∈迸鋹⮧肾䠿쐑ﱁῈ苼࠿Ȁ迺袯뢋甆 Љϻ鈿餧瘝긌怀︪骦뫂ꂏ?⁈Ꮔ脠䠿Ƞ藸࢏邁侢 Ȋ誣ﺪ⢃ﮈ∏ࠒҁﲈ∇࠿Ё⿺ᓲ╈觼唿Ȉ诺蠯벂梨꾊 =퉔뿠臼࠿ࠂ࿸ⁿ褢䣾䀐  꿪諺訯옜怀?ﺔꔪ笂肿ȸꇻ젒뾡叔겸  黩࿀Ͼ∏耀ȸ臻蠏뢁ﮢ꾺 ࠢ⸎뚤ꥲꀧ=귩鏞鄽ࠂ࿸ⁿȏ滑缐䀀䀓켑㻲鏯⩾耀ࠂ࿸萞㡣缐䀀ं輀뻸訢璉ꤌ怀9쪓ﺠ⯎銬ꢫ ߻ၿᄏ᰸Ё߹⑿鉅禍钅怀ԉ䏺钥⿪誾⢋Ȁꟹ䡚钧퉄몕 잁鄅수薁 ሄ蟸䠒㿢ჼℏ쀀拣驆銤너䀀?‐࿆ኄℏ쀀Ȅ軸裿袃廉꼌 Бߺ铿襏碫Ȑ觻蠿邏꼬 ࠂຸ⃷袇㸈耀ࠂ࿸ⁿȏ㸰怀ࠂ߰⃿蒅㉊∉耀ȼ褢绵ॊꔾ䀀ȼ觺䣿袋甆꼼 ;㺈믪誾ꔾ 剤네褢焁耀Ȑ蔫쩟邆⍊劷Ȑ藻ꑉ៦謤䘶怀뱉៦ፂ䤴 擣ꁏ鉆鍄儰䀀;삓ꐉ렁꘾怀ࠂ࿺判Ꮿ䤒䢜쀀䐑ݺꓷꔯ䪒钻怀ऺ考븈먠ﮔꤼ怀삃ﺪ鿀ᇼğ쀀줓︪銯ꢫ삀⃿與䄟쀀Ċꉓﺪ꯯ꢪ⾾耀Ȉ舡䫒钥⥊劗ࠒ߱₈㿡䁐⒱잀 㿠耠ࠂ ࠂ㰈ȇ䄟쀀ࠂ࿺誾袂⃸?ࠂ࿹⑿቏℄쀀ࠂҒ戀ȏ㘰怀⒉≈鈤褢袠 ሪꔫﺪ㺪鏴⊉ ?﹀鿪ꩦ⪖怀摋៦卾䔶 	슋쀯领靖ꈋࠊ˻쀯骦꫾ꪊ怀ࠄ߱ѿ၏䨦怀С◸႟鄁䌧 Ȥ藸䢂០ₘ䪤Сװᒉᑠ菾⤲ ढ䗸⒟镂꡾傧∉࿹⑹ቅ뀀唢ꀀﺠ迥椶隫怀ࠒ࿹䁏鴩牐ᰘࠂ࿺判ῢ᏾ᄘ쀀Бݺ꓿耏䩒怀ȑࣻ鈯ꬭꀀऒ䯻♿╏奔횟 ᄄ迸ⁿȏ琢䔦 ȹૻꊯꨮ響ꬭꀀ䄐䟹䑕ⵉ偾ℰ䀀‐켒勘ꐏ穒풭∈迹呿鐉拓⪒9삋쀏뢀ﮈꈻȼꧻ좟꒏匣 ȼꧻ젯袋慠ꌿ '摈␟녅襤ꀧ'縊럄饜ꐧȜꣻ젯벂響⌿ Ț裻㿢⋘⪼=뷨訢钨ꀀҝ䤃ﺩ㿪鏤ު䀀∉࿸ôꔯ䩒怀∉࿸ⁿએ滑䄟쀀ࠢꢿ骣红 Ȟꓺꠒौ蠀唢ꀀȡӿ與࠿Д꒓︚诤ꮪ徐耀ऐ觻衟ꊯꢫस读袿ꪯ甆ꢫ븪뿢ꦾ눋ऀ迺銿꤫甆ပ麼륢臼࠿뺨ꨪ甆ऒ䗻ꑉ៦謾䢳萓ﺪꈯ滑䄟쀀ᄄ蟹≿鈧ℏ쀀∈迹骪㿠袼㠱㺨訦甆⢷ȼ臸蠤꿪ʪꪼꀀȼ臸蠯꺪滛ꪼꀀऺ䗹ⲕ㿪⪬긼怀븨訤ﮢ䢗黼褦竒⒋	鸤뼢秒ꒋࠂ࿸ⁿऄ课⤲ 鄯碒뒫∈迹⓺⯯ꊬ嚪耀8惣ꀏ멀뎦넸䀀;뻈ꨪﬢ袧␢⨫뾤ꥊꀧ္젓鲁㿈鎴袻ꀀई菹䫟钥濫䢓⑫麤ꧺ쒟怀?剔襂先贌 ᐕ俸裿ꐏ禍 舑ﺡ࿂Ǽꄏ쀀ࠂ࿺ꫫ舏襤䘼怀Ȉ訡︢ࢂↈꈏࠂ࿸䃿誄鏾∰怀ࠂ࿺ꩉ⪤鉒∰怀ࠂ࿺∈㿠聨⤲ ﹉Ὺ䫾ᄇ쀀?Ⴟꤪ䪖萿ࠪ࿺ꨲ뤢預儧ꀀ 鹴ꬢ硈傧ꀀȐ藻쩟钧ﬤ䘶怀빀Ῥ⥾労ꀀ﹒韧⭾䈰耀뱒韧⭼䊷쒓﹒韦⍾䨴ꀀ쐑ﱁ῀菾ࠂ ሄ迹䩿钧ℏ쀀䤀蟱⑿቏⤲ 	슋︨鯦芾뢋ਊ菻꨿骧甆ꢋਢ蟸꪿骣傧쪒ﺲ迤ⅾ訬ꀀ葃ﰉ㿠釼ࠆ Ё߻䩟뒧襤蘮怀︨騦﫢ꢋࠂ࿺剧Ї儧ꀀਊ诺꨿몣廉ꢋ줓숤鈏ꢫꀀȐ觻숯ဏꪭꀀ=쨒ꋲꤊꤋꀀ∈迸衿၇ﾂ ∈迸袢ᯢↈꈏ∈迸郿锎硈ﾈ耀∈迸衉⾢⇼ꄏ쀀ሿ껤䃾锩 Ȥ藸䡟ꐏ옜怀ࠂ߰⃿舂㠱ढ萀縂㟤儢ꀧਯ︪뿥ᅼꀧ죋뿢䊾Ⓗ삃ﺪ鏯褾?꯯꡼튏쌑绒韤꥜䪕ꀀऐ藻쩟钥濫ई菺銿꤫甆⢋ऺ䯻꒿ꥏ뺩 ∈迸裿ꥋ뺡 स读銿꤯ꢫȤ藸䠂㟤褾ꀧ⋏邅㥈帘怀ꔫ穒钥咘ꀀ>⢫ꊯꠊ傢怀=튔ꔯ䪒閻 ࠄ߱ѿ၇儧ꀀ쉟邆묨丼怀ࠂ࿸ⁿቇ⤲ 'ꔨ窒钡钨ꀀ쐑ѿȂ㠱ȧ縒럤ꅊꀧ"+CHR$(10)+"䌉ᣉᐦ濫䢓﹕ោ䇾蒧ꀀȸ꯻ꢪ꾮逤ꊥ ࠒ࿹၏鲉煮ᔚ Ȑ裻젯透ꔪ怀ࠂ࿸蠢ᕈ课ࠂ Ȑ萣︒貥תּ犗∈迸蠾࢏∰怀ऐ藻聞钧庴ꀀင࿸耯၌ⅾ䈑耀;ꉅᢍ龜䪴ꀀ∉࿹呧၏∅耀쒓﹐韧୾䔶 Ĉ䈓︡ᩆ劄ꄈ쀀/刿뒅楪ꀧȈ芩⻎隤ꄠ䢓ࠂǡ蠓蜮蠔؎ ࠂ︈ȁ䂈儢 Срﺄᄀꀤ钨ꀀйǻ숈㩠ꢻﺪ꿪꫾ȸ读Ⴏ봨秲࠿䄑⠢Џ㰰Ȉ菺邯겊甆⾊ 葁၆ጄ䄱쀀Љϻ舨ᩦꢋ∐迺䋔╯扰풥Ȉ菻逯鲆甆꾊 й௺苈⩪袣ȼ訣ﺢ⢏偤풌ꀀ>꩓ﺪ꯯꠪쾌耀Ȉ舡绂ᇄꥈ侐耀Б䓻ꑟ鉄襤賈∋锢⣂䢠怀?∋ﺨꬪꪢꢪ怀Љ◻ࡂ၄蠠袿ࠊ迸꠪㿨觼䤒쀀Б৸ဿ遍滑儒쀀ࠄȣﰢ辀肔ꂧ耀‑⥳킗봉砐傧ꀀЉ佈郿ꪏꥄ瘟 ∈轸裿镊⣸∏耀ࠂ࿸ⁿҎ넲⨶怀Х䟸咕ῢ䣾咥怀йઋꊯꠎ甆ꢫ<躢껮ꊮ갬∈迸䀢㿀ৼ䄟쀀Љ◻ࡂ቏옜怀Љⷹࡿࢣ㸰怀#㸈돤鄲ꀧȠ藸ਟ뒤녚ꀧऺ訂ﻊⲪ猪늣 Љⷹࡿઢꏾ% ﺤ뿪ꯪສ怀ԉ≁绂ႄᄄ䂐 ငȑӿ耇䄟쀀ࠂ︈Ȁ聐∰怀Бݺꑿሇ⢲쀀=꿩⏮鸼怀=뷢⋒?뻥⿪ჾ䂥怀С׸⒉ῡ⡾删ሤ蟸ꢫ鼢루ꪪࠂð‿ࡃﾂ ꢲ꧊ꋌ ࠂ࿺˾Ё﯀ႇ旣遄ᇭ섐䒱ꉏ鉆錤傴 衄Ꮽ覢䢳#⊏鉀逤傤 '摈的韡⃾刧⡒맄ꅌ 8懣逄㧡쎐꒹뵂愈⾼耀/ﺐ២꣺誯怀ऺ䇻蠟뤀ﯢꢻ∈迸裿袃㸸耀씑䑽ᕅ兔钤 Ȉ芫⯯袾⢾怀쐑с၇䄠 =劔ꔩ䩒 ⋏鈤褾䀗Ƞ藸␉㟤ⅾꈧ﹀ῥ≊鄏 ࠂ࿸衕⾢䏾䈉耀ऺ訃뺨ꨮ杖꤬怀=㿢⏾∰怀?풒㵈诼∿Ƞ蔨䨒뒥⥾ꀧ骧몪ꪊꀀ䓈䠡ါℏ쀀㺪详⊾∷ﺪ뿪课«ई菻ꨭ騧廒ꢉ怀й䃻ꐟ멀ﮤꤻ쐑䑉㿤ᄄ脡쀀䤀蟱⑿ቇﾂ ԏ뺪ꯪ⋾ ꉏ鈤褾ꉏ鈦謾䀷鑙邍落䬴ꀀ쐑ѿ၄ᇼ?吿ջ뺂⏨唢 Ȣ꒨ᒘ邀ꢪ䔦 ढ䗸⒏ባ堧ࠢ⿸锥刐訌怀#븨븢唣Ȓ꒫︠⿪䃾ꀀ䐑ݺꑿቇﾂ Б৻숯邏뢨긬怀ȼ諺ꫪ꣊厔ꤊ怀;ꊯꨮ誾ꀫ?뿄釼ࢿ>惣ꠓ몀ꎾ령禍뼅㭺儽ꀀ?ዾꄪ䩒蒿Ȑ藻퉗鐥襤ĺꉓ뺊ꏮꢪ㾰耀)탿꤯䪒 蒿뤋瘝 Ȑ藻퉗鐭捻䤗;좓ꒉ레ﯤ蘦怀쒑ﱉ቏グ쀀:ꂫ鐘뢀ꮪꔾ ȋỄ闥䥞倗䀐ߺ銤뼢䢒咣Ȑ蒣깎隤ꄠȸ芣꺎ꚮꂠ⢳=訚郤⥊쯐ꒉ䀝鿪ჼℏ쀀Ƞ蒠⺎隠ꂠ䢣ࠂ߻{뒧ꪑЅ仸꓿詂理ꤋ︄㿡ᅼ䀟нɹ⓹ॏ傈☾怀န׻ꪪ꾮ꤪ嚼'縕㟥ⅾꈧȼ誣꺮ꂠꢛБݺꓷ銠菾⨲怀ࠂ࿸遉㿤釼䤟쀀Бс⩂ႄ℉쀀Бݺꐀ㯄鄴匼怀∈迸⃿褄鏾䤟쀀'樇㚄ㄲꀧȆ軸ꣲ௢⇈ꔎ ࠂ࿺判㿢ᇺ࠿∈迸蠜ࢄ鋺ࠒ䀀Ȑ藻ꑉ៩⯾咕ᄄ迸ⁿ葏턇쀀ࠂ࿺⊈ꈯࠂ Ȉ菹䫒钥龜䈐耀ࠂ࿺≿ቇ䤟쀀ࠂ߱⑉῀肔ꂧ耀Ȑ萣﹒钧תּ劷쐑ﱂ⿊⣸∿Ј舃︢ᢆ愈ꈏР萀纂ႀ䈧ࠂ߱⑉ቇࢿࠂ࿹⑉ῂ謔䈜怀и考︂㢀ﮈꈿ?∋ﺨ뜨ꯢ袾怀Ȝ裻젯벂朗⪼怀м訃ﺢ⢏툏︤魦䋾ꢈ쀀Ȯꓸ䢲韡䣾咭Ȉ꫹ࢢ迦䪾㒱∈迸蠈㿨ৼࠆ ∈迸䑿蒏턇쀀ȼ觻슐⟯င儢쀀? Ȁ耠ࠎ Ѕॉ吔൅䩐⒱/︤迢઺ꪫꀀȂ꿺ꪫꨋ滛ꀀࠂ࿺諼ᗯ詞Ȉ舣⪊甆⢋ﺨ⯪ꊪ⤋ Ё߹@ῤ∈舃耀삐⑿ሏ諸ࢂ쀀;뺈⟮ꂪ⤳ ?⩓뽈插锽耀ਚ誸切鞬酴䪗 ਚ诸ਫ਼뉅儧ꀀȒ蒫ᛎꤨ劸쾒볹⯪菾⪍怀 黴ꔯ穒怀ဥ庼餣粥怀Ȫ꯺ꫫꈏ滛ꪬꀀ>ૺꓹ⩊鏤ā쀀Ⱥ讫겪⻎ꪨꪼȼ諺裿ꪫﮈꢋꀀ;뺨⿮ꊪ꤫ ;쪓벩⯮苾ꪭ怀Ȋꋻꨏ⪼ꀀ7縔럡஺ꪻꀀȺꇻꨋ먁ﮘꪼꀀ​鋸৫䪞Ⱦ袪⳺ોꪨꪼȚ被㻂ꪨ⪼숀ﰠ㿢邔∞怀繐韥ॾ씆 ࠄߡࡾႇ咪쀀Ȉ辠黺ꪯ좒炪쀀Е앃﹄ᕆ쬄䘶 пﰡ⿊ዼ耿ऺ訃ﺢ⢏愈ꔮ С׸劔醀ꀨ劤캉䱌㡤耀๾ࣣ㸰怀ț︨뿢諾┾ ȸ诺꫏ꪪ﬘説ꀀȠ藸ટ邡徠耀स读Ⴊ뷈꧸࠿Љ䋻驆﫤ꤋČ芻Ầꪮ갌ȡӰ␉㏤褾ꀧĜ袻㺢ꪮⰼЁ߻џ뒥壘龤ꀀ'縒럥⥊ꀧ비ᚤ煪 ꨿騦ꪪ뾈䀀﹒闧⭾傷"+CHR$(10)+"︪龦몴댉怀䫒韥⥊劗Ƞ藸࢟邁䜦 젤ᯧ誢ꢋȠ萠縂や℈ꀧ∈迸蠈ῄᇾ䂥怀ꑖꀏ꤭ꀀ︠㿢䊾⢼쀀Ȉ菻蠯餧者뒉Ƞ藸䪟鈠䜦 ꩋႄⅾ耀ࠂ࿸⃿ꪪ꣸ᐿ﹒雨⍾檒ꀀȐ蠣︪銯ꪫ⑉ቄ鄢袢 쐑ѿȏ諸袢怀Нࡻ봢⫂₾쀀ȉ࿲⑏㹊﯂ꪽ怀ࠂ࿸蠢㿨ৼࠆ Ⓩ鉄褲䀗Ȉ菹Ⓣῦॾ䈑耀Љɹჟ鐥壟弘 䠔‫뺪⯲撫怀ࠂø‿ࡃ㼰怀쐑ѿȇ࠿﹈鏤⎮ฌ怀ࠂ࿺ɿȂ㠱ࠂ࿸裿ꈧ䤒쀀Ё߹_钅梅邏ࠂ࿺ïꢍ愈㈳8拡࣯袊ℾ性∉ﰉῄ臾⢲쀀ऊ舂ﺤ꿪䋾ᒉ怀ꑏ鉆謺䀷䑿鉆鍞堹﹈鏦⌮丶怀ऊ舃︤鿦䋾钉怀'ҁ၀ႄ䄡쀀ȸ藹䊏뢊모긼怀Бѻ퀟౅弘怀ꋿ袂杻ꈋȐ觻ꑉ⟯⢾ꪪꀀ‗꓿ꥋ厮갬;萁㡀ᎄꄹ쀀ȸ臻ꐉ㿡⮾ꪺꀀȼ觺哵௫⪾ꪾꀀ'縒㟤ꤪꀧ>䫻⒨ꮪ̾耀䠄ꪫ㚨꯺匢耀㹂ኤℾ쀀/ꨪ甆뿡䏞唥䀀'纐ᔡ灐꒩Ȑ藻ꑉ៧⭾咵摋뙄鏦鍾䤳∈迹⩈뾪叴隽 Ƞ藸⒉១⡾咥ࠒӻ봩⩂쀀Бݺꐈῤ觾䢟ȧ縒럥䥞ꀧȘ觻ꑉ㿥⭾咽.໤좪䲦怀䀓㻩ቀǼ䄟쀀ሔ诸刢龪勴ꚫ ਒蟻≒龭兴嚵 ਒迹⋲랯兴 Ȣ蓸䠟낄儢ꀧȚ裻㿢⋈┾ ᐅ߱呿ᕅ叾∰怀ȗ빈鏤襾 ?ⁿȀ聐∰怀﹉ῤ鋾鈎怀Ё߹၇鄅既邇'쑀Ⴟ鉁䢔钫䀀Ȑ觻꩟ꊯ傾ꈫ⹈黼褢篒钽ȼ褣캒⒏ꢫ 胿ꪏꊒﲉ​뻸ꏯ蠾唢 ࠂðⁿ၇唢ꀀß鄄鄤劗 >븊篲匣 /着鼂룲謩 ?⊈뿨訢袿삃ﺪ鿄釼䢃?ﱉቇ⒱Ȁ踢ﺢ⢊⊈Б׻鉅៤襾3섫縊ᖨ臼࠿졒ᗪ䮲咑﹅ῤ詾ꢃБ৸ဿ鄍祐尘脠ࡂࢀ㡸耀Ȉ舣︢ᢆ⋈ꈋȠ藸咟镁Ꜧ ?䅑稢鿊⣸ሿ∈迸郿ቇ⒱йૻ銥⿮衾ꢫ#씈㸂㟤ꅊꀧ 訫㾤ꯪ䬞耀Ș觻푟뵅ﭒ䜾 ;⒏멊課ꀻ?㺊㲊窒ꢺ쀀 ⨳㌡Ͼ႙쀀Ё߹⑿鉋ผ怀ࠂﰈȀ耠࠿쉔镊又䔖  ⩒豌ꠐ儧ꀀ꒩䫾꒫邿怀ࠊ䊣ﺀ꾢⃸⒱ငǰ葒̃⌶〃耀Ƞ蟸䨟蒥落説ꀀ?䈐萢ࢂ䄑耀ࠂ࿺⓿ꉏℏ쀀ԑ䗻鑈闤ľȐ藻쩟钥勒ࠂ࿸쓞萏℟ࠂ࿺ɿЃℏ쀀ࠄߡࡾႇꢾ쀀ȉ˲꒯⩊廒怀Љɺ邯ꨪ甆㾈耀쒓逆䘶怀ԑ䗻鑈闦̾䢳ࠂ࿹⑿ቇ⤲ Ȋ芫᫇ꪨꪌȈ苻젯颧朗ꪈ怀Ȉ菻ꨯ骦滛ꪌꀀࠢ׸鉊⑇凜唿ဤ׸䊞鄣咧쀀'씐粑១þ䪥怀С׸႟酃唠쀀	쒡ࡆᅄ褠쀀䩚该褾蔧ࠂ҈ꐈῠ৾Ё߻_됥襤褯Б׻逿襇ﬤ唐쀀Бݺꐈῠ⏾∅耀Бݺꐒངૼℏ쀀Бݺꐀ㿨௺꒯怀Ȉ诺訿뢣廉ꢋȐ觻逩Ꮿ傔꤬怀>∩⫺袯ꢊ₾怀∈迸⃿誂ꇼ࠿∈迺䑟⑅䢤쀀∈迸䫿ꥋﮪ뜪ꀀĸ䀓︁㩀厄ꄸ쀀Ⱥ꯻꒲꯮˾ꢫ?ﱁ၇␿ȼ觪䳺诫誾ꢿȢ螸⠻늄ꥎꀧ'縉㗤䤦ꀧ䡛뿢誾┿࠺ૺ싞꤫﬒钧쀀?ﺐ꟯ॾ唾 Ⱥ꯻钺ꯎꊾꂭ怀=뿨诪劾怀ğ䒑ﺪ꾪꫺袯怀Ⱦ舣ﺪ뺪꯲₾쀀?婢꾪⪊뺠怀ࠊ迺誢辀臼࠿र臻⑉⿠⏾∅耀Ȉ菺꒩⿪ꪾ∏Ȑ藻ꑉ៦ꬾ䈷'窐鞡⡊庤怀ȸ读꒩⿮ꪾꈿࠂ߰䠒㿢郼࠿?몠ꮮꪪ꺨怀∈迸衿ꐧ咟쀀ढ萀縂㏤褾ꀧ﨨뾢ꪪ⺾怀Ȉ舺袯ꠊ愈ﮀ耀ȡ໲⓿ቄ﯂䪕怀?ﲈ㿩˼鄿㸨鏬ॾ䢑怀Ȑ觸࠿銭龜䢛ꀀȠ藸࢏送䔦怀Ȉ諻좯蠣ﮂ⢉怀‍ῤᇼ䄟쀀삃︚ੌ袐⒱Бݺꑈῄ臾䂥怀ࠂ࿸⃿詏襤䤟Ȉ諹⪪誦愈⊳ȸ胻蠏렀ﮢꔺ怀︪᪇窒ꢊ쀀씓﹒韦ꭜ䪕ꀀ舠蠢㣨ਂ肿ࠂ࿺判რ菾∰怀禍霍㧺儕ꀀ﹂៥⩾銇ࠂ俸遾ყ羪ꀀ∈迸蠈π臼䄟쀀ࠂ࿺˿鉇㸰怀﹔駤৾䂟ဥ자庺闣ꢾ뤪쀀࠺ꫫ꨻ ࠂ࿸⁉ቇࢃȈ菺ꊯꡊ⋾∉耀∈迹≺蒢Ꮴ⊛ С׸႔锡䒡?ꢲ꧎ꋌꊫ '縒㗥䤞꒧뺨꯯誾┎ 삃︒ࡏ滑䄟쀀쐓ﺪꙠ菾℟ꀀȜ裻젪뺢直⊾ࠂ࿸衝‧䤦 =푖ᕏ䥒霭 ࠂ࿺⊔ꢬᨂ肠怀 Ϲ⁏∈耾ࠂ ?좒⒩⯊銢ﺠ ∈迹ᑿ꩏夣Ⱥꂳ蠟뢁ꮪ꠽ᐥ䟸뒿镃괩Ȑ藻鑈闆;䨵ꀀ좓㿢ꪪ⺼怀ई菻꠿骦꫎ꂏ>⪫ꪯ꠪좌 ︪Ꮿꢾꨨ钪밊慠ꀀࠂ࿸⃿ꔫ뺢怀Љϻ逿骧朗뾉 Љ࿸꫺ꪏꊨ Е俺꓿詏夣Срﺉቁ၈踬怀 ߰   ﾀ ﹐ᓅ쉀邇Н⁋︂ᲀငᲸ ࠢӸ䠂㋅⤘ꀧ Ϲɤꨫ࢒㲀쀀?⟮ꀪ꤫ ࠂ࿺劢뉨詒ꊠ怀 ⩏還⤿䈓︡ࡂႄℏ쀀쐑сῄᄄ䄟쀀>芢䡂Ẁꏺኜ ȁ䂐䈠怀 Ȼ銨ꭊ㊲﹄ᴩ剘┓ ∈迸蠔㷡䏞ᐿ握ࣂ៤℈䈗擣졒៪⏈䈓?섑䐡ᒀ肔ꂧ耀;ꨄ뫀Έꢻꀀ'纒雠⁾咥怀︚跥ꯞ媕怀Бу븲ࢄ덊䈑耀ࠂ࿺≕␧ﾂ ∈迸衿ꔢ逐儧ꀀԉ䯹ᒯ誦着⪳∈述铽ᖪ蠀唢ꀀ ϹႿं䏾Ё ȡ璀辀‐儧ꀀ씋빀Ꮖገ䢳ꀀė䕻둅ክ⤀唲ꀀċ䭺뒥થ⤀锢ꀀȈ誢츢㲂廉ꢋ?脠䠓萢ࢂ䄡耀;㻪譪褾ꀧࠂﰁ䄠뀣∈迸顫⢠臼࠿ࠂ࿹⓿ꢧ옜怀ࠉ⌒ꂡꪪ䪪₏ԡ䗸䪟鐁ꤣ Ȑ裻銯ꢪ怀‑⥳퀇봉篐钭࠹⬓ꂡꪮ䪪ꂯԹ䯻꪿ꠏ着꤫ ᐅ߱呿ꀏ瘝☼怀;븨먪滛?䠾㫢ꃺࢿቄ鿤Ā䂏鏦茠䢳衟鋇⭾劷?ﱕ㿥䥞ﲉ怀鯦苠ꢋȠ藸䪒១䢔ꌣ  엀䚖ᔡ偘ꔩ =㿤釼䂟ȸ藹䪒㿪䪔ꌻ Ƞ藸䪷ሯ㸰怀?﹈ῄ臾䂥怀∈迸衿ቇ䂟ﱈῄ臾¥怀਒螹⢻ꊋꈮ鈤耀ࠂ࿺ꪕ⿬ꋾ訬衏邆⍾䈰耀ԑ䗛鑝酇팖䤲䀀нॻ╏倈꘦怀쐢ᦆ닊ꈈ耀?擨與唿ȩૺꫯꊮ杖뾨䀀␉⹰逿끇缐䀀й௻邿꤮䪒ꖩ Ѕླྀ僷褏襤ﾂ =싗괉䏒钽Ȉ菹Ⓣ៤ž傗Ȑ藻ꑉ៤žऒ䗻ꑏ቉ﮘ䪔ꀀࠊ˻쀯骧着ꪋऊ䏻ꐯᩇ滛ꪌꀀऊ䯺꒯੅落説ꀀ㺨訦婢┲ ︡࿂ჼመ怀ࠂ࿸ⁿ禍␱ȸ读꒩⿮ʾꢫȸ诺꓉⿪̾袣#縀㏤褾ꀧﺪ⯯ꢾ⨾⫫ႄ⍾成耀#꼪먨븢劣 ∈迸䣪諏ꂈ甪 Ȉ艁绐鐥壟傗>₫뾪꧊ꢙ怀Ȑꗹ⫯銥車䢑怀Ȑ葃﹈鈦ﬢ䢳Ȉ艃︨騦﫢ꢋȠ葀纐鐡傧Ђā﹀逧車䂟Бݺꐂ⟥ࡾ傧Ȉ譂븨븢廉ꢋ∐蹂뻨ꨯ甆ꢫ∈迹࠿ꊤ꡾儢쀀ȡӸ∏눤褾ꀧﺥ㿪鋚ꀀԧ㺈鏠衾䔦 ﺥ࿤酚謥ꀀȐ觻ꨯ銯ꢩ怀ᐿྂ⏾∰怀>⩓좥⨯偈픎 ࠂ࿸ⁿȏ賂踜怀?䓚ꌪꬦ袿Бݺꐯ븢廉뢋:䔉ᢉ㰪甆ꢻБݺꠉ㿡⏾儧쀀н䱾ꊋﾂ Бݺ됈㿠臼䄟쀀Б﹒ᗭ↾䪗袿꫋⪾⪋;쪓꒩⩎銤ꤪ怀ꪪ详ꥪ誣Ђϰﰡῤ觾䢟耠ࠢࡄᄄ肠 Ȝ蠣︢㷂꫈⾼耀.꒰ꢑ韀ꣾ訬?䥑䨢鿉䧼⒱?䑛퓨꿪叾ꔾ怀摡왆㹤츌怀Ȉꈩ绂Ⴄㄈ䔖 ?︠㺠⯪袾怀Б׻遇鈥䭔䌳 Бݺꐢ韬ℊ䌗 =뿩䮖ꊫ怀ȑ׳쑟ᑅ壟誥怀ࠂ颧꾪꫺ꀀБ׻ꑏစ壘ﺄ怀	숋ꨏⒿ ߻ⁿሇﾂ Ȉ芩Ⳃ៤ⅾ䈐耀 ⪪쨢뺢⯪₈怀ࠂҐꠈ㿠菾ࠂ ᑅረ踌怀ꀯ븢䯔䌓 	ꥪ䪒⢊ ࠔ쩚钇תּ嬵 ࠺瑅㷤鄤唼騧䪔ꌋ #⊈鋠肠䢣'씐䒙ᕁ၄ꄨ怀+ꃯꈯ䪔ꌫ ⊨諦芠⢳9呕㷥儔䤺Ⱦ說겢㿪ꊾ꨾耀䐑߻命ᗏ좨ﾒ䀀‑콒哙ꐏ禍팯 ∈迹⨿ꋅ⣾劧;ꂯꨯ䠔ꌫ Бݺ꓿꤯ﲉ쾁␪ȏ⤲ 뺨该褾蔦 纐뿥ॾ褬 븨ꯪ錻 씓﹒钭廊劸켒纒벩﨨쒐ꣿ誌釾䤟쀀‑纔뻉䧼唿‑纔뻉䯾愯쀀∈迹␪㿤鏾䤟쀀ࠂ࿹咔鿄釼ࢿ?⣻ꊋ먨鈿ࠄ߱⑿ቇﾁ ?棩ȧ䄟쀀쉟阊莢墓ࠂ࿺袢⻪⊈⺼Ȑ觸䨲៭䥒䌗 ᐅླྀ僷蔏砐儧ꀀ?﹊Ụꋮ訌耀Ȕ蔣쩟ᒇ⍊庼Ȑ藻쩒៧䭒䌷 ᐅླྀ偷ԏ㰰Бсትᆄ䄒岹Р萈ንᖠ䠰咡Ё߻࡟뒅勒ꌫ Ё߹ቄ῅ቈ踌怀ȹ׹䪟벫瘝뾸䀀Є踈鋽ঢ䦰뒉ԑ䧛鑝ꅏ킖ꤪ䀀?﹄㿩䏞鐭;ꪪ꯮芠ꢫȐ藻쨒࿥䭒䌗 Թ䇛鐝륁펖ꤺ䀀ᐅ߰呿ᔏ㸰怀ħ䕸稓띅祴ꀧᐅླྀ僷蔏䁞␱ ꄳꨪਯ䨒怀︪鯧ꪪ갌Бݺ꓿镇祲 ऊ䏹ⓟ鐅流徔ꀀ﹄ῤ䇾萡ਚ誸切鞭兔劙 Ȋ芣᪇ꊪ꺌쒑ﱉῄ䇞䐽=㿤䇞䐽﹀៥੾邇∉࿸ⁿȏ㘰怀ࠄϰ葿鈧ﾈ耀	퐣ᤧꊄ갈ȅ໸꫿誦杖㾈䀀?䢒⣬Ȁﾠ ?⑈Ꮔ膠頡摡㹢䋞ꐽࠂ࿸䠒ῤⅲ茯 ȸ读ꪳ⦮ꋌꪭꀀ∈迸⃿袍᰸ĸ䨓ﺡ⩎劄ꄨ쀀?꜏硒Ი쀀Àёᔩ詀ㄳ쀀쒓︪㿢ꂨﾂ Бݺꑿɏﾂ '縒럥⥾ꀧ	슋쀯頇敖ꢋ﹈鈩ﮤ䤓쑟锊ﮤ䜖 툤鏯䢒꒫?䁿၇䄟쀀;慫똖멁⮰ꆻ耀Ȉ菹ࣟ邇浪焗 ‎扣⹨抠⢳︪鿦˾ꨌꀀࠒʈ⓪ଂꄤ袆 '纊韠~䨤ꀀ?뺠ꯪ⾬ ?ﱕ῀Ͼ䤦 ࠂ࿸ⁿȏ옜怀;ꨋ㢀⎾ꈸ耀Ѝ൹拰锫⥂邘쀀ࠂ࿺胿ꔯ穒ﾩ ऒ䗻ꑟ钧תּ劷Ё߻낅壘閦 Ȇ踠꫺袆拂⌋ ∈迸衿ቇ䤟쀀ԝ䣻퐯뺢着⪿︩㹂婢┾ ∈迸裷耏欬ꀀꪏ⨿Н⧻풯봪폞ҫ舠蠾穒钽	≓襆┉耀Ȗꐫ︩⯄鄤꺬 #㺉ቁ䤤 %庼闡죞設 萒晴ᤃ㸰怀ࠂ࿺ɝ⊣㸰怀뻸诫覾㔲 䈐蟺ዺꪯ튤徭 '﹔閯隦 ?ဈຌ逢ࠂ Ĉ䈑ﻁᑄ鄄䄐쀀ȑӻꉏ鈄濫ﾀ耀ࠂ߰ 㿠聐∰怀៪⯾䪐耀ࠂ࿺訢ῄ釼䤟쀀?ﰢῄ釼䤟쀀ࠂ࿸䀿餪䢒▁ ࠂ࿺䒿롊銔ꄈ쀀Ȉ菺邯꺪ꪪ⮈耀Ȑ藻衂៦⌈䔶 ∾舻뺪鏴劭 "+CHR$(13)+"貘鿄Ǿ萡 ህ࿹吔㿤ᇼ䄟쀀'⒀Ꮐၾ䈡耀萒Ȁࢁ䀠㘰怀Бݺꐡ៬ᅄ䤐쀀Ё࿺䓿ꥋ着떊ꀀࠃ삁﹄鿥ᅼ鄤쀀∈迸蠈῀菾ᐸस臻ꨂ㿠设ꢻ萣ﱁῄᇼ∰怀Ⱦꨫﺩ⯎逤꺬  辠裻ࢫꊈࠄϰ萿ࠃﾂ ¹⩊뻘ꬪꬢ袢怀ࠊ˹䃟銥浪䪓ࠒ׻꩟銭豈䪴ꀀН⁋︒ޅᅄ庸  ߻呿镏瘝㾰䀀∈迸衿ꔯ粕쀀∈迹哿镏唢ꀀ ⩋㾠⯪謾耀⾈黸褯ꢂ₾怀﹔韧卼䒟쐑ﱑὅ凲銿ꀀ∈迸裿袃㸰耀∈迸裷꘯傾꒽Ȉꈩ绂ႄ℔䢜 ? 뾪䯲꒿怀Бࣸ戯鈬磻䘖怀벩⿪䫾⒏;ꂯꨯ䪔ꌫ 방࿥⭾犗йૻꨮ﫤꘮怀Бӻ訤ﭤ昖怀?ﱕ㿢褾팓 *ꚨ鿢࣮ꪪꀀᐅ࿰呿ᔏ禍▱ у큄ቆ錤劷 ਢ藸⪟銃厤耀	Ɂ჈ቄ酄劗 ࠪૻꪣ䮒⢊쀀⡋ﺨ뼪ꯢࢪ怀숑р꿩၄℉耀ࠂ໺ꪫ䪒쀀Ȁ迺꪿ꨪ甆 Ȑ藻꩟鈤濫 Ȉ菺꪿ꨪ甆✎ 쐓쑐韦錤儵耀∈迸顫Ⲥ鄤㘰怀ࠂ࿸衕⾢䇼䤟쀀	쨒ꈨ뿢䧒ꢊ쀀ࠒ䊣︪ῂꏾ∰怀젓ꉈ꟯䢒ꢪ쀀삃ﺪ螄᏾ᄙ쀀ࠂ࿸ࠢँ䀠㘰怀=뿪⫺ꀀ?ﺈꔪ⬆肠怀ऊ舁ﻉቇ襤儔䀀숀ﰢ࢏∰怀﹕៥兾䀀␭ɻ뻊䧼䤒쀀?␪Ȁ菾ࠂ ␭ɻ뻊䡈ﾈ耀︪骦ꢊ怀∅︔┥偐ᐿ∈迺ꠣ뼪ꯪꬫ =뷨䫺钩怀ĺ䫺꓉⭪⌾舧ࠂҐꠈ㿡ꂤ좂 ?ﱁῄᇼ∰怀ď䕻婞铧텞唗䀀ȼ觻풟번ꇼ࠿Ё߹䣟鵄﯈徜耀Ƚӻ븠课愯쀀>⢪⫺邧ꨪ袌怀␭ɻ뿄᧼䄟쀀ᐅ࿸偿ᕏ﨤怀Бݺꑿቅ凞䐽绐韦꥾䪒ꀀࠂ࿸偕┡᰸Бс﹀ဇ舠耀Бݺꑿ遇תּ羔ꀀ﹐꟮ꣾꪪꀀ'ሄ눤餀ꀧ#㸈늤ㄲꀧ'㸊럤ꤪꀧ绒韥⥮䘖怀Ȝ褣ﺪꪯ쥖逧씓﹒钩ﮔ䤔怀င舓︒ҏ∐耀绺꯯ꢾ廓怀⋏邅落䪔ꀀȜ꫻젯뺠ﯪ达ꀀȘꣻ젯뺢着⾾ꀀ?ﺈ꾪꫺꪿Ȑꗻ衟钧תּ徴ꀀࠓ쒃︈቉蠈జ ࠂ⿸ⁿ鈧濫羒 Ȑꗻ蠿貥תּ羔ꀀȈ꿸裿ꪯ着ﾊꀀȌ跹⫿銦רּ䢛ꀀᐿﱁ㿢釾鄉耀ᐿﱁ㿤鋺࠿ᐿﱁ㿤銢䪦ꀀЁ⟹၄ᄤㄈ贬 ᐿﱁ㿢⇼ꊏ耀씑⑁㿤ቄ褿Бݺ둒꟥⣾儢쀀∈迸蠈㿢⏾䄟쀀ਊ菹⋊鞥冔䚖 Ȉ菹ᓟ銅麗徐耀 ߹ʼꄣ₏쐑ѿȏ⤲  郿锯ꢊ﬋ ࠂ࿸䃿誇缂 ࠂ࿺ɿȇि	钮겊愈ﾀ耀ࠢ⿸葞੍ﾂ ࠢ⿸÷ꔯ穒 ࠂ࿺䂿ㅋ튌ꂯࠒӻ쉎邦䢳Ȑ藻鑟銍麗徰耀Б࿹⑁ᵉ剈ᘚ怀င࿸䀐࿂ᄄ䄃耀=ꔯ穒钭怀С׸ႄ០値劧 ဤ׸芞邡傧ࠂ࿸>ࢇ唢ꀀ࠺ӹ䊎뢪ꢻ鑇Ꙏ렩࠺ૻ슮ꢮꢫ∈迸蠐㿢þ䂠쀀∈迸裷ꔯ穒ﾂ ∈迹∕㇥ꄾꈧ퓗뙏礄徼䀀ࠂ࿹⋟銅⢤옜怀ȸ臻逄㧠䮢ꢸ쀀ᐟ앑ﱕ㿢⃸ᐿ 链ू䯲䜑 퐧빂竄⾼䀀Нࡻ뱉珐꒵?줒⽊勺芪ꀀо૳⩏甆ꪭ怀잀⃿䄠뀣ࠂ﹀ငĀ䀏ЉϹⓉῤ䥾䢔쀀 ⿩⩊뾠⯪袾怀Ȑ藻遄ᇤ䤢쀀Ȑ蓻큔ᗪ䯢䢐쀀ﺠ⯪誾⢋ࠂ࿹@࿀肔ꂧ耀Ȉ舢ﺨ⨊芠⠉?﹈ῥɾꂐ쀀쐓︢㿤銪䤦  Ṅ鵠臼࠿∈迸蠾࢏⤲ Ȉ菻鐿骇愈뾈耀﹀鿢ჼℏ쀀Ȑ觻퀤ᇯ䢢ꢨ쀀ȸ读邤⧮䪢ꢨ쀀࠺⯳ꂾ꣏꒯쀀ऺ䇻ꐏ㩁ﮘꪼꀀĎ赹狷锫祌锚怀;勿ࢃ㸰怀Йࢋ︢뺂靖⾼耀ȸ诺郄⯪譂邠쀀Ȁ긪ﺢ⢊⊔ 뺸误袾䔦 Љɋ鐦ं䆒ꒉਊꏹⓉῤⅾ䔖 Ā䀘ԁ⁀င 쒑ﱉ㿪ꧼ࠿਒ꗻꑉ៦⍾䔶 ∈舣ᢧ⚨ꈈ耀ࠊૻ⥃厈☎怀ȸ读袿꩏⪼ꈿȆ軸ꋿ誧㊰ㆋ耀뼢䫒Ⓙ∈辠黺꒢䯲ₘ쀀#쒐⒑送䘦怀=щꊯ꠆䢣﹒ᒥ龜ﺨꯪ勾┎怀ࠂ࿸ꡝ⪢⏾∰耀ࠂ࿸“઄鋺ࠂ ?鴪꒿怀舠蠲ં₊䊠萒晴ࢇ唿Ё࿺䓿ꩍ뾡 Ё࿺䓿굍ꣾ悯Ё࿺䓿ꪭ剼説Ё࿺䓿ꑋ덖餤䀀﹒韤ⅾȐ蓻졒៪⎘䬔ꀀȀ軺袢㿪⊘ꀀࠊ˻᥇劈꘎怀䀟ﲩ੏襤䤟쀀뺪ꯪ⊾ȏ븨鯦諾ꔊ ∈迸衿၏ﾒ䀀Կ뺨꯮諾ꔮ Љϻ鈤馆ꊨ늈Ȝ裻킯븪ﯢྪ 젪᫦ꋨꨋҜ䣻븪﯂ࢩ怀ᄔ䗓ᕆ팞䤜䀀ࠂ︒҅㉊∉耀㻀Ꮴⅾ䔖 쀐Тࢁ䀠㘰怀Ȑ蟻ࡂ៦⌘䬴ꀀࠂ࿸ ῀聨⤲ Ƞ藸ࢂ០‘䬤ꀀࠢӸ䀏낄䤾ꀧ⋏鉅䦊䰐쀀∈迸裿ꪭ直磌Ё࿺䓿굍꫾ꂏ?䀟ࡂᄄ䈃 싲꒿ꪫ瘝☎怀ԡ䗸ᒟ邁垤 '연䒿骣丬怀ᐅ࿸裿ꔯ᰸Ȁ軺袢⿪⊘ꀀࠂ߰ 㿠聨⤲ ℐ俺꓿꩏륔傧ɿ逄Ă䂏Бݺ듣辂⏾∰怀ꪯꪪꪾ切耀ࠂ࿺䉅⨣䤟쀀ࠂ࿺≕⾤釼ࢿȠ藸႟銡‾䔦 ∈迸裿袃䘜怀캈뻰௦ወ⢋ꀀ<짃욞┯剘锭 Ȑ萣钊揂䌓 逧뼂称ꒉ쐑ѿᄇ蘿䊼怀;ꊯ꩎瘝ꢻꀀнǸꓦ๦䋾⒚쀀ሿﱕᕏ琢జ  ߻呿镏唢ꀀࠄȣﱈ鿈菾ࠂ 聀⃿舡邨젆 삃ﺪ뷂课撪쀀ȹó๊甆몱怀Ȉ菻耯騦愈ꪍꀀ៪设墒怀Ȑ蓻阪ﮪ夓 ?諸ྂ⏾∰怀ࠂð䑢Ԁ킇舑婢㷩䩒 廴ꔩ篒ࢂ怀=뷠觼唿Ȥ꒰ࠟ놄ꥊꀧНࡻ㲂窲Ⓗȁ໲꒯⩊廒怀퉟钊ﮈ刓Љ੃⦃䎐⒉Ƞꗸ䢞钡ꪢ 萣ﱉቇ⒱ȉ˻騦﫪ꮈ耀ȑࣻ鈯ꮨ耀︪銯ꪫ?ﺢ꾪⫺ꊿ䀗绪鎮꫾性ԗ빈鏦譾䔶 ԏ븨鯦諾ꔎ ∈迸ꠉῤ䄔蘦怀ࠂ࿹Џ㸰怀쀠ჿ與唿잀䱼ѡႇࢯ袆着⪷ࠂ࿹@ῢჼℏ쀀퉟꒯勒횔怀濠裳讏㢸犨∈迸裿ꐦ큘 Ğ䑹꺨竪ꪮࠂ︈܂ꄤ袂 ʾꪣﺪ㺂叢% 쐑ﱁ၇䄟쀀ࠂ࿸栩㈧࠿ Ϲ⩊꒩䢒䢄쀀च蠃ﺕ㵉ﯔꔶ䀀ं₃︈́䁒⒱?﹀鿤䋾訜怀투붢妢ꢈ쀀਒迹⡿ࢃ㸰怀=뷨ੲ钧怀=뷨訒톧ꀀȐ裻숤酏傈꘮怀=뷨ਂ肠怀 Ϲቔꈨ졊℁耀ࠂʰ됹㩂날₏С҈䈟老傧ࠂ࿸ꀯ銭ঔ䘖怀"+CHR$(13)+"貘僿ꔯ剒쀀?풖㵉䩒 ?뺢⯌∽耀йɀ뻲₎냊∱耀 ϱ₈㿠聐∰怀籑ᑅㅀ邧좐␑逍䘖怀ࠒࣻ술鄯⢂남쀀∈迸₾飃㸲怀;ꈏ멀鎤낸 ?楊直诣銾ꤿȐ蓻젯ꢋ ꨪ骦ꫪꮊ耀∈迺ꡳ꬯ꤪ猣 Ș觻꩏뷅䭞堹	슊⮪ꪺ⪊ꀀ萓㵉〠ꄯꀀȠ萠纒钡劧ࠂ߻䑾늧ꤢꔯꀀ9삋㮠ꮺꪺꀀ	쾈黸⮯ꪺ慠ꀀЁ仺꒿ꩊ瘝Ȉ菹ჄᏥ覢䢓糑ῥ⦤䘖怀聁ﱉῄ鏾Ⴘ쀀င࿸䀟ࡂ鄨蘎怀ࠂ࿺䋿衇㼈䀀ࠂફ㊪Ꙫ꯾袿Љջ摕ᖄ颐ꄧꀀ?㿪ꦜ᰸빀៦謾墰 ࠂ࿸䀿ᡋ㼈䀀Ȉ舣︪骦﫪ꪋ'쐠纔韡䣾袬쀀'쐠纔韡䡾咥怀ई诹⢿誦꫞₷䨄꾩建⪊ꍨ贾 ࠂ﹈鈧濫䢟Ȑ藻逤௤譢梓䒋쀓थ茾梓;︋㲠ꢼ쀀ሤ蟸则㯤酬ꀧ萣ﲉ≏肿?禎㾥⯺ጿ耀Б俹⑟ꉊ䤿Ⱦ耣ﺊ뺪ﭨꪫࠂø䈐詀倈జ 耠ဈ㿠蠤ࠆ ȡҾ舏䤦  ϰ耿Oȏ ᄒ艃﹉⾠Ǽ䄟쀀࠲毫꺜뫩䯾䄠 ?뻸韦褾䔶 Ȉ菹䫟钥寧侒ꀀЉт㹔褢䤢邼쀀擣졒៪⏈䔖 ࠂ࿺劢靂⇼ꊏ耀Ё߹ቿ鄫朗㾉 쒓뱉Ꮶ荾䪵怀葟邍龜劷Б߻䡯镎秴䴵湊믫銾슓ﰩ᯦苾ꪍ怀ई菻蠯领響ꬍꀀढ萀纂០ 徠耀Ƞ藸咈闀衾䢣Ȉ诺钨跄襾ꢣ﹈鈧濫袢怀ࠂ࿺剳ȇﾕ䀀℈聃︈῀耠ﾂ 橊똤뿥ⅾ鈧ሄ迸ꣿ讂Ͼ⨲怀∈迸⃿ꢥ탸振ꀀ?ﱕᕏ㰰;萏뢀ﮈꪻ?绺诫ꪾꪾꀀ'П낄ꤾꀧ;쪒볉⯪荾誥怀∉࿸⃿袇瘝☼怀Еࣹ쫚ᕇ袐ꄧꀀ쩒钧⭚宰耀Еࣸ⩢ꒀꏈ锾  无ࢂ០ 䔦 "+CHR$(34)+"䔈ሡ>䢣=䪔豠臼∿=剿቏ﾐ䀀Ƞ藸䊏邀련踬怀?︥Ꮿ邾꤫ﺪ꯯傾⨾ꀀ︒迤⍾昒ꀀࠂ߰⁉એ⤲ ∈迸⃿鉂ꏾ⤲ 뻸꯯袾甪 삃ﺪ鿄釼䤟쀀#咃ᄠ䢣퐣ᄯꢫ∈迹࠯⑄ꁼ冧쀀=퓓⴩篲钽踠裺࢏ꈪ誾"+CHR$(13)+"勖ꕫ䭒ᖙ ࠢ⿹ѿᕅ凲銿ꀀ鿦ꪺ떉 ȯ蚸餃ꪯ∈迺郷ꐏ凜唿∈迸裷ꔯ禍鲪н੻뽄ᇼᒹ⸨諺袣⦪ꂈ怀ࠂ࿸ⁿቇᠹ?ﺤ㏩褾팓 ࠂ࿸ꡉ⾠䏾ࠆ >ꈫꩠ菾⨲怀繒뿤ⅾЁ࿹告뿤䅾ꀀЁ߻z뒧뢥怀ࠂ࿹⑿቏옜怀︒迤⍾戗쒑ﱉ῀臼࠿␉俹咧뽂篴ꔭȸ诺裟ꥋꬼ舧Ȑ觸ਿ邭龜徐耀ࠂ࿹␐ᝈ课ࠂ ࠂ࿸"+CHR$(34)+"ࢂₐп∈迸詟ꂢ龜耀Ȑ藻聏鈦﬈䪵ꀀЁ࿺ꊭ㻊䪾7ꢫ樦麩⯲咿怀С׸ႉ០T唥怀&䪔韡⡾劧Ё࿹၉㿤Ŕ怀;䪤뿤釼䤟쀀ȸ藹ႈ뿪ʪꪼꀀЉ௺耩㹂醨ꈏ9铊⯫⌾舧ࠂ࿸蠢㿤釼䢃䀑黸臯䉞⋏鄅壟傗ข࿺銿ꥋ傧ꀀБ࿹⡂鶩퉔ᒙ ข߹剟镇晴袌쀀?ࠌȀ耠ࠎ ࠂ࿸蠾禍␱Ȉ菹哏阦龜䪕ꀀ?ﺈꪪ꫺肠怀Ƞ藸࠿芃砤䘦怀ࠂ࿺⋿镊⣸䤦 	䨲ꐥ㱂ᦜ뤈䀀'쑐嚉ᓀ菾⨲怀Ƞ藸鈠䪥ꀀऊ訁粥࿆勼⒱ Ё߻ࡿ땆餼鈩ꀀȸ读钯긮愈ꪽꀀȌ跹ࣿ銇笤䘖怀︪뿢ꦾꈏࠂ߱ѿ၇䘼怀ȸ臻耏먠ﮈꪽꀀȠ蟸吩독↚ꀧ쐓﹉ῄ釼࠿ȸ诺裟ꪋ笤蘦怀︈뿤襾攖 ࠂ︈舡ࡂ₱쀀젓밡Ꮿ⢬늩ꀀ숉绀៤꥾䪒ꀀ繒韥⩾舏Ȉ舣︢ᦆ닊ꈈ耀Ȥ蔠ﺒᖃ끊判耀Ȋꪲﺢ஦륪螦 Ă云繉㫅턦䀀Ёེ닷ꐏ着廙	쾈뻰⯯ꪾ慠ꀀȺꪲﻂ⮪뭪螦 ꢳﺪ㾪믪ު ∊꾢黺⮯몪랶 >䫴韥⥾쒑ﱉ㿢ꍶ࠿'纐韡⁾䔦 쒑ﱉῂ䯾⨲怀+﹨꯯袾攦 舑ʿࢂ쀀	슉䃟逅裸䒑怀┪檪ꪭꨪ邸怀!쒈䀟者裸蒡怀Ⱦ蠣ﺢ꺪ꪲ䢖쀀ࠢ⿹䢏븠课唖 	슊삯ꠋ朗⒉怀캉䁟렅裸怀Ȉ舣ࢇ⊪⊈∈迸蠞ࡇ梅ᄅ쀀좋쀯밂㮝Ⓗ怀∈迸諿肯ꬭꀀ삃ﺪꞢᇾ褂쀀삃ﺪꈧ唿=ῤꧾꈮ 쮊胿鐊ﭪꪾ쀀?ﺪ뿊ዼꄏ쀀?ﺳ㖨芼⠿?∨ꪩ꠪႘怀ࠂҒ戆㸀臾Ⴘ쀀>ꈨꨡ᠀唢ꀀ>ꈩ萯옜怀Ё߹⩿銫﨨⬒ꀀࠂ࿸偕⤠肔ꂧ耀Ȋꊲﺢ⮪뫪➎ Ȩ藸⪏骣뀳Ȉ诺ꪯ誥落説ꀀБݺꑿ銧廊鬪ꀀȐ觻ꨯ銯ꪬꀀ=⪒⿪ꎪ뮊耀∈迹䨟뒧龜ꀧȠ蟸䨟뒧龜ꀧȘ觻ꨯ뺢滛⪼ꀀ숐萿ȇ車䂟쐣ﱉ῅勺䄟쀀	슓︪鯧劾ꢋ뺨訥鸞逤 =풓┯耞咥=哳फ芞꒿삃ﺪ鷉诜경ᄒ艃ﺈ與ℱ耀ࠂ߱⓿鉏㸰怀ࠂ࿺ꪺ꫋ꪊꬭ耀?ﰈ㿡⏾∰耀䀑廴ꔯ窒钺怀Ȋꊣ︦ᪧ瘝꜎ ࠒ쩟ᒭ圖耀Ƞ蓸⊏鈠䤣 '纒១⡚ꮨꀀࠂ࿺⊨迄菾ࠂ Ȉ諹⊯訦着⤳ Бݺꡕ㿤釼䢃ࠂ߸␊㿡ü傇∈边⣿鈯㾰䀀ࢉℓﺪ꯯ꢾ⪼ꀀ ⫻⊯ꩊ謽耀ࠂ︀ႄ䂠 ∈迹哿ꔯ愈꺜쐓밡࿥⬬劙ꀀȼ褣ﺒ꒯䩒邬쀀젓밡㿢꫌⪽ꀀ;섋븀㿠꯾ꪺꀀ绊ᒧ襤东怀๸鋼褣䦲ꒉ8惣蠏뢀ﮢꢻ?ꡉ㿠脼䠿ȸ读邯긮꾪 й௻銤꩏着ꪭ怀Ё⿸ࡺ鉇ꢐꄧꀀЉ˳퐥ᩦ⋾ꈈ耀∈꿹䡵⩣羪ꀀ?砢ຄ⇐п?ྂ⃸?ﺨ㿪䏾ࢨ쀀йǻ숟㤀篰꒹∈迸僿꾠菾⨲怀∈迸裿딊ﯪꔮ Љϻ舻骧ꪮꨌС߸ꪒ០聾傠쀀й׹䊛몫ꪮ꨼й௻芻ꪯꪮꨬ"
    KNJLIB_FONTDAT$[3]=""
  ENDIF

  ' ……………………………………………………………………………………………………………

  ' 5:M+ BITMAP FONTS 12
  IF FONT%==5 THEN
    GKNJDEFINIT 12,13
    KNJLIB_FONTDAT$[0]="     ࠠ興 Ņᑐ   ᓹ䔔聾 Ả蜊⯂ ⡈䈐邡 ⒑蒪鉆耀ࠠ   BࡁА䂂ЀĂࠐ䄄ႂက ࢩ순ꢀ   辈     ⇂က  ྀ     ⇂  舐䈈䄈 ⊊檲訧 ᢠ興₂ ⊈℈䈏耀舐蜂ਧ ౑䤤 ꂃ삂訧 ႃ좢訧 舐䈈䄄 ⊉䈔訧 ⊊⢞ࡆ  !숀⇂  !숀⇂က 萡ࠐ⁀耀   ဠ䂄℈ ⊈℈  ⊺ꪪ먇 ࡑ䔾訨耀⊊⼢訯 ⊂ࠠ舧 ⒊⢢詎 ꂂ༠舏耀ꂂ༠興 ⊂஢訧耀ꊊ⾢訨耀ࠠ興₇  興₢訧 ꒣న鈨耀₂ࠠ舏耀뚪⢢訨耀늪梢訨耀⊊⢢訧 ⊊⼠興 ⊊⢢訧Ќ⊊⼨鈨耀⊂܂ਧ 蠠興₂ ꊊ⢢訧 ꊊ└傂 "+CHR$(10)+"ꪪꪪ充 ꉑ䈔刨耀ꉑ䈈₂ 舐䈐䈏耀Ǆ၁А䄄ᰀꉑ侈 ǁА䄄၁ᰀ∀       㸀Ąࠠ    삞訧耀₃좢訯  좠舧  舉訧耀 좾舧 蠠辈₂  觠ꉰ₂첢訨耀興₇ @ 섄၁Ӡ₂䨰ꉈ耀ࠠ興₃  쪪ꪪ耀 첢訨耀 좢訧  좢诈₀ 觠興 철興  좜ਧ ၃쐐䄣  ⢢試耀 ⢔傂  ꪪꥅ  ┈ⅈ耀 ⢢觠ꉰ 䈏耀bࠠ谈₂؀ࠠ興₂ࠀ̂ࠠ膈₂　耀      扉᠀âࠠ興    興₂㠀   က  ̌  舋ࡂက やက ℌ剁Ѐ  辢衂က ₏耀 侄ㅉఀ A޲⣂ࠀ 섄၏耀 ࠯耀 ꪪࡂက ހ  興ꊌ₄က 舐䌔遁Ѐ㺊⢂၂ࠀ蠠興₏耀A㼐쌔剉ఀ㸨ꊒ䨨谀㸠舾၁Ѐć鉊⢂၂ࠀĄὒ䤄၂ࠀ興₂࠯耀Ĥ뽉⒂၂ࠀĂ၂　А䈈先ꈀĄᙫ⒔億฀ꊉ⒂၂ࠀć鉊ꦂ၂ࠀnࠣ₄က"+CHR$(10)+"ꪪꂂ၂ࠀǠ၂ࠀĄ၁蔒䄄ကAӼ䄄၂ࠀ耀 耀興⒌Ⴄက㸈䌚ꒂࠀ 興䄄₄ကąᑑ䒒訨ꈀȈ⊒谠興Ḁ興₂၂ࠀᡑ䤤蠠舀㸠說ꪢࠀ興└₁ЀƁ老膀؀ࠡА䨨븀Aґ䈈儨 遃䄃耀Ąᛩ⒊もࠀА䄄၏耀興⾂࠯耀ǀ၂ࠀȨꊊ⢂၂ࠀ⢢訨ꊚ가Ȉ₂ࢢ鉊　ꊊ⢢訯耀ꊊ₂၂ࠀက၂　脈က   扉᠀   䥂"
    KNJLIB_FONTDAT$[1]="                 @Ȁ       〄聈̀       0؀       0      À       ఀ쀀 ఀ쀀     ఀ쀀 ఀ쀘   Ȉဂ@Ѐ   䀄@Ѐ䀄@   င耠        〄聈̀       Ѐ耀        ࠀ䀀        ᦁ頀        Ѐꀑ        ￰                 ࿿   Āࠀ䀄 Ȁ    ࠂ䈐က耈@Ѐ     Ѐ ༀ    ࠂ䄐ࠀ䀄 Ḁ     ऀ递Ġሀ    Ȉ䁈ȿ聀Ѐ䀄߼  Āᾂࠠ耐਀䀂    䀈ᴂ⁅҈偆@   ̘䁈ʀ⠂䁃᠎     ?쀀        ÿ              Ȁ䀈Ā ဂ@ࠀ @Ȁက耄 Āࠀ䀂    聄䀸    ਀ꀊ ਀ꀊ ਀ꀊ ਀Ѐ䀄@Ѐ䀄@Ѐ䀄@Ѐ    f晦        1茘    À᠁耀       〃`        ۀ耀       㘃恬        @ࠁȀ  Ȁခ@䀂Āࠀ耈ࠁȀ䀀@ࠁĀခĀခ@䀂ĀခĀခȀ䀀π  Ȁ  Ȁ  π砀耈ࠀ耈ࠀ耈砀ÀခĀဆĀခÀ态ĀခĀခĀ怀 Ѐ䀈ခࠀ䀄 @Ȁ Ā @Ѐ  ሁ․ɀ䠄聈ɀ␁‒ 	Ҁ䠂䀤ɀ䠄肐ऀ π  Ȁ          耈ࠀ耈砀࿀萋삠਀ꀊ ฀      ฀ꀊ ਀ꁺР縀π㠃0Ȁ  Ȁ〃8π砃耘ƀࠀ耈ࠁ耘΀砀 @Ѐ䁿쁀Ѐ䀄      쀀     @Ѓ@Ѐ?耀   Ȉᄀꀄ ᄂࠀ   àЀ쀀Ѐ     ﰀ 翀     ćﰄ翂@    쀰ఃÀ̀ఀ　쀀  `ƀ؀᠀怘؁聠   샠瀀쀀翀쀀  pàǀ 翀쀀    ㆄꒄ⡂䩃᠀   àЀ Ȉ燂ࠀ   쀌ŀ␼䑀䐄䀸   Đᄀ@㾀䀄  HҀ　       Ѐ       ․Ҁ       〄聈̸р耈ࠀ䐃耀 ࠠ脐ᄃ@㾀䀄   䀟Ɉ␁聈⒁   ࠀ聰ঁ‒Ġಀ瀈  瀈肀ࠇ΀䠄쐳耀 ၉Ҡ䨃䀅肤ੁ␑耀  选㿀选ϼऀ选   쀒Ġሀ舨ℂ⠜䀀  䀤腐ก値聀     艤䥄鑉䒔➃  กထกထàȁထà Ѐ䀊 ﯢࠑŐ⪃ᡀ䀀 Ѐ䀎à￣ǰ㮃ᡀ䀀  怙舄⁄ɀ∄⁁順   怟菼㿇ﹿ㿁   怙舄♄鉉≤⁁順   䀊Đ₄Ҁ␄₁ည@  䀎ǰ㾇ﳿ㾁@  쐄䁄р䐄䁄ѿ쀀  쟼翇ﱿ쟼翇ﱿ쀀   ਁထȈ₄ѿ쀀  àกϸ㾇ﱿ쀀  쐄₂ࠑĐ਀ꀄ   쟼㾃ǰ฀   䁎䉈ᄄꓤᄂ䡎䁀 ﰀ ﰄ@Ѐ䀄   ӿဂ   Ā ÿ    䀎Ő⒄䐄@Ѐ䀄@  䀄@Ѐ䀄ф⒁倎@   ߼翇ﰀ߼翇ﰀ    Ǽ 쐀 ﰀ    ߰ѿ쀄   숀䀄 Ǽ 쀀  @Ѐ蟰 쀀   Ǽ @Ѐ ﰀ    ߰Ѐ䀄    興₂ࠠ興₁ဎ   Đ₂ࠠ興₂ࠠ耀  䀄 ਁထȈ₄р䀀 р䈈₁ထ ਀䀄      쀄@     ﰀ⿼က    Đ₇ﲀ⟼₁က  р䈈㾁ထ ਀䀄  耈耈࠿耀   耐Ȁ䀈Ā ﰀ   @Ѐ䀄@Їﰀ  ἆಀ         ࠎ脐ℂ“   쟼ゃ࠙Ɛ਀    ߼ 쀀ﰀ  8Āﰀ߼ ဃ耐  䂈ᄂ⁄Ƞᄀ蠄䀀  р∁ဈ脐∄䂈  Ϡ @Є䁈઀ꠁ    Ș䉈䊄⒄む     ̘䩈䂄Ҥㆀ     蜜₀ @฀䀀  Ѐꀈࠀ䀄 Ȁ @ ᦂꠢȠ∁ထࢀ蠪茰 ؀选`ЀꀊĐἂࠠ耀 ₒी鐆耎솒ᤢ鈦쀀  选༃选샰㤀选  Āᘁ逑Đሁ䀘   䀆PҀ䠅@ᰃ쀸  Ѐ䀟@ЀàЀ䀄@ Ѐ䀟@฀䀄àЁ@  ϐ㴁퀍PԀ倅   萄䁈ʀ⠂䁄б胠  Ȉ₂ࠠ興₁ဎ   䀌ŀ␀䀄@Ѐ䀄   Ȉဂ@ࠁ?耀  Ѐ₁ဎ   怊 ሁ•Ƞ羀   Ȁ⸃က耈သ   Ȁ⸃ဠ興₁ဎ  耐Ā @Ѐ耈   ȈᄀȈ₁ဎ   Ȉ₂ࠑ胨သ   䀄 ਁထϸ₄р䀀 興₃舄⁂࠿   䈀  Ȁ Џ耀 興⁂Р䈄₂ᠾ  Ȁ Ȁ ?耀 Ȁ Ȁ     䈀 㰠䈄⁁ఏ䀀 Р䈄⁃ﰠ䈄⁂Р䀀  䀄@Ѐ䀄@Ѐ䀄   ခĀ၁А䄂“  ࠡȠ␂耴Ƞℂࠠ䀀  Ȁ  Ȁ ?耀 Ѡ씔䩄䑀䐄䁄р䀀 ࠰芈⒂⠡興₂ࠠ耀  舄⁂Р䈄⁁ࠏ  Ȉ₂ှȀ     舄⁂Р䈄⁁ࠏ ǀȈ₂ှȐℂࠠ耀  舄က耄⁁ࠏ  ﰄ@Ѐ䀄@Ѐ䀄  ࠠ興₂ࠠ興₁ဎ  ࠠ興ᄁထ ਀䀄  䑄䑄䑂꠪芨ᄁထ  ࠠ脐਀䀄 ᄂࠠ耀 ࠠ脐ᄀꀊ@Ѐ䀄  耐Ȁ䀈Ā ?耀    ༀࠇ膈ႁ᠎耀 Āᘁ逐脈ႁ逖     ܀蠐Āက蠇   ࠀ耈ڀ預脈ႀ順耀    ؀逐臸က蠇   㠄@Ё@Ѐ䀄     ڀ預脈ঀ栀耐฀Āᘁ逐脈ႁࠐ耀  䀄  䀄@Ѐ䀄        Ȁ @㠀Āႁဒŀሁတ耀  䀄@Ѐ䀄@Ѐ䀄     妆摄䑄䑄䑄䀀    ᜁ蠐脈ႁࠐ耀    กဠ興₁ဎ     ᘁ逐脈ႁ逖Āက   ڀ預脈ႀ順耈   ᘁ逐Āခ     ༁ࠐðࠏ   耈㼀耈ࠀ蠇     ႁࠐ脈ႁ᠎耀    ₂ࠑĐ਀ꀄ     䑄䑄䊨⪁ထ     ₁ည@ਁဠ耀    ႁࠈ肐Ԁ @᠀   ᾀဂ@ࠁ耀    Ѓð᪂꠬膐  䀄쟰ࠀ䊒䨤숴䀘    အȈ₂䠘    Ȁ₄р䐂䈢䀘     ఀ　pᢀࠁ` 쀃 ฃက耈ဆƀ    ఀ　ǰȀ䀊Ę  쀃 㼀ဂ@ఁ•М    ࠀ蠾䂀ἂ蠨茰  耈쟢ࠀ耏膄⠤艈䌘 脈籁␒∢∄⁂ǀ Б℈簁␒䈢∤⁂ǀ  䀅蟠χǨↂð @刄蟠χǨↂð   Ѐ耐Āఀ   DडࠠȀ᠀䀂  ࠠ興俤ࡀ萈䂄ࠡɠ  ᑁ␘齈ႁࠐ脈၂Ӏ  耀  Ā П耀  ?䀂ЀȀ䀄࠿    ,缀ခǨↂð  萉⃨䀂ϐ䌄 Ǡ  ࠁĀ၁Ј聰  脤ᄂ Ȁ₂ࠑà   ࿾ȀĠ฀ ƀ   ࿾Ȁℨเ ƀ  ࠐ脈Ꮷ점脈ᎁü  အ䈒➏鐡Ȑ✂ Ǹ  耐Ȁ䁿ࠀ耈x  >䀲Ҁ胿삀ခð ߸ခ㰐Ƞ␂䁃 Aሐ蟰ခ㰐Ƞ␂䁃  䀄^縀耗ƈ@Ѐ胰 @鈈胰.̐ࠁǠ     ̐ࠁà   ð炀Ѐ䀄〜  @ሀ胰炀Ѐ䀄〜    ü䀈ࠀ耄8   ü䐉₈ࠀ耄8  耈Ѐ砌Ā ø ␑ĀࠀȀ䀄 ǰ  耈쿢ခࠠ興䞄谈ꁰ   ȼ䀄@Р䐄䀣   Ƞ⾃␢╂喤꘲䀚 Ā玁䐘ℂㆥ☒䄚   øᑂ䉄⒂䠣Ё耀  ࠠ興俤ࡀ萈䞄谨ꉰ  ᑁ␘齈ႁࠐ載ᡑ䓠  ు␒鿈ႁࠐ載ᡑ䓠  yႂఠꐈ䄄ဢǀ  ѹ₈ဂࠠ쐊䄄ဢǀ  ౹ₒჂਠ萈䄄ဢǀ  Ȁ䀤䉄∤≂⃀  П‘ɀ䀤Ʉ≄≂⃀  ట‒ˀ䀤Ʉ≄≂⃀    聄ࠠƀ؀    耤ă聄ࠠƀ؀   耤Ƀ顄ࠠƀ؀   /䂄﹀萈䞄谨ꉰ  џ␘脉ﲁࠐ載ᡑ䓠  ౟␒臉ࠐ載ᡑ䓠   ߼ȃﰂ Ḃ㠢䇀  |HҀ䠿蒌袩ࡡ`  耈߬ࠠ耸Ҁ䡃萈䁸   Ƞ⾁␲╂䰤舰䀘  耈߸ࠀ聿脀၁Ј聰    ȁ‗Ψࢀ逄@  ထĜᜡ鉨⁌Ѐ䀂     Ȃ‧芔ㅁ砑   ခѼ䤥ቑ−⟂ခ`    Ȁ 耠ก〒胀  䀄@ހ䀄@㰄灄莀  쀃  'Έ@Ё胠  脈ႁࠐ腈ࢀࠁ`  耐Ȁ瀘舄ు␒胰 Ā玁䐘䄄ゅࠐ脆  耐Ȁ瀘舄@Ё胠    ࠀ耻Èࢁ蠨肰 Ā玁䐘ℂ〥Ȑ䄘  > ΁쐤⑂䣤鈱‌ ﰁ ྃЎ䄘ἀ耹쑢  耈߸ခ쀢쑰䨁‐ø  @ࠀ耖Ɛℂቁ␌    聈Ԁ䀈Ā  @䠄@Ѐ䀈̀     ࠁ`ᨀ     䀈Ā怚ؠȀ      Ѐ䀿興₀ࠁà  䀄߼䁄р䀈ဆƀ    @Ѐ䀿耀   ߼Ѐ䀄@Ѐ䃿    Ȁ‿耠؀ꀲ`  ခ翠ဃPᤆခp  䀄@翠䈄⁂ࠠ舐☜ @鈈肀￀萈䂄၁Р䰸  䀄@翀䀄@翠    萉₈＀耈￀䀄@  䀄|ࡁР䀈ဆ΀ @鈈胸ႂࡀ耐Ā‌܀ Āῢ၁Ȁ‌̀ Bሠ舀㿄₂ Ѐ䀘؀   ߼@Ѐ䀄@ѿ쀄 @∁߼@Ѐ䀄@ѿ쀄 ࠐ脈翡ࠐ脈Āဆƀ ᐡ∘ｂအȐȀ‌̀  0À&Ș䀄ဆ΀ @ሰ胀&Ș䀄ဆ΀  ?耈ࠁ̀䠘䘂 ɀቿĀဂ ؀逰谄  耈ଡ쓨䂈ࠀ耈~ @鈈肎ଡ쓨䂈ࠀ耈~  @䐄⁂Ѐ䀈ဆƀ @ኀ蠀䂄ࠀ耐Ā‌̀  䀄|ࡁЦ䀘ဆ΀ @鈈胸ႂࡌ耰Ā‌܀  쟀Ѐ䃿Ѐ䀈̀  Ѓ⟈Ѐ䃿Ѐ䀈̀    䠤艈Āဆƀ  H䒄⑂䐀䀈ဆƀ @ነ褀䢄蠀耐Ā‌̀  ?쀀︂ Ȁ ƀ @ቾ耀ﰄ@Ѐ䀈̀ Āခ쀓ČခĀ ࠢ䈐 耦Ș  Ȁ    翠  Ѐ䀈̀   ϼ      ?쀄@蠄耰Ā⠌䜀  䀄߸ဂ`ᶎ䘄@   耈ࠀ耐Ā‌̀  ĈႁР䈄․ɀ␂  Ё℈ခ興⁂р␂  ఁℒჁ興⁂р␂  Ȁ⇃Ȁ  Ǽ  С∈ ᰾Ȁ  Ǽ  ు␒䃄恸Ѐ䀄@ϸ  쀄@Ѐ䀈ဆ΀ @∁࿸ࠀ耐Ā‌̀ Àዿ‌ࠀ耐Ā‌̀    ᰂ⁁ࠈ@Ȁ   Ё 쀢А肀Ѐ   ఁ‒Á쀢А肀Ѐ   䀄@￠䀄Ɉ䑈䈄À @刄聀￠䀄Ɉ䑈䈄À  䰅⁒￀䀄Ɉ䑈䈄À   ߾ Ѐ脐਀䀂  8 0 <8  耈ࠁ脈₂瓸䀄  ခăဎ8ɠ䀘؀  肀ࠀ胿ࠀ耈x    ࠀ耋菈ऀ倄@ ĜṎ萈肈ࠀ䀄@     Ȁⁿ耀   ϰĀခĀჿ    耈ᾀࠀ臸  ?쀄@п쀄@п쀄  ?耀ﰀ䀄ဆƀ ࠠ興₂ࠠ耈ĀဂÀ  ‒Ġሁ‒™≂⑂萰   Ȁ  Ȅ₂ဦ΀   ߼䁄р䐄䁄ѿ쐄    興ࠁà  쐄䁄Ѐ䀈ဆƀ  ခ㿁ထĐ翠ခ   ϼဆ@Ѐ䁿  ?쀄Cﰀ䀈ဆƀ  0À Ȁ䀄ဆ΀ @刄蟼䁄р䀈ဆƀ    ࠀ耿肈ࢀ蠐脰    ခ舠∀ ƀ 쀄 ਁထǰ₂ࣱ 脈ႁ脄၁ࡿ  ﰈ䂄ࠀ耈ࠀ耾   䀄 ਁထȈ₄ѿ쀀 ﰈ䂀ऀࡀ萿쀀 舐Ȁ䀈Ā₂࠿耀 鸐脈ႁ脈ႁࡹ 䐂傥祖ꐂ䀢П耀 @Ѐ䀄@Ѐ䀟  鸐脐ሁ䀜Ġᄁࡹ 쀄 ਁထĐ₂ࣱ ḱ茘⪂꠪艈⒂䣱 鸘腈ᒁ⠒脘ᆁࡸ耀 ︠䀀ႁ 䂈ჿ  萄䁄р䐄䁂ࠟ  ﰐ脈ႁࠐ脈ႁࡹ 脄၁ࠟĀခx  肈Ѐ ႂ࠿耈 ﱄ䑄Ѐ䀄@Ѐ䀟  ᡊ䡂Ѐ䀄@Ѐ䀟  ǰ⒄䑄䉈ἀ䀟  밑Đ਀䀄 ᄁၻ쀀 ф꒢䠤臰Ѐ䀟   舄⁂Р䄈ं鐹쀀    ృ⠡А䈄怹耀  〄肈ઁတ脈⢂瀠Ȁ    ㆀꐄ@ࠀ耐Ā  怉肀ЀꀑȐℂ“    xࡀ耇Àခࠏ   耑腠ࠁ Ȁ᠀态à   ̰ಀ蠐脐ℂ    〄肈ࢁࠟ脈ᄁဒÀ   ࠀ耐Ĉ₂သ    Čऀꀌŀሂ⠡  쀂 ȀȠ℄၀쀀   ࡀ蠈脐ጁ퀠숀   ぀蠈肐ᄁ“   砈øခȀḀခà   pᢁࠠ興ℂ〜    㾀选Ġቂ䑃耀   8ీ萐䄈ㆂȀ   ⃼㄂၁А䈄怸    㾀䀄ࡀ蠇    ࡀ萐脈ℂ“    ðᒂ䠤艈━   Äኀ。 ؀ꈒ䈘  ခ 戡␔䉈⒁   ၁␢䉄⑂䠛  쀄 ਁထǰ₂ࣱ 脄ခ脄၁ࡿ  脈ႁ脄၁ࡿ  ﰈ䂄ࠀ耈ࠀ耼  ﰈ肈ࢀ蠈脈ႃ䐂 ĈሁĀ၁ࡿ耀 ㆀ脈၁„Ġအѿ쀀 䩊⒁Ɉ⒄䓟怀 舄　耄⁃࠯  鸑脨ኁ䠔膈ᢁࡱ ऀ恰ᆁ⠒腈ᒁ衹 谑ℐሁ䀜Ġᄁࡹ ︄聈Ҁ䠄葈䒄蠱 ᰑĐ⪂꠪艈⒂䣱 鸐脈ႁ脈ႁࡹ 萄䁄р䐄䁂ࠟ  ﰐ脈ႁࠐ脈ႁࡹ 脄၁ࠟĀခx   숄  Ȁ⁁ఏ  ﱄ䑄萠䀄@Ѐ䀟  鸐脈ऀ逊 Є䁈̀ ǰ⒄䑄䉈ἀ䀟  밑Đ਀䀄 ᄁၻ쀀 밑ĐᄁထĐᄁၿ쀂 鸐脈ႁࠑ胨ࠁ 艈⒂䠤艈⒂䣿 艈⒂䠤艈⒂䣿 Ҁࠀ䂂ࠠ萿耀 븠興₃젢舨⊂⣽ 쀐Āခ脄၁ࡿ  舄@搉쀄⁃࠯  ᠢ䉂␣숤≂␢⓱耀  ︐興₁ࠏ聈ࢁࡡ   ðႀࠇ膈ႁ᠎쀀 Ā怈Āᘁ逐脈ႀ逆    ϠᄁသĐႁှ    ǰࢀ萈ࠀ耞    ϸऀ选ᄁ䐄   àᄂ࠿舀 ࠏ  ㆀ àᄂ࠿舀 ࠏ    Ӥ䑃堟Ɉ⒂䡮쀀   ǰ₀ࠇ₃ࠏ    Μᆁ⠒腈ᒁ蠹쀀 ऀ怀Μᆁ⠒腈ᒁ蠹쀀   Θቁ—Ơᄁ࠹쀀   ǼҀ䠄聈⒂䠙쀀   ܜㆂ꠪芨⒂䡱쀀   Μႁࠟ脈ႁ࠹쀀   ðႂР䈄⁁ࠏ    ϼႁࠐ脈ႁ࠹쀀   ͰᢁА䄄ᢁ瀐΀   ðႂࠠȀ ࠏ    ϸ⒄䐄@Ѐ䀎    ǜࢀ蠅Pȁ‒À  쀄͘乄䑄䓤㖀䀎    θᄀꀄ@ਁျ耀   θᄁထĐᄁဿ耄   θᄁထİഀဃ耀   ۬⒂䠤艈⒂䡿쀀   ۬⒂䠤艈⒂䡿쀂   Ǡ␂䀇聄р䐟耀   ܜ₂࠼舨⊂⡽쀀   ǀࠀ耏ࢀ蠟    Ǡ℀ࠌ脸သ    θᑁ䐜䅄ᑁ䐻耀   ǸℂဟPऀ逳耀     ÿ    Ѐ䀄@Ѐ䀄@Ѐ䀄@Ѐ    Ѐ䀄@Ѐ    ü@Ѐ䀄@ЀЀ䀄@Ѐ䃼     Ѐ䀄@Ѐ䀇    Ѐ䀄@Ѐ䀇Ѐ䀄@Ѐ    ÿЀ䀄@ЀЀ䀄@Ѐ䃼@Ѐ䀄@ЀЀ䀄@Ѐ䃿    Ѐ䀄@Ѐ䃿Ѐ䀄@Ѐ   ￿    ؀怆`؀怆`؀怆`؀    缇؀怆`؀   `؀怆`؀؀怆`؏     ؀怆`؀缇    ؀怆`؀缇؀怆`؀   ￿؀怆`؀؀怆`؏`؀怆`؀؀怆`؏￿    ؀怆`؏￿؀怆`؀؀怆`؀怇؀怆`؀   ￿Ѐ䀄@Ѐ؀怆`؀惾`؀怆`؀Ѐ䀄@Џ￿    Ѐ䀄@Џ￿Ѐ䀄@ЀЀ䀄@Ѐ缇Ѐ䀄@Ѐ    ÿ؀怆`؀Ѐ䀄@Џ샼@Ѐ䀄@Ѐ؀怆`؏＀     ؀怆`؀惿؀怆`؀ 葄䱉䊄⡂䑄䐱胠  蓤先ኆ⢂偅胠  蓤先ኆ⠒兄胠  葤䙈ꊊ⤢彄␱胠  藴偉⠒兄胠  蓤偉⤒兄胠  藴䅈⊄⡂䡄萱胠  蓤光኎⤒兄胠  蓤光ኑ⣲䅄胠  蔴瓉䪔ꥊ哅㐱胠  蔔獉ኑ⤒充ᐱ胠  蔴瓉ઑ⤢呅簱胠  蔴瓉ઓ⤊哅㐱胠  蔴獉劕⥒埅ᐱ胠  蕼瑉犐ꤊ哅㐱胠  蔴瑉犔ꥊ哅㐱胠  蕼烉ኑ⤢剅␱胠  蔴瓉䪓⥊哅㐱胠  蔴瓉䪔ꤺ僅琱胠  藔囈檊ꤪ勅퐱胠 @Ѐ䀄@Ѐ䀟  ऀ选ऀ速耀 ﰤ艈⒂䠤艈⒂䡿쀀 芈⢂倥ɐ∂⁲  ᰠ興ᄁထ ਀䀄  簢舨⊁䠔腈ࢀ蠉쀀 ﹅䑔䕂鐩䊔ᅁᐓ "+CHR$(13)+"﹕䕔啅呕䉔╂启 艐│•ɐ│衽쀀 ᰠ脐਀䀄 ᄂࡱ쀀 ฀᠎•Ƞ∀䀘 øȀ‏쀐ľȠ∂‾ ⃹⒂䁃렀ހဏ쀐؀  聈̾᠎䀀Ш䊇ꡂꑌ 屸ࢾࠡˡ숀 聄࿀ @Ѐ砄@ѢĠȀ䁸 쀄ʀ⏢@Ā倅⁒ী  ၡ蠠䑁蜄酅ᐯ䰖 	ꤪဦᰀࡈ蒏䢄ꡌ 肊ꢪࠧᰀЀ䀇聀Ѐ û䨩븀Ҁ䠄븈̀ 䁔Ѐ砄B萨ʀ⨂ꁌ ⃹⒂䁃렀Ѐ䀇聀Ѐ ⁕Ԡ䧨耀Ҕᙁ䝤 ␂伤O᠀ઔ腊䤖  䁪ी觠䀀నઌ耐฀    㲪ꪪꪪꪪꀀ    㲊꠪芨ꩲꀀ  ࠀ耉㲢갪ꊩ⪊ꀀ    oᢪ䪘ꨊ鲪“  ࠀ聩ᢢ䰘ꈉᲊ“    ᲊ⠠興ꉱ쀀  ఁ ठ鈉ₒ   ૻꪪꪫ䈴﵂含ꊊ ŀᐂ耨            ʀ⠅P   ಀ젊颪䦤驈ꒉꀀ  J䒤劅⡣Ԩ劄ꑊ䀀  ø興⺂蠨苨⢂蠮  葄䑈犄⡂翄б胠  葄翊䪤꯺䑄䐱胠  萄翈䊆⡒䑄䐱胠  蒄翈芏⤢扄ﰱ胠  蒄翈芟⪒䥄胠 ࡕ䥒￩劷鎩噑䈈 ࡈ䯺蠨⫲褨䈈 ࡊ䢪鈩者ⴢ鈩≑䈈 裬誨뤮튫눭⒞ '⠢劅⢊裾 瀪ຮ꾫ꫢꯪꮪꫪꎮ 8Āﰀ߼ ဃ耐   ߼ 쀀ﰀ  Ѐꀈࠀ䀄 Ȁ @ Ѐꀈàᔁ倕Ő฀ @  숀က耄ဂ쀀 Ϡ @Є䁈઀ꠁ   @Ѐ䀄@Їﰀ    耐Ȁ䀈Ā ﰀ    Ȁ  Ȁ ﰀ    耘ʀ䠈脈₇    蜜₀ @฀䀀   Đ₂ࠠ興₂ࠠ耀   興₂ࠠ興₁ဎ  "
    KNJLIB_FONTDAT$[2]="︊ 翄ꑊ䒤翀ꀊ࿾ ﻢ訨꿪ꪪꪪ꿪⣢臾 Ą၇儅﹑ऐ၁Ӿ ﺠ䨄칊꒪䪤까Ҁ䠜 Ѐ䃿㾂ࠠ菸ᐮ␡蟆 䉈￩≑䣺む逎༞ Ȅ⑄俾䠄﹉ܐ⡄䶂 㱄⾀倅繐ऀ䉄⑾  粘䑈ݡ郧숐⿢ၐࣾ ᄁჿﴤꐱ跶Їﰑฎ ᄁჿ￡ⁿ쒤剆᱀䟼 볤苾┯縥⛾椪ﺩȎ ︊߼䩇ﰊ࿾Ё⑐⣸ ﹈⻾䠄﹊䚾종㹐豾  ﺈ⓾ࠈ﹊䂾䢅㺐衾 籄䑄䑔䕄埅⣾ ᄁჿ㾀裿㿂䃿 ᄁჿ翀?숄㿂@Ѐ ȇ⒔䉾金ﻹ䪢ﳀエ檸 Ăု⑂䡯넊︡Ȑ ﹀А䄄ၟ䄈ႁǾ  ᣺䉂賂賺䢔೻䈄 ﱄ么䔄屈䚤텅ࡃ䳂 Ѐ䃿䀧뱊䚤髀ꀲⰞ 繄⽂埥䉔⥾䉄⓾ Ăအ࿾ꨊꂪྠ∂ꀪྞ ႉȢ﨨뻸ࢀﯩ⊊⽾ Ђ䁇穄꽺⒫窠∌ Ă၏⡌漼ⱊ⒣苆 ć႑Ȟ金郹ા蘒⊪⪾ Āዿ礄鉈꞊A賣⃂ ︊߼䩄ꑿ쉈￠퀴豆 㰤⾀ခ縠؀럢䈤≾ Ѐ䃿蠠胿ႃဏ܌ Ȁⁿ翤ꡒ䟾剅ﲒ⠾ Ȅ 判 쑄졃跆 Āჿ鉉ﻰॾ鐩维⁾ Ѐ䃿￡ࠟɈ￠퀴豆 뺊⾾訯ﺊ⯺鄩⧶ ąჿ產ჿ既⣹艦 Ѐ䃿ഃ䣄䁂㾂ࠠ菸 Ф䉄≂␠䈈㢌ᐆↂ ︡␒忬ቁ⓾䄄၂Ӏ Ăအ׾䀌䑄䑄䑄䡀藾 Ăဿ䈌剉▔梄衋䗂 Ăု忬葏쐐俤遟 ﺀ⢒뾨銉⯺鄩ኀ⿾ Ѐ䃿翀䑿쑀￠ꈱ谆 ﰄ࿾ഃ䣄悀￡ࠟ، ੿纄詿ꔪ剅䒌ꬲ '⟾䀧⟪䠪ꊪↆ Ȃ␢䉾ꒊﺴ詈꟢䠤艾 Ѐ䃿￢࠿興㾁⑐⣸ O蒏艏鐠䪄꓁P䣲 ﰠ䏼⁃ﰐϾ䤨鈒≌ Ăု⑂良Ꜫ刧∆ ∁ ߸ࢁﰠ䟾耥剕‌ ﱄ䟼䑇ﰀ࿾⑂␡辆 ﱄ䟼䑇ﰑ࿾ᄏ︠萄 ā郣≏ᠦؾ氪⒡苠 Ȃ⑂䡾﹄轈⟫䢤艾 ࡏ䉇⟫䢯 ﹄⟾䐧︠䏼⁃ﰠ䈌 ᄁჿ￡偤삀￡ࠟ، Ѐ䃿ࠁ∢䘘ꄂࠦ䞂 ︉⻾म︄䁼粤乌 Ā၏࿠䓧⿢ࡐࣾ Āႏῠ䓧쉄⟂艐ࣾ ﺐৼ鈊₿졐袋Ҁ࿾ ᄁထ࿾ᄁထ࿾ℂ၁А Ѐ䃿℁‌䜈Ā怙踆 ੟ꩊꓤ䁅⁢ Ѐ䃿ႏﰠꏸ₃舘 ခỿ−ⅇ䟒䔧퉅쓐 Ā哹ꉔ⪢ﹱൾ咅橘윲     ÿ    Ѐ䃿翀ÿ醡䃼 ႀ袁߾࢈衐䇾啅咕䯾  粈藾ठ鋯⒂蹐ࣾ 﫢⊔⑏+毪ꊪ⊾ ᄁჿЄ縩℔Ă⡄䦂 ᄁჿﰄ@￠䀄ǀ ﺒ⋮⪪ꪳ⫌ ࠀ耐脈⁏ﰒ™ሁ•Ⱎ 胣舯ꊂ⠢舨⋺  ﻩ⪒꿪銩⪒ꪪ웨⃾ ﱀ䟼ﱀ䟼䁇ﰠ谆 ﺄ⡂뾨䊄⢢鄪઀⿾ ﹉⾒俤鉉⢒왈⓾ 萈䂄Ҁ侄ࡀ萐䘄 ȇ₋直꫸袈雷ᒊ⽂ 廒⒔шO忤ႁ৾ Є葑䗴䑄鑟䔔彅ኟ⤒ ᄁჿ䊣쨈韩⃤⡾ ĎႯ쟪 ૾ꊌ⢄ꦎ 㢤䪂퟊§쨈꿬䂈⣾ ﺥ⩔쿪ʯ꿬傔䨺  维╾倏︄⽾鐯纒係 @Ӱ䧾遉Ҕ䤤遉Ӱ䀜 Ѐ䃿Ѐ耟쌄큁А䇼 Ѐ䃿耣@￠䀄ǀ Ѐ耿興㾂?㿠ɕ⥖ 븈₂訤鈘把䤨ꈈↆ  ﹀興ﻠ興₂ᡐࣾ ︄@￨䊥⥊萪劔ꡆ  ␒䔤剅◒嘉̐ 袄逓쾤⯏꒣⯦芥⊖ Ѐ䃿矂䓿쉄ￂ⡒꣎ 肈ࢀ裿ᄁထ࿾ Ȁ⓺䉾⒂ﹴ赈埥䡔蝾  怘؞䀤ɀ➞䀤ɀ⟾  ﲈ䒼੉﹐ⅺ咥䪗꤆ Ȁ㳢௾ꐫﲤ੾늪곢臾  维⥾鐩纔⥂韯䂂 ₂ꣵ꒯ﺑ⿾蔯쪈⽦ ᄁჿﻸ䠤壟Ҩ䩌 㲒䈼琢ﻺ꫾懲⒩諦 Ȅ⁏劅﹒ौ䁄⑾ ﺀ௞ꕋ풥䯾ꁊ貥䮦 Āኟ࿨鉏࿢鉉⢖ ﹈蒈䢄衈蒄䥈钿⠂ 뺊⾾訯뺀⯺萩⯺ р䣿꿪ꪬ뿪Ӥ䀬 ﰀ ︐Ĉ₂ࡃ䟄 ﺑ⓾ठﻩ⋾ℂ﹑ࣾ ﰄ࿾ꔩ䨄߼︠蟴 ᄁჿ ﹁ఐ忤၁Ӿ 纊䈤﯈ꓺ䢼琢⚗캄 ခ⿢銥䪪ꟊ왇쑄ꟲ Ђ䐤迾鄩ኟ⁀㾂ࠠ菸 뺊⾾訯븤蒄￡ࠟ، 슄俈萏숐俨䠇芔䬨 Āჯꤪ鋩⯾ꄊ⣤䆂 Ѐ䁿쑄翄䑿쀤ʀ」⼎ ࡄ䠡࿾萠䁿쁀ഃ䣄恀 ᠀怀τҏ倖Ő⒄䒄⇀ ȀႀӰĩ푅聐䦄钑⤰ Ā႟Ῡ቟łᡆꦆ р䓯䄎﹉⒒忤⣤䆂 Ϟ䔥芌준翄ꑊ俾 ﻱࡾ维≾ﰢ繲䫂 ﻱࡾ维⁾ﰢ红䫂 ᄁჿЃ艈￠ꀱ谆 Ђ也ࡐῢ鉏Ⱒ徥≿ꐦ Ȏက໰Įᐝ聐钱⹰ у⑈衾䋷늊⠤꾎 ĀႿ৉⑒䍔啅࢑襦 Ȁⁿ쾄詘忄蒇讆 ℁ဂ࿾ᄂࡀ俾䩄ꑊ俾 뺢⾢ꈯ뺢辨੊ꐌ⍂ т␠艾됪슧ꊂ⠤ꎎ ﰈ仼ࡎﰄþ銯⸌ ₂ૻ⊯䎤ꊪ狰ࣾ 뺊⾾訯뺊⧲鄩ꬺ ︡ཾ␢繤♾ꑊꐡ苦 ﺤ诊菫좤诌ꕋ풦⫂ ﺄ⡂萨䋿耨ʀ⠎ ﺄ⯺萯ﺑ⧲誫銈꿾 ﹊Ⓘ빉Ӿ䥄鳪⃾ Ѐ䃿⒇ﺤ菸⒃⁾ Ѐ䃿뾢࠿肀￡ࠟ،  ೯Ȑ䄈廥ɐꔄﺰࣾ 빊⚢髠ꀲⰞЁ⑐⣸ Ąၟ䤥﹉⛾줤﹁ఞ ﹅⹔俤ၟ쟅ꑁ賦  㲀䑄Ш艈~Т䉄⡾ Ā႟࿨၏俤銏 Ѐ䀤䑈ਃᣄ扈⒀ꀱ谆 㰤䪈ꏪꈪ⊾娤ꊊ⢾ ︢諾ꪪꨯ埥ႁࣾ ᄁჿ⺮మ蚪껠R䢒 ĂႯ忪䐤䙼ꊣ쨤䳲 籀䡼﹁ཪ⇊檸ꈸ ␂峾䩈￪䫼ꑾ簂䀤⿾ ᄁჿ䀇뱊䚤髀ꀲⰞ ᄁჿ￨䊿ꤒ鼪ꪉ⿾ Āႏῠ䓧숒╂鉐ࣾ ᱈䠤䋴Ⱦꨪꈢ⾾ 빊⪮ሃ﫠₃﹀⥖ Є䁇䑇쐀俤ꫪꇾ  ᰢ⿀ ᠼ摀䐈䂉茆 ﺂРῨ䁄~ࠢ艀䠘 ﺩ⿾ꤢﻱ˾∢⋴⁌ ẑ⤒鄩ኟ⠂耨ʀ⿾ Ѐ䁿쑄䑄䑄俾Ѐꀱ谆 Ѐ聿암䑇ﱄ䕔￠ꀱ谆 Ȃ၀ࣾĂ၁೾䄄၁Ӿ Ȁⁿ䈄၀ф䐥䂤⠾ ﹉⺒俤鉉⚒쿤၁ఐ  ﻱऐ鄉ჷ鄉ჱþ ҂䠯㿢鉯꿪$䊂 ȏꂃ튪⪠贈襈ᓲ⃂ 벂䤤퉊䚠ൾ鈨⓱胦 ︄@Ѐ䁿쁀Ѐ䀄࿾  貆ႇ྾䤢詉⦦ Ą⁏⮢홋귖愅﹄䖂 Ђ䣿뾢࠿興㿠ɕ⥖ ď₇쥄퟊䒧韨˵⅖ ᄁၿ섐￠䀿艈㾂䠿谆 ﺀ⤒鄩⊿ꡂ꒪䪿꠆ ĀႁӾन鉉⃾Ă၁ࠐ ᄁჿ儂ၥ⥔ㄅᢒ䛂 Ăဿ忬艏俤偔䙺 ﹀⟾䀇﹈藼䈩ﲂϾ Ăု뿪芯꿢倴䉺 ĎႯ芯꿪傴䩺 ﰠ輐⿢鉯꿪鈩⊖ ࢠ辈꟪ࠠ莈ࠠ艾 耐Ȁ䀈Ā⁄р䏸 Ăဿ䤭﹩⓾䤤﹁О 䀄}鄯툑⇒鄩ኝ渐 ﱄ䗴䑄ꑑ䟼Ё⑐⣸  ﲈ䓼ࡈﱀþઢꩊꧾ ﻥ≔⿯ȯ濪傴䉺 Ѐ䁿섐ᄏ︀ϸ₃菸 ︄@Ѐ瀄쁀Ѐ䀄@ ȁ‒Ȣ≆⢣Ƞ∂∢∾ ︨Ҁ俌葊䒔傅ࡃ䓂 ︠䐄乌ꑊ䒤乄р䐜 ࠂ耨䪬ꩊ꒪劥⩂꓎ ︢萨俬ꩊ꒪䪤ꩊ꓾ Ăု䄍﹁А俤၁׾  !┢別⑒䔨劉⌞ ︀耈碄衈蒈碀ࠀ耸 Ѐ䃿翂࠿脐￢ꑊ䦼 ︄ϼ⁃ﰠ䏼ႆ蠏༎ Ąၟ埅ቓ䧈橘ꐰ Ѐ䃿뾢䀌䜨܁꣢惀 Ѐ䃿鼡ჿ翈訐蘰 蓢䈔⁏䐢䘆燊䈄 ⤢黩ñ邩섲 ﱄ䟼䑄䑿쁀￠퀴豆  ỽ≒┤劙￠퀴豆 ȏ꫼肈铪⇂ ﺀ䐄่ꑊ䂤โр䠜 Ѐ䀄Ʉ⑄䡄肠ਁဠ谆 ﻠ䐄乄ꓪ䒤乄Ӡ䀜 籄作ᕂ﹈Ⲻ檤ꩋꒆ  㱼@Џ︆Ðᒂ䓄⁀ ā郯⟏ሣ䛈懊檸ꈰ Ȅ⁻ﺄ⯺萩⿾ ᄁჿခ•昸ꈂ•∾ ᄁჿ︀䏄⑂䐼䀜 ᄁჿ ỽ≒┤劉⌞ ᄁჿ ﻀ䓤䩄ꑎ䐌 ᄁჿ翂䣿翀䃿 ᄁჿ㾂䠿艈￠퀴豆 ︩⾒꽪肩⢢쾲 ︉⻾म鈏ゥ侒 ɀ⓯꿪䪿꿪࣯ ȁ☣踢㿢࠿興㾂࠿谆 ࠀ肈ઠꫪꊪ㊢湐ࣾ  籄䉜Հﻨ⊺⪢멐ࣾ ﰄ࿾ꔡ䣻￨⓹衦 ࠠ迾ꑊ䒥俔⅂蠩迦 樸ꒈ䯯졈ꓪ硄葉ꗢ ꉈ꟫좤ꩪ뱊䓵ꃢ ā铡∐⿯ࠠꋊడ♢ ﰡȐℏ︃PःჁp ︄ϸ⒊䪿ꩊ꒫婢⿾ 좐褈袉侔鉉⋼⁂ ᄁჿ翁ထ࿾ԁ郡p 꽈꿪䢤꿪⑂䐥꿢  㻺⊢䯨蠿興㾂࠿谆 ȏꑒ䕾咅ﻴ腈㟥䢔荾 ꉈ￩䣴ꥪﱊ䒕껢  ỽ≒翪䀿쉀㿠ɕ⥖  Ȉ光ሑĐℂ၁А  Ȉ彈Ȁ࿾ႁࠣ䏄 纑∢ﳊꣻ겏뺈覈 ﺀ⠂鼩ኑ⤒鼨ʀ⿾ Ą⁏鉉⓾䕄哩₞ Ąၟ﹂׾䔥铨胦  ﻨ⊺䪨ꫫꊂ꿤°ࣾ Ăုꄪ኿ꄂ⠤䎂 ︠∤ꆊਐ꟢အ˾ Ђ䀧꿊咥䯾ꩂꐯ ︨芈ꪪꪪꪈꥂᐢ⋂ Ăဿꪪﺢ௾ꔣ鐨苦 Āዿ⤢鋽䊔⢄ᡆ䆂 籄佄䟄@۾숤≄ⶌ Ȁ⃳ᑏ䒁䠔邉ࣳ䃂 ဂዼꩂﴪ䪤⿞吥炐⧾ Ѐ䃧꿊哥䯾ꩊꓯ ਯ⪂ꩿꚪꩊꐠꈲ ࠀ肏Ὲ鑉䇾剅⒟ ﹀А䤤鉉␐䊈⢄䆂 ﱄ䟼䑄䑿섐ㆍᐑ☐ Ȅ⁻䈯븄ϼ⁃ﰠ䏼 㱄⤀@ཾℋ⊤≾ ᄁჿ 贖ᄁအȐ 뺑⾾ꪏﺈ菸⒃⿾ 뺊⾾訯뺀⯺訫慠⤦ 袮좊૾꠬ﺈ⣾ ﰠ䏼⁃ﰠ䈄㿀蘆  볺䀤懲⓺䢤海⑔來 ℂჹѾ褥ሢ⒢鐢䉐䢘 ĄၹҐ䴊낙肔ᄡအఐ Āჿ鈩䒒褒陉ࣳ䃂 Ѐ䃿뾠䀿聀￢ࠠ菸 Є䉿翤 쐠忈₂Ͼ ︩䋴ꥋ麯䪄ꭂ찡䉦 ︩俴⥂鹯䚄ꭊ찡䉦  ﺈ蒾࢈衏䯥࢐衾  维≾␢繰䷾偅䑒䜌 ᄁჿЏ︐蟼'ﱊ俾 Ђ也ࡀӣⱂ弤䉄◶ ĎဏȮ䐂耒ࢣ仂 ă則ÿ럪␢俾 ć遏䨯풄螒乇衉䗢  ﺉ⓾न鉏࿢၁ࣾ ဏﰒ俆喇࿾⒇ﲠꏸ ࠣꢊﺨ辈⏢蠨迾 ﹀Ӽ葏쒄䡄ﳠǾ Ăုℂ﹩⚒ꤪ鈩成 縤࿀꟪傥࿞∢∤⿌ Ѓ䁇諸⋺≊뒪稠⾌ 숥⿒┯툡⿲ꔯ스⿦ Ҁ䣯ꒋﺥ䫔땪哩䂴 ခ興䤀怙踆㾂ࠠ菸 Ѐ䃿﷪劽䢔鄯쮐 Ą၏䤄遉ڤ쩅⑔걲 Ȅ鑄迾䠤ﱈ䚄쿄⡄궎 Ȃ‣⩂ᡢ䝂꿪䈤≾ Ăု∢䑢蘒뙊ࠣ䋂  㳺䈤懲䛸ࣾ爥⒑触 ɂ⒯䟪젧꿢䐣賆 Āჿ⊂繼赈埥䡔蝾 Ɂꓯ⟯젧濪䒣苆 ҂僿뾢࠿興㾡∢ⰾ ߼쑇ﱄ䑄翄Ҁ䠜 ᄁჿᄏ︪說ꪪꩈ薘 Ăჿ琢싸ત壟ࣹ䉢 ခỿ‒組塽䂒ᄯ윐 뺊⾾訯ﺑ⫢鄫晴⧶ ﺠ੼쑊粠૾ꪬ욋ꢒ ᄁჿἀ䁿쑄翀䃿 ࡄ䠡࿾耫@￠䀄ǀ  㠼Ȁ㿂အ࿾Є䑄䟼 Ѐ肟└ἅᒟ⁀￠퀴豆 ခ㻼誾ꨥ㸪⑾﨤빊䟂 뺨达ȯ븂⾾䈯뺉䍢 Є䑏乄䑅晅콄䑄䷴ Ȅ⁻⒀䁿섐ᄁ ࿾ ︪⿺⥂꛺ꄊ縡˾ ︥⽾┢繠۾ꔪ縥⋾ 縤⽾␂繤蝾ꒊ븨舎 㢜艊﫴詌﵀咪⪢ Ȁ첈䓜ࡈﱄþ値ꪊ⠌ ခ˿⤒ﴡችℒﴤ䉄⟆  ﳨ䫼ꡊﲤ૾렪鋯‌ 㰤⊀ꀊ纠਀꟢䈤≾ ا輈₂縠茈䈤♾  ຏАĈ﹁࿢艈⣾  ﲈ䓼ࡈﱄþ堤銏⠌  ﲈ䒼੉﹐⃼ࡂﱈ䢌 ᄁჿ㾂࠿脀㿮Ȣ⏬ ﱈ仼⡂ﱄ໾堤鉏␌ ࣿﯪ裻￢⋺∾ 興㾂ࠠ菸₂ࠠ迾 ﺪ⓺壘꫺㺨諾 ࣰ褈鿩࢐褈邉ࣰ耈 ҂䠿│剩䚘뤊逩⊞ ɂ␯⿢䩿꿪࠯ ȅ⃻瞢䫸ꪺ謁⃺∾ Ă逩໾㄂ၯꎊ吹∐ Ѐ胟椒鼩ኑⷶȁ‒⸾ Ѐ䃿ሇﰤ蟼䑇ﱄ⁾ ᄁჿ俢ႏ࿢鉏 ᣊ惠ㆌؿ聀翂䠕࿾ Ƀ⡏⫿럪⠦쾪 Ȁ볪௾ꉊꪢ⯾ꪫ⛢⏾ ჻쪤ꯏ꒫ﯢȪꊮ ︡༠⟢䉤♾됪䈤≾ ᄁჿ㾀ჿ੃⃂à ᄁჿЏﺀ⯺ᄁ࿾ 丵⋢蹎⸣判ⱌ  舉⢒䤣ሑℒ⤢䉀␆ ᄁჿဥሱℒ⤢剀␆ ︐Āἁထʐ│ሿⰞ Ȃ⃻ﰈ뻸䢈車⋼∾ ︨⒂䠬﹀є䕄呉䔖 ﺀ 縀侤充Ґ⣾ Ѐ䃿뾡ჿⲌ㘘p 숡−™ዽ−™Ƞ∆ Ą郹Ӿ礤鉉⿒ꨬ俘 䄄ၽਾﴥችⴒ縥≐䟘 ࡄ䠡߼ए︐菼삣䏼  糨课ꪪꪬ뿪⣤䆂 ф䑟䑄䓾䪄컸þ ࠀ聿섐㄁迾䩌ꐹ챢 Ѐ䃿뾠 ߼ሁ•ⰾ Ѐ䃿뼪ሿȀ㾂ࠠ菸 Ѐ䃿翂࠿興㾀ꀲⰾ ﰄ@Ѐ䃿Ѐ䀄@ ᳺ≀ﯨ裸袈ﯢࣸ興 Ѐ䁿쑄翀䁿쑄翁⁐䣺 Āቿ嵅䢝䠢Ё⑐⣸ ︩⏾ꤪﺨ⫾ꠢ︢䋂 ਯ꺪꒮ꪒ∀鐨⑸ 籈迾䪤ꩌ⡄䶂 ď퀑䘧쉄ꟊ䑇쓄ꁲ Ђ䈤⿾␢䉧됪䈤≾ ︠ཾ␢䉧됪縠˾ Ăု⟂䑧와럪䈤≾ Ȃ⃿猪⫸耈﵂ᒪ⫂ 䈄ⁿﺥ⩼贈絅ᑒ⟂  ﺁАĈ၏Ă၁ࠐ Ҁ䢟࿨鉏忤⢄䦂 ꗮኩⅺ咥窔ꥺ Ѐ䂇࿨⑇ߢ䡄衾  ﻺꋾ ﻴ䉼Ⅳ㣍䀒 ₂ࠠ迾₂࠿興₂ࠠ菸 ȏꂣ蠏베਀ￄꑊ俾 ︄ϼЏ︈Ǽきﰐ䇼 Ȅ⁻ﰄ@￠䀄@ Ȅ⁻Џﺑ⧲ခ臸 䈄⁻ﯨꋻ⧶ ﹅⡔၏⟊꒡苦  ?쑀䐀䃿Є䑄䟼 ᳺ≀￨鋽ꢒﭢ嫹∶ 纐褈ࢗ邉࢐謈 ₄諾ꪪ꯾ ᄁჿ￨ȿ耀翀ꀲⰾ 䀄㹾⨾︥㹾ⴾ祅ᑒ䟆 Ďဏ࿮鈏ゥ侒 ﱄ俾䑇ﰠ菸₃谆  ﹊ꋾﻤ䉼⌢푑⣾ 裾車꿪ꨪ꿾 뺊⾾訯뺀⧲鄩⧶ 뺊⾾訯뺄⯺萨ꡆ 뺊⾾訯뺊⯺萫慠⤖ 㲤䪈쏪ꊪ⪾ꨬꊊ⢾ ₂ࣷ￨ꋻ￢䣿 ćႇﯨꓻ좠ﯪ⊒⺾ ă၇ﯢ⓻술ﯨꊊ⾾ ခ࿰ᄁၑ̐ᄂ鉅⠎ 藴耣 㾂ࠠ菸 Ȅ≿翤_쐠䈋ﺂ  Є䉿翤避嵅咽衦  ﻰȀ‏︤艈㒌䠈ꌎ Ȁⁿ쿄^廤႑⧾  维⥾䊗锩䫴䁲 Є䑄䟼︈Ā㿎Р䏼 ୀ氋縥侔襏钊侦 ﹊䔾皅⡟鿉П옆 ﹉䒔叧⑗叩⒒䄾  ﻱ~Я織╾吩ﺂ䃂  绸蒾䨯ﺒ⸾騮㸙乢 뺐达訯뺊⾾鈥뺑䍢  Ȉ䑈䈄ɸ␂䀤࿾ Ăဿ䄌ﱀ䑄䑄⡃藆 Р￤O蒈䢄颈⣾ Ѐ䃿翂࠿脐￢ࠠ菸 뱊䒤節䃿ﯤꑊ䞼 ᄁၿ섐ἁჿ⒍߼ Ѐ䁿삠ᄂࣿ㲂䠼耘 ࡏ埥䉗䉄⑾ Ѐ䃿뾠ꀑ࿾젤菘 Ăဿꄊﲠ䩄ꑏ⠃臆 ᰎܘя︒ϼ퉁␒쀠 Ђ䡕䉈䔧࿾∢⑑蓦 耈㾂 䏼Ё⑐⣸ ﹑⿾䤤﹉⚒쿤ၟ 簤佄⑂䑤䝄ꑊ䐨䌆 Є䁏䟤䑷아鿩䙂 纒伤鉉ﻰ蠈醈ꪤ겎 黽⒒秤鉹⒞ﴠቒ⢦ т䐯⟂䑧완꿪$䊂 Ѐ䃿翂䣿翀퀴豆 Ă利佚⥂﹡۾ꒊ樨䊚 ﲠ䫼ꁋﺡ⫾⥂鑉쐐  㳺䔤剏욨վ눥꒑虦  ?往쀄㉀쐒☒ ࠀ肏씀ឈ_쀄Bр⠂ Ё䠭䕨┯︄࿾唧푔蟖 ధཀᐁ縤䙄둂萨䈄 ࿾ᔂ䣟䀢Џ︄ǀ ꛡ艤ℯ縢پ洫劥成 繀⤂繄࿀␋䊤≾ ԃ偕Т꩔겪彄䑔꙲ 縤⽾␢综≾劅⢄ꦎ 縀⼂/縄@䊔⽾ Ѐ䁿쑄翀䃿㾂࠿谆  㻸∂⏯ꀢ΢ꏪðࣾ Ăჹɼ壘铹䪔既⓼䉆 ︩⫾ꔢ绽╒埥႟ 㲊䈤煮ꓺ䢤爫⒊但 ďႯꑏ芯ᜭ列☆ Ѐ聿蒈羄衈蟸ᕁ尤ⰾ ࿸䢇ﱈ俼衏ﲈ⁾ ࢂ䠡׸䒌ﱐ䟾䀥剕␌ т䠿俬ၟ翤鉜쒲 Ąၟ儅ﱐ䥄⡃藆 Ѐ䃿뾢࠿興㾂ࠠ迾 ႁ꟨叧ꗪ镋搔ꟲ Ąၟ䄄ﱀ䙄쑄⡃跆 㹜伈俥ਫ਼蚈ꡖ踾 Ȅꃻ窤꩸蒈﵀ᑒ⣂ ъ䢯꟪ု䨮䉚 	뻠䢈ﯤ੺褨ﻡ⠪豾 ه轈ᒁ䠧䑅ꓢ ႁჿ翀䃿￢⓹艦 ɂ⠯ꯪ袯⿢䨮佚 Ďဏߎ䐇쁄䒤仾 ю䠟࿮ဟ￪銼캲 ࠄ聏劤뉂◾꩒Ⰼ ᄁჿ㿤銪₂羡ꈩ⒌ Ѕ䃿窢⫺⫾ﬢ櫺∌ Ѐ䃿Їﰀ 㾂ࠠ菸 Ѐ䃷选粐褐鈉䋴‾ Ѐ䃯꺪劮樐뿪ღ膆 ࠯₂繠؀럪䈤≾ 簠迾┢鑯곪먪ꊺ ࠇ縀 ⊒⼾ ď逡Ȟℂၱൾ吥䉔❾ Ђ䀧⢂ࡠ蛾ꂊࠠ興  㱼@￢䡊䌘쑡値賆  㻺∢∢⋾␢䈨ꋺ Ѐ䃿ꤤ怙踆㾂ࠠ菸 Ў交꯺䪿깊ꢪ꺮計 Ѐ簄߾䐥◾倉ﺐǾ р⒀蓾Ā鋩⋾ℂၐࣾ  ᠾȀ ﰡȐℂအ࿾ ခ脈₂ခ Ԁ蠰䰂 Ȃ•׼䉌⑂䐤䑄䑈✂ Ăအ׾䄌၃ј䥅ቁА 脐ሁ㰠䉄䊄᠆䎂 ﳤ䩈ꔊ岨䪤녊ࣣ䃂 Ѐ䃿鼩ሟ㾂ࠠ菸 ﰀ䀄㿂 Ͼ䀤Ȁ䀸 ߼Cﰀ䏼Ё⑐⣸ ∂‫⁊䑩䈔梊䠡䙢 ︢༠∂㹢♂됪Ƞ䈸 Ѐ䐄⿼Є䐦聐ಃ䓄⃀ ﲄ䑈Ԉ屈䂤充ࢃ䣂 Ȁ₂׾䑄䁄҂䡀觾 `ᦎ؄Ʉ䒀ꀱ谆 Āᓡ◼䄄鋥䐐䖄铱‰ Ѐ䃿ሆᰈ߰ऀ鈱Ⰾ Ѐ䃿篤艻￢ꉈ⦜ Ȅ⁻ﰡȼ䡄䢃视 ﱄ䥈屈交ㅊࢣ䋂 т䤤⑊侦⏊쒠䈄 ᱂⥀㹈ྀ⏪ꊪ∾ ﹈⒂䠤艏䠤艈⓾ Є䁄߼萈䀄࿾Ѐ䀄@ Ѐ䁿쁀Ѐ䃿ࢁࠣ䏄 ﱀ䟼䈇﹂Р忉Ґ䇼 ﹀Ѐ羄ࡀ蟸䀄@߾ ﹈຀俄葈䛼전聈೾ စᱝ佔啅呕䚤쩄虔฾ ࡂ䠑࿾₅⏸Џ︄ǀ 縤ࡼ䑁簤࿾ഃ䣄恀 Ѐ簄߾䠥ﱈӼ攩咅Ͼ ȏ ҏࠀ聾࢐輈 뺊ࢠﯢ∢⮾ꈊ₢྾ 繌⡾综艈ꯪꈢ⾾  粈藾न﹉ₒ俤ꤪ စﺔꏺ䒭也耀￠䁄䣂 ߼쑇ﱄ䑄翀R䢒 Ѐ䃿ᄁ࿾Ȁ䀄ǀ Ѐ䃿ᄃ ￠䀄ǀ Ѐ䃿㾂ࠠ菸Є䒄⇀ ҂䠤藾䒌䡄藾䀄䡈䔂 Ăု䤬呁׾䄄⡄䖂 ︢׾䒌챗ꘀ忥䩗ꔆ ᑊ䑄䩅ᑀ䟼ሁ∢Ⱎ ₂ࣻ￠ûﯥᒒ䧆 ᄁထ߼ᄁထ࿾ဠ萄 ʠꤒ訨䊊⤒ꂨʀ⿾ Ȅ⁏쐤䑟䪤꩓╦ ﺀ௾興₟젠舋ﺀ࿾ ꣪ꪪꪮꪊ깎萨  Ӳ䤤鉉⒒䤦鏉쓰䀄 ﰄ࿾ᆃᓟ 翅ᑟ䐌 Ȅ ﹈䓼䡄ﳤ膎 Ăဿꤪ咡௾ꄊ⣤䆂 Ȏ䀨⋾ﺉ⺒⿢အ⳾ ︥≾纀໾┢縥ⷾ ĂုꄊႯꉂ䐨ꋲ 簤䉤╃䓀恀ሁѐ⣸ ᄁၿ섐ᄏ︠葄鐢呅䃀 Ą၏䤤呁۾섄⡄䶂 ℂ僽⩏쑁䮔࢏접䍢 ︡࿾⒂챷ꘀ꿪ꨫꊆ  ﺈ⒂ࠨ﹂耨䊄⪄ꦎ ﺡА䄊ုꄂအ೾ ĂႯ䤪吡۾ꄂ⠤䶂 ﻱ૾⒎찷ꈀ忥䪗꤆ ࠎ肯䪪꼚ꂫ猪⨌ Ѓ脈ﯢ鉊毼⁃ﰠ䈌 "+CHR$(13)+"⿾鄯纕⥒￠@䠂 ᄁჿ￡ဿ䰂翅ᑟ䐌 ꣪걎ꢊ걎萨 ă၏综䉼둊簢迎 ꓬꪮ蟼ᄏ︠菸 ꓬꪮ蟼ꂣ侞 ȅ⃿疀ꙿ쑀翠ɕ⥖ 〬䤬鉉⒒䤤뉝搐 㺜䔈࿡ਞ肈廤ꢖ訾 Ѐ䁿쁀ᔏ︑Đ翀ꀲⰞ Āჯꕋﻤ䩄꿪⣤ꆎ ਂꐪ迾ᄁၿ쁀￠퀴豆 ﱀ䟼䀇﹀◲儥ኟ⠌ ऀ选߾䤤鉉⟾䤤鉉⟾ ︤཮∢ꚤ껊㈤˾ ︄@Ѐ䁿쁀р䈄࿾ ︨⾂⮢艫ꚪꪪ먨⊆ ಯਐℏု焊ႡȐ ҂䠿俬鉉⓾䄄﹁׾ ąჹվ浪銩⾒∯ꈠ侘 Є䁇牀␚两ˠ䀘 Ѐ䀄࿾萨䊄⡂萨丄@ ၇䋷럪別⿖  ᱾Ѐ䀇﹁А䄈ႁ ȁꁣ䊧蒈䥈钊⃂ ȃ⁋甆⫸興ꥊ鐢⿂ 븠螼₏︑˨䁫耐 ₂ࣻ狊䨿耀￠䁄䣂 蟼訢䠪芈￨銟⠆ Ȅ⁻礄ﹹ⒒礤ꊊ⦌ 뺠⾔規Ĥ￠䀤豆 ᄁჿχ쁀߾䄈ႁ ᄁჿ￨䊿ꡂ贫䪄⿾ 㰤⾀១ پ뀢舠䈘 ф䑟ⵢ䑏였၉䔲 Ɏ␏࿮鈉⃾ﺡ໾  ేɀЀ绤芈⢂ࡐࣾ  Ȉ彈䈄߼Є䐤迾  㳴⦀韩ॾ逩˰䀘 㹊⠾諸⋻ꪪꨢ侲 ࠀ耈࿰ऀ选ᄁሡⰎ ﰨ䓼䡌ﱈ䒄忤H䔂  ?䀩™ሡ䀘 ﺀऄ袈傂ࡐ袉Ҁ࿾ Ђ䂧䠪爥♒ꜢȠ䰘 Ѐ䃷쑄䑎葈萈䄎⠌䌂 综ੀ⟯숤≾各삄ࡾ ᄁჿЏ︄@翄р䟼  㻺ࢪ直ꓺ䣪甆뉊া 뺢ྪꊯ꒢侪પ눊̾ 貣ྠꈏ뺢侤੊ꐊ䍾 ȏꂣꐯ㪢꾪ப興䌘 菸₃興￠1谆 菸⒏ﺄ⯶Ё⑐⣸ ހ䁿忄䡔藾䀫ﺈ茆  磨䬒꿊蒯쪄꿊雨胦 Ѐ䃿訡⁣쀀㾀䀄࿾ ︩⓾䤬﹁Ӿ䨤꩏ꒆ Ѐ䃿㾂䠿聀￨䪿꠆  ﹉⋾ठﻡ˾⤢멐ࣾ ﺩ⫾줪ﺡ૾ꨬꪏꢆ Ѐ䁿쑄䑇ﰄ࿾萯︄@ Ă逯⻢ꩮꚪ꺪訪 ≊꠪甆⫺ꈪ늪⨤⽂ ﹀⟾剄ꡟ忩ʟ ﹀⟾䄄鉉⓾䄉ኑ⇾ ﹈⻾䢄ꩊꚾ종䩔걾 Ѐ䃿ሇ﹀⟾剉ﲢ⏾ Ѐ䃶⅔⒌였߼䁇ﱀ䟼 ⣺蔨皢⳺誨廒⫺ꈮ Є䒿ꕔ￥哿㾂ࠠ菸 Ѐ䃿ሂᲑӾĂﱁ৾ ∄⚋辢误ꂋ诠R䢒 ﺩ⫾줪ﺠ௾꤬针触 `ᤎ两聐￠퀴豆 ︊߼䩄ꑿ쁀￠퀴豆 籄䣾꩎⿪ゥ䊒 脐ฏ빉└￠퀴豆 㡌衊﫴艌굋否⽂ ď逧꤯銪⾢⃏耂䤒 ﰄ俾р䑿삀㿍А䇼 ᄁჿ翂䠿艈￠R䢒 ∂꼪ʯ⨂ꀪ⪔⽂ ɏꐨ迾⢂裻碌﹈螈 ﺄ⿾⒃艈㾀䃿 ⿴▂哽−紬居ߐ ခࣼ脈ႏꄉﲁࠐ迨  ỽ≒䔩鸄࿾ᑎ␡蟆  㸢⾢ੁ⠢䜢ꨢ∢술 ︢ф䢌偂◾䄄鑑␐ 縠蔾刭繚┾別빂䓂 쉉⒒䤯퉉⒒䤤芈⢆ 興₂࠿脠ሁ∢ⰾ ȏꀃ䩇领栀㾂ࠠ菸 Ѐ䁿쁀Џ︄@翀䀄࿾ Āჷ䄄ﻡА䟤ჱþ 퉉⒒ﴤ銈恀㾀䀄࿾  绹−稢⋸쁀￠ꀱ谆 䒈䠏䒈䠄芈䢈 ﹀⠤Ƃఐ䟤၁Ӿ Ѐ䃿翄䑿쑄翁⑐⣸ Ȁⁿ翤鉿濉䒇莆 ₂ࣻﯢࡿ쀄翁⁐䣺 連⏯ꊊ⾾Ё⑐⣸ ﱈ仼䡄ﱄ۾鉏Ⰼ ҄䡏忤遏쿄♄ⶌ ȅ⃻䉇쒅乔꒎䠉䌢 菸₃࿾ᄁ䣂 Ăဧℂ﹡ؐ럪အ˾ ﺀԢै၏忤⢄䦂 ࣻꢊﻸ誈ꯪ裸聾 ā铯⳯砤♾瀊纤≾ ﰈĐ∁䠈俾Ђ䡄䡂 繀⤤晁༐⟫Ⴁ˾ 䡄ꥬ繄迌▫梤艾 ခ㳾䕆翅䓽脦⒏︤豆 ﺑ⿾ႇ점迬Ⴇ점迨 ᄁჿ翁ࠟ๎Ѓ࿾ ᄁჿ툩⊒ﴢ鉈⒆ ࡄ䠡࿾萫﨤艈㾀䈄⿾ ࠀ輈߯ࠀ耈࢐輈 䘇轀Я縀~纔⽾ ȅ⃿疀꓿翂ࠠ菸 绸∤力誈ﯢࣸ艾 븈蔾㈬︢∾諸㸢係 ďꀇ쥄埀䓷￢ɕ⥖ ᄁჿﰀ࿾ႁࠣ䏄  がठ鋩⊲ⵢၐࣾ ࢗﯪꋺ⪾⪤骘 ခ숑⿲鄯튑⯲줣ꋌ⌦ ℂᓹ∐￨郹䢔ࣳ䋂 ခ㳾䕆翅⓿聆羀䃿 Ҁ袞Ἡ≞ꂊ久⒂꣒ Ď咩⨐쿪芯꿬ႉ䤲 帨ༀ∂幬䝄ꑊ䐤䉌 B䟬䑙䐐忤ぅ䖒  ?쉄䑄䠄 ਁဠ谆 ĀႏĨ቏Ă⡄䦂 ࠀ麞ꒊᴨꙝ$忤ₒ䨢 Ѐ䃿耩ᄁࠠ谆 ࡇ繀ྀ⏪ꊪ∾ Ȁ䀈߼䩄ꑊ䒤䩄ꑊ俾 ĎဏĮሏ⢤侂 ﰠ䈄㿂Р䏼⁂р䐜 䠤葾䢌血藾䂄ࡀ萈 㠤䓾儌﹉⒒俤၆薆 Ȃ鈤䗾䒍﹄䓾灄ﱈ⓾ ࠻俭ਜ਼濥ࡘپ ႁჿ羁⣿羁⁒䤢 Ђ䐤蟼ए︐菼좠蠐蘰 芅⿒ℯ튥⩒ﴢɘ⡦ Ȁ⃿꿊蒯쪄ꡊﳠǾ ﺔꥒ뾨ꋿ꺨芉⿾ 뺠⾒襏袡迦Ѓ࿾ Ʉ⡏埥⩟⡆쒪 Āჯ忨ዧ꿤ၠ৾ Ѐ䃿㾀䃿翁⁐䣺 뺩䮨ꤪ뻽䔒鐁⑐⣸ ࡄ䠡߼ᄏ︤跴Я︄ǀ Ȅ鉄俾䒅﹄䟾졅ﱈ⳾ 砨俾ℂ﹩⚒꿪ဦ莆 Ђ䀧⿢⡧럪䠤艾 Ѐ䃿ሏﺡ⏼䐏︄@ Ѐ䠄䁀￠䀄 ਁဠ谆 ₂ૼꈈ￩䢤迈ꕏ풦⣂ 縢䈤≇ﻒ䔤剅⑔䞄  维≾␢繴ⵂ埥⡔ꞎ 繄⥾繄⽾␫纤≆ 觸邉褈￠䁄䡂 ︀߼䁇ﱐ䗼偉ﲐ䄌 菸₃興㾁∢ⰾ Ɏ⠟࿮⨟⢦캪 뺠⾔覊⓿ꈈ㾂࠿谆  绸興裿ࣸ興 Āႏडﻤ䉾␢繐ࣾ ࡍ諽럪䠬༾ 碨䯾섊ﺩ⪒꿬ႆ覆 뺈达訯빒┾㹒係 㲤⿾ꄏ纥⽒៭ဒ蛆 㱴⓾뻚ꪪ袩俢 ﰀ ︒Ġሁ∢ⰾ ﹂׼偅ﱐ䔄忈ₒ䉢 ȁ⑿翥≞ꔪ幉⒞ꌲ ﹀⠂逥Ƞ∂䀤芈侸 ďဗ⊄伨ᄁ∤Ȿ ટᾉ੗ꅔ坅ҡꩢ  ﺈ蒾ਨ빊₢句ࢄꢚ Ѐ䃿ࢁဢňࢁࠡ䟤  维≾␢维≂⟣⣄ꆎ Ă၇≄伨ℋ⊤≾ ℄ჷ턉⋴䤨턉⊔⭾ ࿾ 㾂ࠠ菸 ĎဏɎ︈育゠湸 纔⩾쐪䊗键䪄䡲  㱼@䑂䠄࿾Ѐ䀄ǀ ︩⒒俬鉋꒪䪤멈⓾ Ѐ䀄࿾Ѐ䀄ϸ₂ࠠ菸  ໯ਐꤪ咡௾ꄊსp ﺄ⡂뾨䊟⤒鄩⿾ ࡀ轾傅ࡐ襾䉄⑾ ︪芨䪄ꡪ䲤䩄꩗괂 耈Ѐ䁄р䟼 Ȁⁿ忥቟忤Ⴟ ︪芨ꢊ交⩂꨷괂 ︀ 翄р䟼䀄ࠀ ∂‣⑂䐡侔袈袉俢 ࠠ轾₂ࡠ虾됪䈤≾ ࠀ麉◒২鉝⅞唥办⠦ ﺪ蒨䪊꠪䚤ꩂ꨷괂 Ђ庥⯲◯刯⚞椪銯∦ Ą၏ᐢ﹀೾戅繄␌ 㲒䤤䚐ཾ鈩⒑警  㸢⾢⏢∢⾾訨ꊌ⾎ ᄁჿꐪ䒤꩗괂 Ѐ簄߾䐥⑾䤈邉⌎ ĎဏЮ︀þ纤⸌ ď႟︠Ͼꈊ纤⼌ ࡈ衾ࣸ艾됪䈤⽾ ︀߼䁇ﱉ׾焅ﲑ৾ 븀达訯뺒⾾鈯뺒係 ₂ࣻ㻸⢢海ᑑ迦 ﰄ@Ѓ肈ႁࠐ迾 ︄ཱྀࠑȐ㸀 ࿾ ︡А䄌ﱂ䐤䑄䑄䗾 䀄졀萀䀄࿾Ѐ䀄@ 蔈径耈￠1谆 ︄ϸࢀ裿㾂ࠠ菸 㱊侤䯄聏D䒂 ⡄袐Ղ⑏俅䑃藆 ခ๟ꥊң梅걪咥乗薈 ︡ɾꈪ⊯꟢䈤≾ ︡ཾ∢≯럪䈤≾ 簩⿾⤢ꩯ꿪ꈫꊆ Ѐ廥◲䗤勯⒞䤤鋯… ᄁၿ섐ἁჿ੐臸 縁ཾȯ∇䊔⽾ 㰊交௎耏¤亂 Ҏ䠏߮젇䒣軆 Џ幅⓲募⬞鄯ኟ⼦ 䀄龈ࠃÀ〤ɀ⏼ 㺒ꈾ着꫻ﯠࢨ誾 Ѐ䃿₄Б Ѐꀱ谆 Ăု䑌艀ф䊄ᡆ䖂 ﰠ䐄忬䁇忤⡄䖂 簠䔄忭⁓埥ࡑ䑢 Ăု忬䑄䗾䄄﹁А Ѐ䁄䉈Ѐ䃿ሁ∢ⰾ  砠興䁄҈⢂ႁࠣ䏄 Āჱ˾™ሢ∢␣䋀䀘 ℂჹ~儨鈁┢∣Ɉ䠘  ?䠨芐™∣䀘 ﹀Ӿ䠤﹈⓾䁉ﺀ聸  䀤ɀ␂䀤ɿ Ȁ䀈࿾耨ʟ⤒鄩⠎  ᱾Ѐ䀇﹀Ѐ忉Ґ䇼  볨䪄꿫ꂫꯪ裩䃢 Ą၏籄䑄䑄䓨䂆 ๏Ҁ﹈Ԁ埤䋤⁾ 繀⼄傅ࡗ血萸 选ᄂအ࿐™ሡ☎ Ѐ䁿쁈ԏ︈͸섃︂à Ѐ䃿蠧Ĥ⑂䑈ꓲ  쁀Ѐ䀄@Ѐ䃿  ﻱȐℂḢ∢␣䋀䀘 ᄁၿ섐￡ဟ舖弉䇼 Ѐ䁿쁀￡ထ࿾Їﰄ@ Ѐ䁿䐄䁄҄䡈蒑ꧢ Ȁⁿ忤≿忨傈茆 Ȁⁿ翤≟午ꢒ䉢 ထĐ₂༤ᑁ䐨곲 ︠ɾꐫ䊧ꐢ縠˾ т䐯ꄊﺤ੾ꀂ吥䊖 Ą၏䀄籄䙄쑄䑈䲆 Є䁇䠤牅♒윤ɀ䰘 Ąၟ劄⩌၁෾ Ѐ䀇⑂萩䈔₃ࣃ䃂 菸₃༾舨 菸₃䉈￠ꀲⰞ ︄ϼ⑃ﰤ䏼ࠁ耦ఞ Ăု 籤䙄ꑊ䐨䊆 Ăု⑂艠لꊊᠢ䋂 ︡࿾⤢﹩⛾ꄊ倢苆 ҂䠯⿢䡯꿪鈿 ﺁАĈ၁Ă၁৾ Ҁ䢄藾҈䡄臾䀄䢈䤂 䢄葾࢈衇ߢ䉄⡾ Ҁ䢟Ῠ䑏࿂聈⣾ Ҁ䢟Ῠ䡟俤銟 ﹄⑂翤䉄⑂翠䀄@ Ѐ耿興㾂ࠠ蟼Ѓ࿾  ﻱɾ┢繵⵾儅偒蟆 ā郯⟏/殪ꪫꊆ ࢯ⿮訫疪Ⲭꈘ 繀袈ࡈ辈₊袨艾 Ă၏⡄轈┊銪∾ Ă၏艀ང⊊ᢢ䋂 ﹈꣊﹊⾢⪪直⊆ ⁂⓺䉾既␢俾≇⒤䉄 Ѐ䁿쁈ԏ︈ϼ퀁ﰀ䀸 Ђ簤ɀ￢࠿興㾂ࠠ舘 ď႟⢔轈餉ኒ⬾ ď႟⪜韉႑௾ Ѐ䃿￩኿ꈈ㾂࠿興 ℄ჷ퀉㳺䤤퉉⒔䭆 ᄁჿЇﰐǸ䠤豎 籀ࠀ﹀谈䂄ࡀ萸 ࡀΰ剟ⵒ徤䉊┖ Ҏ䠏࿮䠏銿 ﰄ@￢࠿興㾂࠿谆 Ҏ䢯꿮䢯銿 ခỿ‒䥈堁䐒⤡ሩ챐 ď逧壘ﺩ඾豏뺈辘 ă၇䣴艐ꤊ鈢⾾ Āჷ⒂䡴赐唅鉒✾ ﹈⢪ﻺ⊢ꪪ﨨⾆ 뺊⾾訯뺑⫪耩⧶ 㺜⨤쎊욐襾钎䢟 ﻡӾ䠤﹈⓾䠮︄䆂 ﰄ࿾ᔂ䣄䏺₃菸 Ѐ䃿ἀÿ鼩ኟ⠆ Ā₇쟄៉䑗ߢɕ⥖ ꪪꪯꨪꪯꊂ⡦ ℂჹɾ™ዹ∢∤芈侘 興㾀ÿ㿂Ѐ聰  Ȉ䁋切 㾂ࠠ菸 Ąၟ￥ɏ妤ⳬꀰ Ăု⅂︢;縠☌ Ȁ₟Ῡɏ妤Ⲝ꠰ Ѐ䃿￨ȿ腂晁룢惀 Ѐ䃿㾂䣿範꓿ ␂䃿甆⋿嚪☰೾ Ѐ䃿㾂ࠠ菸ሁ∢ⰾ ခ˽ℒℤ利ℒ攠舴Ⱖ Ȃ•ϼ䈈⃿㿂Р䏼 ﺀ⯺萨䊟⡊萫婢⿾  㳺䈤煮웰ɾ諸⑩試 ꠢ舾ﲊ袯误ꊊ⾾ ℊ₧콄Ꟃ䓷ʕ⽖ ﱄ䟼䑄䑿쁀￠R䢒 ꗨ䇪蘈꽂鐩Ⳳ Ȁ₟Ῡ⩟囥䢥ꫦ ﺢ諾ꪯ꿪䒧讆 蠄︑ྐꯏ꒪侴铏䒗  ?褡∤쀀Ё⑐⣸ Ђ䀯꒪銲⨄∀鐨⑸ 艸⒏ﺠ꯺₃舘 ĂႢӾ䠪舨⛾ꠢ舨⳾  ȐĀ⣢艄⠢Pࣾ Ȃ•Ƞꉫ뢢ਠꈊ⊺ⰾ  ﺁࡾ纄⡾鐧縂䃂  舄徨 ϼ@Ё胠 ﺄ⡂뾨䊎⥒꒨䊀⿾ Ą၏﹉⒒俤ს 빒⿾刪빊䬺Їﰄ࿾ 繄轾咅晐ॾ繄⑾ 縤≾됪슧ꔢ䨤䉲 빒⿾刪빊䬺Ё⑐⣸ ﱂ߾䈅髠揼⁃ﰠ䏼 ﱀ䟼䁇ﱂЦ箄⁂⾾ 縤⽾␢䉧딪䨤䉲 ︩⾒⿢鉩⚺굪鈩⋾  ﺈ⓾ࠨ﹈肈໢衈꣮ Ȁⁿџ촄必⚑视 Ȃ≂⥾≊⾾∪ꊪ∾ ﰠ䏼⁂п술∢ᐬ輆 Ā⃯࿯鉉⓾蕊哩₞ Ȃ⚻訠ꈫ㾀 ࿾ Ȃ‿䐌䁏傅ࡀ蓾 ﰀ䂄р⠀脐਀怙踆 Ȁⓤ䯾ꊊ⪬樼걊䣣臆 т䠯꟪Ⴏ꟯蠀胾 ࠀ胿ခ℄၁Ǿ ႁჿ翀䃿㿌 ߾ Ѐ䃿㒌䘿興㾂ࠠ迾 ĀႁҔऩ၁0"+CHR$(34)+"с裠 р䣯䟮၏䟤裠胾 Āჱɔ┢遱ര倥ё蝠 Ў䀇ऎ鸁Ⴁฐ ă剅䠐䋷럪"+CHR$(34)+"佂 Ą吩⠰䣡瀢࿾ᑎ␡蟆 Ѐ䀤艈㓄튆⁀翀䀄࿾ Ȁⁿ䢅呢␠忨₂Ͼ Ą၉五䥅婓␐၁෾ Ăဿ俬ၟ俄葏윆 Ă鈩⓾䑌﹘蛾䢄﹈蓾 ︄߼䑇ﱄ䑄￤р䐌 菸₏﹈߾䩄ꑹ賦 ℂᓹ∐⟯送䀔袉俢 Ѐ䃿뾡ჿ彈䈄࿾ Ѐ䃿翠䠿肀￡ࠟ، Ѐ䃿翁ထ࿾Їﰄ@ ꈢ䥈䐀Ȑ俨ဃ䋒䄈 Ȁ ࿾Ȁ⠃`ᨎ à 既⺔䑄A۾쌄呙Ⱀ ᄁᑽℐ￡ࠐ꿪ᑃⓑꅢ Ђ簤࿾﹀꟪䡊꒪ꦒ Ȁ₟҈硘惼䡄ﲐ䤄 ␤蒐⒁␄Ʉ䒀ꀱ谆 ﰈф₀င࿾ഃ䣄恀 ﹀⟾䈇깂ޮ侉₿ Ȁ⃷숤≂䙵ഐ忥ၑܐ Ȃ₻븮Ḁ࿾ဃﳠ䏼 빈⪔ႂӟꀀ翀䁄䣂 Ѐ䃿ἂ࡟樄㿂䑕䕔 繅⥒則┫劥≾ ᄁჿ翄萤耐￠퀴豆 ᄁᑽℐ￡ࣾꄊ⩎ꐤꜲ ᄁᑽℐ￡ࣾꔪ繅⓾ꄲ ⪴쪊䒫ꨀ꿬ႉ䤲 ခ˿⑒䤣鋇⟒䔧튄⡆ ࠀ胿ᄂုꄂအ˾ ⁂Р佾⁂ౡ䘤둊Р䈜 ﺑ⿾ਏ븊޼ਏ븒ؠ O蒈俾衏蒈좔懲䑐䢜 ﺄ䑄с︀䀌䍅쒀䠜 縤ɀ䐤䉔╃裁䃢 纤ੀ쟊䒤䪔ꥌࢃ䣂 ﹉⓾襤鉏䩥ⓤ䁄 ࢂ蠫⊢繪Ɦꯪ젨芈 谇Ǝ︐䏼큁ﰐ䄌 ࡀ䓠諾ꄊႿꄎ⠄䆂 Ăုꑊ芯Ꜫ勷  Ą၏艏伤鋯  Āჿ⑂艿圥剗✆ 㲜伨⯫俼䂇﹀䪬 Ђ䀧䤌鹁А䇤၁А  ʥ⪒ℯ튅⿒蔯슄⣆ Ѐ䃷餉ẑऐ釩ჱ Ąၟ䒅詇폤⁃ Ѐ䃷餉ựऐ釩ჱ 蠄븒⾢⏪ꊪ⪾諸≄⑆ ︪꾪⪢ꩯꪪꨪꊆ Ѐ䃿ሆ␿迀耏 Ȅ⁻Џ︄߼䑄퐴豆 Ѐ䁿쁀￨銒≄翀䁄䡂 Ƀ⑇既绸ɾ됪縤⿾ 別⽔⁂⁯ꑊ䠣苆 ࢓ﻸ誈ﯠࢨ諾 Ȅ⁻⒂䣿⒂砠Ͼ ꂊ澸訏ꀂ⾢⇫胠৾ ﱊ䒤䩄꓿䩄ꑊ䐌 슅⡒ﴪኡ⿒ꔪ䊬∆ Ѐ䃿ꪣᣟ怀￠䁄䣂 鉒么剄鉂ؾ찤⑁賠 ﱈ仼䡅﹊۾쪤꩎춲 Ąၟ媤䑛ꘀ၉䴲 •ྠ∂⁢ܠꨪ∢∾  뱒䈤剈䘠ཾ∧⒩艦 ᄁჿ￪Ⓩ꯬ꢐ襾 Ȅ⓲䕾咉︤轈⟧䢬艾 Ѐ聿쐄翄ѿ쁀䃿 ࢗﯪ裿ﯠ⊫ 꼪庤詎ꚪ튥≂Ⳇ ࡇﯢࣿꯪꈣ ć႗琢싸ઢ鹿ࢩ䫢 ﱊ䒤䩄ꑊ䒤䩄ꑊ俾 ﻢ訨꿪ꫪꪪꫪ싨⃾  쀀 ?耀  ࿾ 蕔꒥吤蕔萯︄@ ࠀ逐蟼Џ︈茔옡蠃π  䀄@Ј䊄⡂萨䊄⿾ Ȃ␤䋾ꄋﺢ詆릂戠싰 ઄ꡞ徤ɞꜪ⑞괲 刅⃻ﱀ䓹䢔裹䣢 Ăሯ⟢ၯ녊ᠦ莆 ࠂ⫪몪咩≔忥ゅ䦒  ﻪ꒪䪮꩟䪤ꫪꂆ Ѐ䁿इ﹒׼刉ﲂϾ Ȅ⁻㾂࠿興㾁ჿ Ȅ⁻㾂ࣿ핧ﰤ豆 ︄߼ँ䠿칊⒃宅⿾ ю䐎໮䐏䒧쾆 ₂ࣻﯤҿꈈ㾂࠿谆 ȏꐤ䉾壘钮涜蹏ꒉ迦 䀇빀➔즃迼₣侞  ۻ舠見뻺䪤既⓼䉄 ခỿ՞問퐒䟼䁇ﱀ䟼 ď቏矩႟⅂ᡆ覆 ĂအА俬၁А䄄၁Ӿ 縠␄䂌ࡏ䂄ࡀ萸 ︠␂伬ɏ⒒䤤␆ Ăု俬鉉⓾䄄い薆  ˽−ℯ튥⩒ㄦ芤∆ ﰀ䀄籀Ѐ䟄䑄䑼䀌 Ѐ䁿쑄䑄䑿쁀㐀쀳ఎ 뺈⾂ί芫ꪪ着모⢆  ÿ鈩⊢Ⱎ耨˿ Ѐ䀄@￠䀄@Ѐ䀄߼ Ą၂⽂埥Pॾ䉄⑾ Ą၏儅繕⥒剅搐 Є䀧⤄⢄悀￡ࠟ، 耐Ȁ䃿Ѐ䀄ǀ ﹀⟾䀇﹑ג旉傉⌎ Ѐ䃿Їﱄ䑄䑄䑄쁀  ﻱऐ韯劅⽒锩劕漐 Ѐ䃿Їﰀ@ȁѐ⣸ ﱄ䟼䑄䑿쀀Ё⑐⣸ 䘧轀␢縠;縤♾ Ѐ䃿Ѓ脈ऀ怙踆 ȏꀋᑂ䐡侔₂ࠣ䛂 蛽蒐礄鹹⒒ﴠቒ⢢ Є䁇䥤婷◒镩倔☾ ๿Ђ㿠?숄㿂Р䏼 Ăဿℂﱠ䙄ꑊ⠣菆 Ѐ䀄@Є籄р䐄䁄࿾ ︢Ƞ㨄ꙋ誠ሁ∢ⰾ  ᱾Р䈄ⁿ䄄ࡌ輆 Ђ뺮蒨䯪ꛪꪢꨪ Ăအ༐ᔁ帥ِ딂倥˾ 郡Ȑℏꀢؤ瑊䒨ꋲ  耑Ƞ᐀蠐俾Ђ䡄䡂 ه襈䡇⑋䒥ꋢ Ȃ₻븮㸒Ʉ￠䁄䡂 ĎႿﲠ乄ꑊ⢣识 䚗襀纐ཾ鐩纔⭾ ︈Đ₇ﰄ⁀㾀䀄࿾ 縤⽾ᐡ縤♾늂⠤ꎎ ︀⸂༮ȏₒ⸆ ĎဇĎ︀䃾䒢丌 Ďሁ⻾ࠏ聄䒯⸂ ĎဏĎ︀ 芨๼ Ď逅鐒 䊤⹾ Є䀧ኄ䒿ꈈ㾂࠿谆 粔佼鑏粔ॾ䩑⢬ ं鐩䊾ꩋﺪ䪤ꯪ꒺䳾 纐∂˷ꥊ窐⺆ Ђ簤࿾⒉劄⯺谩劤꿾 Ѐ䃿⒇ﰄ俾чﰄǀ 萨䒤䥌葈䒈䲇ᑂⓂ Ăု䄍﹀䗾䁄䑂䐌 ﱈ䒄俄葈䓼ऀ鈑⸞ Ѐ䃿뼠ဂ@￠䀄ǀ Ѐ䁿쁀Џ︁࿾Ăထp ႁჿ兂ࡉ⾾Ё⑐⣸ Ą၏䄄﹀䛾쁄䑂䰌 Āჷ鄉ﻰ䧾遉䓲䀌 Ѐ䂇ठ鐁䊄⢄䦂 ࡀ䒀藾ш衑⇞䑄袑⧞ Ȁ₄⒂࿨@þࠢ艈⣾ ︤葄￨䋎歚칫嫎桂 ﹄俾떬곦Їﰄ迾 Ȁⁿ 忤҈䡌 ࡀ䓰苾⑂衱ⷾ剅䡙⛾ ﰀ ︄@⒄䒄⃀ ︄￩⊒⤢鈩⊒⠆ ︠菸₂࠿興⃣耈 Ȁ䀿숄⁃ﰠ䈄㿂Р䏼 ᄁჿ႟鿩䓲䀌 裧≏︠興￨袈辈 Ȁ₃Ш艂䀔䂄ႆঀ Ȁⁿ翤鉿巩႗⎞ Āሁ⿾Āࡼ脈၁О⸂ Ҏ䨟꺨૯ꃪ껲 ჻쪤ꯊꓻꯪ苺ꂮ Ȅ⁻₀ ϸ  ࿾ ࣸ舾着꫺ꪾ甆⫺ꈾ Ѐ䃿Ѐ䃿ࡀ䠂 ﰄ࿾ꔩ䨀࿾Ѐ瀄쁀 ခĎἏĀခА䃼 Ȁ⃲द鎉ठ鈉⋲‾ ℂჹɼ聾呓侔⋏ꐤ≂ Ђ䀤ϼ䐈䃿؀逰谆 Ą၇工桔觾衉䑢 Ѐ䃿뾠逐蟼Ѓ࿾ ﱄ䉈￠퀴谆Ё⑐⣸  ﲈ䓼ࡈﱀP唤풅৾ Ā႟ऩ⡄䂒䕄ᢉ䤲 Ȁⁿ쿄遑෾䄄⢌䬂 뱂߾鉉␿興㾂࠿谆 Ѐ䃿㾀䀿聀￠ꀱ谆 ᄁჿ﷤鉉俔į튅쿐 Ȅ⁻⟥ꑑ赶儅﹅䖒 ︩⓾䤬鉏䅅䉤м Ȃ₺樸ꈋ￠퀴豆 ᄁჿЀ䁿쀈䄄悸ࡾ ﹀⟾則﹊蔤뿨蠏܎ ᄁჿቅʏ耀⥊务ǎ Ă၏O⮪ꪫꊆ  豆㾀䃿㾂ࠠ菸 ﺐ⧺ဂ?耈￠ࠁà ⁄Ӹ䣾蓺䢔葈䦌 㱄⺈䟤ࡏ쟤䉄Ȿ ∂⃻⑏쑑䵔咅䢑䭢 ъ䠔䐢伆⇊䈄 ࠀ葿肐￡࠿贈ᾀR䢒 ₂ࠠ辈௡ࠠ蜈ꢂࠠ艾 Ă၁ࡔ遁༰‫ҡ苠 Ѐ䁿ҏ︈Ǽきﰐ䇼 Ȯ䈏⺞༮鈏ꂖＪ助⼶ Ѐ䃿翄䑿쑄翀䃿 Ā႟ῡ⓳숀⪢꩐ࣾ Ăုꨪꂪ澸∂ꈪ⾾ ⒔䦏퐉→⤤鲉ΐ ɂ␯䉌﹀Ѿ䐤繄⑾  ?䀨芈⁂РȀ䀘 ﰠ䈄⁃ﰢȠ䄄ႀ蠆 Ђ䀧⠢艢☒뀪Ƞ䈘 Ђ䀧꠪舢−値芀䠘 ︤迾鄯ﺈ俾詏钐仌 ȏꀣﰪ芪ⶒ蠯芈侘 뻢⊢눢㻺舨㉆꒤≂ 籄䡼维ɾ늪䨡⾬ ᄁჿࠏ︈Ā㿍А䇼 Ѐ䃿ꏣ萠俔⅊袩虦 븈₂ﯨ⃻䤢詉⬬ ᄁჿ翡?촄῁⑐⣸ ࠀ䀀࿾Ѐ䀄߼Ѐ䀄࿾ 쁋䨤ꉹ䒔䢇飊䃂 Ѐ䃿脠ჿ℁ခp  㱼@Їﰄ@￠䀄ǀ Ђ䀤ϼ䐈䃿ഃ䣄恀 䡄葾璉ࢗↂⱌꠈ ĂႯ䠪Яꑂ␠䰌 䣴艾⒂ࣷↃⳌꀈ ﻡ˾⤯︩⛾愊ﺡ˾ ﺡ૾ﺩ⻾ꄊﺡ૾  ﻵɞ✯툥䍴궪ደࣾ  ﺂ萨࿨ꩊꃎࠢ﹈⣾ ₁ࠁ࿾ࠃ菸₃菸 ︡Ӿ䤬뙀׾䄄﹊꒪ 䑈ℏﺀ⯺ဎܜ  维⥂鐩纒褨銉⫴ꆎ Ѐ䃿㾀䃿￢ࡈ聘 既⺔䑅﹐⛼쑄䡃跆 Ȃ∯⼮⼢ɯꚖ꼪別⋶ 既⢔﹈⽼⑋䢣苆 ﰄ࿾ꔡ䣿翄ꑊ䒬 ﺄ⡂萨䊊⤒ꂨʀ⿾ 繐│別≑䔔炍᠒䇂 ﹄⑂弤䉟ꐂ弥ኟ⠆ Ѐ䃿鼠 ߼Є䒄⃀ ℂዹ⁾龜邉辨⊋⪤Ꙏ ∢∢ꪪꪪꪪ∢≂␂ Ђ䀧䩌ᡑ敠僅灀擸 裢ꈪᡶ䨂Ё⑐⣸ 㰤⼀ 縠̀䈤♾  銉⒒ऩ悒䤤銑⤂ ﰄ࿾ഃ䣄柰ী萐䘸 ā郡ɒ┮鐩䘐犊⢤䎂 Ȃ⁃ᡆ漐⃊삣Ȏ Ă၏ቇ⮪횫ꋖ 빉⊊䤩ꘄϼ⁃ﰠ䏼 Ѐ聿쐄翄ѿ쁀￠ꀱ谆 Ѐ耿숄⑂␠俾⑂䑄䐌 ᄁჿ翄䑿쑄翀꠲ⰾ Ѐ聿쒤䩏︑Ȣ쵀䠴䱂 ሁ⃻￤艻￡ⓡ菆 ℂ鑿翥⣿翂ࠠ菸 ҏ䪞ꤞﺂ꠪쫴땊咥俦  㻺∾ﻺ⪾諸㻾∂  ﹉⊺ठﻨ⊺⪢㩐ࣾ ႁჿ翄ꑒ䘜䁇ﱀ䟼 ꨢꈪ着ﺪ궪誯ꪌ꾂 ሁ‿와뾂䀿聀￠퀴豆 ďꀯ￪銩ⷾ襏뒍⾎ ࠠ萈俼ࡀ萈䂄ࡀ萈 Ȃဠ׾䄌၁Ӿ䄄၁׾ Ѐ䃿ँࡿ섢ሁ•Ⱎ Ѐ䀄@Џ︄@Ѐ䀄@ ࡂ䑀裾Ă၉ಞ䤄遏܎ Ȁ⋿∢⋹䈔₄ᡂ䓂  翀쐴聀￠퀴豆 ࢀ萈࿨ࡀ耈ࡀ蠈 Ā邉उ﹀䒄䤂 ꒊ言꾈꯯袨辈ŏ钊⿂ т⑈襾䡈辮⪊ꢫ苆 ﰄ࿾⒃菸Ѓﰄ࿾ ă၏䓿ꈪ늊⠤꾎  㸸∂∯ꈡ䪔ꢊ頢䛂 ﱀ䟼䡄䕔卄ኆ⦂ Ѐ䃿뿢⁏첄俄葈䓼 ࠀ麎⒂ࢫꂄ婄ꒈꦲ 縤⽂ᐡ縢蘨늂⨤ꎎ Ăၟ䡋⯪ꊪ⊾ Ѐ䁿쁄￠䑿않䔧ﺕ⩊ ℂჿ쒔絁⓽≊Їﰄ࿾ ℂჿ쒔絁⓺䉒撠R䢒 Ѐ䁄䑄䑇ﰄ@萨䊄⿾ Ђ噅ৰӢ䉄ⵒ唥剄⑆ Āᑁ⋼Āქ䊒ℂぐࣾ Ȃ␤䗾䊌䩘搼䱄䡃藆 Ȃ␤䏾ꊊ⪬樼걊䣣臆 Ѐ䁿㿀郿㿍ਐ臸  ﻥ⩔￪芯亞꽋ᓣ Ȅ⑄俾⊊⪬樼걂䣳胆 ﰤ䉈￨ɸ蒼窈ꠗ ȏ⒤俾ꊏ⪬漼ᱍ䠓蛆 Ѐ䢄蓾ँ︉俤邉ࣾ ُ袈࿢衋䯥≒␾  ?䀫⏢∣䀘 د辈⿢衫꯫∢∾ Џ䁇砩犕╲┢牀䠘 Ȁ₟࿈葏쀈䄅ﺁࡰ ҄䠯俀逩Ӿ萏︄@ ꗮኩⅺ儥窑⥺  ᱾Р翤 씄忉Ґ䇼 Ă၇剅⽾ℊ邩∞  呅䉔઀꣥䈪⊢Pࣾ р䢟࿠ꫬ⿢䑒䣾 蠧ﯪꊫ袏ﺈ辘 繑վ吥織╾吥纂䣂 䀄{쒤䩈꒒䕄⑦ࡾ ﹂⼢ሡ∢⑂艈䐘 蘃耠稄빊䞤䉄䒄䠄 ﱀ䟼ࠧﰈ迾၃ﳐ䇼  ﻪ꫾ꈪﻢ课ꐪﻤ⁾ Āႏŉ﹂~䰥纄⡾ Ȁⁿ䢇﹈袈辀R䢒 Ă၇繉྾☪뺪∾ ﹉⟾ࠧﰈ迾၃ﳐ䇼 Ѐ䁿쁄￠䑿쁀￢ࠠ菸 ᄁჿ翀艿삈￣Ӑ䇼 ᄁჿዱ䁾ﺒ⼾ ďဇŏ縁>뺒⼾ ď႑৾ኒ⼢鐩䊐侘 㹈⠂諸∡侔₊袩䙢 ࠀ耈࿾ႁࠐ舐㄀踆 Ȁⁿ俄ࡁ׾䄨ᒁp 硈䤂࿢၁೾䄄鑑␰ ခý䔤鈱Ёѐ⣸ 袾꫺ꋪꪪ눪⿬ 碨䬂쿪Ⴁ௾ꄌ钑⠰ Ђ䀯俌葏忤鉒⑌ Ă吿和﹈⓾䠤﹄䖂 Ď劥䫾ﺤ互럪ኢ⫌ ﺀ৸选줐ꄊႁ࿾  조脈ႁࣿ₂ࡀ萈 ︂⁂ᠦఀϼ⁂Р䏼 Āჩ⩔ꄊﺨ⫾꠪ﻨ₆ Ѐ䃿ᄏﺑ⨒ኑ⧶  糴䥼鑉粐৾逩ﻰ⇾ Ђ䣿儇⟾₃菸 纕┄៥䒒쁀￠ꀱ谆 Ѐ䃿ᄏ︈࿾ႃဟฎ 籄佼呅籐৾﹈⓾ Ѐ䃿ᔇﱀ䟼䁇ﱀ䐌 縠⨤楂䀠䋾恊䐢䈌  䀄@䑄䑄⡂萠䀄ǀ Ѐ䀄Ɉ⑄䊄Ä「܀ Ѐ䁄䉈Џﺀ⧲鄩ኟ⠆ Ȁⁿ䄄၏䄈ႁǾ Ȁⁿ䈇﹂а䚈꒲† Ѐ䃿돪⓼䡔䣵裦 ခ˾䉈＄䉼䑈簁˾䄈 @䰮葄彈䊄⇀ Ą၁๔䤤၁ذ쀤с賠 縡⼒∢䰠;䈤♾ Ђ䣿ᄇﰄϸЏ︄ǀ Ą၏俤ቇ짤遏༎ ﱀ䟼䁇ﰑĐ￡အఐ ﰠ䏼⁃ﰀ߾䀧﹀⟾  绱⤒鈩䳰ॾ鐩䋴⁾ 菸₃྾訯뺊⾾ 㰠佄␢艪☠ꑊ䐨ꋲ Ăဥ⽔ℂ繤♾됪縤≆ ࠯⿢䉧럪࠯ ɂ␧⟢䡧꟪*ꊪ  ﺂ␢Ш豀~Т䉄⡾ Āႉ⑔Ĉ﹈⃾ࠢ﹈⢆ Ȁꂋ쒠Ῠ⁊䄢䘄ҁ裠 ခ㺒⟢Ꮹ≒↾嘥⊒⤾ Ăု뿪䒤䋾劅⢄ꦎ ᄁဿ술翊‿술㿀R䢒 纑⤢ߠR䢒 Ȁⁿ⁂഼刅ₒ௾ Ѐ䀤䉂䴀‏쌄А䇼 Āჵ≔ℂ繴⵾吥織❆ ɀ⓷⿢䡷埥ZꜪ т␠轾ႁࠧ낂縠興 ȁꃣ⒏ࠢ왊梪ࢠ舸 Ѐ䁿섐￢࠿興㾀䃿 Ȅ⁻က㱼@￠ꀱ谆 ĂႷ⒏䠧梊袠艾 繁⤒䱀ཾ␫䊤≾ Ѐ䁄䉈Їﱀ䟼䁇ﱀ䐌 ᄏ︑ϸ₃蟼䁇ﱀ䟼 ᄁჿ⿪≩䉄⿦Ҥ䈬 ᄁჿ㿆₿술㿀R䢒 ৰᗣⷲ䐥◶ Ђ䣿뾢࠿聀￡ⓡ菆 㰀乄Ю舊†䒨껲 ︁ฐĎ倅傥໾ 縁⸒Ȯ䰀~䊤⹾ ࡎ䐀軾Ďဇﺡฐ ࿼䑄䑿셈攁꣢惀 Ђ䣿鼠?興㾂࠿谆 	繕℄埩䐒俾䩇㱀䟼 繈蠈⣺ꪊꠢ迾 繁ࡾ绽≾넊縡࿾ ă၏绽≾딪縡࿾ ĎႯ쿪芯꿬ႏ 裺꒬碂㻺⪾諸㻾∦ Ѐ䀄@߀䀄@Ѐ䀄࿾ Ȁ ࿾Ȁ‒ Ѐꀱ谆  吤葄萡쀀࿾ ﰄ߼⒏︤艈翀퀴豆 ﺀ⠂ἁထĐᄁሡⰞ 숑⿒唯퉕╒ﴡȴ⴦ ੏꒪䩄ꄲ ﱈ䓼﹄׾䒤鋲⁌ Ąၟ䡏忤哸胦 Ą၏埥ꑗ⩌䑲 Ђ䣿鼡ဟ@翄䑄䑌 Ăု꟪Ⴏ꟢䈧 ﹄乼䑅﹕⑄쑃跆 肐؁飤恀翀퀴豆 ࠠ轾₂ࡤ蘨놊ࠣ䋂  碈蔐࿨቟俤ႁࡰ Ăᐡ⨐濢အȐ把⠤䎂 菸⒏ﺠ꯺₃迾 ā郯⿯␯濪⪬䉲 ᄁჿἎ⸤葄뾠R䢒 Ďဏ߮ꐇ⪬乲 ď၏꒷鿯⪜佲 ă၏绹Ȑ뗪倧ྎ ﻰ⧾镉咗줐鿮鈫ꊆ Ąၟ䑗아呅糰Ǿ ȇ₋뻺ꢪ睊⪈ Ąቁ⿾䂄࡟虄쑄䑟Ⰲ ࠯⏢ꉫꨪ븨˾ ࡏ珩⊓⨢빈ࣾ ︪꫾ꠊ︪ꋺ別⪏꠆ ҂䩟ꢨ껪⩊ꋲ ҏ䪯꺨ꫫꫪ꩎ꋲ Рￄ䑄䟼䀄ɀ⏾ ࢐艾ﲪ䫼ꩾ꒏쪄ꣾ  Ɉ翊ਿ興㾢␡辆 ࢈艾ﲨ䫼꡾ﲉઈ꽾 ﹀߾剉ᢼ怈￠ࠐ肘 ﹀␂翤䁄׼䑈䒈䌆 Ăု䤬﹉⒒俤၁А 縠Ӿ䀌繀Ѐ䟤䉄⑾ ﰠ䓼䁍﹐⓼䑄䡃藆 ﹀߾剉ᢼ怀㿂Р䏼 ﹐ོ倅_䩄䓲 Ѐ䃿俄ӟ俌䑇薆 Ѐ䃿ᔏ︕ϸ菸 耆 ѐ䔂逩ࠐ胰 Ăု꟪䊧꿢$䊂 ﹈ຼ䠄聏쪥⩒䱲  ۻ蒠䨏︢侤㉆꒤䉄 ﰊҤ⪀ꃿ㾂ࠠ菸 Ѐ䁿셐⒄䐠达₇Ცꈈ Ăဿ⿢䡯꿪〥䎒  ﲀ䓼I﹐⃼т䡃视 ﺒꔨ҉虁Ǿ䌄咙⠐ Ѐ䁿䐧﹄⑂翠䀄@ Ȁⁿ종㑬Ⱈ䘅蚁觠 Ѐ䃿㾂࠿興￠1谆 ࠧᒡ縤Ꙋ럢ࠠ興 Ѐ䃿㾁ჿ翈툔虄 Ă၏﹉⾒⿪ႡȐ ﹂Р翄р䟼䈄⁂߾ ᄁჿ 䀂Ą倩䃼 ᄁჿﱤ룾Ⱦ暑⑪䩄  㻺Ⓘ䨯︢⾾ㅆ钢䋆 㠄亂Î瀀ʠ칰 Ѐ耿興㾂ਿ숈ﾀ蠰谸 Ѐ䃿ᄁ⃿Їﰄ@ Ҁ䢇០䣧⒂繐ࣾ C葄䠄ﯢӼ䈄ꡊ萠俄 ﰄ࿾ꔩ䩿翥⒑识  䀄@ЀꀊĐᄂࡀ䠂 /䀌@Ѐ䀄O ︈₂⠡興⃂ሡȠ䰸 Ȁⁿ翥ၝ씒編₂Ͼ  㱼@Ѐ䃿Ѐ䀄߼ 菸븢⾾︠脘 ႁࡿᾁࠐ迾䤇Ṁ߾ ﰠ䈄㿂ࠠ蓄䍈ʜ‸ 뺠⾔袏ﲠꏸ₃舘 ﰂ两Ɏ㰎䀤⒤⾂  ﱂ䈤ɀﳢ䈢∢⁐ࣾ ĎႯ쿪銯꿬႟ 绹┒產㋹ꪒ諸⋸䈘 Ȅ⁻︀⟢'⟦ ︊໾ਮꨎꂪ긲 ﹁ࡾТ繄⡾Т繂䣂 Џ쀧金麩ඐ觯邉ྐ ﺈ⡊ꂩኅ⠢贫઀⿾ ﹀߲䀥﹒◢䔩䪔⏦  ﹀ɾР䋧≂繐ࣾ Ѐ䃷餩ᒑऐ銏⠄䆂 ﰄ߼⒏︤艈翀䀄࿾ ℄ჱॾ锯劅⽒锩勵栐 Ȃ␢佾⒂︤荈䠤虾 Ѐ䀄佈ᔁ急Ɉ䑈䈄ǀ Ђ䀧ꤪ钡Ȑ劅⢄䦂  ﻡ૾ﺥ⹒꿪სþ Ȃ₯쨤≏䘥ؐ翪ႡȐ 빉⊊䤨ꉿ숈啀䃿 Ѐ䃿㾂ࣿ㾡ⓡ菆 р䢟ᤠ泹艬㢢ぐࣾ ď逧숔壘ꚪ趈迯袈辈 ȃ⑊䡾综艈럪䠤迾 繁ࣾﻵ≒꿪အ࿾ ĎႷ쏫꯬ꊔਾ Ā鋩⓾䀅ﻢӾ䪤ꫪꂆ ࡛凯늍巧剖֞ Є䑿쁀￨ȿ耀￠䁄䣂 Є䑿쁀￡ဟ ￩ኟ⠆ ℊ偩≆蒥侔䢌蠱䳢 縤ང♂呤虈땊戤ɾ ∂⃻➯鐧Ɦዲ䣾 䄄ᑹ䪾既﹊䜤꯯ꑊ䦾 ﹈⻾䢄﹈蚈쿥䉔Ȿ أ辀 ٣蜀ꠊ 戸 簤佼⑂籠۾꠪︨⋾ ᄁჿЏﺑ⧲ခ臸  㻸誾ꈯ뺊⪾ꨩ㸲䳂 Ѐ䀤蓄茡샢Ͼ∃ﰢϾ 繄⽾ᒁ縤虈ퟤꉊ␾ ꔪై籈ⅼ䑄粄觾 깦䪥㙂۾젤﹈⳾ Āခ࿾ĀအĐĀခp Ђ䠤艈￢䠤艈➂ ϼ ࠀ뺼蒞㼪鹿₞䴥뺩䣢 ∂‣ȯ스䩄ﲊ咦⿂ 菸₃࿾Ђ簼ా Ȁ₟ῠ␏쀠忤䒇覆  ˽⨒ℯ툡⿒ꔪ䊬∆ ℂჿ숔﵄ꓵ≂￀萐䘘 䡄轾咅ࡐ襾ࡀ蓾 ﹁ࠐĂ遉䤄遉׾ 䠤艾ꢊ袠詾ꂂࠠ苾 Āቿ䄧鉉䒔䢅誃棂 Ȁ⃻⑂䒹䨔ꂊࣳ䃂 ∂⃻﵊顢䯾Ђ砤࿾ 菸₃߼萃࿾ ࣷ韩ࣿ韩䋷 Ăု⿢ቧ뿪䐧莆 ︢輨⿢ꩪꚪ곪舨⋾ ︄@Ѐ䀧쉀␂䀤࿾ Ā႟࿨ၟ࿢艏 䢤轾ꒊࠠ荾ࠠ苾 Є䁄߼䐈䂄ϼЀ䀄࿾ Ȁ⑿祄袙䠢翄ꑊ俾 ࢷ⟯࠯柫䊧 ﹊➢䨧뻈ϼЃ࿾ Ѐ䃿翀쑄䑇ﲀࠀ ဉዽ⤒ﴩ䘐࿾ᑎ␡蟆 ︒Ġ￩⊒⨞쀨ʀ⿾ ਏࢎꂪ撠긲  维ɾ㒎䠨迾ﰠ菸 ࠇ߮ࠏ䊧 ࠀ麝Ґৠ퓙䒤䩅蒠৾ 븢∾飯뺪趾貏뺈达 Ѐ䃿㾀䃿㾂࠿興  㳼䈈ﯢ૿ﯨ裸袘 Ѐ䃿ᄁ₃萈 сꓠ艾␯숧犊⢤ꎎ 㲔䦈䂕镩邑⬞ ᄁဿ술翊‿술翁ࠏ༎ Ȁⁿ翤衏萠忉⒒䄬 ɂ␯ꉊﺠ੾ꐢ縤≾ Āቿ亄詿ꒊ婊ꒈꆲ  ᱾Ѐ䀇﹂Ӡ䎈⚂  ᄁၿ섐ᄏ︀ϸ₃菸 ధཀ␂繤䙄ꑊ萨䈄 ︄@Ѐ耟쌄큁А䇼 ā郯⿮ဿ柊䒧쎆 Ȅ⁻≏縢俾␧纬≾ Ă၏၏⟊䒧쎆 Ѐ䃵迾₃舘 Ѐ䃿㾀䃿㾂࠿谆 Ѐ䁿쁀Џ︉䥈鈑ذ ď႑৾⠪ꪪ늪⢤辘 ď႟￢ု럊䒧쾆  ﻱɾ␢繴⵾吥繒䟂 ﹂␢≂⑂䐣興䀘 Ą၉⺒䤤﹁ؐ줤鉉⳾ Ą၏䑅﹂׾쑃賆 ﹄乼䑄䑏쑄⡄䲂 ధཀ␂縤䍄萨䘄 砄蹈Ү踀ü䢣軆 Ѐ䃿ሆᰀӾ≄⍌ 䈄⁻裡鋹⢒朗኉潐 я␀轾Я䈇⢔꾎 ﰄ࿾ꔩ䨄߼Gﰀ䟼 㱄䤈䩄꽾␋䂤≾  㱼@Џ︄@㾂ࠠ菸 Ȣ鐤迾꒪纤꿊⟢蠯 ĂအА䤬鉉⒒䤤鉉⓾ Ђ䀤ϼ䐈䃿ऀ逑⸞  㱼@Ѐ䃿Ѐ䀄@ Ѐ䀄|Ѐ䀄߼䁄р䟼 Ѐ䃿뾢࠿興₃࿾ Ѐ䃿㾂䠿艈￠ࠠ脸 Ѐ䀤葄谠࿾Ѐꀱ谆 ф䑄䑄䑄䑄䑈䒀䠄 ℉剉⾐꿯邩䪔ࣹ䉢 ︀߼䁇ﱀߞ䐩䪥⃆ ⻮䢄蛾슅﹄䶂 㠤侂⿢ၡ۾ꄊအ˾ Ђ䀧⟂呥䙔꿪䐤䉌 Ѐ耿興㾂࠿聄値賆 Ȁ⊟࿈ 䅄ᢆ覆 Ā邉Ӿᄉၟ䒄䢈謎 Ȅ 蠨䒢蹄࿾ഃ䣄恀 Ҁ䢟Ῠ鑒⃼䡄ﲈ䣼 ႁჿ穄ꑺ䒄壀R䢒 ︠ૼꡊﲨˮ判ꪓ⩦ Є䁇䟤鉱՞唉傗Ύ Ѐ䃿ሇﰐ脈￠蠰谸 䈄⁻₏ﺊ侤詏ꒈ䦌 ၇䉇⚪Ⲥꊚ ҂䩞ꡈ꾪⩊뒼ꈲ ႁჿ翀䃿ꥄဢ賆 ႗䊗隩Ⲕꮚ 䁄Ѹ䓾䩊꒪䊤ῡР䰄 ဂᱸ䒤樤싸Ҿ樤ꊊ⦾ ᄁჿ翄ꑿ忨ʕ≖ 㰄⺀࿮ခ~Ⴁ໾ ďኟ韯႟ᡒ裆 ďኟဧꅊᢦ辆 ⋮ࢀﻢ苾⊂왐ࣾ  ﹂苾ઠﻤꊸ㈢㹐ࣾ ă቏ჿꥊ頦辆 䡄衾ࣿꥊ鐢俆 뺊⾾訯뺀⡂萨ꊑ⠆ ч⒐艾裻纨誈 ႁჿ紤剽⑒紤剄Ⓠ ႁჿ㾀䁿쉈￢ࠠ菸 ࠀ躿蒈㻪ꩾꊪ纤調⢒ ć鑉⓼꤉ဒ艄젠R䢒  Ȉ䁋宅@㾀䀄࿾ Ă䨢佾ᒡ縤Ꙋ럢࠯ т䡏၏㿪䒤䉼 ю䢯Ⴏ뿪䒤䩼 ﺨા⪯븪ꚾ梋㺠艾 р䣿鿩ኟ韉䓴䁼 စ㻺∾ꨯ븢⑆Ѓ࿾ 縤≂⟪䊤⩾ꐯ䈄⃾ ɂ␧≂︠;縤♾  䟾풤剿㿂Р䏼 ႁၿ翤䉿㿂Р䏼 ₂ࣻ狊䨀࿾Т砼ా 纤⑂䟪䈤♾ꐢ䈤⳾ ďဟ⑊窸⩔ꕊ咩伆 ďဟ⿢銹⫾ꄊ㢭伒 р䓿ⵢ䑿嗅偗ގ 㸢⾢௡∢✾ꨢ∢≾ 뻢∢⏯ꈢ☾爪ꊢ≾ 㺪⪢⏯ꈢ☾爪ꊢ≾ Ѐ䃿㾀䃿⑏︤豆 㹂⤢≊⾾∪ꊪ≾ ᄁჿﮊ裿呂Ⲩꪈ ఇཀЏ縄聘誐輈 纔⩂쟪䊔⥾鐮䊄⣾ Ё废⑞ᔡ⨢♐ࣾ ဆ㱀䜼䁇ﱄ䝴䑄䑷곂 т䠿忭቟俄葈䓼 艅⿒䔧퉅⟒䄫스⏆ 븈₂䨢ꈑ䆔⒄ᢆ䆂 ਂꣿ翀䃿穄꡹賦  菼恫ﰠ䏼 ﱐ䇼 Ѐ䃿啇射࿾⑂␡辆 Ăအਐ濢အȐ愊အ˾ Ѐ䃿㾁ჿ翈ꈑ، Ѐ䃿啂䡕䉈䑀ꀱ谆 Ѐ䃿萠䃿ഃ䣄恀 ﹀⟾儥﹑◾䡈ﲈ䃼 ﺂࠠ鿉⒒䤤鋈₀࿾ Њ䂯꒣鋢∌Ё⑐⣸  㻺∾㈦ꊣЁ⑐⣸ Ąၟ忥቟䑃跆 ﱀ仼䁅﹑⛾쥄鑉찐 ﹁෾䄄﹉⛾줤﹁ఐ ﱀ么䎅왁۾줤ﱁⷾ 籄仾䪤꩎쿤ぅ䶒 ﱀ䟼䁄ѿ쁀Џ︄@ ᄁჿ翄ꑿ숈㾂ࠠ菸 ࡄ䠡ϸ⒃艈￠퀴豆 㰤⿾␢繤♾ꐊ븪∾ ҂䠿㿢䩿꿊萨䋼 ʀ⢿Ῡ⩟࿂葈䣼 簤䋾ꪪꪮ忤ゅ䦒 Р翀䓿翀䀄ǀ Ȁⁿ቟忤䒃视 縤⽂⟢䉤♾됪䈤≾ Ѐ䃿ꈤ鰐ϸЁ⑐⣸ ҂䢿㿮䨿濊蒨䋼 屄䢄䉇輀∊钨≸ Ă၏@໾ℊ咩∰ 岤亄ꨪ䋧言ꈎ钨≸ ᄁჿ㾂࠿興㾀䃿 ᄁჿℊၯ℆Ⴁ˾ ᄁჿ￤꠲ⰾᄏ︑ؐ ᄁჿ㾆ಿꈈ㾅ࡐ臸 ᄁჿ俢ꪎ࿢ぅ䢒 ĉၗ儉縀࿾ᑎ␡蟆 Ѐ䁿쁀Џ︄ɀ⟂䀼ా ࡀ䑀苾Āჯ≂쉐ࣾ ʀ⢟࿠ꫯ⑂籐ࣾ 㱄⣾维≾ꠊ븢⾾ ﰄ࿾ꔩ䨤྾∧㺪∾ 뺠⾔ꆏ暠达પ밈ꍾ 簨藾䤬鉏妤汘ꐰ ф䡟￥቟俄蓨䃼 ࡂ蠿뿪⊿꿂萨䋼 Ҏ䢿￪ꢯ꺊꿊꒯ꨒ ᄁჿ翥䡞ꔪ幅䒞ꠒ я䢟鿯ኟ䑔䥼 Ā邏쒐āﻠɼ⑂籐ࣾ ︨⒂俬၁Ҟ䤄遏܎ ꗪ튥ꔪ庤ɒ☖ 芉⾒褯銉⢒鸞Ɉ⡆ 麉⢒廊銉⾒脩኉潐 Ѐ耿興㾂ࠠ菸Ё⑐⣸ ﹈⺂俤၁ڞ줄遏༎ Ѐ䃿翄䑄䟼ఁ値豆 ꗪኩꄪ庤ʒ⨖ ﰠ䈄㿀䀄ɼ␂䀼ా Ā၏࿠鋯╂鉐ࣾ 䐨␀䆌⑄⒀䟤䉄⑾ ﹀⟾剅⑟쐠뿪∯ꈆ ટ銏⪟ꤪ⑐ꢲ Є䁇䯧⡔蕾邉ࠑ䙢 Ă၏O⊊⢤ꎎ Ѐ䃿ᄂꡄ䁀￠䀄@ Ą၁໾⤢鉉ⷾ椤鉉⓾ ᄁჿἁဟĐ￠1谆 ф䡟两꩎ꚪ캤ꩊⲦ ࠀ胿ែр谐忤၁а ︡Ƞ䑄⡡⳾䄄鑑Ⱀ ႁჿ翄ꑳ쐄￠ࠠ脘 縤⽾ 縤⍾縢䛂 ⁂Р佾⁂Ѥ䘤끊Р䈜 ﺄ葔ࢀ틛䪥ꪠ৾ Ȃ‪쒴乍ꑊ䒬䨄ꉈ⓾ Ѐ䀏蜈ऀ怙ఠ␁菠 Ѐ䀄࿾ЀꀊĐᄂࡄ䠢 Āႁ׾Ĉ၂耨䑄䒊⤒ Ďဏ࠮䀄쁰䂤⹾  ﻡ௾꤫ﺩ⪒뿪სþ ď纑ਾ阩㻢⠦Ѓ࿾ ﰀ䒈⒀࿾ႃဏ܌ Ăု꟪袧꟢䈧 縠伄⁂Р䌄Р䘜 Ăု⠢䁤왰됊䀤≾ ᄂၿ樤ꃺ撸樄ꂊ⦾ Ȃ ⟢衧럪䈧 ĎႯ젪䂤쩰ꐌ䂄⡾ ď邡࿾ꄏ邢辨ొ萊⌒ ԯ咠ཾ꒯纤꽊៭ࠗ Ăအ׾䄌ぅ蒔儤ﱁА Ȃ␢䉾︤艈⟣䣄聾 ⁂Р佾၁Ҕ䔤⁃ш䠌 O萠䑾蒪䪔ꡊ蒨䢌 Ȃ␢◼섄၀葆Ј䊄⿾ Ђ䣿㾀ÿ뾢䠥聀 Ă၇Ă﹀䳾䁄䑂䐌 ࠀ逐迼#菸Ё⑐⣸ ∄⚋辢误ꂋ诡⁐䣺 ᄁᑽℐ￥⡾ꔪ﹂䓾ꑒ ₂ࣻ￢⡄䯺₃菸 Ѐ䃿㾁ჿ啈숕ٌ Ā銟࿨_俤銉栐 ď႒⥂ཾ鐩䊔⭾ 㺲⪾㺺躪ꩊ늴ਾ ᄁჿᄂࡿ쀂㾂ࠠ菸 Ȃ≟䄄丄࿾ᑎ␡蟆 ȁ∯₃︠䏼⁃ﰐ䘂  籄䉼р糥≊⑂牐ࣾ Āႏῠዯ⍂퉐ࣾ ю⒠諾섊㊬쨘ꋍ쪀꠰ Ȃ≟羂丿艈￠R䢒 ﺩⒺ浪뫸⪺猪⪫ꪆ Ȃ␢␠忬၁А䂄ࡀ䐄 ခࠠ舄￀Ȁ⏸₂ࠠ菸 Ѐ䀄࿾Ѐ䀄 ਁဠ谆 Ȅ⁻翀䑿쑀翡䈤ⱌ 븢∾飯뺨෾袏꺋迆 뺈达訯븂⾾⅋ꋠ৾ ﹊蕾犅㹄׼遉︀╖ Ȁ₟҉﹒䇼剅ﲂ⠾ Ҁ䢾૫勥ꥮ Ѐ䀇쁀㾂࠿興㾀䃿 ﻡਰ겪Ღ讈ꇊ櫸ꀰ Ѐ䃿莣쀈ü耈⃾ ๏ภ䈄⁏숄⁂ⰾ 繄⽂䐤繄虈쑄䑈Ⲃ ﹁༐䄄⁇䉄Ȿ  纄⑂Ш繄聈т䑈⢂  ⓮Ȩ胾墄ﺈ裾 ﻡа䲤᳦薈䇄櫸ꀰ ฏภȎ‏⊢⸾ ﹊ꣾ绺䈤럪ࠧ ﺕ◾ࠈ﹒⇺䪤廒꧶ Ɏ␏Ď︁ ꊢ⸾ ᄁჿ翂࠿興㾂໿耈 ﱄ䑄彅呕䕔啅犄⡂ ࠤ꾬ꢊ뺪⾾∢븪⾦ ﱀ䐄䁄р䟼ࡀ䠂 纔⥂鐩䊔⥂鐯丄@ 縤⑂䟬䉄⑂䟤@Ӿ Ā၏࿠ⓢ䋾ℂ﹑ࣾ ﹀׼䀄利ᒐ菆 Ѐ䃿䩉全Ǹሏ︠脘 я⒐襾䊗銉⢔ꮎ 밈䞼䈧븑࿾ᄏ︠谆 뺠⾒襏颢䩂￁ထ࿾ Ā၁ʒठ鋩⊒⤢﹐ࣾ 꾪⻢ꩪꚪ껪ꨪꊪ ဠ萄กဠ萄뾢ࠠ菸 ﺩ⓾䤪鈯꿢အ೾ 纑˾浪뛸૾㺨⫾ т䠯⿢ꩬ뿪Ф䈬 Ȏ␂乾Ҏ︄聈䢤蹾 ﰠ䉄≂ӿ⁂р䐜 ࡄ䠡߼䑇ﱄ䑄翀䃿 Ҁ䣿꿪銯꿪ღ膆 縤≂䈤≂⟣Àþ 繄⽂䟤䉄♂쟤@೾ ﹒꼨䒅虁Ӿ呙Ⱀ 興㾂ࠠ興㾀 ࿾ ȅ⃿着꫸興﵂ᑒ⣂  銉䐰҉虁䥄や覆 р䒟߈䑄䇾䪄캈ࣾ Ȅ≿翤R┤䈈傈茆 绸਀⟯숤≾剅⒐衾 Ą鉉⿾ ﺡ૾ꪢ꫺ꂆ 䈄⁻翄䑿쑄翀䃿 Ă၏﹁༐◪傧Ύ ď邗锩ዱ褨銏⪔ꆎ 㺒⤢⊒⼢鏩୾ ︄≸㰌㸄ϸ⒃⿾ ป躈઎긒膨뺬༾ ﱉ䣴壟雾ʜ꽊鐩迦 ﺁ⠒뾨ኑ⢒脨㊀⿾ Ąၟ艏䟄䓤䇾 Ȯ鐤苾ﺉ⺒⿢ု 	䛛謠鈏ﺒ䮤홉⓼䁄 ﻥ⩔꿪⃯Ɤꓡ胦 Ăဿ⮢良럊䐤䋾 磄衈軰ࣼ葏䢃视 ﱄ䟼䑇ﰄ࿾Р舰䰸 鈉丐ʎ영イ辆 ࠯䏬ꉋ䨤빈Ӿ 䀄}鄡ዿℒᄢ鉅 Ăဥ扚툥≖┃䃄⁾ Ďဥ扚튅⹖│䀤Ȿ 颐漀鈉⓲䥢騯ₒℾ  }缢鹄௼⁃ﰠ䏼 Ȁ₊쒴้ꑊ䂬䨄芈⣾ Ѐ䁿䩄꿺䒤䪊꬞ ȁꓢ䉾⒏︤虈柫䢤艾 ﹉⟾ȏ︈蓸䢄߾ ȏꀣ葏쐡䈔ࠣ係 Ђ䀧ꪪꪯ꾪⊢㨤꾎  ﹈⋾ठ铯⟢ࡐࣾ ď邥潚ꜯ튥⽖ᔍ䀔☾ Ȅ⁻﯂⓵恀￠퀴豆 Ѐ䃿∁䠈俾䑇ﱄ䟼 Ą၁޾剉䒔䄄၁А䄜 Ȅ⁻簤䉤╃䓈䂆 ᄁჿ翁․俾䑇ﱄ䟼  ﹁Ȳೀᣢ싊₢ぐࣾ 죤艾⒏࠯態ᒢ⋂ Ѐ䃿ሏ︠蟼Ѓ࿾ ᄁჿ 豆㾀䀤葄 Ąၟ䑅﹑⧾稴ꕺ ႁჿ翀䃿㾍ࠐ臸 Ѐ䀄࿾萨䊄⿾Ѐ䀄@ Ăအ׾儭ቑ◾䄄၁А Ѐ䃿Їﱄ䑄翄䑄䟼 Ѐ䁿쑄䑇ﰀ@ህҐ⃸ Ą၁໾䤤鉉⛾줤鉉⳾ ﱀ䟼䄅䧲ᄁ࿾ Ăࠠཾ₂ࡠ虾낊ࠠ艾 ȀႀӾĈ၁þĂ၁ࣾ Ѐ䀄߼䑄䑄䟼Ѐ䠄俾 Ѐ䃿翄䑄䟼ᐮ␡蟆 Ȏက໾ĎခþႡ໾ O萠䉾蒪䶔衏蒈侜 ă၏ჿ꿪䐪伌 ď袠྾ꂏ袠达ࢊ蠈茾 ︡࿾⤢뙡۾ꐊ︨∜ 좋ࢩ繅Þ唤庅⦞ ĂႯ䅊︢پ갢縤Ȿ ᄁჿЏﺀ 翀䀄ǀ ᄁჿЧﰄ迾၃ﳐ䇼 ď႗鐯ࡐ袸 ︂ Ȁ  Ȁ Ǡ ȁₒ┤ኁ′蔤鈡•ⰾ ﺒ┢ᾡ∟ꔂ垩䪧ꈆ Ȁ꓿ꯊ肯뿪ュ䆒 Ѐ䃿宅뻼⢾行뻺ࢾ ĂအȞ金邩૾ꐢ䈤≾ 縤ɼﰊ粤૾ꔂ䨤䉲 Ȁⁿ䀅﹁А䄈ႁp ﰄ䁄翄䁄࿾萠䈄쁀 縤ɼ粄໾│䨤䱲 䤨먉⊺䠨먊ꊺ䡨 ҁ䡔#걊彄䑄ꗲ ҅䢟庬䩞䐚Ё⑐⣸ Ą偕⻔䔄偍蕔偉⼎ 簤俼ꑏﺤ૾䨩∬  㻺∢ﯨꋺ⢾諸⋼≆ ࠀ麿⒒ᷩ剝⅞崤銾⢦ Ċ咯䂇꿪ゥ䪒 삧ﱊ䒤䩄ﱀЀ䀜 ⢲ꪬ⢦캪늊⣤ꎆ ďႯ꿪ꫪ꫾ꈎ钨≸ 纔ॼ粔࿾锉䪔䭲 粔䥼纔࿾銩䪙⬬ Ȃꐯꯊ肯⿢〥侒 ︉⺒ம鈋ꂂꪫ꺆 Ď吏׎䀇ゥ侒  㻸ꈒ≯耣ꈪ㻰ࣾ ⢚ꥬ⠢쩪몊⢤꾆 ⡂ꢬ⣲쉪ꪋ⠤꾆 ﰠϼ ﰠ࿾⑂␡蟆  ﻱӾ䠤﹈⓾䠤ﻄ䆂 Ѐ耿興㾂࠿㿠ɕ⥖ Ăჹɾ浪銩⾒∧⊨䈘 Ȅꁋ캠忤⁊䔢옄с賠 Ȁ⃿࿄葏쒄䡄ﱀ߾ я⒐觾႟鄉⢔䮂 Āႏन鉁耨ʂ⩄ꦎ  㣤䒂䃄烠Ќ䜄ˠ샰 縡໾℃︠䏼⁃ﰐ䘂 ă၏䋷꿪$侂 ĎႯ쿪銯꿬ゅ䦒 ĀႏῨ቏俤႟ ю䢯궪Ⳝ꠲Ѓ࿾ Ȃ␢佾⒂﹤虈럪䠤艾 ဩ⇢ၭꔪ帪̞ Ā⁇쉄߀䃧쉄⑂籐ࣾ ၉ჽ딪帪༞ Ȁⁿ쿄࡟忥ኟ  ﱀ苾ठﻩ⋾⤢限ࣾ ︨≾㈬수⛃諀ꁰ 縤⽒⒢﹤♒ꢪ舯 ﹈⿾䤤鉋Ꚗ줤﹈⳾ 帥⿾┣﹥♒꯫ᐢ䋆 ︩⒒䤬鉏䤤鉉⓾ Ā႟࿨ၟ䟄䒇즆 ︡༐ℂ⁧됪䈤≾ Ā၁Ȑ࿠სȐℂၐࣾ ᄁჿ㾂࠿㿠ɕ⥖ ⢪ꩀ໮∪ꪤ䊪 ꣮绰˾ꈊ縤⼜ Ăု⿢⑿꿫䈤≾ Ā႟Ῠၟ俄蒏쬆 ﹁А呁А忤ს Ѐ䃿㾀ÿꪣ࿾ ﹁࿾儥癐৾﹊꒪ Ă၁ࣾ鉉⿾⤪銩⋾ ﹈蒈䢄衈蒄䡈蒈⢂ 興㾀䀄࿾萨䊄恀 ȃ⁋˺−꠪舠侘 ჿ졄埏䒧꟯ʥ⽖ Ѐ䃿㾀ÿ뾠䀄ǀ د蒈䢌﹈䒄䠤׾ Ȃ‿俌_俤၁Ѱ Ȃ‣俬艏俤D䖂 䠄舑⿒┯튡⿒┦䊤⎆ Ѐ䀇쁀㾂࠿興㾂࠿谆 興㾀쁀㾀䀄࿾ ﱈ䓼ﱀ׾䤄鳯̎ Ѐ䃿考ﰄ@⟂䀼ా Ѐ䃿ᄏﺄ⯺⒂䠤艘 Ȁⁿ必ၟ傉Ͼ Ѐ䁿篤術袉㸘پ  ೧Ȑ䄈ﻡȐꄄﹰࣾ ℁ဂ߼чﱄ߾డ䈤ⱌ т␠苾ꄪﺩ૾ꄢ㈥⊜ ا轈⒂縤䍄爠۾ 왇躈傅﹄蕈빔ാ ﱈ仼䡄ﱀ׾鱏༎ т␠迾™﹩۾ꄪ㈥⊜ ﺀ萈ࡀ耈ࡀ蠸 Āჿ ﹱഐ嗥偗ގ Ăအ១䈧럢"+CHR$(34)+"䋂 ﻤ≂⟯'矪ࢠ艾 Ă၏﹉⽾┫劥≖  䤤푉廾䤤庖ஞ 縀伄OЀ䀄Ґ伜 ĎဏɎ︉⁾劥⹖ ď႟︩⩾딪劥⽖  ﹉ʐ࿠郷┢噐ࣾ  ⤒酏䢒蔮刁쿐 䐄黽┒﵊壝䡒Ｂቑ죐 㹈䠄Ӹ䈄ꡊ萠侜 䗴充ᑿ삠ﯢꐪ䲤  ﺈ⒂࿨聊¦䮄ꂒ⤾ Ąၟ䒄﹉⛾줤멊겺 ⻮䈤蛾﹉೾ ᄁჽ䤯꿪鉋꒪ꮲ Ā႟҈﹉⃾ढ멊ꢺ Ȅ⁃鐩˲⤒逩˰䀘 Ȅ⁻Їﱄ䑄翄䑄䟼 Ā႟Ҁﻩ⋾⪢멐ࣾ ă၏ﻹ⋾ꤪ먪꾺 ⑂ᷩၝ䵥䪅⣆  㻺Ⱦ㩎䐤䀀㿂Р䏼 ҂䡟ሣ귪剅ꔲ ҄䡿別꟪퉅괲 ҂䣿﫹⫺壟ꊒ 䡄艾ࢀ裧⅂扐ࣾ ⡊蠾䣻ꢊ鐢⿂ ਀ꁿ쒤䩇ﱊ䒤￠1谆 Ąၟ艏忤ä䂂 ︄@Їﰄ@ਁဠ谆 ﹀⟾䢇﹈蒈翩⒑菆 Ȁⁿ䈄㹂Р忩ʐ⇾ ﲂРῨ䡈䄢䈄ꪒꡠ Ă၏꩏⪫纠苾 ꋢ≾∯ꈢ∾﨨ꊊ⾾ ď႑༞鄏႑ॾ䉔⥾ 㻼Ȁﰊ综詈ﴂዾ∾  绸舾﨨뻺⢾蘒㹒䣂 Ѐ䀇쁀Ѓ興㾀R䢒 簠Ѐ䀌﹂Р䑄䑈ꓲ 벊䢤爫⛸ॼ煮⑓裆 ꔪẩ婞Ş弤ኔ쨲 ﺄ⡂萨䋿萨䊄⿾ ﰄ࿾锧ﱄ䟼䑇ﰄ⁾  㻼@翄䑄䟼ኁ␢Ⱎ Āჱऐ鿩႑ऐ鄉ჱþ Ą၏﹂Ѿ尤绤⁾ 簨⡼䄁﹅࢔У࿾ ﹁༐儅⁗䉄⑾ ﹀⟾䐥ﱄ蟾䡉ﲨ䃼 Ă၏Ă﹁ఐ䧤遏܎ Āထ䄂ထ༏ခ ࠠ輈⟢ࡠ蘈낊ࠠ艾 Ā႟Ῡ⑓섀埄䒃视 ꐊ袒元毸₃࿾ ᄁჿ㾄ჿ쑄翀꠲Ⱎ ď႗酏纒ॾ蘒㹒⢾  㡄䊂߀ჯ⍂剐ࣾ  ỽ≒⥏䟒씧퉅쟐 ă၏￢ꓻ슀ꯊꐡ迦  维艈⒂繴䵄吥牐ݾ  维ɀ⟢偵ഞ別≔❌  㻼⒒䥃資⁀翀䐘䘘 Ȁⁿ翤衏萀鿈蠏܎ Ѐ䀄@翀䀄@Ѐ䀄࿾ 䀄繀⼂別≑䤔顂䓂  㻼⒒䥃資 Ё⑐⣸ ꒊ傭梅ꑊ庤䉄◶ Ђ䐤迾耫蘒興㾁∢ⰾ ࠀ耏脈椀怙蹆̀8x Ā႟࿠鈏俤ゅ䦒 ︈₂ࠠ興₂အȠ䰸 Ȁⁿ翤≟忉Ґ䇼 ɂ␯␤⊼ 组⁾ ࡏ詋䯤ꋲℾ Ѐ䃿㾍؟Ā￠耐䟼 Ѐ䃿ﰈῃӐ䇼 Ѐ耿興㾂࠿㿡ɒ⟬ Ā 슄꿊蒯꿪˪⊬ Ăအ럪䊧꟢࠯ 硄蹈䒤蹀ۼ쑄䡃跆 Ʉ⑏䆄⑄⚼쀄繄Ȿ Ѐ䃿翄䑿쑄翀퀴豆 ⠪꽬⊂⡢읪ꪊ⠤ꎎ Ăု⿢ၯ뿪䐪䈌 Ăု⿢鉯꿪〥䎒 Є䀧⤄⢄䂂翄ꑊ俾 ࠀ肏Ἠ䉟⁂唥䠘  ﲈ䓼ࡈ﹄þ劤䪉⠬ Ā႟࿨ၟ忤蒔䠬 縠䪄ꡊ萠䈄偄蒀䠜 䪪ꑊ縨ɾ吥纂䣾 Ѐ䁄≄Ї︀ 翠Ȁ⟾ ȀⁿO첄俄䢄觾 Ą၏១ု䑊䐌 Ȅ⁻Ѓﰄ࿾︐肘 Ȅ⁻藴耣菸 Ȅ⁻ﺀ⧲耩⧶ ࢯ⿯訫毫⊢∾ Ă၏䑇꾪⊊⢤ꎎ 숡␒蔯툡−ﴢȠ⿆ ᄁჿ翂䠿艈⒇ﰄ࿾ ᄁჿ迄萏좄忠剉⤬ ᄁჿ绲觾㪝䬲 OЀ佾OЄ䀤Ґ伜 ď咟￩䒙⽼选ﺔ䭼 ︀ϸ₂ࠠ菸ᄁဒ࿾ ꤬࢞騠୾ꐪ纤⽾ ⡊ꉬʀ⳦ꊨ⊢乐ࣾ  ﺁ׾Հ鋯舮∢䱐ࣾ 牁䢪绸ɾ됪縢俾 Ў䂧쾪⊯ꨢꪬ婢⠌ 縀轾鐩纔⽾䐥繒係 Ď咯钯꿪ʪꪮ 뺊⾾訯뺀⯊Ɜ쪒ꯚ 藾咭穀ꗺ䒥◬ ď逡࿾꤯銩⾒∯ꈠ侘 ﺀ⠂뾨ʀ⧲鄩ኟ⠆ ࡄ䠡࿾耫蘒菸Ѓ࿾ р䢟࿎萯쒄￠ࠐ肘 Ăဿꑋﺩ⫾ꤢ︡˾ Ąၟ䑅﹉⛾줤﹁෾ ﺐ│ឩɐⅺ咥窐⤆ Āჿﺩ⻾ꤪﻡǾ Ѐ䁿섐ᄏ︤菸⒃࿾ ﺨ⪂芨⺺ꪪ모⪆ ᄁჿ翪ȿ⒂ﾠ艉⟼ р䢟߀䓧쉄⑂籐ࣾ ﹈⢂ﮢ苸⊺ꪪ먨⾆ Ăအ숐ꤊﺨ૾ꤊ飹䀐 Ĉ₇콄蟉䓷䟯Ɋ꒮ ﺑ௼鄈䂿좀龋࢐迾 繄⡾Т繀䳾䁄䑂䐌 Ă၏࿢ꩊ곾䈄鑨⑸ Ā႟࿨_䊄⢄ꦎ ĊႯꄊ︠䏾䐢䈌  븠⿒⅊貥⟼䁇ﱀ䟼  㱼@￠퀴豆ሁ•Ⱎ Ȅ⁻㿂‿술㿠ɕ⥖ Ѐ䃿翀䃿￤䡿 ĂႡӾ䤪鈩⛾ꄂሡ⳾ Ďဏ߮⢤꾎 縤ཀ⟢健ڞꨪ∤≌ 簨迾⤢鉯궪Ⱜꈰ Đᄁჱ耨ʀ⿾ Ѐ䃿ሆᰄ࿾Ѐꀱ谆 ﰩ俴⥂陮ڜ꽋鐩苦 ﹀␂翤 忩⊒⇾ Ѐ䣿㾂฿興㿠ɕ⥖ ᄁჿЀ簄@翄р䟼 Ѐ䃿뾠䀿艈㾂䠿谆 ︊ 翤ꉒ☞䀧﹀⟾ ࠀ鲾䒈ᷨ詿工䢜襘 ࠀ뻬设ꨪ뺪⯾ꨪ뻩䃢 Ѐ䀇ф䑄䟼䐀䈄‾ Ăု꟪䊧ꂂ︠舸 ∂⃻煮蓹䄔₏蠡䙢 Ȁ₃ɉ⑒䇼ሀ≂⠾ ﺡਰᲦ辈ꇊ檸ꨰ  ﹈苾ࢀ뻪⊾⨢㹐ࣾ 縸蹾␪纤⿾␢縢䇂  㱼@￠逐菼ࠠ菸 菸₏ﺥ⥊Џ︠蟴 ă၁勵≾딊အ⾞ Ѐ䃿ႃ⏸Є䒄⃀ ≒﵂堥俒䔨劉쌐 Ѐ䀄࿾萨䊊⤒ꂨʀ⠎  ?䐄粄ࡀߠ䀄@ ﱀ䑄䑄䑗䕄呅䊿ꠂ ᄁჿ艏뺦䈾既㹒䢾 ࠒ꺬㸘肜袬༾ ā咿䕞㽊鹿䂔翤钕䨾 Ąၟ䡅穀׾鑑ⰰ 籄䡜哿ꮪꨫ꾆 ɂ⠯⿢ꩪꛎ꠪︨⋾ ꊢ꾪ꊯꪢ꾪પꨌ⍂ 籅䥼﹉⿾⤪ﺡȎ  绹⫚ꩊ૾ꤪ䁚 Ѐ䃿￩ኒ⯺萫彩⡆ Ăု⿢ꩪ꛾ꤪ︩⊖ Ȃ⃻着꫸誈壟ᓺ≂ ąᓽ䔾琢ﻺ䈤ﯢ⑒䢾 Ȁ₂׾ш䑄䂄䲄㢌䬂   ߼    ÿ ﱀ䐄翄HҌ伈肈⁾ ć鈁⿾Āၸ耈@Ў⼂ Ѐ䂇ᄀქ䊒ℂぐࣾ  ?倩㊜ℂᄠ䀘 ﺐོ透䩔䣲 Ѐ䃿訩ኤꡂ訩ኀ⠎  縠辈ꢊ袨辈₂蠨迾 ₂ࠠ迾₂ࠠ興₂ࠠ菸 ﰠ䈄⁂п숄⁂Р䏼 ꠢ襈䒀ࡸ肈ႏꌎ 쀄@Ѐ䀊 ᄂ၀蠆  #䨤ꉊ⢢툣≊⢾ ﹀␂翤ၝ⑔䖈钱‰ ᄁჿਇ밊 節ꀊ࿾ యА䄌ၟ䄄၁Ӿ ౏༐儅ၟ၁Ӿ ﰄ䅄ࡁ䑡耀Ё⑐⣸ ︁⹒Ȯ刈쀀钨⹸ ﺁӾन뙁ǾȂ﹊ꢪ ﹅互㿢鉍겶涤뙍꒒ Ȃ‣ᒁࠢ읊ꢢࠠ舸 Ѐ䃿偈߼䩏︄ǀ ᄁჿ㿄钕䈤ҁ⑐⣸ ɂ⒯䀊︩⚒꿢鈩⳾ ᄁჿ섔﵅Ⓔ䉒R䢒  ?舃ﰢȠ￠   藴耣 Ѕ⒐⃸ 㡄人倄籀䘈숄鑈ⱸ 꺾劄ꡄ蒔툤J䴒 ꪾ늊ꠤ芔判䤒 ĂႩઞℏ逡پ琪䊤≾ 肈ࢀ踐ℂ•ɀ䐸  ﻢ舨俨ꫪꋎꠤ﹠৾ Ѐ䀄߼@ࠁȠ␅肆ࠞ ₂ࣿ狊䨠聀㾀䀄࿾ Ѐ䃿￩ሿ脐￡ⓡ菆 ∩≄ꁊ䂪ꪒꪢ온⋾ ʀ⢏࿨꩏俥咔衦 Ă၁ࣾ鉉⾪ⱪ芨⊆  ⚋辠ȯ뺈ྦ讏ꂊ⦾ ⊩⩄䂪꺒ꪪ욨⫾ ʎ⢯ꪯ꿫咤試 ਀ꁿ쒤翄ꑿ翩⒑菆 븊₾뻪⪢꯮鐊䇆 ︤䔘ฏḄ߼䑇ﰄ⿾ ﲄ䡄葈䓿저耈ʀ⟾ ﹉⺒䤤鉏전艈⳾ ﹅丘俤呉◾줤﹉⳾ ︊߼䩏ﺪ⪾諸㻼≆ 縤꽊⒢䩧됊䈤≾ Āႏईﱈ䂤充ࢃ䣂  ᲞԆញ偕⅔咅䢤䩂 븠达₏﹄䑄翄@⏾ ࣷ⒂繴ⵒ啅豑❢ Ąု係ꑉ褤￡ࠟฎ ﺑ⿾䐇ﱄ߼䐇﹀⥖ ᄁჿ翄䑄䟼䀄@⏾ ﱄ߸䐇߾%劕‌ ⠾䊌萨庄⹄薈 Ȁⁿ啄衟왒忨傉⌞ ﹁ฐ俤၁ؐ쿤၁ఐ ⡞䊄蘨⹄趈 ȏꂋ詏蒉䢔ࡓ䣂 ︠輈ℂၣ䙔뤪ሡȐ ︂@ಃ䓄⁀翄ꑊ俾 Ċ₯￨銉⻾ꊊ䢯 ሁ⛳脠ሯ︠䏼⁃ﰠ䈌 ĎႯﺩ⺒ꤪ銩樐 Ȁꃻ篁⃿㾂䣿 븠∂뺪ච訏ꊊ⾾ āဟ≎︠Ȁ⟢䈤≾ Ăု︠Ȁ⟣䋄⁾ ф䑏埅䑗줐ぅ䖒 Ђ䀧⿂呥䛾ꩊꐯ т䐯⟂䑧옐꿪〥䎒 т䐯꿋䐧숐忤ゅ䦒 纤⑾䐪縤♂꟢"+CHR$(34)+"䳂 ﹉⟾ﰠ䏼⁃ﰐ蘆 Ѐ䃿翀ÿሁ•ⰾ ď႗鉏ﺐऀ䊤⥾ ĎႯ쉊ﺠ਀꟬䊄⡾  籀˾ 糠ɼ⑂籐ࣾ 簥俼ꕊﺩ⿾⤢︩ྞ ﻡʒ╏အ۾愊ႡȐ 狹⨒✯숤≲儥ኑ⡢ ᄁჿᢎࠢ꾬₇ࢩ䉢 ĂဢӾ䠬艈⓾䠤艈⓾ 舉➒य툑ⵒ夥䊒⌆ Ą቟鉏忤ф䐬 Ą၂໾䠤艈⛾젤艈⳾ Ăဢཾ␢䉤♾됪䈤≾ ĀႂӾࠨ艈⃾ࠢ艈⣾ Ȁ䀈߼䁄р䟼䁄р䟼 Ȅ⁻Ă纔⑂ߢ䉄⡾ ĂႲ੾␯䈤♾琪䊤≾ ℄ჲॾ퐩䋼⥾퐩䊔⭾ ᄁჿ忣⒟씤ῠш䡌 Ā⁇Р绤≂⟢Pࣾ  ﻨ⫾ꒋﻤ课ꑊ鋥䂲 р䒟࿨艏忤⢄䦂 ︨⫾ꒋﺤ菾呄銅䢲 Ă቟鉏㿪Ҥ䈬 ᄁჿ㾂࠿興￠ꀱ谆 ꊡ侈ꅏꊠྡྷॊ蠉䌢 Ѐ䃿㾀䃿㾍ࠏ܎ ︈À꒩劄⥒꒬욀⿾ Ȅ⁻㻺∾㈦뺢∾  ⓴∀ↂ⑴ⴀ埥䉔❾ Ȅ⁻ࠇﰉ࿾ႃ臸 ȏꀃ䦄ꙿ衈뿠䣿 Ȅ⁻ﰄ࿾Їﱀ䟼 ς ⯂遯ꕊ︪ꏾ ︥䈘￪咩⯾ꤪ︩⋾ 㲒䤤⒒伤鉉⒔䭆 縥⫒딪刧唤튅⡾ Ȁ䀿숄㿂ѿ翤䉄⟾ ℂࠠ萈䁄Ҁ⠂ ࡈ衾᣺쉊ꢊ縠辈 ꔪై籊ꄨ俤⢄ꦎ ꐊ袒元椠翁•ⰾ 桂꒪糚ꬨ鿯⢔꽎 왁蟆䆏葀￢裇莆 Ȃ␢␠忬၁␔䂄ᡆ䖂 ﺑ⿾‏툁⾒į銈⾆ Є䁟䐄籈䚤텅ࡃ䳂 Ȅ⁻ℂ቏䅄ࡃ䓂 뺊⾾訯뺄⥊꾮⊣⫎ Ą⁇콄埅䑗埥ʊꢮ Ѐ䛿誐ꤋﺥ⯲ꔪ≂ Ȅ _垥䫷ꄆ ᰢ⿀ꠊ뺨ྀ⏢ꈪ⾾ ᄁဿ뿂‿술∏︂  Ăဩ⑔䄌﹁А俤၁А  ʥ⪒ℯ툡−ﴢሠ∆ Ѐ䁄䉈Їﰄ@￠䀄@ ︠Ȁ㿂Ф䉄䊄᠆䎂 纬ୀ⟏䐤䊔ࡃ䓂 㰢侤ꩊ뒪쪤ꩋꐤ䉆 Є鱝佔嵅晴׾픥呔쵲 Ў幄䗤䉄ꓫ䑄ꑈ丞 縤ཀ⟂䑤䚔ꥊࠣ䋂  ﲈ䒄ࡈ葉삀ࠂ艈⣾  蒈࢈졊肈䢄誐ꤎ "+CHR$(10)+"纤ੀ䒄五ꥊࢣ䫂 粤䑄䑊䐥와ꐂ䈤Ȿ 㹊䒤䩄ꓫ䉄⑄佞 袬ꪪꢏﺨ誈꿪裸耈 䈄ⁿ絅壾愠⑏︤豆  㳲䤤퉉䛰৾툩⒑警 ᄁჿ俢咟ढ﹉⣾ 纔ཀ韏䒔䥔ࡓ䣂 䈄⁻﷪勽⩒ﵢჽ∞  㱼ф⒀䃿ഃ䣄恀 ︡੾됪纤≾吥纄䦂 縑ॾ萯織╾鐩縒䛂 㺊Ƞﯨꋺꢪ琢⒐꺲 硈輐俤鉉⛾슄⡄궎  磨謐꿪鋩⫾ꊊ⣤ꆎ ﰤ腐￡䠤俺⒃菸 ဂ㱺䓆毄ꓹ蒦翄ꑊ俾 ဂ㱺䓆毄ꓹ蒤￡а䷼ ᄁჿ翂䣿㿎䨤菸 Ѐ䃿䥉ሿ艈⒃宅⿾ ﺅࡐ뷨傝졐뷨邑࿾ Ѐ聿쑄翄䑄䟼ँჿ ︂@᲎䐄⁀㾂ࠠ菸 繀⼂倥織ी䉄⑾ Ȁⁿ儅ၝ儉႑⏞ Ă၏ंﱈ䲤充ࡃ䓂 Ȁꃻ節ꃻЁ⑐⣸ ︀߾䀧﹅ל䔋̐ Ą遉ຒ佄顉ڐ줄鉏⶞ Ą၏䤄ﱈ䚤텅ࡃ䳂 Ȁꃻﯠꀒ࿾ႁဎܜ Ȅ⁂Ц箄⁂Р䈄≚⸾  䂂䐄҈䡕⅒嘤䂌䤼 Ȁⁿቑ෼呅䒣諆 Ȁ‿∃ﰠ䉄䒄「蜆 ჷ⟢創⵾劅䡟 ꃡ∂≏␪蚪欪₦⊞ ⡞踨㺊⺤莈 ﺑ⿾䨏뺊྾訏뺊ঞ 纕⥒劗鐉䊔⭾ Ą၏⤂ﱈ䚤텅ࡃ䓂 ⠞ʎ耨ﺊ⺤辈 ሇﰒ俼鈏︠ꏼ₃谆 좗ᵁ㻜蕾咅좠৾ Ā郹इ鸉豈鸑ؐ 䅘判俸╂剄葆 簠輾⪢㹺ꚾꪪꨬ̾ Ȅ⁻䯯螾䨯푈졲 ҂䠿俬聏濤鉏 ﱀ䐄翄䁟葀翄䂄⡾ ҁ䡔#琢겪䩅㑐ꐲ 䠤轈ⓢ硤虈뒊䠧ꋎ ﱄ䟼䑇ﱂЦ箄⁂⾾ 븠达₏빂Ц箄⁂⾾ ﹂⟾䀅﹐◾倩ﺐ⇾ ႁჿ㾀䃿￠ꀱ谆 Ѐ耿興㾂ࡿ쑄翁ჿ Ȃ‣⩂ᡦ朐ꃊ쀣Ȏ āꃯ⿯鈩⛾把䢯 ﺉ࢐褉ს耈ÿ ︄⁄Є䁇葀䐆䂜࠾ 왁蟆䆏蝐ᇥ큑⿞ Ѐ䃿ᄇ﹂׌䌉욁菠 ĎႿ⢤互ꕊᢩ䬲 ᄁჿ翀䃿㿭ဎܜ OҐ䥾Ҕ伤遉Ґ䬜 ≂ꢊ軮⨢ꈪⳬ 耆 ၅ᑒ⥂頡࠰蓰 ﱄ䟼䑇ﰤ迾⒂䡿쁀 Ȅ⁻㾀䣿㾀䃿 ﺄ䑼 ﻩ⋾⤢﹐ࣾ 㰤⾀⟢`پ넊∤≾ 繄轈埥䉔⥾䡄葾 ﹅⽔忥ၟꑁ蓦 繁⤒ቇ∫⊢⋾ ︄翄р䟼䁄р䟼 ⺪ٮꈁ胤悠컰 Ăဿ俬ၟ䕅졄䓲 ခ옑蟠剧צ䆉䂔♾ ︢迾⪢﹠۾ꀊ︥䊲 Ѐ䁄Ʉҏ倖ɐ⒄䒄⇀ ﺂ蓾ન﹀þ䀅ﺉ䤲 ︩俔ꥏ퐅俔Տ⭂ ︊߼䩇ﰀ߼︤蓄 Ѐ䃿翀䃿㈭ᐐ蟆 ︁ฐम吁Ⴁฐ ȃ㈭ȺⲒ㠬興䌘 Ѐ䃿￪劽뷩ዾ⤦ Ʉ⑏䉄﹉⚒쿤鉉⳾ Ȁⁿၟ劥욐⤆ ā郡ɔ⤮အذ瀪ҡ苠 ᄁჿᄇﱄ䑄翄䑄䟼 Ƀ⑏绽≒럪別⿾ ోࠠﯢ⓺䈤럪"+CHR$(34)+"係 ᄁჿ븀࿾ႅⲔꌘ 縠辐ꨪ뺨辈⏢蠨迾 ćኗ￪鋻䫞蘒㺪⪾ Đᄁ྾訨ꊊ⾾ ∢俸∂≧䚨눊∢䈨 금㿪⢢蒼䩊ꒋ꧂  ಏҀ࿨衈肈忤䤂 ࠂ뺬蚞㼨鹛₞夤庉䬢 瀠蟼袡ဿ興㾂࠿谆 Ѐ䃿㺄䐿踈㾂࠿谆  纸訾諸㺪⩾戠븱䱢 䄄ၽ﹅䑕俔ꒊ䣽䂢 蠄︒ྠ叅⓻䕌呅䲗⦂ ︁ Ѐ퀴豄Р䀄@ BР䓾䁌ф䐤䁄р䐜 ဧ䀧⟣࣏ Ѐ䀄߼Ѐ䃿ਁဠ谆 ﱀ仼䁅﹑⧼鑉쐐 Ѐ䃿뾡ထ߼䑇ﱄ䟼 ﺀ⯺ᄁ߼䑇ﱄ䟼 ࠀ胿ሂⁿ쨤≂␢쀠 Ȁⁿ䡅繰䔤光Ґ䄌 Ăုꊊ䢯꒢䨤 Ą၁໾䄄၏섄⡄䶂 ℂ僽﹊䓽䩔ﺂ䡅䦢 飠憘ฃᣞ戀㿢၁А ႁၿ삠䩂ꠊ࿾₃菸  ﺀ⒔ՈG쀈Ă﹁࠰ ထȈ䁈ȑ Ѐꀱ谆 Ȅ⁻₂џ䑄⑀䐌 Ȁⁿ忧⑑䟾ꪫ嘨ꈆ ހ䁿忄䁟忨蒏삄 ᄁჿЇﰄ࿾Ѐꀱ谆 ю䠏મ氂胾纤⹾ ߼ꁃﰠ䏼⁃ﰐ蘆 금뿮⢢誼꒫꧂ ℂჹȐ↏퐡⎐ꄊჰࣾ Ѐ耿興㾂?숄㿀䃿 N䒤䪾蒪䪔ꡌ蒈䢌 Ђ䀧俌呅䗾䩄ꑏ Є䁇䕅﹅䙔쿤J괪 ć鐁‐￡ࠐ藈偅ў⸂ 䀇ﺪ迾⪏︠莾쪂ꠗ ᄁჿ翨ꋿ꒒缤鉿⒜ ᄁჿ翪ꣿ￠R䢒  ỽ⒒䥏䀒ﴨ劅쿐 •˸∾ 숢−Ƞ⿆ ︨⿾⨢頻ꚪ꾫∢ꋺ ﱀ䟼䑅䕔彄䊄꯺ ᄁჿ㾀ÿ㾂࠿ ᄁჿﯨꋽ䈜㨪红⾾ Ăᐡ␐忬၁А䊄⡄䖂 숁➒䤧鈁⿒ꔯ스⿆ Ђ䁏࿂葏챀俥䑃藆 ︠ɼ粠૾ꤪ︩⋾ 纔⥀䒔佔镉࢑䭢 ﹀ོᑂ籀೾椤﹉⓾ Ȏ₯蒯칀꿫䒣识 Є䁏⿂葏챀濥䑃藆 ︊߼䩄꓿俭䑃藆  ꪊ꒪໨艏令ꪒꤪ ሁ⃿설翅⁒࿾鈡∢Ⱜ ⁂༠䈄⁄ل쑄葈곲 Ԁ傟쑔Έ偕Ǿ䔤劉⬜ •Р䈌⁄ф䑄葈ꓲ ࠊ肯늪䨥⎒∠䈘 ኑ∾飯ꪦ蘒⊪⪦ 砠舄䁄ʿꢈࢁࠐ蘰 ࠀ胯늪䪥⪒ꨪ⋠䀘 Āჯꕋﺤ䫾꠪ﻤ䆂 Ą၏﹄䓾䠤ﻤ䆂 Ăုꕋﺤ䫾ꠢ︤䎂 籀亄䠥ɟ䑈䲘 ₂ࣻ狊䨀Ʉ䒀䀛ฎ Ѐ䃿剋謁௼∇ﱂ䟼 㲰䩄␯舯手䒤䈘 Ђ䠕࿾⒇ﲤꏸᄏ︑، 㱀䡄艏≋䒤䈘 ﰄ࿾ꔩ䨏Ȉ翈訐蘰 Ѐ䀄࿾ࠑ਀䀛ฎ 뺊⾾訯ﺑ⧲鄩⠖ ︄@￨䊄⢢鄪઀⠆ ࡂ䐠藾䑌䑄䗾䑄䑈䒄  ᠾȀ㿂အȐ￠1谆 ﹐◾⡟剅ﻤ䁄 ∊ꀣꕏ墮恀翄䑄䑌 ︄ф⒀䀄࿾Ѐ䀄@ ∊ꀣꥏ颮愐ᄏ︑ؐ ︡༐⿢鉩⚪걪舨⊆ ႀ蠁߾ऀ遉⊔ऀ选߾ ᄁჿꨊ븢俄ꥏ钩諦 뺊⾾訯뺂⯺蘨ꊲ⡦ 袮좪ਐ꿬ႁࣾ Ѐ䁄䉈Џ︄Ðᒂ䓄⁀ ︄ϸ₃菸₃谆 젷핅푓璅織藈 袏蟯袏萃ﰄ࿾ Ȁⁿퟥ푑䷾璅纔览 ဧ⟢䋷￡а䷼ 芉⢒襤ቹ⒒褨興✆ ∊ꃻ力䟼䁇ﱀ䟼 ᄁჿ翄ꑿ쁈翤⒡襦 Ȅ⁻翄䑊䔔䉧롂⾾ ︠Ӿ䠬﹈׾檤﹊꒪ Ѐ䃿䥈鈐Ǹ悀逎༞ Ȃ•Ƞ㿢 ϸ₂ࡀ萈 Ȅ⁻￤ѿ쐀翪势 ﹀ࣾ﹈࿾⪪ﺪꊪ  ﹁−Ġ⋢≂ⓂPࣾ  繄ɼр哩䊈⅂扐ࣾ ﹈⋾ࠁﻪꋾ⪢꩐ࣾ ︡Ӿ䤬﹉⓾䔄い薆 ć႑ɾ浪銩⾢別ಐࣾ 硈輐忥ቑ⧾⡄ꖎ ࠀ耐舄￡ထ࿾ᄁအఐ 综蕾窢뻺ꪾ廒飹䋢 ︨⒂俬၏䎄呙␐ ć኏勷劕⽖ ă቏勷럪別⽖ ﺄ꯺萫瘝꯺꒫瘝꿾 Ą቏俤鉏쿤鉉Ⲗ Ѐ䀧쉀␏︤葄ఀఇހ Ѐ䋿翄䑿쑄翄䑄䑌 Ą቏ῢ鉏濤鉉⒖ Ăዿ￪鋿￢鋹⊖ ā郯⿯鈯濪Ⴔ䉺 ᄁჿ㾂ࣿ翈訐蘰 ᄁჿ㾂ࣿ⒍߼ ᄁჿ㾂ࣿ⑌䈥䓔 Āቿ䄄၁␔䂄ᢆ䦂 ᄁჿ㾂ࣿ㾍ᘑǰ 芈⒏﹀蒈蒈ࣿ Ȅ⁻ῥ␿줤忠ш䡌 ᄁჿ翁ထ࿾菸 ं逩䤬艎꒪剅⑂ꓒ Ăု俬䡟埤၏  ?弨ኁ⏲⃂ ⏾ 興㾀䃿ః壄恀  㻺∠￤ꉊ꿪≏萡ꉢ Ѐ䃿翁ჿ彈䉿쁀 Ѐ䃿耣@㽀䈄࿾ 㸬∤ꏊ쪣ꯪ裿 Ј䋿椀豆㾀䃿 Ј䋿篤ꉻ篤ꊊ⦦ Ȁⁿ俥ɯꐊ復Ґ⇾ Ђ䀧⾢訠ꍺ䀤♾ Ą၏俤䡟ퟤ၏ ∂‣⑂䐹䒔䢈袉䍢 Ѐ䃿ࠀﰈ䄄၂Р聰 빊⒢篤ꉊ➾䨤ꊊ⦦ ĀႏĈ၏т䑉꣢ Ѐ䂇ྨ詀ꁺт䁄⡾ Ѐ䃿㾀쀠Ѐ䁒䢒 Ѐ䃷⾢詰굺呅䁔❾ 㹌⤤䩛⯪袬̾ Џ䂗ઐ꽺鑉䂔⭾ ᄁჿЏ︐Ǽ၂Р耰 ᄁჿﯨꋻ误ꈄ↎ ᄁჿ钄砙湼ℂ﹑ࣾ 㸬⾤ꯊ쪫⏢蠯 Ѐ䃿俌_唢ⓡ菆 ďဏďḂ•䊐优 ਀ꁿ쒤翄꓿㾁ထ࿾ ခỿℒ﵁᠑俲ᄡሡ찐 㹌⠤쫷ꯪ蠧 ȇ₋ﮨ諸ꢺ琢ₒ⺾ ﱄ䗴充䗴偅婢꥚ 邫쪤﯊꒫ꯪ芪ꪮ  㱼@Џﰀ耐∂䁘ࡾ Ѐ䀄࿾  Ȁ  Ǿ Ăဿ䒍﹒⓾䐄繈⒌  ˽⒒䤯툁‒ﴨ䊄⿆ Ąၟ㹄⑂䠤苠䀘 Ą၏儅Ṓ⤢䉀䐘 簤䉼ﱊ粠૾꠪︨⋾ Ѐ䃿 쁀ህҐ⃸ Ăအ˾ꐊ䂤ੀꐂ䀤Ⱦ ︀߼䁇ﱈ߾倉ﲠ䈘 ﱀ䟼䁏︑࿾⒍嘤蓄  㻾␾䈣븄⟼Ѓ࿾ ᄁჿἁဟ@￠퀴豆 Ăု⿢䡿랪ု ﹀⟾䀧︀ϼ⁃ﰠ䏼 Ă၏Ṃ⼢␫䊠䈘 ď႟Ẓ⼢鐩䊐䬘 Ў䊿䩈＊ʯ亘꼊ꊪ䯸 ю䐏ߎ䐇쀐ゥ侒 郗㟭䈔⍾튁⠔Ꙏ 纁⢒諸䰿興㾂࠿谆 ă⁄⡾䣷ꢊ︠辈 ĎႿ숊㺤⩂꠬芀䠘 Āᓡ⨐뿪Ⴁਐꊊ⣤䆂  绸艾갫縤⿾␢繒䣂 ȁ‒Ħ‒Ġ㈍−ℾ Ԃ吿䒍﹁Ӿ䄅﹄薆 Āခ耖ĘခĀ ﱄ䟼䑇ﰄ࿾䥋宅࿾ ԅ呟䒅﹁۾섅﹄趆 ℂအྐℂᡡ䜒ꤚအȐ Ȋ₣ꑊ䐡䎔ࠣ䋂 ĎႯ￪⢢껎ꄊﻡǾ āꃯ⿯ဥ䚲烊犠싰 㹊⠢諸⋺∢ꨪꈢ⾾ ℂჹɾ廊鉱™∯숤䘘  碄葈Ҩ蹀ü䑄䢃视 ȏ⁄⑂矩վ␢䉄⡾ ﹈⓾ꩊ꒾䢅䫴ꁾ 縤≾ﰪ纩⩔꿢⠤ꎎ Ѐ䃿㒌䘿腐ᄏ︡Ȑ Ѐ䀄࿾ЀɈ䑉@ ﺩ−ﶦ㚩⾒꭯⾶ Ȑℂ逥Ȑ䄄ኁ⠞ 砠萄뾠蠐舐翄ꑊ俾 Ȁⁿ緤ꡘ웺䈋ﺂà Ȁⁿ緥걨ꗾ蠉︰◾ Ȁⁿ緥걪ꗼ剉ﲅ⎞ Ȁⁿ䢇蒘嫊쪈肈 ﹉⓾鉏俤სþ Ą၏儅﹑ऐ呙␐ Āჿ鄉ﻱऐ鎉퓱‐ ∂‣⑂䑡䜔ꢊࠣ䋂  ?忁␒俾⑂䑿  ﻩ⫾ꤪ銯꿪სþ Ăု⟢䉧꿪$䊂 ᄁჿ㾂ࣿ翊䨤艘 ɏ⒟䊗鿩႒䭂 Ăု⤢ቡ蘨늊⨤ꎎ ć႗ﯪﯠ⊪⪦ ︡༐ℂ健딊倥˾ ɇ⢟￪꫼￠ʪ⪖ B䐧佞╂鑩䙔돪␤䎄 Ѐ䀄࿾ऀ遉䒔褩ሑذ ︨⒂俬O俤၆薆 ﰀ䀄၁ࠐ肐਀怙踆 Ąၟ䄄﹁ؐ쎄呙Ⱀ Ѐ䃿ЇﰄÐᒂ䓄⁀ Ā႟Ĉ﹁䎄咙⠐ Ѐ䁇ீ裡Ȣ␢籐ࣾ ︨⒂俬葈䔤儥ɆМ ᄁჿ￪勗勽橺 Ȁⁿ緥걨ꗼ偋ﺠ⏾ ︈ࠀﰈ䄄၂Р聰 ﰨ䋼ꡋﺤ꯾ꡂ䐣菆 Ҁ䢟Ῠၟ唥纐⤆  ﲈ䓼ࡉ﹒ꇾ䡄䒃视 ᄁჿ㾂ࣿ￢ࠟฎ Āჯꄋﺡਐꎎ吙‐ Ѐ䁿쁀Џ︄Ðᒂ䓄⁀ ₄ࣻ￪袩쾪咅梐⧾ ﱀ䐄䁇ﱀЀ䀄ɀ⏾ Ȅ⁻ႇ︐臸ႏ０蘆 ︩⊒꿪銩⫾ꄊ郹 Ѐ䃿光∌䜼Є䑄䟼 Ѐ䃿光∿왈⒃宅⿾ Ā႟࿨䡟埤ႆ覆 ᄁჿ翂ࣿ㾡ⓡ菆 룤䊂⟏'옄把邨䉲 ຯઆꢪ꺪ꩋ⒢⨢ Ą၁པ夥ၑरс蓠 Ხਦ⎎昸縊₢∞ ﱀ䐄翄⁂߾䄄၌꼆  维⥂䢔轾鑉䓴⁲ ď选⅏頮抐矪ሢ♌ ᄁჿ翄꓿뾠蠇ހ  ⪏︪芨￠R䢒 ࠀ逐迼Т䀿쑀萏︄@ 脐ਏ︂⁤᪎ à ﰄ࿾ꔩ䩻旅盒䍌 ႍ倗설ￂꐫꯪ芽ⱖ ࠯⟢䉤♾낊䨨ꈘ ﹁⽜唅繜⥾繄⑆ Ą၇埥䉗䡄䑲 ﺀ⯺₃菸Џ︠谆 Ѐ䀏섄梀倂þ㠬興⃾  舄羨{䨤ꉺ  维⥂韯䊔⥾䈈⌎ 纔⽾鐩维₆翄ꑊ俾 Ā၉≔Āﻣɔ⤢ၐࣾ ă၉諸哸舾긪∢⾾ Ā⃯쪄꿊蒯꿮ȕ⅖ ﹁༠吥繐褈ࡀ蓾 Ȋ₢ྡྷꉊ⠣Π∢∾ ટᾉ䩝ꅊ婅ⲡ⩢ Рￄ䑄䟼ሁ∢ⰾ ဧ⟢䉧꿪鈩成 ၇䉇⿪銩成 ﹁ࠠꩋ꾪⮪ꪪꋾ ︄￩ኟ⤒鼩ኑ⿾  ﻱȠ￢䫷ꑊ璭︰೾ ɂ␯⟢䈧ဢ䛂 ɂ␯⟢䉧꿪ဢ䋂 ᄁჿч﹂Ф䆄ႆ覆 Ѐ䃿 ﰄ࿾ႃဏ܌  Џ︄@翄ꑊ俾  㡼༇耈惸興⁾ 粠䐈䄊︡ؐ꿢ꨪ귾 Ѐ䃿䀃ﰀ߼䁇ﱀ䟼 ﹈⢪﹉⿾⨪ꊫꊆ ᰮ༦⎏漸⸇₢∾ ᄁჿ￨ɿ섢晁룢惀 젡䂭萞弥幕◞ Ѐ䀄࿾ЀɈ䑈䈄@ 쪤꿾꒏젡侢РR䢒 ﰠ䈄㿂Р䏼⁂Р䏼 Ѐ䃿ഃ䣄怀翀䀄࿾  ?䤨銑™∤䈈䀘 ч⒈艾煮ꓺ䣾爫⒊佄 Ѐ䐄⿼Ѐ䀊 ሁ∢Ⱎ ︀߼䁇ﱂ߾興倘蘆 ﺢ⨢⨯戢♒璪芨䈘 ऄ郿翀?興㾂࠿谆 뺊⾾訯뺀⠂鼩ኑ⧶ 뺊⾾訯뺀⢂萭ઐ棲 Ă၁৾䑄伨⊊Ⴆ莆 뺊⾾訯뺀⠂耨ʀ⠆  ?刨ꊄ⁂ਡሠ䀘 Ѐ䀤쉴㱎䐤䉌␂䈠⇾ Ȁ₄⒂⿠ þࠢ艈⣾ Ѐ䃿⟄ꑉ䵈劄၆薆 냠ฏ빊➤䨧ꋊ삠 ﹊➤䪄꡺䒢䨧ꋊ삠 뺨⾔ꢊﻸꈊࠠ辘 ȏ–ࢂ콊ᢡࠐ蘸  ?쉀䐈䃿؀逰谆 ﹀Ѐ俄葈䒜䠄芈⡾ 硄衈Ң蹀೼䑄䡃藆 Ђ䁇艂⼒‪芨䈘 ᄁჿ鼥ᒟℐ￠퀴豆 㸂⼢ȯ㸂耨⒔⽂ 皑⥶瘢䭾겊纤轾 Ą၏⟪Ⴏ꟢䋷 꾊⪢ꩪꛪꪪ⸤艈 ᄁჿꨊ빲䪤﵄鑱裦 ࡋ甆㻽䉞딪帬༾ 簨⍾ꀊꫪꪢ⊦ 蟴쩧ꑊ䖌Ё⑐⣸ ĀႁӾन鉉⃾ढ鉉⣾ Ѐ䁿ｄꙺ䲤峀⁐䧲 簈⽾ꃪ⺦ 糸≾ꫪ甆⊦ Ȁ⓲䥾钉ﺔ襈韩䣴聾 Ăု䄌⁇琤䉄⑾ ︨䋼䡇ﻊꕄ䟥쑃藆 ߼䑇ﱄ䑄￠舰Ⱌ ࠀ胿ཱྀࠐ芈䔈「蜆 Ѐ䃿翁?옄뿂п숄 Ѐ䂔꩒옪횔꩒￨䊄⿾ Ђ䀧퉅ᡒ䓂ȁᑐ⣸ ︠菸₏ﺒ└辧ࠏ༎ 縤⽾ ︤⍾縬☂ Ѐ䃿ࠁﰰ䷼၁ﰐ䄌 Ăအ࿾⤢鉩⛾ꤪ鈩⋾  ﲀ蓾न﹉ₒ忤⊄⦌  ﲀ蓾न﹉ₒ࿢鉉⢖ т䢯俪ꨪꛎꠢ︨⳾ 䢅ૼꔈ￪䢤跈蕏풆⿂ Ѐ䀄߾䐤䉄⟾䐤䉄⟾ ࠧࢁဣ먢∢∾ ␤⼀ᆁ␤☀돢ꈢ∾ ︁໾̎퐁⃼⚤⾌ ऀ邟࿠ꋪ䌾≂챐ࣾ ﰠ䏼﹂␢翤@⏾ ⿔喏╒ﴡᰑ࿐ Ȃ␢俾⒂﹄蕈埩䢤菾 졈螾ʯ꫾슋ꪒ꥾ ࠀ耏섄၂葄耨Ā‌܀  Џ︄䁈Ѐ䀄ǀ  Ȉ彈䈄߼Є䒄⇀ ခ섀ခ迾ࠁà Ђ䣿⒇ﲀ⏸菸 Ќ䚿굖鼭嚿ꡂ￠@䠂 縑੾䐯織╾搤繂䳂 Ăု俬鉋忦鉏 Ą၁ࣾ鄥ሢ∢䐥䊐优 ే༐儅ၟ⡄䖂 Ѐ䃿ꂤȈ翊ਠ菸 Ȁⁿ翤≟翪⊿ ﱈ仼䡄﹈׾鉒ⱌ ﹀⺤䩄﹁۾섄鉉⳾ Ȅ 䥅㹞䒾퉅﹊䴾  ⫮ꈪ諾뤊ﻩþ ﰨ俼⡂﹨߾꒪鈲≌ т䠯⟢࡯뚪Ⱔꊚ ࡀ䒀藾Ĉ၏䄅ﺁࠐ Ȁ₟ࡉ㉄肄忤蒈䣼 Ȃ‿ꡋ㊤芄忤蒈䣼 ﹄⑂翤䉄⟾䐤䊄⡎ Ѐ䃿珀逿聀￠R䢒 ₁ࠁ࿾Ѐ䁿쁀Џ︄@ 皩⭶ꄢ盲䕾咅纜衾 ᄁჿ翂䠧舀￠퀴豆 ᄁჿ￪੎䤒㾆ಠꏸ ︊߼䩄ꑿ삀￡ࠟ، ︀⺤੎︁þ銩⻾ 粐褐￢鈯꿪銩⾖  ﹀⊤࿠ჯ┢繐ࣾ ﲨ䫼졊ﺨ௾꒬銒⡌ ႁჿ翁ဿ踎㾂䰣ྎ Ą邅䪏졉䞢Ё⑐⣸ が䤤鉉⚒쬥퉁氐 ȅ₋㊤誄耈賂钊⿂  ಏАĈၟ䄄⢄䦂  䒈␀ƈ⑄₀ߢ䉄⡾ 빉⊊䤨ꈘ恀翁ထ࿾ 빉⊊䤫︤蟼ᄏ︠谆 Ā႟﹁䧤邏଎ ﺑ⿾∅⒧ﯢ⒪䪾 ︩⿾ꤪﺩ侪⟢蠪꾪 ﹉⻾⤢﹁෾挄呙␐ Ѐ䁿쁀⒁倄࿾ഃ䣄恀 ᄁჿЇﰤ腐￠퀴豆  绸舾飯뺪⾾∧㺩䉢 ﰄ࿾ꔩ䨄߼䑇ﱄ䟼 Ѐ䂇쒄ᒈい肆忄蒈䣼 Ȃ⁃ᡂ佂⿪䊤≾ ᄁჿ䟂蒄葸ࡡﱈ䣼 ȏ⁃爫ᣒ䭂鿯䊔⽾  탱Ȑℏ퀡Ȑﴈ劅⿎  ␒斥噅◒嘉̐ Ј䋿翄䑟䕔彄䪿ꠂ 꿮⪢⛾ꪪ먭抒 藾ᄉ忤ꪊꧾ ᄁჿﯨ샹ￄꑊ俾 ᄁჿﯨꋻ￩功⩎ ȏꂣ觯迸₃⸾  싱ℒᄯ툑⌒天䈐℆ Ѐ䃿翄䑄䟼Ѐ쀓ฎ ﹀⟾吆繌䕄柪꒣苆 Ѐ䃿㒌䘿耠Џ︄ǀ 툡⿒ㄦ튠恀￠퀴豆  ﻩ⓾䤤鋯俤სþ Āჿ䤤ꫯ忥䋷ꄆ Ȁⁿ詾겊䲥ꊩ⢆ Ѐ䃿㾂䡿쁀￡ⓡ菆 ﹉⻾⤢鉏濤၁Ӿ ﱄ䟼䑄䑿쁀翀䀄࿾ ᄁᓽ䊾鉊뻾䄤￪Ⓔ䡾 ĎႯ쿪⢢꫎ꄌﺁ৾ Ă၏ῢ቏俤ၟ Ѐ䃿⪀䁉䧲Џ︄@ Ѐ䀄࿾ࠐ脈ᄁခ࿾ ᄁჿ俨ሯ쿤၏ Ąၟ俄葈䛼섄鑑ⰰ Ȁ⃻ꩊ飺䫂ꯪꋺ‾ "+CHR$(13)+"ꪪ횣쩂꿚Ⴏ⿦ Ā႟ш懲⁔Ղ呉䢖 ꔪᔩ陀þढ﹉⣾ Ȁ⃯䑄﫠⑔䕄哩䂖 纁⤒訯䰀߼䑇ﱄ䟼 Ȁ⃿⑂穰ⵔ啅呙䜖 ĂႡ૾‏䐤䙄璊䢠苾 粸䩈쎋용૾턉粁৾ Ѐ䃿ᄏ︤菸⒃宅⁾ ∂⃻ﯠ˻ﯨꃺ⢾ ︨⒂俬၂Ӿ䠤艈⓾ ހ䁿必⑟씤鿈逨䑺 䐄䁇䤄⡾꒪䩈ꒊ⌢ ހ䁿必⑟씤翨䊈⌌ ﰀ耐Ȁ䀄@Ѐ䀄ǀ Ѐ䃿₃࿾鈡•ⰾ Ăဿ俬艟俤၉䔲 ︄@￨䊤ꩊ꒫婢⠆ Ā႟ῠ䠘恼塄䢃视 Ѐ䃿翅ᐿ贖ἀ䁄䣂 Ҳ䨔⁏䐢䘆燊䈄 粑䑖ू⑄迾ഃ䣄恀 Ā႟࿈葈䃼䄄钑⠰ Ȃ銤䓼䥊ﰩ䚔꿂鐩Ⲓ Ȁⁿ￤詟캊侄ₒ䩢 Āჿ䊯꟪ჩ䄲 ā郯㿮⠬昼汊䢣苆 粴䩼⑏︩⛾椪ﺡ˾ Ѐ䀿興㾂ࠠ菸∢ᐬ輆 Ďဟ࿎萈䃼钱⸰ Ā႟ៀ웷숐⥃㉐ࣾ 菸₏︤菸⒇ﰄ࿾ ĎႯ⢬樼걌䢃视 纑~维╾否繂䓂 ࠀ耈࿾ࠠ興₂အȠ䰸 籀䥼﹁⻔▊钱≰ 㠤䒂埬O䪤﹊꒪ ﹀׾儥﹑◾䄉ﺁϾ ₂ࠠ轾₂ࡱ蚬꒪蠠興 Ҁ䢄藾҈䡍腬Ң䡄衈 Ă別䫾ꕊ鈧䉞啄뺂䣄 Ҁ䣤藾䒄䣭蕬䒤䣤聈 Ѐ䃷ꯏ⒓케껪꫺ꃮ 㣴䊂￪胿甆ﻺꊪ Ď劥䫾않銮䪾멌纄䦄 ć劕䉾壘勿䩞﵀㺪䫄 ℂ勽䩾﵊勿䥞﵉㺒䷄  ꒪䬤훠Ӿ䤤ﻩ⃾ ﱄ䟼䑇ﳀ捘쑣࿾ ﺀӾࠨ﹉þ儅ᢂ䣂 ﱄ䟼䑇ﰒɄ￠䀤豆 縠迾␧纬≾ﰢ繒䣂  舄羨 ߼р䐅聀 㠤䒂俌@׾䈤≂쐠 ꒊ亭⩒꒪䒤䉈✆  碈䔂࿀ ׾䈨⊂쀠 ď킁࿾ꄪኽ⩒ꔢ扄▌ Ј䋿蟯ꈃ䯤聚䑂 㠤䊂꿊 ૾ꈢ∢술  㣤䒂俄àӾ䈤⋢쀠 •ྠਁ•ؠ눢ꈢ∞ ᄁჿฃᣟ怀翀萈䂘 ᱂⡀øɾ넪ሡ澐 Ăჿዷ﭂墩䬲 ﰄ࿾ꔩ跶ﰈ䂘 ﰄ࿾ꔩ䩿쀀￤ꐪ迾 븀྾ꪠ䁿翥႗⮞  Ჺ⩀ﯥ¨྾꤭銉澐 ﹈蟾䦅걨ꗼ偉ﲐ䇼 ﹈蟾䦅걬꒨䈉㲒Ͼ 숡−㴤剥⥒ठ舰Ⰶ Ђ䠤䓂膁ϾР舰䰸 숡⏒攩刉ℂ恠R䢒 툡⏒攩䈈愠￡ⓡ菆 Ȁⁿ忤剿忨傕䉒 Ѐ䃿䥈鈑ȀЁ⑐⣸ Ă別䋾ꕊ銮䪾멂縤䎄 ࡏϩꩋ俤袔ਾ Ăဿ꿪鈯忤ゅ䦒 Ȅ⁻翤剿忨傕䉒 Ă၏鉏⿪ゥ䎒 ȯ䒪깄ꪪﻢ說ꪮ苈 ᄁჿ俢鈏⿢ၐࣾ Ā၏࿠鋯⿢ၐࣾ ă၏￢鋿꿪〥侒 ﰠ䈄⁃ﰄ߾䀤ɀ⟾ ࿼䑇ﱒ䯺䁇ﱀ䟼 㰤迾⤢﹪Ꝿꐪ縤≾ 縠઀럪䈤≾吅䂈ࢀ ȏₓ驏ᢒ䥂ﯠ≒⢾ ȏₓ既ᠢ䭂ꏪ⊢⾾ ﰄ࿾ꔩ䫳侼 က葄舐￨䈄߼ࡀ萐䘸 Ѐ䁿쑄￤䓿￡ࠟฎ Ѐ䃿뷪劽䩔봪銥쮰 ︄ϸЀ䃿￡အఐ  㻺⢢ﯨꊊ⾾舩⊊⽆ Ă別俾╂鉢߾ꑊ젣苆 Ђ帯⾒⽂顩䛲뤪눭슐 Ȁ₏쒄࿈葈䃼ढ鑈裦  ﺈ⓾ࠈ﹉þ䤤뚕ꤒ Ѐ䃿ꐣﱄࡀ￠䀄@ ĂႯ쒄俊萨䛼ꤢ鐨賦 Ȅ⁻Џ︑࿾䑇ﱄ⁾ Ѐ䑿ԏ︈Μ츀耈⃾ ℂჽ￤艻￢࠿ Ȣ鈤俼ꥊﲩ侔⿂鐩⾒  㻺⢢煮ꢊ侢舩⊊콠 Ѐ䀄࿾  興䁄Ҁ⠂ ᄁჿ锧﹉⟾ꄋߞ 籀佼၁︡ⓔ鑑⑰ ď႑ॾኑ⼢鈩䊔䬘 籀䡼ﻱ⋔ꖊ鐱⹰ 㠄亂࿮ﺪ꺪 ︡׾䌌呉◾䑄䡃藆  샱ᄯ→㔥㊑℞ ؇輈縀耈䊔⽾ ︂À㖌䘄߼Ђ砤࿾ ࢟鄏㺖⦾㹒⢦ Ȏ₯쨤䒿ꪪꪳ⩦ Āዿ祄衉䞢āѐ⣸ Ȃ 켤≂䙥ؐ뿪အȐ ᄁዿ綁⩔₃﹀⥖ ︈ཱྀ䠒芐─ ࿾ ︀ϸ₃興㾀 ࿾ 纕≾ﻸ૾豈㺪⪌ Ďဏǎ>₢⸾ ᄁჿ￥ᑟ䁀￠퀴豆 ᄁჿ翤ꁿ咧좡䩢 Ăု⻢ꩪꚪ뛪⠤ꎎ Ȁ₟ԩ﹀⃾䠅ﺐ⠜ Āჿ⻢ꩺ굪勥⡔ꞎ ĎႿꪪ꺪뛪⢤ꮎ "
    KNJLIB_FONTDAT$[3]=""
  ENDIF
END

'
' ●文字のエフェクト設定
' GKNJEFFECT 8
' GKNJPRINT 命令での影付きと縁取りの設定をします。
' 1:影付き 2:しっかりした影付き 4:縁取り 8:しっかりした縁取り
' 上記の数字を足して組み合わせることもできます。
' (しかし、1と2、4と8 を足しても「しっかりした」と同等になります)
' 文字の倍率が1倍以外の場合、1:影付き しか使用できません。
'
COMMON DEF GKNJEFF EFF%
  KNJLIB_EFFECT%=EFF%
END

'
' ●文字色の設定
' GKNJCOLOR RGB(255,0,0)
' 文字色の設定をします。
'
COMMON DEF GKNJCOLOR COL%
  KNJLIB_COLOR%=COL%
END

'
' ●文字のエフェクト色設定
' GKNJEFFCOLOR RGB(255,255,0)
' GKNJEFFECT 命令で設定した縁取りと影付きの色を設定します。
'
COMMON DEF GKNJEFFCOLOR COL%
  KNJLIB_EFFCOLOR%=COL%
END

'
' ●文字の背景色変更
' GKNJBGCOLOR RGB(255,0,0)
' GKNJPRINT 命令で文字を描く際に、背景を描画します。
'
COMMON DEF GKNJBGCOLOR COL%
  KNJLIB_BACKCOLOR%=COL%
END

'
' ●文字の描画方法設定
' GKNJDRAWMODE #G_ALPHA2
' 文字の描画方法を #G_*** ではじまる名前の定数で設定します。
' 定数は GLOAD 命令のヘルプを参照してください。
'
COMMON DEF GKNJDRAWMODE MODE%
  KNJLIB_DRAWMODE%=MODE%
END

'
' ●文字の描画倍率変更
' GKNGSCALE 3.5,4.5
' GKNJPRINT 命令で文字を描く際に、文字を拡大します。
' 1x1倍以外は描画が遅くなるほか、エフェクト設定が 1:影付き しか使えません。
'
COMMON DEF GKNJSCALE SCX,SCY
  KNJLIB_SCALEX=SCX
  KNJLIB_SCALEY=SCY
END

'
' ●文字間隔・行間隔の変更
' GKNJMGN 5,0
' GKNJPRINT の間隔をピクセル数で指定します。
'
COMMON DEF GKNJMGN CHARMGN%,LINEMGN%
  KNJLIB_CHARMGN%=CHARMGN%
  KNJLIB_LINEMGN%=LINEMGN%
END

'
' ●文字間隔の変更
' GKNJCMGN 5
' GKNJPRINT の文字間隔をピクセル数で指定します。
'
COMMON DEF GKNJCMGN CHARMGN%
  KNJLIB_CHARMGN%=CHARMGN%
END

'
' ●行間隔の変更
' GKNJLMGN 5
' GKNJPRINT の行間隔をピクセル数で指定します。
'
COMMON DEF GKNJLMGN LINEMGN%
  KNJLIB_LINEMGN%=LINEMGN%
END

'
' ●文字列の描画
' GKNJPRINT 50,50,"ヒャッハー!漢字だー!!"
' グラフィック画面の指定座標に文字列を描画します。
'
COMMON DEF GKNJPRINT X%,Y%,S$
  VAR I%,BX%=X%,BY%=Y%,L%=LEN(S$)-1
  IF KNJLIB_ZENKAKUCONV% THEN S$=AKCNV$(S$)
  FOR I%=0 TO L%
    VAR M$=MID$(S$,I%,1)
    IF M$==CHR$(10) || M$==CHR$(13) THEN
      BX%=X%:INC BY%,KNJLIB_FONTH%*KNJLIB_SCALEY+KNJLIB_LINEMGN%
    ELSE
      INC BX%,GKNJPUT(BX%,BY%,M$)*KNJLIB_SCALEX+KNJLIB_CHARMGN%
    ENDIF
  NEXT
END

'
' ●1文字の描画
' RET=GKNJPUT(50,50,"あ")
' グラフィック画面に1文字を描画します。
' 戻り値には、文字の幅を返します。
'
COMMON DEF GKNJPUT(X%,Y%,C$)
  IF X%>#GRPWIDTH OR Y%>#GRPHEIGHT THEN RETURN 0

  VAR I%,J%,S$,B$,HALF%
  KNJDATAGET C$ OUT S$,HALF%

  VAR W%=KNJLIB_FONTW% DIV HALF%
  VAR H%=KNJLIB_FONTH%,B%=1<<(W%-1)
  VAR RX=KNJLIB_SCALEX,RY=KNJLIB_SCALEY
  IF S$=="" THEN RETURN KNJLIB_FONTW%

  VAR SAME%=(RX==1 && RY==1)
  DIM PX%[W%*H%],L%=LEN(S$)-1,DOTCNT%=16,DOTPOS%

  IF SAME% THEN
    W%=GKNJGET(C$,PX%)
    DIM PAL%[2]
    PAL%[0]=KNJLIB_BACKCOLOR%

    IF KNJLIB_EFFECT% THEN
      VAR SX%=X%,SY%=Y%
      IF KNJLIB_BACKCOLOR% THEN
        PAL%[0]=0
        GFILL X%,Y%,X%+W%-1,Y%+H%-1,KNJLIB_BACKCOLOR%
      ENDIF

      ' 縁取り
      IF KNJLIB_EFFECT% AND (4+8) THEN 
        PAL%[1]=KNJLIB_EFFCOLOR%
        INC SX%:INC SY%
        GLOAD X%,Y%+1,W%,H%,PX%,PAL%,KNJLIB_DRAWMODE%
        GLOAD X%,Y%-1,W%,H%,PX%,PAL%,KNJLIB_DRAWMODE%
        GLOAD X%+1,Y%,W%,H%,PX%,PAL%,KNJLIB_DRAWMODE%
        GLOAD X%-1,Y%,W%,H%,PX%,PAL%,KNJLIB_DRAWMODE%
        IF KNJLIB_EFFECT% AND 8 THEN
          'しっかりした
          GLOAD X%+1,Y%+1,W%,H%,PX%,PAL%,KNJLIB_DRAWMODE%
          GLOAD X%-1,Y%-1,W%,H%,PX%,PAL%,KNJLIB_DRAWMODE%
          GLOAD X%+1,Y%-1,W%,H%,PX%,PAL%,KNJLIB_DRAWMODE%
          GLOAD X%-1,Y%+1,W%,H%,PX%,PAL%,KNJLIB_DRAWMODE%
        ENDIF
      ENDIF

      ' 影付き
      IF KNJLIB_EFFECT% AND (1+2) THEN
        PAL%[1]=KNJLIB_EFFCOLOR%
        GLOAD SX%+1,SY%+1,W%,H%,PX%,PAL%,KNJLIB_DRAWMODE%
        IF KNJLIB_EFFECT% AND 2 THEN
          'しっかりした
          GLOAD SX%+1,SY%,W%,H%,PX%,PAL%,KNJLIB_DRAWMODE%
          GLOAD SX%,SY%+1,W%,H%,PX%,PAL%,KNJLIB_DRAWMODE%
        ENDIF
      ENDIF
    ENDIF

    PAL%[1]=KNJLIB_COLOR%
    GLOAD X%,Y%,W%,H%,PX%,PAL%,KNJLIB_DRAWMODE%
    RETURN W%
  ENDIF

  IF KNJLIB_BACKCOLOR% THEN GFILL X%,Y%,X%+W%*RX-1,Y%+H%*RY-1,KNJLIB_BACKCOLOR%
  FOR I%=0 TO H%-1
    FOR J%=0 TO W%-1
      IF DOTCNT%==16 THEN
        B%=ASC(MID$(S$,DOTPOS%,1)+"0")
        DOTCNT%=0:INC DOTPOS%
      ENDIF

      IF B% AND &H8000 THEN
        GFILL X%+J%*RX,Y%+I%*RY,X%+J%*RX+RX-1,Y%+I%*RY+RY-1,KNJLIB_COLOR%
        IF KNJLIB_EFFECT% AND (1+2) THEN GFILL X%+(J%+1)*RX,Y%+(I%+1)*RY,X%+(J%+1)*RX+RX-1,Y%+(I%+1)*RY+RY-1,KNJLIB_EFFCOLOR%
      ENDIF

      B%=B%<<1
      INC DOTCNT%
    NEXT
  NEXT

  RETURN W%
END

'
' ●文字列の描画 (アンチエイリアス)
' GKNJPRINT 50,50,"ヒャッハー!漢字アンチエイリアスだー!!"
' グラフィック画面の指定座標に文字列をアンチエイリアスをかけて描画します。
' 文字の大きさは半分になります。また、とても描画が遅く、文字のエフェクトも無効です。
'
COMMON DEF GKNJPRINTAA X%,Y%,S$
  VAR I%,BX%=X%,BY%=Y%,L%=LEN(S$)-1
  'IF KNJLIB_ZENKAKUCONV% THEN S$=AKCNV$(S$)
  FOR I%=0 TO L%
    VAR M$=MID$(S$,I%,1)
    IF M$==CHR$(10) || M$==CHR$(13) THEN
      BX%=X%:INC BY%,KNJLIB_FONTH% DIV 2+KNJLIB_LINEMGN%
    ELSE
      INC BX%,GKNJPUTAA(BX%,BY%,M$)+KNJLIB_CHARMGN%
    ENDIF
  NEXT
END

'
' ●1文字の描画 (アンチエイリアス)
' RET=GKNJPUT(50,50,"あ")
' グラフィック画面に1文字をアンチエイリアスをかけて描画します。
' 文字の大きさは半分になります。また、とても描画が遅く、文字のエフェクトも無効です。
' 戻り値には、文字の幅を返します。
'
COMMON DEF GKNJPUTAA(X%,Y%,C$)
  DIM DRAW%[KNJLIB_FONTW%*KNJLIB_FONTH% DIV 4]
  DIM DOT%[KNJLIB_FONTW%*KNJLIB_FONTH%]
  VAR I%,XX%,YY%,W%,H%,A%
  H%=KNJLIB_FONTH%
  W%=GKNJGET(C$,DOT%)

  VAR CL%,R%,G%,B%
  CL%=KNJLIB_COLOR%
  R%=(CL% AND &HFF0000)>>16
  G%=(CL% AND &HFF00)>>8
  B%=(CL% AND &HFF)

  FOR YY%=0 TO H%-1 STEP 2
    FOR XX%=0 TO W%-1 STEP 2
      A%=DOT%[XX%+YY%*W%]+DOT%[XX%+1+YY%*W%]+DOT%[XX%+(YY%+1)*W%]+DOT%[XX%+1+(YY%+1)*W%]
      A%=255*A% DIV 4

      IF A% THEN
        DRAW%[XX% DIV 2+(YY% DIV 2)*(W% DIV 2)]=RGB(A%,R%,G%,B%)
      ENDIF
    NEXT
  NEXT
  GLOAD X%,Y%,W% DIV 2,H% DIV 2,DRAW%,KNJLIB_DRAWMODE%
  RETURN W% DIV 2
END

'
' ●1文字分のデータの取得
' DIM DAT[GKNJW()*GKNJH()]:W=GKNJGET("あ",DAT)
' FOR I=1 TO GKNJH():FOR J=1 TO GKNJW()
' PRINT DAT[P];:INC P:NEXT:PRINT:NEXT
' 配列変数で1文字分のデータを受け取ります。
' 配列には、左上から、0か1でピクセルの内容が入ります。
' 戻り値として、文字の幅を返します。
'
COMMON DEF GKNJGET(C$,PX%[])
  VAR I%,J%,S$,HALF%,B$

  KNJDATAGET C$ OUT S$,HALF%
  VAR W%=KNJLIB_FONTW% DIV HALF%
  VAR H%=KNJLIB_FONTH%,B%=1<<(W%-1)
  IF S$=="" THEN RETURN KNJLIB_FONTW%

  DIM L%=LEN(S$)-1,DOTCNT%=16,DOTPOS%

  FOR I%=0 TO L%
    B$=HEX$(ASC(MID$(S$,I%,1)),4)
    FOR J%=0 TO 1
      COPY PX%,I%*16+J%*8,KNJLIB_BITTBL%,(VAL("&H"+MID$(B$,J%*2,2)))*8,8
     NEXT
  NEXT

  RETURN W%
END

'
' ●文字の幅取得
' W=GKNJW()
' 全角の文字幅をピクセル数で取得します。
'
COMMON DEF GKNJW()
  RETURN KNJLIB_FONTW%
END

'
' ●文字の高さ取得
' H=GKNJH()
' 全角の文字高さをピクセル数で取得します。
'
COMMON DEF GKNJH()
  RETURN KNJLIB_FONTH%
END

'
' ●文字列の全角変換
' RET$=AKCNV$("ABC")
' 文字列を全角に変換します。
'
COMMON DEF AKCNV$(S$)
  VAR I%,S%,L%=LEN(S$)-1
  FOR I%=0 TO L%
    S%=INSTR(KNJLIB_HANKAKUTBL$,MID$(S$,I%,1))
    IF S%>=0 THEN S$=SUBST$(S$,I%,1,MID$(KNJLIB_ZENKAKUTBL$,S%,1))
  NEXT
  RETURN S$
END

'
' ●文字列の半角変換
' RET$=KACNV$("アイウ")
' 文字列を半角に変換します。
'
COMMON DEF KACNV$(S$)
  VAR I%,S%,L%=LEN(S$)-1
  FOR I%=0 TO L%
    S%=INSTR(KNJLIB_ZENKAKUTBL$,MID$(S$,I%,1))
    IF S%>=0 THEN S$=SUBST$(S$,I%,1,MID$(KNJLIB_HANKAKUTBL$,S%,1))
  NEXT
  RETURN S$
END

'
' ●文字コード変換
' PRINT KNJCNV$("プチコン$6F22$5B57ライブラリ")
' 文字列中に「$文字コード16進数」が含まれている場合、
' 該当する文字に変換します。
'
COMMON DEF KNJCNV$(K$)
  VAR I%,POS%,RET$,A$,B$,L%=LEN(K$)-1
  FOR I%=0 TO L%
    A$=MID$(K$,I%,1)
    IF A$==KNJLIB_KNJCONVMARK$ THEN
      B$=MID$(K$,I%+1,4)
      RET$=RET$+CHR$(VAL("&H"+B$))
      INC I%,4
    ELSE
      RET$=RET$+A$
    ENDIF
  NEXT
  RETURN RET$
END

'
' ●文字コード変換の制御記号変更
' KNJCNVMARK "@"
' KNJCNV$ で文字コードを表すための記号を「$」から
' 任意の別の記号1文字に変更します。
'
COMMON DEF KNJCNVMARK M$
  KNJLIB_KNJCONVMARK$=M$
END

'
' ●フォントデータを展開前の文字列で取得
' KNJDATAGET "あ" OUT DAT$,HALF%
' 指定文字のフォントデータを展開前の状態の文字列で取得します。
' HALF% に 2 が入る場合は半角、1 は全角です。
'
COMMON DEF KNJDATAGET C$ OUT S$,HALF%
  VAR I%,M%
  VAR TBL%=-1,L%=LEN(KNJLIB_STRTBL$)-1
  HALF%=1:S$=""
  ' CHR$(FF5E) を CHR$(&H301C) に
  ' IF C$=="～" THEN C$="〜"

  FOR I%=0 TO L%
    IF KNJLIB_ZENKAKUCONV% && KNJLIB_HANKAKU%[I%] THEN CONTINUE
    IF KNJLIB_FONTDAT$[I%]!="" THEN 
      M%=INSTR(KNJLIB_STRTBL$[I%],C$)
      IF M%>=0 THEN TBL%=I%:BREAK
    ENDIF
  NEXT
  IF TBL%<0 THEN RETURN KNJLIB_FONTW%
  IF KNJLIB_HANKAKU%[TBL%] THEN HALF%=2

  VAR BIT%=((KNJLIB_FONTW% DIV HALF%)*KNJLIB_FONTH%-1) DIV 16+1
  S$=MID$(KNJLIB_FONTDAT$[TBL%],M%*(BIT%),BIT%)
END

'
' ●指定文字がフォントデータの対象か確認
' RET=KNJCHK("あ")
' 指定文字がフォントデータに含まれているかを取得します。
' 戻り値が 0 の場合は含まれていません。含まれる場合、半角は 1、全角は 2 です。
'
COMMON DEF KNJCHK(C$)
  VAR I%,M%,L%=LEN(KNJLIB_STRTBL$)-1
  C$=MID$(C$,0,1)
  IF C$=="" THEN RETURN 0
  FOR I%=0 TO L%
    IF KNJLIB_FONTDAT$[I%]!="" THEN 
      M%=INSTR(KNJLIB_STRTBL$[I%],C$)
      IF M%>=0 THEN
        IF KNJLIB_HANKAKU%[I%] THEN
          RETURN 1
        ELSE
          RETURN 2
        ENDIF
      ENDIF
    ENDIF
  NEXT
  RETURN 0
END

Iz>q9vbEQ