      I  $せんたろー                 せんたろー                                 '-------------------------------------------------'
' MAIN.PRG(ブロック くずし)                              '
'-------------------------------------------------'
' 2019.06.08 Sentaro Minami                       '
'-------------------------------------------------'
OPTION STRICT                   '変数宣言を必須にする

'-------------------------------------------------'
' ユーザー定義定数                                        '
'-------------------------------------------------'
'-スクリーン-----------------
CONST #SCREEN_W   =640          'スクリーン はば
CONST #SCREEN_H   =480          'スクリーン たかさ

'-にゅうりょく じょうほう----------
CONST #INPUT_MAX  =17           'しよう する ボタンの かず
CONST #BS_DOWN    =0            'キーのじょうたい おした しゅんかん
CONST #BS_PRESS   =1            'キーのじょうたい おし つづけ
CONST #BS_UP      =2            'キーのじょうたい はなした しゅんかん
CONST #BS_RELEASE =3            'キーのじょうたい はなして いる

'-BGM-------------------
CONST #MAIN_BGM   =7            'メイン の BGM ばんごう
CONST #PENE_BGM   =29           'ボール かんつう ちゅう の BGM ばんごう

'-BEEP------------------
CONST #BEEP_VOL   =127          'こうかおん ボリューム
CONST #BP_ENTER   =32           'タイトル A ボタン & ポーズ
CONST #BP_CLR     =71           'クリア:ヤッタネ!
CONST #BP_OVR     =76           'ゲームオーバー:ウワァーン!
CONST #BP_BOUND   =8            'ボール バウンド
CONST #BP_BREAK   =13           'ブロック はかい
CONST #BP_FALL    =6            'アイテム らっか
CONST #BP_ITEMGET =5            'アイテム しゅとく

'-シーンかんり----------------
CONST #SC_TITLE   =0            'シーン:タイトル
CONST #SC_PLAY    =1            'シーン:プレイ
CONST #SSTA_INI   =0            'シーン・ステータス しょきか
CONST #SSTA_RUN   =1            'シーン・ステータス じっこう
CONST #SSTA_REL   =2            'シーン・ステータス しゅうりょう

'-ポーズきのうーーー-------------
CONST #PAUSE_OFF  =1            'ポーズかいじょ
CONST #PAUSE_ON   =-1           'ポーズちゅう

'-フィールド-----------------
CONST #FIELD_W    =448          'フィールド はば
CONST #FIELD_H    =480          'フィールド たかさ

'-ボール-------------------
CONST #BALL_W     =8            'ボール の はば
CONST #BALL_H     =8            'ボール の たかさ
CONST #BALL_MAX   =10           'ボール の さいだい すう
CONST #BALL_STCMAX=3            'ボール たいき すう しょきち
CONST #BALL_STNON =0            'ボール ステータス なし
CONST #BALL_STSTB =1            'ボール ステータス たいき
CONST #BALL_STACT =2            'ボール ステータス アクティブ
CONST #BALL_MOVE  =2            'ボール いどう りょう
CONST #BALL_PTIME =1800         'ボール かんつう じかん(フレーム)

'-バー--------------------
CONST #BAR_WMAX   =3            'バー の はば だんかい さいだすう
CONST #BAR_W0     =48           'バー の はば0
CONST #BAR_W1     =64           'バー の はば1
CONST #BAR_W2     =80           'バー の はば2
CONST #BAR_H      =8            'バー の たかさ
CONST #BAR_DPX    =#FIELD_W/2-#BAR_W1/2
CONST #BAR_DPY    =#FIELD_H-16
                                'バー の しょき ざひょうXY
'-ブロック------------------
CONST #BLOCK_W    =32           'ブロック 1つの はば
CONST #BLOCK_H    =16           'ブロック 1つの たかさ

'-アイテム------------------
CONST #ITEM_W     =32           'アイテム の はば
CONST #ITEM_H     =16           'アイテム の たかさ

'-マップ-------------------
CONST #MAP_CW     =14           'ブロック よこ に ならべる かず
CONST #MAP_CH     =20           'ブロック たて に ならべる かず

'-スコア-------------------
CONST #SCORE_MAX  =999999       'スコア さいだい ち
CONST #SCORE_ADDBL=100          'スコア かさん:ブロック せっしょく
CONST #SCORE_ADDIT=250          'スコア かさん:アイテム せっしょく
CONST #SCORE_ADDBA=1            'スコア かさん:ボール かべ バー はんしゃ

'-------------------------------------------------'
' グローバル変数宣言                                       '
'-------------------------------------------------'
DIM gGLOBALCNT    =0            'じかん けいそく カウント

'-にゅうりょく じょうほう----------
DIM gINPUT_DATA[#INPUT_MAX]     'いまの フレームの にゅうりょく じょうほう
DIM gINPUT_PREV[#INPUT_MAX]     'まえの フレームの にゅうりょく じょうほう

'-シーンかんり----------------
DIM gSCENE    =#SC_TITLE        'げんざいの シーン=きどうじ しょきシーン
DIM gNEXTSCENE=0                'つぎの シーン
DIM gSSTATE   =#SSTA_INI        'げんざいの シーン・ステータス

'-ポーズきのうーーー-------------
DIM gPAUSE    =#PAUSE_OFF       '1:ポーズ かいじょ ー1:ポーズ ちゅう 

'-ボール-------------------
DIM gBALL_ST[#BALL_MAX]
DIM gBALL_PX[#BALL_MAX]         'ボール ざひょう X
DIM gBALL_PY[#BALL_MAX]         'ボール ざひょう Y
DIM gBALL_MX[#BALL_MAX]         'ボール いどうりょう X
DIM gBALL_MY[#BALL_MAX]         'ボール いどうりょう Y
DIM gBALL_PCNT=0                'ボール かんつう じかん カウント 

'-バー--------------------
DIM gBAR_PX   =#BAR_DPX         'バー ざひょう X
DIM gBAR_PY   =#BAR_DPY         'バー ざひょう Y
DIM gBAR_MX   =4                'バー いどうりょう
DIM gBAR_MY   =4                'バー いどうりょう Y
DIM gBAR_NW   =0                'バー げんざいの はば だんかい
DIM gBAR_W[#BAR_WMAX]           'バー の はば
gBAR_W[0]=#BAR_W0
gBAR_W[1]=#BAR_W1
gBAR_W[2]=#BAR_W2

'-アイテム------------------
DIM gITEM_LIFE[#MAP_CW*#MAP_CH] 'アイテム せいぞん フラグ
DIM gITEM_PX[#MAP_CW*#MAP_CH]   'アイテム ざひょう X
DIM gITEM_PY[#MAP_CW*#MAP_CH]   'アイテム ざひょう Y
DIM gITEM_MX  =1                'アイテム いどう りょう X
DIM gITEM_MY  =1                'アイテム いどう りょう Y

'-マップデータ----------------
DIM gMAP_FILEN$="DAT:BLOCK.DAT" 'マップ・データ ファイル めい
DIM gMAP_DATA[#MAP_CW*#MAP_CH]  'マップ・データ かくのう よう

'-スコア-------------------
DIM gSCORE=0                    'げんざい の スコア

fMain                           'メイン しょり かいし
'-------------------------------------------------'
' メイン しょり                                         '
'-------------------------------------------------'
DEF fMain

 'ぜんたい の しょきか しょり
 gGLOBALCNT=0                   'じかん けいそく カウント しょきか
 fInput_Init                    'にゅうりょく じょうほう の しょきか

 'メインループ
 LOOP
  gGLOBALCNT=gGLOBALCNT+1       'じかん けいそく カウント かさん
  fInput_Update                 'にゅうりょく じょうほう の こうしん

  CASE gSCENE                   'げんざい の シーン を じっこう
   WHEN #SC_TITLE:fScTitle_Main
   WHEN #SC_PLAY :fScPlay_Main
  ENDCASE

  VSYNC
 ENDLOOP

 'ぜんたい の しゅうりょう しょり(NOP)

 RETURN
END

'*************************************************************************'
' シーン:タイトル                                                                '
'*************************************************************************'
'-------------------------------------------------'
' シーン:タイトル メイン                                    '
'-------------------------------------------------'
DEF fScTitle_Main

 CASE gSSTATE
  WHEN #SSTA_INI:
   fScTitle_Ini                 'しょきか
  WHEN #SSTA_RUN:
   fScTitle_Run                 'じっこう
   fScTitle_Draw                'びょうが

  WHEN #SSTA_REL:
   fScTitle_Rel                 'しゅうりょう
 ENDCASE

 RETURN
END

'-------------------------------------------------'
' シーン:タイトル しょきか                                   '
'-------------------------------------------------'
DEF fScTitle_Ini

 fScreen_Init                   'スクリーン しょきか
 BGMSTOP
 BGMPLAY 0,#MAIN_BGM

 gSSTATE=#SSTA_RUN              'じっこう に せんい

 RETURN
END

'-------------------------------------------------'
' シーン:タイトル じっこう                                   '
'-------------------------------------------------'
DEF fScTitle_Run

 'Aボタン を おすと シーン:PLAY に せんい じゅんび
 IF fInput_GetState(1,#B_RRIGHT,#BS_DOWN)THEN
  BEEP #BP_ENTER,0,#BEEP_VOL
  gNEXTSCENE=#SC_PLAY           'つぎの シーン を せってい
  gSSTATE   =#SSTA_REL          'しゅうりょう に せんい
  gGLOBALCNT=0                  'じかん けいそく かいし(0セット)
 ENDIF

 RETURN
END

'-------------------------------------------------'
' シーン:タイトル びょうが                                   '
'-------------------------------------------------'
DEF fScTitle_Draw

 'はいけい
 GFILL 0,0,#SCREEN_W,#SCREEN_H,RGB(0,128,0)

 'タイトル
 COLOR   0,RGB(255,255,255)
 TSCREEN 0,16,48
 LOCATE  0,3,3
 TPRINT  0,"ブロックくずし"

 'Aボタン を おして ください
 COLOR   1,RGB(255,255,255)
 TSCREEN 1,16,16
 LOCATE  1,8,18
 TPRINT  1,"-Please press A button-"

 'ぼく の なまえ
 COLOR   2,RGB(255,255,255)
 TSCREEN 2,16,8
 LOCATE  2,29,50
 TPRINT  2,"2019 SENTARO MINAMI"

 RETURN
END

'-------------------------------------------------'
' シーン:タイトル しゅうりょう                                 '
'-------------------------------------------------'
DEF fScTitle_Rel

 'Aボタン を おして ください(てんめつ)
 IF gGLOBALCNT MOD 2==0 THEN
  COLOR 1,RGB(255,255,255)
 ELSE
  COLOR 1,RGB(0,0,0)
 ENDIF

 TSCREEN 1,16,16
 LOCATE  1,8,18
 TPRINT  1,"-Please press A button-"

 IF gGLOBALCNT>=30 THEN
  gSSTATE=#SSTA_INI             'しょきか に せんい
  gSCENE=gNEXTSCENE
 ENDIF

 RETURN
END

'*************************************************************************'
' シーン:プレイ                                                                 '
'*************************************************************************'
'-------------------------------------------------'
' シーン:プレイ メイン                                     '
'-------------------------------------------------'
DEF fScPlay_Main

 CASE gSSTATE
  WHEN #SSTA_INI:
   fScPlay_Ini                  'しょきか

  WHEN #SSTA_RUN:
   'ポーズ ON/OFF の ボタン にゅうりょく
   IF fInput_GetState(1,#B_R2,#BS_DOWN)THEN
    gPAUSE=-gPAUSE
    BEEP #BP_ENTER,0,#BEEP_VOL
   ENDIF

   'ポーズOFF の ばあい じっこう
   IF gPAUSE==#PAUSE_OFF THEN
    fScPlay_Run                 'じっこう
   ENDIF
   fScPlay_Draw                 'びょうが

  WHEN #SSTA_REL:
   IF gGLOBALCNT>=180 THEN
    fScPlay_Rel                 'しゅうりょう
   ENDIF
 ENDCASE

 RETURN
END

'-------------------------------------------------'
' シーン:プレイ しょきか                                    '
'-------------------------------------------------'
DEF fScPlay_Ini
 fScreen_Init                   'スクリーン しょきか
 fItem_Init                     'アイテム  しょきか
 fBall_Init                     'ボール   しょきか
 fBar_Init                      'バー    しょきか
 fMap_Init                      'マップ   しょきか

 gPAUSE=#PAUSE_OFF              'ポーズ   しょきか
 gSCORE=0                       'スコア   しょきか

 gSSTATE=#SSTA_RUN              'じっこう に せんい

 RETURN
END

'-------------------------------------------------'
' シーン:プレイ じっこう                                    '
'-------------------------------------------------'
DEF fScPlay_Run
 DIM I
 DIM C_FLG=0                    'クリア フラグ
 DIM B_FLG=0                    'ゲームオーバー はんてい よう フラグ

 fBar_Run                       'バー   じっこう
 fBall_Run                      'ボール  じっこう
 fItem_Run                      'アイテム じっこう

 'クリア はんてい
 FOR I=0 TO #MAP_CW*#MAP_CH-1 STEP 1
  IF gMAP_DATA[I]>0 THEN C_FLG=1
 NEXT

 'ゲームオーバー はんてい
 FOR I=0 TO #BALL_MAX-1 STEP 1
  IF gBALL_ST[I]==#BALL_STSTB OR gBALL_ST[I]==#BALL_STACT THEN
   B_FLG=1
  ENDIF
 NEXT

 'クリア こうかおん
 IF C_FLG==0 THEN BEEP #BP_CLR,0,#BEEP_VOL
 'ゲームオーバー こうかおん
 IF B_FLG==0 THEN BEEP #BP_OVR,0,#BEEP_VOL

 IF C_FLG==0 OR B_FLG==0 THEN
  gNEXTSCENE=#SC_TITLE          'つぎの シーン を せってい
  gSSTATE   =#SSTA_REL          'しゅうりょう に せんい
  gGLOBALCNT=0                  'じかん けいそく かいし(0セット)
 ENDIF

 'スコア さいだいち に ほせい
 IF gSCORE>#SCORE_MAX THEN gSCORE=#SCORE_MAX

 RETURN
END

'-------------------------------------------------'
' シーン:プレイ びょうが                                    '
'-------------------------------------------------'
DEF fScPlay_Draw

 fField_Draw                    'フィールド   びょうが
 fBall_StbDraw                  'ボール たいき びょうが
 fBlock_Draw                    'ブロック    びょうが
 fBar_Draw                      'バー      びょうが
 fItem_Draw                     'アイテム    びょうが
 fBall_Draw                     'ボール     びょうが

 'スコア びょうが
 CLS 0
 LOCATE  0,28,10
 TPRINT  0,"SCORE:"
 LOCATE  0,34,10
 TPRINT  0,gSCORE

 'ポーズON の ばあい "-PAUSE-" を びょうが
 IF gPAUSE==#PAUSE_ON THEN
  LOCATE  0,10,10
  TPRINT  0,"-PAUSE-"
 ENDIF

 RETURN
END

'-------------------------------------------------'
' シーン:プレイ しゅうりょう                                  '
'-------------------------------------------------'
DEF fScPlay_Rel

 gSSTATE=#SSTA_INI              'しょきか に せんい
 gSCENE=gNEXTSCENE

 RETURN
END

'*************************************************************************'
' バー                                                                      '
'*************************************************************************'
'-------------------------------------------------'
' バー しょきか                                         '
'-------------------------------------------------'
DEF fBar_Init
 gBAR_PX=#BAR_DPX               'バー ざひょう X
 gBAR_PY=#FIELD_H-16            'バー ざひょう Y
 gBAR_NW=0                      'バー げんざいの はば だんかい

 RETURN
END

'-------------------------------------------------'
' バー じっこう                                         '
'-------------------------------------------------'
DEF fBar_Run

 'いどう
' IF fInput_GetState(1,#B_LUP,   #BS_PRESS)THEN BAR_PY=BAR_PY-BAR_MY 'デバッグ よう
' IF fInput_GetState(1,#B_LDOWN, #BS_PRESS)THEN BAR_PY=BAR_PY+BAR_MY 'デバッグ よう
 IF fInput_GetState(1,#B_LLEFT, #BS_PRESS)THEN gBAR_PX=gBAR_PX-gBAR_MX
 IF fInput_GetState(1,#B_LRIGHT,#BS_PRESS)THEN gBAR_PX=gBAR_PX+gBAR_MX

 'フィールド との あたり はんてい
 IF gBAR_PX<0 THEN                        'ひだり の かべ
  gBAR_PX=0                               'ざひょう の しゅうせい
 ENDIF
 IF gBAR_PX+gBAR_W[gBAR_NW]>#FIELD_W THEN 'みぎ の かべ
  gBAR_PX=#FIELD_W-gBAR_W[gBAR_NW]        'ざひょう の しゅうせい
 ENDIF
 IF gBAR_PY<0 THEN                        'うえ の かべ
  gBAR_PY=0                               'ざひょう の しゅうせい
 ENDIF
 IF gBAR_PY+#BAR_H>#FIELD_H THEN          'した の かべ
  gBAR_PY=#FIELD_H-#BAR_H                 'ざひょう の しゅうせい
 ENDIF
 
 RETURN
END

'-------------------------------------------------'
' バー びょうが                                         '
'-------------------------------------------------'
DEF fBar_Draw

 GBOX   gBAR_PX,gBAR_PY,gBAR_PX+gBAR_W[gBAR_NW]-1,gBAR_PY+#BAR_H-1,RGB(255,0,0)
 GPAINT gBAR_PX+1,gBAR_PY+1,RGB(255,126,126)

 RETURN
END

'*************************************************************************'
' マップ                                                                     '
'*************************************************************************'
'-------------------------------------------------'
' マップ しょきか                                        '
'-------------------------------------------------'
DEF fMap_Init

 LOADV gMAP_FILEN$,gMAP_DATA

 RETURN
END

'*************************************************************************'
' ボール                                                                     '
'*************************************************************************'
'-------------------------------------------------'
' ボール しょきか                                        '
'-------------------------------------------------'
DEF fBall_Init
 DIM I
 FOR I=0 TO #BALL_MAX-1 STEP 1
  gBALL_PX[I]=0
  gBALL_PY[I]=0
  gBALL_ST[I]=#BALL_STNON
  gBALL_MX[I]=#BALL_MOVE
  gBALL_MY[I]=#BALL_MOVE
 NEXT
 FOR I=0 TO #BALL_STCMAX-1 STEP 1 'ボール たいき すう しょきち
  gBALL_ST[I]=#BALL_STSTB
 NEXT
 gBALL_PCNT=0

 RETURN
END

'-------------------------------------------------'
' ボール じっこう                                        '
'-------------------------------------------------'
DEF fBall_Run
 DIM I,X,Y
 DIM W=#BLOCK_W,H=#BLOCK_H

 'せいせい
 IF fInput_GetState(1,#B_RRIGHT,#BS_DOWN)THEN
  FOR I=0 TO #BALL_MAX-1 STEP 1
   IF gBALL_ST[I]==#BALL_STSTB THEN
    gBALL_PX[I]=gBAR_PX+gBAR_W[gBAR_NW]/2-#BALL_W/2
    gBALL_PY[I]=gBAR_PY-#BALL_H
    gBALL_ST[I]=#BALL_STACT
    BREAK
   ENDIF
  NEXT
 ENDIF

 FOR I=0 TO #BALL_MAX-1 STEP 1
  IF gBALL_ST[I]==#BALL_STACT THEN
   'いどう
   gBALL_PX[I]=gBALL_PX[I]+gBALL_MX[I]
   gBALL_PY[I]=gBALL_PY[I]+gBALL_MY[I]
   'したに おちた ばあい しょうめつ
   IF gBALL_PY[I]>#FIELD_H+#BALL_H THEN
    gBALL_ST[I]=#BALL_STNON
   ENDIF

   'フィールド との あたり はんてい
   IF gBALL_PX[I]<0 THEN                'ひだり の かべ
    gBALL_PX[I]=0                       'ざひょう の しゅうせい
    gBALL_MX[I]=-gBALL_MX[I]            'はねかえり
    gSCORE=gSCORE+#SCORE_ADDBA          'スコア かさん
    BEEP #BP_BOUND,0,#BEEP_VOL
   ENDIF
   IF gBALL_PX[I]+#BALL_W>#FIELD_W THEN 'みぎ の かべ
    gBALL_PX[I]=#FIELD_W-#BALL_W        'ざひょう の しゅうせい
    gBALL_MX[I]=-gBALL_MX[I]            'はねかえり
    gSCORE=gSCORE+#SCORE_ADDBA          'スコア かさん
    BEEP #BP_BOUND,0,#BEEP_VOL
   ENDIF
   IF gBALL_PY[I]<0 THEN                'うえ の かべ
    gBALL_PY[I]=0                       'ざひょう の しゅうせい
    gBALL_MY[I]=-gBALL_MY[I]            'はねかえり
    gSCORE=gSCORE+#SCORE_ADDBA          'スコア かさん
    BEEP #BP_BOUND,0,#BEEP_VOL
   ENDIF
   IF gBALL_PY[I]+#BALL_H>#FIELD_H THEN 'した の かべ
'    gBALL_PY[I]=#FIELD_H-#BALL_H        'ざひょう の しゅうせい
'    gBALL_MY[I]=-gBALL_MY[I]            'はねかえり
'    gSCORE=gSCORE+#SCORE_ADDBA          'スコア かさん
'    BEEP #BP_BOUND,0,#BEEP_VOL
   ENDIF

   'バー との あたり はんてい
   IF fBall_HitObj(I,gBAR_PX,gBAR_PY,gBAR_W[gBAR_NW],#BAR_H,0)>0 THEN
    gSCORE=gSCORE+#SCORE_ADDBA          'スコア かさん
    BEEP #BP_BOUND,0,#BEEP_VOL
   ENDIF

   'かんつう カウント
   IF gBALL_PCNT==1 THEN BGMPLAY 0,#MAIN_BGM
   gBALL_PCNT=gBALL_PCNT-1
   IF gBALL_PCNT<0 THEN gBALL_PCNT=0

   'ブロック との あたり はんてい
   FOR Y=0 TO #MAP_CH-1 STEP 1
    FOR X=0 TO #MAP_CW-1 STEP 1
     IF gMAP_DATA[Y*#MAP_CW+X]>=1 THEN
      IF fBall_HitObj(I,X*W,Y*H,W,H,gBALL_PCNT)>0 THEN
       BEEP #BP_BREAK,0,#BEEP_VOL
       'スコア かさん
       gSCORE=gSCORE+#SCORE_ADDBL
       'コントローラ しんどう
       VIBRATE 1,3

       IF gMAP_DATA[Y*#MAP_CW+X]<=3 THEN
        'つうじょうブロック は かたさ-1
        gMAP_DATA[Y*#MAP_CW+X]=gMAP_DATA[Y*#MAP_CW+X]-1
       ELSE IF gMAP_DATA[Y*#MAP_CW+X]<=6 THEN
        'アイテム せいせい
        gITEM_PX[Y*#MAP_CW+X]=X*W
        gITEM_PY[Y*#MAP_CW+X]=Y*H
        gITEM_LIFE[Y*#MAP_CW+X]=gMAP_DATA[Y*#MAP_CW+X]
        'アイテム ブロック は いっぱつ しょうめつ(0)
        gMAP_DATA[Y*#MAP_CW+X]=0
        BEEP #BP_FALL,0,#BEEP_VOL
       ENDIF
       ENDIF
      ENDIF
     ENDIF
    NEXT
   NEXT
  ENDIF
 NEXT

 RETURN
END

'-------------------------------------------------'
' ボール びょうが                                        '
'-------------------------------------------------'
DEF fBall_Draw
 DIM I
 DIM CX,CY                      'ボール ちゅうしん てん
 DIM R=#BALL_W/2

 FOR I=0 TO #BALL_MAX-1 STEP 1
  IF gBALL_ST[I]==#BALL_STACT THEN
   CX=gBALL_PX[I]+#BALL_W/2
   CY=gBALL_PY[I]+#BALL_H/2
   GCIRCLE CX,CY,R,RGB(200,0,200)
   IF gGLOBALCNT MOD 4==0 AND gBALL_PCNT!=0 THEN
    GPAINT  CX,  CY,      RGB(255,255,255)
    GCIRCLE CX-1,CY-1,R/4,RGB(255,150,150)
    GPAINT  CX-1,CY-1,    RGB(150,150,255)
   ELSE
    GPAINT  CX,  CY,      RGB(255,0,0)
    GCIRCLE CX-1,CY-1,R/4,RGB(255,150,150)
    GPAINT  CX-1,CY-1,    RGB(255,150,150)
   ENDIF
  ENDIF
 NEXT

 RETURN
END

'-------------------------------------------------'
' ボール たいき びょうが                                    '
'-------------------------------------------------'
DEF fBall_StbDraw
 DIM I,X,Y
 DIM CX,CY                      'ボール ちゅうしん てん
 DIM R=#BALL_W/2

 X=#FIELD_W+8
 Y=#FIELD_H-16
 FOR I=0 TO #BALL_MAX-1 STEP 1
  IF gBALL_ST[I]==#BALL_STSTB THEN
   CX=X+#BALL_W/2
   CY=Y+#BALL_H/2
   GCIRCLE CX,  CY,  R,  RGB(128,128,0)
   GPAINT  CX,  CY,      RGB(255,0,0)
   GCIRCLE CX-1,CY-1,R/4,RGB(255,150,150)
   GPAINT  CX-1,CY-1,    RGB(255,150,150)
   Y=Y-#BALL_H-4
  ENDIF
 NEXT

 RETURN
END

'-------------------------------------------------'
' ボールとオブジェクトの あたり はんてい                            '
' ox  :オブジェクトX                                    '
' oy  :オブジェクトY                                    '
' ow  :オブジェクトはば                                   '
' oh  :オブジェクトたかさ                                  '
' flag:かんつうフラグ(0=OFF/other=かんつう)                  '
'-------------------------------------------------'
DEF fBall_HitObj(id,ox,oy,ow,oh,flag)
 DIM RET=0
 'ボール
 DIM B_CX    =gBALL_PX[id]+#BALL_W/2'ボール Xちゅうしん てん
 DIM B_CY    =gBALL_PY[id]+#BALL_H/2'ボール Xちゅうしん てん
 DIM B_LEFT  =gBALL_PX[id]          'ボール ひだりはし
 DIM B_TOP   =gBALL_PY[id]          'ボール じょうたん
 DIM B_RIGHT =gBALL_PX[id]+#BALL_W  'ボール みぎはし
 DIM B_BOTTOM=gBALL_PY[id]+#BALL_H  'ボール かたん
 'オブジェクト
 DIM O_LEFT  =ox                    'オブジェクト ひだりはし
 DIM O_TOP   =oy                    'オブジェクト じょうたん
 DIM O_RIGHT =ox+ow                 'オブジェクト みぎはし
 DIM O_BOTTOM=oy+oh                 'オブジェクト かたん

 'さゆう の はんてい
 'まず、オブジェクトの たかさ ない に ボール の Yちゅうしん が はいっているか
 IF O_TOP<B_CY AND B_CY<O_BOTTOM THEN
  'ボール の ひだり が あたった
  IF B_LEFT<O_RIGHT AND O_RIGHT<B_RIGHT THEN
   IF flag<=0 THEN
    gBALL_PX[id]=O_RIGHT            'ざひょう の しゅうせい
    gBALL_MX[id]=-gBALL_MX[id]      'はねかえり
   ENDIF
   RET=1
  ENDIF
  'ボール の みぎ が あたった
  IF B_RIGHT>O_LEFT AND O_LEFT >B_LEFT THEN
   IF flag<=0 THEN
    gBALL_PX[id]=O_LEFT-#BALL_W     'ざひょう の しゅうせい
    gBALL_MX[id]=-gBALL_MX[id]      'はねかえり
   ENDIF
   RET=2
  ENDIF
 ENDIF

 'じょうげ の はんてい
 'まず、オブジェクトの はば ない に ボール の Xちゅうしん が はいっているか
 IF O_LEFT<B_CX AND B_CX<O_RIGHT THEN
  'ボール の じょうたん が あたった
  IF B_TOP<O_BOTTOM AND O_BOTTOM <B_BOTTOM THEN
   IF flag<=0 THEN
    gBALL_PY[id]=O_BOTTOM           'ざひょう の しゅうせい
    gBALL_MY[id]=-gBALL_MY[id]      'はねかえり
   ENDIF
   RET=3
  ENDIF
  'ボール の かたん が あたった
  IF B_BOTTOM>O_TOP AND O_TOP>B_TOP THEN
   IF flag<=0 THEN
    gBALL_PY[id]=O_TOP-#BALL_H      'ざひょう の しゅうせい
    gBALL_MY[id]=-gBALL_MY[id]      'はねかえり
   ENDIF
   RET=4
  ENDIF
 ENDIF

 RETURN RET
END

'*************************************************************************'
' アイテム                                                                    '
'*************************************************************************'
'-------------------------------------------------'
' アイテム しょきか                                       '
'-------------------------------------------------'
DEF fItem_Init
 DIM I
 
 FOR I=0 TO #MAP_CW*#MAP_CH-1 STEP 1
  gITEM_LIFE[I]=0               'アイテム せいぞん フラグ
  gITEM_PX[I]  =0               'アイテム ざひょう X
  gITEM_PY[I]  =0               'アイテム ざひょう Y
 NEXT
 RETURN
END

'-------------------------------------------------'
' アイテム じっこう                                       '
'-------------------------------------------------'
DEF fItem_Run
 DIM I,J

 'いどう
 FOR I=0 TO #MAP_CW*#MAP_CH-1 STEP 1
  IF gITEM_LIFE[I]>=4 AND gITEM_LIFE[I]<=6 THEN
   gITEM_PY[I]=gITEM_PY[I]+gITEM_MY
   IF gITEM_PY[I]>#SCREEN_H THEN
    gITEM_LIFE[I]=0
   ENDIF
  ENDIF
 NEXT

 'バー との あたり はんてい
 FOR I=0 TO #MAP_CW*#MAP_CH-1 STEP 1
  IF gITEM_LIFE[I]>=4 AND gITEM_LIFE[I]<=6 THEN
   IF fFunc_HitRR(gITEM_PX[I],gITEM_PY[I],#ITEM_W,#ITEM_H,gBAR_PX,gBAR_PY,gBAR_W[gBAR_NW],#BAR_H) THEN
    'スコア かさん
    gSCORE=gSCORE+#SCORE_ADDIT

    'アイテム ごと の こうか はつどう
    CASE gITEM_LIFE[I]
     WHEN 4:'アイテム・ブロック[あか] ボール たいき が ふえる
      FOR J=0 TO #BALL_MAX-1 STEP 1
       IF gBALL_ST[J]==#BALL_STNON THEN
        gBALL_ST[J]=#BALL_STSTB
        BREAK
       ENDIF
      NEXT
     WHEN 5:'アイテム・ブロック[みどり] バー の はば が ひろくなる
      gBAR_PX=gBAR_PX+gBAR_W[gBAR_NW]/2
      gBAR_NW=gBAR_NW+1
      IF gBAR_NW>=#BAR_WMAX THEN gBAR_NW=#BAR_WMAX-1
      gBAR_PX=gBAR_PX-gBAR_W[gBAR_NW]/2
     WHEN 6:'アイテム・ブロック[きいろ] ボール が かんつう する
      IF gBALL_PCNT<=0 THEN BGMPLAY 0,#PENE_BGM
      gBALL_PCNT=#BALL_PTIME
    ENDCASE
    gITEM_LIFE[I]=0
    BEEP #BP_ITEMGET,0,#BEEP_VOL
   ENDIF
  ENDIF
 NEXT

 RETURN
END

'-------------------------------------------------'
' アイテム びょうが                                       '
'-------------------------------------------------'
DEF fItem_Draw
 DIM I
 DIM IPX,IPY
 DIM W=#ITEM_W,H=#ITEM_H        'アイテム の はば たかさ
 DIM I_COLOR[7]                 'アイテム の いろ

 I_COLOR[0]=0
 I_COLOR[1]=0
 I_COLOR[2]=0
 I_COLOR[3]=0
 I_COLOR[4]=RGB(255,  0,  0)    'アイテム・ブロック あか
 I_COLOR[5]=RGB(  0,255,  0)    'アイテム・ブロック みどり
 I_COLOR[6]=RGB(255,255, 40)    'アイテム・ブロック きいろ

 FOR I=0 TO #MAP_CW*#MAP_CH-1 STEP 1
  IF gITEM_LIFE[I]>=4 AND gITEM_LIFE[I]<=6 THEN
   IPX=gITEM_PX[I]              'アイテム ざひょう X
   IPY=gITEM_PY[I]              'アイテム ざひょう Y
   GFILL IPX,IPY,IPX+W-1,IPY+H-1,I_COLOR[gITEM_LIFE[I]]
   GLINE IPX,IPY,IPX+W-1,IPY,RGB(255,255,255)
   GLINE IPX,IPY,IPX,IPY+H-1,RGB(255,255,255)
   GLINE IPX+W-1,IPY,IPX+W-1,IPY+H-1,RGB(0,0,0)
   GLINE IPX,IPY+H-1,IPX+W-1,IPY+H-1,RGB(0,0,0)
  ENDIF
 NEXT

 RETURN
END

'*************************************************************************'
' ブロック                                                                    '
'*************************************************************************'
'-------------------------------------------------'
' ブロック びょうが                                       '
'-------------------------------------------------'
DEF fBlock_Draw
 DIM X,Y
 DIM W,H                        'たいしょう の はば たかさ
 DIM B_COLOR[7]                 'ブロックの いろ

 B_COLOR[0]=0                   'ブロック なし
 B_COLOR[1]=RGB(120,120,120)    'たいきゅうど 1
 B_COLOR[2]=RGB(100,100,100)    'たいきゅうど 2
 B_COLOR[3]=RGB( 80, 80, 80)    'たいきゅうど 3
 B_COLOR[4]=RGB(255,  0,  0)    'アイテム・ブロック あか
 B_COLOR[5]=RGB(  0,255,  0)    'アイテム・ブロック みどり
 B_COLOR[6]=RGB(255,255, 40)    'アイテム・ブロック きいろ

 W=#BLOCK_W
 H=#BLOCK_H
 FOR Y=0 TO #MAP_CH-1 STEP 1
  FOR X=0 TO #MAP_CW-1 STEP 1
   IF gMAP_DATA[Y*#MAP_CW+X]>=1 THEN
    GFILL X*W,Y*H,X*W+W-1,Y*H+H-1,B_COLOR[gMAP_DATA[Y*#MAP_CW+X]]
    GLINE X*W,Y*H,X*W+W-1,Y*H,RGB(255,255,255)
    GLINE X*W,Y*H,X*W,Y*H+H-1,RGB(255,255,255)
    GLINE X*W+W-1,Y*H,X*W+W-1,Y*H+H-1,RGB(0,0,0)
    GLINE X*W,Y*H+H-1,X*W+W-1,Y*H+H-1,RGB(0,0,0)
   ENDIF
  NEXT
 NEXT

 RETURN
END

'*************************************************************************'
' フィールド                                                                   '
'*************************************************************************'
'-------------------------------------------------'
' フィールド びょうが                                      '
'-------------------------------------------------'
DEF fField_Draw

 GFILL 0,0,#FIELD_W,#FIELD_H,RGB(0,0,255)
 GFILL #FIELD_W,0,#SCREEN_W,#SCREEN_H,RGB(0,128,0)
 RETURN
END

'*************************************************************************'
' Func Module                                                             '
'*************************************************************************'
'-------------------------------------------------'
' スクリーン しょきか                                      '
'-------------------------------------------------'
DEF fScreen_Init

 ACLS
 XSCREEN #SCREEN_W,#SCREEN_H,1,0
 TSCREEN 0,16,16,#SCREEN_W/16,#SCREEN_H/16

 RETURN
END

'-------------------------------------------------'
' くけい と くけい の あたりはんてい                             '
'-------------------------------------------------'
DEF fFunc_HitRR(R1X,R1Y,R1W,R1H,R2X,R2Y,R2W,R2H)
 DIM RET=0
 DIM DISX=ABS((R1X+R1W/2)-(R2X+R2W/2))
 DIM DISY=ABS((R1Y+R1H/2)-(R2Y+R2H/2))

 IF DISX<(R1W+R2W)/2 AND DISY<(R1H+R2H)/2 THEN RET=1

 RETURN RET
END


'*************************************************************************'
' Input Module                                                            '
'*************************************************************************'
'-------------------------------------------------'
' にゅうりょく じょうほう の しょきか                             '
'-------------------------------------------------'
DEF fInput_Init
 DIM I

 FOR I=0 TO #INPUT_MAX-1 STEP 1
  gINPUT_DATA[I]=#BS_RELEASE    'はなして いる
  gINPUT_PREV[I]=#BS_RELEASE    'はなして いる
 NEXT
 RETURN
END

'-------------------------------------------------'
' にゅうりょく じょうほう の こうしん                             '
'-------------------------------------------------'
DEF fInput_Update
 DIM I

 FOR I=0 TO #INPUT_MAX-1 STEP 1
  IF BUTTON(1,I)==1 THEN        'たいしょう ボタン が おされている
   CASE gINPUT_PREV[I]
    WHEN #BS_DOWN:   gINPUT_DATA[I]=#BS_PRESS  'おした しゅんかん  -> おし つづけ
    WHEN #BS_PRESS:  gINPUT_DATA[I]=#BS_PRESS  'おし つづけ     -> おし つづけ
    WHEN #BS_UP:     gINPUT_DATA[I]=#BS_DOWN   'はなした しゅんかん -> おした しゅんかん 
    WHEN #BS_RELEASE:gINPUT_DATA[I]=#BS_DOWN   'はなして いる    -> おした しゅんかん
   ENDCASE
  ELSE                          'たいしょう ボタン が おされていない
   CASE gINPUT_PREV[I]
    WHEN #BS_DOWN:   gINPUT_DATA[I]=#BS_UP     'おした しゅんかん  -> はなした しゅんかん
    WHEN #BS_PRESS:  gINPUT_DATA[I]=#BS_UP     'おし つづけ     -> はなした しゅんかん
    WHEN #BS_UP:     gINPUT_DATA[I]=#BS_RELEASE'はなした しゅんかん -> はなして いる
    WHEN #BS_RELEASE:gINPUT_DATA[I]=#BS_RELEASE'はなして いる    -> はなして いる
   ENDCASE
  ENDIF
 NEXT

 '1フレームまえ の じょうたい を きろく
 FOR I=0 TO #INPUT_MAX-1 STEP 1
  gINPUT_PREV[I]=gINPUT_DATA[I]
 NEXT

 RETURN
END

'-------------------------------------------------'
' にゅうりょく じょうほう の しゅとく                             '
'-------------------------------------------------'
DEF fInput_GetState(id,btn,state)
 DIM RET=0

 IF gINPUT_DATA[btn]==state THEN RET=1

 RETURN RET
END

~笀N'ިNl!