      # "3 tanuki_aogon                n{tanuki_aogon                   L  L  U               OPTION DEFINT

ACLS
VAR APPVER#=1.14,SAVE_FILE$="DAT:UNYO4.SAV"
'
'                                            
'               でびる うにょ〜 ・ ねお                
'             - 2018  SPECIAL -              
'                                            
'             2015-2019 ©AOGONDO             
'                                            
' USING: < PALETTED IMAGE - FORMAT 1.1 >     
'                  IMAGE CONVERTER by AOGONDO
'
DIM KEY_N[6],KEY_H[6],UID[4],MYSET[],PLSET[]
DIM PLTURN[4],PLCARD[8],PLSTOP[4]
DIM ATK_CRASH[4,4],ATK_SOLID[4,4],ATK_MAGIC[4,4]
DIM NGATK_SOLID[4],NGATK_MAGIC[4]
VAR BTN_NEW,BTN_HLD,BTN_DEV,SKIP,CPULV,CLVSEL=0,LOOPS,TURN
VAR SELECT,MODE=0,RSEED,FIELD,BR,BGMNUM,MPNUM,MYID,ONSWAP
INIT:SELECT_CONTROLLER:VSYNC 1

@MAIN_LOOP
LOOP:GET_INPUT:GOSUB "@F"+HEX$(MODE):ENDLOOP

@F0
BGMSTOP:BTN_DEV=-1:FOR TURN=0 TO 3:UID[TURN]=-1:NEXT
CLS:FONT_COLOR 7:TURN=180:MODE=1:LOCATE 6,3:?"DARKNESS CARD BATTLE"
DRAW_TITLE 15:LOCATE 27,12:?"2015-2019 AOGONDO"
LOCATE 18,16:?"GAME START"
LOCATE 18,18:?"EDIT CARD DECK"
LOCATE 18,20:?"SELECT CONTROLLER"
LOCATE 18,22:?"HELP"
LOCATE 18,24:?"END"
SPHIDE 0:SELECT=0:LOCATE 42,29:?"ver";FORMAT$("%5.2F",APPVER#);
RETURN

@F1
DRAW_TITLE FLOOR(TURN/30)*2+3
TURN=(TURN+1) MOD 210
IF SELECT(5,16,16,"",2) THEN

CASE SELECT
  WHEN 0: GOTO @SETUP
  WHEN 1: EDIT_CARD:RETURN
  WHEN 2: SELECT_CONTROLLER:RETURN
  WHEN 3: MANUAL
  WHEN 4: GOTO @END
  OTHERWISE: RETURN
ENDCASE:ENDIF
RETURN

@F2
IF ALIVE(TURN) THEN
 CLS:DRAW_FIELD
 IF MPNUM<2 AND PLTURN[TURN]==MYID THEN
  LOCATE 20,23:?"あなたの ばん です":BTN_DEV=UID[MYID]
  WAIT_BUTTON:SELECT_CARD 0
 ELSE
  LOCATE 18,23:?GET_PLSTR$(TURN);"の ばん です"
  IF UID[PLTURN[TURN]]>=0 THEN
   MYID=PLTURN[TURN]:BTN_DEV=UID[MYID]
   WAIT_BUTTON:SELECT_CARD 0
  ELSE
   CPTURN
  ENDIF
 ENDIF
 SELECT=CHECK_WIN():IF SELECT GOTO @FINISH
ENDIF
STEPIN
RETURN

@SETUP
IF !SELECT_DECK() GOTO @F0
RSEED=RND(16777215)+1
MODE=2:CPULV=CLVSEL
CLS:BGMPLAY 0:BGMNUM=0
RANDOMIZE 0,RSEED:SHUFFLE:CLS
LOCATE 19, 6:?""
LOCATE 19, 7:?" ゲーム スタート "
LOCATE 19, 8:?""
LOCATE 14,22:?""
LOCATE 14,23:?" はじめに てふだを 7まい ひきます "
LOCATE 14,24:?""
FOR TURN=0 TO 3
 LOCATE 19,TURN*2+12:PLSTOP[TURN]=0
 ?(TURN+1);"ばん  ";GET_PLSTR$(TURN)
 PLCARD[TURN]=0:PLCARD[TURN+4]=7
NEXT
REPEAT:GET_INPUT:UNTIL BTN_NEW==16
FOR TURN=0 TO 3:CLEAR_ATTACK TURN:NEXT
TURN=0:SKIP=1:FIELD=0
IF MPNUM<2 THEN PLCARD[MYID+4]=0:GET_CARD 7
RETURN

@FINISH
CLS:DRAW_FIELD
IF SELECT<0 THEN
 BGMPLAY 6:?"さんかしゃが ぜんめつ しました。":MESSAGE 0
 ?"こんかいは ひきわけ です。"
ELSE
 BGMPLAY 5
 IF SELECT<4 THEN
  ?GET_PLSTR$(TURN);"が てふだを すべて つかいきりました。"
  MESSAGE 0:?GET_PLSTR$(TURN);"の ゆうしょう です。"
 ELSE
  ?GET_PLNAME$(SELECT AND 3);"が いきのこり ました。"
  MESSAGE 0:?GET_PLNAME$(SELECT AND 3);
  ?"の ゆうしょう です。"
 ENDIF
ENDIF
MODE=0:WAIT_BUTTON:BGMSTOP
RETURN

@END
CLS:?"SMILEBASIC for Nintendo Switch ver";#VERSION DIV 1000000;".";
?#VERSION DIV 10000 MOD 100;".";#VERSION DIV 100 MOD 100
?"(C)2011-";LEFT$(DATE$(),4);" SmileBoom Co.Ltd."
?FREEMEM();" bytes free":?
BLANK 30:?"Thanks for playing.":BLANK 60
END

DEF WAIT_INPUT *
 VAR _B=-1:IF DEFARGC() THEN _B=DEFARG(0)
 REPEAT:GET_INPUT:UNTIL !(KEY_H[0] AND _B)
END

DEF GET_INPUT
 VSYNC 1:VAR _X,_Y,_B
 VAR _L,_BN=0,_BH=0,_RN=0,_RH=0
 FOR _L=0 TO 5
  _B=BTN_TRANS(_L):KEY_N[_L]=NOT KEY_H[_L] AND _B:KEY_H[_L]=_B
  _BN=_BN OR KEY_N[_L]:_BH=_BH OR _B
  IF _L THEN _RN=_RN OR KEY_N[_L]:_RH=_RH OR _B
 NEXT
 IF BTN_DEV<0 THEN
  BTN_NEW=_BN:BTN_HLD=_BH
 ELSE
  BTN_NEW=KEY_N[BTN_DEV]:BTN_HLD=KEY_H[BTN_DEV]
 ENDIF
 VAR _T$:REPEAT:_T$=INKEY$():UNTIL !LEN(_T$)
 IF KEY_N[0] AND 1024 THEN BGMSTOP:STOP
END

DEF BTN_TRANS(_DEV)
 VAR _BTN=0
 IF _DEV>4 THEN
  IF KEYBOARD(82) THEN _BTN=_BTN OR    1
  IF KEYBOARD(81) THEN _BTN=_BTN OR    2
  IF KEYBOARD(80) THEN _BTN=_BTN OR    4
  IF KEYBOARD(79) THEN _BTN=_BTN OR    8
  IF KEYBOARD(40) THEN _BTN=_BTN OR   16
  IF KEYBOARD(44) THEN _BTN=_BTN OR   32
  IF KEYBOARD(28) THEN _BTN=_BTN OR  128
  IF KEYBOARD( 4) THEN _BTN=_BTN OR  256
  IF KEYBOARD( 7) THEN _BTN=_BTN OR  512
  IF KEYBOARD(41) THEN _BTN=_BTN OR 1024
 ELSE
  VAR _PB=BUTTON(_DEV),_X,_Y
  IF _PB AND   16 THEN _BTN=_BTN OR     1
  IF _PB AND   32 THEN _BTN=_BTN OR     2
  IF _PB AND   64 THEN _BTN=_BTN OR     4
  IF _PB AND  128 THEN _BTN=_BTN OR     8
  IF _PB AND    1 THEN _BTN=_BTN OR    64
  IF _PB AND    2 THEN _BTN=_BTN OR    32
  IF _PB AND    4 THEN _BTN=_BTN OR   128
  IF _PB AND    8 THEN _BTN=_BTN OR    16
  IF _PB AND  256 THEN _BTN=_BTN OR   256
  IF _PB AND  512 THEN _BTN=_BTN OR   512
  IF _PB AND 1024 THEN _BTN=_BTN OR  2048
  IF _PB AND 2048 THEN _BTN=_BTN OR  4096
  IF _PB AND 4096 THEN _BTN=_BTN OR 16384
  IF _PB AND 8192 THEN _BTN=_BTN OR 32768
  STICK _DEV OUT _X,_Y
  IF _Y<-0.4 THEN _BTN=_BTN OR 1
  IF _Y> 0.4 THEN _BTN=_BTN OR 2
  IF _X<-0.4 THEN _BTN=_BTN OR 4
  IF _X> 0.4 THEN _BTN=_BTN OR 8
 ENDIF
 IF !_DEV THEN _BTN=_BTN OR BTN_TRANS(5)
 RETURN _BTN
END

DEF GET_DEVICE(_DEVID)
 VAR _DEVTYPE,_DEVMAINC,_DEVSUBC,_DEVNAME$
 IF _DEVID>4 THEN RETURN " キーボード "
 CONTROLLER _DEVID OUT _DEVTYPE,_DEVMAINC,_DEVSUBC
 CASE _DEVTYPE
  WHEN    1: _DEVNAME$="プレイヤー 1"
  WHEN    2: _DEVNAME$="Proコン "+STR$(_DEVID)
  OTHERWISE: _DEVNAME$="Joyコン "+STR$(_DEVID)
 ENDCASE
 RETURN _DEVNAME$
END

DEF SELECT(_SIZE,_X,_Y,_CUR$,_LINE)
 VAR _LOOP,_DY=_Y
 IF BTN_NEW==1 THEN ADD_SELECT -1,_SIZE
 IF BTN_NEW==2 THEN ADD_SELECT  1,_SIZE
 FOR _LOOP=0 TO _SIZE-1
  LOCATE _X,_DY:INC _DY,_LINE
  IF SELECT==_LOOP THEN ?_CUR$ ELSE ?" "
 NEXT
 IF BTN_NEW==32 THEN RETURN -1
 RETURN BTN_NEW==16
END

DEF ADD_SELECT _ADD,_SIZE
 SELECT=(SELECT+_ADD+_SIZE) MOD _SIZE
 BEEP 9
END

DEF ALIVE(_TURN)
 RETURN PLCARD[PLTURN[_TURN]+4]<61
END

DEF CHECK_WIN()
 VAR _TP=PLTURN[TURN],_LOOP,_CHECK=0
 IF PLCARD[_TP]==PLCARD[_TP+4] THEN RETURN 1
 FOR _LOOP=4 TO 7
  INC _CHECK,PLCARD[_LOOP]<61
 NEXT
 IF _CHECK>1 THEN RETURN 0
 IF PLCARD[4]<61 THEN RETURN 4
 IF PLCARD[5]<61 THEN RETURN 5
 IF PLCARD[6]<61 THEN RETURN 6
 IF PLCARD[7]<61 THEN RETURN 7
 RETURN -1
END

DEF WAIT_BUTTON
 VAR _BLINK=0,_LOC=CSRY()
 REPEAT
  GET_INPUT:LOCATE 44,27
  IF _BLINK<30 THEN ?"" ELSE ?""
  _BLINK=(_BLINK+1) MOD 60
 UNTIL BTN_NEW==16
 LOCATE 44,27:?"":LOCATE 6,_LOC
END

DEF SELECT_CARD _BACK
 VAR _BASE=MYID*61+1+PLCARD[MYID],_SCR
 VAR _MAX=SIZE_SELECT(MYID,_BACK),_CARD
 VAR _M,_LOOP,_DMG,_X,_Y
 IF !_MAX THEN CARD_PUT _BACK,0:RETURN
 _SCR=0:SELECT=0:CLS:SPOFS 0,284,52
 LOCATE 6,2:?""
 LOCATE 6,3:?" ば に だす カードを せんたく "
 LOCATE 6,4:?""
 LOCATE 4,24:?"";""*40;""
 LOCATE 4,25:?"":LOCATE 45,25:?""
 LOCATE 4,26:?"":LOCATE 45,26:?""
 LOCATE 4,27:?"";""*40;""
 IF UID[MYID]>4 THEN
  LOCATE 2,18:?"Enter:"
  LOCATE 2,19:?"  けってい"
  LOCATE 2,21:?"Space:"
  LOCATE 2,22:?"    パス"
 ELSE
  LOCATE 2,21:?"A:けってい"
  LOCATE 2,22:?"B:パス"
 ENDIF
 LOCATE 32, 4:?"げんざいの ば の カード"
 _M=GET_CARDNAME$(FIELD,0):DEC _MAX
 LOCATE 39-CEIL(LEN(_M)/2),16:?_M
 _Y=18:_DMG=0:FOR _X=0 TO 3:INC _DMG,ATK_SOLID[MYID,_X]:NEXT
 IF _DMG THEN
  LOCATE 32,_Y:FONT_COLOR 7:?"ぶつり ";
  IF NGATK_SOLID[MYID] THEN ?"かんつう" ELSE ?"こうげき"
  LOCATE 41,_Y:?FORMAT$("%3D",_DMG);"Pt":INC _Y
 ENDIF
 _DMG=0:FOR _X=0 TO 3:INC _DMG,ATK_MAGIC[MYID,_X]:NEXT
 IF _DMG THEN
  IF _Y>18 THEN LOCATE 38,_Y:?"+":INC _Y
  LOCATE 32,_Y:FONT_COLOR 7:?"まほう ";
  IF NGATK_MAGIC[MYID] THEN ?"かんつう" ELSE ?"こうげき"
  LOCATE 41,_Y:?FORMAT$("%3D",_DMG);"Pt":INC _Y
 ENDIF
 _DMG=0:FOR _X=0 TO 3:INC _DMG,ATK_CRASH[MYID,_X]:NEXT
 IF _DMG THEN
  IF _Y>18 THEN LOCATE 38,_Y:?"+":INC _Y
  LOCATE 32,_Y:FONT_COLOR 7:?"クラッシャー"
  LOCATE 41,_Y:?FORMAT$("%3D",_DMG);"Pt"
 ENDIF
 WHILE 1
  _SCR=ACT_SELECT_CARD(_BASE,_SCR,_MAX,_BACK)
  IF BTN_NEW==16 THEN
   _CARD=_BASE+SELECT
   IF CHECK_CARD(_CARD,_BACK)>3 THEN
    SLIDE _CARD,_BASE:_CARD=PLSET[_BASE]
    INC PLCARD[MYID]:BREAK
   ENDIF
   BEEP 0:CONTINUE
  ENDIF
  IF BTN_NEW==32 THEN
   _CARD=1:REPEAT
    GET_INPUT
    IF BTN_NEW==4 THEN _CARD=0
    IF BTN_NEW==8 THEN _CARD=1
    IF !_BACK OR _DMG THEN
     RESTORE "@MANUAL_P"+STR$(_CARD)
    ELSE
     RESTORE "@MANUAL_P"+STR$(_CARD+2)
    ENDIF
    READ _M:LOCATE 6,25:?_M
    READ _M:LOCATE 6,26:?_M
   UNTIL BTN_NEW==16
   IF !_CARD THEN BREAK
  ENDIF
 WEND
 _BASE=_CARD AND 31
 IF _BASE==16 THEN SELECT_RECYCLE 4,"やまふだ"
 IF _BASE==20 THEN SELECT_SWAP
 CLS:CARD_PUT _BACK,_CARD
END

DEF MPTURN
 VAR _1ST=GET_MPDATA(16),_2ND=_1ST AND 255
 VAR _THIS=PLTURN[TURN]:_1ST=_1ST>>8
 IF _1ST THEN INC PLCARD[_THIS]
 IF _2ND THEN INC PLCARD[_THIS]
 CLS:CARD_PUT _1ST,_2ND
END

DEF CPTURN
 VAR _1ST,_2ND=0,_THIS=PLTURN[TURN]
 REPEAT
  _1ST=_2ND:_2ND=0
  IF !SIZE_SELECT(_THIS,_1ST) THEN BREAK
  VAR _PRI=-1,_SEL=0,_LOOP=PLCARD[_THIS]
  VAR _BASE=_THIS*61+1+_LOOP
  WHILE _LOOP<PLCARD[_THIS+4]
   VAR _COL=CHECK_CARD(_BASE,_1ST)
   IF _COL==15 THEN
    IF _PRI<0 THEN _PRI=0:_SEL=_BASE
   ELSEIF _COL>3 THEN
    _COL=PLSET[_BASE] AND 31
    IF _COL<2 THEN
     IF _PRI<2 THEN _PRI=2:_SEL=_BASE
    ELSEIF _COL==11 OR _COL==12 THEN
     _PRI=3:_SEL=_BASE:BREAK
    ELSE
     IF _PRI<1 THEN _PRI=1:_SEL=_BASE
    ENDIF
   ENDIF
   IF !CPULV AND _SEL>0 THEN BREAK
   INC _LOOP:INC _BASE
  WEND
  IF _SEL THEN
   _BASE=_THIS*61+1+PLCARD[_THIS]
   SLIDE _SEL,_BASE:_2ND=PLSET[_BASE]
   INC PLCARD[_THIS]
  ENDIF
  IF (_2ND AND 31)!=6 THEN BREAK
 UNTIL _1ST
 CARD_PUT _1ST,_2ND
END

DEF SIZE_SELECT(_ID,_BACK)
 IF PLSTOP[_ID] THEN RETURN 0
 VAR _MAX=PLCARD[_ID+4]-PLCARD[_ID]
 VAR _BASE=_ID*61+1+PLCARD[_ID],_LOOP=_MAX
 WHILE _LOOP
  IF CHECK_CARD(_BASE,_BACK)>3 THEN BREAK
  INC _BASE:DEC _LOOP
 WEND
 IF !_LOOP THEN RETURN 0
 RETURN _MAX
END

DEF SLIDE _START,_END
 VAR _VEC=SGN(_END-_START)
 IF !_VEC THEN RETURN
 VAR _CARD=PLSET[_START],_LOOP=_START
 WHILE _LOOP!=_END
  PLSET[_LOOP]=PLSET[_LOOP+_VEC]
  INC _LOOP,_VEC
 WEND
 PLSET[_END]=_CARD
END

DEF CARD_PUT _1ST,_2ND
 VAR _THIS=PLTURN[TURN],_L
 VAR _NEXT=PLTURN[GET_TARGET(1)]
 VAR _DMG_CRASH=0,_DMG_SOLID=0,_DMG_MAGIC=0
 FOR _L=0 TO 3
  INC _DMG_CRASH,ATK_CRASH[_THIS,_L]
  INC _DMG_SOLID,ATK_SOLID[_THIS,_L]
  INC _DMG_MAGIC,ATK_MAGIC[_THIS,_L]
 NEXT
 VAR _DMG=_DMG_CRASH+_DMG_SOLID+_DMG_MAGIC

 IF !_1ST AND !_2ND THEN
  DRAW_FIELD:LOCATE 6,20
  IF PLSTOP[_THIS] THEN
   ?GET_PLSTR$(TURN);"は みうごき できない!"
   DEC PLSTOP[_THIS]
  ELSE
   ?GET_PLSTR$(TURN);"は ば に だせる カードが ない!":INC _DMG
  ENDIF
  LOCATE 6,21
  IF _DMG THEN ?"やまふだ から カードを ";_DMG;"まい ひいて"; ELSE ?"なにも しないで";
  ?" ターンを しゅうりょう します。":WAIT_BUTTON
  DAMAGE _THIS,_DMG,0:CLEAR_ATTACK _THIS:RETURN
 ENDIF

 FIELD=_2ND:DRAW_FIELD
 IF _THIS==MYID THEN
  IF !_1ST AND (_2ND AND 31)==6 THEN
   IF SIZE_SELECT(MYID,_2ND)>0 THEN
    ?"つづけて ばに だす カードを 1まい せんたく":WAIT_BUTTON
    SELECT_CARD _2ND:RETURN
  ENDIF:ENDIF
 ENDIF

 IF !_2ND THEN _2ND=_1ST:_1ST=0
 VAR _CARD=_2ND AND 31
 ?GET_PLSTR$(TURN);"は ";
 IF _1ST THEN
  ?GET_CARDNAME$(_1ST,0);"を しょうかん。"
  LOCATE 6,21:?"さらに つづけて ";
 ENDIF
 ?GET_CARDNAME$(_2ND,0);"を しょうかん。"

 CASE _CARD
  WHEN 0:
   IF _DMG-_DMG_SOLID THEN
    MESSAGE 1:?GET_CARDNAME$(_2ND,0);"が まほうを きゅうしゅう!"
    IF NGATK_MAGIC[_THIS] THEN
     MESSAGE 0:?"しかし ";GET_CARDNAME$(_2ND,0);"は まほうを きゅうしゅう しきれず"
     MESSAGE 0:?"おとを たてて いきおい よく はじけとんだ。"
     MESSAGE 1:?"てきの こうげきが ";GET_PLSTR$(TURN);"を おそう!"
    ELSE
     MESSAGE 0:?GET_PLSTR$(TURN);"は まほうの ダメージを うけない。"
     DEC _DMG,_DMG_MAGIC:DEC _DMG,_DMG_CRASH
     IF _DMG THEN MESSAGE 1:?"しかし てきの ぶつりこうげきが ";GET_PLSTR$(TURN);"を おそう!"
    ENDIF
   ENDIF

  WHEN 1:
   IF _DMG-_DMG_MAGIC THEN
    MESSAGE 1:?GET_CARDNAME$(_2ND,0);"が こうげきを うけとめた!"
    IF NGATK_SOLID[_THIS] THEN
     MESSAGE 0:?"しかし ";GET_CARDNAME$(_2ND,0);"は こうげきを ふせぎ きれず"
     MESSAGE 0:?"おとを たてて いきおい よく はじけとんだ。"
     MESSAGE 1:?"てきの こうげきが ";GET_PLSTR$(TURN);"を おそう!"
    ELSE
     MESSAGE 0:?GET_PLSTR$(TURN);"は ぶつりこうげきの ダメージを うけない。"
     DEC _DMG,_DMG_SOLID:DEC _DMG,_DMG_CRASH
     IF _DMG THEN MESSAGE 1:?"しかし てきの まほうが ";GET_PLSTR$(TURN);"を おそう!"
    ENDIF
   ENDIF

  WHEN 11:
   IF _DMG-_DMG_MAGIC THEN
    IF NGATK_SOLID[_THIS] THEN
     MESSAGE 0:?GET_CARDNAME$(_2ND,0);"が こうげきを はじきかえす!"
     MESSAGE 0:?"しかし こうげきは ";GET_CARDNAME$(_2ND,0);"を かんつう"
     MESSAGE 0:?GET_CARDNAME$(_2ND,0);"は はかなく くだけちった。"
     MESSAGE 1:?"てきの こうげきが ";GET_PLSTR$(TURN);"を おそう!"
    ELSE
     DEC _DMG,_DMG_SOLID:DEC _DMG,_DMG_CRASH
     IF _DMG THEN
      MESSAGE 0:?GET_CARDNAME$(_2ND,0);"が こうげきを はじきかえす!"
      MESSAGE 1:?"しかし てきの まほうが ";GET_PLSTR$(TURN);"を おそう!"
     ENDIF
    ENDIF
   ENDIF

  WHEN 12:
   IF _DMG-_DMG_SOLID THEN
    IF NGATK_MAGIC[_THIS] THEN
     MESSAGE 0:?GET_CARDNAME$(_2ND,0);"が まほうを はねかえす!"
     MESSAGE 0:?"しかし まほうは ";GET_CARDNAME$(_2ND,0);"を かんつう"
     MESSAGE 0:?GET_CARDNAME$(_2ND,0);"は はかなく くだけちった。"
     MESSAGE 1:?"てきの こうげきが ";GET_PLSTR$(TURN);"を おそう!"
    ELSE
     DEC _DMG,_DMG_MAGIC:DEC _DMG,_DMG_CRASH
     IF _DMG THEN
      MESSAGE 0:?GET_CARDNAME$(_2ND,0);"が まほうを はねかえす!"
      MESSAGE 1:?"しかし てきの ぶつりこうげきが ";GET_PLSTR$(TURN);"を おそう!"
     ENDIF
    ENDIF
   ENDIF
 ENDCASE

 IF _DMG THEN
  MESSAGE 0:?GET_PLSTR$(TURN);"は ";_DMG;"ダメージを うけた。"
  DAMAGE _THIS,_DMG,1
 ENDIF

 CASE _CARD
  WHEN 2:
   MESSAGE 1:?GET_CARDNAME$(_2ND,0);"が まほう こうげきを はなつ!"
   INC ATK_MAGIC[_NEXT,_THIS],2

  WHEN 3:
   MESSAGE 1:?GET_CARDNAME$(_2ND,0);"が ぶつり こうげきを はなつ!"
   INC ATK_SOLID[_NEXT,_THIS],2

  WHEN 4:
   MESSAGE 1:?GET_CARDNAME$(_2ND,0);"が あたりに のろいを ふりまく!"
   MESSAGE 0:?"ときの ながれが くるって しまった。":REVERSE

  WHEN 5:
   MESSAGE 1:?GET_CARDNAME$(_2ND,0);"が ";
   ?GET_PLSTR$(GET_TARGET(1));"に のろいを かける!":MESSAGE 0
   ?GET_PLSTR$(GET_TARGET(1));"は のろいで みうごきが とれない。"
   INC PLSTOP[_NEXT]

  WHEN 7:
   MESSAGE 1:?GET_CARDNAME$(_2ND,0);"が ぶつり こうげきを はなつ!"
   MESSAGE 0:?GET_PLSTR$(TURN);"は しょうげきで 1ダメージを うけた。"
   INC ATK_SOLID[_NEXT,_THIS],4:NGATK_SOLID[_NEXT]=1
   DAMAGE _THIS,1,1

  WHEN 8:
   MESSAGE 1:?GET_CARDNAME$(_2ND,0);"が まほう こうげきを はなつ!"
   MESSAGE 0:?GET_PLSTR$(TURN);"は しょうげきで 1ダメージを うけた。"
   INC ATK_MAGIC[_NEXT,_THIS],4:NGATK_MAGIC[_NEXT]=1
   DAMAGE _THIS,1,1:NGATK=1

  WHEN 9:
   IF _DMG_SOLID+_DMG_CRASH THEN
    MESSAGE 1:?GET_CARDNAME$(_2ND,0);"が あいてに はんげき!":_DMG=0
    FOR _L=0 TO 3
     _DMG_MAGIC=INT((ATK_SOLID[_THIS,_L]+ATK_CRASH[_THIS,_L])*1.5)
     IF _DMG_MAGIC THEN
      IF PLCARD[_L]>60 THEN
       MESSAGE 0:?"しかし ";GET_PLNAME$(_L);"は すでに いきたえていた。"
      ELSE
       MESSAGE 0:?GET_PLNAME$(_L);
       IF !_DMG THEN ?"を "; ELSE ?"も ";
       ?"ひょうてきに さだめた。":INC _DMG
       INC ATK_SOLID[_L,_THIS],_DMG_MAGIC:NGATK_SOLID[_L]=1
      ENDIF
     ENDIF
    NEXT
   ENDIF

  WHEN 10:
   IF _DMG_MAGIC+_DMG_CRASH THEN
    MESSAGE 1:?GET_CARDNAME$(_2ND,0);"が あいてに はんげき!":_DMG=0
    FOR _L=0 TO 3
     _DMG_SOLID=INT((ATK_MAGIC[_THIS,_L]+ATK_CRASH[_THIS,_L])*1.5)
     IF _DMG_SOLID THEN
      IF PLCARD[_L]>60 THEN
       MESSAGE 0:?"しかし ";GET_PLNAME$(_L);"は すでに いきたえていた。"
      ELSE
       MESSAGE 0:?GET_PLNAME$(_L);
       IF !_DMG THEN ?"を "; ELSE ?"も ";
       ?"ひょうてきに さだめた。":INC _DMG
       INC ATK_MAGIC[_L,_THIS],_DMG_SOLID:NGATK_MAGIC[_L]=1
      ENDIF
     ENDIF
    NEXT
   ENDIF

  WHEN 11:
   IF !NGATK_SOLID[_THIS]*(_DMG_SOLID+_DMG_CRASH) THEN
    IF !_DMG THEN MESSAGE 1:?GET_CARDNAME$(_2ND,0);"が こうげきを はじきかえす!"
    _DMG=0
    FOR _L=0 TO 3
     _DMG_MAGIC=ATK_SOLID[_THIS,_L]+ATK_CRASH[_THIS,_L]
     IF _DMG_MAGIC THEN
      IF PLCARD[_L]>60 THEN
       MESSAGE 0:?"しかし ";GET_PLNAME$(_L);"は すでに いきたえていた。"
      ELSE
       MESSAGE 0:?"こうげきは ";GET_PLNAME$(_L);
       IF !_DMG THEN ?"へと "; ELSE ?"にも ";
       ?"とんでいった。":INC _DMG:INC ATK_SOLID[_L,_THIS],_DMG_MAGIC
      ENDIF
     ENDIF
    NEXT
    MESSAGE 1:?GET_PLSTR$(TURN);"は はんどうで たいせいを くずした。"
    INC PLSTOP[_THIS]
   ENDIF

  WHEN 12:
   IF !NGATK_MAGIC[_THIS]*(_DMG_MAGIC+_DMG_CRASH) THEN
    IF !_DMG THEN MESSAGE 1:?GET_CARDNAME$(_2ND,0);"が まほうを はねかえす!"
    _DMG=0
    FOR _L=0 TO 3
     _DMG_SOLID=ATK_MAGIC[_THIS,_L]+ATK_CRASH[_THIS,_L]
     IF _DMG_SOLID THEN
      IF PLCARD[_L]>60 THEN
       MESSAGE 0:?"しかし ";GET_PLNAME$(_L);"は すでに いきたえていた。"
      ELSE
       MESSAGE 0:?"まほうは ";GET_PLNAME$(_L);
       IF !_DMG THEN ?"へと "; ELSE ?"にも ";
       ?"とんでいった。":INC _DMG:INC ATK_MAGIC[_L,_THIS],_DMG_SOLID
      ENDIF
     ENDIF
    NEXT
    MESSAGE 1:?GET_PLSTR$(TURN);"は はんどうで たいせいを くずした。"
    INC PLSTOP[_THIS]
   ENDIF

  WHEN 13:
   INC _DMG,_DMG
   IF _DMG THEN
    MESSAGE 1:?GET_CARDNAME$(_2ND,0);"は いかりに もえている!"
    MESSAGE 0:?GET_CARDNAME$(_2ND,0);"の こうげきりょくが ";_DMG;"に あがった。"
    MESSAGE 0:?GET_CARDNAME$(_2ND,0);"が いかりの ままに ぶつりこうげきを はなつ!"
    INC ATK_SOLID[_NEXT,_THIS],_DMG
   ELSE
    MESSAGE 0:?GET_CARDNAME$(_2ND,0);"が ぶつりこうげきを はなつ!"
    MESSAGE 0:?"ミス! こうげきは しっぱいに おわった。"
   ENDIF

  WHEN 14:
   INC _DMG,_DMG
   IF _DMG THEN
    MESSAGE 1:?GET_CARDNAME$(_2ND,0);"は いかりに もえている!"
    MESSAGE 0:?GET_CARDNAME$(_2ND,0);"の こうげきりょくが ";_DMG;"に あがった。"
    MESSAGE 0:?GET_CARDNAME$(_2ND,0);"が いかりの ままに まほうこうげきを はなつ!"
    INC ATK_MAGIC[_NEXT,_THIS],_DMG
   ELSE
    MESSAGE 0:?GET_CARDNAME$(_2ND,0);"が まほうこうげきを はなつ!"
    MESSAGE 0:?"ミス! しかし MPが たりない。"
   ENDIF

  WHEN 15:
   MESSAGE 1:?GET_CARDNAME$(_2ND,0);"が すべてに はめつを もたらす!"
   FOR _L=0 TO 3:INC ATK_CRASH[_L,_THIS],2:NEXT

  WHEN 16:
   IF PLCARD[_THIS]>1 THEN
    _DMG=PLCARD[_THIS+4]-60:_1ST=RECYCLE(4)
    MESSAGE 1:?"まよえる たましいよ... おのが いばしょへ かえれ!!"
    MESSAGE 0:?GET_PLSTR$(TURN);"は ";
    ?_1ST;"まいの しようずみ カードを やまふだへ もどした。"
    RESHUFFLE _THIS
    IF _DMG>0 THEN
     IF _DMG<=_1ST THEN
      MESSAGE 1:?"これにより ";GET_PLSTR$(TURN);"が せんせんに ふっき!"
      IF _THIS!=MYID THEN
       MESSAGE 0:?"やまふだ から カードを ";_DMG;
       ?"まい ひいて たたかいを ぞっこう。"
      ENDIF
      DEC PLCARD[_THIS+4],_DMG:DAMAGE _THIS,_DMG,1
     ELSE
      MESSAGE 0:?"しかし せんせんに ふっき するには カードが たりなかった..."
     ENDIF
    ENDIF
   ENDIF

  WHEN 17:
   MESSAGE 1:?GET_CARDNAME$(_2ND,0);"が ";GET_PLSTR$(TURN);"の じゅふを くらいつくす!"
   MESSAGE 0:?GET_PLSTR$(TURN);"は てふだを すべて ";
   IF _THIS!=MYID THEN
    ?"うしなって":MESSAGE 0:?"やまふだ から カードを 5まい ほじゅう した。"
   ELSE
    ?"うしなった。"
   ENDIF
   PLCARD[_THIS]=PLCARD[_THIS+4]
   DAMAGE _THIS,5,1

  WHEN 18:
   MESSAGE 1:?GET_CARDNAME$(_2ND,0);"が せんじょうに こんらんを まきおこす!"
   MESSAGE 0:?"すべての プレイヤーは てふだを すべて やまふだに もどした。"
   JUGGRING _2ND

  WHEN 19:
   MESSAGE 1:?GET_CARDNAME$(_2ND,0);"の よびかけで"
   MESSAGE 0:?"すべての しせる ものに かりそめの いのちが やどる!"
   _1ST=PLCARD[_THIS]-1:MESSAGE 0
   IF _1ST THEN
    _DMG=CEIL(_1ST/2)
     _DMG_CRASH=PLCARD[_THIS+4]-60
    IF _DMG_CRASH>0THEN
     ?"なんと ";GET_PLSTR$(TURN);"が せんせんに ふっき!"
     PLCARD[_THIS+4]=60:INC _DMG,_DMG_CRASH
     MESSAGE 0
    ENDIF
    ?GET_PLSTR$(TURN);"は すべての しようずみ カードを ";
    IF _THIS!=MYID THEN
     ?"やまふだに もどして":MESSAGE 0
     ?"シャッフル した のちに カードを ";_DMG;"まい ひいた。"
    ELSE
     ?:MESSAGE 0:?"やまふだに もどして シャッフル した。"
    ENDIF
    _1ST=RECYCLE(_1ST):RESHUFFLE _THIS:DAMAGE _THIS,_DMG,1
   ELSE
    ?"しかし なにも おきなかった..."
   ENDIF

  WHEN 20:
   MESSAGE 1:?GET_CARDNAME$(_2ND,0);"が せかいに おおあなを ひらく!":MESSAGE 0
   IF PLCARD[_THIS]>2 THEN
    ?GET_PLSTR$(TURN);"は てふだと しようずみ カードを"
    MESSAGE 0:?"1まい えらんで こうかん した。"
    _1ST=_THIS*61:_2ND=_1ST+PLCARD[_THIS+4]
    _DMG=_2ND-_DMG:SLIDE _DMG,_2ND
    SWAP PLSET[_2ND],PLSET[_1ST+1]
   ELSE
    ?"しかし なにも おきなかった..."
   ENDIF
 ENDCASE
 CLEAR_ATTACK _THIS
 IF CSRY()>20 THEN WAIT_BUTTON
END

DEF CLEAR_ATTACK _T
 VAR _L
 FOR _L=0 TO 3
  ATK_SOLID[_T,_L]=0:ATK_MAGIC[_T,_L]=0:ATK_CRASH[_T,_L]=0
 NEXT
 NGATK_SOLID[_T]=0:NGATK_MAGIC[_T]=0
END

DEF ACT_SELECT_CARD(_BASE,_SCR,_MAX,_BACK)
 GET_INPUT:VAR _LOOP,_CARD,_M
 IF _MAX>8 THEN
  IF BTN_NEW==4 THEN
   IF !_SCR THEN
    _SCR=_MAX-8:INC SELECT,_SCR
   ELSE 
    DEC SELECT,9:DEC _SCR,9
    WHILE _SCR<0:INC _SCR:INC SELECT:WEND
   ENDIF
   BEEP 9
  ENDIF
  IF BTN_NEW==8 THEN
   IF _SCR<_MAX-8 THEN INC SELECT,9:INC _SCR,9 ELSE DEC SELECT,_SCR:_SCR=0
   BEEP 9
  ENDIF
  WHILE _SCR>_MAX-8:DEC _SCR:DEC SELECT:WEND
 ENDIF
 IF BTN_NEW==1  THEN DEC SELECT:BEEP 9
 IF BTN_NEW==2  THEN INC SELECT:BEEP 9
 IF SELECT<   0 THEN SELECT=_MAX
 IF SELECT>_MAX THEN SELECT=   0
 IF SELECT<_SCR THEN _SCR=SELECT
 WHILE SELECT>_SCR+8:INC _SCR:WEND
 _CARD=_SCR+_BASE
 FOR _LOOP=0 TO 8
  LOCATE 9,_LOOP*2+6:FONT_COLOR 15
  IF _SCR+_LOOP==SELECT THEN ?" "; ELSE ?"  ";
  IF _BACK>=0 THEN FONT_COLOR CHECK_CARD(_CARD,_BACK)
  IF _LOOP>_MAX THEN ?" "*13 ELSE ?GET_CARDNAME$(PLSET[_CARD],1)
  INC _CARD
 NEXT
 FONT_COLOR 15:_CARD=PLSET[SELECT+_BASE] AND 31
 RESTORE "@MANUAL_"+FORMAT$("%02D",_CARD)
 READ _M:LOCATE 6,25:?_M
 READ _M:LOCATE 6,26:?_M:LOCATE 25,14
 IF _SCR<_MAX-8 THEN ?"" ELSE ?" "
 LOCATE 6,14:IF _SCR THEN ?"" ELSE ?" "
 RETURN _SCR
END

DEF STEPIN
 VAR _STEP=SGN(SKIP),_MN=0,_PC=0
 WHILE SKIP
  TURN=(TURN+_STEP) AND 3
  IF ALIVE(TURN) THEN DEC SKIP,_STEP
 WEND:SKIP=_STEP
 FOR _STEP=3 TO 0 STEP -1
  IF PLCARD[_STEP+4]<61 THEN
   IF PLCARD[_STEP+4]-PLCARD[_STEP]<4 THEN _MN=2
   INC _PC
  ENDIF
 NEXT
 IF _PC<3 AND !_MN THEN _MN=3
 IF BGMNUM!=_MN THEN BGMNUM=_MN:BGMPLAY _MN
END

DEF SELECT_SWAP
 VAR _BASE=MYID*61+1+PLCARD[MYID],_SCR
 VAR _MAX=SIZE_SELECT(MYID,1):ONSWAP=_MAX>0
 IF !ONSWAP THEN RETURN ELSE DEC _MAX
 _SCR=0:SELECT=0:CLS:SPOFS 1,284,52:SPHIDE 0
 LOCATE  5, 2:?""
 LOCATE  5, 3:?" てふだから すてる カードを せんたく "
 LOCATE  5, 4:?""
 LOCATE  4,24:?"";""*40;""
 LOCATE  4,25:?"":LOCATE 45,25:?""
 LOCATE  4,26:?"":LOCATE 45,26:?""
 LOCATE  4,27:?"";""*40;""
 LOCATE  2,20:?"あと 1まい"
 LOCATE  2,21:?"A:けってい":SPSHOW 1
 REPEAT
  _SCR=ACT_SELECT_CARD(_BASE,_SCR,_MAX,-1)
  SET_SPRITE 1,PLSET[_BASE+SELECT]
 UNTIL BTN_NEW==16
 _SCR=_BASE+SELECT
 _BASE=MYID*61+PLCARD[MYID+4]
 SLIDE _SCR,_BASE
 WAIT_INPUT 16
 SPHIDE 1:SELECT_RECYCLE 1,"てふだ "
END

DEF SELECT_RECYCLE _SELECT,_POS$
 VAR _BASE=MYID*61+1,_SCR,_MAX=PLCARD[MYID]-2
 IF _MAX<_SELECT THEN RETURN
 VAR _M,_LOOP,_CARD,_COUNT=0
 _SCR=0:SELECT=0:CLS:SPOFS 1,284,52:SPHIDE 0
 LOCATE  5, 2:?""
 LOCATE  5, 3:?" ";_POS$;"に もどす カードを せんたく "
 LOCATE  5, 4:?""
 LOCATE  4,24:?"";""*40;""
 LOCATE  4,25:?"":LOCATE 45,25:?""
 LOCATE  4,26:?"":LOCATE 45,26:?""
 LOCATE  4,27:?"";""*40;""
 LOCATE  2,21:?"A:けってい":SPSHOW 1
 WHILE _COUNT<_SELECT
  _LOOP=_BASE+_COUNT
  _SCR=ACT_SELECT_CARD(_LOOP,_SCR,_MAX,-1)
  LOCATE 2,20:?"あと ";_SELECT-_COUNT;"まい"
  LOCATE 2,22
  IF _COUNT THEN ?"B:とりけし" ELSE ?" "*6
  SET_SPRITE 1,PLSET[SELECT+_BASE+_COUNT]
  IF BTN_NEW==16 THEN
   _CARD=_LOOP+SELECT:DEC _MAX
   SLIDE _CARD,_LOOP:INC _COUNT
  ENDIF
  IF BTN_NEW==32 AND _COUNT>0 THEN INC _MAX:DEC _COUNT:_SCR=0:SELECT=0
 WEND
 SPHIDE 1
END

DEF RECYCLE(_MAX)
 VAR _THIS  =PLTURN[TURN]
 VAR _COUNT =PLCARD[_THIS]-1
 IF _COUNT<=0   THEN RETURN 0
 IF _COUNT>_MAX THEN _COUNT=_MAX
 VAR _BASE =_THIS*61,_LOOP=_COUNT
 WHILE _LOOP
  SLIDE _BASE+_LOOP,_BASE+60:DEC _LOOP
  DEC PLCARD[_THIS]:DEC PLCARD[_THIS+4]
 WEND
 RETURN _COUNT
END

DEF RESHUFFLE _THIS
 VAR _BASE=PLCARD[_THIS+4]
 VAR _SIZE=60-_BASE:INC _BASE,_THIS*61+1
 IF _SIZE<=0 THEN RETURN
 DIM _RES[_SIZE],VAR _POS=_BASE,_LOOP=_SIZE
 WHILE _LOOP
  VAR _R=RND(_SIZE):IF _RES[_R] THEN CONTINUE
  _RES[_R]=PLSET[_POS]:INC _POS:DEC _LOOP
 WEND
 COPY PLSET,_BASE,_RES,0,_SIZE
END

DEF REVERSE
 VAR _A,_B,_C=PLTURN[TURN],_D=RND(10)+1
 WHILE _D
  _A=RND(4):_B=RND(4)
  IF _A!=_B THEN SWAP PLTURN[_A],PLTURN[_B]:DEC _D
 WEND
 _D=RND(4):SKIP=-SKIP
 IF _D THEN
  DIM _TURN[4]:COPY _TURN,PLTURN
  FOR _A=0 TO 3:PLTURN[_A]=_TURN[(_A+_D) AND 3]:NEXT
 ENDIF
 FOR _A=0 TO 3
  IF PLTURN[_A]==_C THEN TURN=_A
 NEXT
 WAIT_BUTTON:DRAW_FIELD:?"こうどう じゅんが いれかわった!"
END

DEF REV_CRASH _POW
 VAR _THIS=PLTURN[TURN],_L=0
 VAR _MASK=1<<(_THIS+4)
 WHILE _L<LEN(CRASH)
  IF CRASH[_L] AND _MASK THEN
   VAR _TARGET=CRASH[_L] AND 7
   MESSAGE 1:?GET_PLNAME$(_TARGET);
   IF ALIVE(_TARGET) THEN
    ?"に ";_POW;"ダメージ"
    DAMAGE _TARGET,_POW,1
   ELSE
    ?"は すでに いきたえていた..."
   ENDIF
  ENDIF
  INC _L
 WEND
END

DEF CHECK_CARD(_INDEX,_CARRY)
 IF _CARRY THEN RETURN 15
 IF !FIELD THEN RETURN 15
 VAR _CARD=PLSET[_INDEX],_MC,_BC
 VAR _CR=0,_SD=0,_MD=0,_LP,_ID=PLTURN[TURN]
 VAR _FE=FIELD>>5,_FC=FIELD AND 31
 VAR _CE=_CARD>>5,_CC=_CARD AND 31
 VAR _OK=_FC==_CC OR _FE==_CE
 FOR _LP=0 TO 3
  _CR=_CR OR !!ATK_CRASH[_ID,_LP]
  _SD=_SD OR !!ATK_SOLID[_ID,_LP]
  _MD=_MD OR !!ATK_MAGIC[_ID,_LP]
 NEXT
 IF !_OK THEN
  IF _FE< 5 THEN _OK=_CE> 4
  IF _FE==5 THEN _OK=_CE!=6
  IF _FE==6 THEN _OK=_CE!=5
  IF _FE==7 THEN _OK=1
 ENDIF
 IF !_OK THEN RETURN 3
 _MC=_CC==13 OR _CC==14
 _BC=_MC OR _CC==9:_MC=_MC OR _CC==10
 IF !NGATK_SOLID[_ID] THEN _BC=_BC OR _CC==1 OR _CC==11
 IF !NGATK_MAGIC[_ID] THEN _MC=_MC OR _CC==0 OR _CC==12
 IF _MD*_MC THEN RETURN 13
 IF _SD*_BC THEN RETURN 13
 IF _CR*(_MC OR _BC) THEN RETURN 13
 RETURN 15
END

DEF JUGGRING _CARD
 VAR _LOOP=4
 WHILE _LOOP
  DEC _LOOP
  IF PLCARD[_LOOP+4]<61 THEN
   VAR _POP=PLCARD[_LOOP+4]-PLCARD[_LOOP]
   PLCARD[_LOOP+4]=PLCARD[_LOOP]
   RESHUFFLE _LOOP:DAMAGE _LOOP,_POP,1
  ENDIF
 WEND
 MESSAGE 0:?GET_CARDNAME$(_CARD,0);
 ?"は スキを ついて ぜんいん から":MESSAGE 0:?"ごうけい ";
 ?RND(24448)+128;"ゴールドを ぬすんだ。"
END

DEF DRAW_TITLE _FONT_COLOR
 FONT_COLOR _FONT_COLOR:VAR _LOOP,_T$:RESTORE @LOGO
 FOR _LOOP=6 TO 9
  READ _T$:LOCATE 7,_LOOP:?_T$
 NEXT
 FONT_COLOR 15:VAR _H
 LOCATE 5, 4:?"";""*38;""
 LOCATE 5,11:?"";""*38;""
 FOR _H=5 TO 10
  LOCATE 5,_H:?"":LOCATE 44,_H:?""
 NEXT
END

DEF DRAW_FIELD
 LOCATE 8,2:?"";GET_PLSTR$(0);"";
 ?GET_PLSTR$(1);"";GET_PLSTR$(2);"";
 ?GET_PLSTR$(3);"":LOCATE 8,3
 ?"                            ":?" "*8;
 ?" てふだ    てふだ    てふだ    てふだ   ":?" "*8;
 ?"";CARD_NUM(0);CARD_NUM(1);
 ?CARD_NUM(2);CARD_NUM(3):?" "*8;
 ?"                            ":?" "*8;
 ?" やまふだ   やまふだ   やまふだ   やまふだ  ":?" "*8;
 ?"";CARD_NUM(4);CARD_NUM(5);
 ?CARD_NUM(6);CARD_NUM(7):?" "*8;
 ?"                            ":?" "*8;
 ?""
 SET_SPRITE 0,FIELD:SPOFS 0,176,88,8:SPSHOW 0
 LOCATE 4,19:?"";""*40;"":CLEAR_MESSAGE
 LOCATE 4,27:?"";""*40;"":LOCATE 6,20:BR=0
END

DEF MESSAGE _WAIT
 IF CSRY()>26 THEN
  VAR _M,_X,_Y=21
  IF _WAIT OR !BR THEN WAIT_BUTTON
  WHILE _Y<27
   _M="":_X=6
   WHILE _X<44
    INC _M,CHR$(CHKCHR(_X,_Y)):INC _X
   WEND
   LOCATE 6,_Y-1:?_M:INC _Y
  WEND
  LOCATE 6,26:?" "*38;
 ENDIF
 LOCATE 6,CSRY()
END

DEF CLEAR_MESSAGE
 VAR _LOOP=20:REPEAT
  LOCATE 4,_LOOP:?"";" "*40;"":INC _LOOP
 UNTIL _LOOP>26:BR=0
END

DEF GET_PLSTR$(_TURN)
 RETURN GET_PLNAME$(PLTURN[_TURN AND 3])
END

DEF GET_PLNAME$(_P)
 IF UID[_P]>0 THEN RETURN GET_DEVICE(UID[_P])
 RETURN "コンピュータ"+STR$(PLSET[_P*61])
END

DEF IS_PLAYER(_TURN)
 VAR _HNUM=MPNUM,_TNUM=PLTURN[_TURN AND 3]
 IF _TNUM== MYID THEN RETURN 1
 IF _TNUM>=_HNUM THEN RETURN 0
 RETURN PLSET[_TNUM*61]<0
END

DEF CARD_NUM(_INDEX)
 VAR _BOX=PLTURN[_INDEX AND 3]
 IF PLCARD[_BOX+4]>60 THEN RETURN "  --まい "
 VAR _NUM=PLCARD[_BOX+4]-PLCARD[_BOX]
 IF _INDEX>3 THEN _NUM=60-PLCARD[_BOX+4]
 RETURN FORMAT$("%4D",_NUM)+"まい "
END

DEF SELECT_DECK()
 DIM _DECK[4],_READY[4],_PNUM[5]
 VAR _LOOP,_STANDBY=0,_DX,_DY
 CLS:LOCATE 16, 4:?"Aボタン/Enterキーで さんか"
     LOCATE 16,26:?"Bボタン/Spaceキーで やめる"
 FOR _LOOP=0 TO 3
  _DECK[_LOOP]=0:_READY[_LOOP]=0:UID[_LOOP]=-1:_PNUM[_LOOP]=-1
 NEXT
 _PNUM[4]=-1:MPNUM=0
 WHILE 1
  GET_INPUT
  FOR _LOOP=0 TO 4
   IF _PNUM[_LOOP]<0 THEN
    IF KEY_N[_LOOP+1]==16 THEN
     _PNUM[_LOOP]=ADD_PLAYER(_LOOP+1)
   ENDIF:ENDIF
  NEXT
  IF !MPNUM THEN
   IF BTN_NEW==32 THEN
    RETURN 0
  ENDIF:ENDIF
  FOR _LOOP=0 TO 3
   _DX=(_LOOP AND 1)*18:_DY=((_LOOP AND 2)>0)*9
   IF UID[_LOOP]>=0 THEN
    LOCATE 10+_DX,7+_DY:?_LOOP+1;"P: ";GET_DEVICE(UID[_LOOP])
    LOCATE 11+_DX,9+_DY:?"デッキ せんたく"
    IF _READY[_LOOP] THEN
     IF KEY_N[UID[_LOOP]]==32 THEN
      _READY[_LOOP]=0:DEC _STANDBY
      LOCATE 7,24:?" "*35
     ENDIF
     LOCATE  8+_DX,11+_DY:?" "*14
     LOCATE 10+_DX,11+_DY:?GET_CHARNAME(_DECK[_LOOP])
     LOCATE  8+_DX,13+_DY:?"    Bで やめる    "
     IF UID[_LOOP]>4 THEN LOCATE 5+_DX,13+_DY:?"     Spaceで やめる     "
    ELSE
     IF KEY_N[UID[_LOOP]]== 4 THEN _DECK[_LOOP]=(_DECK[_LOOP]+19) MOD 20
     IF KEY_N[UID[_LOOP]]== 8 THEN _DECK[_LOOP]=(_DECK[_LOOP]+ 1) MOD 20
     IF KEY_N[UID[_LOOP]]==16 THEN _READY[_LOOP]=1:INC _STANDBY
     LOCATE  8+_DX,11+_DY:?"            "
     LOCATE 10+_DX,11+_DY:?GET_CHARNAME(_DECK[_LOOP])
     LOCATE  8+_DX,13+_DY:?"Aで けってい/Bで やめる"
     IF UID[_LOOP]>4 THEN LOCATE 5+_DX,13+_DY:?"Enter けってい/Space やめる"
     IF KEY_N[UID[_LOOP]]==32 THEN
      _PNUM[UID[_LOOP]-1]=-1:UID[_LOOP]=-1:DEC MPNUM:_DECK[_LOOP]=0
      LOCATE 10+_DX, 7+_DY:?" "*11
      LOCATE 11+_DX, 9+_DY:?" "*8
      LOCATE  8+_DX,11+_DY:?" "*14
      LOCATE  5+_DX,13+_DY:?" "*20
     ENDIF
    ENDIF
   ENDIF
  NEXT
  IF MPNUM THEN
   IF _STANDBY==MPNUM THEN
    LOCATE 11,24:?"Yボタン または キーボードの 'Y'キーで スタート"
    FOR _LOOP=0 TO 3
     IF UID[_LOOP]>0 THEN
      IF KEY_N[UID[_LOOP]]==128 THEN
       BREAK
     ENDIF:ENDIF
    NEXT
    IF SELECT_CPU_LV(_LOOP) THEN BREAK
  ENDIF:ENDIF
 WEND
 _DX=1:_DY=0
 FOR _LOOP=0 TO 3
  IF UID[_LOOP]<0 THEN _DECK[_LOOP]=RND(8)
  LOAD_DECK _LOOP,_DECK[_LOOP]
  IF UID[_LOOP]>=0 THEN
   PLSET[_DY]=-1:MYID=_LOOP
  ELSE
   PLSET[_DY]=_DX:INC _DX
  ENDIF
  INC _DY,61
 NEXT
 RETURN 1
END

DEF ADD_PLAYER(_PNUM)
 VAR _LOOP,_RESULT=-1
 FOR _LOOP=0 TO 3
  IF UID[_LOOP]==_PNUM THEN
   RETURN -1
  ELSEIF _RESULT<0 THEN
   IF UID[_LOOP]<0 THEN _RESULT=_LOOP
  ENDIF
 NEXT
 IF _RESULT>=0 THEN
  UID[_RESULT]=_PNUM
  INC MPNUM:KEY_N[_PNUM]=0
  LOCATE 7,24:?" "*35
 ENDIF
 RETURN _RESULT
END

DEF LOAD_DECK _POS,_DECK
 IF _POS<0 THEN _POS=0 ELSE _POS=_POS*61
 PLSET[_POS]=_POS:INC _POS
 IF _DECK<8 THEN
  COPY PLSET,_POS,"@CARD_SET"+STR$(_DECK),60
 ELSE
  VAR _SRC=(_DECK-8)*70+10
  COPY PLSET,_POS,MYSET,_SRC,60
 ENDIF
END

DEF SET_COMPUTER
 VAR _CPU=0,_MP=MPNUM>1,_CPN=1
 IF !_MP THEN _CPU=1
 WHILE _CPU<4
  IF _MP THEN
   IF _CPU<MPNUM THEN
    IF MPSTAT(_CPU) THEN
     INC _CPU:CONTINUE
  ENDIF:ENDIF:ENDIF
  VAR _P=_CPU*61,_C=RND(8)
  PLSET[_P]=_CPN:INC _P:INC _CPU:INC _CPN
  COPY PLSET,_P,"@CARD_SET"+STR$(_C),60
 WEND
END

DEF SELECT_CPU_LV(_INP)
 IF _INP>3 THEN RETURN 0
 VAR _INT=UID[_INP]
 IF _INT<=0 OR _INT>5 THEN RETURN 0
 IF MPNUM>3           THEN RETURN 1
 LOCATE 20,12:?"コンピュータ"
 LOCATE 20,13:?"      "
 LOCATE 20,15:?"      "
 LOCATE 20,17:?"      "
 LOCATE 20,18:?""
 REPEAT
  LOCATE 20,14:?"  よわい "
  LOCATE 20,16:?"  つよい "
  LOCATE 22,CLVSEL*2+14:?""
  GET_INPUT
  IF KEY_N[_INT]== 1 THEN CLVSEL=0
  IF KEY_N[_INT]== 2 THEN CLVSEL=1
  IF KEY_N[_INT]==16 THEN RETURN 1
 UNTIL KEY_N[_INT]==32
 FOR _INT=12 TO 18:LOCATE 20,_INT:?" "*8:NEXT
 RETURN 0
END

DEF SHUFFLE
 DIM _TEMP[0],_SET[0]:VAR _LOOP,_DAT
 FOR _LOOP=0 TO 3
  _SET=NULL():COPY _TEMP,PLSET,_LOOP*61+1,60
  WHILE LEN(_SET)<60
   REPEAT:_DAT=RND(60):UNTIL _TEMP[_DAT]
   PUSH _SET,_TEMP[_DAT]:_TEMP[_DAT]=0
  WEND
  COPY PLSET,_LOOP*61+1,_SET,0,60
 NEXT
 FOR _LOOP=0 TO 3:_SET[_LOOP]=-1:NEXT
 FOR _LOOP=0 TO 3
  REPEAT:_DAT=RND(4):UNTIL _SET[_DAT]<0
  _SET[_DAT]=_LOOP
 NEXT
 COPY PLTURN,0,_SET,0,4
END

DEF GET_TARGET(_TURN)
 VAR _TARGET=TURN
 IF _TURN THEN
  _TURN=SGN(SKIP)*_TURN
  REPEAT:_TARGET=(_TARGET+_TURN) AND 3:UNTIL ALIVE(_TARGET)
 ENDIF
 RETURN _TARGET
END

DEF DAMAGE _THIS,_COUNT,_WAIT
 IF _COUNT>99 THEN _COUNT=99
 VAR _PID=MYID,_PDEV=BTN_DEV
 IF UID[_THIS]>=0 THEN MYID=_THIS:BTN_DEV=UID[MYID]
 IF _THIS!=MYID THEN
  INC PLCARD[_THIS+4],_COUNT
  IF PLCARD[_THIS+4]>60 THEN
   MESSAGE 1:?"やまふだ から カードが ひけない ため"
   MESSAGE 0:?GET_PLNAME$(_THIS);
   ?"は だつらく しました。"
  ENDIF
  RETURN
 ENDIF
 IF _WAIT THEN
  MESSAGE 1:?GET_PLNAME$(_THIS);"は ";
  ?"やまふだ から カードを ";_COUNT;"まい ひきます。":WAIT_BUTTON
 ENDIF
 GET_CARD _COUNT:DRAW_FIELD
 MYID=_PID:BTN_DEV=_PDEV
END

DEF GET_CARD _COUNT
 IF !_COUNT THEN RETURN
 VAR _INDEX=MYID*61+PLCARD[MYID+4],_C
 SPHIDE 0
 IF UID[MYID]>0 THEN BTN_DEV=UID[MYID]
 WHILE _COUNT
  IF PLCARD[MYID+4]>59 THEN BREAK
  DEC _COUNT:INC _INDEX:INC PLCARD[MYID+4]
  VAR _CARD=PLSET[_INDEX],_Y=-64:CLS
  SET_SPRITE 1,_CARD:SPOFS 1,176,_Y:SPSHOW 1
  LOCATE 0,29:?"[ Yで スキップ ]";
  WHILE _Y<88
   GET_INPUT
   IF BTN_NEW== 16 THEN _Y=87 ELSE INC _Y
   IF BTN_NEW==128 THEN BREAK
   SPOFS 1,176,_Y,8
  WEND
  IF BTN_NEW==128 THEN
   INC PLCARD[MYID+4],_COUNT:_COUNT=0
   SPHIDE 1:BREAK
  ENDIF
  LOCATE 16, 6:?""
  LOCATE 16, 7:?" YOU GOT A CARD "
  LOCATE 16, 8:?""
  LOCATE 16,22:?""
  LOCATE 16,23:?"                "
  LOCATE 16,24:?""
  VAR _CN=GET_CARDNAME$(_CARD,0)
  LOCATE 25-CEIL(LEN(_CN)/2),23:?_CN
  REPEAT
   GET_INPUT
   IF BTN_NEW==128 THEN INC PLCARD[MYID+4],_COUNT:_COUNT=0:BREAK
  UNTIL BTN_NEW==16
  SPHIDE 1
 WEND
 IF _COUNT OR PLCARD[MYID+4]>60 THEN
  LOCATE 11,13:?""
  LOCATE 11,14:?" やまふだ に カード が ありません。      "
  LOCATE 11,15:?" カード を ひけないので あなた の まけです。 "
  LOCATE 11,16:?""
  REPEAT:GET_INPUT:UNTIL BTN_NEW==16
 ENDIF
 CLS:IF _COUNT THEN INC PLCARD[MYID+4],_COUNT
END

DEF SET_SPRITE _SPR,_CARD
 VAR _ELM=_CARD>>5,_COL=0
 VAR _LEFT=_SPR*48,_RIGHT=_LEFT+47
 IF _ELM==1 THEN _COL=-65536
 IF _ELM==2 THEN _COL=-16744193
 IF _ELM==3 THEN _COL=-8372192
 IF _ELM==4 THEN _COL=-16711936
 IF _ELM==5 THEN _COL=-1
 IF _ELM==6 THEN _COL=-12566464
 IF _ELM==7 THEN _COL=-3355444
 GFILL _LEFT,0,_RIGHT,63,_COL
 IF !_ELM THEN RETURN
 GBOX  _LEFT,0,_RIGHT,63,-1:INC _LEFT,8
 VAR _SPL=(_CARD AND 31)*32
 VAR _SPT=(_SPL>511)*32+64,_SPB=_SPT+31
 _SPL=_SPL AND 511:_SPR=_SPL+31
 GCOPY _SPL,_SPT,_SPR,_SPB,_LEFT,16,1
END

DEF GET_CARDNAME$(_NUM,_ID)
 IF !_NUM   THEN RETURN "なし"
 VAR _ELM=_NUM>>5,_CH=_NUM AND 31,_C=""
 IF !_ELM   THEN RETURN "ふせい な カード    "
 IF _ELM>7  THEN RETURN "ふせい な カード    "
 IF _ELM==1 THEN _C="ほのお":GOTO @_CNJ
 IF _ELM==2 THEN _C="みず" :GOTO @_CNJ
 IF _ELM==3 THEN _C="だいち":GOTO @_CNJ
 IF _ELM==4 THEN _C="かぜ" :GOTO @_CNJ
 IF _ELM==5 THEN _C="ひかり":GOTO @_CNJ
 IF _ELM==6 THEN _C="やみ" :GOTO @_CNJ
 IF _ELM==7 THEN _C="きょむ":GOTO @_CNJ
 @_CNJ
 IF _ID THEN
  WHILE LEN(_C)<3:INC _C," ":WEND
 ENDIF
 INC _C," の "
 IF _CH== 0 THEN INC _C,"スライム"   :GOTO @_CNL
 IF _CH== 1 THEN INC _C,"ゴーレム"   :GOTO @_CNL
 IF _CH== 2 THEN INC _C,"ドラキュラ"  :GOTO @_CNL
 IF _CH== 3 THEN INC _C,"ガーゴイル"  :GOTO @_CNL
 IF _CH== 4 THEN INC _C,"カーズマスク" :GOTO @_CNL
 IF _CH== 5 THEN INC _C,"ゴースト"   :GOTO @_CNL
 IF _CH== 6 THEN INC _C,"エビルバード" :GOTO @_CNL
 IF _CH== 7 THEN INC _C,"サタン"    :GOTO @_CNL
 IF _CH== 8 THEN INC _C,"エンジェル"  :GOTO @_CNL
 IF _CH== 9 THEN INC _C,"デスナイト"  :GOTO @_CNL
 IF _CH==10 THEN INC _C,"プリズム"   :GOTO @_CNL
 IF _CH==11 THEN INC _C,"リフレクター" :GOTO @_CNL
 IF _CH==12 THEN INC _C,"マジックミラー":GOTO @_CNL
 IF _CH==13 THEN INC _C,"ヘルファイター":GOTO @_CNL
 IF _CH==14 THEN INC _C,"ウィザード"  :GOTO @_CNL
 IF _CH==15 THEN INC _C,"クラッシャー" :GOTO @_CNL
 IF _CH==16 THEN INC _C,"シャーマン"  :GOTO @_CNL
 IF _CH==17 THEN INC _C,"ロールイーター":GOTO @_CNL
 IF _CH==18 THEN INC _C,"ジャグラー"  :GOTO @_CNL
 IF _CH==19 THEN INC _C,"ネクロマンサー":GOTO @_CNL
 IF _CH==20 THEN INC _C,"サモナー"   :GOTO @_CNL
 RETURN "ふせい な カード    "
 @_CNL
 IF _ID THEN
  WHILE LEN(_C)<13:INC _C," ":WEND
 ENDIF
 RETURN _C
END

DEF GET_CHARNAME(_NUM)
 IF _NUM< 0 THEN RETURN "まさかの エラー"
 IF _NUM==0 THEN RETURN "ただの  ばけネコ"
 IF _NUM==1 THEN RETURN "ほのおの よくりゅう"
 IF _NUM==2 THEN RETURN "みずの  せいれい"
 IF _NUM==3 THEN RETURN "だいちの さむらい"
 IF _NUM==4 THEN RETURN "かぜの  にんじゃ"
 IF _NUM==5 THEN RETURN "ひかりの てんし"
 IF _NUM==6 THEN RETURN "やみの  まおう"
 IF _NUM==7 THEN RETURN "はかいの じゃしん"
 VAR _CN$="",_IDX=(_NUM-8)*70
 IF _IDX>=LEN(MYSET) THEN RETURN "まさかの エラー"
 WHILE LEN(_CN$)<10
  INC _CN$,CHR$(MYSET[_IDX]):INC _IDX
 WEND
 RETURN _CN$
END

DEF EDIT_CARD
 VAR _LOOP,_PRESS,_BACK,_SAVE
 SELECT=0:MODE=0:_SAVE=0
 FOR _LOOP=1 TO 5
  IF KEY_N[_LOOP]==16 THEN BTN_DEV=_LOOP:BREAK
 NEXT
 WHILE 1
  CLS:_PRESS=0
  LOCATE 18, 6:?"DECK EDIT MODE"
  LOCATE 16, 8:?"へんしゅう する デッキを せんたく"
  LOCATE 22,24:?"おわり"
  FOR _LOOP=0 TO 11
   LOCATE 22,_LOOP+12
   ?GET_CHARNAME(_LOOP+8)
  NEXT
  WHILE !_PRESS
   GET_INPUT:_PRESS=SELECT(13,20,12,"",1)
  WEND
  IF _PRESS<0 OR SELECT>11 THEN BREAK
  _BACK=SELECT:_PRESS=EDIT_DECK(SELECT)
  SELECT=_BACK:IF _PRESS THEN _SAVE=1
 WEND
 BTN_DEV=-1:IF _SAVE THEN SAVEV SAVE_FILE$,MYSET
END

DEF EDIT_DECK(_DECK)
 DIM _LIST[256]
 VAR _PAGE=_DECK*70+10,_TOTAL=0,_MAX,_LOOP
 VAR _R=0,_CARD,_M,_BEEP,_POS
 WHILE _TOTAL<60
  INC _LIST[MYSET[_PAGE]]
  INC _PAGE:INC _TOTAL
 WEND
 _PAGE=32:SELECT=0:CLS
 LOCATE 17, 2:?"デッキ へんしゅう :   まい"
 LOCATE 15, 4:?"で カードの まいすうを へんこう"
 IF BTN_DEV==5 THEN
  LOCATE 5,14:?" A":LOCATE 42,14:?"D "
 ELSE
  LOCATE 5,14:?" ":LOCATE 42,14:?" "
 ENDIF
 WHILE 1
  GET_INPUT:_BEEP=-1
  REPEAT
   IF BTN_NEW==256 THEN DEC _POS,7:_BEEP=9
   IF BTN_NEW==512 THEN INC _POS,7:_BEEP=9
   IF _POS< 0 THEN DEC _PAGE,32:_POS=14
   IF _POS>14 THEN INC _PAGE,32:_POS= 0
   _PAGE=_PAGE AND 224
  UNTIL _PAGE>31
  IF _BEEP>=0 THEN BEEP _BEEP
  _MAX=1:IF _PAGE<224 THEN _MAX=2
  IF _PAGE<160 THEN _MAX=8
  _LOOP=_PAGE+_POS+SELECT
  IF BTN_NEW==4 THEN
   _R=_LIST[_LOOP]>0
   DEC _LIST[_LOOP],_R:DEC _TOTAL,_R
  ENDIF
  IF BTN_NEW==8 THEN
   _R=_LIST[_LOOP]<_MAX
   INC _LIST[_LOOP],_R:INC _TOTAL,_R
  ENDIF
  FONT_COLOR (_TOTAL==60)*12+3:LOCATE 28,2
  ?FORMAT$("%3D",_TOTAL):FONT_COLOR 15
  _CARD=_PAGE+_POS
  FOR _LOOP=0 TO 6
   LOCATE 17,_LOOP*2+8
   ?GET_CARDNAME$(_CARD,1)
   LOCATE 32,_LOOP*2+8
   ?_LIST[_CARD];"まい":INC _CARD
  NEXT
  _R=SELECT(7,15,8,"",2)
  _CARD=_POS+SELECT
  RESTORE "@MANUAL_"+FORMAT$("%02D",_CARD)
  READ _M:LOCATE 6,24:?_M
  READ _M:LOCATE 6,25:?_M
  RESTORE "@MANUAL_E"+HEX$(_PAGE>>5)
  READ _M:LOCATE 6,27:?_M
  READ _M:LOCATE 6,28:?_M
  IF _R*_TOTAL==60 THEN
   VAR _DN$=""
   REPEAT
    CLS:WAIT_INPUT
    IF LEN(_DN$) THEN LOCATE 22,16:?"ながすぎます"
    _DN$="":LOCATE 7,14
    LINPUT "デッキめい を にゅうりょく (10もじ いない)";_DN$
   UNTIL LEN(_DN$)<11
   _PAGE=_DECK*70:_LOOP=16
   IF LEN(_DN$) THEN
    WHILE LEN(_DN$)<10:INC _DN$," ":WEND
    WHILE LEN(_DN$)
     MYSET[_PAGE]=ASC(SHIFT(_DN$)):INC _PAGE
    WEND
   ELSE
    INC _PAGE,10
   ENDIF
   WHILE _TOTAL
    WHILE _LIST[_LOOP]
     MYSET[_PAGE]=_LOOP:INC _PAGE
     DEC _LIST[_LOOP]:DEC _TOTAL
    WEND
    INC _LOOP
   WEND
   GET_INPUT:BREAK
  ENDIF
  IF _R<0 THEN
   LOCATE 13,13:?""
   LOCATE 13,14:?" ほぞん せずに しゅうりょう しますか? "
   LOCATE 13,15:?"                      "
   LOCATE 13,16:?""
   _R=0
   REPEAT
    GET_INPUT:LOCATE 15,15
    IF BTN_NEW==4 THEN _R=-1
    IF BTN_NEW==8 THEN _R= 0
    IF _R THEN ?"    [ はい ]   いいえ    " ELSE ?"      はい   [ いいえ ]  "
   UNTIL BTN_NEW==16
   IF _R THEN BREAK
   FOR _LOOP=13 TO 16
    LOCATE 13,_LOOP:?" "*24
   NEXT
  ENDIF
 WEND
 RETURN _R>0
END

DEF CHECK_SAVEDATA()
 IF LEN(MYSET) MOD 70 THEN RETURN 0
 VAR _IDX=0,_RSD=LEN(MYSET)
 DIM _CCL[0]
 WHILE _IDX<_RSD
  INC _IDX,10:_CCL=NEW(256):VAR _LOOP=60
  WHILE _LOOP*_RSD
   VAR _MYC=MYSET[_IDX]:INC _IDX:DEC _LOOP
   IF _MYC< 32 THEN _RSD=0
   IF _MYC>255 THEN _RSD=0
   IF _RSD THEN
    INC _CCL[_MYC]:VAR _MAX=1
    IF _MYC<224   THEN _MAX=2
    IF _MYC<160   THEN _MAX=8
    IF (_MYC AND 31)>20 THEN _MAX=0
    IF _CCL[_MYC]>_MAX  THEN _RSD=0
   ENDIF
  WEND
 WEND
 RETURN _RSD
END

DEF NULL():DIM _NULL[0]:RETURN _NULL:END
DEF NEW(_NUM):DIM _NEW[_NUM]:RETURN _NEW:END

DEF INIT
 IF CHKFILE(SAVE_FILE$) THEN
  LOADV SAVE_FILE$,MYSET
  IF !CHECK_SAVEDATA() THEN MYSET=NULL()
 ENDIF
 VAR _LOOP,_STR=""
 WHILE LEN(MYSET)<840
  _STR="マイセット "+STR$(LEN(MYSET)/70+1)
  INC _STR," "*(10-LEN(_STR))
  WHILE LEN(_STR)
   PUSH MYSET,ASC(SHIFT(_STR))
  WEND
  COPY MYSET,LEN(MYSET),"@CARD_SET0",60
 WEND
 FOR _LOOP=1 TO 4
  PUSH PLSET,-1
  COPY PLSET,LEN(PLSET),"@CARD_SET0",60
 NEXT
 GTARGET 3:SPPAGE 3
 SPSET 0,0,0,48,64,0:SPSET 1,48,0,48,64,0
 FOR _LOOP=0 TO 20
  RESTORE "@IMG_"+FORMAT$("%02D",_LOOP)
  VAR _BIT,_SIZE,_INT,_SHIFT
  READ _STR,_BIT,_SIZE
  VAR _MASK=(1<<_BIT)-1
  DIM _PAL[0],_DAT[0]
  WHILE LEN(_STR)
   _INT=ASC(SHIFT(_STR))
   _SHIFT= (_INT AND     1)*-16777216
   _SHIFT=((_INT AND 63488)<<8) OR _SHIFT
   _SHIFT=((_INT AND  1984)<<5) OR _SHIFT
   _SHIFT=((_INT AND    62)<<2) OR _SHIFT
   PUSH _PAL,_SHIFT
  WEND
  WHILE _SIZE
   READ _STR
   WHILE LEN(_STR)
    _INT=ASC(SHIFT(_STR)):_SHIFT=0
    WHILE _SHIFT<16
     PUSH _DAT,(_INT>>_SHIFT) AND _MASK
     INC _SHIFT,_BIT:DEC _SIZE,_SIZE>0
    WEND
   WEND
  WEND
  _INT=_LOOP*32:_SHIFT=(_INT>511)*32+64
  GLOAD _INT AND 511,_SHIFT,32,32,_DAT,_PAL,1
 NEXT
END

DEF CSRY()
 VAR _X,_Y:LOCATE OUT _X,_Y
 RETURN _Y
END

DEF MANUAL
 VAR _DS="『でびるうにょ〜・ねお』は順番にカードを出し、一番早く全ての手札を"
 INC _DS,"使い切った人が勝ちとなる、4人対戦のカードゲームです。"
 INC _DS,CHR$(10)
 INC _DS,"出せるカードが手札に無い場合や、敵から攻撃を受けた場合、"
 INC _DS,"自分の山札からカードを引いて手札に加えます。"+CHR$(10)
 INC _DS,"山札からカードを引く事ができない場合、そのプレイヤーは失格となり"
 INC _DS,"ます。"+CHR$(10)+CHR$(10)
 INC _DS,"各カードの効果は"+CHR$(10)
 INC _DS,"ゲーム中の説明文をご覧ください。"
 DIALOG _DS,0,"ルール説明"
END

DEF BLANK _TIMER
WHILE _TIMER
 DEC _TIMER,_TIMER>0
 IF !_TIMER THEN INC _TIMER,BUTTON(0)>0
 VSYNC 1
WEND
END

DEF FONT_COLOR _CNUM
 CASE _CNUM
  WHEN    0: COLOR 0
  WHEN    1: COLOR -16777216
  WHEN    2: COLOR -8388608
  WHEN    3: COLOR -65536
  WHEN    4: COLOR -16744448
  WHEN    5: COLOR -16711936
  WHEN    6: COLOR -8355840
  WHEN    7: COLOR -256
  WHEN    8: COLOR -16777088
  WHEN    9: COLOR -16776961
  WHEN   10: COLOR -8388480
  WHEN   11: COLOR -65281
  WHEN   12: COLOR -16744320
  WHEN   13: COLOR -16711681
  WHEN   14: COLOR -8355712
  OTHERWISE: COLOR -1
 ENDCASE
END

DEF SELECT_CONTROLLER
 VAR _S,_T
 XCTRLSTYLE OUT _S,_T:_S=_T>1
 CLS
 LOCATE 18, 4:?"使用する コントローラを 選択"
 LOCATE  8,10:?"本体 (携帯モード)"
 LOCATE  8,12:?"JoyConグリップ"
 LOCATE  8,14:?"Pro コントローラ"
 LOCATE 32,12:?"Joy-Con横持ち"
 LOCATE 10,18:?"1〜2人(※)"
 LOCATE 35,18:?"1〜4人"
 FONT_COLOR 7
 LOCATE 12,24:?"※USBキーボードを接続する事で3人プレイが可能です"
 REPEAT
  GET_INPUT
  IF KEY_N[0]==4 THEN _S=0
  IF KEY_N[0]==8 THEN _S=1
  FOR _T=0 TO 1
   FONT_COLOR 13*(_S==_T)
   LOCATE 24*_T+6, 8:?"            "
   LOCATE 24*_T+6,20:?"            "
  NEXT
 UNTIL KEY_N[0]==16
 MODE=0:IF !_S THEN XCTRLSTYLE 2,0 ELSE XCTRLSTYLE 4,2
END

@CARD_SET0
DATA  32, 32, 32, 32, 33, 33, 33, 33, 34, 34
DATA  64, 64, 64, 64, 65, 65, 65, 65, 66, 66
DATA  96, 96, 96, 96, 97, 97, 97, 97, 98, 98
DATA 128,128,128,128,129,129,129,129,130,130
DATA  35, 35, 67, 67, 99, 99,131,131,168,199
DATA  36, 68,100,132, 37, 69,101,133,235,236

@CARD_SET1
DATA  32, 32, 32, 32, 64, 64, 96, 96,128,128
DATA  33, 33, 33, 33, 65, 65, 97, 97,129,129
DATA  34, 34, 34, 34, 35, 35, 35, 35,194,163
DATA  39, 39, 40, 40, 38, 38, 38, 38,199,168
DATA  43, 43, 43, 43, 44, 44, 44, 44,201,170
DATA  36, 68,100,132, 37, 69,101,133, 48, 49

@CARD_SET2
DATA  32, 32, 96, 96,128,128,160,160,192,192
DATA  64, 64, 64, 64, 64, 64, 64, 64, 72, 72
DATA  33, 65, 97,129, 66, 67, 66, 67, 66, 67
DATA  74, 73,170,201, 76, 75, 76, 75,172,203
DATA  78, 77,174,205, 68, 69, 68, 69,196,197
DATA  38, 38, 70, 70,102,102,134,134, 82, 82

@CARD_SET3
DATA  32, 64, 96,128,160,192, 33, 65,129,225
DATA  97, 97, 97, 97, 97, 97, 97, 97,161,193
DATA  34, 66, 98,130, 99, 35, 99, 67, 99,131
DATA 170,171,172,206,105,109,105,109,105,109
DATA 100,100,196,196,101,101,101,101,197,197
DATA  38, 38, 70, 70,102,102,134,134,112,115

@CARD_SET4
DATA  32, 33, 64, 65, 96, 97,128,129,192,193
DATA 130,131,130,131,194,195,142,141,142,141
DATA 206,205,140,139,140,139,204,203,138,137
DATA 138,137,202,201, 36, 68,100,132,209,211
DATA  38, 38, 70, 70,102,102,134,134,198,198
DATA  37, 37, 69, 69,101,101,133,133,145,146

@CARD_SET5
DATA  32, 32, 64, 64, 96, 96,128,128,160,160
DATA  33, 33, 65, 65, 97, 97,129,129,161,161
DATA  34, 35, 66, 67, 98, 99,130,131,162,163
DATA 163,163,164,164,165,165,166,166,168,168
DATA 169,169,170,170,171,171,172,172,173,173
DATA 174,174, 47, 79,111,143,175,239,176,176

@CARD_SET6
DATA  32, 32, 64, 64, 96, 96,128,128,192,192
DATA  33, 33, 65, 65, 97, 97,129,129,193,193
DATA  34, 35, 66, 67, 98, 99,130,131,194,195
DATA 196,196,197,197,198,198,199,199,200,200
DATA 201,201,202,202,203,203,204,204,205,205
DATA 206,206, 47, 79,111,143,207,239,208,208

@CARD_SET7
DATA  34, 35, 66, 67, 98, 99,130,131,162,163
DATA  34, 35, 66, 67, 98, 99,130,131,194,195
DATA  41, 42, 73, 74,105,106,137,138,233,234
DATA  43, 44, 75, 76,107,108,139,140,235,236
DATA  45, 46, 77, 78,109,110,141,142,237,238
DATA 224,225,226,227,228,229,230,239,232,231

@MANUAL_00
DATA "ゲルじょうの からだを もつ まほう せいぶつ。             "
DATA "まほう こうげきを かんぜんに むこうか する。             "

@MANUAL_01
DATA "てっぺきの にくたいを もつ まどう にんぎょう。            "
DATA "ぶつり こうげきを かんぜんに むこうか する。             "

@MANUAL_02
DATA "えものの けつえきを すいつくし しに いたらしめる まもの。      "
DATA "2ダメージの まほう こうげきを おこなう。               "

@MANUAL_03
DATA "ものかげや じょうくう から とつぜん おそいくる どうもうな まもの。 "
DATA "2ダメージの ぶつり こうげきを おこなう。               "

@MANUAL_04
DATA "いにしえの のろいを まとった あやしげな どうぐ。           "
DATA "ターン しんこうの じゅんばんを くるわせる。              "

@MANUAL_05
DATA "げんせに つよい うらみを もった あくりょう。             "
DATA "つぎの プレイヤーを こうどう ふのうに して じゅんばんを スキップ。 "

@MANUAL_06
DATA "ちからは つよいが おつむは よわく よく パシリに つかわれる まもの。"
DATA "カードを もう1まい えらんで だせる。                 "

@MANUAL_07
DATA "まかいに てんざい する いずれかの くにを おさめる まおう。     "
DATA "4ダメージの ぼうぎょできない ぶつり こうげきで じぶんも 1ダメージ。"

@MANUAL_08
DATA "あしき まものを ほろぼすため てんかいより せめいった だいてんし。  "
DATA "4ダメージの ぼうぎょできない まほう こうげきで じぶんも 1ダメージ。"

@MANUAL_09
DATA "ちかづくもの すべてに しを あたえると いわれる あくまの よろいきし。"
DATA "うけた ぶつりダメージの 1.5ばいの いりょくで はんげきを おこなう。"

@MANUAL_10
DATA "まりょくを たかめる まどう そうち。                  "
DATA "うけた まほうダメージの 1.5ばいの いりょくで はんげきを おこなう。"

@MANUAL_11
DATA "あらゆる ぶったいを はねかえす まどう そうち。            "
DATA "ぶつり こうげきを はんしゃするが つぎの ターンは うごけない。    "

@MANUAL_12
DATA "まりょくを はんしゃする まほうの かがみ。               "
DATA "まほう こうげきを はんしゃするが つぎの ターンは うごけない。    "

@MANUAL_13
DATA "ふくつの とうしで けっして たおれない じごくの かくとうか。     "
DATA "うけた ダメージの 2ばいの いりょくの ぶつり こうげきを おこなう。 "

@MANUAL_14
DATA "リスクを おう ほどに きょうりょくな まほうを はなつ ドM まどうし。"
DATA "うけた ダメージの 2ばいの いりょくの まほう こうげきを おこなう。 "

@MANUAL_15
DATA "こうはんいを なぎはらう きんだんの こだい ぶつり まほう。      "
DATA "てき ぜんいんに 2ダメージの ぶつり まほう こうげきを おこなう。  "

@MANUAL_16
DATA "ししゃの たましいを あやつる あくの まどうし。            "
DATA "しようずみカードを 4まい えらんで やまふだへもどし シャッフルする。 "

@MANUAL_17
DATA "まりょくの こめられた まどうしょを このんで くらう まじゅう。    "
DATA "じぶんの てふだを すべて すてて やまふだから 5まい カードを ひく。"

@MANUAL_18
DATA "てさきの きような だいどうげいにん。 スリの うでは ピカイチ。    "
DATA "ぜんいん てふだを すべて やまふだへもどし シャッフルして ひきなおす。"

@MANUAL_19
DATA "ししゃを あやつり しえきする げどうの まどうし。           "
DATA "しようずみカードを すべて やまふだへもどし そのはんぶん カードをひく。"

@MANUAL_20
DATA "いけにえを ささげることで いかなる まものをも しょかんする まどうし。"
DATA "てふだを 1まい えらんで しようずみカード 1まいと こうかん する。 "

@MANUAL_E1
DATA "ほのお、ひかり、やみ、きょむ の カード または             "
DATA "おなじ しゅるいの カードが ばに でている ときに だすことが できる。"

@MANUAL_E2
DATA "みず、ひかり、やみ、きょむ の カード または              "
DATA "おなじ しゅるいの カードが ばに でている ときに だすことが できる。"

@MANUAL_E3
DATA "だいち、ひかり、やみ、きょむ の カード または             "
DATA "おなじ しゅるいの カードが ばに でている ときに だすことが できる。"

@MANUAL_E4
DATA "かぜ、ひかり、やみ、きょむ の カード または              "
DATA "おなじ しゅるいの カードが ばに でている ときに だすことが できる。"

@MANUAL_E5
DATA "ほのお、みず、だいち、かぜ、ひかり、きょむ の カード または      "
DATA "おなじ しゅるいの カードが ばに でている ときに だすことが できる。"

@MANUAL_E6
DATA "ほのお、みず、だいち、かぜ、やみ、きょむ の カード または       "
DATA "おなじ しゅるいの カードが ばに でている ときに だすことが できる。"

@MANUAL_E7
DATA "げんざい ばに でている カードに かんけいなく             "
DATA "いつでも だすことが できる。                      "

@MANUAL_P0
DATA "やまふだ から カードを ひいて ターンを しゅうりょう します。    "
DATA "よろしい ですか?             [ はい ]   いいえ   "

@MANUAL_P1
DATA "やまふだ から カードを ひいて ターンを しゅうりょう します。    "
DATA "よろしい ですか?               はい   [ いいえ ] "

@MANUAL_P2
DATA "2まいめの カードを ださずに ターンを しゅうりょう します。     "
DATA "よろしい ですか?             [ はい ]   いいえ   "

@MANUAL_P3
DATA "2まいめの カードを ださずに ターンを しゅうりょう します。     "
DATA "よろしい ですか?               はい   [ いいえ ] "

@LOGO
DATA "              "
DATA "               "
DATA "                "
DATA "                 "

@IMG_00
DATA "むп㳿ꚿ痿Ⓙι̳",4,1024
DATA "                                "
DATA "   ကđ      ℐሢ    က∡∢ᄢ    ℀␳∢∢ "
DATA "  䈐⑄∢∢   䈡∤∢∢Ģ  က≂∢∢∢ሢ  က∢∢∢∢ሢ "
DATA " ℀╒∢∢∢∢ ℀╒∢唢∢∢ ℀╕∢唢∥∢ ∐≕⑄唢≕∢"
DATA " ∐䈑䑄刢⅕∢ ∐∢䐢∤ℑ∢ ∐∢䈢∤∢䐢 ᄀᄢ∡∢∢䐢"
DATA "  ᄑ∑∢∢䌢  ᄐℑ∢∢䍂  愐᝷∑∢␲ ᄀ睡癧ℑ∢⑂"
DATA " ∐癡晦ᅷ∢⑄ ∐愒ᄖᝦ∢ቄ  ℀ሢ∡ᙡ⑂ሢ  က∢∢ℒ⑂Ģ "
DATA "  ∑ᄒ∢∢   ᄀ∡ᄒ      ᄐ          "

@IMG_01
DATA "む䁁礁醁拁钁뇁칁￁",4,1024
DATA "           ᄐđ     ᄀ㌡ሳ    ㈐㌳㌳ģ  "
DATA "  ㌡㌳㌳ሳ   က䌲晅呦⌴  က瘳晸蝦㍧  က晣晦晦㙦 "
DATA " ℀晦晦晦晦  ㄀晦㍦昳晦  ㄀晦㌶挳晦  ℀晦晦晦晦 "
DATA " က晣㙦晣㙦  က挲㍦昳⌶   ㌡㌳㌳ሳ    ㄐ㌳㌳ē  "
DATA " က∡㌳㌳ሢ  ㄐ㌳㌳㌳㌳ē  ㌱㌳㌳㌳㌳ጳ က㈣晦ℓㄒ晦㈣"
DATA "㄀挒晦ሶ挡晦ℶ⌐昱晦፦昲晦፦Ĳጱ晣晦፦昲晦㙦ጱሱ晣晦፦昲晦㙦ጡ"
DATA "ㄳ晣晦ሶ挡晦㙦㌓ㅣ昳晦℣㈑晦㍦㘓Ⅶ㌳ᄒ∑ᄡℑ㌳昒፦ᄢ㌱∣㈡ጳ∑昱"
DATA "㍦㈑晣ሳ㌢㙦ᄣ昳⌶㌒晦ሶ挢晦ℳ挲∶㌒晦ሶ挡晦ℳ挢∳ㄢ晦ℓㄒ晦∓㌢"

@IMG_02
DATA "む℉䈑ㆍ劕挙ﺯﴛ︩Ｗ쀁ꀁ",4,1024
DATA " Ā      က         ᄀ    ᄲက⌑  "
DATA "  ㌠ᄔ䄑ȳ    攠㍦昳ɖ    刀䈣㈤%    刀❲❲%  "
DATA "   睷睷    馀睷睷࢙    頀睷睷    脐穹鞧Ę  "
DATA " က啑穹鞧ᕕ  儀㙥ꪓ㦪噣  攐䍦ꞔ䥺昴Ŗ  攐㍦礤䊗昳Ŗ "
DATA " ᄀ晥鉃㐩噦   儑뉦昬ᄕ    ጐ숑ᄭı    唱㉃㐣ፕ  "
DATA "  ᄱ㉃㐣ᕑ   က㌓㈑ᄣ㕓  က匓ᄵ匑啕  က匓晕晦啦 "
DATA " ㄀匓晥晦噦  ㄀儵晥晦噦  ㄀儵晥晦噦  ㄀ㄵ晥晦噦 "
DATA " ㄀ፕ晥晦噦  ㄀ፕ晓晦噦  က㕓攱晦啦  က啓匓晦㕖 "

@IMG_03
DATA "굫℉п̳鳧ㆍ뷯ɥ땁칁钁ιむ玝䈑豣적￁",8,1024
DATA "ฎฎฎฎؔดฎฎฎᐎؔดฎฎฎฎฎฎฎฎؔดฎฎᐎؔ؆ดᐎฎฎฎ"
DATA "ฑฎฎฎؔᐆฎᐎؔ؆؆ดᐎดฎฎᄇฎฎฎؔ؆ᐔؔတؐᐆฎᐎᐆฎฎ"
DATA "܇ฑฎฎؔဆတတတတᐆฎᐎᐐฎฎ܇ᄇฎฎؔတတတတတᐆฎနؐดฎ"
DATA "܀܇ฑฎؔတတတတတดฎနတดฎ ԑᄅฎؔတတሌတؐดฎနဆดฎ"
DATA "ᄀᄀԎฅؔတఐဒတᐆฎᐎؐؔดฎༀฑฎؔတတတؐดฎᐎᐐؔᐆฎ"
DATA "ฏᄎᄀฎᐎဆတတᐆࠃฎᐎᐆᐁᐆฎฏᐎฑᐎဆတؐ̔഍จနᐔᐁᐆฎ"
DATA "ฎᐎᄔᄀᐎ؆တᐆഈȂࠍؔĔᐆᐆฎฎᐎᐆᐑ؆ᐆดഈȂᐂᐆؔᐔดฎ"
DATA "ฎؔؐᄔᄀᐔดࠎഃᐂȂഔ؈ดดฎฎနတᐆᄑฎࠎᐃؔȂȂࠍฎดฎ"
DATA "ᐎဆတတᐆᐔࠈᐔؔᐆȂȂംจฎฎᐎတတတတ؆ᐔؔᐆ̔ȔȂȂࠍฎฎ"
DATA "ᐎတတတတတ؆ᐆ̔ഃᐁȂȂംࠈฎؔတတတတတؐ̔ȍĂᐆȂȂȂ഍ࠈ"
DATA "နတတတတတᐐ̈ȍĂဆȔȂȂȂ഍နတတတတတᐆࠎȃ؁တȔȂȂȂഔ"
DATA "နတတ؆တတดࠎ̃؁ᐐᐐȂȂȂᐐؔတؐᐆؔတਔࠎăᐆᐐᐔȂȂ̂ဆ"
DATA "ᐎတؐดᐉဆДชĈĔᐐᐃȂȂࠈ؃ᐎဆᐐ଎਋ؔᐆ਄ᐈăᐐഈȂȂ഍Ĉ"
DATA "ฎနᐐฎ଎ᐉᐆਓࠎĈᐆȍȂȂȂᐍฎؔᐐฎฎऎᐔГชĈᐆȍȂȂȂန"
DATA "ฎᐎ؆ดฎฎᐉጔࠊ഍ခȔȂȂȂؔฎฎᐔดฎฎ਋ጔࠄ഍؁ഔȂȂᐂĆ"
DATA "ฎฎฎᐔฎฎऎጓࠓ഍čᐆ഍ᐍؔࠁฎฎฎฎฎฎ଎ጓГഈ഍؁ᐔؔĆจ"

@IMG_04
DATA "￿玝ᣇ鳧㧏ㆍ굫䩓挙萡む젳뷯",4,1024
DATA "ⷝ뒂䈭"
DATA "䡲⛝衂ｲꭈ⛝萢翸磿ꪫ睦￸矿翿睷ｷ￿睷"
DATA "睲翿睷￿睿睷睼￷翿睷蝷뭼ｷ矿뮷轻஌ｿ띿迻"
DATA "எｿ୿ 鿻୞笀￿· 馛륜笀￿·뀀覙뗍뀀翷鬀辙"
DATA "飍뀋翷馻迹뮹翷뮻蓮迿翿翷￷￿翿翿￿￷￿⟿"
DATA "矿￿ｿ￿❿狝ｿ矿翿❷燝ｷｿ翿睷퉷췝￷￿睿튇"
DATA "ᷝ鿸靹ﾙ￿퉈秼香饷￿瞁睾轷睿翿㝷"
DATA "苝￿⍸ᷝ裿퉤㌡♈⋝"

@IMG_05
DATA "む적送뷯칳￿",4,1024
DATA "    ᄑđ     ᄀᄑᄑ    ᄐᄑᄑ    ᄑᄑᄑ "
DATA "   ᄑᄑᄑđ   ကᄑᄑᄲđ   ကᄑᄑፃᄑ   ကℑᄓᄡᄑ "
DATA "  ကㄑᄴᄑᄑ    ᄑᄒᄑᄑ   ᄑᄑᄑᄑ   ᄐᄑᄑᄑ"
DATA "  唀ᄕᄑᄑᄑ  晕睷ᅧᄑᄑ 倀癦碈杷ᄑᄑ 攀蝦袈睸ᄖᄑ"
DATA " 甀蝨袈碈ᅧᄑ 虐表袈袈ᙷᄑ 蝐表袈袈᝸ᄑ 蝐衸袈袈枈ᄑ"
DATA " 补衸袈袈瞈ᄑ 衵螈衸袈瞈ᄑ 衵瞈袇袈瞈ᄑ 衵螈袈袈枈ᄑ"
DATA " 补碈ᢈ蠑垈ᄑ 衐袈ᢈ脑ᚈᄑ  虐ᄘᢈ脑ᕸᄑ  蔀ᄘᢈ脑ᅨᄑ "
DATA " 攀ᄘ袁蠑ᅗᄑ  倀ᆆ袁袈ᄖđ   补袈梈ᄕđ   蕐衘墅ᄑđ "

@IMG_06
DATA "む!ȿ1?老萁￁",4,1024
DATA "                          က ᄀ "
DATA "  ℐ ㄀ē   ∡Ĳᄀကጣ  က∢ĳᐑ ㈡ ㄀㈢ဓᑄ ∱"
DATA " ℀㌢䄳䑄∑ ⌐ጲ䐓敄∑Ĳ ∐ᄲ䔓䙔န∔Ģ ∱ဓ琓䑄ᅄ∔Ģ"
DATA " ∡蜑䑷䅄∡Ģက∣蜐䞈䐔∡Ģက∢衰䑸ᑄ∤Ĳ㄀∢硰䑇䅄∢"
DATA "㄀∢᝷䑁䐑∢㄀ሢ ဇᅄፄ∢ᄀሲ က䐔䄴䈢ᄀሓ瀀䄀ᅄ␓䑂"
DATA "ᄀጓ 䄇䝄≁㐓ကጓ 䅰ᑄ㈤ፁ  ጑ 䅰ᑄጢĴ  Ā ᝰ䑄䄑 "
DATA "   pᄑㅷ    w ဇ      瀀          "
DATA "                                "

@IMG_07
DATA "む℉䈑ρցȁ܁적",4,1024
DATA " ᄑ    ᄑ ᄀ    ℀∐    ကĢጡ䐀    Dሱ"
DATA "ሲ䀀D  䐀⌡ĳ 摔  䕆 ㌐ĳ 䕀䑦晄є ㌐ģ 吀啄䑕E ㈐"
DATA "ሣ 䘀啔䕕d ㈡ሢ 䐑睕啷ᅄ ∡ℒခ呂睵坷⑅ခℒሢℑ啂睕啷⑕ᄒ∡"
DATA "⌢∡ᕂ啑ᕕ⑑ሢ∲⌲㌒ᕂ喈衕⑑ℳ⌲⌲㈒啃ᢈ袁㑕℣⌲⌳Ⅶ啃啕啕㑕昒㌲"
DATA "昳⅄吳啕啕㍅䐒㍦䑣㈑吳啕啕㍅ᄣ㙄ᑆ㌡䈳呕啅㌤ሳ摁啔㈕ሳ啔䕕㌡儣䕕"
DATA "睵ㅕ儳䑅呄㌕唓坷睷⅕儳啕啕㌕唒睷坷ᙕ産啗畕㉗啡睵啷ᙅ產啷睕≗呡睕"
DATA "啕Ⅴ嘢啕啕≥䘒啕䕕Ⅶ戢䕔䕔∦昒啔坵晄䈢䑦晄∤䑦坵睵䝷慦䙆摤昖睴坷"
DATA "睕坷䙅摦晆呤睵啷啔啷啅敕啖呕睕䕕呆啕畕敷睖啗啕摅䙢啕畄晗畦䑗啕♤"

@IMG_08
DATA "む칳뷯굫￿ιп̳Ｓﺫｹ",4,1024
DATA "  ကᄑᄑ    ℀呃㑅    က昡ቦ     ᄐđ   "
DATA "           眀w      衰ވ      螇硸   "
DATA "   祹鞗   退骗禩	 က 退ꪛ릪	 愀ᅦ  첫뫌  昑"
DATA "晦 쪰஬ ᄀ晦晦ᅦ ꪰப 昑晦晦晦꬀ºᄀ晦晦晦晦ᅦ뀁ဋ昑晦晦"
DATA "晦晦晦愖愖晦晦晦晦晦晦昑ᅦ晦晦晦晦晦ᄖ晦晦愑晦晦晦ᄖ晡晦晦ᙦ愑晦"
DATA "ᄑ晡晦曖浦晦ᙦᄑ晦晦晦昝텦晦晦晦晦晦晦昒Ⅶ晦晦晦晦晦홦昡ቦ晭晦晦"
DATA "晦晦ⵦ曑ᵦ曒晦晦晦晦ዖ曑ᵦ洡晦晦晦晦ᄭ晢♦툑晦晦晦홦ဒ晭홦℁晭晦"
DATA "晦ዖခ曝ခ洡晦홦Ē℀晦晦ℐ晭ዝ턀晦晦ကĒ 턀晦晦 ℐ"

@IMG_09
DATA "む䈏钟篛떥ႅㆍ",4,1024
DATA "ᄀ ℀Ā ကĐ⌑ᄲĐᄀ ᄱᄐ∓ㄢđ጑  ⌐⌑−™ᄲĲ "
DATA " ㄀∢∲⌢∢ ᄀခ∣⌢∲㈢ခကᄓ䐣∤䈢㉄đ ᄱ䈣䑄䑄㈤ထ "
DATA "ㄐ⌒䑄䑄Ⅎēက㄀ㄒ䐢≄ℓက℀ᔒ∱ጢ⅑ကℑ唒ㄕ儓⅕ᄒက"
DATA "ℐ儲ᕕ啑⌕Ē㄀㄀儢ᙕ啡∕℀Ĳᄐ愣ᙦ晡㈖đ⌐ጢ㌱愱ㄖ愓጖ጳ∱"
DATA "∣㈢ᄑ䄱ጒᄑ∣㈢ሡሡ∱䄲⌒ጢሡሡ∡ᄑ䐣䈒ℤ㉄ᄑሢ∱ጒ∡䐒⅄ሢℱጢ"
DATA "∐ㄓㄓ䈲⌤ㄓㄓĢ㌐ሱ∣⌤䈲㈢ጡĳᄡ∣䐡≄䐢ቄ㈢ሑℑ䑂䈲䑄䑄⌤⑄ᄒ"
DATA "∢䄒∤㌢∳䈢℔∢∱ጒ∤ᄲ⌑䈢ℱጢㄔ™ᄑ㌑ᄳᄑ−䄓ቄㄳℲ㌲⌳⌒㌓䐡"
DATA "≄጑≂∢∢␢ᄱ䐢㈤ሓ䑂∤䈢⑄ㄡ䈣㌤∓䐣ጤ䈱㉄ㄢ䈳㌢ℳ∢ㄒℓ∢㌒∳"

@IMG_10
DATA "む玝뷯鳧",2,1024
DATA "     耀  耀  ꀀ  ꀀ  ꠀ?  ꠀ?  ꨀÿ "
DATA " ꨀÿ  ꪀϿø ꪀϿ࿪ ꪠ࿾Ū ꪠ࿾X ꪨ㿾  ꪨ㿾 ฀ꪪ￾ "
DATA "ྀꪪ忾 㿠ꪼᗾ 㿸꿼ᕞ ᗾ￰՗ Օ￰՗ Ր￀ŗ Ā￀ŗ  ＀W "
DATA " ＀W  ﰀ  ﰀ      쀀  쀀     "

@IMG_11
DATA "む쬁ﶁ￿뷯",4,1024
DATA "     က        က    đ  đ ᄀ ᄡ "
DATA " ሐ  ሐ ℀℀Ē ሐ က㈀ᄤ ᄐ  ㈐ቄᄀ "
DATA "   ㌠⑄     ⌡䑃Ē     ⌲䐲ᄤ    က㈲䌤ቄ "
DATA "   ㈳㉄⑄   ℀㌣⑄䑃Ē   ㈀⌣䑃䐲ᄤ   ㈀⌲䐲䌤ቄ"
DATA "  刀╒㕒唣ሳ  刀┥㍕㕒ᄣ   ℀唥⌵㍕Ē    剕刳⌵ "
DATA "  က剒唣ሳ    ╒㕒ᄣ     ┡㍕Ē     唠⌵  "
DATA "  刐ሳᄀ  က刀ᄣ ᄐ ℀℀Ē ሐ ሐ  ሐ"
DATA " đ ᄀ ᄡ က    đ             က "

@IMG_12
DATA "む쬁ﶁ￁뿿￿",4,1024
DATA "   ᄑᄑ     ᄐ㈢∢đ   က∡㈢∢ሢ  ℀㌢㌢∣∲ "
DATA " ∐㈢㈲∲⌣Ģ  ∡∳㈲∲㈣ሢ က㈢⌢⌣⌣⌢∢℀㈢∢㈣⌢∲∳"
DATA "℀∲㈣呂㕅㈣⌢∐⌣䌲啄啔⌤⌢Ģ㈐㈢䐢䕔䕕⍄∲ģ∐∳䑃呕䑕㑄㈢ģ"
DATA "∡∢呃啅䑅╄∳ሢ∡㌢啄啕䑄啔㌢ሢ∡∳啔䕕䑄䕕∲ሣ㈡⌢啕䑔呄䑕㌣ጳ"
DATA "㌱㈳䕕呅啄呅∲ሣ㈡⌢呕䕄䕄啄㌢ሢ∡∳䕅䕔䑔䕔∳ሢ∡㌢呒䑕䑄㑕∢ሢ"
DATA "㈐∣啃䑅呄㑅㌢Ģ㈐⌢唲䑄啄≄∣ģ∐∲䈲䑄䕔⌴㈲Ģ℀∲㈣䑃⑕㈣⌢"
DATA "℀㌢⌢∲㈣∢∣က∢∲㈲㈲∲∣ ∡㈣⌢⌣㌢ሢ  ∐㈲⌢⌣∣Ģ "
DATA " ℀⌢㈢∳∳  က∡∢∣ሢ   ᄐ∢∣đ     ᄑᄑ   "

@IMG_13
DATA "쀁萁䈑Ｗ￿뷯℉ﴛ︩む￁ﺯ",8,1024
DATA "ฎฎฎฎฎฎЎฎฎคฎฎฎฎฎฎฎฎฎฎЎЎЎคЎคคคฎฎฎฎ"
DATA "ฎฎฎฎЎ༄̄Џ༄ЃЏคࠈࠈฎฎฎฎฎࠎЈ༃̃̏༃̃̏คࠎਊࠈฎ"
DATA "ฎฎࠎਈਊ༄̏༏༏༃Џฎࠎਊਅࠈฎฎਈਊਊ̄̏༃̏༃ЃฎฎਈԊԅ"
DATA "ฎࠎԊਅਊЊ܃܂́คฎฎਈԊԅฎਈԅਅԅ܊܇ȇĂāกฎฎԈਊԅ"
DATA "ࠎԊԅਊԅ܊ဇတတĐกฎฎԈਊԅਈԅਅԊଅ഍တတတတ഍ซࠎԊਅԊ"
DATA "ԊԅฎԎԅഋတတတတ଍ฎࠎԅਅԊԅฎฎฎԅଅဍဆؐഐซฎਈԅԅԊ"
DATA "ฎฎฎฎԎԅဍဆؐഐāࠎԊԅԅਊฎฎฎฎଋċ഍؆؆഍ćਁԅԅฎฎ"
DATA "ฎฎฎଋ഍܁उउउ഍܇āԅฎฎฎฎฎ଎഍တँĉāఁĉāഁซฎฎฎ"
DATA "ฎฎഋတ଍ఉāāāऌāဍ଍ฎฎฎฎ଎ဍ଍ऋČāāāఁĉတഐซฎฎ"
DATA "ฎഋ଍ഋऍČāāāఁഉؐဆ଍ฎฎฎഋഋတऐఌāఁఉऌഁؐ؆ଐฎฎ"
DATA "଎଍ဍ؆ഐఉఌఌउĉଁတ؆ഐซฎ଎഍ؐဆഐఉఌउāāଁဍ؆တซฎ"
DATA "଎ဍတഐ଍ऋउāँĉāഋတတซฎฎഋတ଍ซฎāउఉऌĉଁଋ഍ซฎ"
DATA "ฎ଎ଋซฎฎँČऌఌऌഋဍഐซฎฎฎฎฎฎఌఉāāāऌဍ؆ഐซฎ"
DATA "ฎฎฎฎଋ఍ఉāāāఁဉတଐฎฎฎฎฎ଎ဍഐఉČāāāഉഐ଍ฎฎ"
DATA "ฎฎฎഋؐဆऍఌāāāഉ଍ซฎ਎ฎฎ଎ဍ؆؆ഐఉఌāఁଉ਋ช਎ਊ"
DATA "ฎฎഋတ؆တ഍ऋఉఌऌఋฌਊਊฎฎฎഋဍတഐ଍഍ऍउഉāฌฎฎฎ"

@IMG_14
DATA "むꀁ쀁￿ﴛ︩ﺯＷﶁ￁",4,1024
DATA "  က∢∢    က∢∢    ℀∢∢    ℀∢∢  "
DATA "  ℀∢∢    ∐ᄒℑĢ   ကᄑ㈑ᄣᄑ  ᄀℑ䌢∳ᄒ "
DATA "  ᄐ㈡ሣđ    晐ᄗ焑զ    攀睷睷V    倀硶枇退ª"
DATA "   硶枇 ꤀ત   衡ᚈ ꤀પ  ᄀ蝢♸餀প က∑瘒Ⅷᄢ送"
DATA " ℀∢憱ᬖ∢递	 ሀᄑᮻ뮱ᄑ逡	 눀뮻뮻뮻릛餫  묠뮻뮻뮻릻馻 "
DATA " 묠뮻뮻뮻릛馻  묠뮻뮻뮻뮛ছ  묠⊻뮻뮻馛ঙ  뮲⮻뮲뮻馻⮹ "
DATA " 뮲뮻∢뮻馻⮲  뮲뮻⮻∢餢⮲  뮲뮻뮻⊻⦒⮻  뮲뮻뮻唫♩⮻ "
DATA " 뮲뮻뮻攫뙦⮻  뮻뮻뮻攫뉦뮻 뮻뮻뮻鈫눩뮻 뮻뮻뮻鈢눩뮻"

@IMG_15
DATA "むꀁ𧻓￁￿",4,1024
DATA "                                "
DATA "           ᄐđ     ᄐ∡ሢđ   က∡㌲⌳ሢ "
DATA " ℐ㈢䐳㍄∣Ē  ∡㌲啄䑕⌳ሢ က∢䌳啕啕㌴∢℀㈢吳啕啕㍅∣"
DATA "∐㈢䐳啕啕㍄∣Ģ∐∢䌳啄呕啕∥Ģℑ∢㌲䑃啄ᄑ≕ᄒᄑ∢㈢㌳ᕓ∢║ᄑ"
DATA "ᄐ∑∢∢⅒∢ᔒđᄀᄑ∑∢⅒∢ᔒ ᄑᄑᄑ⅑∢ᔒ  ကᄑᄑᕑ∢Ց "
DATA "  ကᄑᔑ∢Q     唀ᄑU     倀ሡ     啕ሡ啕 "
DATA "   唀ᄕᄑ儑U   ᕐ∡ᕑሢՑ   ⅐∢ᕑ∢Ԓ   ⅐∢ᕑ∢Ԓ"
DATA "   ⅐ሢ啕∡Ԓ   ᕐሢ倅∡Ց   唀儑倅ᄕU   倀啕 啕"

@IMG_16
DATA "ﺫցȁꀁ쀁Ｓ쬁ﶁ￁ｹ𧻓む￿뷯",8,1024
DATA "ฎฎฎฎฎฎฎฎฎฎฎฎซฎฎฎฎฎฎฎฎฎฎ؎ฆฎฎฎଋฎฎฎ"
DATA "ฎฎฎฎฎฎฎआฆฎฎฎଏฎฎฎฎฎฎฎฎฎ؎ࠉฆฎฎฎ༏ซฎฎ"
DATA "ฎฎฎฎฎฎࠆࠈฆฎฎ଎ଏฐฎฎฎฎฎฎฎ؎؈؆उฎฎฎଋฎฎฎ"
DATA "ฎฎฎฎฎࠆ؆؈഍ฃฎฎЎฎฎฎฎฎฎฎซਆࠈ؈ऍ̉ฎฎဎงฎฎ"
DATA "ฎฎฎฎ؋ࠊउ؈̉̉ฎฎဇงฎฎฎฎฎ଎؎ࠈईआԉःฃฎဇ܎ฎฎ"
DATA "ฎฎ฀؆उ؈ԅԅฃฎဇฎงฎฎฎ ࠆईԆఌఌฎฎ฀܎ฎ"
DATA "ฎฎซ؎ࠊ؈అԌ฀ฎԅ ฀܎ฎฎଋฎ؎ਊฆԅԅ฀ԅ ဇฎฎง"
DATA "ฎ଎ฎฎ؆ฎฎԀԅ ฎဎฐฎงฎฎฎฎ฀ Ԁฎฎ܎ฐฎง"
DATA "ฎฎฎฎฎఀ฀ฎฎ܎ฐฎงฎฎฎฎฎฎ ఌఌ฀ซซฎฐฎ܎"
DATA "ฎฎฎฎఌఌ ଋฎฎܐฎ܎ฎฎԅ฀ԎԀԀ ଎ฎฎฐง܎"
DATA "ฎฎԀԅ฀ฎఀԎଅฎฎฐฎ܎ฎฎฎ฀ฎฎԀฎ ฀ฎฐฎฎ"
DATA "ฎฎฎฎฎฎฎఀฎ฀ฎฐฎฎฎฎฎฎฎฎฎԀฎԎซฎฐฎฎ"
DATA "ฎฎฎฎฎฎฎĀฎฎซฎฐฎฎฎฎฎฎฎฎ Ăȁฎฎଋฎฐฎฎ"
DATA "ฎฎฎฎฎ ԅȅฎ଎଎ฎတฎฎฎฎฎฎ ԅฅȎԂ฀ฎฎฎဎฎฎ"
DATA "ฎฎฎฎԀฅฎȎข฀ฎฎฎဎฎฎฎฎฎฎฅฎฎฎԀฎฎฎဎฎฎ"
DATA "ฎฎฎฎฅฎฎฎฎฎฎฎฎฎฎฎฎฎฎԀฎฎฎฅฎฎฎฎฎ"

@IMG_17
DATA "むȁց܁ρ￿",4,1024
DATA "က㌢㌳㌳㌳∢ᅂ က㌢㌳㌳⌳∢䈢℀㈢㌳⌳∢┢∢ł℀∢∢∢∢∢∢ᐢ"
DATA "℀∥∢∢∢∢∢ሢ℀∢∢∢∢∢∢䈢␐∢ᄔ≁∢∢∢∢␐∢敡ᄖ≁∢∢⌲"
DATA "␐䈢敡晕䄕∢∢㌳␐ሢ啕噕ᙥ∤∢㌳␐ሢ啦啕啥≁∢㌲␐ሢ啖啕敕∖∢㌢"
DATA "䐐ᐢ啕啕啕␖∢∢䄀ᐢ啦啕啕⅕∢∢䄀ᑄ啖啕啕Ⅶ∢∢ကᑄ啕啕啕Ⅵ∢∢"
DATA "က䑄噡啕啕䅕∢∢ 䑁啡啕啕ᙥ∢∢ 䐐攔啕啕ᙕ∤∢ᄑ䄀慄啥啕ᕕ䑄≄"
DATA "䑄ထᑁ敥噕ᕥ䑄䑁䈢ń䄐攑晖䅥ᅄ⑄∢ᑂကᄑᄑᄑ䐑∤∢䐢 䄀䑄⑄∢"
DATA "∳䈢 䄀䑄∤∢㌳∢ń 䐐⑄∢∢㌳∢ᑂ䐐∤㌳∢∣∢䑂ᄔ⑁㈢㌳∢"
DATA "∢∢䑄ᑄ≄㈢∳∢∢䈢䑄䄔∤∢∢䈢∢䑂ᄔ䑁∤∢∢䑂∢䐢䑄䑄≄∢䈢䑄"

@IMG_18
DATA "￁ﺯ挙ㆍցむ쀁뿿℉劕܁Ｗ뷯￿߿䈑︩ﴛ",8,1024
DATA "ԅԅԅԏԅԅԅԅԅԅԅԅጅԅԅԅԅԅࠈ༅ԅԅԅԅԅԅԅԅԓԅሒԅ"
DATA "ԅࠅࠐԑ༏ԅԅԅԅԅԅጓԅህሐԇԅࠅࠈԑਏ༏ԏԅԅጅ഍औԅህሒԇ"
DATA "ԅԅᄑԅ༅ਊ༆༏ጓഓഐԄԅԅ܇ԅԅԅԅԅ༅ညတਊᐔം഍ᔕԅԅԅԅ"
DATA "ԅԅԅԅԅဏ༆؏ःᐉЄᔕԃԅԅԅԅԅԅԅԅਏď༁ĉँᘋ጖Ȃԃԅԅ"
DATA "ԅԅԅԅԓ༅āāĀԉ༅ጅȓԃԅԅԅԓԅᘅᔕሁāāఀᔕԖԅጅȂԃ"
DATA "ԅԅጅԓጅᔖሇĒāఀᘕԏ༅ԏጓ̃؅ԆԅጓጓᘓܕĎᔌ༖༏༏ጓ̃ԃ"
DATA "ਆ༆ԅ̓ଋଋĕĎกᔁਊਊ༆̃ԃԅؕ༆ԅଓȋᐂᔔฎฎਕညਐ༊ԃԅԅ"
DATA "༕ԏጅȃȂ̔ᔃกĎؕਆတؐԏԅԅᘖጅጓȋȂᐔःĕᔁ؏ਊတਐ༏ԏԅ"
DATA "ԏጓԅጓȋȂ̔ᔉ༕ਆတਐ༏ԅ༏ԅԆԅԅጏጓଃȂȂတတ؊༏ԏԅԅԅ"
DATA "؆ԅԅጓԅጓȃȂတؐ༏ԅ༏ԅԅԅਏԅ؅ԓԅጏጓጓ༏༏ጏԅ༅ԅԅԅ"
DATA "؅Ԇਅԏԅ؏ጓ؆̓༏ጃԅԅԅԅԅ༅Ԋ؆ԅԅ༅ؓਊ̓༃ጃԅԅԅԅԅ"
DATA "ԅ༆༊ԅԅ༅؆ਊጆȂԓԅԅԅԅԅԅ؏Ԇԅԅԅ؏ਊጆ̂༓༏ԏԅԅԅ"
DATA "ԅ؅ԏԅԅԅ༅ਆጆጃؓਊ༆ԏԅԅԅ༅ԅԅԅԅԅ؏ጆؓਆਊਊ༆ԏԅ"
DATA "ԅԅԅԅԅԅԅ؏̏ؓ༏༏ਆਊ༆ԅԅԅԅԅԅԅጅ༏̃༓ԅԅ༏༏༆ԅ"
DATA "ԅԅԅԅԅԅȓ̂ጓԓԅԅԅ؏ԏԅԅԅԅԅԅጅ̂ጓԅԓԅԅԅ؏ԏԅ"
DATA "ԅԅԅԅԅȓጃԅԅጅԅԓ༅༆ԅԅԅԅԅԅጅ̂ԓԅԅԅጓጓ༅༆ԅԅ"

@IMG_19
DATA "︩むＷ￿挙ﺯㆍﴛ뷯",4,1024
DATA "ᄑᄑ䄑睷睷ᄔᄑᄑᄑᄑ䄑睷睷ᄔᄑᄑᄑᄑ琑饷瞙ᅇᄑᄑᄑᄑ琑㎗礳ᅇᄑᄑ"
DATA "ᄑᄑ琑㌹錳ᅇᄑᄑᄑᄑ睁㐹鍃ᑷᄑᄑᄑ䄑睄㒙饃䑷ᄔᄑᄑ䐑瑄馚ꦙ䑇ᅄᄑ"
DATA "ᄑᄑ䑁禤䪗ᑄᄑᄑᄑᄑ䑆摄᠀ᄑᄑᄑᄑࠑ晦晦ᆀᄑᄑᄑᄑ脑扠ئᄘᄑᄑ"
DATA "ᄑᄑᄑ扠ئᄑᄑᄑᄑᄑᄑ∄䀢ᄑᄑᄑᄑᄑ䐑☇灢ᅄᄑᄑᄑ䄑睄恇理䑷ᄔᄑ"
DATA "ᄑ琑睷Ѵ䝀睷ᅇᄑᄑ䜑䑄睷睷䑄ᅴᄑᄑ眑霵垙饵卹ᅷᄑᄑ坱㩵㤴䎓垣᝵ᄑ"
DATA "ᄑ啱㩵礴䎗垣᝕ᄑᄑ啱饕垙饵喙᝕ᄑᄑ啱祕啹靕喗᝕ᄑᄑ啷畕啗睕啷睕ᄑ"
DATA "ᄑ啗啕啕畕啗畕ᄑᄑ啗啕啕畕啗畕ᄑᄑ啗啕啕啕啗畕ᄑᄑ啗畕啗啕啗畕ᄑ"
DATA "ᄑ啗畕啷啕啗畕ᄑ焑啗啕啷啕啗畕ᄗ焑啷啵坷啕啕畕ᄗ焑啷啷睷啕啕睕ᄗ"

@IMG_20
DATA "むȁρＳﺫցﴛｹ쀁",4,1024
DATA "           ကđ      ᄀᄑ     ℐᄒ  "
DATA "   ∐ᄢđ     ∡ᄢ     ∡ᄢ      ∡ᄒ   "
DATA " ကᄑᄑ က က㌑ᄳ ℀ᄢ က㌴䌳 ∑≕怀眴䍷ᄀ唢"
DATA "啕ᄢ 獆搷 ∑啕啕≕㍀гᄀ唢啕≕啕ᄢ㐑ᅃ∑啕唢∢唢≕䄢∔唢≕∢"
DATA "∢∢∢ሢ∡∢∢∢∢∢∢╒╒∢∢∢∢∢∢啑ᕕ∢∢∢∢∢∢啑ᕕ∢∢∢"
DATA "∢∢ሢ唡ቕ∡∢∢ሢ∢Ē唡ሥℐ∢∡Ģሡ刐Ģကሡ∐ĢĐ ∐Ģ Đ∐"
DATA " ∐ĥ  ℀ 刐ŕ ℀老 刡ቕࠀက耈 唡ቕࠀ耀"
DATA "耈ࠀࢀ唡ᕕࠀ耀肈ࠀ颀啑ᕕࢉ蠈肈蠈ᦉ啒╒频蠈肈题ᦙ啒┢馑覙蠈"

I<As_