       "KYoshiaki             C    
5KYoshiaki                         
            '
' YOS_CHESS.PRG
'
'  Original
'
' Vice 1.1 by BlueFeverSoft
' Programming A Chess Engine C, YouTube 
'
'  YKChess (YOS_CHESS.PRG)
'
' 2017/02/03/(Fri)
' Version 1.0 Programmed by KYoshiaki
'
'  Minesweeper (YOS_MINE)
'
' 2015/01/25(Wed)
' Version 1.0 Programmed by KYoshiaki
'
' Pubkic Key: E3AN3XZF
'
'  Development Tools and Enviroment
'   (KYoshiaki)
'
'   MacBook Pro (Retina, 15-inch, Late 2013) 
'
'   Parallels Desktop 12.1.3(41532) for Mac
'   Xboard 4.8.0
'   Arena Chess GUI 3.5.1
'   PetitModem Ver. 1.2.7
'   Adobe Reader Touch
'    Version 3.1 Build 87675
'
'   Pixelmator version 3.6 Cordillera(61103)
'   GIMP 2.8.18
'   Preview version 9.0(909.12)
'   Grab version 1.9(137)
'
'   Atom v1.13.1 x64
'   atom-language-smilebasic 1.2.0
'
'   Visual Studio Code Version 1.8.1(1.8.1)
'
'   CotEditor version 3.1.3(180)
'   SmileBASIC.yaml
'    - CotEditor's syntax style (KYoshiaki)
'
'   AnimalCrossingDesign 
'    version 1.0.1 (KYoshiaki)
'
'   GNU Chess 6.2,4
'   ag version 1.0.2
'   nkf version 2.1.4
'
'   iPad mini 2
'
'   GoodReader version 4.12.1
'   Adobe Acrobat Reader version 17.01.31
'
'   iPhone 7 Plus 128GB Black 
'
'   iYKIndexView version 1.0 (KYoshiaki)
'
'   SmileBASIC
'
'   PMODEM127.PRG
'   LZSSLIB102.PRG
'
'   RMG IME Ver 0.36
'
'   PUCHIPACK V1.91
'   PUCHI-SOUND VER 1.11
'
'   US-100
'
'   iBUFFALO USB Audio Adapter BSHSAU01BK
'
'   GS-MHA01-BK
'
'   ST35-SM35F
'
 
OPTION STRICT
OPTION DEFINT

'
' STKANDBTN
'
VAR BTBAK
VAR BTCNT

'
' SCENE
'
VAR SCENE_STATE

VAR G_SCENE_PLAY
VAR G_SCENE_NEW
VAR G_SCENE_RECORD
VAR G_SCENE_END
VAR G_SCENE_LOOP

'
' CONSTANT
'
VAR G_BOARD_NUM
VAR G_EMPTY,G_WP,G_WN,G_WB,G_WR,G_WQ,G_WK
VAR G_BP,G_BN,G_BB,G_BR,G_BQ,G_BK
VAR FILE_A,FILE_B,FILE_C,FILE_D
VAR FILE_E,FILE_F,FILE_G,FILE_H,FILE_NONE
VAR RANK_1,RANK_2,RANK_3,RANK_4
VAR RANK_5,RANK_6,RANK_7,RANK_8,RANK_NONE
VAR G_WHITE,G_BLACK,G_BOTH
VAR G_A1,G_A2,G_A3,G_A4,G_A5,G_A6,G_A7,G_A8
VAR G_B1,G_B2,G_B3,G_B4,G_B5,G_B6,G_B7,G_B8
VAR G_C1,G_C2,G_C3,G_C4,G_C5,G_C6,G_C7,G_C8
VAR G_D1,G_D2,G_D3,G_D4,G_D5,G_D6,G_D7,G_D8
VAR G_E1,G_E2,G_E3,G_E4,G_E5,G_E6,G_E7,G_E8
VAR G_F1,G_F2,G_F3,G_F4,G_F5,G_F6,G_F7,G_F8
VAR G_G1,G_G2,G_G3,G_G4,G_G5,G_G6,G_G7,G_G8
VAR G_H1,G_H2,G_H3,G_H4,G_H5,G_H6,G_H7,G_H8
VAR NO_SQ,OFFBOARD

VAR MFLAG_EP
VAR MFLAG_PS
VAR MFLAG_CA
VAR MFLAG_CAP
VAR MFLAG_PROM

VAR WK_CA
VAR WQ_CA
VAR BK_CA
VAR BQ_CA

VAR NO_MOVE

VAR G_GAME_CONTINUE
VAR G_GAME_WHITE_WIN
VAR G_GAME_BLACK_WIN
VAR G_GAME_MATERIAL_DRAW
VAR G_GAME_STALEMATE
VAR G_GAME_FIFTY_MOVE

VAR INFINITE

VAR G_USER
VAR G_ENGINE

VAR G_EVAL_MATERIAL
VAR G_EVAL_TABLE

VAR PAUSE_WAIT

VAR LC_EN
VAR LC_JA

VAR G_DIALOG_CAPTION
VAR G_DIALOG_TEXT
VAR G_DIALOG_OTHER

VAR G_DIALOG_RESULT
VAR G_DIALOG_GAME

'
' DATA
'
VAR PIECE_CHAR$
VAR SIDE_CHAR$
VAR RANK_CHAR$
VAR FILE_CHAR$

VAR START_FEN$
VAR TEST_FEN$[15]

VAR PIECE_BIG[13]
VAR PIECE_MAJ[13]
VAR PIECE_MIN[13]
VAR PIECE_VAL[13]
VAR PIECE_COL[13]

VAR PIECE_PAWN[13]
VAR PIECE_KNIGHT[13]
VAR PIECE_KING[13]
VAR PIECE_ROOK_QUEEN[13]
VAR PIECE_BISHOP_QUEEN[13]
VAR PIECE_SLIDES[13]

VAR MIRROR_64[64]
VAR FLIP_64[64]

'
' DATA MOVE
'
VAR LOOP_SLIDE_PIECE[8]
VAR LOOP_NONSLIDE_PIECE[6]

VAR LOOP_SLIDE[8]
VAR LOOP_NONSLIDE[6]
VAR LOOP_SLIDE_INDEX[2]
VAR LOOP_NONSLIDE_INDEX[2]

VAR PIECE_DIR[13,8]
VAR PIECE_NUM_DIR[13]

VAR VICTIM_SCORE[13]
VAR MVV_LVA_SCORES[13,13]

'
' DATA ATTACK
'
VAR KN_DIR[8]
VAR RK_DIR[4]
VAR BI_DIR[4]
VAR KI_DIR[8]

'
' DATA EVALUATE
'
VAR PAWN_TABLE[64]
VAR KNIGHT_TABLE[64]
VAR BISHOP_TABLE[64]
VAR ROOK_TABLE[64]
VAR KING_E[64]
VAR KING_O[64]

VAR END_GAME_MAT
VAR BISHOP_PAIR

VAR EVAL_MODE

'
' BOARD
'
VAR B_PIECE_SIDE[1]
VAR B_PIECES[120]
VAR B_PIECE_LIST[13,10]
VAR B_PIECE_NUM[13]
VAR B_ENPAS[1]
VAR B_CASTLE_PERM[1]
VAR B_FIFTY_MOVE[1]

VAR B_BIG_PIECE[2]
VAR B_MAJ_PIECE[2]
VAR B_MIN_PIECE[2]
VAR B_MATERIAL_PIECE[2]

VAR B_RECORD_MOVE[0]
VAR B_RECORD_CASTLE_PERM[0]
VAR B_RECORD_ENPAS[0]
VAR B_RECORD_FIFTY_MOVE[0]

VAR B_KING_SQ[2]

VAR B_LIST_MOVE[0]
VAR B_LIST_SCORE[0]

VAR SQ64TOSQ120[64]
VAR SQ120TOSQ64[120]
VAR FILES_BOARD[120]
VAR RANKS_BOARD[120]
VAR CASTLE_PERM[120]

'
' PLAYER
'
VAR PLAYER[2]
VAR PLAYER_LEVEL[2]
VAR PLAYER_EVAL[2]
VAR PLAYER_DEPTH[2]

VAR G_SIDE$[2]
VAR G_PLAYER$[2]
VAR G_PLAYER_LEVEL$
VAR G_PLAYER_EVAL$[2]
VAR G_PLAYER_DEPTH$

'
' SOUND
'
VAR BEEP_ON
VAR G_BEEP_ERR_NUM

'
' DIALOG
'
VAR G_GAME_RESULT$[6,2,2]
VAR G_BUTTON$[6,3,2]

'
' BG
'
VAR BG_PIECE_CHR[13]
VAR BG_BOARD_OXY[2]
VAR BG_BOARD_RECT[4]
VAR BG_BOARD_ENABLE
VAR BG_FLIP

VAR BG_TARGET120[2]
VAR BG_HIGHLIGHT120

VAR BG_ASSISTANT
VAR BG_MOVE_LIST[0]

'
' UI
'
VAR G_WINDOW_MAIN
VAR G_WINDOW_SUB
VAR G_WINDOW_PLY

VAR G_PLY_PLAY
VAR G_PLY_RECORD

VAR G_POPUP_TYPE
VAR G_POPUP_LEVEL

VAR G_BUTTON_NEW
VAR G_BUTTON_PLAY
VAR G_BUTTON_UNDO
VAR G_BUTTON_FLIP
VAR G_BUTTON_RESIGN
VAR G_BUTTON_QUIT

VAR G_MENU_LEVEL
VAR G_MENU_TYPE

VAR G_CONTROL_HEAD
VAR G_CONTROL_BACKWARD
VAR G_CONTROL_FORWARD
VAR G_CONTROL_TAIL

VAR G_RADIO_ASSISTANT

VAR WINDOW_RECT[2,3,4]
VAR WINDOW_COL_ROW[2,3,2]

VAR POPUP_RECT[2,2,4]
VAR POPUP_COL[2,2]
VAR POPUP_ENABLE[2,2]

VAR BUTTON_RECT[6,4]
VAR BUTTON_COL[6]
VAR BUTTON_ENABLE[6]
VAR BUTTON_TITLE$[6]

VAR MENU_RECT[2,2,4]
VAR MENU_COL_ROW[2,2,2]
VAR MENU_ENABLE[2,2]

VAR CONTROL_RECT[4,4]
VAR CONTROL_COL[4]
VAR CONTROL_ENABLE[4]
VAR CONTROL_TITLE$[4]

VAR RADIO_RECT[1,4]
VAR RADIO_COL[1]
VAR RADIO_ENABLE[1]
VAR RADIO_TITLE$[1]
VAR RADIO_STATE[1]

'
' MAIN
'
@MAIN

 ACLS
 SPCLR
 BGCLR

 XSCREEN 2,256,0 
 VISIBLE 1,1,1,1

 LOAD "GRP5:YOS_CHESS.GRP",FALSE

 INIT_STKANDBTN
 INIT_SCENE
 INIT_CONSTANT
 INIT_DATA
 INIT_MOVE
 INIT_ATTACK
 INIT_EVALUATE
 INIT_SQ
 INIT_PLAYER
 INIT_SOUND

 INIT_BG
 INIT_UI

 INIT_DIALOG

 DRAW_UI
 DRAW_BOARD

' DEBUG
' END

 WHILE TRUE

 IF SCENE_STATE==G_SCENE_PLAY THEN
  SCENE_PLAY
 ELSEIF SCENE_STATE==G_SCENE_NEW THEN
  SCENE_NEW
 ELSEIF SCENE_STATE==G_SCENE_RECORD THEN
  SCENE_RECORD
 ELSEIF SCENE_STATE==G_SCENE_END THEN
  BREAK
 ENDIF

 WEND
 
' PAUSE
 
END
 
'
' DEBUG
'
DEF DEBUG
 VAR I,J,P,F
 VAR MOVE
 VAR SQ,S
 VAR ATTACK
 VAR FR$
 VAR X,Y
 VAR TX,TY
 VAR CHR
 VAR C
 VAR FLAG
 VAR SQ120

' PARSE_FEN START_FEN$,B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE

 PARSE_FEN TEST_FEN$[9],B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE

 DRAW_BOARD
 DRAW_PIECES B_PIECES,NO_SQ

 SQ120_PRINT B_PIECES

 GOTO @DEBUG1

 WHILE TRUE

  TOUCH_XY OUT FLAG, TX, TY

  IF FLAG THEN

   ? "X=";TX;" ";"Y=";TY

   XY2SQ120 TX, TY OUT FLAG, SQ120
   IF FLAG THEN
    BG_FLIP=BG_FLIP XOR 1
   
    DRAW_BOARD
    DRAW_PIECES B_PIECES,NO_SQ
   ENDIF

  ELSE
'   ? "NO TOUCH
  ENDIF
 WEND

@DEBUG1

'GOTO @DEBUG1

FOR I=0 TO 5
 P=LOOP_NONSLIDE_PIECE[I]
' P=LOOP_SLIDE_PIECE[I]
 ? SIDE_CHAR$[PIECE_COL[P]];PIECE_CHAR$[P];" ";
NEXT
 ?:?

 P=G_BN
 S=SQ64TOSQ120[28]
 B_PIECES[S]=G_WK
 FOR I=0 TO PIECE_NUM_DIR[P]-1
  SQ=S+PIECE_DIR[P,I] 
  IF B_PIECES[SQ]!=OFFBOARD THEN B_PIECES[SQ]=G_BK
 NEXT

' SQ120_PRINT SQ120TOSQ64

'S=SQ64TOSQ120[18]
'B_PIECES[S]=G_WK
'SQ=S+KI_DIR[0] 
'IF B_PIECES[SQ]!=OFFBOARD THEN B_PIECES[SQ]=G_BK

'ATTACK=FALSE
'ATTACK=SQ_ATTACKED(S, G_BLACK, B_PIECES)
'IF ATTACK==TRUE THEN
' ? "ATTACK"
'ELSE
' ? "NO ATTACK"
'ENDIF

'SQ64_PRINT SQ64TOSQ120
'SQ120_PRINT SQ120TOSQ64

'RESET_BOARD B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE

'SQ120_PRINT B_PIECES

'PRINT_BOARD B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,FALSE

'PRINT_BOARD B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,TRUE


'MATERIAL_PRINT B_PIECE_SIDE,B_PIECE_LIST,B_PIECE_NUM


'SQ120_PRINT FILES_BOARD
'SQ120_PRINT RANKS_BOARD


'MOVE=BIT_MOVE(21,41,G_BP,G_WQ,(MFLAG_EP OR MFLAG_PS OR MFLAG_CA))

'MOVE_PRINT MOVE

'SQ120_PRINT CASTLE_PERM

'FOR I=G_EMPTY TO G_BK
' F=PIECE_BIG[I]
' F=PIECE_MAJ[I]
' F=PIECE_MIN[I]
' F=PIECE_VAL[I]
' F=PIECE_COL[I]
' IF F THEN ? PIECE_CHAR$[I];" "; 
' IF I==G_WP||I==G_BP THEN ?
' ? PIECE_CHAR$[I];" ";F;" "; 
'NEXT
'?

'SQ64_PRINT PAWN_TABLE
'SQ64_PRINT KNIGHT_TABLE
'SQ64_PRINT BISHOP_TABLE
'SQ64_PRINT ROOK_TABLE
'SQ64_PRINT KING_E
'SQ64_PRINT KING_Q

'SQ64_PRINT MIRROR_64

'? END_GAME_MAT
 
 DRAW_PIECES B_PIECES,NO_SQ

@DEBUG2

 ? "MATERIAL_DRAW: ";
 IF MATERIAL_DRAW(B_PIECE_SIDE, B_PIECES, B_MATERIAL_PIECE,B_PIECE_LIST,B_PIECE_NUM) THEN
  ? "TRUE"
 ELSE
  ? "FALSE"
 ENDIF
 ? "DRAW_MATERIAL: ";
 IF DRAW_MATERIAL(B_PIECE_LIST,B_PIECE_NUM) THEN
  ? "TRUE"
 ELSE
  ? "FALSE"
 ENDIF
 
 PAUSE

' SQ64_PRINT FLIP_64

'FOR I=G_EMPTY TO G_BK
' ? SIDE_CHAR$[PIECE_COL[I]];PIECE_CHAR$[I];" ";VICTIM_SCORE[I];" ";
' IF I==G_EMPTY THEN ?
' IF I==G_WK THEN ?
'NEXT
'?

'FOR I=G_EMPTY TO G_BK
'? "Victim:";SIDE_CHAR$[PIECE_COL[I]];PIECE_CH'AR$[I];" "
' FOR J=G_EMPTY TO G_BK
'  IF J==G_WP THEN ?
'  IF J==G_BP THEN ?
'  ? SIDE_CHAR$[PIECE_COL[J]];PIECE_CHAR$[J];" ";MVV_LVA_SCORES[I,J];" ";
' NEXT
'?
'NEXT

' PRINT_PLAYER G_WHITE:?
' PRINT_PLAYER G_BLACK

'PRINT_BOARD B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,TRUE

END

'
' SCENE
'
DEF SCENE_PLAY
 VAR I,J

 FOR I=G_WHITE TO G_BLACK
  FOR J=G_POPUP_TYPE TO G_POPUP_LEVEL 
   POPUP_ENABLE[I,J]=FALSE
  NEXT
 NEXT

 BG_BOARD_ENABLE=TRUE

 BUTTON_ENABLE[G_BUTTON_NEW]=TRUE
 BUTTON_ENABLE[G_BUTTON_PLAY]=FALSE
 BUTTON_ENABLE[G_BUTTON_UNDO]=FALSE
 BUTTON_ENABLE[G_BUTTON_FLIP]=TRUE
 BUTTON_ENABLE[G_BUTTON_RESIGN]=TRUE
 
 BUTTON_ENABLE[G_BUTTON_QUIT]=TRUE

 CONTROL_ENABLE[G_CONTROL_HEAD]=FALSE
 CONTROL_ENABLE[G_CONTROL_BACKWARD]=FALSE
 CONTROL_ENABLE[G_CONTROL_FORWARD]=FALSE
 CONTROL_ENABLE[G_CONTROL_TAIL]=FALSE

 RADIO_ENABLE[G_RADIO_ASSISTANT]=TRUE

 BG_HIGHLIGHT120=NO_SQ

' CONSOLE_LOOP
 UI_LOOP
 
END

'
'
'
DEF SCENE_NEW
 VAR FLAG
 VAR TX,TY
 VAR SQ
 VAR BTN
 VAR SIDE
 VAR TYPE
 VAR VALUE
 VAR ENGINE
 VAR LEVEL
 VAR I,J

 ARRAY_CLEAR B_RECORD_MOVE
 ARRAY_CLEAR B_RECORD_CASTLE_PERM
 ARRAY_CLEAR B_RECORD_ENPAS
 ARRAY_CLEAR B_RECORD_FIFTY_MOVE

 FOR I=G_WHITE TO G_BLACK
  FOR J=G_POPUP_TYPE TO G_POPUP_LEVEL 
   POPUP_ENABLE[I,J]=TRUE
  NEXT
 NEXT

 BG_BOARD_ENABLE=FALSE
 
 BUTTON_ENABLE[G_BUTTON_NEW]=FALSE
 BUTTON_ENABLE[G_BUTTON_PLAY]=TRUE
 BUTTON_ENABLE[G_BUTTON_UNDO]=FALSE
 BUTTON_ENABLE[G_BUTTON_FLIP]=FALSE
 BUTTON_ENABLE[G_BUTTON_RESIGN]=FALSE
 BUTTON_ENABLE[G_BUTTON_QUIT]=TRUE

 CONTROL_ENABLE[G_CONTROL_HEAD]=FALSE
 CONTROL_ENABLE[G_CONTROL_BACKWARD]=FALSE
 CONTROL_ENABLE[G_CONTROL_FORWARD]=FALSE
 CONTROL_ENABLE[G_CONTROL_TAIL]=FALSE

 RADIO_ENABLE[G_RADIO_ASSISTANT]=FALSE

 DRAW_UI

 PARSE_FEN START_FEN$,B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE

 BG_TARGET120[0]=NO_SQ
 BG_TARGET120[1]=NO_SQ

 BG_HIGHLIGHT120=NO_SQ

 ARRAY_CLEAR BG_MOVE_LIST
 DRAW_PIECES B_PIECES,NO_SQ
 
 WHILE TRUE

  TOUCH_XY OUT FLAG, TX, TY

  IF FLAG THEN

   XY2SQ120 TX, TY OUT FLAG, SQ

   IF FLAG THEN
   ENDIF

   XY2BUTTON TX, TY OUT FLAG, BTN

   IF FLAG THEN
    IF BTN==G_BUTTON_NEW THEN
    ELSEIF BTN==G_BUTTON_PLAY THEN
     IF DIALOG_BUTTON(BTN) THEN
      SCENE_STATE=G_SCENE_PLAY
      BREAK
     ENDIF
    ELSEIF BTN==G_BUTTON_UNDO THEN
    ELSEIF BTN==G_BUTTON_FLIP THEN
    ELSEIF BTN==G_BUTTON_RESIGN THEN
    ELSEIF BTN==G_BUTTON_QUIT THEN
     IF DIALOG_BUTTON(BTN) THEN
      SCENE_STATE=G_SCENE_END
      BREAK
     ENDIF
    ENDIF
   ENDIF
   
 
   XY2POPUP TX,TY OUT FLAG,SIDE,TYPE

   IF FLAG THEN

    DISPLAY 1
    MENU_ENABLE[SIDE,TYPE]=TRUE
    DRAW_MENU SIDE,TYPE,MENU_RECT,MENU_COL_ROW,MENU_ENABLE
    PRINT_MENU SIDE,TYPE,MENU_RECT,MENU_COL_ROW,MENU_ENABLE 
    DISPLAY 0

    WHILE TRUE
    
     TOUCH_XY OUT FLAG, TX, TY
    
     IF FLAG THEN
      XY2MENU TX,TY OUT FLAG,SIDE,TYPE,VALUE
      IF FLAG THEN
       ENGINE=PLAYER[SIDE]
       LEVEL=PLAYER_LEVEL[SIDE]
       IF TYPE==G_MENU_TYPE THEN
        SET_PLAYER_LEVEL SIDE,VALUE,LEVEL
       ELSE
        SET_PLAYER_LEVEL SIDE,ENGINE,VALUE
       ENDIF
      
      ENDIF
      
      ERASE_ALL_MENU
      DRAW_UI
     
      BREAK
     ENDIF
    WEND
   ENDIF
  ENDIF
 WEND

END

'
'
'
DEF SCENE_RECORD
 VAR FLAG
 VAR TX,TY
 VAR SQ
 VAR BTN
 VAR SIDE
 VAR TYPE
 VAR VALUE
 VAR ENGINE
 VAR LEVEL
 VAR L,M
 VAR I,J
 VAR RECORD_MOVE[0]
 VAR RECORD_CASTLE_PERM[0]
 VAR RECORD_ENPAS[0]
 VAR RECORD_FIFTY_MOVE[0]
 VAR MOVE
 VAR NO_ATTACKED
 VAR ABBREV
 VAR GAME_END
 VAR GAME_RESULT

 ABBREV=FALSE

 L=LEN(B_RECORD_MOVE)

 IF L==0 THEN
  CONTROL_ENABLE[G_CONTROL_HEAD]=FALSE
  CONTROL_ENABLE[G_CONTROL_BACKWARD]=FALSE
  CONTROL_ENABLE[G_CONTROL_FORWARD]=FALSE
  CONTROL_ENABLE[G_CONTROL_TAIL]=FALSE
 ELSE
  CONTROL_ENABLE[G_CONTROL_HEAD]=TRUE
  CONTROL_ENABLE[G_CONTROL_BACKWARD]=TRUE
  CONTROL_ENABLE[G_CONTROL_FORWARD]=FALSE
  CONTROL_ENABLE[G_CONTROL_TAIL]=FALSE
  
  COPY RECORD_MOVE,B_RECORD_MOVE
  COPY RECORD_CASTLE_PERM,B_RECORD_CASTLE_PERM
  COPY RECORD_ENPAS,B_RECORD_ENPAS
  COPY RECORD_FIFTY_MOVE,B_RECORD_FIFTY_MOVE
 ENDIF

 FOR I=G_WHITE TO G_BLACK
  FOR J=G_POPUP_TYPE TO G_POPUP_LEVEL 
   POPUP_ENABLE[I,J]=FALSE
  NEXT
 NEXT

 BG_BOARD_ENABLE=FALSE
 
 BUTTON_ENABLE[G_BUTTON_NEW]=TRUE
 BUTTON_ENABLE[G_BUTTON_PLAY]=FALSE
 BUTTON_ENABLE[G_BUTTON_UNDO]=FALSE
 BUTTON_ENABLE[G_BUTTON_FLIP]=TRUE
 BUTTON_ENABLE[G_BUTTON_RESIGN]=FALSE
 BUTTON_ENABLE[G_BUTTON_QUIT]=TRUE

 RADIO_ENABLE[G_RADIO_ASSISTANT]=FALSE

 DRAW_UI
 PRINT_PLY_WINDOW LEN(B_RECORD_MOVE),LEN(RECORD_MOVE)

 ARRAY_CLEAR BG_MOVE_LIST

 BG_TARGET120[0]=NO_SQ
 BG_TARGET120[1]=NO_SQ

 BG_HIGHLIGHT120=NO_SQ

 IF L<=0 THEN
  SQ=NO_SQ
 ELSE
  MOVE=B_RECORD_MOVE[L-1]
  SQ=MOVE_TOSQ(MOVE)
 ENDIF
 
 DRAW_PIECES B_PIECES,SQ

 WHILE TRUE

  SQ=NO_SQ

  TOUCH_XY OUT FLAG, TX, TY

  IF FLAG THEN

   XY2BUTTON TX, TY OUT FLAG, BTN

   IF FLAG THEN
    IF BTN==G_BUTTON_NEW THEN
     IF DIALOG_BUTTON(BTN) THEN
      SCENE_STATE=G_SCENE_NEW
      BREAK
     ENDIF
    ELSEIF BTN==G_BUTTON_PLAY THEN
     IF DIALOG_BUTTON(BTN) THEN
      SCENE_STATE=G_SCENE_PLAY
      BREAK
     ENDIF
    ELSEIF BTN==G_BUTTON_UNDO THEN
    ELSEIF BTN==G_BUTTON_FLIP THEN

      BG_FLIP=BG_FLIP XOR 1
   
      DRAW_BOARD
      DRAW_PIECES B_PIECES,NO_SQ
    ELSEIF BTN==G_BUTTON_RESIGN THEN
    ELSEIF BTN==G_BUTTON_QUIT THEN
     IF DIALOG_BUTTON(BTN) THEN
      SCENE_STATE=G_SCENE_END
      BREAK
     ENDIF
    ENDIF
   ENDIF
  
   XY2CONTROL TX, TY OUT FLAG, BTN

   IF FLAG THEN

'
' HEAD BUTTON
'
    IF G_CONTROL_HEAD==BTN THEN
     L=LEN(B_RECORD_MOVE)

     FOR I=0 TO L-1
      TAKE_MOVE B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,B_RECORD_MOVE,B_RECORD_ENPAS,B_RECORD_CASTLE_PERM,B_RECORD_FIFTY_MOVE
      M=LEN(B_RECORD_MOVE)

      IF M==0 THEN
       SQ=NO_SQ
      ELSE
       MOVE=B_RECORD_MOVE[M-1]
       SQ=MOVE_TOSQ(MOVE)
      ENDIF
      DRAW_PIECES B_PIECES,SQ
     NEXT

     PRINT_BOARD B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,ABBREV

     SQ=NO_SQ
     
     BG_HIGHLIGHT120=NO_SQ

     CONTROL_ENABLE[G_CONTROL_HEAD]=FALSE
     CONTROL_ENABLE[G_CONTROL_BACKWARD]=FALSE
     CONTROL_ENABLE[G_CONTROL_FORWARD]=TRUE
     CONTROL_ENABLE[G_CONTROL_TAIL]=TRUE

'
' BACKWARD BUTTON
'     
    ELSEIF G_CONTROL_BACKWARD==BTN THEN
     TAKE_MOVE B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,B_RECORD_MOVE,B_RECORD_ENPAS,B_RECORD_CASTLE_PERM,B_RECORD_FIFTY_MOVE

     L=LEN(B_RECORD_MOVE)

     IF L==0 THEN
      BG_HIGHLIGHT120=NO_SQ

      CONTROL_ENABLE[G_CONTROL_HEAD]=FALSE
      CONTROL_ENABLE[G_CONTROL_BACKWARD]=FALSE
     ELSE
      MOVE=B_RECORD_MOVE[L-1]
      SQ=MOVE_TOSQ(MOVE)

      PLY_MOVE_TO_PRINT L,B_PIECE_SIDE[0] XOR 1,B_PIECES,MOVE
     ENDIF

     CONTROL_ENABLE[G_CONTROL_FORWARD]=TRUE
     CONTROL_ENABLE[G_CONTROL_TAIL]=TRUE

     PRINT_BOARD B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,ABBREV

'
' FORWARD BUTTON
'
    ELSEIF G_CONTROL_FORWARD==BTN THEN
     L=LEN(B_RECORD_MOVE)
     
     MOVE=RECORD_MOVE[L]
     SQ=MOVE_TOSQ(MOVE)

     NO_ATTACKED=MAKE_MOVE(MOVE, B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,B_RECORD_MOVE,B_RECORD_ENPAS,B_RECORD_CASTLE_PERM,B_RECORD_FIFTY_MOVE)

     PLY_MOVE_TO_PRINT L+1,B_PIECE_SIDE[0] XOR 1,B_PIECES,MOVE

     PRINT_BOARD B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,ABBREV

     L=LEN(B_RECORD_MOVE)
     M=LEN(RECORD_MOVE)
     
     IF L==M THEN
      CONTROL_ENABLE[G_CONTROL_FORWARD]=FALSE
      CONTROL_ENABLE[G_CONTROL_TAIL]=FALSE
     ENDIF
     
     CONTROL_ENABLE[G_CONTROL_HEAD]=TRUE
     CONTROL_ENABLE[G_CONTROL_BACKWARD]=TRUE

     CHECK_RESULT B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,TRUE OUT GAME_END, GAME_RESULT

'
' TAIL BUTTON
'
    ELSEIF G_CONTROL_TAIL==BTN THEN
     L=LEN(B_RECORD_MOVE)
     M=LEN(RECORD_MOVE)

     FOR I=0 TO M-L-1
      MOVE=RECORD_MOVE[L+I]
      SQ=MOVE_TOSQ(MOVE)

      NO_ATTACKED=MAKE_MOVE(MOVE, B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,B_RECORD_MOVE,B_RECORD_ENPAS,B_RECORD_CASTLE_PERM,B_RECORD_FIFTY_MOVE)

      J=LEN(B_RECORD_MOVE)

      MOVE=B_RECORD_MOVE[J-1]
      SQ=MOVE_TOSQ(MOVE)

      DRAW_PIECES B_PIECES,SQ
     NEXT

     PRINT_BOARD B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,ABBREV

     SQ=NO_SQ

     L=LEN(B_RECORD_MOVE)
     M=LEN(RECORD_MOVE)

     IF L==M THEN
      CONTROL_ENABLE[G_CONTROL_FORWARD]=FALSE
      CONTROL_ENABLE[G_CONTROL_TAIL]=FALSE
      CONTROL_ENABLE[G_CONTROL_HEAD]=TRUE
      CONTROL_ENABLE[G_CONTROL_BACKWARD]=TRUE
     ENDIF

     CHECK_RESULT B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,TRUE OUT GAME_END, GAME_RESULT

    ENDIF
    DRAW_PIECES B_PIECES,SQ
    DRAW_UI
    
    PRINT_PLY_WINDOW LEN(B_RECORD_MOVE),LEN(RECORD_MOVE)

   ENDIF
  ENDIF
 WEND


END

'
' 
'
DEF CONSOLE_LOOP
 VAR GAME_END
 VAR GAME_RESULT
 VAR IN_BUF$
 VAR COMMAND$
 VAR MOVE
 VAR NO_ATTACKED
 VAR PIECE
 VAR RECORD
 VAR PLY
 VAR ABBREV
 VAR L
 VAR SQ
 VAR START

 START=FALSE

' SET_PLAYER_LEVEL G_WHITE,G_USER,1
' SET_PLAYER_LEVEL G_WHITE,G_ENGINE,1

' SET_PLAYER_LEVEL G_BLACK,G_USER,1
' SET_PLAYER_LEVEL G_BLACK,G_ENGINE,1
' SET_PLAYER_LEVEL G_BLACK,G_ENGINE,2
' SET_PLAYER_LEVEL G_BLACK,G_ENGINE,3

 BG_BOARD_ENABLE=FALSE

 BUTTON_ENABLE[G_BUTTON_NEW]=FALSE
 BUTTON_ENABLE[G_BUTTON_PLAY]=FALSE
 BUTTON_ENABLE[G_BUTTON_UNDO]=FALSE
 BUTTON_ENABLE[G_BUTTON_FLIP]=FALSE
 BUTTON_ENABLE[G_BUTTON_RESIGN]=FALSE
 BUTTON_ENABLE[G_BUTTON_QUIT]=FALSE

 RADIO_ENABLE[G_RADIO_ASSISTANT]=FALSE

 DRAW_UI

 PLY=0
 ABBREV=FALSE

 PRINT_PLY_WINDOW PLY,0

 PARSE_FEN START_FEN$,B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE

' PARSE_FEN TEST_FEN$[8],B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE

 PRINT_BOARD B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,ABBREV

 DRAW_PIECES B_PIECES,NO_SQ
 
 WHILE TRUE
  CHECK_RESULT B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,FALSE OUT GAME_END, GAME_RESULT

  IF GAME_END THEN

   DRAW_PIECES B_PIECES,NO_SQ
  
'   PRINT_BOARD B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,ABBREV

   ? G_GAME_RESULT$[GAME_RESULT,G_DIALOG_RESULT,LC_EN]
   ? G_GAME_RESULT$[GAME_RESULT,G_DIALOG_GAME,LC_EN]

   DIALOG_RESULT GAME_RESULT

   SCENE_STATE=G_SCENE_RECORD

   RETURN
  ENDIF
 
  IF PLAYER[B_PIECE_SIDE[0]]==G_ENGINE THEN

   SEARCH_POSITION B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,B_RECORD_MOVE,B_RECORD_ENPAS,B_RECORD_CASTLE_PERM,B_RECORD_FIFTY_MOVE,TRUE OUT MOVE

   INC PLY

   IF PLAYER[B_PIECE_SIDE[0]]==G_ENGINE THEN
    IF (PLY AND &H0F)==0 THEN
     PRINT_BOARD B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,ABBREV
    ENDIF
   ELSE
    PRINT_BOARD B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,ABBREV
   ENDIF

   DRAW_PIECES B_PIECES, MOVE_TOSQ(MOVE)
   PRINT_PLY_WINDOW PLY,0

'PAUSE

   CONTINUE

  ENDIF

  EVAL_MODE=PLAYER_EVAL[B_PIECE_SIDE[0]]

  DRAW_PIECES B_PIECES,NO_SQ
  
  PAUSE

  IF START==FALSE THEN
   PRINT_HELP
   START=TRUE
  ENDIF
  
  IN_BUF$=""
  INPUT IN_BUF$
  
  COMMAND$=UPCASE$(IN_BUF$)

  IF COMMAND$=="HELP" THEN
   PRINT_HELP
   CONTINUE
  ENDIF
 
  IF COMMAND$=="QUIT" THEN
   IF DIALOG_BUTTON(G_BUTTON_QUIT) THEN
    SCENE_STATE=G_SCENE_END
    BREAK
   ENDIF
   CONTINUE
  ENDIF

  IF COMMAND$=="RESIGN" THEN
   IF DIALOG_BUTTON(G_BUTTON_RESIGN) THEN
    SCENE_STATE=G_SCENE_RECORD
    BREAK
   ENDIF
   CONTINUE
  ENDIF
  
  IF COMMAND$=="PRINT" THEN
   PRINT_BOARD B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,ABBREV
   CONTINUE
  ENDIF
  
  IF COMMAND$=="GO" THEN
   SEARCH_POSITION B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,B_RECORD_MOVE,B_RECORD_ENPAS,B_RECORD_CASTLE_PERM,B_RECORD_FIFTY_MOVE,TRUE OUT MOVE

   INC PLY

   DRAW_PIECES B_PIECES,MOVE_TOSQ(MOVE)
   PRINT_PLY_WINDOW PLY,0

   PRINT_BOARD B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,ABBREV
   CONTINUE
  ENDIF

  IF COMMAND$=="UNDO" THEN
   RECORD=LEN(B_RECORD_MOVE)

   IF RECORD<=0 THEN
    ? "Can't undo move"

    IF BEEP_ON THEN BEEP G_BEEP_ERR_NUM

    CONTINUE
   ENDIF

   MOVE=B_RECORD_MOVE[RECORD-1]
   SQ=MOVE_TOSQ(MOVE)
   PLY_MOVE_TO_PRINT RECORD,B_PIECE_SIDE[0] XOR 1,B_PIECES,MOVE

   REPEAT
   
    TAKE_MOVE B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,B_RECORD_MOVE,B_RECORD_ENPAS,B_RECORD_CASTLE_PERM,B_RECORD_FIFTY_MOVE
    L=LEN(B_RECORD_MOVE)

    IF L==0 THEN
     BG_HIGHLIGHT120=NO_SQ
     SQ=NO_SQ
     BUTTON_ENABLE[G_BUTTON_UNDO]=FALSE
     DRAW_UI
     BREAK
    ELSE
     MOVE=B_RECORD_MOVE[L-1]
     SQ=MOVE_TOSQ(MOVE)
     PLY_MOVE_TO_PRINT L,B_PIECE_SIDE[0] XOR 1,B_PIECES,MOVE
    ENDIF

   UNTIL PLAYER[B_PIECE_SIDE[0]]==G_USER

'   PRINT_BOARD B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,ABBREV

   DRAW_PIECES B_PIECES,SQ
   PLY=L
   PRINT_PLY_WINDOW PLY,0

   COMMAND$=""
  ENDIF
  
  IF COMMAND$=="FLIP" THEN
   BG_FLIP=BG_FLIP XOR 1
   
   DRAW_BOARD
   DRAW_PIECES B_PIECES,NO_SQ
   CONTINUE
  ENDIF

  IF COMMAND$=="" THEN CONTINUE

  MOVE=PARSE_MOVE(COMMAND$, B_PIECE_SIDE,B_PIECES,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM)
  
  IF MOVE==G_EMPTY THEN
   ? "Illegal move"

   IF BEEP_ON THEN BEEP G_BEEP_ERR_NUM

   L=LEN(B_RECORD_MOVE)
   IF L==0 THEN
    BG_HIGHLIGHT120=NO_SQ
    SQ=NO_SQ
   ELSE
    SQ=MOVE_TOSQ(B_RECORD_MOVE[L-1])
   ENDIF

   DRAW_PIECES B_PIECES,SQ
  ELSE
   L=LEN(B_RECORD_MOVE)+1

   PLY_MOVE_FROM_PRINT L,B_PIECE_SIDE[0],B_PIECES,MOVE
   PIECE=B_PIECES[MOVE_FROMSQ(MOVE)]

   NO_ATTACKED=MAKE_MOVE(MOVE, B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,B_RECORD_MOVE,B_RECORD_ENPAS,B_RECORD_CASTLE_PERM,B_RECORD_FIFTY_MOVE)

   IF NO_ATTACKED==FALSE THEN
    ? "Illegal move: Attaked king:";SIDE_CHAR$[PIECE_COL[PIECE]];PIECE_CHAR$[PIECE]

    IF BEEP_ON THEN BEEP G_BEEP_ERR_NUM

    L=LEN(B_RECORD_MOVE)
    IF L==0 THEN
     BG_HIGHLIGHT120=NO_SQ
     SQ=NO_SQ
    ELSE
     SQ=MOVE_TOSQ(B_RECORD_MOVE[L-1])
    ENDIF

    DRAW_PIECES B_PIECES,SQ

    CONTINUE
   ENDIF
 
   INC PLY
   
   PRINT_BOARD B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,ABBREV

   DRAW_PIECES B_PIECES, MOVE_TOSQ(MOVE)
   PRINT_PLY_WINDOW PLY,0

  ENDIF
 
 WEND
 
END

'
'
'
DEF PRINT_HELP
 ? "List of commands:"
 ? " PRINT - show board"
 ? " RESIGN - resign game"
 ? " GO - set computer thinking"
 ? " UNDO - undo move"
 ? " FLIP - flip board"
 ? " QUIT - quit program"
 ? " HELP - show command list"
 ? " enter moves using coordinate algebraic notation"
 ? " e.g. D2D4,B7B8Q"
END

'
' UI_LOOP 
'
DEF UI_LOOP
 VAR GAME_END
 VAR GAME_RESULT
 VAR COMMAND$
 VAR RECORD
 VAR NO_ATTACKED
 VAR MOVE
 VAR PIECE
 VAR PLY
 VAR ABBREV
 VAR FLAG
 VAR TX,TY
 VAR SQ
 VAR COLOUR
 VAR BTN
 VAR L
 VAR SIDE
 VAR TYPE
 VAR RANK
 VAR DI

 IF PLAYER[G_WHITE]==G_ENGINE && PLAYER[G_BLACK]==G_ENGINE THEN
  BUTTON_ENABLE[G_BUTTON_NEW]=FALSE
  BUTTON_ENABLE[G_BUTTON_PLAY]=FALSE
  BUTTON_ENABLE[G_BUTTON_UNDO]=FALSE
  BUTTON_ENABLE[G_BUTTON_FLIP]=FALSE
  BUTTON_ENABLE[G_BUTTON_RESIGN]=FALSE
  BUTTON_ENABLE[G_BUTTON_QUIT]=FALSE

  RADIO_ENABLE[G_RADIO_ASSISTANT]=FALSE
 ENDIF

 DRAW_UI

 PLY=0
 ABBREV=FALSE

 PRINT_PLY_WINDOW PLY,0

 PARSE_FEN START_FEN$,B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE

' PARSE_FEN TEST_FEN$[8],B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE

' B_FIFTY_MOVE[0]=101

 ARRAY_CLEAR BG_MOVE_LIST
 DRAW_PIECES B_PIECES,NO_SQ

 WHILE TRUE

  IF PLAYER[G_WHITE]==G_ENGINE && PLAYER[G_BLACK]==G_ENGINE THEN
  ELSE
   L=LEN(B_RECORD_MOVE)
   IF L==1 THEN
    BUTTON_ENABLE[G_BUTTON_UNDO]=TRUE
    DRAW_UI
    PRINT_PLY_WINDOW L,0
   ENDIF
  ENDIF
  
  IF PLAYER[B_PIECE_SIDE[0]]==G_ENGINE THEN
   IF (PLY AND &H0F)==0 THEN
    PRINT_BOARD B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,ABBREV
   ENDIF
  ELSE
   PRINT_BOARD B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,ABBREV
  ENDIF

  DRAW_PIECES B_PIECES,NO_SQ

  CHECK_RESULT B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,FALSE OUT GAME_END, GAME_RESULT

  IF GAME_END THEN
   PRINT_BOARD B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,ABBREV

  ? G_GAME_RESULT$[GAME_RESULT,G_DIALOG_RESULT,LC_EN]
  ? G_GAME_RESULT$[GAME_RESULT,G_DIALOG_GAME,LC_EN]

   DIALOG_RESULT GAME_RESULT
   SCENE_STATE=G_SCENE_RECORD
   RETURN
  ENDIF
 
  IF PLAYER[B_PIECE_SIDE[0]]==G_ENGINE THEN

   SEARCH_POSITION B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,B_RECORD_MOVE,B_RECORD_ENPAS,B_RECORD_CASTLE_PERM,B_RECORD_FIFTY_MOVE,FALSE OUT MOVE

   INC PLY

   DRAW_PIECES B_PIECES, MOVE_TOSQ(MOVE)
   PRINT_PLY_WINDOW PLY,0

   CONTINUE

  ENDIF

  EVAL_MODE=PLAYER_EVAL[B_PIECE_SIDE[0]]

  DRAW_PIECES B_PIECES,NO_SQ
  
' PAUSE

  BG_TARGET120[0]=NO_SQ
  BG_TARGET120[1]=NO_SQ

  ARRAY_CLEAR BG_MOVE_LIST

  WHILE TRUE

   TOUCH_XY OUT FLAG, TX, TY

   IF FLAG THEN

    XY2SQ120 TX, TY OUT FLAG, SQ

    IF FLAG THEN

     PIECE=B_PIECES[SQ]
     COLOUR=PIECE_COL[PIECE]

     DRAW_BOARD
     IF BG_TARGET120[0]==NO_SQ THEN
      IF B_PIECE_SIDE[0]==COLOUR THEN
       BG_TARGET120[0]=SQ

       GENERATE_ASSISTANT_MOVE_LIST B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,SQ

       DRAW_PIECES B_PIECES,SQ
      ENDIF
     ELSE
      IF BG_TARGET120[0]==SQ || BG_TARGET120[1]==SQ THEN
       BG_TARGET120[0]=NO_SQ
       BG_TARGET120[1]=NO_SQ

       BG_HIGHLIGHT120=NO_SQ

       ARRAY_CLEAR BG_MOVE_LIST

       DRAW_PIECES B_PIECES,NO_SQ
      ELSE
       BG_TARGET120[1]=SQ

       ARRAY_CLEAR BG_MOVE_LIST

       DRAW_PIECES B_PIECES,SQ

       COMMAND$=UPCASE$(SQ2FR$(BG_TARGET120[0])+SQ2FR$(BG_TARGET120[1]))

       TOUCH_PRINT DOWNCASE$(COMMAND$)

       PIECE=B_PIECES[BG_TARGET120[0]]
       COLOUR=PIECE_COL[PIECE]
       RANK=RANKS_BOARD[BG_TARGET120[1]]

       IF PIECE_PAWN[PIECE] THEN
        IF COLOUR==G_WHITE && RANK==RANK_8 THEN
         COMMAND$=COMMAND$+"Q"
        ELSEIF COLOUR==G_BLACK && RANK==RANK_1 THEN
         COMMAND$=COMMAND$+"Q"
        ENDIF
       ENDIF

       BREAK
      ENDIF
     ENDIF
    ENDIF

    XY2RADIO TX, TY OUT FLAG, BTN

    IF FLAG THEN
     IF BTN==G_RADIO_ASSISTANT THEN
      RADIO_STATE[BTN]=RADIO_STATE[BTN] XOR 1

      BG_ASSISTANT=RADIO_STATE[BTN]
      
      DISPLAY 1
      DRAW_RADIO BTN,RADIO_RECT,RADIO_COL,RADIO_ENABLE,RADIO_TITLE$,RADIO_STATE
      DISPLAY 0

      DRAW_BOARD
      DRAW_PIECES B_PIECES,NO_SQ
     ENDIF
    ENDIF


    XY2BUTTON TX, TY OUT FLAG, BTN

    IF FLAG THEN
     IF BTN==G_BUTTON_NEW THEN
      IF DIALOG_BUTTON(BTN) THEN
       SCENE_STATE=G_SCENE_NEW
       RETURN
      ENDIF
     ELSEIF BTN==G_BUTTON_PLAY THEN
     ELSEIF BTN==G_BUTTON_UNDO THEN
      RECORD=LEN(B_RECORD_MOVE)

      IF RECORD<=0 THEN
       ? "Can't undo move"

       IF BEEP_ON THEN BEEP G_BEEP_ERR_NUM

       CONTINUE
      ENDIF

      MOVE=B_RECORD_MOVE[RECORD-1]
      SQ=MOVE_TOSQ(MOVE)
      PLY_MOVE_TO_PRINT RECORD,B_PIECE_SIDE[0] XOR 1,B_PIECES,MOVE

      REPEAT

       TAKE_MOVE B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,B_RECORD_MOVE,B_RECORD_ENPAS,B_RECORD_CASTLE_PERM,B_RECORD_FIFTY_MOVE
       L=LEN(B_RECORD_MOVE)

       IF L==0 THEN
        BG_HIGHLIGHT120=NO_SQ
        SQ=NO_SQ
        BUTTON_ENABLE[G_BUTTON_UNDO]=FALSE
        DRAW_UI
        BREAK
       ELSE
        MOVE=B_RECORD_MOVE[L-1]
        SQ=MOVE_TOSQ(MOVE)
        PLY_MOVE_TO_PRINT L,B_PIECE_SIDE[0] XOR 1,B_PIECES,MOVE
       ENDIF

      UNTIL PLAYER[B_PIECE_SIDE[0]]==G_USER

'      PRINT_BOARD B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,ABBREV

      ARRAY_CLEAR BG_MOVE_LIST

      DRAW_PIECES B_PIECES,SQ
      PLY=L
      PRINT_PLY_WINDOW PLY,0

      COMMAND$=""

      BREAK
     ELSEIF BTN==G_BUTTON_FLIP THEN
      BG_FLIP=BG_FLIP XOR 1
   
      DRAW_BOARD
      DRAW_PIECES B_PIECES,NO_SQ
    
     ELSEIF BTN==G_BUTTON_RESIGN THEN
      IF DIALOG_BUTTON(BTN) THEN
       SCENE_STATE=G_SCENE_RECORD
       RETURN
      ENDIF
     ELSEIF BTN==G_BUTTON_QUIT THEN
      IF DIALOG_BUTTON(BTN) THEN
       SCENE_STATE=G_SCENE_END
       RETURN
      ENDIF
     ENDIF
    ENDIF
   ENDIF
  WEND

  IF COMMAND$=="" THEN CONTINUE

  MOVE=PARSE_MOVE(COMMAND$, B_PIECE_SIDE,B_PIECES,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM)

  IF MOVE==G_EMPTY THEN
   ? "Illegal move"

   IF BEEP_ON THEN BEEP G_BEEP_ERR_NUM

   L=LEN(B_RECORD_MOVE)
   IF L==0 THEN
    BG_HIGHLIGHT120=NO_SQ
    SQ=NO_SQ
   ELSE
    SQ=MOVE_TOSQ(B_RECORD_MOVE[L-1])
   ENDIF

   DRAW_PIECES B_PIECES,SQ
  ELSE
   L=LEN(B_RECORD_MOVE)+1

   PLY_MOVE_FROM_PRINT L,B_PIECE_SIDE[0],B_PIECES,MOVE
   PIECE=B_PIECES[MOVE_FROMSQ(MOVE)]

   NO_ATTACKED=MAKE_MOVE(MOVE, B_PIECE_SIDE,B_PIECES,B_BIG_PIECE,B_MAJ_PIECE,B_MIN_PIECE,B_MATERIAL_PIECE,B_KING_SQ,B_PIECE_LIST,B_PIECE_NUM,B_ENPAS,B_CASTLE_PERM,B_FIFTY_MOVE,B_RECORD_MOVE,B_RECORD_ENPAS,B_RECORD_CASTLE_PERM,B_RECORD_FIFTY_MOVE)

   IF NO_ATTACKED==FALSE THEN
    ? "Illegal move: Attaked king:";SIDE_CHAR$[PIECE_COL[PIECE]];PIECE_CHAR$[PIECE]

    IF BEEP_ON THEN BEEP G_BEEP_ERR_NUM

    L=LEN(B_RECORD_MOVE)
    IF L==0 THEN
     BG_HIGHLIGHT120=NO_SQ
     SQ=NO_SQ
    ELSE
     SQ=MOVE_TOSQ(B_RECORD_MOVE[L-1])
    ENDIF

    DRAW_PIECES B_PIECES,SQ

    CONTINUE
   ENDIF

   INC PLY
   PRINT_PLY_WINDOW PLY,0

  ENDIF
 
 WEND
 
END

'
' STKANDBTN
'
DEF INIT_STKANDBTN
 BTBAK=0 'BACKUP(GLOBAL)
 BTCNT=0 'COUNT(GLOBAL)
END

'
' SCENE
'
DEF INIT_SCENE

 G_SCENE_PLAY=0
 G_SCENE_NEW=1
 G_SCENE_RECORD=2
 G_SCENE_END=3
 G_SCENE_LOOP=4

 SCENE_STATE=G_SCENE_PLAY

END

'
' CONSTANT
'
DEF INIT_CONSTANT
 G_BOARD_NUM=120
 G_EMPTY=0
 G_WP=1:G_WN=2:G_WB=3:G_WR=4:G_WQ=5:G_WK=6
 G_BP=7:G_BN=8:G_BB=9:G_BR=10:G_BQ=11:G_BK=12
 '
 FILE_A=0:FILE_B=1:FILE_C=2:FILE_D=3:FILE_E=4
 FILE_F=5:FILE_G=6:FILE_H=7:FILE_NONE=8
 '
 RANK_1=0:RANK_2=1:RANK_3=2:RANK_4=3:RANK_5=4
 RANK_6=5:RANK_7=6:RANK_8=7:RANK_NONE=8
 '
 G_WHITE=0:G_BLACK=1:G_BOTH=2
 '
 G_A1=21:G_A2=31:G_A3=41:G_A4=51
 G_A5=61:G_A6=71:G_A7=81:G_A8=91
 '
 G_B1=22:G_B2=32:G_B3=42:G_B4=52
 G_B5=62:G_B6=72:G_B7=82:G_B8=92
 '
 G_C1=23:G_C2=33:G_C3=43:G_C4=53
 G_C5=63:G_C6=73:G_C7=83:G_C8=93
 '
 G_D1=24:G_D2=34:G_D3=44:G_D4=54
 G_D5=64:G_D6=74:G_D7=84:G_D8=94
 '
 G_E1=25:G_E2=35:G_E3=45:G_E4=55
 G_E5=65:G_E6=75:G_E7=85:G_E8=95
 '
 G_F1=26:G_F2=36:G_F3=46:G_F4=56
 G_F5=66:G_F6=76:G_F7=86:G_F8=96
 '
 G_G1=27:G_G2=37:G_G3=47:G_G4=57
 G_G5=67:G_G6=77:G_G7=87:G_G8=97
 '
 G_H1=28:G_H2=38:G_H3=48:G_H4=58
 G_H5=68:G_H6=78:G_H7=88:G_H8=98
 '
 NO_SQ=99:OFFBOARD=100

 MFLAG_EP  =  &H40000
 MFLAG_PS  =  &H80000
 MFLAG_CA  =&H1000000
 MFLAG_CAP =  &H7C000
 MFLAG_PROM= &HF00000

 WK_CA=&B0001
 WQ_CA=&B0010
 BK_CA=&B0100
 BQ_CA=&B1000

 NO_MOVE=0

 G_GAME_CONTINUE=0
 G_GAME_WHITE_WIN=1
 G_GAME_BLACK_WIN=2
 G_GAME_MATERIAL_DRAW=3
 G_GAME_STALEMATE=4
 G_GAME_FIFTY_MOVE=5

 INFINITE=30000

 G_USER=0
 G_ENGINE=1

 G_EVAL_MATERIAL=0
 G_EVAL_TABLE=1

 PAUSE_WAIT=12

 LC_EN=0
 LC_JA=1

 G_DIALOG_CAPTION=0
 G_DIALOG_TEXT=1
 G_DIALOG_OTHER=2

 G_DIALOG_RESULT=0
 G_DIALOG_GAME=1

END

'
' DATA
'
DEF INIT_DATA
 VAR I
 
 PIECE_CHAR$=".PNBRQKpnbrqk"
 SIDE_CHAR$="wb-"
 RANK_CHAR$="12345678"
 FILE_CHAR$="abcdefgh"

 RESTORE @PARSE
 READ START_FEN$
 FOR I=0 TO 14
  READ TEST_FEN$[I]
 NEXT

 RESTORE @DATA
 FOR I=0 TO 12
  READ PIECE_BIG[I]
 NEXT

 FOR I=0 TO 12
  READ PIECE_MAJ[I]
 NEXT
 FOR I=0 TO 12
  READ PIECE_MIN[I]
 NEXT

 FOR I=0 TO 12
  READ PIECE_VAL[I]
 NEXT

 FOR I=0 TO 12
  READ PIECE_COL[I]
 NEXT

 RESTORE @DATA_PIECE
 FOR I=0 TO 12
  READ PIECE_PAWN[I]
 NEXT

 FOR I=0 TO 12
  READ PIECE_KNIGHT[I]
 NEXT

 FOR I=0 TO 12
  READ PIECE_KING[I]
 NEXT

 FOR I=0 TO 12
  READ PIECE_ROOK_QUEEN[I]
 NEXT

 FOR I=0 TO 12
  READ PIECE_BISHOP_QUEEN[I]
 NEXT

 FOR I=0 TO 12
  READ PIECE_SLIDES[I]
 NEXT

 FOR I=0 TO 63
  READ MIRROR_64[I]
 NEXT

 FOR I=0 TO 63
  READ FLIP_64[I]
 NEXT

END

@PARSE
 ' START_FEN$
 DATA "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1" 
 ' TEST_FEN$[15]
 '  0
 DATA "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1" 
 '  1
 DATA "rnbqkbnr/P7/8/8/8/8/8/RNBQKBNR w KQkq - 0 1" 
 '  2
 DATA "r3k2r/1B2r1Pp/8/pP6/1Pp5/8/4Q1pP/R3K2R w KQkq a6 0 1" 
 '  3
 DATA "rn2kbnr/8/8/8/8/8/8/RNB1KBNR w KQkq - 0 1"
 '  4
 DATA "r3k2r/6r1/8/8/8/8/8/R3K2R w KQkq - 0 1"
 '  5
 '  Insufficient material
 DATA "2b1k3/8/8/8/8/8/8/1N2K3 w - - 0 1"
 '  6
 '  Stalemate
 DATA "4k3/8/4K3/8/8/p7/P7/1N1R1R2 b - - 0 1"
 '  7
 DATA "2k5/6RR/2K5/8/8/p7/P7/8 w - - 0 1"
 '  8
 DATA "8/7R/8/8/2kn4/p1n14/P4b2/2K5 w - - 0 1"
 '  9
 DATA "4k3/8/N7/8/8/5q1n/8/4K1N1 w - - 0 1"
 '
 ' 10
 DATA "k7/2K5/8/8/1N6/5N2/8/8 w - - 0 1"
 ' 11
 DATA "kq6/p7/8/8/8/8/P7/K1Q5 w - - 0 1"
 ' 12
 DATA "4k3/8/4K3/8/8/p7/P7/1N1R1R2 b - - 0 1"
 ' 13
 DATA "2k5/6RR/2K5/8/8/p7/P7/8 w - - 0 1"
 ' 14
 DATA "8/7R/8/8/2kn4/p1n1b3/P7/2K5 w - - 0 1"

@DATA
 ' PIECE_BIG
 DATA FALSE
 DATA FALSE,TRUE,TRUE,TRUE,TRUE,TRUE
 DATA FALSE,TRUE,TRUE,TRUE,TRUE,TRUE
 ' PIECE_MAJ
 DATA FALSE
 DATA FALSE,FALSE,FALSE,TRUE,TRUE,TRUE
 DATA FALSE,FALSE,FALSE,TRUE,TRUE,TRUE
 ' PIECE_MIN
 DATA FALSE
 DATA FALSE,TRUE,TRUE,FALSE,FALSE,FALSE
 DATA FALSE,TRUE,TRUE,FALSE,FALSE,FALSE
 ' PIECE_VAL
 DATA 0
 DATA 100,325,325,550,1000,50000
 DATA 100,325,325,550,1000,50000
 ' PIECE_COL
 DATA 2,0,0,0,0,0,0,1,1,1,1,1,1
@DATA_PIECE
 ' PIECE_PAWN
 DATA FALSE
 DATA TRUE,FALSE,FALSE,FALSE,FALSE,FALSE
 DATA TRUE,FALSE,FALSE,FALSE,FALSE,FALSE
 ' PIECE_KNIGHT
 DATA FALSE
 DATA FALSE,TRUE,FALSE,FALSE,FALSE,FALSE
 DATA FALSE,TRUE,FALSE,FALSE,FALSE,FALSE
 ' PIECE_KING
 DATA FALSE
 DATA FALSE,FALSE,FALSE,FALSE,FALSE,TRUE
 DATA FALSE,FALSE,FALSE,FALSE,FALSE,TRUE
 ' PIECE_ROOK_QUEEN
 DATA FALSE
 DATA FALSE,FALSE,FALSE,TRUE,TRUE,FALSE
 DATA FALSE,FALSE,FALSE,TRUE,TRUE,FALSE
 ' PIECE_BISHOP_QUEEN
 DATA FALSE
 DATA FALSE,FALSE,TRUE,FALSE,TRUE,FALSE
 DATA FALSE,FALSE,TRUE,FALSE,TRUE,FALSE
 ' PIECE_SLIDES
 DATA FALSE
 DATA FALSE,FALSE,TRUE,TRUE,TRUE,FALSE
 DATA FALSE,FALSE,TRUE,TRUE,TRUE,FALSE
 ' MIRROR_64[64]
 DATA 56,57,58,59,60,61,62,63
 DATA 48,49,50,51,52,53,54,55
 DATA 40,41,42,43,44,45,46,47
 DATA 32,33,34,35,36,37,38,39
 DATA 24,25,26,27,28,29,30,31
 DATA 16,17,18,19,20,21,22,23
 DATA  8, 9,10,11,12,13,14,15
 DATA  0, 1, 2, 3, 4, 5, 6, 7
 ' FLIP_64[64]
 DATA 63,62,61,60,59,58,57,56
 DATA 55,54,53,52,51,50,49,48
 DATA 47,46,45,44,43,42,41,40
 DATA 39,38,37,36,35,34,33,32
 DATA 31,30,29,28,27,26,25,24
 DATA 23,22,21,20,19,18,17,16
 DATA 15,14,13,12,11,10, 9, 8
 DATA  7, 6, 5, 4, 3, 2, 1, 0

'
' DATA MOVE 
'
DEF INIT_MOVE
 VAR I,J

 RESTORE @MOVE
 FOR I=0 TO 7
  READ LOOP_SLIDE_PIECE[I]
 NEXT

 FOR I=0 TO 5
  READ LOOP_NONSLIDE_PIECE[I]
 NEXT

 FOR I=0 TO 1
  READ LOOP_SLIDE_INDEX[I]
 NEXT
 
 FOR I=0 TO 1
  READ LOOP_NONSLIDE_INDEX[I]
 NEXT

 FOR I=G_EMPTY TO G_BK
  FOR J=0 TO 7
   READ PIECE_DIR[I,J]
  NEXT
 NEXT
 
 FOR I=G_EMPTY TO G_BK
  READ PIECE_NUM_DIR[I]
 NEXT

 FOR I=G_EMPTY TO G_BK
  READ VICTIM_SCORE[I]
 NEXT
 
 FOR I=G_WP TO G_BK
  FOR J=G_WP TO G_BK
   MVV_LVA_SCORES[J,I]=VICTIM_SCORE[J]+6-(VICTIM_SCORE[I]/100)
  NEXT
 NEXT
 
END
'
@MOVE
' LOOP_SLIDE_PCE[8]
DATA 3,4,5,0,9,10,11,0
' LOOP_NONSLIDE_PCE[6]
DATA 2,6,0,8,12,0
' LOOP_SLIDE_INDEX[2]
DATA 0,4
' LOOP_NONSLIDE_INDEX[2]
DATA 0,3
' PIECE_DIR[13][8]
DATA  0,  0,  0,  0, 0,  0, 0, 0
DATA  0,  0,  0,  0, 0,  0, 0, 0
DATA -8,-19,-21,-12, 8, 19,21,12
DATA -9,-11, 11,  9, 0,  0, 0, 0
DATA -1,-10,  1, 10, 0,  0, 0, 0
DATA -1,-10,  1, 10,-9,-11,11, 9
DATA -1,-10,  1, 10,-9,-11,11, 9
DATA  0,  0,  0,  0, 0,  0, 0, 0
DATA -8,-19,-21,-12, 8, 19,21,12
DATA -9,-11, 11,  9, 0,  0, 0, 0
DATA -1,-10,  1, 10, 0,  0, 0, 0
DATA -1,-10,  1, 10,-9,-11,11, 9
DATA -1,-10,  1, 10,-9,-11,11, 9
' PIECE_NUM_DIR[13]
DATA 0
DATA 0,8,4,4,8,8
DATA 0,8,4,4,8,8
' VICTIM_SCORE[13]
DATA 0
DATA 100,200,300,400,500,600
DATA 100,200,300,400,500,600

'
' DATA ATTACK
'
DEF INIT_ATTACK
 VAR I
 RESTORE @ATTACK
 FOR I=0 TO 7
  READ KN_DIR[I]
 NEXT

 FOR I=0 TO 3
 READ RK_DIR[I]
 NEXT

 FOR I=0 TO 3
 READ BI_DIR[I]
 NEXT

 FOR I=0 TO 7
 READ KI_DIR[I]
 NEXT
END

@ATTACK
' KN_DIR[8]
DATA -8,-19,-21,-12, 8, 19,21,12
' RK_DIR[4]
DATA -1,-10,  1, 10
' BI_DIR[4]
DATA -9,-11, 11,  9
' KI_DIR[8]
DATA -1,-10,  1, 10,-9,-11, 9,11

'
' DATA EVALUATE
'
DEF INIT_EVALUATE
 VAR I
 
 RESTORE @EVALUATE
 FOR I=0 TO 63
  READ PAWN_TABLE[I]
 NEXT

 FOR I=0 TO 63
  READ KNIGHT_TABLE[I]
 NEXT
 
 FOR I=0 TO 63
  READ BISHOP_TABLE[I]
 NEXT
 
 FOR I=0 TO 63
  READ ROOK_TABLE[I]
 NEXT
 
 FOR I=0 TO 63
  READ KING_E[I]
 NEXT
 
 FOR I=0 TO 63
  READ KING_O[I]
 NEXT

 END_GAME_MAT=1*PIECE_VAL[G_WR]+2*PIECE_VAL[G_WN]+2*PIECE_VAL[G_WP]+PIECE_VAL[G_WK]

 BISHOP_PAIR=30
 
 EVAL_MODE=G_EVAL_MATERIAL
 
END

@EVALUATE
' PAWN_TABLE[64]
DATA  0,  0,  0,  0,  0,  0,  0,  0
DATA 10, 10,  0,-10,-10,  0, 10, 10
DATA  5,  0,  0,  5,  5,  0,  0,  5
DATA  0,  0, 10, 20, 20, 10,  0,  0
DATA  5,  5,  5, 10, 10,  5,  5,  5
DATA 10, 10, 10, 20, 20, 10, 10, 10
DATA 20, 20, 20, 30, 30, 20, 20, 20
DATA  0,  0,  0,  0,  0,  0,  0,  0
' KNIGHT_TABLE[64]
DATA  0,-10,  0,  0,  0,  0,-10,  0
DATA  0,  0,  0,  5,  5,  0,  0,  0
DATA  0,  0, 10, 10, 10, 10,  0,  0
DATA  0,  0, 10, 20, 20, 10,  5,  0
DATA  5, 10, 15, 20, 20, 15, 10,  5
DATA  5, 10, 10, 20, 20, 10, 10,  5
DATA  0,  0,  5, 10, 10,  5,  0,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0
' BISHOP_TABLE[64]
DATA  0,  0,-10,  0,  0,-10,  0,  0
DATA  0,  0,  0, 10, 10,  0,  0,  0
DATA  0,  0, 10, 15, 15, 10,  0,  0
DATA  0, 10, 15, 20, 20, 15, 10,  0
DATA  0, 10, 15, 20, 20, 15, 10,  0
DATA  0,  0, 10, 15, 15, 10,  0,  0
DATA  0,  0,  0, 10, 10,  0,  0,  0
DATA  0,  0,  0,  0,  0,  0,  0,  0
' ROOK_TABLE[64]
DATA  0,  0,  5, 10, 10,  5,  0,  0
DATA  0,  0,  5, 10, 10,  5,  0,  0
DATA  0,  0,  5, 10, 10,  5,  0,  0
DATA  0,  0,  5, 10, 10,  5,  0,  0
DATA  0,  0,  5, 10, 10,  5,  0,  0
DATA  0,  0,  5, 10, 10,  5,  0,  0
DATA 25, 25, 25, 25, 25, 25, 25, 25
DATA  0,  0,  5, 10, 10,  5,  0,  0
' KING_E[64]
DATA -50,-10,  0,  0,  0,  0,-10,-50
DATA -10,  0, 10, 10, 10, 10,  0,-10
DATA   0, 10, 20, 20, 20, 20, 10,  0
DATA   0, 10, 20, 40, 40, 20, 10,  0
DATA   0, 10, 20, 40, 40, 20, 10,  0
DATA   0, 10, 20, 20, 20, 20, 10,  0
DATA -10,  0, 10, 10, 10, 10,  0,-10
DATA -50,-10,  0,  0,  0,  0,-10,-50
' KING_Q[64]
DATA   0,  5,  5,-10,-10,  0, 10,  5
DATA -30,-30,-30,-30,-30,-30,-30,-30
DATA -50,-50,-50,-50,-50,-50,-50,-50
DATA -70,-70,-70,-70,-70,-70,-70,-70
DATA -70,-70,-70,-70,-70,-70,-70,-70
DATA -70,-70,-70,-70,-70,-70,-70,-70
DATA -70,-70,-70,-70,-70,-70,-70,-70
DATA -70,-70,-70,-70,-70,-70,-70,-70

'
'
'
DEF INIT_SQ
 VAR I,J,R,F
 VAR SQ
 VAR SQ64
 
 SQ64=0
 FOR I=0 TO 119
  SQ120TOSQ64[I]=65
 NEXT
 
 FOR R=0 TO 7
  FOR F=0 TO 7
   SQ=FR2SQ120(F,R)
   SQ64TOSQ120[SQ64]=SQ
   SQ120TOSQ64[SQ]=SQ64
   INC SQ64
  NEXT
 NEXT

 FOR I=0 TO 119
  FILES_BOARD[I]=OFFBOARD
  RANKS_BOARD[I]=OFFBOARD
 NEXT
 
 FOR R=RANK_1 TO RANK_8
  FOR F=FILE_A TO FILE_H
   SQ=FR2SQ120(F,R)
   FILES_BOARD[SQ]=F
   RANKS_BOARD[SQ]=R
  NEXT
 NEXT

 FOR I=0 TO 119
  CASTLE_PERM[I]=&B1111
 NEXT
 
 CASTLE_PERM[G_A1]=&B1101
 CASTLE_PERM[G_E1]=&B1100
 CASTLE_PERM[G_H1]=&B1110
 
 CASTLE_PERM[G_A8]=&B0111
 CASTLE_PERM[G_E8]=&B0011
 CASTLE_PERM[G_H8]=&B1011

END

'
'
'
DEF INIT_DIALOG
 VAR I,J,K,L,NUM
 VAR TEXT$,TEMP$

 RESTORE @BUTTON
 FOR I=G_BUTTON_NEW TO G_BUTTON_QUIT
  FOR K=LC_EN TO LC_JA
   READ G_BUTTON$[I,G_DIALOG_CAPTION,K]
  NEXT

  FOR J=G_DIALOG_TEXT TO G_DIALOG_OTHER
   FOR K=LC_EN TO LC_JA
    READ NUM
    TEMP$=""
    FOR L=0 TO NUM-1
     READ TEXT$
     TEMP$=TEMP$+TEXT$+CHR$(13)
    NEXT
    G_BUTTON$[I,J,K]=TEMP$
   NEXT
  NEXT
 NEXT

 RESTORE @RESULT
 FOR I=G_GAME_CONTINUE TO G_GAME_FIFTY_MOVE
  FOR J=G_DIALOG_RESULT TO G_DIALOG_GAME
   FOR K=LC_EN TO LC_JA
    READ G_GAME_RESULT$[I,J,K]
   NEXT
  NEXT
 NEXT

@BUTTON

' NEW
 DATA "New"
 DATA "New"
'
 DATA 2
 DATA "Do you want to set up each player for"
 DATA "a new game?" 
 DATA 1
 DATA "新規ゲームのプレイヤーを設定しますか?"
'
 DATA 3
 DATA "Having chosen a type and a level from"
 DATA "pop-up menus, please tap the play button"
 DATA "to start a game. "
 DATA 2
 DATA "ゲームを始めるには、タイプとレベルの"
 DATA "ポップアップメニューを選択した後、プレーボタンをタッチしてください。"

' PLAY
 DATA "Play"
 DATA "Play"
'
 DATA 1
 DATA "Do you want to play a new game?"
 DATA 1
 DATA "新規のゲームを始めますか?"
 
'
 DATA 2
 DATA "Please press the START button to"
 DATA "stop the playing between machines."
 DATA 2
 DATA "コンピュータ同士の対戦を中断するには、"
 DATA "STARTボタンを押してください。"
 
' UNDO
 DATA "Undo"
 DATA "Undo"
 DATA 1
 DATA ""
 DATA 1
 DATA ""
 DATA 1
 DATA ""
 DATA 1
 DATA ""

' FLIP
 DATA "Flip"
 DATA "Flip"
 DATA 1
 DATA ""
 DATA 1
 DATA ""
 DATA 1
 DATA ""
 DATA 1
 DATA ""

' RESIGN
 DATA "Resign"
 DATA "Resign"
'
 DATA 1
 DATA "Are you sure you want to resign?"
 DATA 1
 DATA "本当にリザインしますか?"
'
 DATA 1
 DATA ""
 DATA 1
 DATA "" 

' QUIT
 DATA "Quit"
 DATA "Quit"
'
 DATA 1
 DATA "Are you sure you want to quit?"
 DATA 1
 DATA "本当に終了しますか?"
'
 DATA 1
 DATA ""
 DATA 1
 DATA "" 

@RESULT
' CONTINUE
 DATA "",""
 DATA "",""
' WHITE_WIN
 DATA "{White mates} 1-0"
 DATA "チェックメイト"
 DATA "White Win"
 DATA "白の勝利"
' BLACK_WIN
 DATA "{Black mates} 0-1"
 DATA "チェックメイト"
 DATA "Black Win"
 DATA "黒の勝利"
' MATERIAL_DRAW
 DATA "{Insufficient material} 1/2-1/2"
 DATA "チェックメイトするのに駒が足りません。"
 DATA "Draw"
 DATA "引き分け"
' STALEMATE
 DATA "{Stalemate} 1/2-1/2"
 DATA "ステイルメイト"
 DATA "Draw"
 DATA "引き分け"
' FIFTY_MOVE
 DATA "{Fifty move rule} 1/2-1/2"
 DATA "50手ルール"
 DATA "Draw"
 DATA "引き分け"
END

'
'
'
DEF INIT_SOUND
 BEEP_ON=TRUE

 G_BEEP_ERR_NUM=0
' G_BEEP_ERR_NUM=2

END

'
'
'
DEF INIT_PLAYER

 SET_PLAYER_LEVEL G_WHITE,G_USER,1
' SET_PLAYER_LEVEL G_WHITE,G_ENGINE,2
' SET_PLAYER_LEVEL G_WHITE,G_ENGINE,3
 SET_PLAYER_LEVEL G_BLACK,G_ENGINE,1
' SET_PLAYER_LEVEL G_BLACK,G_USER,1
' SET_PLAYER_LEVEL G_BLACK,G_USER,4

 G_SIDE$[G_WHITE]="White"
 G_SIDE$[G_BLACK]="Black"
 
 G_PLAYER$[G_USER]="You"
' G_PLAYER$[G_ENGINE]="Computer"
 G_PLAYER$[G_ENGINE]="Machine"
 
 G_PLAYER_LEVEL$="Level:"
 
 G_PLAYER_EVAL$[G_EVAL_MATERIAL]="Material"
 G_PLAYER_EVAL$[G_EVAL_TABLE]="Table"
 
 G_PLAYER_DEPTH$="Depth:"

END

'
'
'
DEF SET_PLAYER_LEVEL SIDE, SPLAYER, LEVEL
 VAR EVAL
 VAR DEPTH

 IF LEVEL==1 THEN
  EVAL=G_EVAL_MATERIAL
  DEPTH=1
 ELSEIF LEVEL==2 THEN
  EVAL=G_EVAL_MATERIAL
  DEPTH=2
 ELSEIF LEVEL==3 THEN
  EVAL=G_EVAL_TABLE
  DEPTH=2
 ELSEIF LEVEL==4 THEN
  EVAL=G_EVAL_MATERIAL
  DEPTH=3
 ELSEIF LEVEL==5 THEN
  EVAL=G_EVAL_TABLE
  DEPTH=3
 ELSE 
  EVAL=G_EVAL_MATERIAL
  DEPTH=1
 ENDIF

 PLAYER[SIDE]=SPLAYER
 PLAYER_LEVEL[SIDE]=LEVEL
 PLAYER_EVAL[SIDE]=EVAL
 PLAYER_DEPTH[SIDE]=DEPTH
END

'
'
'
DEF SQ_OFF_BOARD(SQ)
 VAR F
 F=FILES_BOARD[SQ]
 IF F==OFFBOARD THEN
  RETURN TRUE
 ELSE
  RETURN FALSE
 ENDIF
END

'
'
'
DEF BIT_MOVE(SQ_FROM,SQ_TO,CAPTURED,PROMOTED,FLAG)
 VAR MOVE
 MOVE=0
 MOVE = MOVE OR SQ_FROM
 MOVE = MOVE OR (SQ_TO << 7)
 MOVE = MOVE OR (CAPTURED << 14)
 MOVE = MOVE OR (PROMOTED << 20)
 MOVE = MOVE OR FLAG
 RETURN MOVE
END

'
'
'
DEF MOVE_FROMSQ(MOVE)
 VAR SQ
 SQ=MOVE AND &H7F
 RETURN SQ
END

'
'
'
DEF MOVE_TOSQ(MOVE)
 VAR SQ
 SQ=(MOVE >> 7) AND &H7F
 RETURN SQ
END

'
'
'
DEF MOVE_CAPTURED(MOVE)
 VAR SQ
 SQ=(MOVE >> 14) AND &HF
 RETURN SQ
END

'
'
'
DEF SQ2FR$(SQ)
 VAR FR$

 FR$=FILE_CHAR$[FILES_BOARD[SQ]]+RANK_CHAR$[RANKS_BOARD[SQ]]

 RETURN FR$
END

'
'
'
DEF MOVE_PROMOTED(MOVE)
 VAR SQ
 SQ=(MOVE >> 20) AND &HF
 RETURN SQ
END

'
'
'
DEF MOVE_PRINT MOVE
 VAR SQ_FROM
 VAR SQ_TO
 VAR CAPTURED
 VAR PROMOTED
 VAR FLAG_EP
 VAR FLAG_PS
 VAR FLAG_CA

 SQ_FROM=MOVE_FROMSQ(MOVE)
 SQ_TO=MOVE_TOSQ(MOVE)
 CAPTURED=MOVE_CAPTURED(MOVE)
 PROMOTED=MOVE_PROMOTED(MOVE)
 FLAG_EP=MOVE AND MFLAG_EP
 FLAG_PS=MOVE AND MFLAG_PS
 FLAG_CA=MOVE AND MFLAG_CA

' ? "MOVE:&H";HEX$(MOVE,7)
' ? "FROM:";SQ120TOSQ64[SQ_FROM];
' ? " TO:";SQ120TOSQ64[SQ_TO];
 ? SQ2FR$(SQ_FROM);SQ2FR$(SQ_TO);
 
 ? " CAPTURE:";SIDE_CHAR$[PIECE_COL[CAPTURED]];
 ? PIECE_CHAR$[CAPTURED];
 ? " PROMOTE:";SIDE_CHAR$[PIECE_COL[PROMOTED]];
 ? PIECE_CHAR$[PROMOTED];
 IF FLAG_EP THEN ? " EP";
 IF FLAG_PS THEN ? " PS";
 IF FLAG_CA THEN ? " CA";
 IF FLAG_EP==FALSE && FLAG_PS==FALSE && FLAG_CA==FALSE THEN ? "   ";
 ?
END

'
'
'
DEF TOUCH_PRINT FR$
 ? "Touch ";FR$
END

'
'
'
DEF PLY_MOVE_FROM_PRINT PLY, SIDE, SQ120, MOVE
 ? FORMAT$("%4D",PLY);" ";
 ? SIDE_CHAR$[SIDE];
 ? PIECE_CHAR$[SQ120[MOVE_FROMSQ(MOVE)]];" ";
   MOVE_PRINT MOVE
END

'
'
'
DEF PLY_MOVE_TO_PRINT PLY, SIDE, SQ120, MOVE
 ? FORMAT$("%4D",PLY);" ";
 ? SIDE_CHAR$[SIDE];
 ? PIECE_CHAR$[SQ120[MOVE_TOSQ(MOVE)]];" ";
   MOVE_PRINT MOVE
END

'
'
'
DEF ADD_QUIET_MOVE MOVE, LIST_MOVE, LIST_SCORE
 PUSH LIST_MOVE, MOVE
 PUSH LIST_SCORE,0
END

'
'
'
DEF ADD_WHITE_PAWN_MOVE SQ_FROM, SQ_TO, LIST_MOVE, LIST_SCORE

 IF RANKS_BOARD[SQ_FROM] == RANK_7 THEN
  ADD_QUIET_MOVE BIT_MOVE(SQ_FROM,SQ_TO,G_EMPTY,G_WQ,0), LIST_MOVE, LIST_SCORE
  ADD_QUIET_MOVE BIT_MOVE(SQ_FROM,SQ_TO,G_EMPTY,G_WR,0), LIST_MOVE, LIST_SCORE
  ADD_QUIET_MOVE BIT_MOVE(SQ_FROM,SQ_TO,G_EMPTY,G_WB,0), LIST_MOVE, LIST_SCORE
  ADD_QUIET_MOVE BIT_MOVE(SQ_FROM,SQ_TO,G_EMPTY,G_WN,0), LIST_MOVE, LIST_SCORE 
 ELSE
  ADD_QUIET_MOVE BIT_MOVE(SQ_FROM,SQ_TO,G_EMPTY,G_EMPTY,0), LIST_MOVE, LIST_SCORE
 ENDIF
END

'
'
'
DEF ADD_CAPTURE_MOVE MOVE, LIST_MOVE, LIST_SCORE
 PUSH LIST_MOVE, MOVE
 PUSH LIST_SCORE,0
 
END

'
'
'
DEF ADD_ENPASSANT_MOVE MOVE, LIST_MOVE, LIST_SCORE
 PUSH LIST_MOVE, MOVE
 PUSH LIST_SCORE,0
 

END

'
'
'
DEF ADD_WHITE_PAWN_CAP_MOVE SQ_FROM, SQ_TO, CAPTURE, LIST_MOVE, LIST_SCORE
 
 IF RANKS_BOARD[SQ_FROM] == RANK_7 THEN

  ADD_CAPTURE_MOVE BIT_MOVE(SQ_FROM,SQ_TO,CAPTURE,G_WQ,0), LIST_MOVE, LIST_SCORE 
  ADD_CAPTURE_MOVE BIT_MOVE(SQ_FROM,SQ_TO,CAPTURE,G_WR,0), LIST_MOVE, LIST_SCORE 
  ADD_CAPTURE_MOVE BIT_MOVE(SQ_FROM,SQ_TO,CAPTURE,G_WB,0), LIST_MOVE, LIST_SCORE 
  ADD_CAPTURE_MOVE BIT_MOVE(SQ_FROM,SQ_TO,CAPTURE,G_WN,0), LIST_MOVE, LIST_SCORE 
 ELSE
  ADD_CAPTURE_MOVE BIT_MOVE(SQ_FROM,SQ_TO,CAPTURE,G_EMPTY,0), LIST_MOVE, LIST_SCORE  
 ENDIF  
END

'
'
'
DEF WHITE_PAWN_ALL_MOVES SIDE, SQ120, LIST, NUM, ENPAS, PERM, LIST_MOVE, LIST_SCORE

 IF (SIDE[0]==G_BLACK || SIDE[0]==G_BOTH) THEN RETURN

 VAR SQ
 VAR I
 
 FOR I=0 TO NUM[G_WP]-1
  SQ=LIST[G_WP,I]
'  ? SQ120TOSQ64[SQ];" ";
  IF SQ120[SQ + 10] == G_EMPTY THEN
   ADD_WHITE_PAWN_MOVE SQ, SQ+10, LIST_MOVE, LIST_SCORE
   IF RANKS_BOARD[SQ]==RANK_2 && SQ120[SQ + 20] == G_EMPTY THEN
      ADD_QUIET_MOVE BIT_MOVE(SQ,SQ+20,G_EMPTY,G_EMPTY,MFLAG_PS), LIST_MOVE, LIST_SCORE
   ENDIF
  ENDIF
  
  IF SQ_OFF_BOARD(SQ+9)==FALSE && PIECE_COL[SQ120[SQ+9]]==G_BLACK THEN
   ADD_WHITE_PAWN_CAP_MOVE SQ, SQ+9, SQ120[SQ + 9], LIST_MOVE, LIST_SCORE
   
  ENDIF 

  IF SQ_OFF_BOARD(SQ+11)==FALSE && PIECE_COL[SQ120[SQ+11]]==G_BLACK THEN
   ADD_WHITE_PAWN_CAP_MOVE SQ, SQ+11, SQ120[SQ + 11], LIST_MOVE, LIST_SCORE
   
  ENDIF 
  
  IF ENPAS[0]!=NO_SQ THEN
   IF (SQ+9)==ENPAS[0] THEN 
    ADD_ENPASSANT_MOVE BIT_MOVE(SQ,SQ+9,G_EMPTY,G_EMPTY,MFLAG_EP), LIST_MOVE, LIST_SCORE
   ENDIF
   
   IF (SQ+11)==ENPAS[0] THEN 
    ADD_ENPASSANT_MOVE BIT_MOVE(SQ,SQ+11,G_EMPTY,G_EMPTY,MFLAG_EP), LIST_MOVE, LIST_SCORE
   ENDIF
  ENDIF
  
 NEXT

 IF PERM[0] AND WK_CA THEN
  IF SQ120[G_F1]==G_EMPTY && SQ120[G_G1]==G_EMPTY THEN
   IF SQ_ATTACKED(G_E1,G_BLACK,SQ120)==FALSE && SQ_ATTACKED(G_F1,G_BLACK,SQ120)==FALSE THEN
    ADD_QUIET_MOVE BIT_MOVE(G_E1,G_G1,G_EMPTY,G_EMPTY,MFLAG_CA), LIST_MOVE, LIST_SCORE
   ENDIF
  ENDIF
 ENDIF

 IF PERM[0] AND WQ_CA THEN
  IF SQ120[G_D1]==G_EMPTY && SQ120[G_C1]==G_EMPTY && SQ120[G_B1]==G_EMPTY THEN
   IF SQ_ATTACKED(G_E1,G_BLACK,SQ120)==FALSE && SQ_ATTACKED(G_D1,G_BLACK,SQ120)==FALSE THEN
    ADD_QUIET_MOVE BIT_MOVE(G_E1,G_C1,G_EMPTY,G_EMPTY,MFLAG_CA), LIST_MOVE, LIST_SCORE
   ENDIF
  ENDIF
 ENDIF

END

'
'
'
DEF ADD_BLACK_PAWN_MOVE SQ_FROM, SQ_TO, LIST_MOVE, LIST_SCORE

 IF RANKS_BOARD[SQ_FROM] == RANK_2 THEN
  ADD_QUIET_MOVE BIT_MOVE(SQ_FROM,SQ_TO,G_EMPTY,G_BQ,0), LIST_MOVE, LIST_SCORE
  ADD_QUIET_MOVE BIT_MOVE(SQ_FROM,SQ_TO,G_EMPTY,G_BR,0), LIST_MOVE, LIST_SCORE
  ADD_QUIET_MOVE BIT_MOVE(SQ_FROM,SQ_TO,G_EMPTY,G_BB,0), LIST_MOVE, LIST_SCORE
  ADD_QUIET_MOVE BIT_MOVE(SQ_FROM,SQ_TO,G_EMPTY,G_BN,0), LIST_MOVE, LIST_SCORE 
 ELSE
  ADD_QUIET_MOVE BIT_MOVE(SQ_FROM,SQ_TO,G_EMPTY,G_EMPTY,0), LIST_MOVE, LIST_SCORE
 ENDIF
END

'
'
'
DEF ADD_BLACK_PAWN_CAP_MOVE SQ_FROM, SQ_TO, CAPTURE, LIST_MOVE, LIST_SCORE
 
 IF RANKS_BOARD[SQ_FROM] == RANK_2 THEN

  ADD_CAPTURE_MOVE BIT_MOVE(SQ_FROM,SQ_TO,CAPTURE,G_BQ,0), LIST_MOVE, LIST_SCORE 
  ADD_CAPTURE_MOVE BIT_MOVE(SQ_FROM,SQ_TO,CAPTURE,G_BR,0), LIST_MOVE, LIST_SCORE 
  ADD_CAPTURE_MOVE BIT_MOVE(SQ_FROM,SQ_TO,CAPTURE,G_BB,0), LIST_MOVE, LIST_SCORE 
  ADD_CAPTURE_MOVE BIT_MOVE(SQ_FROM,SQ_TO,CAPTURE,G_BN,0), LIST_MOVE, LIST_SCORE 
 ELSE
  ADD_CAPTURE_MOVE BIT_MOVE(SQ_FROM,SQ_TO,CAPTURE,G_EMPTY,0), LIST_MOVE, LIST_SCORE  
 ENDIF  
END

'
'
'
DEF BLACK_PAWN_ALL_MOVES SIDE, SQ120, LIST, NUM, ENPAS, PERM, LIST_MOVE, LIST_SCORE

 IF (SIDE[0]==G_WHITE || SIDE[0]==G_BOTH) THEN RETURN

 VAR SQ
 VAR I
 
 FOR I=0 TO NUM[G_BP]-1
  SQ=LIST[G_BP,I]
'  ? SQ120TOSQ64[SQ];" ";
  IF SQ120[SQ - 10] == G_EMPTY THEN
   ADD_BLACK_PAWN_MOVE SQ, SQ-10, LIST_MOVE, LIST_SCORE
   IF RANKS_BOARD[SQ]==RANK_7 && SQ120[SQ - 20] == G_EMPTY THEN
      ADD_QUIET_MOVE BIT_MOVE(SQ,SQ-20,G_EMPTY,G_EMPTY,MFLAG_PS), LIST_MOVE, LIST_SCORE
   ENDIF
  ENDIF

  IF SQ_OFF_BOARD(SQ-9)==FALSE && PIECE_COL[SQ120[SQ-9]]==G_WHITE THEN
   ADD_BLACK_PAWN_CAP_MOVE SQ, SQ-9, SQ120[SQ-9], LIST_MOVE, LIST_SCORE
   
  ENDIF 

  IF SQ_OFF_BOARD(SQ-11)==FALSE && PIECE_COL[SQ120[SQ-11]]==G_WHITE THEN
   ADD_BLACK_PAWN_CAP_MOVE SQ, SQ-11, SQ120[SQ-11], LIST_MOVE, LIST_SCORE
   
  ENDIF 

  IF ENPAS[0]!=NO_SQ THEN
   IF (SQ-9)==ENPAS[0] THEN 
    ADD_ENPASSANT_MOVE BIT_MOVE(SQ,SQ-9,G_EMPTY,G_EMPTY,MFLAG_EP), LIST_MOVE, LIST_SCORE
   ENDIF
   
   IF (SQ-11)==ENPAS[0] THEN 
    ADD_ENPASSANT_MOVE BIT_MOVE(SQ,SQ-11,G_EMPTY,G_EMPTY,MFLAG_EP), LIST_MOVE, LIST_SCORE
   ENDIF
  ENDIF

 NEXT

 IF PERM[0] AND BK_CA THEN
  IF SQ120[G_F8]==G_EMPTY && SQ120[G_G8]==G_EMPTY THEN
   IF SQ_ATTACKED(G_E8,G_WHITE,SQ120)==FALSE && SQ_ATTACKED(G_F8,G_WHITE,SQ120)==FALSE THEN
    ADD_QUIET_MOVE BIT_MOVE(G_E8,G_G8,G_EMPTY,G_EMPTY,MFLAG_CA), LIST_MOVE, LIST_SCORE
   ENDIF
  ENDIF
 ENDIF

 IF PERM[0] AND BQ_CA THEN
  IF SQ120[G_D8]==G_EMPTY && SQ120[G_C8]==G_EMPTY && SQ120[G_B8]==G_EMPTY THEN
   IF SQ_ATTACKED(G_E8,G_WHITE,SQ120)==FALSE && SQ_ATTACKED(G_D8,G_WHITE,SQ120)==FALSE THEN
    ADD_QUIET_MOVE BIT_MOVE(G_E8,G_C8,G_EMPTY,G_EMPTY,MFLAG_CA), LIST_MOVE, LIST_SCORE
   ENDIF
  ENDIF
 ENDIF

END

'
'
'
DEF GENERATE_ALL_MOVES SIDE, SQ120, LIST, NUM, ENPAS, PERM, LIST_MOVE, LIST_SCORE
 VAR PIECE
 VAR I,J,S
 VAR SQ,T_SQ
 VAR DIR


 WHITE_PAWN_ALL_MOVES SIDE, SQ120, LIST, NUM, ENPAS, PERM, LIST_MOVE, LIST_SCORE

 BLACK_PAWN_ALL_MOVES SIDE, SQ120, LIST, NUM, ENPAS, PERM, LIST_MOVE, LIST_SCORE

 IF SIDE[0]==G_BOTH THEN RETURN

'LOOP FOR SLIDE PIECES
 S=LOOP_SLIDE_INDEX[SIDE[0]]
 PIECE=LOOP_SLIDE_PIECE[S]
 INC S
 
 WHILE PIECE!=0
  FOR I=0 TO NUM[PIECE]-1
   SQ=LIST[PIECE,I]
   FOR J=0 TO PIECE_NUM_DIR[PIECE]-1
    DIR=PIECE_DIR[PIECE,J]
    T_SQ=SQ+DIR
    WHILE SQ120[T_SQ]!=OFFBOARD
     IF SQ120[T_SQ] != G_EMPTY THEN
      IF PIECE_COL[SQ120[T_SQ]] == (SIDE[0] XOR 1) THEN
       ADD_CAPTURE_MOVE BIT_MOVE(SQ,T_SQ,SQ120[T_SQ],G_EMPTY,0), LIST_MOVE, LIST_SCORE 
      ENDIF
      BREAK
     ENDIF
     ADD_QUIET_MOVE BIT_MOVE(SQ,T_SQ,G_EMPTY,G_EMPTY,0), LIST_MOVE, LIST_SCORE
     T_SQ=T_SQ+DIR
    WEND
   NEXT
  NEXT
  PIECE=LOOP_SLIDE_PIECE[S]
  INC S
 WEND

'LOOP FOR NON SLIDE PIECES
 S=LOOP_NONSLIDE_INDEX[SIDE[0]]
 PIECE=LOOP_NONSLIDE_PIECE[S]
 INC S
 
 WHILE PIECE!=0
  FOR I=0 TO NUM[PIECE]-1
   SQ=LIST[PIECE,I]
   FOR J=0 TO PIECE_NUM_DIR[PIECE]-1
    DIR=PIECE_DIR[PIECE,J]
    T_SQ=SQ+DIR

    IF SQ120[T_SQ]==OFFBOARD THEN CONTINUE
    IF SQ120[T_SQ] != G_EMPTY THEN
     IF PIECE_COL[SQ120[T_SQ]] == (SIDE[0] XOR 1) THEN
      ADD_CAPTURE_MOVE BIT_MOVE(SQ,T_SQ,SQ120[T_SQ],G_EMPTY,0), LIST_MOVE, LIST_SCORE 
     ENDIF
     CONTINUE
    ENDIF

    ADD_QUIET_MOVE BIT_MOVE(SQ,T_SQ,G_EMPTY,G_EMPTY,0), LIST_MOVE, LIST_SCORE
     T_SQ=T_SQ+DIR

   NEXT
  NEXT
  PIECE=LOOP_NONSLIDE_PIECE[S]
  INC S
 WEND

END

'
'
'
DEF GENERATE_ASSISTANT_MOVE_LIST SIDE, SQ120, BIG, MAJ, MINI, MATERIAL, KING, LIST, NUM, ENPAS, PERM, FIFTY, ORIGIN
 VAR HIS_MOVE[0]
 VAR HIS_ENPAS[0]
 VAR HIS_PERM[0]
 VAR HIS_FIFTY[0]
 VAR I,L
 VAR SQ
 VAR MOVE
 VAR LIST_MOVE[0]
 VAR LIST_SCORE[0]

 ARRAY_CLEAR BG_MOVE_LIST

 GENERATE_ALL_MOVES SIDE,SQ120,LIST,NUM,ENPAS,PERM,LIST_MOVE,LIST_SCORE

 L=LEN(LIST_MOVE)
 IF L!=0 THEN
  FOR I=0 TO L-1
   MOVE=LIST_MOVE[I]
   SQ=MOVE_FROMSQ(MOVE)
   IF SQ==ORIGIN THEN
    IF MAKE_MOVE(MOVE, SIDE, SQ120, BIG, MAJ, MINI, MATERIAL, KING, LIST, NUM, ENPAS, PERM, FIFTY, HIS_MOVE, HIS_ENPAS, HIS_PERM, HIS_FIFTY)==FALSE THEN CONTINUE
    TAKE_MOVE SIDE, SQ120, BIG, MAJ, MINI, MATERIAL, KING, LIST, NUM, ENPAS, PERM, FIFTY, HIS_MOVE, HIS_ENPAS, HIS_PERM, HIS_FIFTY
    PUSH BG_MOVE_LIST,MOVE_TOSQ(MOVE)
   ENDIF
  NEXT
 ENDIF

END

'
'
'
DEF CLEAR_PIECE SQ, SQ120, BIG, MAJ, MINI, MATERIAL, LIST, NUM
 VAR PIECE
 VAR COL
 VAR I
 VAR T_NUM
 
 T_NUM=-1
 
 PIECE=SQ120[SQ]
 COL=PIECE_COL[PIECE]

 SQ120[SQ]=G_EMPTY
 MATERIAL[COL] = MATERIAL[COL]-PIECE_VAL[PIECE]

 IF PIECE_BIG[PIECE] THEN
  DEC BIG[COL]
  IF PIECE_MAJ[PIECE] THEN
   DEC MAJ[COL]
  ELSE
   DEC MINI[COL]
  ENDIF
 ENDIF
 
 FOR I=0 TO NUM[PIECE]-1
  IF LIST[PIECE,I]==SQ THEN
   T_NUM=I
   BREAK
  ENDIF
 NEXT

 DEC NUM[PIECE]
 
 LIST[PIECE,T_NUM]=LIST[PIECE,NUM[PIECE]]

END

'
'
'
DEF ADD_PIECE SQ, PIECE, SQ120, BIG, MAJ, MINI, MATERIAL, LIST, NUM
 VAR COL

 COL=PIECE_COL[PIECE]

 SQ120[SQ]=PIECE

 IF PIECE_BIG[PIECE] THEN
  INC BIG[COL]
  IF PIECE_MAJ[PIECE] THEN
   INC MAJ[COL]
  ELSE
   INC MINI[COL]
  ENDIF
 ENDIF

 MATERIAL[COL]=MATERIAL[COL]+PIECE_VAL[PIECE]

 LIST[PIECE,NUM[PIECE]]=SQ
 INC NUM[PIECE]

END

'
'
'
DEF MOVE_PIECE FROM_SQ, TO_SQ, SQ120, BIG, MAJ, MINI, MATERIAL, LIST, NUM
 VAR PIECE
 VAR COL
 VAR I

 PIECE=SQ120[FROM_SQ]
 COL=PIECE_COL[PIECE]

 SQ120[FROM_SQ]=G_EMPTY
 SQ120[TO_SQ]=PIECE
 
 FOR I=0 TO NUM[PIECE]-1
  IF LIST[PIECE,I]==FROM_SQ THEN
   LIST[PIECE,I]=TO_SQ
  ENDIF
 NEXT

END 

'
'
'
DEF MAKE_MOVE(MOVE, SIDE, SQ120, BIG, MAJ, MINI, MATERIAL, KING, LIST, NUM, ENPAS, PERM, FIFTY, HIS_MOVE, HIS_ENPAS, HIS_PERM, HIS_FIFTY)
 VAR FROM_SQ
 VAR TO_SQ
 VAR B_SIDE
 VAR CAPTURED
 VAR PROMOTED 

 FROM_SQ=MOVE_FROMSQ(MOVE)
 TO_SQ=MOVE_TOSQ(MOVE)
 B_SIDE=SIDE[0]

 IF MOVE AND MFLAG_EP THEN
  IF B_SIDE==G_WHITE THEN
   CLEAR_PIECE TO_SQ-10,SQ120,BIG,MAJ,MINI,MATERIAL,LIST,NUM
  ELSE
   CLEAR_PIECE TO_SQ+10,SQ120,BIG,MAJ,MINI,MATERIAL,LIST,NUM
  ENDIF
 ELSEIF MOVE AND MFLAG_CA THEN
  IF TO_SQ==G_C1 THEN
   MOVE_PIECE G_A1,G_D1,SQ120,BIG,MAJ,MINI,MATERIAL,LIST,NUM
  ELSEIF TO_SQ==G_C8 THEN
   MOVE_PIECE G_A8,G_D8,SQ120,BIG,MAJ,MINI,MATERIAL,LIST,NUM
  ELSEIF TO_SQ==G_G1 THEN
   MOVE_PIECE G_H1,G_F1,SQ120,BIG,MAJ,MINI,MATERIAL,LIST,NUM
  ELSEIF TO_SQ==G_G8 THEN
   MOVE_PIECE G_H8,G_F8,SQ120,BIG,MAJ,MINI,MATERIAL,LIST,NUM
  ENDIF
 ENDIF
 
 PUSH HIS_MOVE,MOVE
 PUSH HIS_ENPAS,ENPAS[0]
 PUSH HIS_PERM,PERM[0]
 PUSH HIS_FIFTY,FIFTY[0]

 PERM[0]=PERM[0] AND CASTLE_PERM[FROM_SQ]
 PERM[0]=PERM[0] AND CASTLE_PERM[TO_SQ]
 
 ENPAS[0]=NO_SQ
 
 CAPTURED=MOVE_CAPTURED(MOVE)
 INC FIFTY[0]
 
 IF CAPTURED!=G_EMPTY THEN
  CLEAR_PIECE TO_SQ,SQ120,BIG,MAJ,MINI,MATERIAL,LIST,NUM
  FIFTY[0]=0
 ENDIF
 
 IF PIECE_PAWN[SQ120[FROM_SQ]] THEN
  FIFTY[0]=0
  IF MOVE AND MFLAG_PS THEN
   IF B_SIDE==G_WHITE THEN
    ENPAS[0]=FROM_SQ+10
   ELSE
    ENPAS[0]=FROM_SQ-10
   ENDIF
  ENDIF
 ENDIF
 
 MOVE_PIECE FROM_SQ,TO_SQ,SQ120,BIG,MAJ,MINI,MATERIAL,LIST,NUM

 PROMOTED=MOVE_PROMOTED(MOVE)
 
 IF PROMOTED!=G_EMPTY THEN
  CLEAR_PIECE TO_SQ,SQ120,BIG,MAJ,MINI,MATERIAL,LIST,NUM
  ADD_PIECE TO_SQ,PROMOTED,SQ120,BIG,MAJ,MINI,MATERIAL,LIST,NUM
 ENDIF
 
 IF PIECE_KING[SQ120[TO_SQ]] THEN
  KING[B_SIDE]=TO_SQ
 ENDIF
 
 SIDE[0]=SIDE[0] XOR 1

 IF SQ_ATTACKED(KING[B_SIDE],SIDE[0],SQ120) THEN
' ? "TAKE_MOVE:ATTACKED: ";SIDE_CHAR$[PIECE_COL[SQ120[KING[B_SIDE]]]];PIECE_CHAR$[SQ120[KING[B_SIDE]]]
  TAKE_MOVE SIDE, SQ120, BIG, MAJ, MINI, MATERIAL, KING, LIST, NUM, ENPAS, PERM, FIFTY, HIS_MOVE, HIS_ENPAS, HIS_PERM, HIS_FIFTY
  RETURN FALSE
 ENDIF
 
 RETURN TRUE
END

'
'
'
DEF TAKE_MOVE SIDE, SQ120, BIG, MAJ, MINI, MATERIAL, KING, LIST, NUM, ENPAS, PERM, FIFTY, HIS_MOVE, HIS_ENPAS, HIS_PERM, HIS_FIFTY
 VAR MOVE
 VAR FROM_SQ
 VAR TO_SQ
 VAR CAPTURED
 VAR PROMOTED 

 MOVE=POP(HIS_MOVE)
 FROM_SQ=MOVE_FROMSQ(MOVE)
 TO_SQ=MOVE_TOSQ(MOVE)

 ENPAS[0]=POP(HIS_ENPAS)
 PERM[0]=POP(HIS_PERM)
 FIFTY[0]=POP(HIS_FIFTY)

 SIDE[0]=SIDE[0] XOR 1

 IF MOVE AND MFLAG_EP THEN
  IF SIDE[0]==G_WHITE THEN
  ADD_PIECE TO_SQ-10,G_BP,SQ120,BIG,MAJ,MINI,MATERIAL,LIST,NUM
  ELSE
  ADD_PIECE TO_SQ+10,G_WP,SQ120,BIG,MAJ,MINI,MATERIAL,LIST,NUM
  ENDIF
 ELSEIF MOVE AND MFLAG_CA THEN
  IF TO_SQ==G_C1 THEN
   MOVE_PIECE G_D1,G_A1,SQ120,BIG,MAJ,MINI,MATERIAL,LIST,NUM
  ELSEIF TO_SQ==G_C8 THEN
   MOVE_PIECE G_D8,G_A8,SQ120,BIG,MAJ,MINI,MATERIAL,LIST,NUM
  ELSEIF TO_SQ==G_G1 THEN
   MOVE_PIECE G_F1,G_H1,SQ120,BIG,MAJ,MINI,MATERIAL,LIST,NUM
  ELSEIF TO_SQ==G_G8 THEN
   MOVE_PIECE G_F8,G_H8,SQ120,BIG,MAJ,MINI,MATERIAL,LIST,NUM
  ENDIF
 ENDIF

 MOVE_PIECE TO_SQ,FROM_SQ,SQ120,BIG,MAJ,MINI,MATERIAL,LIST,NUM

 IF PIECE_KING[SQ120[FROM_SQ]] THEN
  KING[SIDE[0]]=FROM_SQ
 ENDIF

 CAPTURED=MOVE_CAPTURED(MOVE)
 
 IF CAPTURED!=G_EMPTY THEN
  ADD_PIECE TO_SQ,CAPTURED,SQ120,BIG,MAJ,MINI,MATERIAL,LIST,NUM

 ENDIF

 PROMOTED=MOVE_PROMOTED(MOVE)
 
 IF PROMOTED!=G_EMPTY THEN
  CLEAR_PIECE FROM_SQ,SQ120,BIG,MAJ,MINI,MATERIAL,LIST,NUM
  IF PIECE_COL[PROMOTED]==G_WHITE THEN
   ADD_PIECE FROM_SQ,G_WP,SQ120,BIG,MAJ,MINI,MATERIAL,LIST,NUM
  ELSE
   ADD_PIECE FROM_SQ,G_BP,SQ120,BIG,MAJ,MINI,MATERIAL,LIST,NUM
  ENDIF
 ENDIF

END

'
'
'
DEF MATERIAL_DRAW(SIDE, SQ120, MATERIAL, LIST, NUM)

 IF !NUM[G_WR] && !NUM[G_BR] && !NUM[G_WQ] && !NUM[G_BQ] THEN
  IF !NUM[G_BB] && !NUM[G_WB] THEN
   IF NUM[G_WN]<3 && NUM[G_BN]<3 THEN
    RETURN TRUE
   ENDIF
  ELSEIF !NUM[G_WN] && !NUM[G_BN] THEN
   IF ABS(NUM[G_WB]-NUM[G_BB])<2 THEN
    RETURN TRUE
   ENDIF
  ELSEIF (NUM[G_WN]<3 && !NUM[G_WB]) || (NUM[G_WB]==1 && !NUM[G_WN]) THEN
   IF (NUM[G_BN]<3 && !NUM[G_BB]) || (NUM[G_BB]==1 && !NUM[G_BN]) THEN
    RETURN TRUE
   ENDIF
  ENDIF
 ELSEIF !NUM[G_WQ] && !NUM[G_BQ] THEN
  IF NUM[G_WR]==1 && NUM[G_BR]==1 THEN
   IF (NUM[G_WN]+NUM[G_WB])<2 && (NUM[G_BN]+NUM[G_BB])<2 THEN
    RETURN TRUE
   ENDIF
  ELSEIF NUM[G_WR]==1 && !NUM[G_BR] THEN
   IF (NUM[G_WN]+NUM[G_WB])==0 && ((NUM[G_BN]+NUM[G_BB])==1 || (NUM[G_BN]+NUM[G_BB])==2) THEN
    RETURN TRUE
   ENDIF
  ELSEIF NUM[G_BR]==1 && !NUM[G_WR] THEN
   IF (NUM[G_BN]+NUM[G_BB])==0 && ((NUM[G_WN]+NUM[G_WB])==1 || (NUM[G_WN]+NUM[G_WB])==2) THEN
    RETURN TRUE
   ENDIF
  ENDIF
 ENDIF

 RETURN FALSE

END

'
'
'
DEF EVAL_POSITION(SIDE, SQ120, MATERIAL, KING, LIST, NUM)
 VAR SCORE
 VAR PIECE
 VAR I
 VAR SQ
 
' IF NUM[G_WP]==0 && NUM[G_BP]==0 && MATERIAL_DRAW(SIDE,SQ120,MATERIAL,LIST,NUM) THEN
'  RETURN 0
' ENDIF
 
 SCORE=MATERIAL[G_WHITE]-MATERIAL[G_BLACK]
 
 IF EVAL_MODE==G_EVAL_MATERIAL THEN
'  ? "Material ";
  GOTO @EVAL_MATERIAL
 ENDIF

 PIECE=G_WP
 FOR I=0 TO NUM[PIECE]-1
  SQ=LIST[PIECE,I]
  SCORE=SCORE+PAWN_TABLE[SQ120TOSQ64[SQ]]
 NEXT
 
 PIECE=G_BP
 FOR I=0 TO NUM[PIECE]-1
  SQ=LIST[PIECE,I]
  SCORE=SCORE-PAWN_TABLE[MIRROR_64[SQ120TOSQ64[SQ]]]
 NEXT

 PIECE=G_WN
 FOR I=0 TO NUM[PIECE]-1
  SQ=LIST[PIECE,I]
  SCORE=SCORE+KNIGHT_TABLE[SQ120TOSQ64[SQ]]
 NEXT

 PIECE=G_BN
 FOR I=0 TO NUM[PIECE]-1
  SQ=LIST[PIECE,I]
  SCORE=SCORE-KNIGHT_TABLE[MIRROR_64[SQ120TOSQ64[SQ]]]
 NEXT

 PIECE=G_WB
 FOR I=0 TO NUM[PIECE]-1
  SQ=LIST[PIECE,I]
  SCORE=SCORE+BISHOP_TABLE[SQ120TOSQ64[SQ]]
 NEXT

 PIECE=G_BB
 FOR I=0 TO NUM[PIECE]-1
  SQ=LIST[PIECE,I]
  SCORE=SCORE-BISHOP_TABLE[MIRROR_64[SQ120TOSQ64[SQ]]]
 NEXT

 PIECE=G_WR
 FOR I=0 TO NUM[PIECE]-1
  SQ=LIST[PIECE,I]
  SCORE=SCORE+ROOK_TABLE[SQ120TOSQ64[SQ]]
 NEXT

 PIECE=G_BR
 FOR I=0 TO NUM[PIECE]-1
  SQ=LIST[PIECE,I]
  SCORE=SCORE-ROOK_TABLE[MIRROR_64[SQ120TOSQ64[SQ]]]
 NEXT

 PIECE=G_WK
 SQ=LIST[PIECE,0]
 IF MATERIAL[G_BLACK]<=END_GAME_MAT THEN
  SCORE=SCORE+KING_E[SQ120TOSQ64[SQ]]
 ELSE
  SCORE=SCORE+KING_O[SQ120TOSQ64[SQ]]
 ENDIF

 PIECE=G_BK
 SQ=LIST[PIECE,0]
 IF MATERIAL[G_WHITE]<=END_GAME_MAT THEN
  SCORE=SCORE-KING_E[MIRROR_64[SQ120TOSQ64[SQ]]]
 ELSE
  SCORE=SCORE-KING_O[MIRROR_64[SQ120TOSQ64[SQ]]]
 ENDIF

 IF NUM[G_WB]>=2 THEN SCORE=SCORE+BISHOP_PAIR
 IF NUM[G_BB]>=2 THEN SCORE=SCORE-BISHOP_PAIR

@EVAL_MATERIAL

 IF SIDE[0]==G_BLACK THEN SCORE=-1*SCORE

 RETURN SCORE

END

'
' A7B8Q, a7b8r
'
DEF PARSE_MOVE(PARSE$, SIDE, SQ120, LIST, NUM, ENPAS, PERM)
 VAR LIST_MOVE[0]
 VAR LIST_SCORE[0]
 VAR F$,R$
 VAR F,R
 VAR I
 VAR L
 VAR FROM_SQ
 VAR TO_SQ
 VAR MOVE
 VAR PROMOTED

 IF PARSE$=="" || LEN(PARSE$)<4 THEN RETURN NO_MOVE

 FROM_SQ=-1
 TO_SQ=-1
 
 FOR I=0 TO 1
  F=-1
  R=-1
  F$=PARSE$[I*2+0]
  R$=PARSE$[I*2+1] 

  IF ASC(F$)>=ASC("A")&&ASC(F$)<=ASC("H")THEN
   F=ASC(F$)-ASC("A")
  ENDIF
  IF ASC(F$)>=ASC("a")&&ASC(F$)<=ASC("h")THEN
   F=ASC(F$)-ASC("a")
  ENDIF
  IF ASC(R$)>=ASC("1")&&ASC(R$)<=ASC("8") THEN
   R=ASC(R$)-ASC("1")
  ENDIF

  IF I==0 && F!=-1 && R!=-1 THEN
   FROM_SQ=FR2SQ120(F,R)
  ENDIF
  IF I==1 && F!=-1 && R!=-1 THEN
   TO_SQ=FR2SQ120(F,R)
  ENDIF
 NEXT
 
 IF FROM_SQ==-1 || TO_SQ==-1 THEN
  ? "ERROR PARSE MOVE"
  RETURN NO_MOVE
 ENDIF

 GENERATE_ALL_MOVES SIDE, SQ120, LIST, NUM, ENPAS, PERM, LIST_MOVE, LIST_SCORE

 L=LEN(LIST_MOVE)
 FOR I=0 TO L-1
  MOVE=LIST_MOVE[I]

  IF MOVE_FROMSQ(MOVE)==FROM_SQ && MOVE_TOSQ(MOVE)==TO_SQ THEN

   PROMOTED=MOVE_PROMOTED(MOVE)
   
   IF PROMOTED!=G_EMPTY THEN
    IF IS_RQ(PROMOTED) && IS_BQ(PROMOTED)==FALSE && (PARSE$[4]=="r"||PARSE$[4]=="R") THEN
      RETURN MOVE
    ELSEIF IS_RQ(PROMOTED)==FALSE && IS_BQ(PROMOTED) && (PARSE$[4]=="b"||PARSE$[4]=="B") THEN
      RETURN MOVE
    ELSEIF IS_RQ(PROMOTED) && IS_BQ(PROMOTED) && (PARSE$[4]=="q"||PARSE$[4]=="Q") THEN
      RETURN MOVE
    ELSEIF IS_KN(PROMOTED) && (PARSE$[4]=="n"||PARSE$[4]=="N") THEN
      RETURN MOVE
    ENDIF
    CONTINUE
   ENDIF
   RETURN MOVE
  ENDIF
 NEXT
 
 RETURN NO_MOVE
 
END 

'
'
'
DEF SQ_ATTACKED(SQ, ENEMY, SQ120)
 VAR PIECE
 VAR I
 VAR T_SQ
 VAR DIR
 
 'PAWN
 IF ENEMY==G_WHITE THEN
  IF SQ120[SQ-11]==G_WP || SQ120[SQ-9]==G_WP THEN RETURN TRUE
 ELSE
  IF SQ120[SQ+11]==G_BP || SQ120[SQ+9]==G_BP THEN RETURN TRUE
 ENDIF

'KNIGHT
 FOR I=0 TO 7
  PIECE=SQ120[SQ+KN_DIR[I]]
  IF PIECE!=OFFBOARD && IS_KN(PIECE) && PIECE_COL[PIECE]==ENEMY THEN RETURN TRUE 
 NEXT

'ROOKS, QUEENS
 FOR I=0 TO 3
  DIR=RK_DIR[I] 
  T_SQ=SQ+DIR
  PIECE=SQ120[T_SQ]
  WHILE PIECE!=OFFBOARD
   IF PIECE!=G_EMPTY THEN
    IF IS_RQ(PIECE) && PIECE_COL[PIECE]==ENEMY THEN RETURN TRUE 
    BREAK
   ENDIF
   T_SQ=T_SQ+DIR
   PIECE=SQ120[T_SQ]
  WEND
 NEXT

'BISHOPS, QUEENS
 FOR I=0 TO 3
  DIR=BI_DIR[I] 
  T_SQ=SQ+DIR
  PIECE=SQ120[T_SQ]
  WHILE PIECE!=OFFBOARD
   IF PIECE!=G_EMPTY THEN
    IF IS_BQ(PIECE) && PIECE_COL[PIECE]==ENEMY THEN RETURN TRUE 
    BREAK
   ENDIF
   T_SQ=T_SQ+DIR
   PIECE=SQ120[T_SQ]
  WEND
 NEXT

' KINGS
 FOR I=0 TO 7
  PIECE=SQ120[SQ+KI_DIR[I]]
  IF PIECE!=OFFBOARD && IS_KI(PIECE) && PIECE_COL[PIECE]==ENEMY THEN RETURN TRUE 
 NEXT

 RETURN FALSE 
END

'
'
'
DEF LIST_MOVE_PRINT LIST_MOVE, LIST_SCORE
 VAR SIZE
 VAR I
 VAR CNT
 VAR IN$
 VAR TOTAL$
 VAR FLAG

 CNT=13
 ' Y:0-29
 IF CSRY<29 THEN
  CNT=29-CSRY
 ENDIF

 TOTAL$=STR$(LEN(LIST_MOVE))
 
 ? "Total:";TOTAL$;" "
 DEC CNT

 SIZE=LEN(LIST_MOVE)
 FOR I=0 TO SIZE-1
  ? STR$(I+1,LEN(TOTAL$)+1);" Score:";FORMAT$("% 6D",LIST_SCORE[I]);" ";
  MOVE_PRINT LIST_MOVE[I]
  DEC CNT
  IF CNT<=0 THEN
   FLAG=MORE()
   IF FLAG==FALSE THEN BREAK
   CNT=20
  ENDIF
 NEXT

 ? "Total:";TOTAL$;" "
 PAUSE
END

'
'
'
DEF MATERIAL_PRINT SIDE,LIST,NUM
 VAR I,J
 ? PIECE_CHAR$
 FOR I=G_EMPTY TO G_BK
  ? NUM[I];" ";
 NEXT
 ?
 FOR I=G_EMPTY TO G_BK
  IF NUM[I]!=0 THEN ? PIECE_CHAR$[I];" ";
  FOR J=0 TO NUM[I]-1
   ? SQ120TOSQ64[LIST[I,J]];" ";
  NEXT
  IF NUM[I]!=0 THEN ?
 NEXT
END

'
'
' 
DEF UPDATE_LISTS_MATERIAL SIDE, SQ120, BIG, MAJ, MINI, MATERIAL, KING, LIST, NUM, ENPAS, PERM

 VAR I
 VAR SQ
 VAR PIECE
 VAR COLOUR
 
 FOR I=0 TO G_BOARD_NUM-1
  SQ=I
  PIECE=SQ120[I]
  IF ((PIECE!=OFFBOARD) && (PIECE!=G_EMPTY)) THEN
   COLOUR=PIECE_COL[PIECE]
   
   IF PIECE_BIG[PIECE] THEN INC BIG[COLOUR]
   IF PIECE_MAJ[PIECE] THEN INC MAJ[COLOUR]
   IF PIECE_MIN[PIECE] THEN INC MINI[COLOUR]

   MATERIAL[COLOUR]=MATERIAL[COLOUR]+PIECE_VAL[PIECE]

   LIST[PIECE,NUM[PIECE]]=SQ
   INC NUM[PIECE]

   IF PIECE==G_WK THEN KING[G_WHITE]=SQ
   IF PIECE==G_BK THEN KING[G_BLACK]=SQ
   
  ENDIF
 NEXT
 
END

'
'
'
DEF PARSE_FEN FEN$, SIDE, SQ120, BIG, MAJ, MINI, MATERIAL, KING, LIST, NUM, ENPAS, PERM, FIFTY
 VAR R,F
 VAR PIECE
 VAR INDEX
 VAR SIZE
 VAR F$
 VAR COUNT
 VAR I
 VAR SQ

 RESET_BOARD SIDE, SQ120, BIG, MAJ, MINI, MATERIAL, KING, LIST, NUM, ENPAS, PERM, FIFTY

 R=RANK_8
 F=FILE_A
 
 INDEX=0
 SIZE=LEN(FEN$)
 
 WHILE ((R>=RANK_1) && (INDEX<SIZE))
  COUNT=1
  F$=FEN$[INDEX]

  IF F$=="P" THEN PIECE=G_WP
  IF F$=="N" THEN PIECE=G_WN
  IF F$=="B" THEN PIECE=G_WB
  IF F$=="R" THEN PIECE=G_WR
  IF F$=="Q" THEN PIECE=G_WQ
  IF F$=="K" THEN PIECE=G_WK
  IF F$=="p" THEN PIECE=G_BP
  IF F$=="n" THEN PIECE=G_BN
  IF F$=="b" THEN PIECE=G_BB
  IF F$=="r" THEN PIECE=G_BR
  IF F$=="q" THEN PIECE=G_BQ
  IF F$=="k" THEN PIECE=G_BK
  
  IF F$>="1" && F$<="8" THEN
   PIECE=G_EMPTY
   COUNT=VAL(F$)
  ENDIF
  
  IF F$=="/" || F$==" " THEN
   DEC R
   F=FILE_A
   INC INDEX
   CONTINUE
  ENDIF

  FOR I=0 TO COUNT-1
   SQ=FR2SQ120(F,R)
   IF PIECE!=G_EMPTY THEN SQ120[SQ]=PIECE
   INC F
  NEXT
  INC INDEX
 WEND

 F$=FEN$[INDEX]
 IF (F$=="w") THEN SIDE[0]=G_WHITE
 IF (F$=="b") THEN SIDE[0]=G_BLACK
 IF (F$!="w" && F$!="b") THEN
  ? "FEN Parse Error"
 ENDIF
 INDEX=INDEX+2

 
 I=0
 WHILE (I<=4)
  F$=FEN$[INDEX+I]
  IF F$==" " THEN BREAK
  IF F$=="-" THEN I=I+1:BREAK
  IF F$=="K" THEN PERM[0]= PERM[0] OR &B0001
  IF F$=="Q" THEN PERM[0]= PERM[0] OR &B0010
  IF F$=="k" THEN PERM[0]= PERM[0] OR &B0100
  IF F$=="q" THEN PERM[0]= PERM[0] OR &B1000
  INC I
 WEND
 INDEX=INDEX+I+1
 
 F$=FEN$[INDEX]

 IF F$!="-" THEN
  F=ASC(F$)-ASC("a")
  INC INDEX
  R=VAL(FEN$[INDEX])-1
  ENPAS[0]=FR2SQ120(F,R)
 ENDIF
 
 
 UPDATE_LISTS_MATERIAL SIDE, SQ120, BIG, MAJ, MINI, MATERIAL, KING, LIST, NUM, ENPAS, PERM

END

'
'
'
DEF DRAW_MATERIAL(LIST, NUM)
 IF NUM[G_WP] || NUM[G_BP] THEN RETURN FALSE
 IF NUM[G_WQ] || NUM[G_BQ] || NUM[G_WR] || NUM[G_BR] THEN RETURN FALSE
 IF NUM[G_WB]>1 || NUM[G_BB]>1 THEN RETURN FALSE
 IF NUM[G_WN]>1 || NUM[G_BN]>1 THEN RETURN FALSE
 IF NUM[G_WN] && NUM[G_WB] THEN RETURN FALSE
 IF NUM[G_BN] && NUM[G_BB] THEN RETURN FALSE

 RETURN TRUE
END

'
'
'
DEF CHECK_RESULT SIDE, SQ120, BIG, MAJ, MINI, MATERIAL, KING, LIST, NUM, ENPAS, PERM, FIFTY, CONSOLE OUT GAME_END, GAME_RESULT
 VAR HIS_MOVE[0]
 VAR HIS_ENPAS[0]
 VAR HIS_PERM[0]
 VAR HIS_FIFTY[0]
 VAR I,L
 VAR MOVE
 VAR ATTACKED
 VAR FOUND
 VAR LIST_MOVE[0]
 VAR LIST_SCORE[0]

 GAME_END=FALSE
 GAME_RESULT=G_GAME_CONTINUE

 IF FIFTY[0]>100 THEN

  GAME_END=TRUE
  GAME_RESULT=G_GAME_FIFTY_MOVE

  IF CONSOLE THEN
   ? G_GAME_RESULT$[GAME_RESULT,G_DIALOG_RESULT,LC_EN]
   ? G_GAME_RESULT$[GAME_RESULT,G_DIALOG_GAME,LC_EN]
  ENDIF

  RETURN
 ENDIF

 IF DRAW_MATERIAL(LIST,NUM) THEN

  GAME_END=TRUE
  GAME_RESULT=G_GAME_MATERIAL_DRAW

  IF CONSOLE THEN
  ? G_GAME_RESULT$[GAME_RESULT,G_DIALOG_RESULT,LC_EN]
  ? G_GAME_RESULT$[GAME_RESULT,G_DIALOG_GAME,LC_EN]
  ENDIF
  
  RETURN
 ENDIF

' GOTO @CHECK_RESULT1

 GENERATE_ALL_MOVES SIDE, SQ120, LIST, NUM, ENPAS, PERM, LIST_MOVE, LIST_SCORE

' LIST_MOVE_PRINT LIST_MOVE,LIST_SCORE

 FOUND=0
 L=LEN(LIST_MOVE)
 FOR I=0 TO L-1
  MOVE=LIST_MOVE[I]
  IF MAKE_MOVE(MOVE, SIDE, SQ120, BIG, MAJ, MINI, MATERIAL, KING, LIST, NUM, ENPAS, PERM, FIFTY, HIS_MOVE, HIS_ENPAS, HIS_PERM, HIS_FIFTY)==FALSE THEN CONTINUE
'  MOVE_PRINT MOVE
  INC FOUND
  TAKE_MOVE SIDE, SQ120, BIG, MAJ, MINI, MATERIAL, KING, LIST, NUM, ENPAS, PERM, FIFTY, HIS_MOVE, HIS_ENPAS, HIS_PERM, HIS_FIFTY
 NEXT

 IF FOUND!=0 THEN RETURN
 
 ATTACKED=SQ_ATTACKED(KING[SIDE[0]],SIDE[0] XOR 1,SQ120)

 IF ATTACKED THEN
  IF SIDE[0]==G_WHITE THEN
   GAME_END=TRUE
   GAME_RESULT=G_GAME_BLACK_WIN
  ELSE
   GAME_END=TRUE
   GAME_RESULT=G_GAME_WHITE_WIN
  ENDIF
 ELSE
  GAME_END=TRUE
  GAME_RESULT=G_GAME_STALEMATE
 ENDIF

 IF GAME_END && CONSOLE THEN
  ? G_GAME_RESULT$[GAME_RESULT,G_DIALOG_RESULT,LC_EN]
  ? G_GAME_RESULT$[GAME_RESULT,G_DIALOG_GAME,LC_EN]
 ENDIF

 @CHECK_RESULT1

END

'
'
'
DEF ALPHA_BETA(ALPHA, BETA, DEPTH, SIDE, SQ120, BIG, MAJ, MINI, MATERIAL, KING, LIST, NUM, ENPAS, PERM, FIFTY, HIS_MOVE, HIS_ENPAS, HIS_PERM, HIS_FIFTY)
 VAR LIST_MOVE[0]
 VAR LIST_SCORE[0]
 VAR I
 VAR L
 VAR NO_ATTACKED
 VAR SCORE
 VAR LEGAL
 VAR IN_CHECK
 VAR MOVE
 
 LEGAL=0

 IF DEPTH<=0 THEN
  RETURN EVAL_POSITION(SIDE,SQ120,MATERIAL,KING,LIST,NUM)

 ENDIF
 
 IN_CHECK=SQ_ATTACKED(KING[SIDE[0]],SIDE[0] XOR 1,SQ120)
  
 GENERATE_ALL_MOVES SIDE, SQ120, LIST, NUM, ENPAS, PERM, LIST_MOVE, LIST_SCORE

 L=LEN(LIST_MOVE)
 FOR I=0 TO L-1
  MOVE=LIST_MOVE[I]

  NO_ATTACKED=MAKE_MOVE(MOVE, SIDE, SQ120, BIG, MAJ, MINI, MATERIAL, KING, LIST, NUM, ENPAS, PERM, FIFTY, HIS_MOVE, HIS_ENPAS, HIS_PERM, HIS_FIFTY)
 
  IF NO_ATTACKED==FALSE THEN CONTINUE

  INC LEGAL
  
  SCORE=-1*ALPHA_BETA(-1*BETA, -1*ALPHA, DEPTH-1, SIDE, SQ120, BIG, MAJ, MINI, MATERIAL, KING, LIST, NUM, ENPAS, PERM, FIFTY, HIS_MOVE, HIS_ENPAS, HIS_PERM, HIS_FIFTY)

  TAKE_MOVE SIDE, SQ120, BIG, MAJ, MINI, MATERIAL, KING, LIST, NUM, ENPAS, PERM, FIFTY, HIS_MOVE, HIS_ENPAS, HIS_PERM, HIS_FIFTY
  
  IF SCORE>=BETA THEN RETURN BETA
  IF SCORE>ALPHA THEN ALPHA=SCORE
 NEXT

 IF LEGAL==0 THEN
  IF IN_CHECK THEN
   RETURN -1*INFINITE
  ELSE
   RETURN 0
  ENDIF
 ENDIF

 RETURN ALPHA
END

'
'
'
DEF SEARCH_POSITION SIDE, SQ120, BIG, MAJ, MINI, MATERIAL, KING, LIST, NUM, ENPAS, PERM, FIFTY, HIS_MOVE, HIS_ENPAS, HIS_PERM, HIS_FIFTY, SCORE_FLAG OUT BEST_MOVE
 VAR LIST_MOVE[0]
 VAR LIST_SCORE[0]
 VAR L
 VAR I
 VAR MOVE
 VAR NO_ATTACKED
 VAR DEPTH
 VAR M
 VAR SCORE
 VAR PLY
 
 DEPTH=PLAYER_DEPTH[SIDE[0]]
 EVAL_MODE=PLAYER_EVAL[SIDE[0]]

'? SIDE_CHAR$[SIDE[0]]
'? "Depth:";DEPTH
'? "Eval type:";EVAL_MODE

 GENERATE_ALL_MOVES SIDE, SQ120, LIST, NUM, ENPAS, PERM, LIST_MOVE, LIST_SCORE

 L=LEN(LIST_MOVE)
 FOR I=0 TO L-1
  MOVE=LIST_MOVE[I]

  NO_ATTACKED=MAKE_MOVE(MOVE, SIDE, SQ120, BIG, MAJ, MINI, MATERIAL, KING, LIST, NUM, ENPAS, PERM, FIFTY, HIS_MOVE, HIS_ENPAS, HIS_PERM, HIS_FIFTY)
 
  IF NO_ATTACKED THEN
   LIST_SCORE[I]=-1*ALPHA_BETA(-1*INFINITE, INFINITE, DEPTH-1, SIDE, SQ120, BIG, MAJ, MINI, MATERIAL, KING, LIST, NUM, ENPAS, PERM, FIFTY, HIS_MOVE, HIS_ENPAS, HIS_PERM, HIS_FIFTY)

   TAKE_MOVE SIDE, SQ120, BIG, MAJ, MINI, MATERIAL, KING, LIST, NUM, ENPAS, PERM, FIFTY, HIS_MOVE, HIS_ENPAS, HIS_PERM, HIS_FIFTY
  ELSE
   LIST_SCORE[I]=-1*INFINITE*2
  ENDIF
 NEXT

 RSORT LIST_SCORE,LIST_MOVE

 IF SCORE_FLAG THEN
  LIST_MOVE_PRINT LIST_MOVE,LIST_SCORE
 ENDIF

 SCORE=LIST_SCORE[0]
 FOR I=1 TO L-1
  IF SCORE!=LIST_SCORE[I] THEN BREAK
 NEXT

 MOVE=LIST_MOVE[RND(I)]
 
 PLY=LEN(HIS_MOVE)+1

 PLY_MOVE_FROM_PRINT PLY,SIDE[0],SQ120,MOVE

 BEST_MOVE=MOVE
 
 NO_ATTACKED=MAKE_MOVE(MOVE, SIDE, SQ120, BIG, MAJ, MINI, MATERIAL, KING, LIST, NUM, ENPAS, PERM, FIFTY, HIS_MOVE, HIS_ENPAS, HIS_PERM, HIS_FIFTY)

END

'
'
'
DEF PRINT_BOARD SIDE, SQ120, BIG, MAJ, MINI, MATERIAL, KING, LIST, NUM, ENPAS, PERM, FIFTY, ABBREV

 VAR R,F
 VAR PIECE
 VAR F$
 VAR SQ

 FOR R=RANK_8 TO RANK_1 STEP -1
  F$=RANK_CHAR$[R]
  IF ABBREV==FALSE THEN ?
  COLOR 9:? F$+" ";:COLOR 15 
  FOR F=FILE_A TO FILE_H
   SQ=FR2SQ120(F,R)
   PIECE=SQ120[SQ]
   F$=PIECE_CHAR$[PIECE]
   F$="   "+F$
   IF PIECE_COL[PIECE]==G_BLACK THEN
    COLOR 4
   ELSE
    COLOR 15
   ENDIF
   ? RIGHT$(F$,3);
   COLOR 15 
  NEXT
   
  IF R==RANK_8 THEN ? "   side:";SIDE_CHAR$[SIDE[0]];
  IF R==RANK_7 THEN
   IF ENPAS[0]!=NO_SQ THEN
'  ? "   enPas:";ENPAS[0];
    ? "   enPas:";FILE_CHAR$[FILES_BOARD[ENPAS[0]]];RANK_CHAR$[RANKS_BOARD[ENPAS[0]]];
   ELSE
    ? "   enPas:..";  
'  ? "   enPas:";ENPAS[0];  
   ENDIF
  ENDIF
 
  IF R==RANK_6 THEN
   ? "   castle:";
   IF (PERM[0] AND &B0001) THEN ? "K";
   IF (PERM[0] AND &B0010) THEN ? "Q";
   IF (PERM[0] AND &B0100) THEN ? "k";
   IF (PERM[0] AND &B1000) THEN ? "q";
  ENDIF
 
  IF R==RANK_4 THEN
   ? "   FiftyMove:";FIFTY[0];
  ENDIF
 
  IF R==RANK_3 THEN
   ? "   Material[w]:";MATERIAL[G_WHITE];
  ENDIF

  IF R==RANK_2 THEN
   ? "   Material[b]:";MATERIAL[G_BLACK];
  ENDIF

  IF R==RANK_1 THEN
   EVAL_MODE=PLAYER_EVAL[SIDE[0]]
   ? "   Eval:";EVAL_POSITION(SIDE,SQ120,MATERIAL,KING,LIST,NUM);
  ENDIF
 
 ?
 NEXT
 
 IF ABBREV==FALSE THEN ?
 ? "  ";
 COLOR 9
 FOR F=FILE_A TO FILE_H
  F$=FILE_CHAR$[F]
  ? "  ";F$;
 NEXT
 COLOR 15
 ?

 GOTO @PRINT_BOARD1
 
 ? "=White=";
 ? " King:";SQ120TOSQ64[KING[G_WHITE]];
 ? " BIG:";BIG[G_WHITE];
 ? " MAJ:";MAJ[G_WHITE];
 ? " MIN:";MINI[G_WHITE]
 
 ? "=Black=";
 ? " King:";SQ120TOSQ64[KING[G_BLACK]];
 ? " BIG:";BIG[G_BLACK];
 ? " MAJ:";MAJ[G_BLACK];
 ? " MIN:";MINI[G_BLACK]

 @PRINT_BOARD1
END

'
'
'
DEF RESET_BOARD SIDE, SQ120, BIG, MAJ, MINI, MATERIAL, KING, LIST, NUM, ENPAS, PERM, FIFTY
 VAR I 
 VAR J

 SIDE[0]=G_BOTH

 FOR I=0 TO 119
  SQ120[I]=OFFBOARD
 NEXT
 FOR I=0 TO 63
  SQ120[SQ64TOSQ120[I]]=G_EMPTY
 NEXT
 
 FOR I=0 TO 1
  BIG[I]=0
  MAJ[I]=0
  MINI[I]=0
  MATERIAL[I]=0
 NEXT
 
 FOR I=0 TO 12
  FOR J=0 TO 9
   LIST[I,J]=0
  NEXT
 NEXT
 FOR I=0 TO 12
  NUM[I]=0
 NEXT

 ENPAS[0]=NO_SQ
 PERM[0]=0
 FIFTY[0]=0

 KING[G_WHITE]=NO_SQ
 KING[G_BLACK]=NO_SQ
 
END

'
'
'
DEF FR2SQ120(F,R)
 VAR SQ
 SQ=21+F+R*10
 RETURN SQ
END

'
'
'
DEF SQ64_PRINT SQ64
 SQ_PRINT SQ64,64,8 
END

'
'
'
DEF SQ120_PRINT SQ120
 SQ_PRINT SQ120,120,10
END

'
'
'
DEF SQ_PRINT SQ, SIZE, LINE
 VAR I
 FOR I=0 TO SIZE-1
  IF (((I MOD LINE) == 0) AND (I!=0)) THEN ?
  ? STR$(SQ[I],3);" ";
 NEXT
 ?:?
END

'
'
'
DEF IS_BQ(PIECE)
 RETURN PIECE_BISHOP_QUEEN[PIECE]
END

'
'
'
DEF IS_RQ(PIECE)
 RETURN PIECE_ROOK_QUEEN[PIECE]
END

'
'
'
DEF IS_KN(PIECE)
 RETURN PIECE_KNIGHT[PIECE]
END

'
'
'
DEF IS_KI(PIECE)
 RETURN PIECE_KING[PIECE]
END

'
'
'
DEF PRINT_PLAYER SIDE
 ? "Player: ";G_SIDE$[SIDE]
 ? "Type: ";G_PLAYER$[PLAYER[SIDE]]
 ? G_PLAYER_LEVEL$;" ";PLAYER_LEVEL[SIDE]
 ? "Eval:";G_PLAYER_EVAL$[PLAYER_EVAL[SIDE]]
 ? "Depth: ";PLAYER_DEPTH[SIDE]
END

'
'
'
DEF ARRAY_CLEAR ARRAY
 VAR I,D,L

 L=LEN(ARRAY)
 FOR I=0 TO L-1
  D=POP(ARRAY)
 NEXT

END

'
'
'
DEF DOWNCASE$(S$)
 VAR I
 VAR D$
 
 D$=""
 FOR I=0 TO LEN(S$)-1
  D$=D$+TO_LOWER$(S$[I])
 NEXT
 RETURN D$
END

'
'
'
DEF UPCASE$(S$)
 VAR I
 VAR U$
 
 U$=""
 FOR I=0 TO LEN(S$)-1
  U$=U$+TO_UPPER$(S$[I])
 NEXT
 RETURN U$
END

'
'
'
DEF TO_LOWER$(C$)
 VAR L$
 VAR L
 
 L$=C$[0]
 L=ASC(L$)
 IF ASC("A")<=L && L<=ASC("Z") THEN
  L$=CHR$(L+&H20)
 ENDIF
 
 RETURN L$
END

'
'
'
DEF TO_UPPER$(C$)
 VAR U$
 VAR U
 
 U$=C$[0]
 U=ASC(U$)
 IF ASC("a")<=U && U<=ASC("z") THEN
  U$=CHR$(U-&H20)
 ENDIF
 
 RETURN U$
END

'
' SYS/EX8TECDEMO
'
' 3738 ギョウメ:
'
DEF STKANDBTN()
' BTBAK=0 'BACKUP(GLOBAL)
' BTCNT=0 'COUNT(GLOBAL)
 VAR SLV#
 VAR BTN
 VAR SX#,SY#

 SLV#=0.2  'THRESHOLD

 BTN=BUTTON()
 STICK OUT SX#,SY#

 IF (SY#>SLV#) THEN BTN=BTN OR 1
 IF (SY#<-SLV#) THEN BTN=BTN OR 2
 IF (SX#<-SLV#) THEN BTN=BTN OR 4
 IF (SX#>SLV#) THEN BTN=BTN OR 8

 IF BTBAK!=BTN THEN BTCNT=0

 BTBAK=BTN
 BTCNT=BTCNT+1

 IF BTCNT==1 THEN RETURN BTN
 IF BTCNT>20 THEN BTCNT=BTCNT-3:RETURN BTN

 RETURN 0
END 

'
'
'
DEF PAUSE
 VAR BTN

 ? "Push  Button"

@BTN_LOOP

 BTN=STKANDBTN()
 IF (BTN AND #A)==0 THEN @BTN_LOOP

 WAIT PAUSE_WAIT
END

'
'
'
DEF MORE()
 VAR BTN
 VAR FLAG

 FLAG=FALSE

 ? "More: Button / Break: Button"

@BTN_LOOP

 BTN=STKANDBTN()
 IF (BTN AND #A)==0 && (BTN AND #B)==0 THEN @BTN_LOOP

 IF (BTN AND #A)!=0 THEN FLAG=TRUE

 WAIT PAUSE_WAIT
 
 RETURN FLAG
END

'
'
'
DEF TOUCH_XY OUT FLAG, TX, TY
 VAR _STTM,_TX,_TY,_CNT
 
 _CNT=0
 FLAG=TRUE
 
 REPEAT
  TOUCH OUT _STTM,_TX,_TY
  IF _STTM==1 THEN INC _CNT
 UNTIL _STTM==0
 IF _CNT==0 THEN FLAG=FALSE

 TX=_TX
 TY=_TY
END

'
'
'
DEF INIT_BG
 VAR I
 VAR SIZE
 VAR S#

 BG_BOARD_OXY[0]=96
' BG_BOARD_OXY[1]=56
' BG_BOARD_OXY[1]=70
 BG_BOARD_OXY[1]=76

 S#=16/16 

 RESTORE @BG_PIECE_CHR
 FOR I=G_EMPTY TO G_WK
  READ BG_PIECE_CHR[I]
 NEXT
 FOR I=G_BP TO G_BK
  BG_PIECE_CHR[I]=BG_PIECE_CHR[I-6]+6
 NEXT

@BG_PIECE_CHR
'G_EMPTY
'G_WP,G_WN,G_WB,G_WR,G_WQ,G_WK
'G_BP,G_BN,G_BB,G_BR,G_BQ,G_BK
 DATA 0
 DATA 4,6,7,5,8,9

 SIZE=16*8*S#
 BG_BOARD_RECT[0]=BG_BOARD_OXY[0]
 BG_BOARD_RECT[1]=BG_BOARD_OXY[1]
 BG_BOARD_RECT[2]=BG_BOARD_RECT[0]+SIZE
 BG_BOARD_RECT[3]=BG_BOARD_RECT[1]+SIZE

 BG_BOARD_ENABLE=TRUE

 DISPLAY 1
 VISIBLE 1,1,1,1

 FOR I=0 TO 2
  BGSCREEN I,320/16,240/16
'  BGHOME I,0,0
  BGHOME I,BG_BOARD_OXY[0],BG_BOARD_OXY[1]
  BGOFS I,0,0
  BGSCALE I,S#,S#
 NEXT

 BGSCREEN 3,320/16,240/16
 BGHOME 3,0,0
 BGOFS 3,0,0

' BGSCALE 3,S#,S#

 DISPLAY 0

 BG_FLIP=FALSE

 BG_TARGET120[0]=NO_SQ
 BG_TARGET120[1]=NO_SQ
 
 BG_HIGHLIGHT120=NO_SQ

 BG_ASSISTANT=TRUE

END

'
'
'
DEF DRAW_UI
 VAR I,J
 VAR LABEL$
 VAR C
 
 DISPLAY 1
 
 GPAGE 1,1

 FOR I=G_WHITE TO G_BLACK
  FOR J=G_WINDOW_MAIN TO G_WINDOW_SUB
   DRAW_WINDOW I,J,WINDOW_RECT,WINDOW_COL_ROW
   PRINT_WINDOW I,J,WINDOW_RECT,WINDOW_COL_ROW
  NEXT
 NEXT

 IF SCENE_STATE==G_SCENE_PLAY THEN
  ERASE_WINDOW G_PLY_RECORD,G_WINDOW_PLY,WINDOW_RECT,WINDOW_COL_ROW

'  DRAW_WINDOW G_PLY_PLAY,G_WINDOW_PLY,WINDOW_RECT,WINDOW_COL_ROW
 ELSEIF SCENE_STATE==G_SCENE_RECORD THEN
'  DRAW_WINDOW G_PLY_RECORD,G_WINDOW_PLY,WINDOW_RECT,WINDOW_COL_ROW
 ELSE
  ERASE_WINDOW G_PLY_RECORD,G_WINDOW_PLY,WINDOW_RECT,WINDOW_COL_ROW
 ENDIF 

 FOR I=G_WHITE TO G_BLACK
  FOR J=G_POPUP_TYPE TO G_POPUP_LEVEL
   DRAW_POPUP I,J,POPUP_RECT,POPUP_COL
   IF J==G_POPUP_TYPE THEN
    LABEL$=G_PLAYER$[PLAYER[I]]
   ELSE
    LABEL$=STR$(PLAYER_LEVEL[I])
   ENDIF
    IF POPUP_ENABLE[I,J] THEN
     C=-1
    ELSE
     C=RGB(136,136,136)
    ENDIF
    PRINT_POPUP LABEL$,C,I,J,POPUP_RECT,POPUP_COL
  NEXT
 NEXT
 
 FOR I=G_BUTTON_NEW TO G_BUTTON_QUIT
  DRAW_BUTTON I,BUTTON_RECT,BUTTON_COL,BUTTON_ENABLE,BUTTON_TITLE$
 NEXT

 FOR I=G_CONTROL_HEAD TO G_CONTROL_TAIL
  DRAW_BUTTON I,CONTROL_RECT,CONTROL_COL,CONTROL_ENABLE,CONTROL_TITLE$
 NEXT

 FOR I=G_RADIO_ASSISTANT TO G_RADIO_ASSISTANT
  DRAW_RADIO I,RADIO_RECT,RADIO_COL,RADIO_ENABLE,RADIO_TITLE$,RADIO_STATE
 NEXT

' DRAW_BUTTON_GBOX G_BUTTON_QUIT,BUTTON_RECT,RGB(0,255,0)

' DRAW_BUTTON_GBOX G_RADIO_ASSISTANT,RADIO_RECT,RGB(255,0,0)

 DISPLAY 0

END

'
'
'
DEF INIT_UI
 VAR X,Y
 VAR COL,ROW
 VAR I,J
 VAR LABEL$

'
 G_WINDOW_MAIN=0
 G_WINDOW_SUB=1
 G_WINDOW_PLY=2

 G_PLY_PLAY=G_WHITE
 G_PLY_RECORD=G_BLACK

 G_POPUP_TYPE=0
 G_POPUP_LEVEL=1

 G_BUTTON_NEW=0
 G_BUTTON_PLAY=1
 G_BUTTON_UNDO=2
 G_BUTTON_FLIP=3
 G_BUTTON_RESIGN=4
 G_BUTTON_QUIT=5

 G_MENU_TYPE=0
 G_MENU_LEVEL=1

 G_CONTROL_HEAD=0
 G_CONTROL_BACKWARD=1
 G_CONTROL_FORWARD=2
 G_CONTROL_TAIL=3

 G_RADIO_ASSISTANT=0

 RESTORE @WIN
 FOR I=G_WHITE TO G_BLACK
  FOR J=G_WINDOW_MAIN TO G_WINDOW_PLY 
    READ X,Y,COL,ROW
   CREATE_WINDOW X,Y,COL,ROW,I,J,WINDOW_RECT,WINDOW_COL_ROW
  NEXT
 NEXT

@WIN
 DATA 0,2,15,2
 DATA 1,60,6,6
 DATA 1,188,6,0

 DATA 158,2,15,2
 DATA 237,60,6,6
 DATA 1,188,6,1
 
 FOR I=G_WHITE TO G_BLACK
  FOR J=G_POPUP_TYPE TO G_POPUP_LEVEL
   IF J==G_POPUP_TYPE THEN
    X=WINDOW_RECT[I,J,0]+8+8*5
    COL=6
   ELSE
    X=WINDOW_RECT[I,J,0]+8
    COL=1
   ENDIF

   Y=WINDOW_RECT[I,J,1]+8+12
   CREATE_POPUP X,Y,COL,I,J,POPUP_RECT,POPUP_COL,POPUP_ENABLE
  NEXT
 NEXT

 X=WINDOW_RECT[0,1,0]
 Y=WINDOW_RECT[0,1,3]

 RESTORE @BUTTON
 FOR I=0 TO 1
  READ LABEL$
  CREATE_BUTTON X,Y,5,LABEL$,I,BUTTON_RECT,BUTTON_COL,BUTTON_ENABLE,BUTTON_TITLE$
  Y=Y+23
 NEXT

 X=WINDOW_RECT[1,1,0]
 Y=WINDOW_RECT[1,1,3]
 FOR I=2 TO 5
  READ LABEL$
  CREATE_BUTTON X,Y,5,LABEL$,I,BUTTON_RECT,BUTTON_COL,BUTTON_ENABLE,BUTTON_TITLE$
  Y=Y+23
 NEXT

@BUTTON
 DATA "New"
 DATA "Play"
 DATA "Undo"
 DATA "Flip"
 DATA "Resign"
 DATA "Quit"
 
 FOR I=G_WHITE TO G_BLACK
  FOR J=G_MENU_TYPE TO G_MENU_LEVEL
   IF J==G_MENU_TYPE THEN
    COL=7
    ROW=0
   ELSE
    COL=3
    ROW=4
   ENDIF
   
   CREATE_MENU POPUP_RECT[I,J,0],POPUP_RECT[I,J,3]-2,COL,ROW,I,J,MENU_RECT,MENU_COL_ROW,MENU_ENABLE
  NEXT
 NEXT

 RESTORE @CONTROL
 X=BG_BOARD_OXY[0]-(134-16*8)/2
 Y=BUTTON_RECT[G_BUTTON_QUIT,1]
 FOR I=G_CONTROL_HEAD TO G_CONTROL_TAIL
  READ LABEL$
  CREATE_BUTTON X,Y,0,LABEL$,I,CONTROL_RECT,CONTROL_COL,CONTROL_ENABLE,CONTROL_TITLE$
  X=CONTROL_RECT[I,2]+2
 NEXT

@CONTROL
 DATA ""
 DATA ""
 DATA ""
 DATA ""

 X=BG_BOARD_OXY[0]
 Y=WINDOW_RECT[0,0,3]+5
 CREATE_RADIO X,Y,14,"Assistant:",G_RADIO_ASSISTANT,RADIO_RECT,RADIO_COL,RADIO_ENABLE,RADIO_TITLE$,RADIO_STATE

 DISPLAY 1
 VISIBLE 1,1,1,1

 BACKCOLOR RGB(57,104,176)

 GPAGE 1,1

 DISPLAY 0
END

'
'
'
DEF GCOPY_FROM_GRP5 CX,CY,CX_SIZE,CY_SIZE,X,Y,MODE
 GCOPY 5,CX*16,CY*16,CX*16+CX_SIZE-1,CY*16+CY_SIZE-1,X,Y,MODE
END

'
'
'
DEF DRAW_GBOX NUMBER, TYPE, RECT, COLOUR
 VAR C

 IF COLOUR==-1 THEN
  C=RGB(255,0,0)
 ELSE
  C=COLOUR
 ENDIF

 GBOX RECT[NUMBER,TYPE,0],RECT[NUMBER,TYPE,1],RECT[NUMBER,TYPE,2],RECT[NUMBER,TYPE,3],C
END

'
'
'
DEF DRAW_BUTTON_GBOX NUMBER, RECT, COLOUR
 VAR C

 IF COLOUR==-1 THEN
  C=RGB(255,0,0)
 ELSE
  C=COLOUR
 ENDIF

 GBOX RECT[NUMBER,0],RECT[NUMBER,1],RECT[NUMBER,2],RECT[NUMBER,3],C
END

'
'
'
DEF CHR_LEN(LENGTH)
 RETURN LENGTH/2+(LENGTH MOD 2)

END

'
'
'
DEF CREATE_WINDOW X, Y, COLUMN, ROW, NUMBER, TYPE, RECT, COL_ROW

 COL_ROW[NUMBER,TYPE,0]=CHR_LEN(COLUMN)
 COL_ROW[NUMBER,TYPE,1]=CHR_LEN(ROW)

 RECT[NUMBER,TYPE,0]=X
 RECT[NUMBER,TYPE,1]=Y
 RECT[NUMBER,TYPE,2]=X+16*COL_ROW[NUMBER,TYPE,0]+32
 RECT[NUMBER,TYPE,3]=Y+16*COL_ROW[NUMBER,TYPE,1]+32

END

'
'
'
DEF ERASE_WINDOW NUMBER, TYPE, RECT, COL_ROW
 VAR X,Y
 VAR C,R
 VAR I,J

 X=RECT[NUMBER,TYPE,0]
 Y=RECT[NUMBER,TYPE,1]
 C=COL_ROW[NUMBER,TYPE,0]
 R=COL_ROW[NUMBER,TYPE,1]

 GCOPY_FROM_GRP5 0,0,16,16,X,Y,TRUE
 X=X+16
 FOR I=1 TO C
  GCOPY_FROM_GRP5 0,0,16,16,X,Y,TRUE
  X=X+16
 NEXT
 GCOPY_FROM_GRP5 0,0,16,16,X,Y,TRUE

 FOR J=1 TO R
  X=RECT[NUMBER,TYPE,0]
  Y=Y+16
  GCOPY_FROM_GRP5 0,0,16,16,X,Y,TRUE
  X=X+16
  FOR I=1 TO C
   GCOPY_FROM_GRP5 0,0,16,16,X,Y,TRUE
   X=X+16
  NEXT
  GCOPY_FROM_GRP5 0,0,16,16,X,Y,TRUE
 NEXT

 X=RECT[NUMBER,TYPE,0]
 Y=Y+16
 GCOPY_FROM_GRP5 0,0,16,16,X,Y,TRUE
 X=X+16
 FOR I=1 TO C
  GCOPY_FROM_GRP5 0,0,16,16,X,Y,TRUE
  X=X+16
 NEXT
 GCOPY_FROM_GRP5 0,0,16,16,X,Y,TRUE

END

'
'
'
DEF DRAW_WINDOW NUMBER, TYPE, RECT, COL_ROW
 VAR X,Y
 VAR C,R
 VAR I,J

 X=RECT[NUMBER,TYPE,0]
 Y=RECT[NUMBER,TYPE,1]
 C=COL_ROW[NUMBER,TYPE,0]
 R=COL_ROW[NUMBER,TYPE,1]

 GCOPY_FROM_GRP5 0,4,16,16,X,Y,FALSE
 X=X+16
 FOR I=1 TO C
  GCOPY_FROM_GRP5 1,4,16,16,X,Y,FALSE
  X=X+16
 NEXT
 GCOPY_FROM_GRP5 2,4,16,16,X,Y,FALSE

 FOR J=1 TO R
  X=RECT[NUMBER,TYPE,0]
  Y=Y+16
  GCOPY_FROM_GRP5 0,5,16,16,X,Y,FALSE
  
  X=X+16
  FOR I=1 TO C
   GCOPY_FROM_GRP5 1,5,16,16,X,Y,FALSE
   X=X+16
  NEXT
  GCOPY_FROM_GRP5 2,5,16,16,X,Y,FALSE
 NEXT

 X=RECT[NUMBER,TYPE,0]
 Y=Y+16
 GCOPY_FROM_GRP5 0,6,16,16,X,Y,FALSE
 X=X+16
  
 FOR I=1 TO C
  GCOPY_FROM_GRP5 1,6,16,16,X,Y,FALSE
  X=X+16
 NEXT
 GCOPY_FROM_GRP5 2,6,16,16,X,Y,FALSE
END

'
'
'
DEF PUT_WINDOW X, Y, MESS$, COLOUR, NUMBER, TYPE, RECT, COL
 VAR C
 VAR OX,OY

 OX=RECT[NUMBER,TYPE,0]+X
 OY=RECT[NUMBER,TYPE,1]+Y
 
 IF COLOUR==-1 THEN
  C=RGB(0,0,0)
 ELSE
  C=COLOUR
 ENDIF
 
 GPUTCHR OX,OY,MESS$,C
END

'
'
'
DEF PRINT_WINDOW NUMBER, TYPE, RECT, COL_ROW
 VAR Y
 VAR C

 IF TYPE==G_WINDOW_MAIN THEN
  IF NUMBER==G_WHITE THEN
   C=RGB(0,0,255)
  ELSE
   C=RGB(0,127,0)
  ENDIF
  PUT_WINDOW 8,12,G_SIDE$[NUMBER],C,NUMBER,TYPE,RECT,COL_ROW
  PUT_WINDOW 8,12+16,"Type:",-1,NUMBER,TYPE,RECT,COL_ROW
 
 ELSEIF TYPE==G_WINDOW_SUB THEN
  Y=12
  PUT_WINDOW 8,Y,"Level:",-1,NUMBER,TYPE,RECT,COL_ROW
  Y=Y+10+20
  PUT_WINDOW 8,Y,"Eval:",-1,NUMBER,TYPE,RECT,COL_ROW
  Y=Y+10
  PUT_WINDOW 8,Y,G_PLAYER_EVAL$[PLAYER_EVAL[NUMBER]],-1,NUMBER,TYPE,RECT,COL_ROW
 Y=Y+10
  PUT_WINDOW 8,Y,"Depth:"+STR$(PLAYER_DEPTH[NUMBER]),-1,NUMBER,TYPE,RECT,COL_ROW
 ELSE
 ENDIF
END

'
'
'
DEF PRINT_PLY_WINDOW PLY, MAX_PLY
 VAR PLY$
 VAR MAX_PLY$
 VAR Y
 
 DISPLAY 1

 PLY$=FORMAT$("%4D",PLY)
 MAX_PLY$=FORMAT$("%4D",MAX_PLY)

'
' PLAY
'
 IF SCENE_STATE==G_SCENE_PLAY THEN
  ERASE_WINDOW G_PLY_PLAY,G_WINDOW_PLY,WINDOW_RECT,WINDOW_COL_ROW

  DRAW_WINDOW G_PLY_PLAY,G_WINDOW_PLY,WINDOW_RECT,WINDOW_COL_ROW

  Y=12
  PUT_WINDOW 8,Y,"Ply:"+PLY$,-1,G_PLY_PLAY,G_WINDOW_PLY,WINDOW_RECT,WINDOW_COL_ROW

'
' RECORD
'
 ELSEIF SCENE_STATE==G_SCENE_RECORD THEN
  ERASE_WINDOW G_PLY_RECORD,G_WINDOW_PLY,WINDOW_RECT,WINDOW_COL_ROW

  DRAW_WINDOW G_PLY_RECORD,G_WINDOW_PLY,WINDOW_RECT,WINDOW_COL_ROW

  Y=12
  PUT_WINDOW 8,Y,"Ply:"+PLY$,-1,G_PLY_RECORD,G_WINDOW_PLY,WINDOW_RECT,WINDOW_COL_ROW
  Y=Y+14
  PUT_WINDOW 8,Y,"Max:"+MAX_PLY$,-1,G_PLY_RECORD,G_WINDOW_PLY,WINDOW_RECT,WINDOW_COL_ROW

 ENDIF

 DISPLAY 0
END

'
'
'
DEF CREATE_POPUP X, Y, COLUMN, NUMBER, TYPE, RECT, COL, ENABLE
 COL[NUMBER,TYPE]=CHR_LEN(COLUMN)

 RECT[NUMBER,TYPE,0]=X
 RECT[NUMBER,TYPE,1]=Y
 RECT[NUMBER,TYPE,2]=X+16+16*COL[NUMBER,TYPE]+32
 RECT[NUMBER,TYPE,3]=Y+19

 ENABLE[NUMBER,TYPE]=TRUE

END

'
'
'
DEF ERASE_POPUP NUMBER, TYPE, RECT, COL
 VAR X,Y
 VAR I,J

 X=RECT[NUMBER,TYPE,0]
 Y=RECT[NUMBER,TYPE,1]
 
 FOR I=0 TO 1
  GCOPY_FROM_GRP5 0,0,16,16,X,Y+16*I,TRUE
 NEXT
 X=X+16
 FOR I=1 TO COL[NUMBER,TYPE]
  GCOPY_FROM_GRP5 0,0,16,16,X,Y,TRUE
  GCOPY_FROM_GRP5 0,0,16,16,X,Y+16,TRUE
  X=X+16
 NEXT
 FOR I=0 TO 1
  FOR J=0 TO 1
   GCOPY_FROM_GRP5 0,0,16,16,X+I*16,Y+J*16,TRUE
  NEXT
 NEXT
END

'
'
'
DEF DRAW_POPUP NUMBER, TYPE, RECT, COL
 VAR X,Y
 VAR I

 X=RECT[NUMBER,TYPE,0]
 Y=RECT[NUMBER,TYPE,1]
 
 GCOPY_FROM_GRP5 0,7,16,32,X,Y,FALSE
 X=X+16
 FOR I=1 TO COL[NUMBER,TYPE]
  GCOPY_FROM_GRP5 1,7,16,32,X,Y,FALSE
  X=X+16
 NEXT
 GCOPY_FROM_GRP5 2,7,32,32,X,Y,FALSE
END

'
'
'
DEF PRINT_POPUP MESS$, COLOUR, NUMBER, TYPE, RECT, COL
 VAR X,Y
 VAR C

 X=RECT[NUMBER,TYPE,0]+6
 Y=RECT[NUMBER,TYPE,1]+6

 IF COLOUR==-1 THEN
  C=RGB(0,0,0)
 ELSE
  C=COLOUR
 ENDIF
 
 GPUTCHR X,Y,MESS$,C
END

'
'
'
DEF CREATE_BUTTON X, Y, COLUMN, LABEL$, NUMBER, RECT, COL, ENABLE, TITLE$

 COL[NUMBER]=CHR_LEN(COLUMN)
 ENABLE[NUMBER]=TRUE
 TITLE$[NUMBER]=LABEL$

 RECT[NUMBER,0]=X
 RECT[NUMBER,1]=Y
 RECT[NUMBER,2]=X+16+16*COL[NUMBER]+16
 RECT[NUMBER,3]=Y+22
END

'
'
'
DEF DRAW_BUTTON NUMBER, RECT, COL, ENABLE, TITLE$
 VAR X,Y
 VAR I

 X=RECT[NUMBER,0]
 Y=RECT[NUMBER,1]
 
 GCOPY_FROM_GRP5 0,9,16,32,X,Y,FALSE
 X=X+16
 FOR I=1 TO COL[NUMBER]
  GCOPY_FROM_GRP5 1,9,16,32,X,Y,FALSE
  X=X+16
 NEXT
 GCOPY_FROM_GRP5 2,9,16,32,X,Y,FALSE

 PRINT_BUTTON NUMBER,RECT,COL,ENABLE,TITLE$

END

'
'
'
DEF PRINT_BUTTON NUMBER, RECT, COL, ENABLE, TITLE$
 VAR X,Y
 VAR C
 VAR L
 VAR W

 L=LEN(TITLE$[NUMBER])
 W=RECT[NUMBER,2]-RECT[NUMBER,0]+1

 X=RECT[NUMBER,0]+(W-L*8)/2
 Y=RECT[NUMBER,1]+8

 IF ENABLE[NUMBER]==TRUE THEN
  C=RGB(0,0,0)
 ELSE
  C=RGB(136,136,136)
'  C=RGB(255,255,255)
 ENDIF
 
 
 GPUTCHR X,Y,TITLE$[NUMBER],C
END

'
'
'
DEF CREATE_RADIO X, Y, COLUMN, LABEL$, NUMBER, RECT, COL, ENABLE, TITLE$, STATE

 COL[NUMBER]=CHR_LEN(COLUMN)
 ENABLE[NUMBER]=TRUE
 TITLE$[NUMBER]=LABEL$

 RECT[NUMBER,0]=X
 RECT[NUMBER,1]=Y
 RECT[NUMBER,2]=X+COL[NUMBER]*16+16
 RECT[NUMBER,3]=Y+16

 STATE[NUMBER]=TRUE
END

'
'
'
DEF DRAW_RADIO NUMBER, RECT, COL, ENABLE, TITLE$, STATE
 VAR X,Y
 VAR I

 X=RECT[NUMBER,0]
 Y=RECT[NUMBER,1]
 
 GCOPY_FROM_GRP5 0,12,16,16,X,Y,FALSE
 X=X+16
 FOR I=1 TO COL[NUMBER]-1
  GCOPY_FROM_GRP5 1,12,16,16,X,Y,FALSE
  X=X+16
 NEXT

 GCOPY_FROM_GRP5 2,12,16,16,X,Y,FALSE
 
 X=X-8
 IF STATE[NUMBER]==TRUE THEN
  GCOPY_FROM_GRP5 0,11,16,16,X,Y,FALSE
 ELSE
  GCOPY_FROM_GRP5 1,11,16,16,X,Y,FALSE
 ENDIF
 
 PRINT_RADIO NUMBER,RECT,COL,ENABLE,TITLE$,STATE

END

'
'
'
DEF PRINT_RADIO NUMBER, RECT, COL, ENABLE, TITLE$, STATE
 VAR X,Y
 VAR C
 VAR L
 VAR W

 L=LEN(TITLE$[NUMBER])
 W=RECT[NUMBER,2]-RECT[NUMBER,0]-15

 X=RECT[NUMBER,0]+(W-L*8)/2+4
 Y=RECT[NUMBER,1]+4

 IF ENABLE[NUMBER]==TRUE THEN
  C=RGB(0,0,0)
 ELSE
  C=RGB(136,136,136)
'  C=RGB(255,255,255)
 ENDIF

 GPUTCHR X,Y,TITLE$[NUMBER],C
END

'
'
'
DEF IS_IN_RECT(X, Y, NUMBER, RECT)

 IF RECT[NUMBER,0]<=X && X<=RECT[NUMBER,2] && RECT[NUMBER,1]<=Y && Y<=RECT[NUMBER,3] THEN
  RETURN TRUE
 ENDIF

 RETURN FALSE
END

'
'
'
DEF IS_POPUP_IN_RECT(X, Y, NUMBER, TYPE, RECT)
 IF RECT[NUMBER,TYPE,0]<=X && X<=RECT[NUMBER,TYPE,2] && RECT[NUMBER,TYPE,1]<=Y && Y<=RECT[NUMBER,TYPE,3] THEN
  RETURN TRUE
 ENDIF

 RETURN FALSE
END

'
'
'
DEF DRAW_PIECES SQ120, HIGHLIGHT120
 VAR I
 VAR X,Y,L
 VAR PIECE
 VAR LAYER
 VAR SQ64
 VAR SQ

 LAYER=2

 DISPLAY 1
 
 FOR I=0 TO 63
  X=I MOD 8
  Y=I/8
 
  IF BG_FLIP THEN
   PIECE=SQ120[SQ64TOSQ120[FLIP_64[I]]]
  ELSE
   PIECE=SQ120[SQ64TOSQ120[I]]
  ENDIF
  BGPUT LAYER,X,7-Y,BG_PIECE_CHR[PIECE]
 NEXT

 LAYER=1
 CLEAR_BOARD LAYER

 IF HIGHLIGHT120!=NO_SQ THEN
  BG_HIGHLIGHT120=HIGHLIGHT120
 ENDIF

 IF BG_HIGHLIGHT120!=NO_SQ THEN
  DRAW_BGPUT BG_HIGHLIGHT120,96
 ENDIF

 L=LEN(BG_MOVE_LIST) 

 IF L!=0 && BG_ASSISTANT THEN
  FOR I=0 TO L-1
   SQ=BG_MOVE_LIST[I]
'   DRAW_BGPUT SQ,97
   DRAW_BGPUT SQ,98
  NEXT
 ENDIF

 DISPLAY 0

END

'
'
'
DEF DRAW_BGPUT SQ120, CHR
 VAR X,Y
 VAR LAYER
 VAR SQ64

 IF SQ120==NO_SQ THEN
  RETURN
 ENDIF

 DISPLAY 1
 
 LAYER=1

 SQ64=SQ120TOSQ64[SQ120]

 IF BG_FLIP THEN
  SQ64=FLIP_64[SQ64]
 ENDIF

 X=SQ64 MOD 8
 Y=SQ64/8
 BGPUT LAYER,X,7-Y,CHR
 
 DISPLAY 0

END

'
'
'
DEF DRAW_BOARD
 VAR I
 VAR C
 VAR X,Y
 VAR PIECE
 VAR LAYER

 LAYER=0

 DISPLAY 1

 FOR I=0 TO 63
  X=I MOD 8
  Y=I/8
  C=1
'  IF BG_FLIP THEN C=C XOR 1
  IF (Y XOR X) AND 1 THEN C=C XOR 1
  BGPUT LAYER,X,7-Y,C+1
 NEXT

 DISPLAY 0

END

'
'
'
DEF CLEAR_BOARD LAYER
 VAR I,J

 DISPLAY 1

 FOR I=0 TO 7
  FOR J=0 TO 7
   BGPUT LAYER,I,J,0
  NEXT
 NEXT

 DISPLAY 0

END

'
'
'
DEF CREATE_MENU X, Y, COLUMN, ROW, NUMBER, TYPE, RECT, COL_ROW, ENABLE

 COL_ROW[NUMBER,TYPE,0]=CHR_LEN(COLUMN)
 COL_ROW[NUMBER,TYPE,1]=CHR_LEN(ROW)

 RECT[NUMBER,TYPE,0]=X
 RECT[NUMBER,TYPE,1]=Y
 RECT[NUMBER,TYPE,2]=X+16*COL_ROW[NUMBER,TYPE,0]+32
 RECT[NUMBER,TYPE,3]=Y+16*COL_ROW[NUMBER,TYPE,1]+32

 ENABLE[NUMBER,TYPE]=FALSE
END

'
'
'
DEF ERASE_MENU NUMBER, TYPE, RECT, COL_ROW, ENABLE
 VAR X,Y
 VAR C,R
 VAR I,J

 IF ENABLE[NUMBER,TYPE]==FALSE THEN RETURN

 X=RECT[NUMBER,TYPE,0]
 Y=RECT[NUMBER,TYPE,1]
 C=COL_ROW[NUMBER,TYPE,0]
 R=COL_ROW[NUMBER,TYPE,1]

 GCOPY_FROM_GRP5 0,0,16,16,X,Y,TRUE
 X=X+16
 FOR I=1 TO C
  GCOPY_FROM_GRP5 0,0,16,16,X,Y,TRUE
  X=X+16
 NEXT
 GCOPY_FROM_GRP5 0,0,16,16,X,Y,TRUE

 FOR J=1 TO R
  X=RECT[NUMBER,TYPE,0]
  Y=Y+16
  GCOPY_FROM_GRP5 0,0,16,16,X,Y,TRUE
  X=X+16
  FOR I=1 TO C
   GCOPY_FROM_GRP5 0,0,16,16,X,Y,TRUE
   X=X+16
  NEXT
  GCOPY_FROM_GRP5 0,0,16,16,X,Y,TRUE
 NEXT

 X=RECT[NUMBER,TYPE,0]
 Y=Y+16
 GCOPY_FROM_GRP5 0,0,16,16,X,Y,TRUE
 X=X+16
 FOR I=1 TO C
  GCOPY_FROM_GRP5 0,0,16,16,X,Y,TRUE
  X=X+16
 NEXT
 GCOPY_FROM_GRP5 0,0,16,16,X,Y,TRUE

 ENABLE[NUMBER,TYPE]=FALSE

END

'
'
'
DEF ERASE_ALL_MENU
 VAR I,J

 DISPLAY 1

 FOR I=G_WHITE TO G_BLACK
  FOR J=G_MENU_TYPE TO G_MENU_LEVEL
   ERASE_MENU I,J,MENU_RECT,MENU_COL_ROW,MENU_ENABLE
  NEXT
 NEXT

 DISPLAY 0

END

'
'
'
DEF DRAW_MENU NUMBER, TYPE, RECT, COL_ROW, ENABLE
 VAR X,Y
 VAR X1,Y1
 VAR C,R
 VAR I,J
 VAR COLOUR

 IF ENABLE[NUMBER,TYPE]==FALSE THEN RETURN

 X=RECT[NUMBER,TYPE,0]
 Y=RECT[NUMBER,TYPE,1]
 C=COL_ROW[NUMBER,TYPE,0]
 R=COL_ROW[NUMBER,TYPE,1]

 GCOPY_FROM_GRP5 3,4,16,16,X,Y,FALSE
 X=X+16
 FOR I=1 TO C
  GCOPY_FROM_GRP5 4,4,16,16,X,Y,FALSE
  X=X+16
 NEXT
 GCOPY_FROM_GRP5 5,4,16,16,X,Y,FALSE

 FOR J=1 TO R
  X=RECT[NUMBER,TYPE,0]
  Y=Y+16
  GCOPY_FROM_GRP5 3,5,16,16,X,Y,FALSE
  
  X=X+16
  FOR I=1 TO C
   GCOPY_FROM_GRP5 4,5,16,16,X,Y,FALSE
   X=X+16
  NEXT
  GCOPY_FROM_GRP5 5,5,16,16,X,Y,FALSE
 NEXT

 X=RECT[NUMBER,TYPE,0]
 Y=Y+16
 GCOPY_FROM_GRP5 3,6,16,16,X,Y,FALSE
 X=X+16
  
 FOR I=1 TO C
  GCOPY_FROM_GRP5 4,6,16,16,X,Y,FALSE
  X=X+16
 NEXT
 GCOPY_FROM_GRP5 5,6,16,16,X,Y,FALSE

 X=RECT[NUMBER,TYPE,0]+2
 Y=RECT[NUMBER,TYPE,1]
 X1=RECT[NUMBER,TYPE,2]-3
 Y1=RECT[NUMBER,TYPE,3]
 C=COL_ROW[NUMBER,TYPE,0]
 R=COL_ROW[NUMBER,TYPE,1]

 COLOUR=RGB(152,152,152)
' COLOUR=RGB(255,0,0)

 IF TYPE==G_MENU_TYPE THEN
  GLINE X,Y+15,X1,Y+15,COLOUR
 ELSE
  FOR I=1 TO 4
   GLINE X,Y+12*I,X1,Y+12*I,COLOUR
  NEXT
 ENDIF

END

'
'
'
DEF PUT_MENU X, Y, MESS$, COLOUR, NUMBER, TYPE, RECT, COL, ENABLE
 VAR C
 VAR OX,OY

 IF ENABLE[NUMBER,TYPE]==FALSE THEN RETURN

 OX=RECT[NUMBER,TYPE,0]+X
 OY=RECT[NUMBER,TYPE,1]+Y
 
 IF COLOUR==-1 THEN
  C=RGB(0,0,0)
 ELSE
  C=COLOUR
 ENDIF
 
 GPUTCHR OX,OY,MESS$,C
END

'
'
'
DEF PRINT_MENU NUMBER, TYPE, RECT, COL_ROW, ENABLE
 VAR I
 VAR Y

 IF TYPE==G_MENU_TYPE THEN
  FOR I=G_USER TO G_ENGINE
   PUT_MENU 8,6+I*12,G_PLAYER$[I],RGB(0,0,0),NUMBER,TYPE,RECT,COL_ROW,ENABLE
  NEXT  
 ELSE
  Y=3
  FOR I=1 TO 5
   PUT_MENU 8,Y,STR$(I),-1,NUMBER,TYPE,RECT,COL_ROW,ENABLE
   Y=Y+12
  NEXT
 ENDIF
END
'
'
'
DEF IS_MENU_IN_RECT(X, Y, NUMBER, TYPE, RECT)
 IF RECT[NUMBER,TYPE,0]<=X && X<=RECT[NUMBER,TYPE,2] && RECT[NUMBER,TYPE,1]<=Y && Y<=RECT[NUMBER,TYPE,3] THEN
  RETURN TRUE
 ENDIF

 RETURN FALSE
END

'
'
'
DEF XY2SQ120 TX, TY OUT FLAG, SQ120
 VAR X,Y
 VAR SQ64
 
 FLAG=FALSE
 SQ120=NO_SQ
 
 X=0
 Y=0
 IF BG_BOARD_ENABLE && BG_BOARD_RECT[0]<=TX && TX<=BG_BOARD_RECT[2] && BG_BOARD_RECT[1]<=TY && TY<=BG_BOARD_RECT[3] THEN
  FLAG=TRUE
  X=(TX-BG_BOARD_OXY[0]-1)/16
  Y=(TY-BG_BOARD_OXY[1]-1)/16
 ENDIF

 IF FLAG==TRUE THEN
  SQ64=X+(7-Y)*8
  IF BG_FLIP THEN SQ64=FLIP_64[SQ64]

  SQ120=SQ64TOSQ120[SQ64]
 ENDIF

' IF FLAG THEN ? "X=";X;" Y=";7-Y;" SQ64=";SQ64
END

'
'
'
DEF XY2POPUP TX, TY OUT FLAG, SIDE, TYPE
 VAR I,J

 FOR I=G_WHITE TO G_BLACK
  FOR J=G_POPUP_TYPE TO G_POPUP_LEVEL
   IF POPUP_ENABLE[I,J] && IS_POPUP_IN_RECT(TX,TY,I,J,POPUP_RECT) THEN
    FLAG=TRUE
    SIDE=I
    TYPE=J
    RETURN
   ENDIF
  NEXT
 NEXT

 FLAG=FALSE
 SIDE=G_BOTH
 TYPE=0
END

'
'
'
DEF XY2BUTTON TX, TY OUT FLAG, BTN
 VAR I

 FOR I=G_BUTTON_NEW TO G_BUTTON_QUIT
  IF BUTTON_ENABLE[I] && IS_IN_RECT(TX,TY,I,BUTTON_RECT) THEN
   FLAG=TRUE
   BTN=I
   RETURN
  ENDIF
 NEXT

 FLAG=FALSE
 BTN=-1
END

'
'
'
DEF XY2CONTROL TX, TY OUT FLAG, BTN
 VAR I

 FOR I=G_CONTROL_HEAD TO G_CONTROL_TAIL
  IF CONTROL_ENABLE[I] && IS_IN_RECT(TX,TY,I,CONTROL_RECT) THEN
   FLAG=TRUE
   BTN=I
   RETURN
  ENDIF
 NEXT

 FLAG=FALSE
 BTN=-1
END

'
'
'
DEF XY2MENU TX, TY OUT FLAG, SIDE, TYPE, VALUE
 VAR I,J

 FOR I=G_WHITE TO G_BLACK
  FOR J=G_MENU_TYPE TO G_MENU_LEVEL
   IF MENU_ENABLE[I,J] && IS_MENU_IN_RECT(TX,TY,I,J,MENU_RECT) THEN
    FLAG=TRUE
    SIDE=I
    TYPE=J
    IF TYPE==G_MENU_TYPE THEN
     VALUE=(TY-MENU_RECT[I,J,1])/16
    ELSE
     VALUE=(TY-MENU_RECT[I,J,1])/12+1    
    ENDIF
    RETURN
   ENDIF
  NEXT
 NEXT

 FLAG=FALSE
 SIDE=G_BOTH
 TYPE=0
 VALUE=0
END

'
'
'
DEF XY2RADIO TX, TY OUT FLAG, BTN
 VAR I

 FOR I=G_RADIO_ASSISTANT TO G_RADIO_ASSISTANT
  IF RADIO_ENABLE[I] && IS_IN_RECT(TX,TY,I,RADIO_RECT) THEN
   FLAG=TRUE
   BTN=I
   RETURN
  ENDIF
 NEXT

 FLAG=FALSE
 BTN=-1
END

'
'
'
DEF DIALOG_BUTTON(STATE)
 VAR CAPTION$
 VAR TEXT$
 VAR I
 VAR DI
 VAR RET
 
 CAPTION$=G_BUTTON$[STATE,G_DIALOG_CAPTION,LC_EN]

 TEXT$=""
 FOR I=LC_EN TO LC_JA 
  TEXT$=TEXT$+G_BUTTON$[STATE,G_DIALOG_TEXT,I]
 NEXT
 
 DI=DIALOG(TEXT$,1,CAPTION$)
 
 RET=FALSE
 IF DI==1 THEN RET=TRUE

 TEXT$=""

 IF RET==TRUE && STATE==G_BUTTON_NEW THEN
  FOR I=LC_EN TO LC_JA 
   TEXT$=TEXT$+G_BUTTON$[STATE,G_DIALOG_OTHER,I]
  NEXT
  DIALOG TEXT$,0,CAPTION$
 ENDIF

 IF RET==TRUE && STATE==G_BUTTON_PLAY && PLAYER[G_WHITE]==G_ENGINE && PLAYER[G_BLACK]==G_ENGINE THEN
  FOR I=LC_EN TO LC_JA 
   TEXT$=TEXT$+G_BUTTON$[STATE,G_DIALOG_OTHER,I]
  NEXT
  DIALOG TEXT$,0,CAPTION$
 ENDIF

 RETURN RET
END

'
'
'
DEF DIALOG_RESULT STATE
 VAR CAPTION$
 VAR TEXT$
 VAR I,J
 VAR DI
 VAR RET
 
 CAPTION$="Result"

 TEXT$=""
 FOR I=G_DIALOG_RESULT TO G_DIALOG_GAME 
  FOR J=LC_EN TO LC_JA 
  TEXT$=TEXT$+G_GAME_RESULT$[STATE,I,J]+CHR$(13)
  NEXT
  TEXT$=TEXT$+CHR$(13)
 NEXT

 DI=DIALOG(TEXT$,0,CAPTION$)
END

Y8Sɭ=Xge